c----------------------------------------------------------------------
c --- CALPUFF -- Non-steady-state Puff Model
c----------------------------------------------------------------------
c
c     Copyright (c) 1998-2013 by Exponent, Inc.
c
c --- CALPUFF    Version: 5.8.5          Level: 151214            MAIN
c
c --- CALPUFF MOD5 - Developed by:
c                    Joe Scire and David Strimaitis
c
c ---                e-mail: jss@src.com or jscire@alum.mit.edu
c
c----------------------------------------------------------------------
c --- Model Change Bulletin Updates Included:           MCB-A (040716)
c                                                       MCB-B (051216)
c                                                       MCB-C (060804)
c                                                       MCB-D (070623)
c                                                       MCB-E (080613)
c                                                       MCB-F (101025)
c                                                       MCB-H (151214)
c----------------------------------------------------------------------
c
c     Version 5.8.4, Level 130731 to Version 5.8.5 Level 151214
c     Associate with Model Change Bulletin H
c
c     1) Debug output of local species arrays (e.g., conc()) should
c     use explicit array index since entries after NSPEC are not
c     defined, which halts run if extended compiler checking is on.
c     No effect on results.
c     MODIFIED: CALCBC
c
c     2) Initialize error flag IERR in RDHDBC to zero (PC default)
c     No effect on results since run halts if IERR=1 is returned
c     from call to QCHECK, and otherwise proceeds
c     MODIFIED: RDHDBC
c
c     3) Fix bug in boundary-source puff sampling that added the
c     contribution of boundary-sources only when the last puff
c     sampled in a time-step was from a boundary-source
c     MODIFIED: COMP
c
c     4) Fix bug in computing PRIME downwash wake-modified primary
c     plume sigmas beyond tabulated range for receptors within
c     the distance range of the cavity.  There was an inconsistent
c     mix of travel time and virtual-source increment for this.
c     Sigmas for locations beyond the cavity are not affected.
c     NEW     : WAKE_CSIG
c     MODIFIED: WAKEDAT.PUF
c               POINTS1, POINTS2, WAKE_XSIG
c
c     5) Fix bug in setting the high and low limits on the range of
c     receptors that are within the range of influence of a SLUG
c     during a sampling step.  A typo in screening for the impact
c     zone about the youngest end of the slug at the end of the step
c     used its position at the start of the step with its spread at
c     the end of the step.
c     MODIFIED: SLGXLIM
c
c     6) Rename loop index in debug output that conflicted
c     with calling argument.  Could cause model to stop if debug
c     output is selected with more than 1 variable-emissions file
c     for point sources.  Contributed by Peter Rye.
c     MODIFIED: RDTIEM2
c
c     7) Add BID to sigmas for the PRIME case where plume does
c     not enter the wake (no wake table).  Plume growth is
c     calculated from the source rather than from the sigmas at the
c     end of the wake (read from the wake table, including BID),
c     so the BID due to rise must be added.  Before this fix the BID
c     sigmas were set to zero like the plumes that enter the wake,
c     and this can over-estimate concentrations.
c     Earlier CALPUFF versions did not include BID in the wake tables, 
c     so BID was always added in subsequent calculations including 
c     this case without a wake table.
c     MODIFIED: POINTS1, POINTS2
c
c     8) Add check for Gaussian vertical distribution before
c     calling RISEWIND to refine advection wind (may cause halt in
c     ADVECT subroutine)
c     MODIFIED: COMP


C     TRC Version 5.834, Level 090710 to Version 5.8.4, Level 130731
C     Associated with Model Change Bulletin F
C
c
c     1) Relax test for small negative travel in SIGTZ following the
c        approach used in SIGTY.  Small negative travel should be
c        interpreted as zero, but larger negative travel indicates a
c        potential problem and the code should halt as it does now.
c        Configuration for both SIGTY and SIGTZ:
c          0.00s >dt> -.01s    dt reset to zero (incident not reported)
c          -.01s >dt> -1.0s    dt reset to zero (incident counted)
c          -1.0s >dt           CALPUFF Halted with error message
c          0.00m >dx> -.01m    dx reset to zero (incident not reported)
c          -.01m >dx> -1.0m    dx reset to zero (incident counted)
c          -1.0m >dx           CALPUFF Halted with error message
c        Incidents counted are reported to the list file at the end of
c        the run with the most negative travel encountered.
c        (No impact on results)
c        Modified: WARN, SIGTZ, SIGTY, FIN
c     2) Align specific details of PRIME implementation with those used
c        in ISC-PRIME.
c     a. Computing sigmas in building wake:  Include BID in sigmas at
c        the entry to the wake (xi) and allow these enhanced sigmas to
c        grow within wake PDF region.  Tabulated sigmas for PRIME source
c        will now include the BID so that BID in the puff arrays must be
c        set to zero. Previous method grew sigmas in the wake without
c        BID, and tabulated sigmas from the source to the end of the
c        wake without BID.  Non-zero BID was then added whenever a sigma
c        was extracted from the table.
c     b. Compute receptor-specific sigmas downwind of the end of the
c        PRIME wake (e.g., beyond the end of the wake table) using time
c        or distance measured from this point rather than interpolating
c        sigmas via virtual time (distance) at the start and end of the
c        sampling step.  This assures that the sigmas are continuous in
c        this region.  This applies to puff steps that start within the
c        wake.  Subsequent steps interpolate the virtuals.
c     c. Align calculation of plume drdx in wake region with ISC-PRIME.
c        The drdx includes extra dilution in the wake and this is then
c        used in the numerical rise, so the resolution of tabulated
c        values can alter rise and mass captured in the cavity.
c        Implement by creating XWAKISC() and DRWAKISC() arrays.  Since
c        these are only used in NUMRISE for the current source, they
c        are not saved to the SRCTAB file.
c     d. Trap negative virtuals when computing source sigma that
c        grows to wake-modified sigma at end of wake, and set to zero
c     e. Use ISC-PRIME method of computing distances for numerical rise
c        and wake arrays.
c     f. Disable comparison of the wake-influenced sigma growth with the
c        current ambient sigma growth (taking the larger of the 2) when
c        filling the wake arrays (now conforms to the treatment used
c        in ISC-PRIME).
c     g. Remove approximate calculation of the BID-enhanced sigmas that
c        was used when the BID term is small compared to the sigma.
c        New:      WAKE_ADDBID
c        Modified: WAKEDAT.PUF
c                  NUMPR1, NUMRISE, WAKE_FIN, WAKE_XSIG, WAKE_DFSN,
c                  WAKE_DRDX, WAKE_FIN, WAKE_TAB, CAV_CONC, CAV_SAMP,
c                  POINTS1, POINTS2, PUFRECS, SETPUF, SETSLG
c     3) Fix error in cavity concentrations (factor-of-2 for reflection
c        was missing and impact from the end of the cavity to the end of
c        the cavity transition not included).
c        Modified: CAV_SAMP
c     4) Initialize wind speed shear factor to zero outside of the wake
c        when reporting results to list file.
c        (No impact on results)
c        Modified: WAKE_DBG
c     5) Update number of arguments in VCOUP call in CALCPF loop over
c        CTSG receptors and AREAINT and SLUGAVE calls in CALCSL loop
c        over CTSG receptors (new HLIDMAX added in v5.834).  These
c        bugs may affect results for CTSG receptors during calms.
c        Modified: CALCPF, CALCSL
c     6) Fix name of debug logical in calls to ASDF, ADVECT.
c        (No impact on results)
c        Modified: SLUGINT, FOGREC
c     7) Fix typo in BC file name variable FNAMEBC (not FNAMBC) in
c        call to QCHECK, and initialize I2DRHBC (not I2DRH)
c        (No impact on results)
c        Modified: RDHDBC, RDHDBC2
c     8) Declare temp string using full MXCOL dimension.
c        (No impact on results)
c        Modified: RDEMBC
c     9) Declare default potential temperature gradient as 1-D real
c        variable instead of implicit scalar.  The 1-D PTG enters via the
c        calling argument list, and is used in subroutine calls that
c        require a 1-D variable.
c        (No impact on results)
c        Modified: RDMET4, RDMET5
c    10) Rename station ID returned from FINDR and FINDI (used when
c        data are missing at nearest station) so that it does not
c        replace the station ID obtained from the NEARS array
c        Modified: EXMET
c    11) Met station coordinates assumed for single-station met
c        files should be set relative to the grid origin rather
c        than to the grid origin coordinates.
c        (No impact on results)
c        Modified: MET2, MET3, MET4
c    12) Roughness adjustment to PG sigmas is computed for 1 roughness
c        length used with non-gridded meteorological data, so restrict
c        MROUGH = 1 to METFM = 2, 3, 4, or 5.
c        Modified: QAINP
c    13) Change elev(i,j) to elevg(i,j) to write out gridded receptor
c        elevations.
c        (No impact on results)
c        Modified: QAPLOT1
c    14) Add idownw as a screen for debug writes so that unassigned
c        downwash variables are not written to list file
c        (No impact on results)
c        Modified:    POINTS1, POINTS2
c
c
c --- TRC Version 5.833, Level 090619 to Version 5.834, Level 090710
C     Associated with Model Change Bulletin F
c
c     1) Restrict deposition fluxes to receptors that are located ON
c        the ground (currently only discrete receptors may be elevated)
c        Modified: CALCBC, CALCPF, CALCSL
c     2) Add concentration calculations at elevated receptors that are
c        located above the mixing height when there is mass above.  The
c        impact at these receptors had been set to zero.
c        Modified: VCOUP, VCBAR, SLUGAVE, SLUGSNP, SLUGINT, LSSLINT,
c                  AREAINT, CPQROMB, CPTRAP, ROMBTIN, TRAPSL,
c                  CALCBC, CALCPF, CALCSL, COMP,
c                  PLMFOG, POINTS1, POINTS2, CAVCONC, CAV_SAMP
c     3) 1/Slug-length is not computed for young end of emitting slugs
c        because it is not defined.  But it is used in clipping logic,
c        so it should be the actual length which equals the result
c        computed for the older end.  Clipping at the release point
c        (young end of emitting slug) has no effect on results due
c        to other constraints.
c        Modified: SLGRECS
c
c --- TRC Version 5.832, Level 090612 to Version 5.833, Level 090619
C     Associated with Model Change Bulletin F
c
c     1) Trap case in which the shear adjustment to Briggs plume rise
c        is applied in near-calm conditions.  A distance to final
c        rise of zero (calm) can produce an incorrect shear-modified
c        rise that is zero.  Also increase the number of digits used
c        to write TSTAK and DTEMP to the list file (debug output).
c        Contributed by Brian Zelt
c        Modified: POINTS1, POINTS2
c
c --- TRC Version 5.831, Level 080520 to Version 5.832, Level 090612
C     Associated with Model Change Bulletin F
c
c     1) Assign power-law exponent to default value for met file types
c        that do not use power-law profiles so that exponent is
c        available for plume rise wind shear option
c        Modified: BLOCK DATA, POINTS1, POINTS2, AREAS1, AREAS2,
c                  LINES1, LINES2, VOLS, ADVECT, WINDSET, NUMMET,
c                  POWLAW, PRFINSH, PRSHEAR, SETLINE
c    (2) Updated CALUTILS from v2.56 Level 080407 to v2.57 Level 090202
c        Increase control file line length to 200 characters
c        Activate CPU clock using F95 system routine
c        Modified: PARAMS.CAL, READIN, DATETM
c    (3) Reset control-file line-length limit to 200
c        Modified: TFERCF
c    (4) Add call to SRCTABOUT to update the source number of the
c        current puff in the DA file when line-source slugs are
c        processed during the first step.  The source number given
c        to slugs generated from line segments 2+ has '1000' added to
c        it, and this '1000' is removed in the first model step.
c        The code stopped in the second timestep.  This only affects
c        buoyant line sources when modeled with slugs.
c        Modified: COMP
c    (5) Use local source-table arrays in the subroutine used to move
c        the puff index when inactive puffs are removed from DA file
c        of source-related tabulations.  The current contents in the
c        arrays had been overwritten before being used because the
c        /SRCTAB/ common had been included, and the roll-down process
c        happens after the tables are created.  This affects all
c        source types that use tabulated rise information whenever
c        inactive puffs are removed when generating puffs/slugs.
c        Roll-downs made when splitting puffs or when generating a
c        restart file do not overwrite arrays that are currently in use.
c        Modified: SWAPTAB
c    (6) Do not allow the receptor-specific sigmas for a line source
c        to be zero.  Add a check for sy0 and sz0 when puffs/slugs are
c        generated to assure that SYMIN and SZMIN are the smallest
c        values used.
c        Modified: LINES1, LINES2
c    (7) Add check for zero final rise from a buoyant line source when
c        computing receptor-specific sigmas for the case of an emitting
c        slug (attached to source).  The zero rise can result in a
c        divide-by-zero that halts the model.
c        Modified: RECSPEC0
c    (8) Screen for use of undefined variables --- none of these
c        updates alters concentrations
c        Modified: COMP                 (qratew, xlam)
c                  LINES1               (thalf,xhalfkm,syhalf,szhalf)
c
c --- TRC Version 5.83, Level 080110 to Version 5.831, Level 080520
C     Associated with Model Change Bulletin E
c
c     1) Updated CALUTILS from v2.55 Level 070327 to v2.56 Level 080407
c        Control file entries in exponential notation were not correct
c        if decimal point was missing (2e-02 was read as 0.2e-02).
c        Modified: ALTONU
c     2) Add puff-based storage of arrays related to plume rise
c        tabulations.  This is implemented via a direct access (DA)
c        file.  IMET logic to only use current met period table is
c        disabled by assigning IMET=1 (should be removed entirely).
c        New:      SRCTAB.PUF
c                  SWAPTAB, SRCTABIN, SRCTABOUT
c        Modified: PARAMS.PUF,
c                  PT1.PUF, PT2.PUF, AR2.PUF, LN1.PUF, LN2.PUF
c                  POINTS1, POINTS2, AREAS2, LINES1, LINES2,
c                  AREAS1, VOLS, BCS1,
c                  OPENOT, SWAP, COMP, GRISE, WAKE_TAB, RECSPEC0,
c                  RESTARTQ, RESTARTO, RESTARTI
c     3) Place call to PRSS into RISEWIND to treat Schulman-Scire
c        building downwash cases
c        Modified: RISEWIND
c     4) Fix QA test for MTILT restrictions on other model options
c        Modified: QAINP
c
c --- TRC Version 5.82, Level 071207 to Version 5.83, Level 080110
C     Associated with Model Change Bulletin E
c
c    (1) Refine mixing height adjustment of the top of the layer
c        containing a target height in PUFFDZ so that the layer-top
c        returned is always greater than the target height.
c        Add checks for a layer top less than a layer bottom to routines
c        that define or use layer interfaces to obtain mean winds.
c        Modified:  PUFFDZ, ADVECT
c    (2) Trap case of falling puff in the RISEWIND procedure because it
c        may lead to the 'bottom' of the layer exceeding the 'top' of
c        the layer used to obtain the mean advection during rise.
c        Modified:  RISEWIND
c    (3) RISEWIND samples winds across the current gradual rise path
c        via calls to GRISE.  However, GRISE does not include stack-tip
c        downwash and RISEWIND does not apply it either.  Add the tip
c        downwash adjustment to GRISE and remove the adjustment
c        elsewhere.
c        Modified:  GRISE, PUFRECS, SLGRECS, PLGRECS, ZTRACE
c
c --- TRC Version 5.81, Level 070801 to Version 5.82, Level 071207
C     Associated with Model Change Bulletin E
C
c    (1) When performing cavity sampling for PRIME downwash, restrict
c        primary source calculations to receptors downwind of primary
c        source and add screen for receptors located far to the side
c        (no impact).  Without this restriction, the model may halt with
c        an attempted division by zero.  Receptors upwind of the source
c        are processed for cavity impacts starting with Version 5.8,
c        Level 070623.  Remove unused CAV_SRC.
c        Modified:  CAV_SAMP
c    (2) Fix bug in wet flux calculation for sampling puffs (not slugs).
c        The horizontal sampling factors were calculated only if puff
c        mass diffused to the surface producing non-zero concentrations.
c        These factors are needed for the wet fluxes due to elevated
c        puffs as well.  Wet removal mass depletion calculations are
c        correct, as are wet fluxes at receptors with non-zero
c        concentration.
c        Modified:  CALCPF
c    (3) Add check for ATAN2(0.0,0.0) in FOGREC, as function will halt
c        execution if both arguments are zero.  This behavior changed
c        between F77 and F95 compilations.
c        Modified:  FOGREC
c    (4) Add source tabulations stored for previous met periods, and
c        introduce dataset name and version record, to RESTART file.
c        This currently applies only to line sources, which use rise
c        tables for the current and previous met periods (MXMETSAV=2).
c        Without the table for the previous met period in a restart
c        file, table values starting as zero may be accessed and
c        halt the run with a divide-by-zero.
c        Enforce MXMETSAV=2 as LN1 and LN2 arrays are explicitly
c        dimensioned to 2, and add checks for the met period pointer
c        to trap IMET<1 (should never happen).
c        New:       RESTARTHD.PUF
c        Modified:  RESTARTQ, RESTARTI, RESTARTO
c                   INITPUF, COMP, SETPUF, PUFRECS, GRISE
c    (5) Fix several undefined variables that do not affect results:
c        - PROBLEM variable initialized to false in LN2FILL
c        - Calm logical is not set in call to VCBAR from DRY, so
c          a frozen puff treatment for dry depletion in calms is
c          never triggered.  This would have made a single calculation
c          of the vertical distribution at the middle of the step in
c          place of 3 calculations during a step.  Logical is explicitly
c          set to false to ensure current 3-step calculation is always
c          done.
c        - Initialize ISTA=ILQ=IPRECIP=0 in WET for debug output
c          (they may not be computed)
c        - Change J to I in debug output in VOLS, AREAS1/2
c        - Initialize INDEX=0 in POINTS1/2 for debug output
c        - Initialize DUMMY=0.0 in RDTIEM3
c        Modified:  LN2FILL, RDTIEM3
c                   DRY, VCBAR, WET,
c                   VOLS, POINTS1/2, AREAS1/2
c    (6) COORDLIB from v1.98 Level 060911 to v1.99 Level 070921
c        - Conversion of point in S. hemisphere to UTM-N returned coord.
c          as UTM-S instead, for conversions from all map projections
c          except lat/lon.
c        - Initialization of a few work arrays were missing.  These have
c          no effect on results.
c         Modified:  COORDS, PJINIT
c
c --- TRC Version 5.8, Level 070623 to Version 5.81, Level 070801
C     Associated with Model Change Bulletin E
c
c    (1) Add cap on sigma-z to avoid a floating-point error when
c        computing virtuals.  Default cap is 5e06 m (5000km), which is
c        expected to have no influence on normal concentrations.
c        Modified:  COMPARM.PUF
c                   BLOCK DATA, READCF, COMP
c    (2) Relax requirement that the input restart file be from the same
c        version and level of the code to a WARNING.
c        Modified:  RESTARTQ
c
c --- Version 5.760, Level 070605 to Version 5.8, Level 070623
c
c    (1) Add (MREG) regulatory constraint that overwater and over land
c        minimum sigma-v values must be 0.5 m/s
c        Modified:  QAINP
c    (2) Always write the control file variables to the list file to
c        confirm values used
c        Modified:  READCF
c
c --- Version 5.756, Level 060725 to Version 5.760, Level 070605
c
c    (1) Address problem in PRIME downwash when a cavity source puff
c        reaches a "calm" zone in the wake region.  Downwash algorithms
c        were turned off once such a puff was sampled at a receptor.
c        This should be done as soon as such a puff is advected into a
c        calm region so that the puff growth and trajectory remain
c        independent of the sampling receptors.  Move the re-assignment
c        from PUFRECS/SLGRECS to SETPUF/SETSLG.
c        Modified:  SETPUF, SETSLG, PUFRECS, SLGRECS
c    (2) Pass CALM processing result (LCALM) from SETPUF/SETSLG for use
c        later in calls to PUFRECS/SLGRECS.  Previously determined CALM
c        setting was made at the start of a sampling sub-step and may
c        not be current.
c        Modified:  COMP, SETPUF, SETSLG
c    (3) Puff virtual times at the time of release obtained for
c        PRIME downwash during very strong wind speed shear in the
c        vertical can lead to much larger or much smaller sigmas than
c        those tabulated within the wake zone, if time-based disperision
c        rates are selected.  Although the tabulated PRIME sigmas are
c        used for concentrations at receptors in the wake zone, the
c        lateral sampling screen uses the virtual-time sigmas.  This can
c        lead to screening out receptors in the wake zone that should be
c        sampled.  Assign sigmas to the puff in the wake zone from the
c        PRIME sigma tables, and compute the corresponding virtual times.
c        Modified:  SETPUF
c    (4) Initialize the following variables (results are not affected
c        but execution may halt with some compilers)
c          IGRDVL = 0  (READCF)
c          HB, HW, HEFF2, ZLY, RINIT = 0. (POINTS1, POINTS2)
c          YKDUM, SYDUM, ZKDUM, SZDUM = 0.0 (WAKE_DFSN)
c          DBDUW = 0.0  (WAKE_DBG)
c          XMAX, FZMAX = 0.0 (WAKE_FQC)
c          DZDS=0.0 (NUMRISE)
c        Modified:  READCF, POINTS1, POINTS2, WAKE_DFSN, WAKE_DBG,
c                   WAKE_FQC, NUMRISE
c    (5) Assign PTGRAD value to default so it is always available for
c        debug output even when not used (does not change results)
c        Modified:  NUMMET
c    (6) Typo in argument IRU (0=rural, 1=urban) in call to WAKE_INI
c        results in rural dispersion curves in PRIME calculations when
c        making the wake-zone sigma tables (PG dispersion option) if
c        the compiler initializes variables to zero.  Without such
c        initialization, run may halt with invalid IRU value.
c        Modified:  POINTS1, POINTS2
c    (7) Local receptor height ZRC for PRIME cavity-source impact was
c        not set in the wake downwind of the cavity.  Applications that
c        place receptors on the ground are not affected because ZRC is
c        always zero.  (ZRC is set to zero for receptors in the cavity,
c        and it is set to the receptor elevation above the top of the
c        cavity for any receptors placed above a cavity.)  Initialize
c        ZRC to the actual receptor height above the ground.
c        Modified:  CAV_SAMP
c    (8) Cavity concentrations were not computed at receptors in cavity
c        if they were upwind of the source.  Logic updated to account
c        for mass recirculating in cavity.
c        Modified:  CAV_CONC
c    (9) PRIME cavity concentrations are calculated but not reported due
c        to array initializations introduced for the source contribution
c        option in V5.72.  The cavity concentrations are now placed in
c        the TOTAL concentration arrays which are not zeroed in the
c        source loop, and the source contribution output option is not
c        allowed with the PRIME downwash option.
c        Modified:  QAINP, COMP, CAV_CONC
c   (10) CALUTILS from v2.53 Level 060626 to v2.55 Level 070327
c        Allow negative increments in INCRS
c        Fixed format bug in subroutine BASRUTC for the case of time
c        zone zero (output string was 'UTC+0  0' instead of 'UTC+0000'
c        Modified:  INCRS, UTCBASR, BASRUTC
c   (11) COORDLIB from v1.97 Level 060626 to v1.98 Level 060911
c        Changes in COORDS that allow a higher level of FORTRAN error
c        checking.  Compiler checks had identified constant arguments
c        and 2 uninitialized variables.  None of these is known to have
c        produced errors in cooerdinate conversions.
c        Modified:  COORDS
c
c --- Version 5.755, Level 060626 to Version 5.756, Level 060725
c
c    (1) Ozone.dat dataset version 2.1 header is processed for LCC map
c        projection, but not others.  Program stops when attempting to
c        process the reference lat/lon and matching lats which are not
c        read for UTM map projection.
c        Modified:  RDHDOZ2
c    (2) Fix PTLAPS case where upper height of layer for extracting
c        the potential temperature gradient exceeds the middle of the
c        top layer of the model (search index was not assigned in this
c        case which leads to an invalid array index)
c        Contributed by:  Bart Brashers, Geomatrix Consultants
c        Modified:  PTLAPS
c
c --- Version 5.754, Level 060202 to Version 5.755, Level 060626
c
c    (1) CALUTILS from v2.2 Level 030528 to v2.53 Level 060626
c        Process long filenames with embedded blanks
c        Misc. subroutines to support 'Version 6' constructs
c        Added:     TLEFT, TRIGHT
c        Added(V6): INCRS, MIDNITE, BASRUTC, UTCBASR
c        Modified:  READIN, FILCASE, COMLINE
c        Removed:   GLOBE1
c    (2) COORDLIB from v1.95 Level 050126 to v1.97 Level 060626
c        Add Albers Conical Equal Area projection
c        Add GLOBE1 (from CALUTILS)
c    (3) Filnames changed from c*70 to c*132 (for CALUTILS V2.3
c        and later)
c        Modified:  FILNAM.PUF
c                   READFN, WRFILES, OPENAB
c    (4) Changed LDBG to .FALSE. to remove debug output to list file
c        when SLUG option is used
c        Modified:  RECSPEC0
c
c --- Version 5.753, Level 051130 to Version 5.754, Level 060202
c
c    (1) Correct bugs in QAINP that did not properly identify the EPA
c        guidance selections when checking user inputs:
c         -- Allow either CALMET or ISCMET (METFM=1,2)
c         -- Allow either MESOPUFF II of RIVAD chemistry (MCHEM=1,3)
c         -- Allow either PG or turbulence-based dispersion (MDISP=2,3)
c         -- Require PDF option with turbulence-based dispersion
c        Modified: QAINP
c
c --- Version 5.752, Level 051108 to Version 5.753, Level 051130
c
c    (1) Accept Dataset Version 2.1 OZONE.DAT file with coordinate and
c        time zone documentation, and begin/end times resolved to
c        seconds, but demand that the seconds in the time fields be
c        zero (e.g. hourly data).
c        No time zone shifts are made.
c        Modified: CHEMDAT.PUF
c                  COMP, CHEMI, RDOZ
c        New:      RDHDOZ2, RDTIOZ2
c
c    (2) Add QA plot output files for OZONE and H2O2 stations
c        Modified: QAPLOT1
c
c --- Version 5.751, Level 050805 to Version 5.752, Level 051108
c
c    (1) Screen call to TIBLGRO using heat flux at start of step, as
c        calculated from u-star and M-O length, to conform to what is
c        done within TIBLGRO.  The heat flux had been computed for the
c        mid-point of the step, which can lead to a run-time error.
c        Test for small/negative heat flux during step in TIBLGRO.
c        Modified: COMP, TIBLGRO
c
c    (2) Bug fix: compute XLAM as the scavenging RATIO in WET rather
c        than the scavenging COEFFICIENT.  XLAM is used in the SLUG
c        sampling routine for wet deposition fluxes.  This bug results
c        in wet fluxes that are based on the reference precipitation
c        rate of 1 mm/hr.  Concentrations and dry fluxes are correct.
c        This bug does not affect puff sampling.
c        Modified: WET
c
c    (3) Add minimum Sigma-v and Sigma-w inputs for overwater cells as
c        distinct from the inputs for overland cells
c        Modified: COMPARM.PUF
c                  BLOCK DATA, READCF, QAINP, COMP, RLSMET, TURBSET
c
c --- Version 5.75, Level 050225 to Version 5.751, Level 050805
c
c    (1) Add check in trajectory/coastline intercept (onshore flow)
c        calculation for parallel lines (equal slope).  The vector
c        cross-product (previous check) should be zero when the slopes
c        are equal, but precision can lead to a slightly positive
c        cross-product.  Identical slopes produces divide-by-zero.
c        Modified: TIBLON
c
c    (2) Place water cell mixing height (not ht0) into TIBL array
c        locations upwind of the coast, and use land cell pointer in
c        call to TIBLGRO so that shore properties are consistent with
c        coastline as puff crosses coast
c        Modified: TIBLGRO, TIBLON, COMP
c
c    (3) Add turbulence advection option for including advection
c        effects with decay to modify the local sigma-v and sigma-w
c        for puff growth (MDISP=2) --- Draft implementation for
c        testing
c        Modified: FLAGS.PUF
c                  TURBSET, COMP, RLSMET, READCF, BLOCK DATA
c
c --- Version 5.741, Level 040913 to Version 5.75, Level 050225
c
c    (1) Add building downwash adjustment for elevated (platform)
c        structures with an open area between the surface and the bulk
c        of the structures.  Currently implemented for ISC downwash
c        method (MBDW = 1).
c        Modified: PT1.PUF, PT2.PUF
c                  BLOCK DATA, SETUP, READCF, QAINP, RDTIEM2, COMP
c                  POINTS1, POINTS2, DWSIGS, PUFRECS, SLGRECS, PLGRECS
c
c    (2) Add option for computing turbulence profiles using the AERMOD
c        subroutines.
c        Modified: FLAGS.PUF
c                  BLOCK DATA, READCF, QAINP, TURBSET, COMP, RLSMET
c        New:      AERSWV
c        AERMOD:   REFSV, REFSVC, REFSVM, REFWV, REFSWC, REFSWM, GINTRP
c
c    (3) Add Lagrangian timescale option for lateral growth when
c        dispersion options MDISP=1,2 or MDISP2=1,2 are used.
c        1/Fy = 1 + 0.9 SQRT(t/1.62T)
c        [DIAGNOSTIC FEATURE]
c        Option choices are:
c          - Draxler default 617.284 (s)
c          - Computed as Length Scale / (.75 q) -- after SCIPUFF
c          - Direct user input (s)
c        Modified: FLAGS.PUF
c                  BLOCK DATA, READCF, QAINP, SETCSIG, COMP
c                  PUFRECS, SLGRECS, PLGRECS, SETPUF, SETSLG
c                  CALCPF, CALCSL, PLMFOG
c                  POINTS1, POINTS2, LINES1, LINES2
c        New:      TAULY (called from SETCSIG)
c
c
c    (4) Change the control parameter MGRAV to MTILT, and augment the
c        "tilted plume" calulations by:
c        - increasing the ratio of sigma-z to zmix at which the
c          well-mixed puff flag is set (subr. VMASS)
c
c  Additional modifications implemented in Version 5.75, Level 050225
c                    from Version 5.722, Level 040610
c                    to   Version 5.727, Level 050309
c
c
c    (1) Drop the requirement that the UTM zone in the OZONE.DAT file
c        matches the UTM zone in the CALPUFF control file when the UTM
c        projection is NOT used.  Instead, require that the zone be
c        zero in the header of OZONE.DAT (when present).
c        Modified: CHEMI
c
c    (2) Replace restriction that Boundary Condition (BC) segments must
c        match the computational grid cell size with a warning that
c        they do not match, and allow the BC segments to be larger than
c        the grid cell size (but not smaller).
c        Modified: RDHDBC
c
c    (3) Fix bug in GRISE associated with the rise factor for the PRIME
c        module.  The rise factor used to adjust the buoyancy-induced
c        dispersion from that at final rise to that at a gradual rise
c        height should exclude streamline deflections induced by the
c        building.  The gradual rise (without streamline deflection) was
c        divided by the final rise (with streamline deflection).  This
c        may cause any buoyancy-induced dispersion to be overestimated
c        in the gradual rise region, when using the PRIME option,
c        leading to larger puff sigmas.  Receptors located beyond the
c        distance to final rise are not affected.
c        Modified: GRISE
c
c    (4) Fix bug in PUFRECS that did not update the rise factor when the
c        PRIME wake tables are used to obtain receptor-specific sigmas.
c        The rise factor is used after the PUFRECS call to adjust
c        the sigmas for the PDF option.  This may cause a runtime
c        error that halts an application.  Concentrations are affected
c        at receptors withing a building wake during daytime periods
c        only if both the PRIME and PDF options are used.
c        Modified: PUFRECS
c
c    (5) COORDLIB updated to stop UTM conversions with a DATUM that is
c        not mapped to the list in the USGS UTM subroutine.  An example
c        is the sphere datum NWS-84 (Earth radius 6370km), since only
c        the sphere datum ESR-S (Earth radius 6371km) is available.
c        Unmapped datums had defaulted to the Clarke 1866 spheroid.
c        LAZA Projection:  removed assignment of 6370 km earth
c        radius (NWS-84 datum) when a value less than 6000 km is
c        found.  This assignment can override a requested radius
c        of 6371 (ESR-S datum) if the NWS-84 datum is used with
c        any valid projection prior to the request for ESR-S.
c        LAZA(NWS-84) coordinate distances from the projection
c        origin are about 0.016% smaller than LAZA(ESR-S).
c        Error message and version strings added to COORDS calls
c        and new subroutine COORDSVER to report COORDS version
c        documentation.
c        (Version 1.95, Level 050126)
c        COORDLIB updated to fix UTM conversion in the S.
c        hemisphere when the ouput UTM zone is forced as N.
c        hemisphere, and the DATUM changes (completes changes
c        started in version 1.93).
c        (Version: 1.94, Level: 041007)
c
c    (6) Added call to COORDSVER to access the COORDS version info and
c        passed string to list file and comment section of output files.
c        Modified: READCF, WROUT1
c
c    (7) LUSE.CLR color scale file modified to better distinguish
c        wetlands, and a RED strip is added at the top of the bar for
c        a marker LU of 99.
c        Modified: QAPLOT1
c
c    (8) Added new files TK2D.DAT and RHO2D.DAT along with the output
c        control variables IT2D and IRHO respectively.  This complements
c        the VISB.DAT output file of 2D Relative Humidity
c        fields with the corresponding 2D Temperature and Density fields
c        written in the same file format.
c        Modified: FILNAM.PUF, OUTPT.PUF
c                  BLOCK DATA, READFN, READCF, WRFILES, OPENOT,
c                  WROUT1, OUTPUT
c
c    (9) Fix number of arguments in call to LN2FILL from RDEMSRC.  The
c        last argument PROBLEM had been omitted.
c        Modified: RDEMSRC
c
c   (10) Initialize first element of MXNW numerical rise arrays to stack
c        conditions to avoid problems with an old NN index being used.
c        This could affect buoyant area sources and point sources with
c        the PRIME downwash option when these sources are non-buoyant
c        and are given very small (but non-zero) exit velocity.
c        Modified: NUMRISE
c
c   (11) Add test for a zero lofting rise in PDFPATH to avoid potential
c        attempt to divide by zero.
c        Modified: PDFPATH
c
c   (12) Change the GRD file format for SURFER Image files (QALUSE.GRD)
c        This applies to GRD files that are plotted as image maps (not
c        contours) -- Landuse.  SURFER 7 required a range
c        adjustment to properly register the grid cell blocks that
c        make up the image.  SURFER 8 registers cells properly without
c        the adjustment, so the standard GRD works for both image and
c        contour maps.  The revised output follows the SURFER 8
c        convention in which all GRD files are alike.
c        (We presume that the SURFER 7 format will seldom be needed.)
c        Modified: QAPLOT1
c
c   (13) Enlarge output format for the QATERR.DAT plot-file to allow
c        terrain heights below sea level (subroutine QAPLOT1).
c
c --- Version 5.74, Level 040715 to Version 5.741, Level 040913
c
c    (1) Fix bug in XERFDIF that produced an error in integral F1.
c        The F1 integral in the analytic sampling done for attached
c        slugs is not coded correctly.  F1 is used only for slugs as
c        they are being emitted (youngest end is at the source), and
c        is multiplied by the change in effective emission rate during
c        the sampling step (due to chemical transformation or
c        deposition removal).
c
c    (2) Add stop in QAINP if DATUM in control file is UNKNOWN
c
c    (3) COORDLIB updated to respond to UTM conversion across the
c        equator from S. hemisphere to N. hemisphere, when the S.
c        hemisphere zone is forced.  Also fixed a problem with the
c        conversion to/from spherical NWS-84 datum when using UTM
c        projection (USGS program input array conflicts).
c        (Version: 1.93, Level: 040713)
c
c    (4) Add puff-age cutoff control MXAGEHR (hours) in Group 12.
c        Puffs older than MXAGEHR (>0) are de-activated.
c        Feature typically NOT appropriate for Regulatory applications!
c        Modified COMPARM.PUF
c                 BLOCK DATA, READCF, QAINP, COMP
c
c    (5) Change the control parameter MGRAV to MTILT, and augment the
c        "tilted plume" calulations by:
c        - increasing the ratio of sigma-z to zmix at which the
c          well-mixed puff flag is set (subr. VMASS)
c
c --- Version 5.73, Level 040611 to Version 5.74, Level 040715
c
c    (1) Add AERMET version of SURFACE and PROFILE met data files
c        Modified FLAGS.PUF, GEN.PUF
c                 BlockData, READCF, QAINP, COMP, ADVECT, WINDSET,
c                 POINTS1, POINTS2, LINES1, LINES2, AREAS2, NUMPR1,
c                 NUMMET, WRFILES, SETUP, OPENOT, PTLAPS
c        New      RDMET5, RDPROF5
c
c
c --- Version 5.722, Level 040610 to Version 5.73, Level 040611
c
c    (1) Add gravitational settling (plume-tilt) option to allow
c        puffs with 1 particle species to fall at the gravitational
c        settling velocity for that species.  Restrictions:
c        - MGRAV = 1  Turns option on (new variable)
c        - NSPEC = 1  (must be particle species as well)
c        - sg    = 0  GEOMETRIC STANDARD DEVIATION in Group 8 is
c                     set to zero to make single particle diameter
c        - MCTADJ= 0,1,3  (Interaction with option 2 not supported)
c        Modified FLAGS.PUF, CURRENT.PUF
c                 BLOCK DATA, READCF, QAINP, VCBAR
c                 SETPUF, PUFRECS, SETSLG, SLGRECS, RECSPEC0
c
c    (2) Change number of particle sizes name from NINT to NPSINT to
c        avoid overlap with function NINT.
c        Modified DRYPART.PUF, BLOCK DATA, READCF,
c                 DRYI, VDP, VDP1, VDCOMP
c
c --- Version 5.721, Level 040503 to Version 5.722, Level 040610
c
c    (1) Fix array assignments in RESTART subroutines by using the
c        /puff/ and /slug/ include files.  Restart option
c        did not work in V5.72+ (QA stopped run).
c
c --- Version 5.72, Level 031017 to Version 5.721, Level 040503
c
c    (1) VERY small negative virtual time/distance is reset to ZERO
c        in SIGTY and SIGTZ (PRIME module)
c
c    (2) Added list-file report of largest (most) negative
c        increments encountered in SIGTY.  New routine WARN added.
c        Modified SIGTY, FIN
c
c    (3) COORDLIB updated to respond to projection parameter
c        changes when both the projection type and datum do not change
c        (Version: 1.92, Level: 031201)
c
c    (4) Fix array declaration in CALCSL:  species mass array for wet
c        deposition declared using mxspec (had been declared nspec).
c        This bug causes erroneous wet fluxes to be output from
c        slug sampling.  Total mass of each species in slugs is not
c        affected.
c
c    (5) File unit passed to subroutine YR4 for listfile output was
c        not defined so that error reports attempted to write to
c        unit 0.  Changed io1 to io6 in call to YR4 from subroutines
c        RDHDBC2 and GETRCRD.
c
c    (6) Function XVZ altered to improve single precision accuracy
c        of solution for stability classes A and B
c        (NOT connected, revision is called XVZ2)
c
c --- Version 5.713, Level 030905 to Version 5.72, Level 031017
c
c    (1) Fix QA output file for gridded receptors (QARECG.DAT)
c        [incorrect terrain elevations reported]
c        and add control file switch to disable QAPLOT feature
c          - CALPUFF.INP, OUTPT.PUF, BLOCK DATA, READCF, SETUP
c
c    (2) Replace the puff ID (ppptssss) with individual integer arrays
c        to allow for more puffs/source and more sources: IRLSNUM,
c        ISRCNUM, and ISRCTYP repace IPUFID.
c          - PUFF.PUF, COMP, SWAP, RESTARTI, RESTARTO, SPLIT,
c            POINTS1, POINTS2, AREAS1, AREAS2, VOLS,
c            LINES1, LINES2, BCS1, ZTRACE
c
c    (3) Add source contribution output feature.  Output data file
c        format is revised (version 2.1).
c          - CALPUFF.INP, FLAGS.PUF, PARAMS.PUF, CHIFLX.PUF,
c            PT1.PUF, AR1.PUF, LN1.PUF, VOL1.PUF
c          - BLOCK DATA, READCF, QAINP, SETUP, COMP, OPENOT,
c            OUTPUT, WROUT1
c          - RDEMSRC, TCHIFLX
c
c    (4) Change control file source names from character*12 to
c        character*16 to match string length used in variable emission
c        files.
c
c    (5) WGS-72 DATUM bug for UTM calls fixed in COORDLIB
c        (Version: 1.91, Level: 031017)
c
c --- Version 5.712, Level 030822 to Version 5.713, Level 030905
c
c    (1) DATUMs updated in COORDLIB (Version: 1.9, Level: 030905)
c    (2) Default DATUMs reset
c
c --- Version 5.711, Level 030625 to Version 5.712, Level 030822
c
c    (1) Address PRIME module bug that produced a negative virtual
c        travel time increment due to numerical precision (seen when
c        using turbulence-based sigma option with PRIME downwash)
c        Modified:  WAKE_DFSN
c
c --- Version 5.71, Level 030528 to Version 5.711, Level 030625
c
c    (1) Address TIBL module bug that left cell index (i,j) undefined
c        Modified:  TIBLGRO
c
c --- Version 5.7, Level 030402 to Version 5.71, Level 030528
c
c    (1) Assign inputs for LCC projection to internal variables used
c        in QA checks
c
c    (2) Remove old UTM zone check in METQA that does not screen out
c        PMAP.NE.UTM cases
c
c    (3) Add MBCON=2 option to read a CONC.DAT file from another
c        CALPUFF run and use receptor concentrations as boundary
c        condition
c        New:       HEADBC2.PUF
c                   RDHDBC2, BC2DOC, RDEMBC2, GETRCRD, UNCOMPRS
c        Modified:  BCS.PUF, FLAGS.PUF
c                   SETUP, OPENOT, RDHDBC, INITPUF
c
c    (4) Fix xmesh,ymesh definition for computing MBCON=1 segment
c        grid coordinates (mesh becomes 1/mesh)
c
c    (5) Add Input Group 12 variables for MBCON option to configure
c        the BC puff depth, the search radius for identifying BC
c        impacts, and a switch to control the near-surface depletion
c        adjustment for the BC puffs.
c        Modified:  BCS.PUF
c                   READCF, BLOCK DATA, BCS1, CALCBC, COMP,
c                   RDHDBC, RDHDBC2
c
c    (6) Add QA checks for MBCON configuration and write QA ALERT
c        notice to screen (QAINP); require that species 'BCON' be
c        modeled when MBCON > 0.  Boundary puffs will be emitted
c        with non-zero mass of BCON to model clean air the same way
c        as polluted air.
c
c    (7) Update COORDLIB (Version: 1.15  Level: 030528)
c        Update CALUTILS (Version: 2.2  Level: 030528)
c
c    (8) Modify use of MAX function in WAKE_FQC and args of MIN in
c        NUMRISE to conform to compiler type rules
c
c    (9) Trap zero bldg length with MBDW=2 (PRIME) in READCF
c
c   (10) Require non-negative emissions in READCF, INITPUF, LN2FIL
c
c   (11) Add RESTART notice to list file each time a restart file
c        is rewritten (RESTARTO)
c
c --- Version 5.5, Level 010730_1 to Version 5.7, Level 030402
c
c    (1) Accommodate the CALMET no-observation mode,
c        [Originally denoted as Ver 5.5  Level 010901]  (FRR)
c        Changes to:
c        - COMP, RDMET, EXMET, SUNDATA, GETPRFM, WET
c          AREAS1, VOLS, POINTS1, POINTS2, LINES1, NUMMET, TIBLON
c          TIBLGRO, BCS1, FOGOUT, OUTPUT, WROUT1
c        - METHD (new i2dmet) and METHR (2D arrays)
c        - New subroutine METLATLON: computes latitude and longitude
c          of all CALMET gridpoints
c
c    (2) Updated on 03/31/02  to fix bug in WRDAT
c
c    (3) Added i2dmet in header record for all types of output,
c        subroutine WROUT1.
c        [Originally denoted as Ver 5.5  Level 021028]  (FRR)
c
c    (4) Bug fix in RDMET (ipcode2d data was not read when npsta=-1)
c        [Originally denoted as Ver 5.5  Level 030119]  (FRR)
c
c    (5) Accept revised CALMET.DAT 2.0 header format
c
c    (6) Implement CALUTILS packaging (Version: 2.1  Level: 030402)
c
c    (7) Implement the full map projection/datum transformation
c        routines using COORDLIB (Version: 1.14  Level: 030402)
c
c    (8) Move Y2K processing of system date into subroutine DATETM
c        and change rdate from (MM-DD-YY) to (MM-DD-YYYY)
c
c    (9) Change UNDER0 call to generic UNDRFLW, and place compiler-
c        specific implementation routines there
c
c   (10) Alter format of QA plot-file header for SURFER 'bug'
c
c   (11) Screen output from VCOUP with sigma_z ~ '0'
c
c   (12) Dataset version 2.0 header format implemented for output
c        data files with control file images, and /MAP/ variables
c
c   (13) Replace OPENAB with explicit ASCII/BINARY option
c        (Set to ASCII for now --- PTEMARB and VOLEMARB only!)
c
c   (14) Add PRIME downwash modules.
c        Modified: NUMPARM.PUF, PT1.PUF, PT2.PUF, FLAGS.PUF, COMPARM.PUF
c                  BLOCK DATA, SETUP, READCF, RDTIEM2, NUMMET, NUMRISE,
c                  POINTS1, POINTS2, GRISE, PUFRECS, SETPUF,
c                  COMP, CALCPF, PLMFOG
c        New:      WAKEDFSN.PUF, WAKEDAT.PUF,
c                  WAKE_CAV0, WAKE_DBG, WAKE_DFSN, WAKE_DIM, WAKE_DRDX,
c                  WAKE_FQC, WAKE_FIN, WAKE_INI, WAKE_SCALES,WAKE-SIGA,
c                  WAKE_SIG, WAKE_TURB, WAKE_U, WAKE_XA, WAKE_XSIG,
c                  CAVITY_HT, CAV_SRC, CAV_CONC CAV_SAMP, FRGAUSS,
c                  NUMGRAD, POSITION, ZSTREAM, INTERTAB, WAKE_TAB
c
c   (15) Add IMET and MXMETSAV to manage source tabulations such as
c        plume rise that are saved over multiple met periods
c        (current.puf, params.puf)
c
c   (16) Set the time to Heffter transition (sigma-y) within SETCSIG
c
c   (17) Revise lower threshold for computing a virtual time/distance
c        from szmin,symin to 0.001m in SIGTY and SIGTZ
c
c   (18) Revise default plume rise-angle criterion for wake effects
c        from 45 degrees to 20 degrees
c
c
c --- Version 5.5, Level 010730 to Version 5.5, Level 010730_1
c
c    (1) Remove conditioning of initial sigmas for control file
c        point sources so that a zero is not reset to symin or
c        szmin (READCF)
c
c --- Version 5.4, Level 000602_8 to Version 5.5, Level 010730
c
c    (1) Add IWAT2 to list file output in subr. MET1.
c
c    (2) Revise treatment of sigmas at receptors in the building
c        downwash zone of point sources to properly account for
c        initial sigmas at the source.  The changes made in Version 5.4,
c        Level 000602_2, introduced a sigma that already contained the
c        downwash contribution, resulting in overprediction of the
c        sigmas in the wake (which will typically increase ground-level
c        concentrations in the wake).
c
c    (3) Revise wind-direction-specific building information selection
c        to match that used in ISCST3 (treatment of directions that lie
c        on sector boundaries.)
c
c --- Version 5.4, Level 000602_7 to Version 5.4, Level 000602_8
c
c    (1) Fix declaration of character*16 variables in /AR2/, /PT2/,
c        and /VOL2/ ('include' files -- no change to CALPUFF.FOR).
c
c    (2) Add constraint that buoyancy flux (FLUXB) be greater than zero
c        to conditions that must be met for calling partial penetration
c        subroutine (PRFPP) in subroutine POINTS2, which processes the
c        PTEMARB source data file.  This condition was already used
c        in subroutine POINTS1 (control file source data).  A run-time
c        divide-by-zero error stops CALPUFF if PRFPP is called with
c        FLUXB=0.0 (emission temperature LE ambient temperature).
c
c --- Version 5.4, Level 000602_6 to Version 5.4, Level 000602_7
c
c    (1) Fix call to READIN in subr. RDVD to allow for more than 5
c        species with user-specified deposition velocities.
c
c --- Version 5.4, Level 000602_5 to Version 5.4, Level 000602_6
c
c    (1) Fix call to RDEM3 (data records for BAEMARB.DAT files) to use
c        the file unit number 'io' instead of 'io17', which was removed
c        in CALPUFF 5.4, Level 000602.  File unit io17 (which is zero
c        because it is not defined) is not open so the call to RDEM3
c        generates a runtime error which halts the run.  This affects
c        previous CALPUFF versions starting with version 5.4.
c
c    (2) Change name of LCC longitude stored in /PT2/, /AR2/, /LN2/,
c        and /VOL2/ from '-ELON-' to '-WLON-' to match variable
c        returned from XTRACTLL (variables are not currently used).
c
c --- Version 5.4, Level 000602_4 to Version 5.4, Level 000602_5
c
c    (1) Add new 'qaplot' files to facilitate making maps of layout
c        [qaplot1, setup]
c
c    (2) Initialize QAFAIL before MREG if-block in qainp
c
c --- Version 5.4, Level 000602_3 to Version 5.4, Level 000602_4
c
c    (1) Remove XLAT,XLONG,XTZ variables from Input Group 4 of control
c        file, and place XBTZ into Input Group 1 [changes to METHD.PUF,
c        DATEHR.PUF, GRID.PUF, block data, readcf, qainp, met1, metqa,
c        sundata]
c
c    (2) Fix ZFRISE assignment before call to RISEWIND and in ZTRACE.
c        The height at final rise was used instead of the rise at
c        final rise.  This has no apparent effect on computations
c        made in these subroutines.
c
c    (3) Screen hourly data in ISC met file for invalid entries [rdisc,
c        qahrisc]
c
c    (4) Add monthly background O3, NH3, and H2O2 arrays
c        [CHEMDAT.PUF, block data, comp, readcf, qainp, chembk]
c
c --- Version 5.4, Level 000602_2 to Version 5.4, Level 000602_3
c
c    (1) Add aqueous phase chemistry option (not enabled)
c
c --- Version 5.4, Level 000602_1 to Version 5.4, Level 000602_2
c
c    (1) Revise MFOG=1 (Plume Mode) option to treat multiple sources;
c        actual receptor locations vary with wind direction and
c        impact of plumes from all sources is summed as in receptor
c        mode; range of receptor distances and heights are selected
c        internally
c
c    (2) Revise FOG.DAT structure to remove restriction on number of
c        receptors; add new header to report compression logical in
c        receptor mode
c
c    (3) Add initial sigmas to downwash sigmas in wake of point sources
c
c --- Version 5.4, Level 000602 to Version 5.4, Level 000602_1
c
c    (1) Set LADTFOG=FALSE in block data.  This corrects problem
c        resulting in zero species #2 (usually SO4) concentrations
c        at discrete receptors.  Versions of CALPUFF earlier
c        than 000602 were not affected by the error.  Also, gridded
c        receptor concentrations were not affected in any version.
c
c --- Version 5.3, Level 991222 to Version 5.4, Level 000602
c
c    (1)  Replace VOLEM.DAT structures with new VOLEMARB.DAT structures
c         that include multiple emissions files
c
c    (2)  Use QAFAIL in QAINP when testing MREG option;  Add reference
c         to list-file at all "stop" statements (message to screen)
c
c    (3)  Add message to "stop" statements to identify subroutine where
c         model run is halted, and refer user to list file
c
c    (4)  Add units choice (g/s or g/m**2/s) to header of BAEMARB.DAT
c
c    (5)  Add initial sigmas and vertical momentum flux factor to
c         PTEMARB.DAT
c
c    (6)  Revise puff sampling (vertical) in depletion calculation
c         to match methods used for receptors during calms (VCBAR)
c
c    (7)  Report NMETDAT>MXMETDAT to unit '*' (io6 not yet assigned)
c
c    (8)  Add Horizontal puff splitting option (Block Data, READCF,
c         QAINP, SPLIT)
c
c    (9)  Revise treatment of exponentials in crosswind impact slug
c         sampling (SLUGINT) for receptors at the fringe of a slug
c
c    (10) Add specialized FOG module for use with the fog analysis
c         package of processors designed to evaluate the frequency
c         of fogging/icing events associated with mechanical-draft
c         cooling towers
c
c    (11) Allow multiple emissions files for point and buoyant area
c         sources
c
c    (12) Add new header record to all variable emissions files to
c         document the parameters for the Lambert Conformal map
c         projection
c
c    (13) Add CALMET version number to test for format before
c         Version 5.0 (980304) in MET1, and add window of 950101-980304
c         for level check in SSLATLON.
c
c    (a1/5.3)  Sigma-w data should not be extracted from a SWPRF array
c         when turbulence data are provided in a PLMMET.DAT file,
c         and a PROFILE.DAT file should not be reported to the
c         list file when turbulence data (sigma-theta) in PLMMET.DAT
c         are used.  (Subroutines TURBSET and WRFILES modified.)
c      ** Change suggested by Dennis Hearn, EPA of Victoria, Australia.
c
c    (a2/5.3)  Profile arrays for turbulence data initialized to missing
c         in BLOCK DATA.
c
c    (a3/5.3)  Complete logic to allow turbulence data to be read from
c         PROFILE.DAT when PLMMET.DAT is the primary met file.
c         (Subroutines QAINP, RDPLM, and COMP modified.)
c
c    (b1/5.3)  Add a momentum flux factor (FMFAC) for point sources to
c         simulate the reduction in vertical momentum caused by stack
c         structures (e.g., rain-hats).  Current implementation allows
c         only 0 or 1 for the factor.  (Subroutines POINTS1, POINTS2,
c         READCF, QAINP, PRFIN, STKTIP, PUFRECS, SLGRECS, PLGRECS,
c         BLOCK DATA)
c
c    (b2/5.3)  Fix bug in READCF processing of FMFAC input array for
c         point sources that updated only the value for the first source
c
c --- Version 5.2, Level 991104 to Version 5.3, Level 991222
c
c    (1)  Add boundary flux module (inflow at edge of computational
c         domain).  This brings in a new source type whose puffs are
c         initially mixed (puff code 6).  These are advected with normal
c         transformation/removal, but they do not grow laterally and
c         the (uniform) concentration from just the nearest such puff
c         is summed to obtain the impact at a given receptor.
c
c    (2)  Enable SOA option
c
c    (a1/5.2) Use MIN,MAX in place of MIN1,MAX1 in TIBLGRO, and move
c         in-line format to format statements in TRACK (removes
c         compiler warnings)
c
c    (a2/5.2)  Bug in CHEM: replace PIVOLM with PIVOLU in assigning
c         puff volume for the Upper layer used to compute the mean puff
c         concentration for the call to CHEMTF  (the M denotes the
c         mixed layer puff volume, the U denotes the upper layer
c         puff volume)
c
c    (a3/5.2)  Condition sigma-z ratio R in CTADJ2 to be <= 1.
c
c    (a4/5.2) Logic added to 3 coordinate routines (MAPG2L, LL2UTM,
c        and UTM2LL) to accommodate -180 to +180 longitude boundary
c        -- taken directly from CALMET V5.1 (991104a) --
c
c --- Version 5.0, Level 990228 to Version 5.2, Level 991104
c
c    (a1/5.0) Add capability to read a list of CALMET.DAT filenames and
c         process them in sequence.
c
c    (a2/5.0) Fix runtime /0 in terrain adjustment option 2 for ground
c         level non-buoyant sources.
c
c    (b1/5.0) Add elevated discrete receptors (gridded and CTSG receptors
c         remain on the surface).
c
c    (c1/5.0) Add ability to track mass flux across user-specified
c         boundaries, using puff centers.
c
c    (d1/5.0) Add ability to track mass balance hourly for all species,
c         for the computational domain.
c
c    (d2/5.0) Add IPFDEB variable to input group 5 to identify puff index
c         at which to begin debug output.
c
c    (d3/5.0) Fix argument type for MIN/MAX functions in MFLXCMP, and
c         assign ZERO/0.0/ in MFLXINI.
c
c    (e1/5.0) Expand search for nearest land and water cells in TIBLSET
c         and fix loop over cells touched in TIBLON.
c
c    (e2/5.0) Add transition from TIBL to inland mixing heights
c
c    (e3/5.0) Recast IXREMN arrays as map to FULL advected species array
c
c    (a1/5.1) Fix coding error in call to SLGRECS in CALCSL (introduced
c         in (b1/5.0))
c
c    (b1/5.1) Add PGTIME to control file
c
c    (b2/5.1) Incorporate mmodel='AUSPUFF' options (except metric tons).
c
c    (1) Allow zero exit velocity in numerical rise (rise = 0)
c                                                             <990729>
c
c    (2) Use plume w-velocity < 0 rather than plume angle (phi<0)
c        to stop numerical rise during stable conditions
c                                                             <990729>
c
c    (3) Enforce SYMIN limit on crosswind area source projection
c                                                             <990729>
c
c    (4) Implement Y2K logic (YYYY format for year)
c
c    (5) Add metric tons/yr as 7th option in emission units
c
c    (6) Add numerical rise integration step DSRISE(m) to control file
c
c    (7) Add check on nx,ny provided in control file (mxnx,mxny)
c
c    (8) Revise distance to final momentum rise calculation in NUMRISE
c
c    (9) Write error messages to list file as well as screen (VEMFAC,
c        VWIDTH, HDUN, SIGMA, SIGSET, RESTARTO, TIBLSET, TIBLGRO,
c        MFLXSET, YR4, QAYR4)
c
c----------------------------------------------------------------------
c --- MOD5 adapted from CALPUFF (MOD4 - V3.0, V4.0, V4.0t, V4.07, V4.1)
c
c --- Original CALPUFF written by:
c
c                  J. Scire, R. Yamartino, D. Strimaitis
c                  EARTH TECH / Sigma Research
c                  196 Baker Avenue
c                  Concord, MA  01742
c                  TEL:(978) 371-4200
c                  FAX:(978) 371-2468
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'qa.puf'
      include 'outpt.puf'
c
      logical lflag
c
c --- Set underflow treatment (compiler-dependent)
      lflag=.true.
      call UNDRFLW(lflag)
c
c --- set version and level number of program
      ver='5.8.5'
      level='151214'
c
c --- SETUP PHASE -- initialization & program setup operations
      itest=2
      call setup(itest)
c
c --- Skip COMPUTATIONAL phase and STOP program execution if in TEST
c --- mode
      if(itest.eq.1)go to 999
c
c --- COMPUTATIONAL PHASE -- basic time loop with scientific modules
      call comp
c
c --- TERMINATION PHASE -- program termination functions
999   continue
      call fin(itest)
c
      stop
      end

c----------------------------------------------------------------------
      BLOCK DATA
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731            BLOCK DATA
c                J. Scire, D. Strimaitis
c
c --- Include parameter statements
      include 'params.puf'
      parameter(mxem1=mxemdat-1)
c
c --- Include common blocks
      include 'ar1.puf'
      include 'ar2.puf'
      include 'bcs.puf'
      include 'chemdat.puf'
      include 'comparm.puf'
      include 'csigma.puf'
      include 'ctsgdat.puf'
      include 'dispdat.puf'
      include 'datehr.puf'
      include 'drydep.puf'
      include 'drygas.puf'
      include 'drypart.puf'
      include 'filnam.puf'
      include 'flags.puf'
      include 'fog.puf'
      include 'gen.puf'
      include 'grid.puf'
      include 'ln1.puf'
      include 'ln2.puf'
      include 'map.puf'
      include 'methd.puf'
      include 'methr.puf'
      include 'outpt.puf'
      include 'pdf.puf'
      include 'pt1.puf'
      include 'pt2.puf'
      include 'puff.puf'
      include 'vol1.puf'
      include 'vol2.puf'
      include 'wakedfsn.puf'
      include 'wrkspc.puf'
c
c --- AR1 common block (control file area sources)
      data nvert1/mxarea*4/
      data iaru/1/
      data ivar1/mxspar*0/
      data iq12ar1/mxspar*0/
c
c --- AR2 common block (external file area sources)
      data nvert2/mxarea*4/,ntr0/10/
      data xnlat1ar2/0./,xnlat2ar2/0./,rnlat0ar2/0./,rwlon0ar2/0./
c
c --- BCS common block (BCON.DAT file)
      data ibcu/1/
      data ivbc/mxspbc*0/
      data iq12bc/mxspbc*0/
      data mdepbc/1/
      data htminbc/500./, rsampbc/10./, conbc0/1.0e-06/
c --- Initialize air-mass type names to blank
      data cnamtyp/mxbc*'            '/
c --- Set array of concentration conversion factors to convert user
c --- units to g/m**3.  Note that ppm and ppb are converted using
c --- molecular weight (g/g-mole) and molar volume (.0224 m^3/kg-mole)
c --- at STP (0 C, 1 atm)
      data funitsbc/1.0, 1.0E-06, 4.4643E-05, 4.4643E-08/
c --- Name those factors
      data cunitsbc/'   g/m**3   ','  ug/m**3   ',
     &              '    ppm     ','    ppb     '/
c
c --- CHEMDAT common block
      data moz/1/,bcko3m/12*80./,bcknh3m/12*10./
      data mh2o2/1/,bckh2o2m/12*1.0/
      data ch2o2/'H2O2','h2o2'/
      data rnite1/0.2/,rnite2/2.0/,rnite3/2.0/
      data bckpmf/12*1.0/
      data vcnx/12*50.0/
      data ofrac/2*.15,9*.20,.15/
c      data nozsta/0/, nh2o2sta/0/
c
c --- COMPARM common block
      data xmxlen/1.0/,mxnew/99/,xsamlen/1.0/,mxsam/99/
      data mxagehr/0/
      data xminzi/50.0/,xmaxzi/3000./
      data symin/1.0/,szmin/1.0/
      data sl2pf/10.0/,svmin/6*0.5,6*0.37/
      data swmin/.20,.12,.08,.06,.03,.016,
     &           .20,.12,.08,.06,.03,.016/
c --- Divergence criterion for initiating sigma-z enhancement
      data cdiv/0.000,0.000/
c --- Default for minimum wind speed for non-"calm"
      data wscalm/0.5/
c --- Default limits (m/s) for wind speed classes (class 6 has no limit)
      data wscat/1.54,3.09,5.14,8.23,10.8/
c --- Number of groups of 12 emission rate scaling factors for each
c --- variable emissions option
      data iqnum/2,1,8,3,1/
c --- Initialize the index pointer for the variable emissions scaling
c --- factor array (VQFAC)
      data iqnext/1/
c --- Default for maximum sigma-z allowed (sigma-z cap)
      data szcap_m/5.0e06/
c
c --- ISC rural defaults for wind profile power law exponents (6)
      data plx0/.07,.07,.10,.15,.35,.55/
c --- ISC defaults for array of potential temperatures (2)
      data ptg0/0.020,0.035/
c --- Defaults for array of plume path coefficients (6)
      data ppc/0.5,0.5,0.5,0.5,0.35,0.35/
c --- Default for using ISC transition-point between downwash schemes
      data tbd/0.5/
c --- Puff splitting defaults
      data nsplit/3/
      data iresplit/17*0,1,6*0/
      data zisplit/100./,roldmax/0.25/
      data nsplith/5/,sysplith/1./,cnsplith/mxspec*1.0E-07/
      data shsplith/2./
c --- Convergence fractions for numerical integration
      data epsslug/1.0e-04/,epsarea/1.0e-06/
c --- Number of iterations used to estimate transport wind for sampling
c --- step prior to final rise
      data ncount/2/
c --- Distance parameters for sub-grid TIBL module
      data tibldist/1.0, 10., 9.0/
c --- Step distance for numerical plume rise
      data dsrise/1.0/
c --- Set trajectory inclination angle, ignoring streamline descent,
c --- at which check is made for PRIME wake influence
c --- (Current default = 20 deg = 0.3490659 radians)
      data trajincl/20.0/
c
c --- CSIGMA common block
      data tyidr,tzidr,tzisdr/0.001,0.002,0.01/
      data syh/300./,szh/88./
c
c --- The following from from MESOPUFF II   VERSION 4.01   LEVEL 821201
      data ayt/0.5/,azt/5.0,3.873,2.739,1.871,1.225,0.707/
      data aypgt/0.36,0.25,0.19,0.13,0.096,0.063/,bypgt/6*0.9/
      data azpgt/0.00023,0.058,0.11,0.57,0.85,0.77/
      data bzpgt/2.10,1.09,0.91,0.58,0.47,0.42/
c
c --- The following from from ISC6-8
      data ayurb/2*0.32,0.22,0.16,2*0.11/
      data xiyurb/6*0.0004/
      data azurb/2*0.24,0.20,0.14,2*0.08/
      data xizurb/3*0.001,0.0003,2*0.0015/
c
      data nzbrur/8,3,1,6,9,10/
c
      data xzbrur/0.10, 0.15, 0.20, 0.25, 0.30,
     1            0.40, 0.50, 3.11, 2*1.e20,
     2            0.20, 0.40, 8*1.e20,
     3            10*1.e20,
     4            0.30, 1.00, 3.00, 10.0, 30.0, 5*1.e20,
     5            0.10, 0.30, 1.00, 2.00, 4.00,
     5            10.0, 20.0, 40.0, 2*1.e20,
     6            0.20, 0.70, 1.00, 2.00, 3.00,
     6            7.00, 15.0, 30.0, 60.0, 1.e20/
c
      data szbrur/60*1.0e20/
c
      data azrur/122.80, 158.08, 170.22, 179.52, 217.41,
     1           258.89, 346.75, 3*453.85,
     2           90.673, 98.483, 8*109.3,
     3           10*61.141,
     4           34.459, 32.093, 32.093, 33.504, 36.65 ,5*44.053,
     5           24.26 , 23.331, 21.628, 21.628, 22.534,
     5           24.703, 26.97 , 35.42 , 2*47.618,
     6           15.209, 14.457, 13.953, 13.953, 14.823,
     6           16.187, 17.836, 22.651, 27.074, 34.219/
c
      data bzrur/0.9447 , 1.0542 , 1.0932 , 1.1262 , 1.2644 ,
     1           1.4094 , 1.7283,  3*2.1166,
     2           0.93198, 0.98332, 8*1.0971,
     3           10*0.91465,
     4           0.86974, 0.81066, 0.64403, 0.60486, 0.56589, 5*0.51179,
     5           0.8366 , 0.81956, 0.75660, 0.63077, 0.57154,
     5           0.50527, 0.46713, 0.37615, 2*0.29592,
     6           0.81558, 0.78407, 0.68465, 0.63227, 0.54503,
     6           0.46490, 0.41507, 0.32681, 0.27436, 0.21716/
c
c --- CTSGDAT common block
      data nhill/0/,nctrec/0/,xhill2m/1.0/,zhill2m/1.0/
c
c --- DATEHR common block
      data xbtz/-999./
c
c --- DISPDAT common block
      data sytdep/550./
      data jsup/5/,conk1/0.01/,conk2/0.1/,iurb1/10/,iurb2/19/
      data avet/60./,pgtime/60./
c
c --- DRYDEP common block
      data idryflg/mxspec*0/,iveg/1/
c
c --- DRYGAS common block
      data rcutr/30.0/,rgr/10.0/,reactr/8.0/
      data pconst/2.3e-8/,bmax/2.5e-6/,bmin/0.1e-6/,qswmax/600./
      data dconst1/2.0/,dconst2/0.6666667/,dconst3/4.8e-4/
      data pdiff/mxspec*-999./,alphas/mxspec*-999./,
     1 react/mxspec*-999./,rm/mxspec*-999./,henry/mxspec*-999./
c
c --- DRYPART common block
      data rho/mxpdep*1.0/,npsint/9/,dconst4/0.6666667/
c
c --- FILNAM, FILLOG common blocks
      data pufinp/'calpuff.inp'/,metdat/'calmet.dat'/,
     1 iscdat/'iscmet.dat'/,plmdat/'plmmet.dat'/,puflst/'calpuff.lst'/,
     2 condat/'conc.dat'/,dfdat/'df.dat'/,wfdat/'wf.dat'/,
     3 visdat/'visb.dat'/,t2ddat/'tk2d.dat'/,rhodat/'rho2d.dat'/,
     4 ptdat/'ptemarb.dat',mxem1*' '/,voldat/'volemarb.dat',mxem1*' '/,
     5 ardat/'baemarb.dat',mxem1*' '/,lndat/'lnemarb.dat'/,
     6 ozdat/'ozone.dat'/,vddat/'vd.dat'/,chemdat/'chem.dat'/,
     7 hildat/'hill.dat'/,rctdat/'hillrct.dat'/,
     8 rstartb/'restartb.dat'/,rstarte/'restarte.dat'/,
     9 cstdat/'coastln.dat'/,bdydat/'fluxbdy.dat'/,
     1 flxdat/'massflx.dat'/,baldat/'massbal.dat'/,debug/'debug.dat'/
      data bcndat/'bcon.dat'/,fogdat/'fog.dat'/,h2o2dat/'h2o2.dat'/
      data nptdat/0/, nardat/0/, nvoldat/0/
      data lcfiles/.true./
c
c --- FLAGS common block
      data mgauss/1/,mctadj/3/,mctsg/0/,mslug/0/,mtrans/1/,mtip/1/
      data mshear/0/,msplit/0/,mchem/1/,mwet/1/,mdry/1/
      data mdisp/3/,mturbvw/3/,mdisp2/3/,mrough/0/,mpartl/1/
      data mtinv/0/,mpdf/0/,mhftsz/0/,msgtibl/0/,mreg/1/
      data mfog/0/,maqchem/0/,mbdw/1/,mtilt/0/,mcturb/1/,mtauly/0/
      data mtauadv/0/
      data ldevel/.FALSE./
c
c --- FOG common block
      data nfpts/1/,ipcp/51*0/,ifdays/366*0/
      data lpmode/.FALSE./
      data ladtfog/.FALSE./
c
c --- GEN common block
      data nspec/5/,nse/3/
      data metfm/1/,metrun/0/,mprffm/1/
      data mrestart/0/, nrespd/0/
c --- Activate this block for MXSPEC=35
c *** data cspec/ 'SO2', 'SO4', 'NOX', 'HNO3', 'NO3', 30*' '/
c *** data cgrup/ 35*'      '/
c *** data isplst/3*1,0, 3*1,0, 3*1,0, 1,0,1,0, 1,0,1,0, 120*0/
c --- Activate this block for MXSPEC=20
      data cspec/ 'SO2', 'SO4', 'NOX', 'HNO3', 'NO3', 15*' '/
      data cgrup/ 20*'      '/
      data isplst/3*1,0, 3*1,0, 3*1,0, 1,0,1,0, 1,0,1,0, 60*0/
c --- Activate this block for MXSPEC=5
c *** data cspec/ 'SO2', 'SO4', 'NOX', 'HNO3',   'NO3'/
c *** data cgrup/ 5*'      '/
c *** data isplst/3*1,0, 3*1,0, 3*1,0, 1,0,1,0, 1,0,1,0/
c
c --- GRID common block
      data lsamp/.true./,meshdn/1/
      data xtz/-999.0/
c
c --- LN1 common block
      data ilnu/1/
      data ivln1/mxspln*0/
      data iq12ln1/mxspln*0/
c --- Default for the maximum number of segments along one line source
c --- from which a slug is released, and for number of points used to
c --- tabulate rise
      data mxnseg/7/,nlrise/6/
c
c --- LN2 common block
      data nln2/0/
      data xnlat1ln2/0./,xnlat2ln2/0./,rnlat0ln2/0./,rwlon0ln2/0./
c
c --- MAP common block
      data pmap/'UTM     '/
      data datum/'WGS-84  '/
      data utmhem/'N   '/
      data iutmzn/-999/
      data xlat1 /-999./, xlat2 /-999./
      data rlon0 /-999./, rlat0 /-999./
      data relon0 /-999./, rnlat0 /-999./
      data feast/0.0/, fnorth/0.0/
c --- Derived variables
      data lutm/.false./, llcc/.false./, lps/.false./
      data lem/.false./, llaza/.false./, lttm/.false./
c
c --- METHD common block
      data datumm/'WGS-84  '/
      data iutmznm/-999/
      data xlat1m /-999./, xlat2m /-999./
      data rlon0m /-999./, rlat0m /-999./
      data feastm/0.0/, fnorthm/0.0/
c --- Nulls for using "old" CALMET met data file (METFM=1)
      data llconfm/.FALSE./
      data xlat0m/-999./,xlon0m/-999./
c --- Defaults for using single-point met data files (METFM=2,3,4,5)
      data i2dmet/0/
      data anemht/10./,isigmav/1/,imixctdm/0/
      data ilanduin/20/,z0in/.25/,xlaiin/3.0/
      data elevin/0.0/,xlatin/-999./,xlonin/-999./
      data nss/0/,xlatss/mxss*-999./,xlonss/mxss*-999./
c
c --- METHR common block
c --- ISC defaults for potential temperature gradient (KST=5,6)
      data ptg/0.020,0.035/
c --- Initialize observed inversion strength to missing (-999.)
      data dptinvo/-999./
c --- Initialize observed turbulence profiles to missing (-999.)
      data svprf/mxprfz*-999./
      data swprf/mxprfz*-999./
c --- Initialize observed wind shear power-law exponent to missing
      data plexp/-999./
c
c --- OUTPT common block
      data icon/1/,idry/1/,iwet/1/,icprt/0/,idprt/0/,iwprt/0/
      data icfrq/1/,idfrq/1/,iwfrq/1/
      data iprtu/1/
      data ioutop/mx7*0/,imesg/2/
c --- Add a flag for supplying Rel. Hum. (%) in a VISB.DAT file for
c --- visibility applications
      data ivis/1/
c --- Add a flags for creating 2D Temperature(K) and Density(kg/m3)
c --- output files
      data it2d/0/, irho/0/
      data ldebug/.FALSE./,ipfdeb/1/,npfdeb/1/,nn1/1/,nn2/10/
      data lcomprs/.true./
      data imflx/0/,imbal/0/
c --- Add a flag for FOG.DAT file (need MFOG>0 to be used)
      data ifog/0/
c --- QA plot files and source contributions
      data iqaplot/1/,msource/0/
c
c --- PDF common block
      data lpdf/.FALSE./
c
c --- PT1 common block (control file point sources)
      data iptu/1/
      data ivpt1/mxsppt1*0/
      data iq12pt1/mxsppt1*0/
      data fmfpt1/mxpt1*1.0/
      data zplatpt1/mxpt1*0.0/
c
c --- PT2 common block (external file point sources)
      data xnlat1pt2/0./,xnlat2pt2/0./,rnlat0pt2/0./,rwlon0pt2/0./
      data zplatpt2/mxpt2*0.0/
c
c --- PUFF common block
      data npuffs/0/
      data tcon/mxpuf6*0.0/
      data isplit/mxpuff*1/
c
c --- VOL1 common block (control file volume sources)
      data ivlu/1/
      data ivvl1/mxspvl*0/
      data iq12vl1/mxspvl*0/
c
c --- VOL2 common block (control file volume sources)
      data xnlat1vl2/0./,xnlat2vl2/0./,rnlat0vl2/0./,rwlon0vl2/0./
c
c --- WAKEDFSN common block
c --- Ambient turbulence intensities are inferred from Briggs (1973)
c --- "Diffusion estimation for small emissions", ATDL-106;
      data rurliz/.20,.12,.08,.06,.03,.016/
      data rurliy/.22,.16,.11,.08,.06,.04/
      data urbniz/.24,.24,.20,.14,.08,.08/
      data urbniy/.32,.32,.22,.16,.11,.11/
c --- Set the factor for defining when turb Approaches Asymptotic
c --- value, and also define the maximum allowed scaled distance
      data afac/1.3/, xbyrmax/15./
c --- Turbulence intensities in wake (from Briggs rural curves)
      data wiz0/0.06/, wiy0/0.08/
c --- Wake Factors for sigw and sigv from Weil (1996)
      data wfz/1.7/, wfy/1.7/
c --- DeltaU0/U0
      data dua_ua/0.7/
c --- Power-law exponent for turbulence intensity change in distance
      data xdecay/0.666667/, xdecayi/1.5/
c
c --- WRKSPC common block
      data nw1/mxnxy/,nw2/mxnxy/
c
      end

c----------------------------------------------------------------------
c --- BRING IN CALPUFF SYSTEM UTILITY SUBROUTINES
      include 'calutils.for'
      include 'coordlib.for'
c----------------------------------------------------------------------

c----------------------------------------------------------------------
      subroutine advwnd(u,v,zface,nzp1,zbot,ztop,uave,vave)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 940430                 ADVWND
c                J. Scire, SRC
c
c --- PURPOSE:  Compute the vertically-averaged winds (U, V) through
c               the layer ZBOT through ZTOP
c
c --- INPUTS:
c         U(mxnz) - real array - U-component of wind (m/s) for each
c                                layer
c         V(mxnz) - real array - V-component of wind (m/s) for each
c                                layer
c   ZFACE(mxnzp1) - real array - Cell face heights (m) for each layer
c            NZP1 - integer    - Number of cell face heights (NZ + 1)
c            ZBOT - real       - Height (m) of BOTTOM of averaging layer
c            ZTOP - real       - Height (m) of TOP of averaging layer
c
c     Parameters:
c           MXNZ, MXNZP1, IO6
c
c --- OUTPUT:
c            UAVE - real       - Vertically-averaged U-component of the
c                                wind (m/s)
c            VAVE - real       - Vertically-averaged V-component of the
c                                wind (m/s)
c
c --- ADVWND called by:  ADVECT
c --- ADVWND calls:      ZFIND
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
      real u(mxnz),v(mxnz)
      real zface(mxnzp1)
c
c --- Set the limits of the averaging depth to ensure overlap
c --- with the meteorological fields
      zabot=zbot
      if(zabot.lt.zface(1))zabot=zface(1)
      if(zabot.gt.zface(nzp1))zabot=zface(nzp1)
c
      zatop=ztop
      if(zatop.lt.zface(1))zatop=zface(1)
      if(zatop.gt.zface(nzp1))zatop=zface(nzp1)
c
c --- Find the met. layer containing the height "ZABOT" (adjusted ZBOT)
      call zfind(zabot,zface,nzp1,IBOT)
c
c --- Find the met. layer containing the height "ZATOP" (adjusted ZTOP)
      call zfind(zatop,zface,nzp1,ITOP)
c
c ------------------------------------
c --- Compute the layer-averaged winds
c ------------------------------------
c
      if(IBOT.eq.ITOP)then
c
c ---    Averaging layer is completely within one met. layer
         uave=u(ibot)
         vave=v(ibot)
      else
c
c ---    Averaging layer extends into two or more met. layers
c ---    Sum through each met. layer
c
c ---    Lowest met. layer containing ZABOT -- ZFACE(ibot+1) is the
c ---    height of the TOP of layer IBOT
         delz=zface(ibot+1)-zabot
         sumu=delz*u(ibot)
         sumv=delz*v(ibot)
         sumz=delz
c
c ---    Highest met. layer containing ZATOP -- ZFACE(itop) is the
c ---    height of the BOTTOM of layer ITOP
         delz=zatop-zface(itop)
         sumu=sumu+delz*u(itop)
         sumv=sumv+delz*v(itop)
         sumz=sumz+delz
c
c ---    Sum through met. layers between IBOT and ITOP
         ibotp1=ibot+1
         itopm1=itop-1
         if(itopm1.lt.ibotp1)go to 102
         do 100 i=ibotp1,itopm1
            delz=zface(i+1)-zface(i)
            sumu=sumu+delz*u(i)
            sumv=sumv+delz*v(i)
            sumz=sumz+delz
100      continue
102      continue
c
c ---    Compute the layer-averaged winds
         UAVE=sumu/sumz
         VAVE=sumv/sumz
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine advect(ldbg,ix,iy,z0m,el,dpbl,istab,ht,zbot,ztop,
     &                  uadv,vadv)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 ADVECT
c ---            D. Strimaitis
c
c --- PURPOSE:  Obtain puff advection wind
c
c --- UPDATE
c --- V5.83-V5.8.4  130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be replaced with default if
c                                  it remains missing here

c --- V5.4-V5.74    040715  (DGS): add AERMET option (METFM=5)
c --- V4.0a-V5.4    000602  (DGS): add message to "stop"
c --- V4.0-V4.0a    971107  (DGS): initialize ibot & itop (METFM=4)
c                   971107  (DGS): modify search for profile levels
c                                  within puff
c                   971107  (DGS): check PROBLEM returned by XTPRF
c
c --- INPUTS:
c            LDBG - logical      - Write debug output if .TRUE.
c           IX,IY - integer      - Cell index of puff in MET grid
c             Z0M - real         - Surface roughness (m)
c              EL - real         - Monin-Obukhov length (m)
c            DPBL - real         - Depth of boundary layer (m)
c           ISTAB - integer      - PG stability class
c              HT - real         - Initial puff height, at release (m)
c            ZBOT - real         - Bottom of puff (m)
c            ZTOP - real         - Top of puff (m)
c
c    Common block /COMPARM/ variables:
c         WSCALM, PLX0
c    Common Block /GEN/ variables:
c         METFM
c    Common Block /GRID/ variables:
c         NZ, NZP1, ZGPT(mxnz), ZFACE(mxnzp1)
c    Common block /METHR/ variables:
c         UMET(mxnx,mxny,mxnz), VMET(mxnx,mxny,mxnz)
c         PTG(2), PLEXP, SSPRF(mxprfz), WDPRF(mxprfz), ZPRF(mxprfz)
c         NZPRF
c    Parameters:
c         MXNX, MXNY, MXNZ, MXNZP1, MXPRFZ, IO6
c
c --- OUTPUT:
c            UADV - real         - Vertically-averaged U-component
c                                  of the wind (m/s)
c            VADV - real         - Vertically-averaged V-component
c                                  of the wind (m/s)
c
c --- ADVECT called by:  COMP, RISEWIND
c --- ADVECT calls:      ADVWND, POWLAW, XTPRF
c----------------------------------------------------------------------
      include 'params.puf'
      include 'comparm.puf'
      include 'gen.puf'
      include 'grid.puf'
      include 'methr.puf'

      real u(mxnz),v(mxnz)
      logical ldbg,problem
      data dtor/0.0174533/


      if(ldbg) then
         write(io6,*)
         write(io6,*)'ADVECT:      metfm =  ',metfm
         write(io6,*)'zbot,ztop,ht(release) ',zbot,ztop,ht
      endif

c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif
      if(metfm.LE.3) then
c ---    3-D gridded MET field:  transfer U,V to 1-D arrays
         do iz=1,nz
            u(iz)=umet(ix,iy,iz)
            v(iz)=vmet(ix,iy,iz)
         enddo

         if(metfm.EQ.2 .OR. metfm.EQ.3) then
c ---       ISC/PLUME treatment (1-layer)
c ---       Profile non-calm wind speed in layer to RELEASE height
            wsold=sqrt(u(1)**2+v(1)**2)
            if(wsold.LT.wscalm) then
               uadv=u(1)
               vadv=v(1)
            else
               call POWLAW(ht,zgpt(1),wsold,plx,ws)
               ratio=ws/wsold
               uadv=u(1)*ratio
               vadv=v(1)*ratio
            endif
            if(ldbg) then
               write(io6,*)'uadv,vadv= ',uadv,vadv
            endif
         else
c ---       Full 3-D gridded layer-averaged MET treatment
            call ADVWND(u,v,zface,nzp1,zbot,ztop,uadv,vadv)
            if(ldbg) then
               write(io6,*)'uadv,vadv= ',uadv,vadv
            endif
         endif

      elseif(metfm.EQ.4 .OR. metfm.EQ.5) then
c ---    PROFILE.DAT met data
c ---    Use scalar speed as in CTDM
         problem=.FALSE.
         if(zbot.EQ.ztop) then
c ---       Get wind at ZBOT
            call XTPRF(nzprf,ssprf,zprf,zbot,'spd',z0m,el,
     &                 dpbl,istab,ptg,ws,problem)
            call XTPRF(nzprf,wdprf,zprf,zbot,'dir',z0m,el,
     &                 dpbl,istab,ptg,wd,problem)
            wdrad=wd*dtor
            uadv=-ws*SIN(wdrad)
            vadv=-ws*COS(wdrad)
            if(ldbg) then
               write(io6,*)'ws,wd    = ',ws,wd
            endif
         else
c ---       Get wind at top and bottom of puff
            call XTPRF(nzprf,ssprf,zprf,ztop,'spd',z0m,el,
     &                 dpbl,istab,ptg,wstop,problem)
            call XTPRF(nzprf,wdprf,zprf,ztop,'dir',z0m,el,
     &                 dpbl,istab,ptg,wdtop,problem)
            toprad=wdtop*dtor
            utop=-wstop*SIN(toprad)
            vtop=-wstop*COS(toprad)
            call XTPRF(nzprf,ssprf,zprf,zbot,'spd',z0m,el,
     &                 dpbl,istab,ptg,wsbot,problem)
            call XTPRF(nzprf,wdprf,zprf,zbot,'dir',z0m,el,
     &                 dpbl,istab,ptg,wdbot,problem)
            botrad=wdbot*dtor
            ubot=-wsbot*SIN(botrad)
            vbot=-wsbot*COS(botrad)
            if(ldbg) then
               write(io6,*)'wstop,wsbot = ',wstop,wsbot
               write(io6,*)'wdtop,wdbot = ',wdtop,wdbot
            endif
c ---       Find range of indices of profile array within puff
            ibot=0
            itop=0
            do iz=1,nzprf
               if(zprf(iz).LT.zbot) ibot=iz+1
               if(zprf(iz).LT.ztop) itop=iz
            enddo
            if(ibot.GT.itop .OR. ibot.EQ.0) then
c ---          No profile levels are within puff
               uadv=0.5*(utop+ubot)
               vadv=0.5*(vtop+vbot)
            else
               denomi=0.5/(ztop-zbot)
c ---          Bottom edge
               usum=ubot*(zprf(ibot)-zbot)
               vsum=vbot*(zprf(ibot)-zbot)
c ---          Top edge
               usum=usum+utop*(ztop-zprf(itop))
               vsum=vsum+vtop*(ztop-zprf(itop))
c ---          Middle layer(s)
               do iz=ibot,itop
                  call XTPRF(nzprf,ssprf,zprf,zprf(iz),'spd',z0m,el,
     &                       dpbl,istab,ptg,wsiz,problem)
                  call XTPRF(nzprf,wdprf,zprf,zprf(iz),'dir',z0m,el,
     &                       dpbl,istab,ptg,wdiz,problem)
                  drad=wdiz*dtor
                  ui=-wsiz*SIN(drad)
                  vi=-wsiz*COS(drad)
                  if(iz.EQ.ibot) then
                     zb=zbot
                  else
                     zb=zprf(iz-1)
                  endif
                  if(iz.EQ.itop) then
                     zt=ztop
                  else
                     zt=zprf(iz+1)
                  endif
                  usum=usum+ui*(zt-zb)
                  vsum=vsum+vi*(zt-zb)
               enddo
c ---          Average
               uadv=usum*denomi
               vadv=vsum*denomi
               if(ldbg) then
                  write(io6,*)'itop,ibot   = ',itop,ibot
                  write(io6,*)'usum,vsum   = ',usum,vsum
               endif
            endif
            if(ldbg) then
               write(io6,*)'uadv,vadv= ',uadv,vadv
            endif
         endif

c ---    Results are invalid if XTPRF reported PROBLEM=TRUE
         if(PROBLEM) then
            write(io6,*) 'ADVECT:  FATAL ERROR reported when ',
     &                   'extracting winds from PROFILE ---'
            write(io6,*) 'There are no valid data'
            write(*,*)
            stop 'Halted in ADVECT -- see list file'
         endif

      endif

      return
      end
c----------------------------------------------------------------------
      subroutine windset(ht,ilayer,ix,iy,z0m,el,dpbl,istab,ws,wd)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                WINDSET
c ---            D. Strimaitis
c
c --- PURPOSE:  Obtain wind at height HT
c
c --- UPDATE
c --- V5.74-V5.8.4  130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c --- V5.4-V5.74    040715  (DGS): Add AERMET option (METFM=5)
c --- V5.0-V5.4     000602  (DGS): Add message to "stop"
c --- V5.0-V5.0     980731  (DGS): Use CALM WD=180.0 for absolute
c                                  calms (ws=0.0)
c --- V4.0-V5.0     971107  (DGS): Set wd to ZERO if CALM to avoid
c                                  potential numerical problem with
c                                  ATAN2 function
c                   971107  (DGS): Use (WS.GE.WSCALM) to signal NON Calm
c                   971107  (DGS): check PROBLEM returned by XTPRF
c
c --- INPUTS:
c              HT - real         - Puff height (m)
c          ILAYER - integer      - Met layer containing HT
c           IX,IY - integer      - Cell index of puff in MET grid
c             Z0M - real         - Surface roughness (m)
c              EL - real         - Monin-Obukhov length (m)
c            DPBL - real         - Depth of boundary layer (m)
c           ISTAB - integer      - PG stability class
c
c    Common block /COMPARM/ variables:
c         WSCALM, PLX0
c     Common Block /GEN/ variables:
c         METFM
c     Common Block /GRID/ variables:
c         ZGPT(mxnz)
c    Common block /METHR/ variables:
c         UMET(mxnx,mxny,mxnz), VMET(mxnx,mxny,mxnz)
c         PTG(2), PLEXP, SSPRF(mxprfz), WDPRF(mxprfz), ZPRF(mxprfz)
c         NZPRF
c    Parameters:
c         MXNX, MXNY, MXNZ, MXPRFZ, IO6
c
c --- OUTPUT:
c              WS - real         - Value of wind speed at HT (m/s)
c              WD - real         - Value of wind direction at HT (deg)
c
c --- WINDSET called by:  RLSMET, COMP
c --- WINDSET calls:      POWLAW, XTPRF
c----------------------------------------------------------------------
      include 'params.puf'
      include 'comparm.puf'
      include 'gen.puf'
      include 'grid.puf'
      include 'methr.puf'

      logical problem
      data rtod/57.29578/,wdcalm/180.0/
c
c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif
c
      if(metfm.LE.3) then
c ---    3-D gridded MET field
c ---    Form wind speed from components
         ws=SQRT(umet(ix,iy,ilayer)**2+vmet(ix,iy,ilayer)**2)
         if(metfm.EQ.2 .OR. metfm.EQ.3) then
c ---       Adjustment for ISC/PLUME treatment !!
c ---       Profile non-calm wind speed in layer to puff height
            if(ws.GE.wscalm) then
               wsold=ws
               call POWLAW(ht,zgpt(ilayer),wsold,plx,ws)
            endif
         endif
         if(ws.GT.0.0) then
            wd=270.-(ATAN2(vmet(ix,iy,ilayer),umet(ix,iy,ilayer)))*rtod
         else
c ---       Absolute calm
            wd=wdcalm
         endif

      elseif(metfm.EQ.4 .OR. metfm.EQ.5) then
c ---    PROFILE.DAT met data
c ---    Use scalar speed as in CTDM
         problem=.FALSE.
         call XTPRF(nzprf,ssprf,zprf,ht,'spd',z0m,el,
     &              dpbl,istab,ptg,ws,problem)
         call XTPRF(nzprf,wdprf,zprf,ht,'dir',z0m,el,
     &              dpbl,istab,ptg,wd,problem)

c ---    Results are invalid if XTPRF reported PROBLEM=TRUE
         if(PROBLEM) then
            write(io6,*) 'WINDSET:  FATAL ERROR reported when ',
     &                   'extracting winds from PROFILE ---'
            write(io6,*) 'There are no valid data'
            write(*,*)
            stop 'Halted in WINDSET -- see list file.'
         endif

      endif

      return
      end
c----------------------------------------------------------------------
      subroutine puffdz(ii,icode,lpuff,istab,ilayer,htmet,dpbl,
     &                  ztop,zbot)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8        Level: 000602               PUFFDZ
c                D. Strimaitis
c
c --- PURPOSE:  Computes the top and bottom of the puff/slug for
c               use in obtaining the advection wind
c
c --- UPDATE
c --- V5.0-V5.4     000602  (DGS): Add message to "stop"
c --- V5.0-V5.0     980821  (DGS): Impose lid height on ZTOP for class
c                                  D as well as A,B, and C
c
c --- INPUTS:
c               II - integer - Puff index
c            ICODE - integer - Puff code
c            LPUFF - logical - Puff if .TRUE. (SLUG if .FALSE.)
c            ISTAB - integer - Stability class
c           ILAYER - integer - Met grid layer containing puff
c            HTMET - real    - Ht at which to center puff (m)
c             DPBL - real    - Current planetary boundary layer depth (m)
c
c     Common block /GEN/ variables:
c           NSPEC
c     Common block /GRID/ variables:
c           ZFACE(mxnzp1)
c     Common block /PUFF/ variables:
c           SIGZB(mxpuff), ZIOLD(mxpuff), ZIMAX(mxpuff),
c           QM(mxspec,mxpuff), QU(mxspec,mxpuff)
c     Common block /SLUG/ variables:
c           SIGZE(mxpuff)
c     Parameters:
c           MXNZP1, MXPUFF, MXSPEC, IO6
c
c --- OUTPUT:
c             ZTOP - real    - Top of puff
c             ZBOT - real    - Bottom of puff
c
c --- PUFFDZ called by: COMP, SPLIT
c --- PUFFDZ calls:     none
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
      include 'gen.puf'
      include 'grid.puf'
      include 'puff.puf'
      include 'slug.puf'
c
      logical lpuff
c
c --- Compute the height of the bottom and top of the puff/slug
c --- at the end of previous step
      if(mod(icode,2).eq.1)then
c ---    Gaussian if ICODE=1,3,5 (puff) or 11,13,15 (slug)
c ---    (height +/- sigma-z; ignore BID)
         if(lpuff) then
c ---       PUFF
            sigmaz=sigzb(ii)
         else
c ---       SLUG
            sigmaz=0.5*(sigzb(ii)+sigze(ii))
         endif
         zbot=htmet-sigmaz
         if(zbot.LT.0.) zbot=0.0
         ztop=htmet+sigmaz
         if(icode.NE.3 .and. icode.NE.13 .AND. istab.LE.4) then
            if(dpbl.GT.htmet) then
               ztop=amin1(ztop,dpbl)
            else
               ztop=amin1(ztop,ziold(ii))
            endif
         endif
      else
c ---    Uniformly mixed if ICODE=2,4,6 (puff) or 12,14,16 (slug)
         if(icode.eq.2.or.icode.eq.12)then
c ---       Puff is within mixed layer (ICODE=2 or 12)
            zbot=0.0
c            ztop=amax1(dpbl,zimax(ii))
            ztop=zimax(ii)
         else if(icode.eq.4.or.icode.eq.14)then
c ---       Puff is above mixed layer since release (ICODE=4,14)
            zbot=zface(ilayer)
            ztop=zface(ilayer+1)
         else if(icode.eq.6.or.icode.eq.16)then
c ---       Puff is within 2-layer, mixed structure (ICODE=6,16)
            zbot=0.0
            ztop=zimax(ii)
c ---       Revise ZBOT if mass in upper layer > 2*mass in lower
            qmtot=0.0
            qutot=0.0
            do is=1,nspec
               qmtot=qmtot+qm(is,ii)
               qutot=qutot+qu(is,ii)
            enddo
            if(qutot.GT.(2.*qmtot)) zbot=ziold(ii)*(1-2.*qmtot/qutot)
         else
            write(io6,*)'ERROR in SUBR. PUFFDZ -- Invalid value of ',
     &      'ICODE -- ICODE = ',icode,' PUFF NO. (II) = ',ii
            write(*,*)
            stop 'Halted in PUFFDZ -- see list file.'
         endif
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine areaint(x,y,lwflux,z,hlid,hlidmax,
     &                   zrterr,zstak,zbase,ppcf,ldbhr,
     &                   ccqb,ccdq,ccizqb,ccizdq)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                AREAINT
c                R. Yamartino
c
c --- PURPOSE:  For a polygon AREA source, INTegrate the
c               time-averaged concentration for the case of the
c               unaged slug (i.e., IAGE=0) for a receptor at (X,Y)
c
c --- UPDATE
c --- V5.0-V5.8.4   130731  (EPA): add HLIDMAX for use in VCOUP
c --- V5.0-V5.0     980430  (DGS): drop dt from argument list
c --- V4.0-V5.0     971107  (DGS): add /COMPARM/ with "eps" variable for
c                                  use in CPQROMB
c
c --- INPUTS:
c
c                 X - real    - X coord. of receptor.
c                 Y - real    - Y coord. of receptor.
c            LWFLUX - logical - Receptor specific wet deposition flag
c                                .true. if calculation is to be made
c                                .false. if not.
c                 Z - real    - Z coord. of receptor.
c              HLID - real    - Relevant mixing depth (m) at receptor.
c           HLIDMAX - real    - Maximum lid height (m) for mass
c                               above HLID
c            ZRTERR - real    - Terrain elevation (m MSL) at receptor
c             ZSTAK - real    - Stack height of source of puff (m)
c             ZBASE - real    - Stack base elevation MSL (m)
c              PPCF - real    - Plume Path Coefficient
c             LDBHR - logical - Flag for debugging write-statements
c
c --- COMPARM.PUF variables used.
c             EPSAREA
c --- CURRENT.PUF variables used.
c             NSIDE, XVERT, YVERT, XV, YV
c
c --- OUTPUTS:
c
c              CCQB - real    - Coupling coefficient (s/m**3) for
c                               the source rate ,QB, at the
c                               beginning of the time step.
c              CCDQ - real    - Coupling coefficient (s/m**3) for
c                               the change in source rate, DQ, between
c                               the beginning and end of the time step.
c            CCIZQB - real    - Z-integrated coefficient (s/m**2) for
c                               the source rate ,QB, at the
c                               beginning of the time step.
c            CCIZDQ - real    - Z-integrated coefficient (s/m**2) for
c                               the change in source rate, DQ, between
c                               the beginning and end of the time step.
c
c --- AREAINT called by:  CALCSL
c --- AREAINT calls:      XY2UWCW, CWYVALS, VECMIN, VECMAX, EXTREME
c                         CPQROMB
c----------------------------------------------------------------------
c
      include 'params.puf'
      include 'comparm.puf'
      include 'current.puf'
c
      logical lwflux,ldbhr
      real xvord(mxvert)
      data sigcut/3.0/
      data zero/0.0/
c
c --- Zero out the return quantities.
      ccqb  = zero
      ccdq  = zero
      ccizqb  = zero
      ccizdq  = zero
c
c --- Transform vertex coordinates, (XVERT,YVERT), into upwind/crosswind
c --- frame as (XV,YV), relative to receptor (x,y); also compute upwind
c --- position of edge of line sources (if source-type is 5), and
c --- pass slug-length variables DXY12, RDXY12 to /SLGLIN/
      call xy2uwcw(x,y)
c
c --- Quit if receptor entirely upwind.
      xtest = vecmax(nside,xv)
      if(xtest.le.zero) then
         go to 500
      else
c ---    Quit if receptor excessively crosswind.
         call extreme(nside,yv,ymin,ymax)
c ---    Continue test if receptor is NOT directly downwind.
         if((ymin*ymax).gt.zero) then
c ---       Define smallest absolute crosswind distance.
            ymin = amin1(abs(ymin),abs(ymax))
c ---       Normalize by the largest sigma y possible
            ymin = ymin / sye1
            if(ymin.gt.sigcut) go to 500
         endif
      endif
c
c --- Order the XV vertex locations in ascending order in XVORD
c --- and determine the number of integration segments NISEG.
      xvord(  1  ) = vecmin(nside,xv)
      xlast        = vecmax(nside,xv)
      xvord(nside) = xlast
      niseg = 1
c
      do i=2,nside-1
         xbelow = xvord(i-1)
         xnext = xlast
         do j=1,nside
            xnow = xv(j)
            if(xnow.gt.xbelow) xnext = amin1(xnext,xnow)
         enddo
         xvord(i) = xnext
         if(xnext.lt.xlast) niseg = niseg + 1
      enddo
c
c --- Reduce the number of segments if intercept directly upwind.
c --- Reset NISEG to 2.
c --- Define alongwind X values
      call cwyvals(nside,yv,xv,zero,xmin,xmax,nhits)
      if(nhits.eq.2) then
         xvord(2) = amax1(xmin,zero)
         xvord(3) = xlast
         niseg = 2
      endif
c
c --- Begin loop over finite length integration segments.
c --- N.B. The maximum value of NISEG is NSIDE-1
c
      do 15 i=1,niseg
      xbelow = xvord(i)
      xnext = xvord(i+1)
c
c --- Zero out the return quantities from CPQROMB
      ss1 = zero
      ss2 = zero
      ss3 = zero
      ss4 = zero
c
c --- Quit if receptor entirely upwind of this segment.
      if(xnext.le.zero) go to 15
c
c --- Redefine segment to ignore downwind source portions.
      xbelow = amax1(xbelow,zero)
c --- Ignore integration paths smaller than 0.01 m long (arbitrary cut)
      if(xnext-xbelow.lt.0.01) go to 15
c
c === Quit if receptor excessively crosswind of all Y in this interval.
c
c --- Define crosswind Y values at start of integration segment.
      call cwyvals(nside,xv,yv,xbelow,ymin,ymax,nhits)
c --- Skip detailed test if receptor directly downwind.
      if((ymin*ymax).le.zero) go to 12
      y1 = ymin
      y2 = ymax
c --- Define crosswind Y values at end of integration segment.
      call cwyvals(nside,xv,yv,xnext,ymin,ymax,nhits)
c --- Skip detailed test if receptor directly downwind.
      if((ymin*ymax).le.zero) go to 12
c --- Define range of crosswind Y values throughout integration segment.
      ymin = amin1(ymin,y1)
      ymax = amax1(ymax,y2)
c --- Skip detailed test if receptor directly downwind.
      if((ymin*ymax).le.zero) go to 12
c --- Define smallest absolute crosswind distance.
      ymin = amin1(abs(ymin),abs(ymax))
c --- Normalize by the largest sigma y possible
      ymin = ymin / sye1
      if(ymin.gt.sigcut) go to 15
c
c --- Evaluate the integral for this portion of the regime.
   12 call cpqromb(xbelow,xnext,lwflux,z,hlid,hlidmax,
     x             zrterr,zstak,zbase,ppcf,epsarea,
     x             ss1,ss2,ss3,ss4)
      ccqb  = ccqb + ss1
      ccdq  = ccdq + ss2
      ccizqb  = ccizqb + ss3
      ccizdq  = ccizdq + ss4
c ***
      if(ldbhr) then
         write(io6,*)'AREAINT -- i = ',i
         write(io6,*)'  ccqb, ccdq = ',ccqb,ccdq
      endif
c ***
c
   15 continue
c
  500 return
      end
c----------------------------------------------------------------------
      subroutine xy2uwcw(x,y)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                XY2UWCW
c                R. Yamartino, D. Strimaitis, SRC
c
c --- PURPOSE:  Transform the NSIDE vertex coordinates, (XVERT,YVERT),
c               relative to the receptor coordinates (X,Y),
c               into upwind/crosswind frame vectors (XV,YV).
c               Also compute upwind distance from receptor to the
c               upwind corner of the block of line sources (if modeled)
c
c --- UPDATE
c --- V4.0-V5.0     971107  (DGS): add variable line source treatment
c
c
c --- INPUTS:
c
c              X    - real    - Receptor X coordinate (m).
c              Y    - real    - Receptor Y coordinate (m).
c
c     Common Block /CURRENT/ variables:
c        XB1, YB1, ZB1, SYB1, SZB1,
c        XE1, YE1, ZE1, SYE1, SZE1,
c        XB2, YB2, ZB2, SYB2, SZB2,
c        XE2, YE2, ZE2, SYE2, SZE2,
c        IAGE, SPEEDI, SRAT, TEMIS,
c        NSIDE, XVERT, YVERT, XSHIFT
c
c --- OUTPUTS:
c
c     Common Block /CURRENT/ variables:
c             XV    - real    - Receptor/vertex upwind distances (m)
c             YV    - real    - Receptor/vertex crosswind distances (m)
c        XUPEDGE    - real    - Distance from receptor to upwind edge
c                               of block of line sources (m)
c
c     Common Block /SLGLIN/ variables:
c          DXY12    - real    - Projection of fully-extended slug length
c                               on the x-y plane (m)
c         RDXY12    - real    - Reciprocal of DXY12
c
c --- XY2UWCW called by:  AREAINT
c --- XY2UWCW calls:       none
c----------------------------------------------------------------------
c
      include 'params.puf'
      include 'current.puf'

      common /SLGLIN/ dxy12,rdxy12
c
c --- Determine the length and orientation of the final slug
c --- emitted from the center of the polygon area source.
c --- XE1,YE1 are the final coordinates of the slug end-point.
c --- XB2,YB2 are the initial coordinates of the slug end-point.
c --- Note that there is no change in (XB2,YB2) over time.
      X12 = XE1 - XB2
      Y12 = YE1 - YB2
c --- DXY12 is the projection of the slug length on the x-y plane.
      DXY12 = SQRT(X12*X12 + Y12*Y12)
      RDXY12 = 1.0 / DXY12
c --- Note that the angles are defined cw (clockwise) from North.
c --- Define the cos and sin of omega.
c --- note that omega = wind direction (met.) + pi in this case !
      COSOM = Y12 * RDXY12
      SINOM = X12 * RDXY12
c
c --- Begin loop over array vertices.
      do i=1,nside
c ---    Define the vertex-receptor relative position.
         xr = xvert(i) - x
         yr = yvert(i) - y
c ---    Convert to upwind (=-downwind) and crosswind distances.
         xv(i) = -(yr * cosom  +  xr * sinom)
         yv(i) =  -xr * cosom  +  yr * sinom
      enddo
c
c --- For line sources, determine distance from upwind edge of block
c --- of line sources to this receptor
      if(istype.EQ.5 .OR. istype.EQ.6) then
c ---    Source-receptor relative position
         xr = xb2 - x
         yr = yb2 - y
c ---    Convert to upwind (=-downwind) distance
         xline = -(yr * cosom  +  xr * sinom)
c ---    Add distance between upwind edge and source
         xupedge = xline + xshift
      endif
c
      return
      end
c----------------------------------------------------------------------
      real function vecmin(n,xv)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 931228                 VECMIN
c                R. Yamartino, SRC
c
c --- PURPOSE:  For an N element array of values, XV,
c               determine the minimum value.
c
c --- INPUTS:
c
c             N     - integer - Number of elements in XV
c             XV    - real    - Array of values.
c
c
c --- OUTPUTS:
c
c           VECMIN  - real    - Minimun value found.
c
c
c --- VECMIN called by:  AREAINT
c --- VECMIN calls:       none
c----------------------------------------------------------------------
c
      real xv(n)
      data big/1.0e+20/
c
      xmin =  big
c
c --- Loop over array elements.
      do i=1,n
         xmin = amin1(xmin,xv( i ))
      enddo
      vecmin = xmin
c
      return
      end
c----------------------------------------------------------------------
      real function vecmax(n,xv)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 931228                 VECMAX
c                R. Yamartino, SRC
c
c --- PURPOSE:  For an N element array of values, XV,
c               determine the maximum value.
c
c --- INPUTS:
c
c             N     - integer - Number of elements in XV
c             XV    - real    - Array of values.
c
c --- OUTPUTS:
c
c           VECMAX  - real    - Maximun value found.
c
c --- VECMAX called by:  AREAINT
c --- VECMAX calls:       none
c----------------------------------------------------------------------
c
      real xv(n)
      data big/1.0e+20/
c
      xmax = -big
c
c --- Loop over array elements.
      do i=1,n
         xmax = amax1(xmax,xv( i ))
      enddo
      vecmax = xmax
c
      return
      end
c----------------------------------------------------------------------
      subroutine extreme(n,xv,xmin,xmax)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 931228                EXTREME
c                R. Yamartino, SRC
c
c --- PURPOSE:  For an N element array of values, XV, determine the
c               min./max. values and return as XMIN, XMAX.
c
c --- INPUTS:
c
c             N     - integer - Number of elements in XV
c             XV    - real    - Array of values.
c
c --- OUTPUTS:
c
c             XMIN  - real    - Minimun value found.
c             XMAX  - real    - Maximun value found.
c
c --- EXTREME called by:  AREAINT
c --- EXTREME calls:       none
c----------------------------------------------------------------------
c
      real xv(n)
      data big/1.0e+20/
c
      xmin =  big
      xmax = -big
c
c --- Loop over array elements.
      do i=1,n
         xmin = amin1(xmin,xv( i ))
         xmax = amax1(xmax,xv( i ))
      enddo
c
      return
      end
c----------------------------------------------------------------------
      subroutine cwyvals(nside,xv,yv,x,ymin,ymax,nhits)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 931228                CWYVALS
c                R. Yamartino, SRC
c
c --- PURPOSE:  For an NSIDEd polygon area source with vertices at
c               (upwind,crosswind) coordinates (XY,YV), relative to the
c               receptor at (0,0), determine the CrossWind Y VALS of
c               the polygon boundary intercepted by the cwosswind
c               line at upwind distance X.  The min./max. values are
c               computed and returned in YMIN/YMAX and the number of
c               legitimate values returned in NHITS.  Three values of
c               NHITS are possible.
c
c --- INPUTS:
c
c             NSIDE - integer - Number of sides (>3) for the polygon.
c             XV    - real    - Upwind distances of polygon vertices.
c             YV    - real    - Crosswind coords. of polygon vertices.
c             X     - real    - Upwind distance for eval. of YMIN/YMAX
c
c --- OUTPUTS:
c
c             YMIN  - real    - Minimun value of crosswind intercept.
c             YMAX  - real    - Maximun value of crosswind intercept.
c             NHITS - integer - Number of valid crosswind intercepts.
c                               NHITS = 0 => No crosswind intercepts
c                                            (e.g., X outside polygon)
c                               NHITS = 1 => 1 intercepts at a vertex.
c                               NHITS = 2 => 2 side intercepts.
c
c --- CWYVALS called by:  AREAINT, LSSLINT
c --- CWYVALS calls:       none
c----------------------------------------------------------------------
c
c --- SUPPLEMENTAL NOTES
c
c --- This subroutine may also be called with interchanged (XV,YV)
c     arguments to determine intercepts XMIN,XMAX at a specific value
c     of the coordinate Y.
c----------------------------------------------------------------------
c
      real xv(nside),yv(nside)
      data zero/0.0/,big/1.0e+20/
c
      ymin =  big
      ymax = -big
      nhits = 0
c
c *** Begin loop over all polygon segments.
      do 10 i=1,nside
      if(i.eq.nside) then
         ip1 = 1
         else
         ip1 = i + 1
      endif
c
      xt1 = xv( i ) - x
      xt2 = xv(ip1) - x
c
c --- Quit if X lies outside of the two ends of the segment.
      if((xt1*xt2).gt.zero) go to 10
c
c --- Test if intercept occurs at endpoint (e.g., a vertex hit)
      if(xt1.eq.zero) then
         ymin = amin1(ymin,yv( i ))
         ymax = amax1(ymax,yv( i ))
         nhits = nhits + 1
      endif
c
      if(xt2.eq.zero) then
         ymin = amin1(ymin,yv(ip1))
         ymax = amax1(ymax,yv(ip1))
         nhits = nhits + 1
      endif
c
      xtot = xt1 - xt2
c --- Quit if zero x-length segment as could only be end-point hit.
      if(xtot.eq.zero) go to 10
c     Define frac in range zero to one.
      frac = xt1 / xtot
      ytot = yv(i) - yv(ip1)
      y = yv(i) - frac * ytot
c
      ymin = amin1(ymin,y)
      ymax = amax1(ymax,y)
      nhits = nhits + 1
c
   10 continue
c
c --- Quit if X lies outside of the two ends of the segment.
      ytot = ymax - ymin
      if(ytot.lt.zero) nhits = 0
      if(nhits.eq.0) go to 20
c
c --- Must be 2 hits (e.g., vertex hit) or more, so set NHITS = 1.
      nhits = 1
c --- If the hits are separated in space then there are NHITS = 2.
      if(ytot.gt.zero) nhits = 2
c
   20 continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine cpqromb(xlower,xupper,lwflux,z,hlid,hlidmax,
     x                   zrterr,zstak,zbase,ppc,eps,
     x                   ss1,ss2,ss3,ss4)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                CPQROMB
c                R. Yamartino
c
c --- PURPOSE:  Performs Romberg integration of the polygon segment
c               in the upwind distance domain (XLOWER,XUPPER) via
c               calls to the slug line source routine LSSLINT.
c
c               Adapted to integration of multiple quantities from
c               QROMB Module of ISC2 Short Term Model - ISCST2
c
c               which performs Romberg Integration of Function Using
c               Polynomial Extrapolation for h=0 With h1(i)=h1(i-1)/4
c               Modifed To Use Variable Order Extrapolation
c
c               (as programmed on July 7, 1993 by:
c                    Jeff Wang, Roger Brode  and
c                    Adapted From Codes By Richard Strelitz, CSC)
c
c --- UPDATE
c --- V5.0-V5.8.4   130731  (EPA): add HLIDMAX for use in VCOUP
c --- V5.0-V5.0     980430  (DGS): drop dt from argument list
c --- V4.0-V5.0     971107  (DGS): add eps variable to calling arguments
c
c --- INPUTS:
c
c            XLOWER - real    - Lower limit (m) for the integration.
c            XUPPER - real    - Upper limit (m) for the integration.
c            LWFLUX - logical - Receptor specific wet deposition flag
c                                .true. if calculation is to be made
c                                .false. if not.
c                 Z - real    - Z coord. of receptor.
c              HLID - real    - Relevant mixing depth (m) at receptor.
c           HLIDMAX - real    - Maximum lid height (m) for mass
c                               above HLID
c            ZRTERR - real    - Terrain elevation (m MSL) at receptor
c             ZSTAK - real    - Stack height of source of puff (m)
c             ZBASE - real    - Stack base elevation MSL (m)
c               PPC - real    - Plume Path Coefficient
c               EPS - real    - Tolerance limit for integral convergence
c
c --- OUTPUTS:
c
c            SS1    - real    - Coupling coeff. (s/m**3) #1
c            SS2    - real    - Coupling coeff. (s/m**3) #2
c            SS3    - real    - Coupling coeff. (s/m**2) #3
c            SS4    - real    - Coupling coeff. (s/m**2) #4
c
c --- CPQROMB called by:  AREAINT
c --- CPQROMB calls:      CPTRAP, POLINT
c----------------------------------------------------------------------

c --- Declarations
      parameter(K1 = 5, JMAX1 =10, ITMAX =100, EPS2 = 1.0E-20)
c *** parameter(K1 = 5, JMAX1 =10, ITMAX =100, EPS = 1.0E-6,
c ***&          EPS2 = 1.0E-20)
C**   K1    = Order of Extrapolating Polynomial
C**   JMAX1 = Maximum Number of Iterations in Halving Interval
C**   ITMAX = Maximum Number of Integral Iterations
C**   EPS   = Tolerance Limit for Convergence of the Integral
C**   EPS2  = Lower Threshold Limit for the Value of the Integral
      real s1(21), h1(21)
      real s2(21), s3(21), s4(21)
      logical lwflux
      data zero/0.0/,one/1.0/

c --- Initialize
      do j=1,jmax1
         H1(j) = zero
         s1(j) = zero
         s2(j) = zero
         s3(j) = zero
         s4(j) = zero
      enddo
      H1(1) = one

      call cptrap(xlower,xupper,lwflux,z,hlid,hlidmax,
     x            zrterr,zstak,zbase,ppc,
     x            s1(1),s2(1),s3(1),s4(1),1)
      ss1 = s1(1)
      ss2 = s2(1)
      ss3 = s3(1)
      ss4 = s4(1)

      do j = 2, jmax1
         h1(j) = 0.25*h1(j-1)
c ---    Obtain samples for all four integrals at once.
         call cptrap(xlower,xupper,lwflux,z,hlid,hlidmax,
     x               zrterr,zstak,zbase,ppc,
     x               s1(j),s2(j),s3(j),s4(j),j)
         kp = MIN0(j,k1)-1
c ---    Estimate all four integrals at once.
         call polint(h1(J-kp),s1(j-kp),kp+1,ss1,dss1)
         call polint(h1(j-kp),s2(j-kp),kp+1,ss2,dss2)
         call polint(h1(j-kp),s3(j-kp),kp+1,ss3,dss3)
         call polint(h1(j-kp),s4(j-kp),kp+1,ss4,dss4)
C***********************************************************************
C        Check The Convergence Criteria:
C        EPS is tolerance level for convergence of the integral,
C          initially set = 1.0E-4 in a PARAMETER statement in MAIN1.INC;
C        EPS2 is lower threshold for the integral, initially set = 1.0E-10
C          in a PARAMETER statement in MAIN1.INC;
C        J is number of halving intervals and must be at least 3 for
C          convergence criteria to be met.  Maximum number of intervals
C          is set by JMAX1 (=10).
C***********************************************************************
c ---    Consider the convergence of only one of the four integrals
         if ((abs(dss3) .le. eps*abs(ss3) .or. abs(ss3*dss3)
     &                  .le. eps2) .and. j .ge. 3) goto 999
      enddo

 999  return
      end
c----------------------------------------------------------------------
      subroutine cptrap(xlower,xupper,lwflux,z,hlid,hlidmax,
     x                 zrterr,zstak,zbase,ppc,
     x                 val1,val2,val3,val4,n)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 CPTRAP
c                R. Yamartino
c
c --- PURPOSE:  Performs Trapezoidal integration of polygon segment
c               in the upwind distance domain (XLOWER,XUPPER) via
c               calls to the slug line source routine LSSLINT.
c
c               Adapted to integration of multiple quantities from
c               TRAPZD Module of ISC2 Short Term Model - ISCST2
c               which performs standard trapezoidal integration for 2-d
c               integrals.
c               (as programmed on July 7, 1993 by:
c                    Jeff Wang, Roger Brode  and
c                    Adapted From Codes By Richard Strelitz, CSC)
c
c --- UPDATE
c --- V5.0-V5.8.4   130731  (EPA): add HLIDMAX for use in VCOUP
c --- V5.0-V5.0     980430  (DGS): drop dt from argument list
c
c --- INPUTS:
c
c            XLOWER - real    - Lower limit (m) for the integration.
c            XUPPER - real    - Upper limit (m) for the integration.
c            LWFLUX - logical - Receptor specific wet deposition flag
c                                .true. if calculation is to be made
c                                .false. if not.
c                 Z - real    - Z coord. of receptor (m).
c              HLID - real    - Relevant mixing depth (m) at receptor.
c           HLIDMAX - real    - Maximum lid height (m) for mass
c                               above HLID
c            ZRTERR - real    - Terrain elevation (m MSL) at receptor
c             ZSTAK - real    - Stack height of source of puff (m)
c             ZBASE - real    - Stack base elevation MSL (m)
c               PPC - real    - Plume Path Coefficient
c
c --- OUTPUTS:
c
c           VAL1    - real    - Coupling coeff. (s/m**3) #1
c           VAL2    - real    - Coupling coeff. (s/m**3) #2
c           VAL3    - real    - Coupling coeff. (s/m**2) #3
c           VAL4    - real    - Coupling coeff. (s/m**2) #4
c
c --- CPTRAP called by:  CPQROMB
c --- CPTRAP calls:      RECSPEC0, LSSLINT
c----------------------------------------------------------------------

      real del, sum1, sum2, sum3, sum4, sval1, sval2, sval3, sval4
      save neval2, sval1, sval2, sval3, sval4
      logical lwflux
      data zero/0.0/

      if(n .EQ. 1) then
         call recspec0(xupper,zrterr,zstak,zbase,ppc,
     &                 syr,szr,zpr)
         call lsslint(xupper,lwflux,z,zpr,syr,szr,hlid,hlidmax,
     x                sum11,sum21,sum31,sum41)

         call recspec0(xlower,zrterr,zstak,zbase,ppc,
     &                 syr,szr,zpr)
         call lsslint(xlower,lwflux,z,zpr,syr,szr,hlid,hlidmax,
     x                sum12,sum22,sum32,sum42)

         sum1 = sum11 + sum12
         sum2 = sum21 + sum22
         sum3 = sum31 + sum32
         sum4 = sum41 + sum42
c
         del = xupper-xlower
         sval1 = zero
         sval2 = zero
         sval3 = zero
         sval4 = zero
         neval2 = 1
      else
         del = (xupper-xlower)/neval2
         x1 = xlower+del*0.5
         sum1 = zero
         sum2 = zero
         sum3 = zero
         sum4 = zero
         do i = 1,neval2
            call recspec0(x1,zrterr,zstak,zbase,ppc,
     &                    syr,szr,zpr)
            call lsslint(x1,lwflux,z,zpr,syr,szr,hlid,hlidmax,
     x                   sumc1,sumc2,sumc3,sumc4)
            sum1 = sum1 + sumc1
            sum2 = sum2 + sumc2
            sum3 = sum3 + sumc3
            sum4 = sum4 + sumc4
            x1 = x1+del
         enddo
         neval2 = neval2*2
      endif
c
      val1 = 0.5 * (sval1 + del*sum1)
      sval1 = val1
c
      val2 = 0.5 * (sval2 + del*sum2)
      sval2 = val2
c
      val3 = 0.5 * (sval3 + del*sum3)
      sval3 = val3
c
      val4 = 0.5 * (sval4 + del*sum4)
      sval4 = val4
c
      return
      end
c----------------------------------------------------------------------
      subroutine lsslint(rhoa,lwflux,z,zpr,syr,szr,hlid,hlidmax,
     &                   ccqb,ccdq,ccizqb,ccizdq)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                LSSLINT
c                R. Yamartino
c
c --- PURPOSE:  Computes the time-average coupling coefficients (s/m**3)
c               at the downwind dist. RHOA for the time period T to T+DT
c               for a crosswind line source.
c
c --- UPDATE
c --- V5.0-V5.8.4   130731  (EPA): add HLIDMAX for use in VCOUP and
c                                  allow receptor to sample mass above
c                                  lid
c --- V4.0-V5.0     971107  (DGS): pass ICODE to VCOUP from /CURRENT/
c --- V4.0-V4.07    971107  (DGS): add PDF logic (call PDFPATH)
c
c --- INPUTS:
c
c              RHOA - real    - Downwind line/receptor distance (m).
c            LWFLUX - logical - Receptor specific wet deposition flag
c                                .true. if calculation is to be made
c                                .false. if not.
c                 Z - real    - Height (m) receptor above ground
c               ZPR - real    - Height (m) of the plume above receptor
c                               terrain height (allowing for terr adj)
c         (SYR,SZR) - real    - Sigmas at the receptor before T factor.
c              HLID - real    - Relevant mixing depth (m) at receptor.
c           HLIDMAX - real    - Maximum lid height (m) for mass
c                               above HLID
c
c     Common Block /CURRENT/ variables:
c        SYB2, SPEEDI, SRAT, ICODE
c     Common Block /PDF/ variables:
c        LPDF, SWUPF, SWDNF, SZUPB, SZDNB, WTUP, WTDN, ZUP, ZDN, RFACSQ
c     Parameters:
c        MXVERT
c
c --- OUTPUTS:
c
c              CCQB - real    - Coupling coefficient (s/m**3) for
c                               the source rate ,QB, at the
c                               beginning of the time step.
c              CCDQ - real    - Coupling coefficient (s/m**3) for
c                               the change in source rate, DQ, between
c                               the beginning and end of the time step.
c            CCIZQB - real    - Z-integrated coefficient (s/m**2) for
c                               the source rate ,QB, at the
c                               beginning of the time step.
c            CCIZDQ - real    - Z-integrated coefficient (s/m**2) for
c                               the change in source rate, DQ, between
c                               the beginning and end of the time step.
c
c --- LSSLINT called by:  CPTRAP
c --- LSSLINT calls:      CWYVALS, VCOUP, XERFDIF, ERF, ERFDIF, PDFPATH
c----------------------------------------------------------------------
c
c --- Include common blocks
      include 'params.puf'
      include 'current.puf'
      include 'pdf.puf'

      common /SLGLIN/ dxy12,rdxy12
c
      logical lwflux
c
      data srthaf/0.7071/,half/0.5/,small/1.0e-10/
      data fourth/0.25/
      data erfcut/3.0/
c
      ccqb = 0.0
      ccdq = 0.0
      ccizqb = 0.0
      ccizdq = 0.0
c
      call cwyvals(nside,xv,yv,rhoa,rhoc1,rhoc2,nhits)
      if(nhits.lt.2) go to 100
c
c --- Note that for Z coordinates, we take receptor-specific value
      zp = zpr
c
c --- Use actual values of sigmas at receptor. T factor is 1 for IAGE=0
c --- 12/3/89 Protect against divide by sigma of zero.
      sy = amax1(syr,small)
      sz = amax1(szr,small)
c
c --- All coordinates ready ! now compute coupling coefficient for
c --- a unit source (Q = 1 ug/sec)
c
c --- Check if any vertical coupling.
c --- vert = vcoup(icode,z,zp,sz,hlid) includes the 1/sqrt(2*pi) and
c --- the sum over all reflection terms.
      if(LPDF .AND. z.LE.hlid) then
c ---    Find the travel time to the receptor
         trec=AMAX1(0.0,rhoa/speedi)
         call PDFPATH(zp,hlid,trec)
         szsq=sz**2
         szdn=SQRT(szsq*swdnf+szdnb*rfacsq)
         szup=SQRT(szsq*swupf+szupb*rfacsq)
         vert= wtdn*VCOUP(icode,z,zdn,szdn,hlid,hlidmax) +
     &         wtup*VCOUP(icode,z,zup,szup,hlid,hlidmax)
      else
         vert = vcoup(icode,z,zp,sz,hlid,hlidmax)
      endif
c
c --- No longer always skip if no vertical coupling !!  11/12/88
      IF(.not.lwflux .and. vert .LT. SMALL) GO TO 100
c
c --- Check if any cross-slug distance coupling.
      phic1 = srthaf * srat * rhoc1 / sy
      phic2 = srthaf * srat * rhoc2 / sy
      expy = half * erfdif(phic2,phic1)
      if(expy .LT. small) goto 100
c
c --- Check if any along-slug distance coupling.
c --- 12/3/89 Protect against divide by sigma of zero.
      phia2 = srthaf * rhoa / amax1(syb2,small)
      eta2 = srthaf * (rhoa - dxy12) / sy
c
c --- For ETA1, I need the slug length at the beginning of the
c --- time step.  this is usually zero but may not be if we allow
c --- for prolonged steady-state releases somehow. however, this
c --- would then require a mechanism for telling this routine
c --- that IAGE > 0 but all conditions (e.g., met., source strength)
c --- are unchanged. since this may never be implemented, assume zero
c --- slug length and set ETA1 = PHIA2
c --- Modify eta1 to use sigma y at receptor rather than at source
      eta1 = srthaf * rhoa / sy
c
c --- Eliminate cases beyond the causal frontier.
c --- IF(ETA1.GT.ERFCUT .AND. ETA2.GT.ERFCUT) GO TO 100 for downwind
c --- receptors, but in general (including upwind receptors)
c --- consider the following approach.
      prod = eta2 * eta1
      if(prod.GT.0.0 .AND. abs(eta1).GT.erfcut .AND.
     &                     abs(eta2).GT.erfcut) goto 100
c
c --- Compute the causality factors FCAUS0 AND FCAUS1.
c --- For this I need the VMWS = speedi * srat
c --- coeff = sy / ( vmws * dt )
      erfa2 = 1.0
      if(phia2.LT.0.0) erfa2 = -1.0
      if(abs(phia2) .LE. erfcut) erfa2 = erf(phia2)
      coeff = SRTHAF/(eta1-eta2)
      coeff2 = coeff * coeff
c
      call xerfdif(eta2,eta1,xint0,xint1)
c
      fcaus0 = half * erfa2  +  srthaf * coeff * xint0
c
      fcaus1 = fourth * erfa2  -  coeff2 * xint1  +
     x         srthaf * coeff2 * ( rhoa / sy ) * xint0
c
c --- Compute the time-average conc. terms for unit emission rate line!
      ccoup = expy  / speedi
      if(ccoup .lt. small) go to 100
c
      if(fcaus0 .gt. small) then
         ccizqb = ccoup * fcaus0
         ccqb = vert * ccizqb
      endif
c
      if(fcaus1 .gt. small) then
         ccizdq = ccoup * fcaus1
         ccdq = vert * ccizdq
      endif
c
c*****
c *** write(6,*)'LSSLINT -- New slug -- vert = ',vert,
c ***1 '  expy = ',expy,'  speedi = ',speedi,'  sy = ',sy,
c ***2 '  sz = ',sz
c*****
c
c*****
c *** write(6,*)'SUBR. LSSLINT -- CCQB = ',ccqb,' CCDQ = ',ccdq,
c ***1 ' CCIZQB = ',ccizqb,' CCIZDQ = ',ccizdq,' DSAMP = ',dsamp
c ****
c
  100 return
      end
c----------------------------------------------------------------------
      subroutine polint(xa,ya,n1,y1,dy1)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 931229                 POLINT
c                R. Yamartino, SRC
c
c --- PURPOSE:  Computes Y(X) as Interpolation of XA, YA
c
c               Except for altered COMMOMs this is a copy of the
c               POLINT Module of ISC2 Short Term Model - ISCST2
c
c               (as programmed on July 7, 1993 by:
c                    Jeff Wang, Roger Brode  and
c                    Adapted From Codes By Richard Strelitz, CSC)
c
c --- INPUTS:
c
c             XA    - real    - The edge pairs
c             YA    - real    - The dimension of the edge pairs.
c
c --- OUTPUTS:
c
c             Y1    - real    - Interpolated value of YA relative to XA
c
c --- POLINT called by:  CPQROMB
c --- POLINT calls:      none
c----------------------------------------------------------------------

C     Variable Declarations
c     INCLUDE 'MAIN1.INC'
c     INCLUDE 'MAIN2.INC'
c     INCLUDE 'MAIN3.INC'
      PARAMETER (K1 = 5, JMAX1 =10, ITMAX =100, EPS = 1.0E-6,
     &           EPS2 = 1.0E-20)
C**   K1    = Order of Extrapolating Polynomial
C**   JMAX1 = Maximum Number of Iterations in Halving Interval
C**   ITMAX = Maximum Number of Integral Iterations
C**   EPS   = Tolerance Limit for Convergence of the Integral
C**   EPS2  = Lower Threshold Limit for the Value of the Integral

      DIMENSION XA(N1),YA(N1),C1(JMAX1),D1(JMAX1)

C     Variable Initializations
c     MODNAM = 'POLINT'

      ns = n1
      y1 = ya(ns)
c     dIFt = abs(xa(n1))
C     Set Up Interpolation/Divided Differences
      do 11 i = 1,n1
         c1(i) = ya(i)
         d1(i) = ya(i)
  11  CONTINUE

C     Compute Table Entries
      ns = ns-1
      do 13 m1 = 1,n1-1
         do 12 i = 1,n1-m1
            ho = xa(i)
            hp = xa(i+m1)
            w = c1(i+1)-d1(i)
            den = w/(ho-hp)
            d1(i) = hp*den
            c1(i) = ho*den
  12     CONTINUE
         IF (2*ns .lt. n1-m1) THEN
            dy1 = c1(ns+1)
         else
            dy1 = d1(ns)
            ns = ns-1
         END IF
         y1 = y1+dy1
  13  CONTINUE

      RETURN
      END
c----------------------------------------------------------------------
      subroutine calcpf(xold,yold,xnew,ynew,ppc,istab,iru,sigv,sigw,
     1                  el,bvf,uavg,dpbl,qold,qnew,qoldup,qnewup,icode,
     2                  hlid,hlidmax,puffr,vdpvd,nspec,q01wet,q01dry,
     3                  vd,fracwet,tsampi,tfract,ldbhr,lcalm,lclip)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 CALCPF
c                J. Scire, D. Strimaitis
c
c --- PURPOSE:  For a given puff, perform the loop over all receptors
c               for each species. Time-averaged coupling coefficients
c               are used to compute concentration and wet and dry
c               deposition fluxes.
c
c --- UPDATE
c --- V5.834-V5.8.4 130731  (EPA): Fix number of arguments in VCOUP
c                                  call for PDF section of loop
c                                  over CTSG receptors in CALMS
c --- V5.82-V5.8.4  130731  (EPA): Restrict deposition fluxes to
c                                  receptors that are located ON
c                                  the ground
c                           (EPA): Allow elevated receptors to sample
c                                  mass aloft (only discrete recs can
c                                  be elevated)
c --- V5.75-V5.8.4  130731  (EPA): Fix bug in wet flux calculation.
c                                  Horizontal sampling factors were
c                                  calculated only if mass diffused to
c                                  the surface, but are also needed for
c                                  washout.
c --- V5.7-V5.75    050225  (DGS): Add DPBL arg to pass on to PUFRECS
c                                  for SETCSIG and TAULY
c --- V5.4-V5.7     030402  (DGS): Drop impact at receptors in/near
c                                  cavity zone for PRIME downwash
c --- V5.0-V5.4     000602  (DGS): add temperature excess logic (FOG)
c                                  at discrete receptors
c --- V5.0-V5.0     990228b (DGS): add non-zero receptor height
c --- V5.0-V5.0     980918  (DGS): add factor to estimate non-Gaussian
c                                  horizontal distribution (area source)
c --- V4.0-V5.0     971107  (DGS): use effective "pole" height from
c                                  call to PUFRECS
c                   971107  (DGS): add ICODE to VCOUP calls
c --- V4.0-V4.07    971107  (DGS): add PDF logic (call PDFPATH)
c
c --- INPUTS:
c
c         XOLD,YOLD - real    - Starting position (m)
c         XNEW,YNEW - real    - Ending position (m)
c               PPC - real    - Plume Path Coefficient
c             ISTAB - integer - PGT stability class
c               IRU - integer - Rural(0) or urban(1) flag
c              SIGV - real    - Sigma-v velocity (m/s)
c              SIGW - real    - Sigma-w velocity (m/s)
c                EL - real    - Monin-Obukhov length (m)
c               BVF - real    - Brunt-Vaisala frequency (1/s)
c              UAVG - real    - Mean transport speed (m/s) over xtotm
c              DPBL - real    - Depth of PBL (m)
c       QOLD(nspec) - real    - Puff mass (g) at beginning of time step
c       QNEW(nspec) - real    - Puff mass (g) at end of time step
c     QOLDUP(nspec) - real    - Puff mass (g) aloft at beginning of
c                               time step
c     QNEWUP(nspec) - real    - Puff mass (g) aloft at end of time
c                               step
c             ICODE - integer - Code for vertical layering of puff
c              HLID - real    - Height of reflection lid (m)
c           HLIDMAX - real    - Maximum lid height (m) for mass
c                               above HLID
c             PUFFR - real    - Puff radius in computational grid units
c      VDPVD(nspec) - real    - Conc. correction factor (vd'/vd) used
c                               to estimate effect of dry deposition and
c                               vertical mixing on near-surface concs.
c             NSPEC - real    - Number of species
c  Q01WET(mxspec,2) - real    - Puff mass before/after wet removal (g)
c  Q01DRY(mxspec,2) - real    - Puff mass before/after dry removal (g)
c         VD(nspec) - real    - Dry deposition velocity (m/s) for each
c                               species
c    FRACWET(nspec) - real    - Fraction of mass left in puff after wet
c                               removal
c            TSAMPI - real    - 1.0/(TSAMP)
c            TFRACT - real    - 1./(number of samples in averaging pd)
c             LDBHR - logical - Debug output (T,F)
c             LCALM - logical - .TRUE. if this puff is in a calm
c             LCLIP - logical - .TRUE. if receptor-specific sigmas are
c                               limited to range defined by values at
c                               the start/end of step
c
c     Common Block /FLAGS/ variables:
c        MCTADJ
c     Common Block /FOG/ variables:
c        LADTFOG, TXSMXFOG
c     Common Block /PDF/ variables:
c        LPDF, SWUPF, SWDNF, SWUPB, SWDNB, WTUP, WTDN, ZUP, ZDN, RFACSQ
c     Parameters:
c        MXNX, MXNY, NSPEC, MXNXG, MXNYG, MXREC, IO6
c
c --- OUTPUTS:
c
c     Common block /CHIFLX/ variables:
c        CHISAM(mxnxg,mxnyg,mxspec),DFSAM(mxnxg,mxnyg,mxspec),
c        WFSAM(mxnxg,mxnyg,mxspec),CHIREC(mxrec,mxspec),
c        DFREC(mxrec,mxspec),WFREC(mxrec,mxspec),
c        CHICT(mxrect,mxspec)
c
c --- CALCPF called by:  COMP
c --- CALCPF calls:      PFSCRN, PUFRECS, PFSAMP, VCOUP, PDFPATH,
c                        ASDF
c----------------------------------------------------------------------
c --- Adapted from:
c --- MESOPUFF II   VERSION 5.1   LEVEL 921025                   GRICN2
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'chiflx.puf'
      include 'ctsgdat.puf'
      include 'flags.puf'
      include 'fog.puf'
      include 'grid.puf'
      include 'nongrd.puf'
      include 'pdf.puf'
c
      real qold(nspec),qnew(nspec),vdpvd(nspec)
      real qoldup(nspec),qnewup(nspec)
      real q01wet(mxspec,2),q01dry(mxspec,2),vd(nspec),fracwet(nspec)
      real xadj(mxspec)
      logical ldbhr,lwet,limpact,lcalm,lclip
      logical lup

c --- Set number of sigmas to reach "edge" of puff (check subr. COMP !)
      data nsigma/3/
c
c --- Determine if wet removal is active this step: set adjustment
      lwet=.FALSE.
      if(mwet.EQ.1) then
         do i=1,nspec
            if(fracwet(i).LT.1.0) lwet=.TRUE.
            wetavg=0.5*(q01wet(i,1)+q01wet(i,2))
            if(wetavg.NE.0.0) then
               xadj(i)=tfract*tsampi*q01wet(i,1)/wetavg
            else
               xadj(i)=0.0
            endif
         enddo
      endif
c
c --- Check for mass in lower layer of puff (in contact with ground)
      mass=0
      do is=1,nspec
         if(qold(is).GT.0.0 .OR. qnew(is).GT.0.0) mass=1
      enddo

c --- Check for mass in upper layer of puff
      massup=0
      do is=1,nspec
         if(qoldup(is).GT.0.0 .OR. qnewup(is).GT.0.0) massup=1
      enddo

c --- Calculate vertical distribution factor at surface (uniform ONLY)
      if(icode.EQ.2 .OR. icode.EQ.6) then
c ---    ICODE=2,6:  within past/present mixed layer and uniform
         f1=1./hlid
      elseif(icode .EQ. 4) then
c ---    ICODE=4:  above mixed layer and uniform (no ground-level concs)
         f1=0.
      else
c ---    ICODE ODD: Gaussian,  set f1 to 1.0 for now
         f1=1.0
      endif

c --- Calculate vertical distribution factor aloft
      f1up=0.
      if(icode.EQ.2 .OR. icode.EQ.6) then
c ---    ICODE=2,6:  within past/present mixed layer and uniform
         if(hlidmax.GT.hlid) f1up=1./(hlidmax-hlid)
      elseif(icode .EQ. 4) then
c ---    ICODE=4:  above mixed layer and uniform (concs not defined)
         f1up=0.
      endif
c
c -------------------------------------------------------------
c --- SAMPLING GRID RECEPTOR POINTS  (uses SAMPLING grid units)
c -------------------------------------------------------------
c
      if(.NOT.lsamp) goto 101
c --- There are no elevated receptors here
      if(.NOT.lwet) then
c ---    Skip gridded receptors if no mass in lower layer or
c ---    if vertical factor is zero without wet deposition
         if(mass.EQ.0. OR. f1.EQ.0.) goto 101
      endif

c --- Compute the start of the sampling grid in MET grid units
      xbsamp=float(ibsamp)-0.5
      ybsamp=float(jbsamp)-0.5
c --- Calculate puff center coordinates in SAMPLING grid units
      samxo=(xold-xbsamp)*meshdn+1.0
      samyo=(yold-ybsamp)*meshdn+1.0
      samxn=(xnew-xbsamp)*meshdn+1.0
      samyn=(ynew-ybsamp)*meshdn+1.0
c --- Convert puff radius to SAMPLING grid units
      samr=puffr*meshdn
      samrp1=samr+1.0
      samr2=samr*samr
c
c --- Determine section of grid affected by this puff
      il=amin1(samxo-samrp1,samxn-samrp1,float(nxsam))+0.001
      il=max0(1,il)
      ir=amax1(samxo+samrp1,samxn+samrp1,1.0)+0.001
      ir=min0(nxsam,ir)
      jb=amin1(samyo-samrp1,samyn-samrp1,float(nysam))+0.001
      jb=max0(1,jb)
      jt=amax1(samyo+samrp1,samyn+samrp1,1.0)+0.001
      jt=min0(nysam,jt)
c
c --- Loop over receptors
      do 100 isamp=il,ir
         xr=float(isamp)
         do 100 jsamp=jb,jt
            yr=float(jsamp)
c
c ---       Compute nearest approach of puff to receptor and screen out
c ---       receptors that are too far away
            call pfscrn(samxo,samyo,samxn,samyn,xr,yr,samr2,
     &                  samd2,limpact)
c
            if(.NOT.limpact) goto 100
c
c ---------------------------------------------------------------------
c ---       Obtain receptor-specific sigmas and puff height (gradual
c ---       rise) including any terrain adjustment to height
c ---------------------------------------------------------------------
c ---       Get location of the receptor (m) (on met. grid)
            xrec = xbsamp*dgrid+float(isamp-1)*delsam
            yrec = ybsamp*dgrid+float(jsamp-1)*delsam
            zrec = 0.0
            call pufrecs(lclip,xrec,yrec,zrec,istab,iru,sigv,sigw,el,
     &                   bvf,uavg,dpbl,elevg(isamp,jsamp),ppc,lcalm,
     &                   trec,frec,syrec,szrec,zgrise,zpr,zrpole,
     &                   rfacsq,idrop)
c ---       PRIME downwash:  skip 'dropped' receptors in cavity zone
            if(idrop.EQ.1) goto 100
c
c ---       Check impact based on receptor-specific sigma-y and skip
c ---       this receptor if no impact
c ---       Convert receptor specific sigma-y to SAMPLING grid units
            syrgu=syrec/delsam
c ---       Puff radius (squared) at receptor
            pr2=(nsigma*syrgu)**2
            if(samd2.GT.pr2) goto 100
c
c ***
      if(LDBHR) then
      write(io6,*) 'CALCPF: Grid rec x,y  = ',xrec,yrec
      write(io6,*) '        Trans. Rise   = ',zgrise
      write(io6,*) '        Adj. Puff Ht. = ',zpr
      write(io6,*) '    Adj. Rec Pole Ht. = ',zrpole
      write(io6,*) '       Sigma-y @ rec. = ',syrec
      write(io6,*) '       Sigma-z @ rec. = ',szrec
      write(io6,*) '   Reflecting Lid Ht. = ',hlid
      write(io6,*) '     Time to receptor = ',trec
      write(io6,*) ' G.Rise Adj to BID**2 = ',rfacsq
      endif
c ***
c
            if(mod(icode,2).EQ.1) then
c ---          Sample vertical distribution (GAUSSIAN)
               if(LPDF) then
                  call PDFPATH(zpr,hlid,trec)
                  szrecsq=szrec**2
                  argup=szrecsq*swupf+szupb*rfacsq
                  argdn=szrecsq*swdnf+szdnb*rfacsq
                  szdn=SQRT(argdn)
                  szup=SQRT(argup)
                  f1= wtdn*VCOUP(icode,zrpole,zdn,szdn,hlid,hlidmax) +
     &                wtup*VCOUP(icode,zrpole,zup,szup,hlid,hlidmax)
               else
                  f1=vcoup(icode,zrpole,zpr,szrec,hlid,hlidmax)
               endif
c ***
      if(LDBHR) then
      write(io6,*) '       zrpole, vcoup  = ',zrpole,f1
      endif
c ***
            endif
c
c ---       Sample horizontal distribution if puff impact reaches the
c ---       surface due to diffusion or washout
            if(f1.GT.0. .OR. mwet.EQ.1) then
               call pfsamp(samxo,samyo,samxn,samyn,xr,yr,syrgu,samd2,
     &                    xi1,xi2)
c ---          Normalize horizontal sampling result by 1/(2*pi*syrec^2)
c ---          and scale by the Area Source Distribution Factor
c ---          (nominally 1.0); syrec is in meters;
               samdm=SQRT(samd2)*delsam
               dinv=ASDF(ldbhr,samdm,syrec)/(6.2831853*syrec**2)
               t2=xi2*dinv
               t1=xi1*dinv-t2
c ---          (QOLD*T1+QNEW*T2 IS THE HORIZONTAL TERM * SOURCE TERM OF
c ---           THE GAUSSIAN EQN.)
            endif

c ---       Concentration and Dry Fluxes
            if(f1.GT.0.) then
               xtemp=f1*tfract
               do ipol=1,nspec
                  conc=vdpvd(ipol)*xtemp*(qold(ipol)*t1+qnew(ipol)*t2)
                  chisam(isamp,jsamp,ipol)=chisam(isamp,jsamp,ipol)+conc
                  if(mdry.EQ.1) then
                     dfsam(isamp,jsamp,ipol)=dfsam(isamp,jsamp,ipol)+
     &                    (q01dry(ipol,1)*t1+q01dry(ipol,2)*t2)*
     &                     vd(ipol)*vdpvd(ipol)*xtemp
                  endif
               enddo
            endif
c
c ---       Wet fluxes
            if(mwet.EQ.1) then
               do ipol=1,nspec
                  wfsam(isamp,jsamp,ipol)=wfsam(isamp,jsamp,ipol)+
     &                 (q01wet(ipol,1)*t1+q01wet(ipol,2)*t2)*
     &                 (1.0-fracwet(ipol))*xadj(ipol)
               enddo
            endif
100   continue
101   continue
c
c ----------------------------------------------------
c --- DISCRETE RECEPTOR POINTS  (using MET grid units)
c ----------------------------------------------------
c
      if(nrec.LE.0) goto 201
c
      puffr2=puffr*puffr
c
c --- Loop over receptors
      do i=1,nrec
c
c ---    Compute nearest approach of puff to receptor and screen out
c ---    receptors that are too far away
         call pfscrn(xold,yold,xnew,ynew,xng(i),yng(i),puffr2,
     &               d2,limpact)
c
         if(.NOT.limpact) goto 200
c
c ---------------------------------------------------------------
c ---    Obtain receptor-specific sigmas and puff height (gradual
c ---    rise) including any terrain adjustment to height
c ---------------------------------------------------------------
c ---    Get location of the receptor (m) (on met. grid)
         xrec = xng(i)*dgrid
         yrec = yng(i)*dgrid
         zrec = zng(i)
         call pufrecs(lclip,xrec,yrec,zrec,istab,iru,sigv,sigw,el,bvf,
     &                uavg,dpbl,elevng(i),ppc,lcalm,
     &                trec,frec,syrec,szrec,zgrise,zpr,zrpole,
     &                rfacsq,idrop)
c ---    PRIME downwash:  skip 'dropped' receptors in cavity zone
         if(idrop.EQ.1) goto 200
c
c ---    Check impact based on receptor-specific sigma-y and skip
c ---    this receptor if no impact
c ---    Convert receptor specific sigma-y to MET grid units
         syrgu=syrec*dgridi
c ---    Puff radius (squared) at receptor
         pr2=(nsigma*syrgu)**2
         if(d2.GT.pr2) goto 200
c
c ***
      if(LDBHR) then
      write(io6,*) 'CALCPF: Disc rec x,y,z= ',xrec,yrec,zrec
      write(io6,*) '        Trans. Rise   = ',zgrise
      write(io6,*) '        Adj. Puff Ht. = ',zpr
      write(io6,*) '    Adj. Rec Pole Ht. = ',zrpole
      write(io6,*) '       Sigma-y @ rec. = ',syrec
      write(io6,*) '       Sigma-z @ rec. = ',szrec
      write(io6,*) '   Reflecting Lid Ht. = ',hlid
      write(io6,*) '     Time to receptor = ',trec
      write(io6,*) ' G.Rise Adj to BID**2 = ',rfacsq
      endif
c ***
c
c ---    Set logical for impact of mass aloft at receptor aloft
c ---    (Should only depend on receptor height and
c ---     reflecting height)
         if(zrec.GT.hlid) then
            lup=.TRUE.
         else
            lup=.FALSE.
         endif
         if(mod(icode,2).EQ.1) then
c ---       Sample vertical distribution (GAUSSIAN)
c ---       Allow for elevated receptors above lid
            f1=0.0
            f1up=0.0
            if(LUP) then
               f1up=VCOUP(icode,zrpole,zpr,szrec,hlid,hlidmax)
            elseif(LPDF) then
               call PDFPATH(zpr,hlid,trec)
               szrecsq=szrec**2
               argup=szrecsq*swupf+szupb*rfacsq
               argdn=szrecsq*swdnf+szdnb*rfacsq
               szdn=SQRT(argdn)
               szup=SQRT(argup)
               f1= wtdn*VCOUP(icode,zrpole,zdn,szdn,hlid,hlidmax) +
     &             wtup*VCOUP(icode,zrpole,zup,szup,hlid,hlidmax)
            else
               f1=vcoup(icode,zrpole,zpr,szrec,hlid,hlidmax)
            endif
c ***
      if(LDBHR) then
      write(io6,*) '       zrpole, vcoup f1,f1up  = ',zrpole,f1,f1up
      endif
c ***
         endif
c
c ---    Skip this receptor?
         if(LUP) then
c ---       Must have mass above lid and impact at receptor
            if(f1up.LE.0.0 .OR. massup.LE.0.0) goto 200
         elseif(.not.LWET .OR. zrec.GT.0.0) then
c ---       Wet deposition not done at this receptor
c ---       Must have mass below lid and impact at receptor
            if(f1.LE.0.0 .OR. mass.LE.0.0) goto 200
         endif
c ---    Sample horizontal distribution if puff impact reaches the
c ---    receptor due to diffusion or washout
         call pfsamp(xold,yold,xnew,ynew,xng(i),yng(i),syrgu,d2,
     &               xi1,xi2)
c ---    Normalize horizontal sampling result by 1/(2*pi*syrec^2)
c ---    and scale by the Area Source Distribution Factor
c ---    (nominally 1.0); syrec is in meters;
         dm=SQRT(d2)*dgrid
         dinv=ASDF(ldbhr,dm,syrec)/(6.2831853*syrec**2)
         t2=xi2*dinv
         t1=xi1*dinv-t2

c ---    Use mass in either surface or upper layer depending on receptor
c ---    elevation relative to the reflecting lid
         if(LUP) then
c ---       Compute concentration aloft without surface deposition
c ---       adjustment
            xtemp=f1up*tfract
            do ipol=1,nspec
               conc=xtemp*(qoldup(ipol)*t1+qnewup(ipol)*t2)
               chirec(i,ipol)=chirec(i,ipol)+conc
               if(ipol.EQ.2 .AND. LADTFOG) then
c ---             FOG: SUM the T excess (ipol=2) at receptor but
c ---             do not allow sum to exceed excess at release
                  chirec(i,ipol)=AMIN1(txsmxfog,chirec(i,ipol))
               endif
            enddo
         else
c ---       Compute concentration
            xtemp=f1*tfract
            do ipol=1,nspec
               conc=vdpvd(ipol)*xtemp*(qold(ipol)*t1+qnew(ipol)*t2)
               chirec(i,ipol)=chirec(i,ipol)+conc
               if(ipol.EQ.2 .AND. LADTFOG) then
c ---             FOG: SUM the T excess (ipol=2) at receptor but
c ---             do not allow sum to exceed excess at release
                  chirec(i,ipol)=AMIN1(txsmxfog,chirec(i,ipol))
               endif
            enddo
         endif
c
c ---    Wet fluxes
c ---    Only at the surface
         if(mwet.EQ.1 .AND. zrec.EQ.0.0) then
            do ipol=1,nspec
               wfrec(i,ipol)=wfrec(i,ipol)+
     &              (q01wet(ipol,1)*t1+q01wet(ipol,2)*t2)*
     &              (1.0-fracwet(ipol))*xadj(ipol)
            enddo
         endif
c
c ---    Dry fluxes
c ---    Only at the surface
         if(mdry.EQ.1 .AND. f1.GT.0. .AND. zrec.EQ.0.0) then
            do ipol=1,nspec
               dfrec(i,ipol)=dfrec(i,ipol)+
     &              (q01dry(ipol,1)*t1+q01dry(ipol,2)*t2)*
     &               vd(ipol)*vdpvd(ipol)*xtemp
            enddo
         endif
c
c ---    End computation of impact at receptor
200      continue
c
c --- End loop over discrete receptors
      enddo
c
201      continue
c
c ----------------------------------------------------
c --- CTSG RECEPTOR POINTS  (using MET grid units)
c --- CALM conditions ONLY!
c ----------------------------------------------------
c
      if(nctrec.LE.0 .OR. .NOT.lcalm) return
c --- There are no elevated CTSG receptors and no deposition
c --- Skip CTSG receptors if no mass in lower layer or
c --- if vertical factor is zero
      if(mass.EQ.0. OR. f1.EQ.0.) return
c
      puffr2=puffr*puffr
c
c --- Loop over receptors
      do i=1,nctrec
c
c ---    Compute nearest approach of puff to receptor and screen out
c ---    receptors that are too far away
         call pfscrn(xold,yold,xnew,ynew,xrct(i),yrct(i),puffr2,
     &               d2,limpact)
c
         if(.NOT.limpact) goto 300
c
c ---------------------------------------------------------------
c ---    Obtain receptor-specific sigmas and puff height (gradual
c ---    rise) assuming no terrain adjustment to height
c ---------------------------------------------------------------
c ---    Get location of the receptor (m) (on met. grid)
         xrec = xrct(i)*dgrid
         yrec = yrct(i)*dgrid
         zrec = 0.0
         call pufrecs(lclip,xrec,yrec,zrec,istab,iru,sigv,sigw,el,bvf,
     &                uavg,dpbl,0.0,ppc,lcalm,
     &                trec,frec,syrec,szrec,zgrise,zpr,zrpole,
     &                rfacsq,idrop)
         zrpole=0.0
c ---    PRIME downwash:  skip 'dropped' receptors in cavity zone
         if(idrop.EQ.1) goto 300
c
c ---    Check impact based on receptor-specific sigma-y and skip
c ---    this receptor if no impact
c ---    Convert receptor specific sigma-y to MET grid units
         syrgu=syrec*dgridi
c ---    Puff radius (squared) at receptor
         pr2=(nsigma*syrgu)**2
         if(d2.GT.pr2) goto 300
c
c ***
      if(LDBHR) then
      write(io6,*) 'CALCPF: calm CTSG x,y  = ',xrec,yrec
      write(io6,*) '         Trans. Rise   = ',zgrise
      write(io6,*) '         Adj. Puff Ht. = ',zpr
      write(io6,*) '     Adj. Rec Pole Ht. = ',zrpole
      write(io6,*) '        Sigma-y @ rec. = ',syrec
      write(io6,*) '        Sigma-z @ rec. = ',szrec
      write(io6,*) '    Reflecting Lid Ht. = ',hlid
      write(io6,*) '     Time to receptor = ',trec
      write(io6,*) ' G.Rise Adj to BID**2 = ',rfacsq
      endif
c ***
c
         if(mod(icode,2).EQ.1) then
c ---       GAUSSIAN: sample vertical distribution at the surface if
c ---       non-stable class (dividing streamline is 0); sample at
c ---       receptor elevation above base of hill if stable (impingement
c ---       case)
            if(istab.GT.4) then
               zrpole=elrect(i)-hilldat(4,ihill(i))
               zrpole=amax1(0.0,zrpole)
            else
               zrpole=0.0
            endif
            if(LPDF) then
               call PDFPATH(zpr,hlid,trec)
               szrecsq=szrec**2
               argup=szrecsq*swupf+szupb*rfacsq
               argdn=szrecsq*swdnf+szdnb*rfacsq
               szdn=SQRT(argdn)
               szup=SQRT(argup)
               f1= wtdn*VCOUP(icode,zrpole,zdn,szdn,hlid,hlidmax) +
     &             wtup*VCOUP(icode,zrpole,zup,szup,hlid,hlidmax)
            else
               f1=vcoup(icode,zrpole,zpr,szrec,hlid,hlidmax)
            endif
c ***
      if(LDBHR) then
      write(io6,*) '        zrpole, vcoup  = ',zrpole,f1
      endif
c ***
         endif
c
c ---    Sample horizontal distribution if puff impact reaches the
c ---    surface due to diffusion (no Wet fluxes at CTSG receptors)
         if(f1.GT.0.) then
            call pfsamp(xold,yold,xnew,ynew,xrct(i),yrct(i),syrgu,d2,
     &                  xi1,xi2)
c ---       Normalize horizontal sampling result by 1/(2*pi*syrec^2)
c ---       and scale by the Area Source Distribution Factor
c ---       (nominally 1.0); syrec is in meters;
            dm=SQRT(d2)*dgrid
            dinv=ASDF(ldbhr,dm,syrec)/(6.2831853*syrec**2)
            t2=xi2*dinv
            t1=xi1*dinv-t2
         endif
         if(f1.GT.0.) then
c ---       Compute concentration
            xtemp=f1*tfract
            do ipol=1,nspec
               conc=vdpvd(ipol)*xtemp*(qold(ipol)*t1+qnew(ipol)*t2)
               chict(i,ipol)=chict(i,ipol)+conc
            enddo
         endif
c
c ---    No Wet or Dry fluxes at CTSG receptors!
c
c ---    End computation of impact at receptor
300      continue
c
c --- End loop over CTSG receptors during CALM conditions
      enddo

      return
      end
c----------------------------------------------------------------------
      subroutine pfscrn(xold,yold,xnew,ynew,xrec,yrec,puffr2,
     &                  dist2,limpact)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 950715                 PFSCRN
c                J. Scire, D. Strimaitis,  SRC
c
c --- PURPOSE:  For a given puff and receptor, use the puff radius at
c               the end of the step and the trajectory to screen out
c               cases with zero contribution.
c
c --- INPUTS:   (*  Assumes all distance units are consistent)
c
c         XOLD,YOLD - real    - Starting position (*)
c         XNEW,YNEW - real    - Ending position (*)
c         XREC,YREC - real    - Receptor position (*)
c            PUFFR2 - real    - Square of puff radius at end of step (*)
c
c --- OUTPUTS:
c             DIST2 - real    - Square of distance of closest approach
c                               of puff to receptor (*)
c           LIMPACT - logical - Calculate impact? (TRUE/FALSE)
c
c
c --- PFSCRN called by:  CALCPF
c --- PFSCRN calls:      none
c----------------------------------------------------------------------

      logical limpact

      dx=xnew-xold
      dy=ynew-yold
      dx1=xold-xrec
      dy1=yold-yrec

c --- Length of trajectory
      c1=dx*dx+dy*dy
c
      a=c1/puffr2
c
c --- Calculate distance of closest approach of puff to receptor
      if(a.LT.1.e-4) then
c ---    Prevent numerical problems at very low wind speeds
         dist2=(xrec-(xold+0.5*dx))**2+(yrec-(yold+0.5*dy))**2
      else
         c2=dx*dx1+dy*dy1
         pc=-c2/c1
         pc=amax1(pc,0.0)
         pc=amin1(pc,1.0)
         xpc=xold+dx*pc
         ypc=yold+dy*pc
         dist2=(xrec-xpc)**2+(yrec-ypc)**2
      endif
c
c --- Compare distance to puff radius to determine impact
      if(dist2.GT.puffr2) then
         limpact=.FALSE.
      else
         limpact=.TRUE.
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine pfsamp(xold,yold,xnew,ynew,xrec,yrec,sygu,dist2,
     &                  xi1,xi2)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 950715                 PFSAMP
c                J. Scire,  SRC
c
c --- PURPOSE:  For a given puff and receptor, compute the time-
c               averaged coupling coefficients used to compute
c               concentration and wet and dry deposition fluxes.
c
c --- INPUTS:   (*  Assumes all distance units are consistent)
c
c         XOLD,YOLD - real    - Starting position (*)
c         XNEW,YNEW - real    - Ending position (*)
c         XREC,YREC - real    - Sampling position (*)
c              SYGU - real    - Sigma-y at receptor (*)
c             DIST2 - real    - Square of distance of closest approach
c                               of puff to receptor (*)
c
c --- OUTPUTS:  (unitless)
c               XI1 - real    - Integral I1 in sampling function
c               XI2 - real    - Integral I2 in sampling function
c
c
c --- PFSAMP called by:  CALCPF
c --- PFSAMP calls:      none
c----------------------------------------------------------------------
c --- Adapted from:
c --- MESOPUFF II   VERSION 5.1   LEVEL 920930                   SAMPLE
c----------------------------------------------------------------------

      data rt2/1.4142136/,rtpiby2/1.2533141/

      xi1=0.0
      xi2=0.0

      dx=xnew-xold
      dy=ynew-yold
      dx1=xold-xrec
      dy1=yold-yrec
c
      c1=dx*dx+dy*dy
      tsy=sygu*sygu
      a=c1/tsy
c
c --- Prevent numerical problems at very low wind speeds
      if(a.LT.1.e-4) then
c ---    Factor of 0.5 averages (qold+qnew)
         xi2=0.5*exp(-dist2/(2.*tsy))
         xi1=2.*xi2
         return
      endif
c
      sqrta=sqrt(a)
      sqrt2a=rt2*sqrta
      c2=dx*dx1+dy*dy1
      b=c2/tsy
      c=(dx1*dx1+dy1*dy1)/tsy
c
      xxexp=exp(0.5*(b*b/a-c))
c --- Use error function difference routine
c --- XI1=(rtpiby2/SQRTA)*XXEXP*(ERF((A+B)/SQRT2A)-ERF(B/SQRT2A))
      xi1=(rtpiby2/sqrta)*xxexp*(erfdif((a+b)/sqrt2a,b/sqrt2a))
      b2da=b*b/a
      xi2=-b*xi1/a+(xxexp/a)*(exp(-0.5*b2da)-exp(-0.5*(a+2.*b+b2da)))
      return

      end
c----------------------------------------------------------------------
      subroutine pufrecs(lclip,x,y,z,istab,iru,sigv,sigw,el,bvf,uavg,
     &                   dpbl,zrterr,ppcoef,lcalm,
     &                   trec,frac,syr,szr,hgr,zpr,zrpole,rfacsq,idrop)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                PUFRECS
c                D. Strimaitis
c
c --- PURPOSE:  Computes the receptor-specific sigmas y and z, and
c               finds receptor-specific puff height (gradual rise)
c               with terrain adjustments for PUFFS
c
c --- UPDATE
c --- V5.83-V5.8.4  130731  (EPA): Compute sigmas downwind of the end
c                                  of the PRIME wake table using time
c                                  or distance measured from this point
c                                  rather than interpolating via virtual
c                                  time (distance) at the start and end
c                                  of the sampling step.
c                           (EPA): PRIME wake table sigmas now include
c                                  BID and BIDSQ=0.0, so add BIDSQ to
c                                  test before adjusting
c --- V5.82-V5.8.4  130731  (EPA): Remove stack-tip downwash adjustment
c                                  to gradual rise because adjustment
c                                  is done within GRISE.
c --- V5.760-V5.8.4 130731  (EPA): Check for imet outside valid range
c                                  of 1 to MXMETSAV+1
c --- V5.75-V5.760  070605  (DGS): move CALM re-assignment of IDW0() to
c                                  SETPUF so that downwash effects are
c                                  turned off as soon as a puff reaches
c                                  a calm area (add QA here).
c --- V5.725-V5.75  050225  (DGS): add platform ht to DWSIGS call for
c                                  ISC building downwash (MBDW=1)
c                   050225  (DGS): Add DPBL arg to pass on to SETCSIG
c                                  for TAULY
c --- V5.7-V5.725   050128  (DGS): fix bug that did not update the rise
c                                  factor when the PRIME wake tables are
c                                  used to obtain receptor-specific
c                                  sigmas
c --- V5.7-V5.73    040611  (DGS): add gravitational settling for one
c                                  particle size (plume tilt)
c --- V5.5-V5.7     030402  (DGS): add PRIME downwash gradual rise and
c                                  sigma tables, and add IDROP to skip
c                                  impact at receptors in/near the
c                                  cavity zone (contribution already
c                                  added)
c --- V5.4-V5.5     010730  (DGS): correct initial sigma used with
c                                  downwash sigma
c --- V5.3-V5.4     000602_2(DGS): add initial sigmas to downwash
c                                  sigmas in quadrature
c --- V5.0-V5.3     991222b (DGS): pass momentum flux to STKTIP
c --- V5.0-V5.0     990228a (JSS): screen for zero puff height in
c                                  terrain adjustment (CTADJ=2)
c --- V5.0-V5.0     990228b (DGS): add receptor ht above ground
c --- V5.0-V5.0     980918  (DGS): use quadrature to include initial
c                                  area source size
c --- V5.0-V5.0     980615  (DGS): remove extra sigma-z virtual calls
c --- V5.0-V5.0     980304  (DGS): use SY0,SZ0 for minimum sigmas
c --- V4.0-V5.0     971107  (DGS): compute effective "pole" height
c                                  of receptor for option MCTADJ=2
c                   971107  (DGS): initialize gradual rise at final
c                                  rise for x < 10 "Hb"
c --- V4.0-V4.07    971107  (DGS): add time to receptor and rise factor
c                                  squared to arg list
c --- V4.0-V5.0     971107  (DGS): alter puff height at receptor
c                                  position for option MCTADJ=2
c                   971107  (DGS): use SLGFRAC to provide puff-step
c                                  geometry and relative receptor pos.
c                   971107  (DGS): extrapolate puff sigmas beyond step
c                                  when puff "passes" receptor, even if
c                                  LCLIP is .TRUE.;do not clip distance
c                                  to receptor
c
c --- INPUTS:
c
c             LCLIP - logical - .TRUE. : limit "receptor position" to
c                                        lie within puff trajectory for
c                                        local puff influence
c                               .FALSE.: always use actual receptor
c                                        positionto determine sigmas
c           (X,Y,Z) - real    - Coordinates of the receptor (m), where
c                               Z is above ground, not sea level
c                               NOTE: All Sigmas before any T factors.
c             ISTAB - integer - PGT stability class
c               IRU - integer - Rural(0) or urban(1) flag
c              SIGV - real    - Sigma-v velocity (m/s)
c              SIGW - real    - Sigma-w velocity (m/s)
c                EL - real    - Monin-Obukhov length (m)
c               BVF - real    - Brunt-Vaisala frequency (1/s)
c              UAVG - real    - Mean transport speed (m/s) over xtotm
c              DPBL - real    - Depth of PBL (m)
c            ZRTERR - real    - Terrain elevation (m MSL) at receptor
c            PPCOEF - real    - Plume path coefficient
c             LCALM - logical - .TRUE. if this puff is in a calm
c
c     Common Block /COMPARM/ variables:
c        SYMIN, SZMIN, TBD
c     Common Block /CURRENT/ variables:
c        XB1, YB1, ZB1, SYB1, SZB1,
c        XE1, YE1, ZE1, SYE1, SZE1,
c        xttb1,xtte1,tb1,te1,vsetl,
c        vtyb1,vtzb1,vtye1,vtze1,
c        vdyb1,vdzb1,vdye1,vdze1,
c        bidsq, sy0sq, IPNUM, ISTYPE,
c        IDOPTY, IDOPTZ, ZPLAT
c     Common Block /FLAGS/ variables:
c        MTRANS, MTIP, MHFTSZ
c     Common Block /PUFF/ variables:
c        zfinal,xfinal,fb,fm,xbfin,xmfin,elbase,
c        idw0,ht0,exitw0,diam0,ws0,istab0,sqrts0,srat0,
c        hb0,hw0,heff20,iru0,sigv0,sigw0,el0,
c        plexp0,zly0,r0,xshift0,sy0,sz0,
c        sysrc0,szsrc0,
c        zimax
c
c     Parameters:
c        IO6
c
c --- OUTPUTS:
c
c              TREC - real    - Time from source to receptor for
c                               computing PDF path (s)
c              FRAC - real    - Interpolation factor for receptor pos.
c                                 (0: at puff at start of step)
c                                 (1: at puff at end of step  )
c               SYR - real    - Receptor sigma Y (m)
c               SZR - real    - Receptor sigma Z (m)
c               HGR - real    - Receptor-specific puff height due to
c                               gradual rise (m).
c               ZPR - real    - Receptor-specific puff height after any
c                               terrain adjustments (m)
c            ZRPOLE - real    - Pole height for receptor (m)
c            RFACSQ - real    - Square of gradual rise / final rise
c             IDROP - integer - Flag to skip impact at this receptor
c                               when it is in the PRIME cavity zone
c                                 (0: do not drop this receptor)
c                                 (1: drop this receptor)
c
c --- PUFRECS called by:  CALCPF, COMP, PLMFOG
c --- PUFRECS calls:      SETCSIG, SIGTY, SIGTZ, DWSIGS, PRSS, GRISE,
c                         SLGFRAC, HEFTRAN, CTADJ, PUFFCT2
c                         WAKE_TAB
c----------------------------------------------------------------------
c
c --- Include parameter block
      include 'params.puf'

c --- Include common blocks
      include 'comparm.puf'
      include 'current.puf'
      include 'pt1.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'puff.puf'

      logical lcalm,lclip,lendpt,ldbg
      data dum0/0.0/

c --- Set list-file output switch for testing
      ldbg=.FALSE.

c --- Initialize PRIME IDROP flag (process this receptor)
      idrop=0

c --- Validate imet index
      if(imet.LT.1 .OR. imet.GT.mxmetsav+1) then
         write(io6,*)
         write(io6,*) 'FATAL ERROR in PUFRECS: bad met period index'
         write(io6,*) 'Expected IMET = 1 to MXMETSAV+1'
         write(io6,*) 'Found    IMET = ',imet
         write(io6,*) '     MXMETSAV = ',mxmetsav
         write(io6,*)
         write(*,*)
         stop 'Halted in PUFRECS -- See list file'
      endif
c
c -------------------------------------------------------------------
c --- Determine interpolation factor FRAC for interpolating
c --- virtual time/distance for sigmas
c -------------------------------------------------------------------
      call SLGFRAC(x,y,xe1,ye1,xb1,yb1,xr1,yr1,frac,xbe1,rxbe1)
c
c --- Does interpolation factor need to be clipped?
      if(LCLIP) then
c ---    Extend the 0,1 range by the puff sigma-y at start and end
c ---    of step, scaled by length of step, and limit FRAC to this
c ---    range
         frac=AMAX1(frac,-syb1*rxbe1)
         frac=AMIN1(frac,1.0+sye1*rxbe1)
c ---    Do not allow receptor-specific puff properties to be
c ---    extrapolated beyond the FRAC limit - change receptor "location"
         xr1=frac*xbe1
      endif

c --- Estimate total travel distance to receptor from source
      xtt1 = xttb1+xr1
      if(xtt1.LT.0.0) then
         xtt1 = 0.0
         frac = -xttb1*rxbe1
      endif

c --- Estimate total travel time to receptor from source for PDF
      trec = xtt1/uavg

c --- If CALM period encountered: reset dispersion option for this step
c --- ("calms" use time-based sigmas)
      if(lcalm) then
         idopty=1
         idoptz=1
         frac=0.5
         xfrise=0.0
c ---    Test:  Downwash should aready be off for a puff in a calm
         if(idw0(ipnum).GT.0) then
            write(io6,*)'PUFRECS: Puff with active downwash found in'
            write(io6,*)'   a calm environment.  This should have been'
            write(io6,*)'   trapped in SETPUF!'
            stop 'Halted in PUFRECS -- See list file'
         endif
      endif

      if(idw0(ipnum).EQ.3 .OR. idw0(ipnum).EQ.4) then
c -------------------------------------------------------------------
c ---    Special case of PRIME building downwash ---
c -------------------------------------------------------------------
c        Plume rise and sigmas are tabulated from the source to the
c        point where the turbulence reaches ambient.
c        1. Receptors within the tabulated range of the sigmas use
c           WAKE_TAB to interpolate rise and sigmas
c        2. Puffs starting within the tabulated range grow the sigmas
c           from the end of the table for receptors further downwind
c        3. Puffs and receptors beyond the tabulated range are modeled
c           using normal (non-PRIME) processing later
c -------------------------------------------------------------------
c ---    Check location of receptor relative to cavity area
         if(xtt1.LE.xshift0(ipnum)) then
            idrop=1
            return
         else
c ---       Extract sigmas if this puff was emitted with current met
            if(imet.EQ.1) then
               call WAKE_TAB(istype,isnum,idw0(ipnum),xtt1,
     &                       syr,szr,hgr,rise,xlast,idone)
c ---          Finish up and skip to terrain adjustments if sigmas
c ---          are extracted from wake table or grown from wake table
               if(idone.EQ.1) then
                  rfacsq=0.0
                  if(rise.GT.0.0 .AND. bidsq.GT.0.0) then
c ---                Add BID contribution to sigmas
                     sigbidsq=(rise/3.5)**2
                     syr=sqrt(syr**2+sigbidsq)
                     szr=sqrt(szr**2+sigbidsq)
c ---                Compute the corresponding BIDSQ adjustment factor
                     rfacsq=sigbidsq/bidsq
                  endif

                  go to 500

               elseif(xttb1.LE.xlast) then
c ---             Puff starts in tabulated wake region and receptor is
c ---             beyond the wake so grow sigmas from end of table
c ---             Properties at XLAST:
                  call WAKE_TAB(istype,isnum,idw0(ipnum),xlast,
     &                          sylast,szlast,hgr,rise,xlast2,idone)
                  dxwakkm=(xtt1-xlast)*.001
                  dtwaksec=(xtt1-xlast)/uavg
c ---             Set selected data in /CSIGMA/ for sigma calls
                  call SETCSIG(idopty,idoptz,iru,uavg,istab,el,bvf,
     &                         sigv,sigw,symin,szmin,ze1,dpbl)
c ---             Compute the receptor-specific sigmas via 'forward'
c ---             calls to sigma routines
                  call SIGTZ(szlast,dxwakkm,dtwaksec,zb1,szr,dum1,dum2)
                  call SIGTY(sylast,dxwakkm,dtwaksec,syr,dum1,dum2)
c ---             Height and rise at receptor
                  call grise(xtt1,hgr,risefac)
                  rfacsq=risefac**2
                  if(rise.GT.0.0 .AND. bidsq.GT.0.0) then
c ---                Add BID contribution to sigmas
                     sigbidsq=(rise/3.5)**2
                     syr=sqrt(syr**2+sigbidsq)
                     szr=sqrt(szr**2+sigbidsq)
c ---                Compute the corresponding BIDSQ adjustment factor
                     rfacsq=sigbidsq/bidsq
                  endif
                  go to 500
               endif
            endif
         endif
      elseif((idw0(ipnum).EQ.1 .OR. idw0(ipnum).EQ.2)
     &                             .AND. istype.LE.2) then
c -------------------------------------------------------------------
c ---    Special case of HS/SS building downwash ---
c -------------------------------------------------------------------
c        Consider the details of effects of the Huber-Snyder downwash
c        formulation or the Schulman-Scire downwash formulation on the
c        sigmas within 10 HL of the source.  This applies only if this
c        puff experiences building downwash.
c        POINT SOURCES !
c -------------------------------------------------------------------
c ---    Check for receptors in downwash zone
         hl=amin1(hb0(ipnum),hw0(ipnum))
         if(xtt1.LT.(10.*hl)) then
c ---       Initialize ratio of (gradual/final)^2  (used for BID)
            rfacsq=1.0
            if(idw0(ipnum).EQ.2) rfacsq=0.0
            hgr=zfinal(ipnum)
c ---       Set selected data in /CSIGMA/ for sigma calls
            call setcsig(idopty,idoptz,iru0(ipnum),ws0(ipnum),
     &                   istab0(ipnum),el0(ipnum),sqrts0(ipnum),
     &                   sigv0(ipnum),sigw0(ipnum),symin,szmin,
     &                   zfinal(ipnum),dpbl)
c ---       Obtain sigmas in downwash zone
            call dwsigs(tbd,hw0(ipnum),hb0(ipnum),mhftsz,ws0(ipnum),
     &                  ht0(ipnum),heff20(ipnum),zplat,xtt1,sydw,szdw)
c ---       Add initial sigmas to downwash sigmas
            sydw=SQRT(sydw**2+sysrc0(ipnum)**2)
            szdw=SQRT(szdw**2+szsrc0(ipnum)**2)
c ---       Set a "floor" to the sigma values equal to SYMIN, SZMIN
            syr=amax1(sydw,symin)
            szr=amax1(szdw,szmin)
c ---       Assess gradual rise at all receptors in downwash zone
            if(xtt1.LT.xfrise) then
c ---          Compute gradual rise
               if(idw0(ipnum).EQ.2) then
c ---             Schulman-Scire building downwash
                  call prss(xtt1,zly0(ipnum),r0(ipnum),ws0(ipnum),
     &                      istab0(ipnum),sqrts0(ipnum),diam0(ipnum),
     &                      exitw0(ipnum),fm(ipnum),fb(ipnum),
     &                      xmfin(ipnum),xbfin(ipnum),ssrise)
                  hgr=ht0(ipnum)+ssrise
               elseif(idw0(ipnum).EQ.1) then
c ---             Huber-Snyder building downwash
                  call grise(xtt1,hgr,risefac)
                  rfacsq=risefac**2
               endif
            endif
c ---       Add BID contribution to sigmas
            if(bidsq.GT.0.0) then
               syr=sqrt(syr**2+bidsq*rfacsq)
               szr=sqrt(szr**2+bidsq*rfacsq)
            endif
c
c ---       Skip to terrain adjustments
            goto 500
         endif
      endif

c --- Continue on for receptors outside downwash zone

c --------------------------------------------------------------------
c --- Compute the gradual rise if appropriate ...............
c ---   Use ISC convention that gradual rise is used to compute
c ---   buoyancy enhancement to sigmas; and is used as the "plume"
c ---   height only if MTRANS=1
c --------------------------------------------------------------------
c
      if(xtt1.LT.xfrise .AND. xtt1.GT.0.0 .AND. .NOT.lcalm) then
c ---    Compute gradual rise
         if(idw0(ipnum).EQ.3 .OR. idw0(ipnum).EQ.4) then
c ---       PRIME building downwash
            call grise(xtt1,hgr,risefac)
            rfacsq=risefac**2
         elseif(idw0(ipnum).EQ.2) then
c ---       Schulman-Scire building downwash
            call prss(xtt1,zly0(ipnum),r0(ipnum),ws0(ipnum),
     &                istab0(ipnum),sqrts0(ipnum),diam0(ipnum),
     &                exitw0(ipnum),fm(ipnum),fb(ipnum),xmfin(ipnum),
     &                xbfin(ipnum),ssrise)
            hgr=ht0(ipnum)+ssrise
c ---       No BID here
            rfacsq=0.0
         elseif(idw0(ipnum).EQ.1) then
c ---       Huber-Snyder building downwash
            call grise(xtt1,hgr,risefac)
            rfacsq=risefac**2
         else
c ---       No building downwash
            call grise(xtt1,hgr,risefac)
            rfacsq=risefac**2
         endif
      elseif(xtt1.LE.0.0 .AND. xfrise.GT.0.0) then
c ---    Receptor upwind of source, and final rise does NOT occur at
c ---    source (wind for plume rise is not "calm")
         hgr=ht0(ipnum)
         rfacsq=0.0
      else
c ---    Final rise
         hgr=zfinal(ipnum)
         rfacsq=1.0
      endif
c
c --- Set BID adjustment to account for gradual rise
c --- ADD addbid to ambient sigmas**2 without BID
      addbid=bidsq*rfacsq
c --- SUBTRACT subbid from sigmas**2 with BID
      subbid=bidsq*(1.0-rfacsq)
c
c -------------------------------------------------------------------
c --- Find the receptor-specific sigmas, with BID
c -------------------------------------------------------------------
      lendpt=.FALSE.
      if(frac.EQ.0.0) then
c ---    Use sigmas at start of step
         lendpt=.TRUE.
         syr=syb1
         szr=szb1
      elseif(frac.EQ.1.0) then
c ---    Use sigmas at end of step
         lendpt=.TRUE.
         syr=sye1
         szr=sze1
      endif
      if(LENDPT) then
         if(subbid.GE.0.0) then
            argy=syr**2-subbid
            syr=symin
            if(argy.GT.0.) syr=sqrt(argy)
            if(MOD(icode,2).EQ.1) then
c ---          Gaussian
               argz=szr**2-subbid
               szr=szmin
               if(argz.GT.0.) szr=sqrt(argz)
            endif
         endif
      else
c ---    Compute sigmas from virtual times
c ---    Set selected data in /CSIGMA/ for sigma calls
         call setcsig(idopty,idoptz,iru,uavg,istab,el,bvf,
     &                sigv,sigw,symin,szmin,ze1,dpbl)

c ---    SIGMA-Y:
c ---------------
c ---    Interpolate for virtual times/distances at receptor
         vty = AMAX1(0.0,(vtyb1 + frac * (vtye1 - vtyb1)))
         vdy = AMAX1(0.0,(vdyb1 + frac * (vdye1 - vdyb1)))
c
c ---    Compute the receptor-specific sigma (syar) via 'forward'
c ---    call to the sigma routine (without BID)
         call sigty(dum0,vdy,vty,syar,dum1,dum2)

c ---    Adjust sigma:  add contribution due to buoyancy enhancement
c ---    and initial area source size
         syr=syar
         if(addbid.GT.0.0 .OR.
     &       sy0sq.GT.0.0) syr=sqrt(syar**2+addbid+sy0sq)

c ---    SIGMA-Z:
c ---------------
         if(MOD(icode,2).EQ.0) then
            szr=szb1
         else
c ---       Interpolate for virtual times/distances at receptor
            vtz = AMAX1(0.0,(vtzb1 + frac * (vtze1 - vtzb1)))
            vdz = AMAX1(0.0,(vdzb1 + frac * (vdze1 - vdzb1)))
c
c ---       Reset Heffter transition for sigma-z for current slug
            if(mhftsz.EQ.1) call heftran(2,zb1,dum0,dum0,
     &                                   vtzb1,vtze1,vtyb1,vtye1)
c
c ---       Compute the receptor-specific sigma (szar) via 'forward'
c ---       call to the sigma routine (without BID)
            call sigtz(dum0,vdz,vtz,zb1,szar,dum1,dum2)

c ---       Adjust sigma: add contribution due to buoyancy enhancement
            szr=szar
            if(addbid.GT.0.0) szr=sqrt(szar**2+addbid)
         endif
      endif

c --- Set a "floor" to the sigma values equal to SY0, SZ0
c --- which represent minimum values at release
      if(syr .LT. sy0(ipnum)) syr=sy0(ipnum)
      if(szr .LT. sz0(ipnum)) szr=sz0(ipnum)

500   continue

c --- Estimate puff height at receptor with gravitational settling
c --- (Initial Implementation!)
      if(mtilt.EQ.1) then
c ---    Use full settling over puff age here (ht may be negative)
         dzprg=-(tb1+frac*(te1-tb1))*vsetl
         dzprg=AMIN1(0.0,dzprg)
      else
         dzprg=0.0
      endif

c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      if(LDBG) then
         write(io6,*)'PUFRECS --  plume tilt'
         write(io6,*)'zb1,ze1,frac     = ',zb1,ze1,frac
         write(io6,*)'tb1,te1          = ',tb1,te1
         write(io6,*)'dzprg            = ',dzprg
      endif
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


c -------------------------------------------------------------------
c --- Section for terrain adjustments to puff or receptor height
c -------------------------------------------------------------------
c --- Use gradual rise height if requested, or if downwash is active
      if(mtrans.EQ.1 .OR. idw0(ipnum).GT.0) then
         zpr = hgr
      else
         zpr = zfinal(ipnum)
      endif

c --- Account for settling (may be negative)
      zpr=zpr+dzprg

      zrpole=z
      if(mctadj.eq.1 .OR. mctadj.eq.3) then
         call ctadj(zrterr,zpr,ht0(ipnum),elbase(ipnum),ppcoef,zpra)
         zpr=zpra

c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      if(LDBG) then
         write(io6,*)'zrterr,elbase    = ',zrterr,elbase(ipnum)
         write(io6,*)'ppcoef,zpra      = ',ppcoef,zpra
      endif
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

      elseif(mctadj.eq.2) then
c ---    Set receptor-specific puff height
         call PUFFCT2(frac,xr1,yr1,zpr)
         if(mtrans.EQ.1 .OR. idw0(ipnum).GT.0) then
            if(zfinal(ipnum).gt.0.0)then
c ---          Scale by ratio of gradual rise to final rise
               zpr = zpr*hgr/zfinal(ipnum)
            else
               zpr = 0.0
            endif
         endif
c ---    Set receptor elevation relative to dividing-streamline
         if(bvf.gt.0.0) then
c ---       Get elevation (m MSL) of hilltop for receptor
            ix=x*dgridi+1
            iy=y*dgridi+1
            eltop=relief(5,ix,iy)
c ---       Set elevation (m MSL) of dividing-streamline
            dsel=eltop-uavg/bvf
c ---       Set elevation (m MSL) beneath puff (receptor-specific)
            xr1met = xr1*dgridi
            yr1met = yr1*dgridi
            call GETELEV(xr1met,yr1met,ze)
c ---       Set dividing-streamline height above this elevation
            dsh=AMAX1(0.0,dsel-ze)
c ---       Set elevation difference from receptor location to
c ---       dividing-streamline elevation
            zdiff=zrterr-dsel
            zdiff=zrterr-dsel
c ---       Reset pole height if altered from "z"
            if(dsh.EQ.0.0) then
               if(zdiff.LT.0.0) zrpole=AMAX1(0.0,z+zdiff)
            else
               if(zdiff.LT.0.0) then
                  zrpole=AMAX1(0.0,z+zrterr-ze)
               else
                  zrpole=z+dsh
               endif
            endif
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      if(LDBG) then
            write(io6,*)'PUFRECS --  mctadj=2'
            write(io6,*)'(x,y,z) @ puff = ',xr1,yr1,ze
            write(io6,*)'uavg, bvf        = ',uavg, bvf
            write(io6,*)'dsel, eltop (MSL)= ',dsel, eltop
            write(io6,*)'dsh, zrterr (MSL)= ',dsh,zrterr
      endif
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         endif
      endif

c --- Condition final effective puff ht to be non-negative
      zpr=AMAX1(zpr,0.0)

      return
      end
c----------------------------------------------------------------------
      subroutine calcsl(tsamp,tfract,nspec,qb,qe,qbup,qeup,qw,zstak,
     1 zbase,ppc,istab,symin,szmin,iru,hlid,hlidmax,sigv,sigw,el,bvf,
     2 dpbl,xlam,vd,vdpvd,uavg,ldbhr,lcalm,lclip)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 CALCSL
c                R. Yamartino, J. Scire, D. Strimaitis
c
c --- PURPOSE:  For a given slug, perform the loop over all receptors
c               for each species. Time-averaged coupling coefficients
c               are computed for each slug-receptor pair via SLUGAVE.
c               Also computed wet and dry deposition fluxes.
c
c --- UPDATE
c --- V5.834-V5.8.4 130731  (EPA): Fix number of arguments in AREAINT
c                                  and SLUGAVE calls within CTSG
c                                  receptor loop during calms
c --- V5.75-V5.8.4  130731  (EPA): Restrict deposition fluxes to
c                                  receptors that are located ON
c                                  the ground
c                           (EPA): Allow elevated receptors to sample
c                                  mass aloft (only discrete recs can
c                                  be elevated)
c --- V5.721-V5.75  050225  (DGS): Add DPBL arg to pass on to SLGRECS,
c                                  SETCSIG for TAULY
c --- V5.4-V5.721   040503  (DGS): Fix declaration of qw(MXSPEC,2) for
c                                  slug mass associated with wet fluxes
c                                  (was NSPEC,2)
c --- V5.1-V5.4     000602  (DGS): add temperature excess logic (FOG)
c                                  at discrete receptors
c --- V5.0-V5.1     990625a (DGS): fix coding error in SLGRECS call
c --- V5.0-V5.0     990228b (DGS): add non-zero receptor height
c --- V4.0-V5.0     971107  (DGS): use effective "pole" height from
c                                  call to SLGRECS
c                   971107  (DGS): add variable line source treatment
c                   971107  (DGS): ICODE obtained from /CURRENT/
c --- V4.0-V4.07    971107  (DGS): add PDF logic (call PDFPATH)
c
c --- INPUTS:
c
c             TSAMP - real    - Sampling time duration (s)
c            TFRACT - real    - 1./(number of samples in averaging pd)
c             NSPEC - real    - Number of species
c         QB(nspec) - real    - Slug 'mass' (g/s) (effective emission
c                               rate) at beginning of time step
c         QE(nspec) - real    - Slug 'mass' (g/s) (effective emission
c                               rate) at end of time step
c       QBUP(nspec) - real    - Slug 'mass' (g/s) (effective emission
c                               rate) at beginning of time step ALOFT
c       QEUP(nspec) - real    - Slug 'mass' (g/s) (effective emission
c                               rate) at end of time step ALOFT
c      QW(mxspec,1) - real    - Total slug 'mass' (g/s) (effective
c                               emission rate) before wet removal
c      QW(mxspec,2) - real    - Total slug 'mass' (g/s) (effective
c                               emission rate) after wet removal
c             ZSTAK - real    - Stack height of source of slug (m)
c             ZBASE - real    - Stack base elevation MSL (m)
c               PPC - real    - Plume Path Coefficient
c             ISTAB - integer - PGT stability class
c             SYMIN - real    - Minimum sigma-y (m)
c             SZMIN - real    - Minimum sigma-z (m)
c               IRU - integer - Rural(0) or urban(1) flag
c              HLID - real    - Height of reflection lid (m)
c           HLIDMAX - real    - Maximum lid height (m) for mass
c                               above HLID
c              SIGV - real    - Sigma-v velocity (m/s)
c              SIGW - real    - Sigma-w velocity (m/s)
c                EL - real    - Monin-Obukhov length (m)
c               BVF - real    - Brunt Vaisala frequency (1/s)
c              DPBL - real    - Depth of PBL (m)
c       XLAM(nspec) - real    - Scavenging ratio (1/s) for each species
c         VD(nspec) - real    - Dry deposition velocity (m/s) for each
c                               species
c      VDPVD(nspec) - real    - Conc. correction factor (vd'/vd) used
c                               to estimate effect of dry deposition and
c                               vertical mixing on near-surface concs.
c              UAVG - real    - Mean transport speed (m/s) over life of
c                               slug
c             LDBHR - logical - Debug output (T,F)
c             LCALM - logical - .TRUE. if this puff is in a calm
c             LCLIP - logical - .TRUE. if receptor-specific sigmas are
c                               limited to range defined by values at
c                               the start/end of step
c
c     Common Block /FLAGS/ variables:
c        MCTADJ, MHFTSZ
c     Common Block /FOG/ variables:
c        LADTFOG, TXSMXFOG
c     Common Block /GRID/ variables:
c        ELEVG(mxnxg,mxnyg), DGRID, IBSAMP, JBSAMP, DELSAM
c     Common Block /NONGRD/ variables:
c        NREC,XNG(mxrec),YNG(mxrec),ZNG(mxrec),ELEVNG(mxrec)
c     Common Block /CURRENT/ variables:
c        XB1, YB1, XE2, YE2, XB2, YB2, XE2, YE2
c        IAGE, SPEEDI, SRAT, TEMIS, AREAM2
c        IDOPTY, IDOPTZ, ICODE
c     Common Block /CTSGDAT/ variables:
c        NCTREC, XRCT, YRCT, IHILL, HILLDAT, ELRECT
c     Common Block /PDF/ variables:
c        LPDF
c     Parameters:
c        NSPEC, MXREC, MXSLUG, IO6
c
c
c --- OUTPUTS:
c
c     Common block /CHIFLX/ variables:
c        CHISAM(mxnxg,mxnyg,mxspec),DFSAM(mxnxg,mxnyg,mxspec),
c        WFSAM(mxnxg,mxnyg,mxspec),CHIREC(mxrec,mxspec),
c        DFREC(mxrec,mxspec),WFREC(mxrec,mxspec)
c     Common Block /PDF/ variables:
c        RFACSQ
c
c --- CALCSL called by:  COMP
c --- CALCSL calls:      SLGXLIM, SLGRECS, SLUGAVE, AREAINT, SETCSIG
c----------------------------------------------------------------------
c --- Note that ungridded receptor info in /slgbnd/ is used here.
c     common/slgbnd/ xreclo,xrechi,yreclo,yrechi
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'chiflx.puf'
      include 'ctsgdat.puf'
      include 'current.puf'
      include 'flags.puf'
      include 'fog.puf'
      include 'grid.puf'
      include 'nongrd.puf'
      include 'pdf.puf'
c
      common/slgbnd/ xreclo,xrechi,yreclo,yrechi
c
      real qb(nspec),qe(nspec),qw(mxspec,2)
      real qdiff(mxspec),qwdiff(mxspec)
      real qbup(nspec),qeup(nspec)
      real qdiffup(mxspec)
      real xlam(nspec),vd(nspec),vdpvd(nspec)
      logical lwflux
      logical ldbhr,lcalm,lclip
      logical lup

c
c --- Slug types : "icode" differentiates the vertical structure
c ---    ICODE=11:  within mixed layer and Gaussian
c ---    ICODE=12:  within mixed layer and uniform
c ---    ICODE=13:  above mixed layer and Gaussian (ignore mixing ht)
c ---    ICODE=14:  above mixed layer and uniform (not allowed !!)
c ---    ICODE=15:  above (but previously below) mixed layer and Gaussian
c ---    ICODE=16:  above (but previously below) mixed layer and uniform
c ---    ICODE=99:  off grid
      if(icode.EQ.14 .OR. icode.EQ.99) then
c ---    No concs
         return
      endif
c
c --- Is wet flux to be computed for this slug ?
      lwflux=.FALSE.
      if(mwet.EQ.1) then
         xsum=0.0
         do i=1,nspec
            xsum=xsum+xlam(i)
         enddo
         if(xsum.GT.0.0) lwflux=.TRUE.
      endif
c
c --- Process emissions (mass) for each species in this slug
      mass=0
      massup=0
      massw=0
      do is=1,nspec
         qdiff(is) = 0.0
         qdiffup(is) = 0.0
         if(qb(is).GT.0.0 .OR. qe(is).GT.0.0) then
c ---       There is mass in this slug (lower layer)
            mass=1
            qdiff(is) = qe(is)-qb(is)
         endif
         if(qbup(is).GT.0.0 .OR. qeup(is).GT.0.0) then
c ---       There is mass in this slug (upper layer)
            massup=1
            qdiffup(is) = qeup(is)-qbup(is)
         endif
         qwdiff(is) = 0.0
         if(lwflux .AND. (qw(is,1).GT.0.0 .OR. qw(is,2).GT.0.0)) then
c ---       There is wet removal of mass from this slug
            massw=1
            qwdiff(is) = qw(is,1)-qw(is,2)
         endif
      enddo
c
c --- Determine the T factors for the slug that are due to shear
c     induced stretching of the slug.  4/5/89
c --- First must define the average x-y plane length of slug over
c --- the sampling time interval.
      sluglen = srat * speedi * temis
      if(iage.gt.0) sluglen = 0.5*(sqrt( (xb1-xb2)**2 + (yb1-yb2)**2 )+
     1                             sqrt( (xe1-xe2)**2 + (ye1-ye2)**2 ))
c
c --- Now compute the T factors, tfaca and tfacc.
      tfaca = 1.0
c --- Slugs with low srat are essentially puffs and are not subjected
c     to shear growth of the axial length.
      if(iage.GT.0 .AND. srat.GT.0.01) tfaca = sluglen /
     1                                         (srat * speedi * temis)
c --- Assume that there is no z - compensation due to shear.
c --- i.e. tfacz = 1.0 is understood and not defined.
      tfacai = 1.0 / tfaca
      tfacc = tfacai
c
c --- Set bounds on receptors affected by the slug
c --- Corresponding coordinate bounds are placed in /SLGBND/
      call slgxlim(il,iu,jl,ju,tfacc)
c
c --- Set factor to obtain correct units from area-source integrator:
c --- Divide coupling coefficients by area of source
      if(iage.EQ.0 .AND.
     &   istype.GE.3 .AND. istype.LE.6) then
         factor=1./aream2
      else
         factor=1.0
      endif
c
c --- Set unadjusted slug height above ground for SETCSIG
      zht=ze1
c
c*****
      if(LDBHR) then
      write(io6,*)
      write(io6,*) ' CALCSL -- xlo, xhi = ',xreclo,xrechi
      write(io6,*) '           ylo, yhi = ',yreclo,yrechi
      write(io6,*) '        IL,IU,JL,JU = ',il,iu,jl,ju
      write(io6,*) '       tfaca, tfacc = ',tfaca,tfacc
      write(io6,*) '  area units factor = ',factor
      do is=1,nspec
         write(io6,*)' CALCSL --  ispec = ',is
         write(io6,*)'           qb, qe = ',qb(is),qe(is)
         write(io6,*)'       qbup, qeup = ',qbup(is),qeup(is)
         write(io6,*)'          qw(1,2) = ',qw(is,1),qw(is,2)
         write(io6,*)'         vd, xlam = ',vd(is),xlam(is)
      enddo
      endif
c*****

      if(lsamp) then
c --- There are no elevated receptors here so skip if no mass in lower
c --- layer and no wet deposition
      if(mass.EQ.0 .AND. massw.EQ.0) goto 201

c ---------------------------------------------------------------------
c --- Begin loop over grid receptors
c ---------------------------------------------------------------------
      do 200 i=il,iu
      do 200 j=jl,ju
c
c --- xrec,yrec is the location of the receptor (m) (on met. grid)
      xrec = (float(ibsamp)-0.5)*dgrid+float(i-1)*delsam
      yrec = (float(jbsamp)-0.5)*dgrid+float(j-1)*delsam
c --- zrec is the z height (m) of the receptor above local terrain.
      zrec = 0.0
c
c --- The local lid height is measured above terrain and is presently
c --- assumed to be a constant over the grid.
c
c --- Identify the local terrain elevation (m MSL) at the receptor
      zrterr=elevg(i,j)
c
c --- Special treatment for determination of impact due to a polygon
c --- area source for a slug attached to the source.
c --- The source type index for POLYGON areas is 3 or 4.  Initially,
c --- LINE sources (source type=5,6) are also modeled as polygon areas.
      if(iage.EQ.0 .AND.
     &   istype.GE.3 .AND. istype.LE.6) then
c ---    Set selected data in /CSIGMA/ for sigma calls
         call setcsig(idopty,idoptz,iru,uavg,istab,el,bvf,
     &                sigv,sigw,symin,szmin,zht,dpbl)
         call areaint(xrec,yrec,lwflux,zrec,hlid,hlidmax,
     2                zrterr,zstak,zbase,ppc,ldbhr,
     3                ccqb,ccdq,ccizqb,ccizdq)
         ccqb=ccqb*factor
         ccdq=ccdq*factor
         ccizqb=ccizqb*factor
         ccizdq=ccizdq*factor
c
      else
c ---    Obtain receptor-specific sigmas and puff height (gradual rise),
c ---    including any terrain adjustment to height
         call slgrecs(lclip,xrec,yrec,zrec,istab,iru,sigv,sigw,el,bvf,
     &                uavg,dpbl,zrterr,ppc,lcalm,
     &                trec,syrb,syre,szrb,szre,zgrise,zpr,zrpole,rfacsq)
c
c ***
      if(LDBHR) then
      write(io6,*) 'CALCSL: Grid rec x,y  = ',xrec,yrec
      write(io6,*) '        Trans. Rise   = ',zgrise
      write(io6,*) '        Adj. Slug Ht. = ',zpr
      write(io6,*) '    Adj. Rec Pole Ht. = ',zrpole
      write(io6,*) '  Sigma-y @ rec. (b,e)= ',syrb,syre
      write(io6,*) '  Sigma-z @ rec. (b,e)= ',szrb,szre
      write(io6,*) '  Reflecting Lid Ht.  = ',hlid
      write(io6,*) '    Time to receptor  = ',trec
      write(io6,*) ' G.Rise Adj to BID**2 = ',rfacsq
      endif
c ***
c
c ---    Store PDF path data for this receptor
         if(LPDF) call PDFPATH(zpr,hlid,trec)

c ---    Perform SLUG calculations
         call slugave(ldbhr,lwflux,tsamp,xrec,yrec,zrpole,zpr,tfacc,
     &                syrb,szrb,syre,szre,hlid,hlidmax,
     &                ccqb,ccdq,ccizqb,ccizdq)

      endif
c
c --- All coupling coefficients are now available.
c
c ---------------------------------------------------------------------
c --- Begin the loop over species
c ---------------------------------------------------------------------
c
      do 100 is=1,nspec
c
      conc = 0.0
      dflux = 0.0
      wflux = 0.0
c
c --- Concentration and dry deposition flux
      if(mass.EQ.1) then
c ---    Compute concentration at receptor (include vd'/vd)
c ---    Introduce the along slug T factor correction (tfacai=1/tfaca)
         conc = vdpvd(is)*(qb(is)*ccqb + qdiff(is)*ccdq)*tfacai
         chisam(i,j,is) = chisam(i,j,is) + conc* tfract
c ---    Compute dry flux at receptor using local concentration and vd.
         dflux = vd(is) * conc
         dfsam(i,j,is) = dfsam(i,j,is) + dflux*tfract
      endif
c
c --- Wet deposition flux
      if(massw.EQ.1) then
c ---    Compute wet flux at receptor using z integrated quantities,
c ---    Introduce the along slug T factor correction (tfacai=1/tfaca)
         wflux = (qw(is,1)*ccizqb + qwdiff(is)*ccizdq)*xlam(is)*tfacai
         wfsam(i,j,is) = wfsam(i,j,is) + wflux*tfract
      endif
c
c ***
      if(LDBHR) then
      write(io6,*) ' CALCSL -- i,j,ispec = ',i,j,is
      write(io6,*) '  conc, wflux, dflux = ',conc,wflux,dflux
      write(io6,*) '        ccqb, ccizqb = ',ccqb,ccizqb
      write(io6,*) '        ccdq, ccizdq = ',ccdq,ccizdq
      endif
c ***
c
  100 continue
  200 continue
c ---------------------------------------------------------------------
c --- END loop over grid receptors
c ---------------------------------------------------------------------
  201 continue
      endif

c
c ---------------------------------------------------------------------
c --- Begin loop over discrete receptors
c ---------------------------------------------------------------------
c
      if(nrec.GT.0) then
      do 400 ing=1,nrec
c
c --- xrec is the X location of the receptor (m) (on met. grid)
c --- yrec is the Y location of the receptor (m) (on met. grid)
      xrec = xng(ing)*dgrid
      yrec = yng(ing)*dgrid
c --- zrec is the z height (m) of the receptor above local terrain.
      zrec = zng(ing)
c --- Set logical for impact of mass aloft at receptor aloft
c --- (Should only depend on receptor height and
c ---  reflecting height)
      if(zrec.GT.hlid) then
         lup=.TRUE.
      else
         lup=.FALSE.
      endif

c --- Test receptor location to see if it is affected by slug
c --- (loop to next receptor if outside slug boundary)
      if(xrec.lt.xreclo .OR. xrec.gt.xrechi) goto 400
      if(yrec.lt.yreclo .OR. yrec.gt.yrechi) goto 400
c
c --- Identify the local terrain elevation (m MSL) at the receptor
      zrterr=elevng(ing)
c
c --- Special treatment for determination of impact due to a polygon
c --- area source for a slug attached to the source.
c --- The source type index for POLYGON areas is 3 or 4.  Initially,
c --- LINE sources (source type=5,6) are also modeled as polygon areas.
      if(iage.EQ.0 .AND.
     &   istype.GE.3 .AND. istype.LE.6) then
c ---    Set selected data in /CSIGMA/ for sigma calls
         call setcsig(idopty,idoptz,iru,uavg,istab,el,bvf,
     &                sigv,sigw,symin,szmin,zht,dpbl)
         call areaint(xrec,yrec,lwflux,zrec,hlid,hlidmax,
     2                zrterr,zstak,zbase,ppc,ldbhr,
     3                ccqb,ccdq,ccizqb,ccizdq)
         ccqb=ccqb*factor
         ccdq=ccdq*factor
         ccizqb=ccizqb*factor
         ccizdq=ccizdq*factor
c
      else
c ---    Obtain receptor-specific sigmas and puff height (gradual rise),
c ---    including any terrain adjustment to height
         call slgrecs(lclip,xrec,yrec,zrec,istab,iru,sigv,sigw,el,bvf,
     &                uavg,dpbl,zrterr,ppc,lcalm,
     &                trec,syrb,syre,szrb,szre,zgrise,zpr,zrpole,rfacsq)
c
c ***
      if(LDBHR) then
      write(io6,*) 'CALCSL: Disc rec x,y,z= ',xrec,yrec,zrec
      write(io6,*) '        Trans. Rise   = ',zgrise
      write(io6,*) '        Adj. Slug Ht. = ',zpr
      write(io6,*) '    Adj. Rec Pole Ht. = ',zrpole
      write(io6,*) '  Sigma-y @ rec. (b,e)= ',syrb,syre
      write(io6,*) '  Sigma-z @ rec. (b,e)= ',szrb,szre
      write(io6,*) '  Reflecting Lid Ht.  = ',hlid
      write(io6,*) '    Time to receptor  = ',trec
      write(io6,*) ' G.Rise Adj to BID**2 = ',rfacsq
      endif
c ***
c
c ---    Store PDF path data for this receptor
         if(LPDF) call PDFPATH(zpr,hlid,trec)

c ---    Perform SLUG calculations
         call slugave(ldbhr,lwflux,tsamp,xrec,yrec,zrpole,zpr,tfacc,
     &                syrb,szrb,syre,szre,hlid,hlidmax,
     &                ccqb,ccdq,ccizqb,ccizdq)
c
      endif
c
c --- All coupling coefficients are now available.
c
c ---------------------------------------------------------------------
c --- Begin the loop over species
c ---------------------------------------------------------------------
c
      do 300 is=1,nspec
c
      conc = 0.0
      dflux = 0.0
      wflux = 0.0
c
c --- Concentration and dry deposition flux
      if(mass.EQ.1 .AND. .not.LUP) then
c ---    Compute concentration at receptor (include vd'/vd)
c ---    Introduce the along slug T factor correction (tfacai=1/tfaca)
         conc = vdpvd(is)*(qb(is)*ccqb + qdiff(is)*ccdq)*tfacai
         chirec(ing,is) = chirec(ing,is) + conc*tfract
         if(is.EQ.2 .AND. LADTFOG) then
c ---       FOG: SUM T excess (is=2) at receptor but do not exceed
c ---       excess at source
            chirec(ing,is) = AMIN1(txsmxfog,chirec(ing,is))
         endif
c ---    Compute dry flux at receptor using local concentration and vd.
c ---    Deposition is only at the surface
         if(zrec.EQ.0.0) then
            dflux = vd(is) * conc
            dfrec(ing,is) = dfrec(ing,is) + dflux*tfract
         endif
      endif
c --- Concentration ALOFT
      if(massup.EQ.1 .AND. LUP) then
c ---    Compute concentration at receptor
c ---    Introduce the along slug T factor correction (tfacai=1/tfaca)
         conc = (qbup(is)*ccqb + qdiffup(is)*ccdq)*tfacai
         chirec(ing,is) = chirec(ing,is) + conc*tfract
         if(is.EQ.2 .AND. LADTFOG) then
c ---       FOG: SUM T excess (is=2) at receptor but do not exceed
c ---       excess at source
            chirec(ing,is) = AMIN1(txsmxfog,chirec(ing,is))
         endif
      endif
c
c --- Wet deposition flux
c --- Deposition is only at the surface
      if(massw.EQ.1 .AND. zrec.EQ.0.0) then
c ---    Compute wet flux at receptor using z integrated quantities,
c ---    Introduce the along slug T factor correction (tfacai=1/tfaca)
         wflux = (qw(is,1)*ccizqb + qwdiff(is)*ccizdq)*xlam(is)*tfacai
         wfrec(ing,is) = wfrec(ing,is) + wflux*tfract
      endif
c
c ***
      if(LDBHR) then
      write(io6,*) ' CALCSL -- ing,ispec = ',ing,is
      write(io6,*) '  conc, wflux, dflux = ',conc,wflux,dflux
      write(io6,*) '        ccqb, ccizqb = ',ccqb,ccizqb
      write(io6,*) '        ccdq, ccizdq = ',ccdq,ccizdq
      endif
c ***
c
  300 continue
  400 continue
c ---------------------------------------------------------------------
c --- END loop over discrete receptors
c ---------------------------------------------------------------------
      endif

c
c ---------------------------------------------------------------------
c --- Begin loop over CTSG receptors
c --- CALM conditions ONLY!
c ---------------------------------------------------------------------
c
      if(nctrec.GT.0 .AND. LCALM) then
c --- There are no elevated receptors and no wet deposition here so
c --- skip if no mass in lower layer
      if(mass.EQ.0) goto 601

      do 600 ict=1,nctrec
c
c --- xrec is the X location of the receptor (m) (on met. grid)
c --- yrec is the Y location of the receptor (m) (on met. grid)
      xrec = xrct(ict)*dgrid
      yrec = yrct(ict)*dgrid
c --- zrec is the z height (m) of the receptor above local terrain.
c --- Sample vertical distribution at the surface if non-stable class
c --- (dividing streamline is 0); sample at receptor elevation above
c --- base of hill if stable (impingement case)
      if(istab.GT.4) then
         zrec=elrect(ict)-hilldat(4,ihill(ict))
         zrec=amax1(0.0,zrec)
      else
         zrec=0.0
      endif

c --- Test receptor location to see if it is affected by slug
c --- (loop to next receptor if outside slug boundary)
      if(xrec.lt.xreclo .OR. xrec.gt.xrechi) goto 600
      if(yrec.lt.yreclo .OR. yrec.gt.yrechi) goto 600
c
c --- Identify the local terrain elevation (m MSL) at the receptor with
c --- the base of the source so that slug height is not modified by
c --- simple terrain adjustments (terrain influence is done via zrec)
      zrterr=zbase
c
c --- Special treatment for determination of impact due to a polygon
c --- area source for a slug attached to the source.
c --- The source type index for POLYGON areas is 3 or 4.  Initially,
c --- LINE sources (source type=5,6) are also modeled as polygon areas.
      if(iage.EQ.0 .AND.
     &   istype.GE.3 .AND. istype.LE.6) then
c ---    Set selected data in /CSIGMA/ for sigma calls
         call setcsig(idopty,idoptz,iru,uavg,istab,el,bvf,
     &                sigv,sigw,symin,szmin,zht,dpbl)
         call areaint(xrec,yrec,lwflux,zrec,hlid,hlidmax,
     2                zrterr,zstak,zbase,ppc,ldbhr,
     3                ccqb,ccdq,ccizqb,ccizdq)
         ccqb=ccqb*factor
         ccdq=ccdq*factor
         ccizqb=ccizqb*factor
         ccizdq=ccizdq*factor
c
      else
c ---    Obtain receptor-specific sigmas and puff height (gradual rise),
c ---    including any terrain adjustment to height
         call slgrecs(lclip,xrec,yrec,zrec,istab,iru,sigv,sigw,el,bvf,
     &                uavg,dpbl,zrterr,ppc,lcalm,
     &                trec,syrb,syre,szrb,szre,zgrise,zpr,zrpole,rfacsq)
c ---    NOTE: zrpole is not used for these CTSG receptors!
c
c ***
      if(LDBHR) then
      write(io6,*) 'CALCSL: CTSG Calm x,y,z= ',xrec,yrec,zrec
      write(io6,*) '         Trans. Rise   = ',zgrise
      write(io6,*) '         Adj. Slug Ht. = ',zpr
      write(io6,*) '   Sigma-y @ rec. (b,e)= ',syrb,syre
      write(io6,*) '   Sigma-z @ rec. (b,e)= ',szrb,szre
      write(io6,*) '   Reflecting Lid Ht.  = ',hlid
      write(io6,*) '    Time to receptor  = ',trec
      write(io6,*) ' G.Rise Adj to BID**2 = ',rfacsq
      endif
c ***
c
c ---    Store PDF path data for this receptor
         if(LPDF) call PDFPATH(zpr,hlid,trec)

c ---    Perform SLUG calculations
         call slugave(ldbhr,lwflux,tsamp,xrec,yrec,zrec,zpr,tfacc,
     &                syrb,szrb,syre,szre,hlid,hlidmax,
     &                ccqb,ccdq,ccizqb,ccizdq)
c
      endif
c
c --- All coupling coefficients are now available.
c
c ---------------------------------------------------------------------
c --- Begin the loop over species
c ---------------------------------------------------------------------
c
      do 500 is=1,nspec
c
      conc = 0.0
c
c --- Concentration
      if(mass.EQ.1) then
c ---    Compute concentration at receptor (include vd'/vd)
c ---    Introduce the along slug T factor correction (tfacai=1/tfaca)
         conc = vdpvd(is)*(qb(is)*ccqb + qdiff(is)*ccdq)*tfacai
         chict(ict,is) = chict(ict,is) + conc*tfract
      endif
c
c --- Wet and Dry deposition flux not computed at CTSG receptors
c
c ***
      if(LDBHR) then
      write(io6,*) ' CALCSL -- ict,ispec = ',ict,is
      write(io6,*) '                conc = ',conc
      write(io6,*) '        ccqb, ccizqb = ',ccqb,ccizqb
      write(io6,*) '        ccdq, ccizdq = ',ccdq,ccizdq
      endif
c ***
c
  500 continue
  600 continue
c ---------------------------------------------------------------------
c --- END loop over CTSG receptors
c ---------------------------------------------------------------------
601   continue

      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine slgrecs(lclip0,x,y,z,istab,iru,sigv,sigw,el,bvf,uavg,
     &                   dpbl,zrterr,ppcoef,lcalm,
     &                   trec,syrb,syre,szrb,szre,hgr,zpr,zrpole,
     &                   rfacsq)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 139731                SLGRECS
c                R. Yamartino, D. Strimaitis
c
c --- PURPOSE:  Computes the receptor-specific sigmas y and z,
c               and receptor-specific slug height (gradual rise)
c               with terrain adjustments for SLUGS
c
c --- UPDATE
c --- V5.83-V5.8.4  130731  (EPA): 1/Slug-length is not computed for
c                                  young end of emitting slugs, but is
c                                  used in clipping logic:  set to
c                                  result for old end
c --- V5.760-V5.8.4 130731  (EPA): Remove stack-tip downwash adjustment
c                                  to gradual rise because adjustment
c                                  is done within GRISE.
c --- V5.75-V5.760  070605  (DGS): move CALM re-assignment of IDW0() to
c                                  SETSLG so that downwash effects are
c                                  turned off as soon as a puff reaches
c                                  a calm area (add QA here).
c --- V5.73-V5.75   050225  (DGS): add platform ht to DWSIGS call for
c                                  ISC building downwash (MBDW=1)
c                   050225  (DGS): Add DPBL arg to pass on to SETCSIG
c                                  for TAULY
c --- V5.5-V5.73    040611  (DGS): add gravitational settling for one
c                                  particle size (plume tilt)
c --- V5.4-V5.5     010730  (DGS): correct initial sigma used with
c                                  downwash sigma
c --- V5.3-V5.4     000602_2(DGS): add initial sigmas to downwash
c                                  sigmas in quadrature
c --- V5.0-V5.3     991222b (DGS): pass momentum flux to STKTIP
c --- V5.0-V5.0     990228b (DGS): screen for zero puff height in
c                                  terrain adjustment (CTADJ=2)
c --- V5.0-V5.0     990228b (DGS): add receptor ht above ground
c --- V5.0-V5.0     980918  (DGS): use quadrature to include initial
c                                  area source size
c --- V5.0-V5.0     980615  (DGS): return initial sigz if well-mixed
c --- V5.0-V5.0     980304  (DGS): use hard clip in place of soft clip
c                                  along the axis of a slug if
c                                  dispersion changes, and use
c                                  sy0,sz0 for min values
c --- V4.0-V5.0     971107  (DGS): extrapolate slug sigmas beyond ends
c                                  when slug "passes" receptor, even if
c                                  LCLIP0 is .TRUE.
c                   971107  (DGS): compute effective "pole" height
c                                  of receptor for option MCTADJ=2
c --- V4.0-V4.07    971107  (DGS): add mean transport time and gradual
c                                  rise factor squared to output
c --- V4.0-v5.0     971107  (DGS): alter slug height for receptor
c                                  position for option MCTADJ=2
c                   971107  (DGS): package slug geometry in SLGFRAC
c
c --- INPUTS:
c
c            LCLIP0 - logical - .TRUE. : limit "receptor position" to
c                                        lie within slug end-points for
c                                        local slug influence
c                               .FALSE.: use actual receptor position
c                                        to determine sigmas
c           (X,Y,Z) - real    - Coordinates of the receptor (m), where
c                               Z is above ground, not sea level
c             ISTAB - integer - PGT stability class
c               IRU - integer - Rural(0) or urban(1) flag
c              SIGV - real    - Sigma-v velocity (m/s)
c              SIGW - real    - Sigma-w velocity (m/s)
c                EL - real    - Monin-Obukhov length (m)
c               BVF - real    - Brunt-Vaisala frequency (1/s)
c              UAVG - real    - Mean transport speed (m/s) over xtotm
c              DPBL - real    - Depth of PBL (m)
c            ZRTERR - real    - Terrain elevation (m MSL) at receptor
c            PPCOEF - real    - Plume path coefficient
c             LCALM - logical - .TRUE. if this puff is in a calm
c
c     Common Block /COMPARM/ variables:
c        SYMIN, SZMIN, TBD
c     Common Block /CURRENT/ variables:
c        XB1, YB1, ZB1, SYB1, SZB1,
c        XE1, YE1, ZE1, SYE1, SZE1,
c        XB2, YB2, ZB2, SYB2, SZB2,
c        XE2, YE2, ZE2, SYE2, SZE2,
c        xttb1,xtte1,tb1,te1,vsetl,
c        xttb2,xtte2,tb2,te2,
c        vtyb1,vtzb1,vtyb2,vtzb2,
c        vtye1,vtze1,vtye2,vtze2,
c        vdyb1,vdzb1,vdyb2,vdzb2,
c        vdye1,vdze1,vdye2,vdze2,
c        IAGE, SPEEDI, SRAT, TEMIS, bidsq, IPNUM, ISTYPE, sy0sq,
c        IDOPTY, IDOPTZ, rlfmax,
c        ZPLAT
c     Common Block /FLAGS/ variables:
c        MTRANS, MTIP, MHFTSZ, MCTADJ. MTILT
c     Common Block /PUFF/ variables:
c        zfinal,xfinal,fb,fm,xbfin,xmfin,elbase,
c        idw0,ht0,exitw0,diam0,ws0,istab0,sqrts0,srat0,
c        hb0,hw0,heff20,iru0,sigv0,sigw0,el0,
c        plexp0,zly0,r0,xshift0,sy0,sz0,
c        sysrc0,szsrc0
c
c     Parameters:
c        IO6
c
c --- OUTPUTS:
c
c              TREC - real    - Time from source to receptor (s)
c              SYRB - real    - Receptor sigma Y at start of time step.
c              SYRE - real    - Receptor sigma Y at end of time step.
c              SZRB - real    - Receptor sigma Z at start of time step.
c              SZRE - real    - Receptor sigma Z at end of time step.
c               HGR - real    - Receptor-specific slug height due to
c                               gradual rise (m).
c               ZPR - real    - Receptor-specific slug height after any
c                               terrain adjustments (m)
c            ZRPOLE - real    - Pole height for receptor (m)
c            RFACSQ - real    - Rise factor squared
c
c --- SLGRECS called by:  CALCSL
c --- SLGRECS calls:      SETCSIG, SIGTY, SIGTZ, DWSIGS, PRSS, GRISE,
c                         HEFTRAN, CTADJ, SLUGCT2, SLGFRAC
c----------------------------------------------------------------------
c
c --- Include parameter block
      include 'params.puf'

c --- Include common blocks
      include 'comparm.puf'
      include 'pt1.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'puff.puf'
      include 'current.puf'

c --- Some variables passed to LSSLINT via SLGLIN common block
      COMMON /SLGLIN/ DXY12,RDXY12

      logical lcalm,lclip0,lclip, ldbg
      data zero/0.0/, one/1.0/
      data dum0/0.0/

c --- Set list-file output switch for testing
      ldbg=.FALSE.

c --- Initialize gradual rise height to full final rise
      hgr=zfinal(ipnum)
c
c --- If CALM period encountered: reset dispersion option for this step
c --- ("calms" use time-based sigmas)
      if(lcalm) then
         idopty=1
         idoptz=1
         xfrise=zero
         if(idw0(ipnum).GT.0) then
            write(io6,*)'SLGRECS: Puff with active downwash found in'
            write(io6,*)'   a calm environment.  This should have been'
            write(io6,*)'   trapped in SETSLG!'
            stop 'Halted in SLGRECS -- See list file'
         endif
      endif

c -------------------------------------------------------------------
c --- Determine the spatial interpolation factors for along-slug
c --- and along-step positions
c -------------------------------------------------------------------

c --- (1)  Along-slug at Final slug position  (FRACSF)
c
c --- Determine the length and orientation of the final slug,
c --- and the position of the receptor relative to slug end 2
c --- as a fraction of the along-slug length
c --- FRACSF = 0 corresponds to slug end 2 (new)
c --- FRACSF = 1 corresponds to slug end 1 (old)
      call SLGFRAC(x,y,xe1,ye1,xe2,ye2,rhoaf,rhocf,fracsf,d12f,rd12f)

c --- (2)  Along-slug at Initial slug position  (FRACSI)
c
      if(iage.EQ.1) then
         call SLGFRAC(x,y,xb1,yb1,xb2,yb2,rhoai,rhoci,fracsi,d12i,rd12i)
      else
         d12i=d12f
         rd12i=rd12f
         fracsi=fracsf
         rhoai=rhoaf
         rhoci=rhocf
      endif

c --- (3)  Along-step for Old slug-end  (FRACSO)
c
c --- Determine the length and orientation of the step taken by this
c --- slug-end, and the along-step position of the receptor
c --- as a fraction of this step length
      call SLGFRAC(x,y,xe1,ye1,xb1,yb1,rhoao,rhoco,fracso,d12o,rd12o)

c --- (4)  Along-step for Young slug-end  (FRACSY)
c
      if(iage.EQ.1) then
         call SLGFRAC(x,y,xe2,ye2,xb2,yb2,rhoay,rhocy,fracsy,d12y,rd12y)
      else
         d12y=d12o
         rd12y=rd12o
         fracsy = fracso
         rhoay = rhoao
         rhocy = rhoco
      endif

c --- (5)  Do interpolation factors need to be clipped near slug-ends?
c
      lclip=lclip0
      if(LCLIP0) then

c ---    Identify case where slug passes receptor during step (no clip)
         if(fracsi.GT.-syb2*rd12i .AND.
     &      fracsf.LT.one+sye1*rd12f) lclip=.FALSE.

c ---    Now clip interpolation range if needed
         if(LCLIP) then

c ---       (1) Along-step
c ---       Extend the 0,1 range by sigma-y at start and end of step,
c ---       scaled by length of step, and limit FRAC to this interval
            fracso=AMAX1(fracso,-syb1*rd12o)
            fracso=AMIN1(fracso,one+sye1*rd12o)
            fracsy=AMAX1(fracsy,-syb2*rd12y)
            fracsy=AMIN1(fracsy,one+sye2*rd12y)

c ---       (2) Along-slug
c ---       Extend the 0,1 range by sigma-y at young and old end of
c ---       slug, scaled by length of slug, and limit FRAC to this
c ---       interval
            fracsi=AMAX1(fracsi,-syb2*rd12i)
            fracsi=AMIN1(fracsi,one+syb1*rd12i)
            fracsf=AMAX1(fracsf,-sye2*rd12f)
            fracsf=AMIN1(fracsf,one+sye1*rd12f)

c ---       Note: along-slug/step distance (rhoa_) is not clipped here

         endif
      endif

c --- (6)  Define "hard" clipping factors for dispersion calcs
c
      hfracsi=fracsi
      hfracsf=fracsf
      if(LCLIP0) then
c ---    Set a hard clip Along-slug if end-point sigma-ys are not
c ---    consistent with real difference in age across slug (temis)
c ---    indicating slug has passed into new dispersion regime
         fclip=(vtye1-vtye2)/temis
         if(fclip.GT.1.1 .OR. fclip.LT.0.9) then
c ---       Reset hard FRACS[I,F] values within 0-1 range
            hfracsi=AMAX1(fracsi,zero)
            hfracsi=AMIN1(hfracsi,one)
            hfracsf=AMAX1(fracsf,zero)
            hfracsf=AMIN1(hfracsf,one)
         endif
      endif

c -------------------------------------------------------------------
c --- Approximate the (clipped) distance and time to receptor
c -------------------------------------------------------------------
c
c --- (1) Estimate total travel distance to receptor, using movement
c --- of OLDER end of slug from beginning to end of step
      xtt1 = xttb1+fracso*(xtte1-xttb1)
c
c --- (2) Estimate total travel distance to receptor, using movement
c --- of YOUNG end of slug from beginning to end of step
      if(iage.EQ.1) then
         xtt2 = xttb2+fracsy*(xtte2-xttb2)
      else
         xtt2=xtt1
      endif
c
c --- (3) Choose/interpolate between xtt1 and xtt2, giving priority
c --- to information obtained from the old (1) end of the slug
      if(fracso.LT.0.5) then
c ---    Focus on slug at the beginning of the step
         frac=fracsi
      else
c ---    Focus on slug at the end of the step
         frac=fracsf
      endif
      if(frac.LE.zero) then
         xttr=xtt2
      elseif(frac.GE.one) then
         xttr=xtt1
      else
c ---    Interpolate from new (xxt2) to old (xxt1) end distance
         xttr=xtt2+frac*(xtt1-xtt2)
      endif

c --- Total travel distance is positive!
      xrec=amax1(xttr,zero)

c --- Use xrec to estimate travel time to receptor
      trec=xrec/uavg

c -------------------------------------------------------------------
c --- Special case of building downwash ---
c -------------------------------------------------------------------
c     Point sources:
c     Consider the details of effects of the Huber-Snyder downwash
c     formulation or the Schulman-Scire downwash formulation on the
c     sigmas within 10 HL of the source.  This applies only if this
c     slug experiences building downwash, and if the youngest end of
c     the slug is attached to the source at the start of the step.
c     POINT SOURCES !
c -------------------------------------------------------------------

      if(idw0(ipnum).GT.0 .AND. istype.LE.2) then
c ---    Check for receptors in downwash zone
         hl=amin1(hb0(ipnum),hw0(ipnum))
         if(xrec.LT.(10.*hl)) then
c ---       Initialize ratio of (gradual/final)^2  (used for BID)
            rfacsq=one
            if(idw0(ipnum).EQ.2) rfacsq=zero
c ---       Set selected data in /CSIGMA/ for sigma calls
            call setcsig(idopty,idoptz,iru0(ipnum),ws0(ipnum),
     &                   istab0(ipnum),el0(ipnum),sqrts0(ipnum),
     &                   sigv0(ipnum),sigw0(ipnum),symin,szmin,
     &                   zfinal(ipnum),dpbl)
c ---       Obtain sigmas in downwash zone
            call dwsigs(tbd,hw0(ipnum),hb0(ipnum),mhftsz,ws0(ipnum),
     &                  ht0(ipnum),heff20(ipnum),zplat,xrec,sydw,szdw)
c ---       Add initial sigmas to downwash sigmas
            sydw=SQRT(sydw**2+sysrc0(ipnum)**2)
            szdw=SQRT(szdw**2+szsrc0(ipnum)**2)
c ---       Set a "floor" to the sigma values equal to SYMIN, SZMIN
            syre=amax1(sydw,symin)
            syrb=syre
            szre=amax1(szdw,szmin)
            szrb=szre
c ---       Assess gradual rise at all receptors in downwash zone
            if(xrec.LT.xfrise) then
c ---          Compute gradual rise
               if(idw0(ipnum).EQ.2) then
c ---             Schulman-Scire building downwash
                  call prss(xrec,zly0(ipnum),r0(ipnum),ws0(ipnum),
     &                      istab0(ipnum),sqrts0(ipnum),diam0(ipnum),
     &                      exitw0(ipnum),fm(ipnum),fb(ipnum),
     &                      xmfin(ipnum),xbfin(ipnum),ssrise)
                  hgr=ht0(ipnum)+ssrise
               elseif(idw0(ipnum).EQ.1) then
c ---             Huber-Snyder building downwash
                  call grise(xrec,hgr,risefac)
                  rfacsq=risefac**2
               endif
            endif
c ---       Add BID contribution to sigmas
            if(bidsq.GT.zero) then
               syre=sqrt(syre**2+bidsq*rfacsq)
               szre=sqrt(szre**2+bidsq*rfacsq)
               syrb=syre
               szrb=szre
            endif
c
c ---       Skip to terrain adjustments
            goto 500
         endif
      endif

c --- Continue on for receptors outside downwash zone
c
c --- Set selected data in /CSIGMA/ for sigma calls
      call setcsig(idopty,idoptz,iru,uavg,istab,el,bvf,
     &             sigv,sigw,symin,szmin,ze1,dpbl)

c --- Set sigma-y squared for effective area source size for old slugs
      sysq=zero
      if(iage.EQ.1) sysq=sy0sq

c -------------------------------------------------------------------
c --- Find the receptor-specific sigmas for the FINAL slug position
c -------------------------------------------------------------------
c
c --- Avoid unrealistic interpolation during calm conditions by forcing
c --- sigmas to lie between those at the ends of the slug
      if(lcalm .AND. fracsf.LE.zero) then
         syre=sye2
         szre=sze2
      elseif(lcalm .AND. fracsf.GE.one) then
         syre=sye1
         szre=sze1
      else
c ---    Interpolate for virtual times/distances at receptor
c
c ---    SIGMA-Y
c --------------
c ---    Enforce hard-clipped interpolation factors for dispersion
         vty = vtye2 + hfracsf * (vtye1 - vtye2)
         vty = amax1(vty,zero)
         vdy = vdye2 + hfracsf * (vdye1 - vdye2)
         vdy = amax1(vdy,zero)
c
c ---    Compute the receptor-specific sigma (syare) via
c ---    'forward' call to the sigma routine (without BID)
         call sigty(dum0,vdy,vty,syare,dum1,dum2)

c ---    Add contribution due to BID at final rise and initial area
c ---    source size (after slug is emitted!)
         syre=syare
         if(bidsq.GT.zero .OR.
     &       sysq.GT.zero) syre=sqrt(syare**2+bidsq+sysq)

c ---    SIGMA-Z
c --------------
         if(MOD(icode,2).EQ.0) then
            szre=sze1
         else
c ---       Enforce hard-clipped interpolation factors for dispersion
            vtz = vtze2 + hfracsf * (vtze1 - vtze2)
            vtz = amax1(vtz,zero)
            vdz = vdze2 + hfracsf * (vdze1 - vdze2)
            vdz = amax1(vdz,zero)
c
c ---       Reset Heffter transition for sigma-z for current slug
            if(mhftsz.EQ.1) call heftran(2,zb1,dum0,dum0,
     &                                   vtze1,vtze2,vtye1,vtye2)
c
c ---       Compute the receptor-specific sigma (szare) via
c ---       'forward' call to the sigma routine (without BID)
            call sigtz(dum0,vdz,vtz,zb1,szare,dum1,dum2)

c ---       Add contribution due to BID at final rise
            szre=szare
            if(bidsq.GT.zero) szre=sqrt(szare**2+bidsq)
         endif
      endif

c -------------------------------------------------------------------
c --- Find the receptor-specific sigmas for the INITIAL slug position
c -------------------------------------------------------------------

c --- Consider the special case of the current period's emissions.

      if(iage.eq.0) then
c ---    Constrain the receptor-specific sigmas to be time independent.
c ---    Note that it may also be dangerous to compute them directly due
c ---    to zero length slug possibilities.
         syrb = syre
         szrb = szre

      else
c
c ---    Avoid unrealistic interpolation during calm conditions by
c ---    forcing sigmas to lie between those at the ends of the slug
         if(lcalm .AND. fracsi.LE.zero) then
            syrb=syb2
            szrb=szb2
         elseif(lcalm .AND. fracsi.GE.one) then
            syrb=syb1
            szrb=szb1
         else
c ---       Interpolate for virtual times/distances at receptor
c
c ---       SIGMA-Y
c -----------------
            vty = vtyb2 + hfracsi * (vtyb1 - vtyb2)
            vty = amax1(vty,zero)
            vdy = vdyb2 + hfracsi * (vdyb1 - vdyb2)
            vdy = amax1(vdy,zero)
c
c ---       Compute the receptor-specific sigma (syrb) via
c ---       'forward' call to the sigma routine (without BID)
            call sigty(dum0,vdy,vty,syarb,dum1,dum2)

c ---       Add contribution due to BID at final rise and initial area
c ---       source size
            syrb=syarb
            if(bidsq.GT.zero .OR.
     &          sysq.GT.zero) syrb=sqrt(syarb**2+bidsq+sysq)
c
c ---       SIGMA-Z
c -----------------
            if(MOD(icode,2).EQ.0) then
               szre=szb1
            else
               vtz = vtzb2 + hfracsi * (vtzb1 - vtzb2)
               vtz = amax1(vtz,zero)
               vdz = vdzb2 + hfracsi * (vdzb1 - vdzb2)
               vdz = amax1(vdz,zero)
c
c ---          Reset Heffter transition for sigma-z for current slug
               if(mhftsz.EQ.1) call heftran(2,zb1,dum0,dum0,
     &                                      vtzb1,vtzb2,vtyb1,vtyb2)
c
c ---          Compute the receptor-specific sigma (szrb) via
c ---          'forward' call to the sigma routine (without BID)
               call sigtz(dum0,vdz,vtz,zb1,szarb,dum1,dum2)
c
c ---          Add contribution due to BID at final rise
               szrb=szarb
               if(bidsq.GT.zero) szrb=sqrt(szarb**2+bidsq)
            endif
         endif

      endif

c
c --------------------------------------------------------------------
c --- Compute the gradual rise if appropriate ...............
c ---   Use ISC convention that gradual rise is used to compute
c ---   buoyancy enhancement to sigmas; and is used as the "plume"
c ---   height only if MTRANS=1
c --------------------------------------------------------------------
c
      if(xrec.LT.xfrise .AND. xrec.GT.zero) then
c ---    Compute gradual rise
         if(idw0(ipnum).EQ.2) then
c ---       Schulman-Scire building downwash
            call prss(xrec,zly0(ipnum),r0(ipnum),ws0(ipnum),
     &                istab0(ipnum),sqrts0(ipnum),diam0(ipnum),
     &                exitw0(ipnum),fm(ipnum),fb(ipnum),xmfin(ipnum),
     &                xbfin(ipnum),ssrise)
            hgr=ht0(ipnum)+ssrise
c ---       No BID here
            rfacsq=zero
         elseif(idw0(ipnum).EQ.1) then
c ---       Huber-Snyder building downwash
            call grise(xrec,hgr,risefac)
            rfacsq=risefac**2
         else
c ---       No building downwash
            call grise(xrec,hgr,risefac)
            rfacsq=risefac**2
         endif
      elseif(xrec.LE.zero) then
c ---    Receptor upwind of source
         hgr=ht0(ipnum)
         rfacsq=zero
      else
c ---    Final rise height (before any terrain adjustment)
         hgr=zfinal(ipnum)
         rfacsq=one
      endif
c
c --- Reset BID adjustment to account for gradual rise
c --- SUBTRACT subbid from sigmas**2 with BID at final rise
      subbid=bidsq*(one-rfacsq)
      if(subbid.GT.zero) then
c
         argy=syrb**2-subbid
         syrb=symin
         if(argy.GT.zero) syrb=sqrt(argy)
c
         argy=syre**2-subbid
         syre=symin
         if(argy.GT.zero) syre=sqrt(argy)
c
         argz=szrb**2-subbid
         szrb=szmin
         if(argz.GT.zero) szrb=sqrt(argz)
c
         argz=szre**2-subbid
         szre=szmin
         if(argz.GT.zero) szre=sqrt(argz)
c
      endif

c --- Set a "floor" to all sigma values equal to SY0, SZ0
c --- which are the minimum values allowed at the time of release
      if(iage.EQ.0 .AND. (istype.EQ.3 .OR. istype.EQ.4)) then
         if(syrb .LT. symin) syrb=symin
         if(syre .LT. symin) syre=symin
      else
         if(syrb .LT. sy0(ipnum)) syrb=sy0(ipnum)
         if(syre .LT. sy0(ipnum)) syre=sy0(ipnum)
      endif
      if(szrb .LT. sz0(ipnum)) szrb=sz0(ipnum)
      if(szre .LT. sz0(ipnum)) szre=sz0(ipnum)

500   continue


c --- Estimate slug height at receptor with gravitational settling
c --- (Initial Implementation!)
      if(mtilt.EQ.1) then
c ---    Use full settling over slug ages here (ht may be negative)
c ---    Older end
         dzprg1=-(tb1+fracso*(te1-tb1))*vsetl
c ---    Younger end
         dzprg2=-(tb2+fracsy*(te2-tb2))*vsetl
c ---    Average along-slug factor between initial and final positions
         if(te2.GT.1.0) then
c ---       Slug detached from source
            fracavg=0.5*(hfracsi+hfracsf)
         else
c ---       Slug attached to source
            fracavg=1.0
         endif
c ---    Limit to 0-1 range
         fracavg=AMAX1(0.0,fracavg)
         fracavg=AMIN1(1.0,fracavg)
         dzprg=dzprg2+fracavg*(dzprg1-dzprg2)
         dzprg=AMIN1(0.0,dzprg)
      else
         dzprg=0.0
      endif

c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      if(LDBG) then
         write(io6,*)'SLGRECS --  plume tilt'
         write(io6,*)'zb1,ze1,fracso   = ',zb1,ze1,fracso
         write(io6,*)'tb1,te1,dzprg1   = ',tb1,te1,dzprg1
         write(io6,*)'zb2,ze2,fracsy   = ',zb2,ze2,fracsy
         write(io6,*)'tb2,te2,dzprg2   = ',tb2,te2,dzprg2
         write(io6,*)'fracsi,fracsf    = ',fracsi,fracsf
         write(io6,*)'fracavg,dzprg    = ',fracavg,dzprg
      endif
c !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


c -------------------------------------------------------------------
c --- Section for terrain adjustments to slug or receptor height
c -------------------------------------------------------------------
c --- Use gradual rise height if requested, or if downwash is active
      if(mtrans.EQ.1 .OR. idw0(ipnum).GT.0) then
         zpr = hgr
      else
         zpr = zfinal(ipnum)
      endif

c --- Account for settling (may be negative)
      zpr=zpr+dzprg

      zrpole=z
      if(mctadj.eq.1 .OR. mctadj.eq.3) then
         call ctadj(zrterr,zpr,ht0(ipnum),elbase(ipnum),ppcoef,zpra)
         zpr=zpra
      elseif(mctadj.eq.2) then
c ---    Set receptor-specific slug height
         call SLUGCT2(x,y,lclip,rhoci,rhocf,fracsi,fracsy,fracso,
     &                xr1,yr1,xr2,yr2,zpr,fracsr)
         if(mtrans.EQ.1 .OR. idw0(ipnum).GT.0) then
            if(zfinal(ipnum).gt.0.0)then
c ---          Scale by ratio of gradual rise to final rise
               zpr = zpr*hgr/zfinal(ipnum)
            else
               zpr = 0.0
            endif
         endif
c ---    Set receptor elevation relative to dividing-streamline
         if(bvf.gt.0.0) then
c ---       Get elevation (m MSL) of hilltop for receptor
            ix=x*dgridi+1
            iy=y*dgridi+1
            eltop=relief(5,ix,iy)
c ---       Set elevation (m MSL) of dividing-streamline
            dsel=eltop-uavg/bvf
c ---       Set elevation (m MSL) beneath slug (receptor-specific)
c ---       OLD end of slug
            xr1met = xr1*dgridi
            yr1met = yr1*dgridi
            call GETELEV(xr1met,yr1met,zeo)
c ---       YOUNG end of slug
            xr2met = xr2*dgridi
            yr2met = yr2*dgridi
            call GETELEV(xr2met,yr2met,zey)
c ---       Interpolate elevation between ends
            ze=zey+fracsr*(zeo-zey)
c ---       Set dividing-streamline height above this elevation
            dsh=AMAX1(zero,dsel-ze)
c ---       Set elevation difference from receptor location to
c ---       dividing-streamline elevation
            zdiff=zrterr-dsel
c ---       Reset pole height if altered from "z"
            if(dsh.EQ.zero) then
               if(zdiff.LT.zero) zrpole=AMAX1(zero,z+zdiff)
            else
               if(zdiff.LT.0.0) then
                  zrpole=AMAX1(zero,z+zrterr-ze)
               else
                  zrpole=z+dsh
               endif
            endif
         endif
      endif

c --- Condition final effective puff ht to be non-negative
      zpr=AMAX1(zpr,0.0)

c --- Special DEBUG (normally inactive)
      if(LDBG) then
         write(io6,*)'SLGRECS:'
         write(io6,*)'fracs[i,f,y,o]= ',fracsi,fracsf,fracsy,fracso
         write(io6,*)'hfracs[i,f]   = ',hfracsi,hfracsf
         write(io6,*)'rhoa[i,f,y,o]= ',rhoai,rhoaf,rhoay,rhoao
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine plgrecs(lclip,pfac,x,y,istab,iru,sigv,sigw,el,bvf,
     &                   uavg,dpbl,frac,syr,szr,zpr)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                PLGRECS
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Computes the receptor-specific sigmas y and z, and
c               finds receptor-specific puff height (gradual rise)
c               with terrain adjustments for PLUGS
c               --- PLUGS are puff-like segments of a slug ---
c
c --- UPDATE
c --- V5.75-V5.8.4  130731  (EPA): Remove stack-tip downwash adjustment
c                                  to gradual rise because adjustment
c                                  is done within GRISE.
c --- V5.5-V5.75    050225  (DGS): add platform ht to DWSIGS call for
c                                  ISC building downwash (MBDW=1)
c                   050225  (DGS): Add DPBL arg to pass on to SETCSIG
c                                  for TAULY
c --- V5.4-V5.5     010730  (DGS): correct initial sigma used with
c                                  downwash sigma
c --- V5.3-V5.4     000602_2(DGS): add initial sigmas to downwash
c                                  sigmas in quadrature
c --- V5.0-V5.3     991222b (DGS): pass momentum flux to STKTIP
c --- V5.0-V5.0     980918  (DGS): use quadrature to include size of
c                                  area source
c --- V5.0-V5.0     980615  (DGS): return initial sigz if well-mixed
c --- V5.0-V5.0     980304  (DGS): use SY0,SZ0 as minimum sigmas
c --- V4.0-V5.0     971107  (DGS): initialize gradual rise at final
c                                  rise for x < 10 "Hb"
c --- V4.0-V5.0     971107  (DGS): package step interpolation in call
c                                  to SLGFRAC
c
c --- INPUTS:
c
c             LCLIP - logical - .TRUE. : limit "receptor position" to
c                                        lie within plug trajectory for
c                                        local plug influence
c                               .FALSE.: use actual receptor position
c                                        to determine sigmas
c              PFAC - real    - Factor denoting position of plug
c                               along slug (0: older end
c                                           1: newer end)
c            (X, Y) - real    - Coordinates of the receptor (m)
c                               NOTE: All Sigmas before any T factors.
c             ISTAB - integer - PGT stability class
c               IRU - integer - Rural(0) or urban(1) flag
c              SIGV - real    - Sigma-v velocity (m/s)
c              SIGW - real    - Sigma-w velocity (m/s)
c                EL - real    - Monin-Obukhov length (m)
c               BVF - real    - Brunt-Vaisala frequency (1/s)
c              UAVG - real    - Mean transport speed (m/s) over xtotm
c
c     Common Block /COMPARM/ variables:
c        SYMIN, SZMIN, TBD
c     Common Block /CURRENT/ variables: (for SLUGS)
c        XB1, YB1, ZB1, SYB1, SZB1,
c        XE1, YE1, ZE1, SYE1, SZE1,
c        XB2, YB2, ZB2, SYB2, SZB2,
c        XE2, YE2, ZE2, SYE2, SZE2,
c        xttb1,xttb2,xtte1,xtte2,
c        vtyb1,vtzb1,vtyb2,vtzb2,
c        vtye1,vtze1,vtye2,vtze2,
c        vdyb1,vdzb1,vdyb2,vdzb2,
c        vdye1,vdze1,vdye2,vdze2,
c        IAGE, SPEEDI, SRAT, TEMIS, bidsq, sy0sq, IPNUM, ISTYPE,
c        IDOPTY, IDOPTZ, ZPLAT
c     Common Block /FLAGS/ variables:
c        MTRANS, MTIP, MHFTSZ
c     Common Block /PUFF/ variables:
c        zfinal,xfinal,fb,fm,xbfin,xmfin,elbase,
c        idw0,ht0,exitw0,diam0,ws0,istab0,sqrts0,srat0,
c        hb0,hw0,heff20,iru0,sigv0,sigw0,el0,
c        plexp0,zly0,r0,xshift0,sy0,sz0,
c        sysrc0,szsrc0
c
c     Parameters:
c        IO6
c
c --- OUTPUTS:
c
c              FRAC - real    - Interpolation factor for receptor pos.
c                                 (0: at plug at start of step)
c                                 (1: at plug at end of step  )
c               SYR - real    - Receptor sigma Y (m)
c               SZR - real    - Receptor sigma Z (m)
c               ZPR - real    - Receptor-specific plug height (m)
c
c --- PLGRECS called by:  COMP
c --- PLGRECS calls:      SETCSIG, SIGTY, SIGTZ, DWSIGS, PRSS, GRISE,
c                         HEFTRAN, SLGFRAC
c----------------------------------------------------------------------
c
c --- Include parameter block
      include 'params.puf'

c --- Include common blocks
      include 'comparm.puf'
      include 'current.puf'
      include 'pt1.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'puff.puf'

      logical lclip

      data dum0/0.0/

cc --- DEBUG Section ---
c      write(io6,*) 'PLGRECS: Selected values passed in argument list'
c      write(io6,*) 'pfac, rec(x,y)  : ',pfac,x,y
c      write(io6,*) 'PLGRECS: Selected values passed in /CURRENT/'
c      write(io6,*) 'Younger end of slug ---'
c      write(io6,*) 'xb2,xb1,yb2,yb1 : ',xb2,xb1,yb2,yb1
c      write(io6,*) 'xttb2,xttb1     : ',xttb2,xttb1
c      write(io6,*) 'Older end of slug ---'
c      write(io6,*) 'xe2,xe1,ye2,ye1 : ',xe2,xe1,ye2,ye1
c      write(io6,*) 'xtte2,xtte1     : ',xtte2,xtte1
cc --- DEBUG Section ---

c -------------------------------------------------------------------
c --- Define plug parameters by interpolating from older end (1) to
c --- younger end (2) of slug by the factor PFAC
c -------------------------------------------------------------------

c --- At START:
c --- Position
      pxb1=xb1+pfac*(xb2-xb1)
      pyb1=yb1+pfac*(yb2-yb1)
c --- Height above ground (linear approximation)
      pzb1=zb1+pfac*(zb2-zb1)
c --- Total distance traveled
      pxttb1=xttb1+pfac*(xttb2-xttb1)
c --- Sigma-y (linear approximation)
      psyb1=syb1+pfac*(syb2-syb1)
c --- Virtuals
      pvtyb1=vtyb1+pfac*(vtyb2-vtyb1)
      pvtzb1=vtzb1+pfac*(vtzb2-vtzb1)
      pvdyb1=vdyb1+pfac*(vdyb2-vdyb1)
      pvdzb1=vdzb1+pfac*(vdzb2-vdzb1)

c --- At END:
c --- Position
      pxe1=xe1+pfac*(xe2-xe1)
      pye1=ye1+pfac*(ye2-ye1)
c --- Height above ground (linear approximation)
      pze1=ze1+pfac*(ze2-ze1)
c --- Sigma-y (linear approximation)
      psye1=sye1+pfac*(sye2-sye1)
c --- Virtuals
      pvtye1=vtye1+pfac*(vtye2-vtye1)
      pvtze1=vtze1+pfac*(vtze2-vtze1)
      pvdye1=vdye1+pfac*(vdye2-vdye1)
      pvdze1=vdze1+pfac*(vdze2-vdze1)

c -------------------------------------------------------------------
c --- Determine factor FRAC for interpolating virtual time/distance
c --- from plug at start as a fraction of plug-step
c ---                         (0: at plug at start of step)
c ---                         (1: at plug at end of step  )
c -------------------------------------------------------------------
      call SLGFRAC(x,y,pxe1,pye1,pxb1,pyb1,xr1,rhoc,frac,
     &             xbe1,rxbe1)
c
c --- Does interpolation factor need to be clipped?
      if(LCLIP) then
c ---    Extend the 0,1 range by the plug sigma-y at start and end
c ---    of step, scaled by length of step, and limit FRAC to this
c ---    range
         frac=AMAX1(frac,-psyb1*rxbe1)
         frac=AMIN1(frac,1.0+psye1*rxbe1)
      endif

c --- Do not allow receptor-specific puff properties to be
c --- extrapolated beyond the FRAC limit - change receptor "location"
      xr1=frac*xbe1

c --- Estimate total travel distance to receptor from source
      xtt1 = pxttb1+xr1
      if(xtt1.LT.0.0) then
         xtt1 = 0.0
         frac = -pxttb1*rxbe1
      endif

c -------------------------------------------------------------------
c --- Special case of building downwash ---
c -------------------------------------------------------------------
c     Point sources:
c     Consider the details of effects of the Huber-Snyder downwash
c     formulation or the Schulman-Scire downwash formulation on the
c     sigmas within 10 HL of the source.  This applies only if this
c     puff experiences building downwash.
c     POINT SOURCES !
c -------------------------------------------------------------------
      if(idw0(ipnum).GT.0 .AND. istype.LE.2) then
c ---    Check for receptors in downwash zone
         hl=amin1(hb0(ipnum),hw0(ipnum))
         if(xtt1.LT.(10.*hl)) then
c ---       Initialize ratio of (gradual/final)^2  (used for BID)
            rfacsq=1.0
            if(idw0(ipnum).EQ.2) rfacsq=0.0
            hgr=zfinal(ipnum)
c ---       Set selected data in /CSIGMA/ for sigma calls
            call setcsig(idopty,idoptz,iru0(ipnum),ws0(ipnum),
     &                   istab0(ipnum),el0(ipnum),sqrts0(ipnum),
     &                   sigv0(ipnum),sigw0(ipnum),symin,szmin,
     &                   zfinal(ipnum),dpbl)
c ---       Obtain sigmas in downwash zone
            call dwsigs(tbd,hw0(ipnum),hb0(ipnum),mhftsz,ws0(ipnum),
     &                  ht0(ipnum),heff20(ipnum),zplat,xtt1,sydw,szdw)
c ---       Add initial sigmas to downwash sigmas
            sydw=SQRT(sydw**2+sysrc0(ipnum)**2)
            szdw=SQRT(szdw**2+szsrc0(ipnum)**2)
c ---       Set a "floor" to the sigma values equal to SYMIN, SZMIN
            syr=amax1(sydw,symin)
            szr=amax1(szdw,szmin)
c ---       Assess gradual rise at all receptors in downwash zone
            if(xtt1.LT.xfrise) then
c ---          Compute gradual rise
               if(idw0(ipnum).EQ.2) then
c ---             Schulman-Scire building downwash
                  call prss(xtt1,zly0(ipnum),r0(ipnum),ws0(ipnum),
     &                      istab0(ipnum),sqrts0(ipnum),diam0(ipnum),
     &                      exitw0(ipnum),fm(ipnum),fb(ipnum),
     &                      xmfin(ipnum),xbfin(ipnum),ssrise)
                  hgr=ht0(ipnum)+ssrise
               elseif(idw0(ipnum).EQ.1) then
c ---             Huber-Snyder building downwash
                  call grise(xtt1,hgr,risefac)
                  rfacsq=risefac**2
               endif
            endif
c ---       Add BID contribution to sigmas
            if(bidsq.GT.0.0) then
               syr=sqrt(syr**2+bidsq*rfacsq)
               szr=sqrt(szr**2+bidsq*rfacsq)
            endif
c
c ---       Skip to puff height section
            goto 500
         endif
      endif

c --- Continue on for receptors outside downwash zone

c --------------------------------------------------------------------
c --- Compute the gradual rise if appropriate ...............
c ---   Use ISC convention that gradual rise is used to compute
c ---   buoyancy enhancement to sigmas; and is used as the "plume"
c ---   height only if MTRANS=1
c --------------------------------------------------------------------
c
      if(xtt1.LT.xfrise .AND. xtt1.GT.0.0) then
c ---    Compute gradual rise
         if(idw0(ipnum).EQ.2) then
c ---       Schulman-Scire building downwash
            call prss(xtt1,zly0(ipnum),r0(ipnum),ws0(ipnum),
     &                istab0(ipnum),sqrts0(ipnum),diam0(ipnum),
     &                exitw0(ipnum),fm(ipnum),fb(ipnum),xmfin(ipnum),
     &                xbfin(ipnum),ssrise)
            hgr=ht0(ipnum)+ssrise
c ---       No BID here
            rfacsq=0.0
         elseif(idw0(ipnum).EQ.1) then
c ---       Huber-Snyder building downwash
            call grise(xtt1,hgr,risefac)
            rfacsq=risefac**2
         else
c ---       No building downwash
            call grise(xtt1,hgr,risefac)
            rfacsq=risefac**2
        endif
      elseif(xtt1.LE.0.0 .AND. xfrise.GT.0.0) then
c ---    Receptor upwind of source, and final rise does NOT occur at
c ---    source (wind for plume rise is not "calm")
         hgr=ht0(ipnum)
         rfacsq=0.0
      else
c ---    Final rise
         hgr=zfinal(ipnum)
         rfacsq=1.0
      endif
c
c --- Set BID adjustment to account for gradual rise
c --- ADD addbid to ambient sigmas**2 without BID
      addbid=bidsq*rfacsq
c
c -------------------------------------------------------------------
c --- Find the receptor-specific sigmas, with BID
c -------------------------------------------------------------------
c
c --- Set selected data in /CSIGMA/ for sigma calls
      call setcsig(idopty,idoptz,iru,uavg,istab,el,bvf,
     &             sigv,sigw,symin,szmin,pze1,dpbl)
c
c ---    SIGMA-Y:
c ---------------
c --- Interpolate for virtual times/distances at receptor
      vty = AMAX1(0.0,(pvtyb1 + frac * (pvtye1 - pvtyb1)))
      vdy = AMAX1(0.0,(pvdyb1 + frac * (pvdye1 - pvdyb1)))
c
c --- Compute the receptor-specific sigma (syar) via 'forward'
c --- call to the sigma routine (without BID)
      call sigty(dum0,vdy,vty,syar,dum1,dum2)

c --- Adjust sigma:  add contribution due to buoyancy enhancement
      syr=syar
      if(addbid.GT.0.0 .OR.
     &    sy0sq.GT.0.0) syr=sqrt(syar**2+addbid+sy0sq)

c ---    SIGMA-Z:
c ---------------
      if(MOD(icode,2).EQ.0) then
         szr=szb1
      else
c
c ---    Interpolate for virtual times/distances at receptor
         vtz = AMAX1(0.0,(pvtzb1 + frac * (pvtze1 - pvtzb1)))
         vdz = AMAX1(0.0,(pvdzb1 + frac * (pvdze1 - pvdzb1)))
c
c ---    Reset Heffter transition for sigma-z for current slug
         if(mhftsz.EQ.1) call heftran(2,zfinal(ipnum),dum0,dum0,
     &                                vtzb1,vtze1,vtyb1,vtye1)
c
c ---    Compute the receptor-specific sigma (szar) via 'forward'
c ---    call to the sigma routine (without BID)
         call sigtz(dum0,vdz,vtz,zfinal(ipnum),szar,dum1,dum2)
      endif

c --- Adjust sigma:  add contribution due to buoyancy enhancement
      szr=szar
      if(addbid.GT.0.0) szr=sqrt(szar**2+addbid)

c --- Set a "floor" to the sigma values equal to SY0, SZ0
c --- which represent minimum values at release
      if(syr .LT. sy0(ipnum)) syr=sy0(ipnum)
      if(szr .LT. sz0(ipnum)) szr=sz0(ipnum)

500   continue
c -------------------------------------------------------------------
c --- Section for puff height at receptor
c -------------------------------------------------------------------
c --- Use gradual rise height if requested, or if downwash is active
      if(mtrans.EQ.1 .OR. idw0(ipnum).GT.0) then
         zpr = hgr
      else
         zpr = zfinal(ipnum)
      endif

c --- Height must not be greater than interpolated height from slug data
c --- Condition FRAC to fully clipped range
      fracz=AMAX1(0.0,frac)
      fracz=AMIN1(fracz,1.0)
c --- Interpolate height
      zslug=pzb1+fracz*(pze1-pzb1)
      zpr=AMIN1(zpr,zslug)

      return
      end
c----------------------------------------------------------------------
      subroutine slgfrac(x,y,x1,y1,x2,y2,rhoa,rhoc,fracs,dxy12,rdxy12)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                SLGFRAC
c                R. Yamartino, D. Strimaitis, SRC
c
c --- PURPOSE:  Computes along-slug and cross-slug distances from
c               the younger end (x2,y2) to a reference point (x,y),
c               the spatial interpolation factor for the scaled
c               along-slug position, and the slug length.
c
c --- INPUTS:
c
c            (X, Y) - real    - Coordinates of the reference point (m)
c          (X1, Y1) - real    - Coordinates of the old end of slug (m)
c          (X2, Y2) - real    - Coordinates of the new end of slug (m)
c
c
c --- OUTPUTS:
c
c              RHOA - real    - Distance along slug from end 2 to ref
c                               point (m)
c              RHOC - real    - Distance across slug from end 2 to ref
c                               point (m)
c             FRACS - real    - Distance along slug from end 2 to ref
c                               point, expressed as fraction of slug
c                               length
c             DXY12 - real    - Slug length in x-y plane (m)
c            RDXY12 - real    - Reciprocal of DXY12
c
c --- SLGFRAC called by:  PUFRECS, SLGRECS, SLUGAVE, SLUGSNP, SLUGINT,
c                         SLUGCT2, PLGRECS
c --- SLGFRAC calls:      none
c----------------------------------------------------------------------
      data one/1.0/, zero/0.0/

c --- Determine the length of the slug
      x12 = x1 - x2
      y12 = y1 - y2
c --- DXY12 is the projection of the slug length on the x-y plane
      dxy12 = SQRT(x12*x12 + y12*y12)

      if(dxy12.GE.one) then

c ---    Determine the orientation of the slug
c ---    Note that slug angles are defined cw (clockwise) from North
c ---    Define the cos and sin of omega.
c ---    note that omega = wind direction (met.) + pi for IAGE=0 slugs
         rdxy12 = one / dxy12
         cosom = y12 * rdxy12
         sinom = x12 * rdxy12

c ---    Define position of reference point relative to slug end 2
         xr = x - x2
         yr = y - y2

c ---    Convert reference position to along-slug and cross-slug axis
c        coordinates RHOA and RHOC respectively
         rhoa =  yr * cosom  +  xr * sinom
         rhoc = -xr * cosom  +  yr * sinom

c ---    FRACS is the fraction RHOA/DXY12 for this slug position
c ---    FRACS = 0 corresponds to the point (X2,Y2).
c ---    FRACS = 1 corresponds to the point (X1,Y1).
         fracs = rhoa * rdxy12

      else

c ---    SPECIAL CASE of small slug length (1 meter or less)
c ---    Just use scale factor of unity (this should not happen often)
c ---    and place reference point "across" this slug
         dxy12 = one
         rdxy12 = one
         xr = x - x2
         yr = y - y2
         rhoc = SQRT(xr*xr + yr*yr)
         rhoa = zero
         fracs = zero

      endif

      return
      end
c----------------------------------------------------------------------
      subroutine chem(nspec,mchem,maqchem,nhrind,tsamp,jsup,qsw,tempk,
     1 irh,rhoair,istab,hlid,chioz,chih2o2,cloud,zcoef,zmsl,ldbhr)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602_3                 CHEM
c                J. Scire, SRC
c
c --- PURPOSE:  Compute chemical transformation rates for each species
c               using the MESOPUFF II or RIVAD algorithm, or user-
c               specified diurnally varying values.  Adjust the mass
c               in each layer to account for chemical transformation
c               effects.
c
c --- UPDATE
c --- V5.4-V5.4
c          000602 - 000602_3(DGS): Add aqueous chemistry data
c --- V5.3-V5.4
c          991222 - 000602  (DGS): Add message to "stop"
c --- V5.2-V5.3
c          980918 - 991222  (DGS): Fix bug in assigning puff volume for
c                                  computing CON array for CHEMTF call
c                                  for mass above mixed layer
c --- V5.0-V5.0
c          980304 - 980918  (DGS): Add SOA module (MCHEM=4)
c          960521 - 980304  (DGS): include well-mixed limit on mean C
c                                : Store NO and NO2 for RIVAD option,
c                                  but keep NOx for the other options
c
c --- INPUTS:
c
c             NSPEC - integer - Number of chemical species
c             MCHEM - integer - Chemical transformation mechanism
c                               flag (0 = no transformation,
c                               1 = MESOPUFF II scheme,
c                               2 = user-specified rates, except
c                                   HNO3 <--> NO3 based on equilibrium
c                                   equation
c                               3 = RIVAD scheme with HNO3 <--> NO3
c                                   equilibrium)
c                               4 = Form SOA from VOC emissions
c           MAQCHEM - integer - Aqueous phase transformation flag
c                               0 = aqueous phase transformation
c                                   not modeled
c                               1 = transformation rates adjusted
c                                   for aqueous phase reactions
c            NHRIND - integer - Current hour (01-24)
c             TSAMP - real    - Sampling step (s)
c              JSUP - integer - effective stability class above the
c                               mixed layer
c               QSW - real    - Short-wave solar radiation (W/m**2)
c             TEMPK - real    - Air temperature (deg. K)
c               IRH - integer - Relative humidity (percent)
c            RHOAIR - real    - Air density (kg/m**3)
c             ISTAB - integer - PGT stability class
c              HLID - real    - Height of reflecting lid (m)
c             CHIOZ - real    - Ozone concentration (ppb) to use in
c                               chemistry calculations
c           CHIH2O2 - real    - background H2O2 concentration (ppb)
c             CLOUD - real    - Cloud cover (tenths)
c             ZCOEF - real    - Cosine of solar zenith angle
c              ZMSL - real    - Height of puff above sea level (m)
c             LDBHR - logical - Variable controlling debug write
c                               statements
c
c     Common Block /CHEMDAT/ variables:
c        MOZ, BCKNH3, RNITE1, RNITE2, RNITE3, CHEMT(24,3),
c        NOZSTA
c     Common Block /CURRENT/ variables:
c        SYB1,SZB1,SYE1,SZE1,
c        SPEEDI,TEMIS,IPNUM,ICODE
c     Common Block /DATE/ variables:
c        NDATHR
c     Common Block /PUFF/ variables:
c        QM(mxspec,mxpuff), QU(mxspec,mxpuff)
c     Parameters:
c        MXPUFF, MXSPEC, MXOZ, MXNX, MXNY, IO6, IO22
c
c --- OUTPUT:
c     Common Block /PUFF/ variables:
c        QM(mxspec,mxpuff), QU(mxspec,mxpuff)
c
c --- CHEM called by:  COMP
c --- CHEM calls:      CHEMTF, CHEMRIV, CHEMSOA
c----------------------------------------------------------------------
c
c --- Include PARAMETERS
      include 'params.puf'
c
c --- Include common blocks
      include 'chemdat.puf'
      include 'current.puf'
      include 'puff.puf'
c
      real rmid(3),rup(3),ruser(3)
      real rmid3(4),rup3(4)
      real rmid4(4),rup4(4)
      real qmid(mxspec),qup(mxspec)
      real con(mxspec)
      integer noreact5(5),noreact6(6)
      logical ldbhr,ldb,lentrain
c
      data rmid/3*0.0/,rup/3*0.0/,ruser/3*0.0/
      data rmid3/4*0.0/,rup3/4*0.0/
      data rmid4/4*0.0/,rup4/4*0.0/
      data qmid/mxspec*0.0/,qup/mxspec*0.0/
      data con/mxspec*0.0/
      data imiss/9999/,xmiss/9999./
      data noreact5/1,1,2,3,3/
      data noreact6/1,1,3,3,4,4/
      data xscale/0.984127/

c --- Set local debug switch here
      ldb=ldbhr
c --- ldb=.TRUE.

c --- Do not consider entrained volume
      lentrain=.FALSE.

c --- Check that required data are not missing
      if(qsw.ge.xmiss.or.tempk.ge.xmiss.or.irh.ge.imiss.or.
     1 rhoair.ge.xmiss)then
         write(io6,*)'ERROR in SUBR. CHEM -- Required data are',
     1   ' missing -- QSW = ',qsw,' TEMPK = ',tempk,' IRH = ',irh,
     2   ' RHOAIR = ',rhoair
         write(*,*)
         stop 'Halted in CHEM -- see list file.'
      endif

c --- Set local puff index to value in /CURRENT/
      jp=ipnum

c --- Identify position of TNO3 in the species list (NT)
c --- MCHEM=0,1,2:  SO2,SO4,NOX,TNO3,NO3       - NT=4
c --- MCHEM=3    :  SO2,SO4,NO ,NO2 ,TNO3,NO3  - NT=5
c --- and set IREACT, the number of reaction rates required
      if(mchem.LT.3) then
         nt=4
         ireact=noreact5(MIN0(nspec,5))
      elseif(mchem.EQ.3) then
         nt=5
         ireact=noreact6(MIN0(nspec,6))
      elseif(mchem.EQ.4) then
c ---    Set nt>nspec to disable since TNO3 not modeled in CHEMSOA
         nt=nspec+1
      endif
      nt1=nt+1

c --- Compute chemical conversion rates
      if(mchem.eq.0)then
c ---    No chemical conversion
         do i=1,ireact
            rmid(i)=0.0
            rup(i)=0.0
         enddo
         go to 100
      elseif(mchem.eq.2)then
c ---    User-specified chemical conversion rates
         do i=1,ireact
            ruser(i)=chemt(nhrind,i)
         enddo
      endif
c
c --- Compute and apply modeled (MESOPUFF II or RIVAD, or SOA)
c --- conversion rates or apply user-specified conversion rates
c
      rhum=irh
      delt=tsamp/3600.
c
c --- Clear working arrays and assign mass in each layer
      do i=1,mxspec
         qup(i)=0.0
         qmid(i)=0.0
      enddo
      do i=1,nspec
         qup(i)=qu(i,jp)
         qmid(i)=qm(i,jp)
      enddo
c
c --- NOTE: TNO3 = HNO3 + NO3 is required by the chemical module
c --- (does not apply to mchem=4)
      if(nspec.ge.nt)then
c ---    XSCALE is 0.984127 = 62./63. = (mol. wt. NO3)/(mol. wt. HNO3)
         qup(nt)=qu(nt,jp)*xscale+qu(nt1,jp)
         qmid(nt)=qm(nt,jp)*xscale+qm(nt1,jp)
      endif

c --- Puff volume computation (for mean concentration) follows MESOPUFF
c --- approach.  Length scale is SQRT(2pi)*sigma/0.723 = sigma*3.467
c --- Use puff or old end of slug for length scales (end of step)
      if(mchem.NE.4) then
         ylenb=syb1*3.467
         zlenb=szb1*3.467
         ylene=sye1*3.467
         zlene=sze1*3.467
         pareab=ylenb**2
         pareae=ylene**2
         if(icode.LT.10) then
c ---       Puff
            icd=icode
         else
c ---       Slug
            icd=icode-10
         endif
c ---    Set vertical length scales for upper and main layer
         if(icd.EQ.2 .OR. icd.EQ.4 .OR. icd.EQ.6) then
c ---       Uniformly mixed in the vertical
            zlenue=zimax(jp)-hlid
            zlenme=hlid
            zlenub=zlenue
            zlenmb=zlenme
         elseif(icd.eq.1) then
            zlenue=0.0
            zlenme=AMIN1(zlene,hlid)
            zlenub=0.0
            zlenmb=AMIN1(zlenb,hlid)
         elseif(icd.eq.3) then
            zlenue=zlene
            zlenme=zlene
            zlenub=zlenb
            zlenmb=zlenb
         elseif(icd.eq.5) then
            zlenue=zimax(jp)-hlid
            zlenme=AMIN1(zlene,hlid)
            zlenub=zlenue
            zlenmb=AMIN1(zlenb,hlid)
         endif
c ---    Compute entrained volume during step
         ventm=AMAX1(0.0,pareae*zlenme-pareab*zlenmb)
         ventu=AMAX1(0.0,pareae*zlenue-pareab*zlenub)
c ---    Compute 1/volume at end of step
         pivolu=pareae*zlenue
         if(pivolu.GT.0.0) pivolu=1./pivolu
         pivolm=pareae*zlenme
         if(pivolm.GT.0.0) pivolm=1./pivolm
      endif


c --- Transformation in the mixed layer
c
c --- If non-zero mass in mixed layer, compute transformation rates
c --- NOTE: (qmid(nt) = q(TNO3))
      qtot=0.0
      do i=1,nt
         qtot=qtot+qmid(i)
      enddo
      if(qtot.gt.0.0)then
         if(mchem.NE.4 .AND. pivolm.LE.0.0) then
            write(io6,*)'CHEM:  No Puff volume below lid!'
            write(io6,*)'       Puff ID = ',ipnum
            write(*,*)
            stop 'Halted in CHEM -- see list file.'
         endif
         if(mchem.LE.2) then
            do i=1,nt1
               con(i)=qmid(i)*pivolm
            enddo
            call CHEMTF(delt,con,qmid,chioz,bcknh3,chih2o2,qsw,tempk,
     1                  rhum,rhoair,istab,rnite1,rnite2,rnite3,mchem,
     2                  maqchem,ruser,nspec,ldb,io6,rmid)
         elseif(mchem.EQ.3) then
            o3ent=chioz
            if(lentrain) o3ent=chioz*ventm*pivolm
            call CHEMRIV(delt,qmid,o3ent,bcknh3,chih2o2,maqchem,tempk,
     1                   rhum,rhoair,pivolm,zmsl,cloud,zcoef,nspec,
     2                   ldb,io6,rmid3)
         elseif(mchem.EQ.4) then
            call CHEMSOA(ldb,io6,delt,qmid,istab,qsw,tempk,chioz,rmid4)
         endif
      endif

c
c --- Transformation above the mixed layer
c
c --- If non-zero mass in upper layer, compute transformation rates
c --- NOTE: (qup(nt) = q(TNO3))
      qtot=0.0
      do i=1,nt
         qtot=qtot+qup(i)
      enddo
      if(qtot.gt.0.0)then
         jdstab=jsup
         if(jdstab.eq.0)jdstab=istab
         if(mchem.NE.4 .AND. pivolu.LE.0.0) then
            write(io6,*)'CHEM:  No Puff volume above lid!'
            write(io6,*)'       Puff ID = ',ipnum
            write(*,*)
            stop 'Halted in CHEM -- see list file.'
         endif
         if(mchem.LE.2) then
            do i=1,nt1
               con(i)=qup(i)*pivolu
            enddo
            call CHEMTF(delt,con,qup,chioz,bcknh3,chih2o2,qsw,tempk,
     1                  rhum,rhoair,jdstab,rnite1,rnite2,rnite3,mchem,
     2                  maqchem,ruser,nspec,ldb,io6,rup)
         elseif(mchem.EQ.3) then
            o3ent=chioz
            if(lentrain) o3ent=chioz*ventu*pivolu
            call CHEMRIV(delt,qup,chioz,bcknh3,chih2o2,maqchem,tempk,
     1                   rhum,rhoair,pivolu,zmsl,cloud,zcoef,nspec,
     2                   ldb,io6,rup3)
         elseif(mchem.EQ.4) then
            call CHEMSOA(ldb,io6,delt,qup,jdstab,qsw,tempk,chioz,rup4)
         endif
      endif
C
      do i=1,nspec
         qm(i,jp)=qmid(i)
         qu(i,jp)=qup(i)
      enddo
c
c --- XSCALE is 0.984127 = 62./63. = (mol. wt. NO3)/(mol. wt. HNO3)
c --- (does not apply to mchem=4)
      if(nspec.ge.nt)then
         qm(nt,jp)=(qmid(nt)-qmid(nt1))/xscale
         qu(nt,jp)=(qup(nt)-qup(nt1))/xscale
         qm(nt1,jp)=qmid(nt1)
         qu(nt1,jp)=qup(nt1)
      endif
c
100   continue
c*****
      if(ldb)then
         write(io6,*)'CHEMICAL CONVERSION over step (s): ',tsamp
         if(mchem.EQ.3) then
            write(io6,103) rup3
            write(io6,105) rmid3
         elseif(mchem.EQ.4) then
            write(io6,103) rup4
            write(io6,105) rmid4
         else
            write(io6,103) (rup(n),n=1,ireact)
            write(io6,105) (rmid(n),n=1,ireact)
         endif
103      format(5x,'UPPER LAYER',2x,'rup =',4F12.2)
105      format(5x,'MIXED LAYER',2x,'rmid=',4F12.2)
      endif
c*****
      return
      end
c----------------------------------------------------------------------
      subroutine chemtf(delt,con,q,coz,ctnh3,ch2o2,qsw,temp,
     1 rhum,rhoair,istab,rnite1,rnite2,rnite3,mchem,maqchem,ruser,
     2 nspec,ldb1,io6,r)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602_3               CHEMTF
c                J. Scire
c --- Adapted from MESOPUFF II Subr. CHEMTF written by F. Lurmann
c     MESOPUFF II   VERSION 4.41  LEVEL 821201   CHEMTF     ERT
c
c --- PURPOSE:  This routine adjusts the pollutant mass values
c               to account for chemical transformations
c
c --- UPDATE
c --- V5.4-V5.4
c          000602 - 000602_3(DGS): add aqueous chemistry module
c --- V5.0-V5.4
c          980615 - 000602  (DGS): add message to "stop"
c --- V5.0-V5.0
c          960612 - 980615  (DGS): fix NSPEC loop (limit = 5)
c
c --- INPUTS:
c         DELT - real    - integration time interval (hours)
c       CON(5) - real    - Concentrations current time (g/m**3)
c                            CON(1) = SO2  (not used within CHEMTF)
c                            CON(2) = SO4
c                            CON(3) = NOx  (NO + NO2 weighed as NO2)
c                            CON(4) = TNO3 (HNO3 + NO3)
c                            CON(5) = NH4NO3  (not used within CHEMTF)
c         Q(5) - real    - Pollutant mass (g) in the puff
c                            Q(1) = SO2
c                            Q(2) = SO4
c                            Q(3) = NOx
c                            Q(4) = TNO3 (HNO3 + NO3)
c                            Q(5) = NH4NO3
c          COZ - real    - background ozone concentration (ppb)
c        CTNH3 - real    - background ammonia concentration (ppb)
c        CH2O2 - real    - background H2O2 concentration (ppb)
c          QSW - real    - total solar radiation (W/m**2)
c         CNOX - real    - NOx concentration current time (ppb)
c         TEMP - real    - temperature (deg. K)
c         RHUM - real    - relative humidity (percent)
c       RHOAIR - real    - surface air density (kg/m**3)
c        ISTAB - integer - PGT stability class (1-6)
c       RNITE1 - real    - nighttime SO2 loss rate (percent/hour)
c       RNITE2 - real    - nighttime NOx loss rate (percent/hour)
c       RNITE3 - real    - nighttime HNO3 formation rate (percent/hour)
c        MCHEM - integer - Chemical transformation mechanism
c                          flag (0 = no transformation,
c                            1 = MESOPUFF II scheme,
c                            2 = user-specified rates, except
c                                HNO3 <--> NO3 based on equilibrium
c                                equation)
c      MAQCHEM - integer - Aqueous phase transformation flag
c                            0 = aqueous phase transformation
c                                not modeled
c                            1 = transformation rates adjusted
c                                for aqueous phase reactions
c     RUSER(3) - real    - User-specified conversion rates (percent/hr)
c        NSPEC - real    - number of species
c         LDB1 - logical - Control variable for printing of debug
c                          information
c          IO6 - integer - Fortran unit number of printed output
c
c --- OUTPUT:
c         R(3) - real    - Transformation rates (percent/hour)
c                            R(1) -- SO2 loss rate
c                            R(2) -- NOx loss rate
c                            R(3) -- HNO3 formation rate
c
c --- CHEMTF called by: CHEM
c --- CHEMTF calls:     CHEMII, CHEMEQ, AQTEST
c----------------------------------------------------------------------
c
      real con(5),ppb(5),q(5),r(3),ruser(3)
      real rmwt(5)
      logical ldb1
c
c --- Note: HNO3 is weighed as NO3
      data rmwt/64.,96.,46.,62.,62./

c --- Define default fraction of mass available for aqueous phase chem
c --- as a fraction/hour
      data faqmass0/0.02/
c
c --- Define local NSPEC to be no greater than 5
      nspec5=MIN0(nspec,5)
c
c --- Convert units of solar radiation from W/m**2 to KW/m**2
      tsr=0.001*qsw
c
c --- Combine %-conversion with time-step
      dt=0.01*delt
c
c --- Convert concentrations from g/m**3 to ppb
c --- Note: constant 28.97e6 is based on rho in kg/m**3, not g/m**3
      f=28.97e6/rhoair
      do 10 i=1,nspec5
      ppb(I)=con(i)*f/rmwt(i)
10    continue

c --- Initialize parameters for aqueous phase chem
c --- Available SO2 mass fraction
      faqmass=0.0
c --- Fraction of available SO2 lost
      faqloss=0.0
c
c --- Compute transformation rates
c
      if(mchem.eq.1)then
c
c ---    Using MESOPUFF II scheme to compute transformation rates
         call chemii(ppb(3),coz,tsr,rhum,istab,rnite1,rnite2,
     1   rnite3,r)
c ---    SO2 loss rate if using aqueous phase module
         if(maqchem.EQ.1) then
            call AQTEST(delt,con,coz,ctnh3,ch2o2,temp,
     1                  rhoair,ldb1,io6,raq)
c ---       Factor for SO2 loss rate from Aqueous Chem Module
            faqloss=(1.-exp(-raq*dt))
            faqmass=faqmass0*delt
         endif
      else if(mchem.eq.2)then
c
c ---    Using user-specified conversion rates
         r(1)=ruser(1)
         r(2)=ruser(2)
         r(3)=ruser(3)
      else
         write(io6,*)'ERROR in SUBR. CHEMTF -- Invalid value of ',
     1   'MCHEM passed to routine -- MCHEM = ',mchem
         write(*,*)
         stop 'Halted in CHEMTF -- see list file.'
      endif
c
c --- Perform transformation/integration
c
c------------- SOX --------------------
c
c --- Factor for SO2 loss rate from Chem Module
      floss=(1.-exp(-r(1)*dt))
c
      dc1=q(1)*((1.-faqmass)*floss+faqmass*faqloss)
      q(1)=q(1)-dc1
      q(2)=q(2)+rmwt(2)*dc1/rmwt(1)
c
c------------- NOX --------------------
c
      if(nspec5.ge.3)then
         dc1=q(3)*(1.-exp(-r(2)*dt))
         dc2=q(3)*(1.-exp(-r(3)*dt))
         q(3)=q(3)-dc1
         q(4)=q(4)+rmwt(4)*dc2/rmwt(3)
         q(5)=0.0
         if(q(4).gt.0.0)then
c
c ---       Adjust total ammonia for that absorbed by SO4 in the puff
            canh3=ctnh3-2.*ppb(2)
            if(canh3.gt.0.0)then
c
c ---          Compute NH4NO3 concentration from chemical equilibrium
               call chemeq(canh3,ppb(4),rhum,temp,ppb(5),ehno3,ehn3,io6)
c
c ------------ HNO3, NH4NO3 --------------
               pfrac=0.0
               if(ppb(4).gt.0.0)pfrac=ppb(5)/ppb(4)
c ---          Prevent round-off problem; PFRAC must be 0.0-1.0
               pfrac=amax1(pfrac,0.0)
               pfrac=amin1(pfrac,1.0)
               q(5)=q(4)*pfrac
c*****
               if(ldb1)write(io6,2028)pfrac,ppb(4),ehno3,ppb(5),ehn3,
     1          rhum,temp
2028           format(24x,'PFRAC=',f4.2,1x,'TNO3(ppb)=',f6.2,1x,
     1          'HNO3(ppb)=',f6.2,1x,'NO3(ppb)=',f6.2,1x,'NH3(ppb)=',
     2          f6.2,1x,'RHUM=',f4.0,1x,'TEMP=',f5.1)
c*****
            endif
         endif
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine chemii(cnox,coz,tsr,rhum,istab,rnite1,rnite2,
     1 rnite3,r)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 941215                   CHEM
c                J. Scire
c --- Adapted from MESOPUFF II Subr. CHEMTR written by F. Lurmann
c
c --- Purpose: Calculate the chemical tranformation rates for loss
c              of SO2 & NOx and formation of SO4 & HNO3
c
c --- INPUTS:
c         CNOX - real    - NOx concentration current time (ppb)
c          TSR - real    - total solar radiation (KW/M**2)
c        ISTAB - integer - PGT stability class (1-6)
c         RHUM - real    - relative humidity (percent)
c          COZ - real    - background ozone concentration (ppb)
c       RNITE1 - real    - nighttime SO2 loss rate (percent/hour)
c       RNITE2 - real    - nighttime NOx loss rate (percent/hour)
c       RNITE3 - real    - nighttime HNO3 formation rate (percent/hour)
c
c --- OUTPUT:
c         R(3) - real    - Transformation rates (percent/hour)
c                            R(1) -- SO2 loss rate
c                            R(2) -- NOx loss rate
c                            R(3) -- HNO3 formation rate
c
c --- CHEMII called by: CHEM
c --- CHEMII calls:     none
c----------------------------------------------------------------------
      real r(3)
c
c --- Initialize conversion rates
      do 10 i=1,3
      r(i)=0.0
10    continue
c
      co3ppm=0.001*coz
      st=amax0(istab,2)
c
c ---------------------------
c --- SOx transformation rate
c ---------------------------
      if(tsr.le.0.)then
c
c ---    Use nighttime transformation rate
         r(1)=rnite1
      else
c
c ---    Compute daytime transformation rate
         r(1)=36.*(tsr**.55)*(co3ppm**.71)/(st**1.29)
c ---    Add heterogeneous component
         rshet=3.E-8*(rhum**4)
         rshet=amax1(rshet,0.2)
         r(1)=r(1)+rshet
      endif
c
c ----------------------------
c --- NOx transformation rates
c ----------------------------
      if(tsr.le.0.)then
c
c ---    Use nighttime transformation rates
         r(2)=rnite2
         r(3)=rnite3
      else
c
c ---    Compute daytime transformation rates
         cnppm=0.001*cnox
         cnppm=amax1(cnppm,1.e-4)
         r(2)=1206.*(co3ppm**1.50)/(cnppm**.329)/(st**1.41)
         r(3)=1262.*(co3ppm**1.45)/(cnppm**.122)/(st**1.34)
         r(3)=amin1(r(2),r(3))
      endif
c
      return
      end
c----------------------------------------------------------------------
      SUBROUTINE CHEMEQ(CANH3,CTNO3,RHUM,TEMP,CPNO3,EHNO3,ENH3,io6)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960612                 CHEMEQ
c --- Adapted from MESOPUFF II Subr. CHEMEQ
c     MESOPUFF II   VERSION 4.41  LEVEL 821201   CHEMEQ     ERT
C
C      THIS ROUTINE DETERMINES AMMONIUM NITRATE CONCENTRATION
C      FROM TOTAL NITRATE CONCENTRATION.
C
C INPUTS:  CANH3 = TOTAL AMMONIA AVAILIABLE FOR NH4NO3 FORMATION (PPB)
C                  (IE. TOTAL AMMONIA - SULFATE)
C          CTNO3 = PUFF TOTAL NITRATE CONCENTRATION (PPB)
C           RHUM = RELATIVE HUMIDITY (PERCENT)
C           TEMP = TEMP (DEG K)
C           io6 = LOGICAL UNIT OF PRINTED OUTPUT FILE
C
C OUTPUTS: CPNO3 = EQUILIBRIUM NH4NO3 AEROSOL CONCENTRATION (PPB)
C          EHNO3 = EQUILIBRIUM GASEOUS HNO3 CONCENTRATION (PPB)
C          ENH3  = EQUILIBRIUM GASEOUS NH3 CONCENTRATION (PPB)
C
C METHOD:  WE ASSUME HNO3, NH3, AND NH4NO3 ARE IN EQUILIBRIUM.
C
C          HNO3 + NH3 <---> NH4NO3
C
C          K = (NH3)*(HNO3)/(NH4NO3)
C
C          K HAS BEEN SHOWN TO BE A NONLINEAR FUNCTION OF
C          RELATIVE HUMIDITY AND TEMPERATURE.
C
C          WE USE DOUBLE LINEAR INTERPOLATION ON TABULATED DATA
C          TO DETERMINE K FROM RHUM AND TEMP.
C
C          EQUILIBRIUM CONSTANT DATA OBTAINED FROM:
C
C          STELSON,A.W. AND J.H.SEINFELD 1982.  RELATIVE HUMIDITY
C          AND TEMPERATURE DEPENDENCE OF AMMONIUM NITRATE
C          DISSOCIATION CONSTANT. ATMOSPHERIC ENVIRONMENT.
C          VOL.16,NO.5,PP 983-992.
C
C          GIVEN CTNO3, CANH3, AND K, NH4NO3 IS DETERMINED
C          FROM THE FOLLOWING EQUATION:
C
C          NH4NO3 = 0.5 * (B - SQRT(B**2 -4*CTNO3*CANH3) )
C          WHERE B = K + CTNO3 + CANH3
C
      DIMENSION EQKD(10,5), RHUMD(10), TEMPD(5)
      double precision b,r
C
C------ RELATIVE HUMIDITY VECTOR    (DATA IN PERCENT)
      DATA RHUMD /0.,50.,60.,70.,75.,80.,85.,90.,95.,100./
      DATA NRHUMD /10/
C------ TEMPERATURE VECTOR     (DATA IN DEGREES KELVIN)
      DATA TEMPD /273.,283.,293.,303.,313./
      DATA NTEMPD /5/
C------ EQUILIBRIUM CONSTANT ARRAY   (DATA IN PPB)
      DATA EQKD /        5*.029,  .02,  .012,  .008,  .003,  .0001,
     1              4*.535,.400,  .30,   .24,   .15,   .04,   .001,
     2         3*8.0,   7.,  6.,   4.,    3.,   1.5,    .4,    .01,
     3   2*99.6, 98.,  75., 60.,  40.,   28.,   13.,    4.,    .02,
     4  2*1047.,1000.,700.,500., 400.,  250.,  120.,   20.,    .05/
C
C------- FIND THE INDICES IN TEMPD WHICH BRACKET TEMP
C
      TEMPX = TEMP
      TEMPX = AMAX1(TEMPX,TEMPD(1))
      TEMPX = AMIN1(TEMPX,TEMPD(NTEMPD))
      N = NTEMPD - 1
c *** NOTE: If tempx=tempd(1) i.e., temp < tempd(1) won't satisfy the
c ***       following if therefore changing .GT. to .GE. -- 5/30/93
      DO 100 K=1,N
c***  IF( (TEMPX.GT.TEMPD(K)) .AND. (TEMPX.LE.TEMPD(K+1)) )  GO TO 110
      IF( (TEMPX.ge.TEMPD(K)) .AND. (TEMPX.LE.TEMPD(K+1)) )  GO TO 110
100   CONTINUE
110   K1 = K
      K2 = K + 1
C------- INTERPOLATION ON RELATIVE HUMIDITY AT
C        THE UPPER AND LOWER TEMPERATURES.
      EQK1 = TRPF(RHUM,RHUMD,EQKD(1,K1),NRHUMD)
      EQK2 = TRPF(RHUM,RHUMD,EQKD(1,K2),NRHUMD)
C------- INTERPOLATE ON TEMPERATURE TO FIND K
      EQK = EQK1 + ((TEMPX-TEMPD(K1))/(TEMPD(K2)-TEMPD(K1)))*(EQK2-EQK1)
C------- SOLVE THE QUADRATIC EQN FOR NH4NO3 CONCENTRATION
      B = EQK + CANH3 + CTNO3
      R = B**2 - 4.*CANH3*CTNO3
      IF(R.LT.0.)  GO TO 120
c *** Change to double precision to avoid precision problems
c *** as recommended by J. Vimont (NPS) - 6/96
c *** CPNO3 = (B -SQRT(R))/2.
      CPNO3 = 0.5d0*(B-DSQRT(R))
      if((ctno3-cpno3).lt.0.0)then
        cpno3=ctno3
      endif
c --- Add checks to avoid problems when b**2 = r
      cpno3 = amax1(cpno3,0.0)
      EHNO3 = CTNO3 - CPNO3
      ehno3 = amax1(ehno3,0.0)
      ENH3 = CANH3 - CPNO3
      enh3 = amax1(enh3,0.0)
      RETURN
120   WRITE(io6,130) CANH3,CTNO3,TEMP,rhum,EQK
130   FORMAT(56H1JOB ABORTED IN CHEMEQ -- QUADRATIC EQN NOT SOLVABLE
     1,//, 30H NH3, TNO3, TEMP, RHUM, EQK =         ,5E12.4)
      write(*,*)
      stop 'Halted in CHEMEQ -- see list file.'
      END
c----------------------------------------------------------------------
      FUNCTION TRPF(X,XS,FS,NXF)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 941215                   TRPF
c --- Adapted from MESOPUFF II Subr. CHEM
c     MESOPUFF II   VERSION 4.41  LEVEL 821201   TRPF     ERT
c
C--------- TRPF IS A LINEAR INTERPOLATOR
      DIMENSION XS(NXF),FS(NXF)
      IF(XS(NXF)-XS(1))  100,120,120
100   DO 110 K =1,NXF
      IF(X-XS(K))  110,110,140
110   CONTINUE
      K=NXF + 1
      GO TO 140
120   DO 130 K=1,NXF
      IF(XS(K)-X)  130,130,140
130   CONTINUE
      K=NXF + 1
140   KL=K-1
      IF(K-2) 160,170,150
150   IF(K-NXF) 170,170,180
160   TRPF = FS(1)
      RETURN
170   DX = XS(K) - XS(KL)
      IF(DX.NE.0.0000)  GO TO 175
      TRPF = FS(KL)
      RETURN
175   TRPF =FS(KL)+(X-XS(KL))*(FS(K)-FS(KL))/DX
      RETURN
180   TRPF = FS(NXF)
      RETURN
      END
c----------------------------------------------------------------------
      subroutine chemi(mchem,maqchem,ldb)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 051130                  CHEMI
c                J. Scire, SRC
c
c --- PURPOSE:  Setup functions for the chemistry module
c                 -- Read user-specified conversion rates from CHEM.DAT
c                 -- Read header & time-invariant records of the
c                    hourly ozone data file (OZONE.DAT) and the
c                    hourly H2O2 data file (H2O2.DAT)
c                 -- Perform conversion of station coordinates and
c                    compute nearest ozone station to each grid point
c
c --- UPDATE
c --- V5.727-V5.753
c          050309 - 051130  (DGS): Add OZONE.DAT Dataset 2.1
c --- V5.7-V5.727
c          030402 - 050309  (DGS): revise UTM zone check for OZONE.DAT
c --- V5.4-V5.7
c          000602_3- 030402 (DGS): add /MAP/
c --- V5.4-V5.4
c          000602 - 000602_3(DGS): add H2O2.DAT for aqueous chemistry
c --- V5.0-V5.4
c          990130 - 000602  (DGS): add message to "stop"
c --- V5.0-V5.0
c          980918 - 990130  (JSS): fixed logic for NSPEC=2 and 3
c          980304 - 980918  (DGS): add MCHEM=4 logic and species QA
c                                  fix SOA species name checking
c          941215 - 980304  (DGS): add MCHEM=3 logic and species QA
c
c --- INPUTS:
c             MCHEM - integer - Chemical transformation mechanism
c                               flag (0 = no transformation,
c                               1 = MESOPUFF II scheme,
c                               2 = user-specified rates, except
c                                   HNO3 <--> NO3 based on equilibrium
c                                   equation)
c                               3 = RIVAD scheme with HNO3 <--> NO3
c                                   equilibrium)
c                               4 = Form SOA from VOC emissions
c           MAQCHEM - integer - Aqueous phase transformation flag
c                               (Used only if MCHEM = 1 or 3)
c                               0 = aqueous phase transformation
c                                   not modeled
c                               1 = transformation rates adjusted
c                                   for aqueous phase reactions
c              LDB - logical  - Flag controlling printing of header
c                               record data (F=suppress, T=print)
c
c     Common block /DATEHR/ variables
c           XBTZ
c     Common block /CHEMDAT/ variables
c           MOZ, MH2O2, CH2O2
c     Common block /GEN/ variables
c           NSPEC, CSPEC(mxspec), METFM
c     Common block /GRID/ variables
c           NX, NY, DGRID, XORIG, YORIG
c     Common block /MAP/ variables
c           iutmzn,feast,fnorth,
c           rnlat0,relon0,rlat0,rlon0,xlat1,xlat2,
c           pmap,utmhem,datum
c        Parameters:
c           IO6, MXSPEC, MXOZ, MXNX, MXNY, MXNZP1
c
c --- OUTPUT:
c     Common block /CHEMDAT/ variables
c           ITIMOZ,
c           CHEMT(24,3) --->  (if MCHEM=2)
c           NOZSTA,IUTMOZ,IBDATO,IBTIMO,IEDATO,IETIMO,VRSOZ,LABOZ, and
c           NEAROZ      --->  (if MCHEM=1,3,4 and MOZ=1)
c           NH2O2STA,IUTMH2O2,IBDATH,IBTIMH,IEDATH,IETIMH,VRSH2O2,
c           LABH2O2, and NEAROZ
c                       --->  (if MAQCHEM=1 and MH2O2=1)
c     Common block /SOA/ variables (if MCHEM=4)
c           LAROM, LBIOG
c
c --- CHEMI called by: SETUP
c --- CHEMI calls:     RDCHEM, RDHDOZ, RDTIOZ, OUT, SSLATLON,
c                      RDHDOZ2, RDTIOZ2, GLOBE1, GLOBE
c                      RDHDAQ, RDTIAQ
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      include 'datehr.puf'
      include 'chemdat.puf'
      include 'gen.puf'
      include 'grid.puf'
      include 'map.puf'
      include 'soa.puf'

c --- For coordinate transformations
      character*8 cmapi,cmapo
      character*12 caction
      character*4 c4hem
      real*8 vecti(9),vecto(9)
      character*4 utmhemoz
      character*8 datumoz,pmapoz


      logical ldb,ldate,problem
      character*70 messag
      character*16 c16
      character*12 cspec1(5),cspec3(6),cspec4(5)
      data cspec1/ 'SO2', 'SO4', 'NOX', 'HNO3',   'NO3'/
      data cspec3/ 'SO2', 'SO4', 'NO', 'NO2', 'HNO3', 'NO3'/
      data cspec4/ 'TOLUENE', 'XYLENE', 'B-PINENE', 'A-PINENE',
     &             'SOA'/
      data rmax/1.e37/

      problem=.FALSE.

c --- Set up for coordinate transformations
c --- Scale factor for Tangential TM projection
      tmsone=1.00000
c --- Output of coord transform is to CALPUFF (x,y) - /MAP/
      iutmo=iutmzn
      if(utmhem.EQ.'S   ' .AND. iutmo.LT.900) iutmo=-iutmo
      cmapo=pmap
      if(cmapo.EQ.'TTM     ') cmapo='TM      '

c --- Perform QA check on species library;  Species must be entered
c --- in the correct order
      if(mchem.LT.3) then
c ---    Check for MESOPUFF species
         if(nspec.LT.5) then
c ********* if(nspec.NE.2 .OR. nspec.NE.3) problem=.TRUE.
c ---       Allowed values of NSPEC are 2,3,5 with MCHEM=1 or 2
            if(nspec.eq.1.or.nspec.eq.4) problem=.true.
         endif
         is=MIN0(nspec,5)
         do i=1,is
            if(cspec(i).NE.cspec1(i)) then
               problem=.TRUE.
            endif
         enddo
      elseif(mchem.EQ.3) then
c ---    Check for RIVAD species
         if(nspec.LT.6) then
c ********* if(nspec.NE.2 .OR. nspec.NE.4) problem=.TRUE.
c ---       Allowed values of NSPEC are 2,4,6 with MCHEM=3
            if(nspec.eq.1.or.nspec.eq.3.or.nspec.eq.5) problem=.true.
         endif
         is=MIN0(nspec,6)
         do i=1,is
            if(cspec(i).NE.cspec3(i)) then
               problem=.TRUE.
            endif
         enddo
      elseif(mchem.EQ.4) then
c ---    Check for VOC and SOA species
         larom=.FALSE.
         lbiog=.FALSE.
         if(nspec.LT.3) then
            problem=.TRUE.
         elseif(cspec(1).EQ.cspec4(1)) then
            larom=.TRUE.
            if(cspec(3).EQ.cspec4(3)) lbiog=.TRUE.
         elseif(cspec(1).EQ.cspec4(3)) then
            lbiog=.TRUE.
         endif
         is=MIN0(nspec,5)
         if(LAROM .AND. LBIOG) then
c ---       First 5 species should match expected order
            if(is.NE.5) then
               problem=.TRUE.
            else
               do i=1,is
                  if(cspec(i).NE.cspec4(i)) problem=.TRUE.
               enddo
            endif
         elseif(LAROM) then
c ---       First 2 species should be aromatics; 3rd is SOA
            if(is.GE.3) then
               if(cspec(3).NE.cspec4(5)) problem=.TRUE.
               do i=1,2
                  if(cspec(i).NE.cspec4(i)) problem=.TRUE.
               enddo
            endif
         elseif(LBIOG) then
c ---       First 2 species should be biogenics; 3rd is SOA
            if(is.GE.3) then
               do i=1,3
                  if(cspec(i).NE.cspec4(i+2)) problem=.TRUE.
               enddo
            endif
         else
c ---       Initial species name is not consistent with SOA CHEM
            problem=.TRUE.
         endif
      else
         problem=.TRUE.
      endif
      if(problem) then
         if(mchem.EQ.3) then
            write(io6,*)'CHEMI: FATAL error with species'
            write(io6,*)'RIVAD chemistry selected, MCHEM= ',mchem
            write(io6,*)'Species number must be 2,4,6 or greater'
            write(io6,*)'And ordered as:'
            do i=1,6
               write(io6,*) cspec3(i)
            enddo
            write(io6,*)'Species found:'
            do i=1,is
               write(io6,*) cspec(i)
            enddo
         elseif(mchem.LT.3) then
            write(io6,*)'CHEMI: FATAL error with species'
            write(io6,*)'User or MESOPUFF chemistry, MCHEM= ',mchem
            write(io6,*)'Species number must be 2,3,5 or greater'
            write(io6,*)'And ordered as:'
            do i=1,5
               write(io6,*) cspec1(i)
            enddo
            write(io6,*)'Species found:'
            do i=1,is
               write(io6,*) cspec(i)
            enddo
         elseif(mchem.EQ.4) then
            write(io6,*)'CHEMI: FATAL error with species'
            write(io6,*)'SOA chemistry selected, MCHEM= ',mchem
            write(io6,*)'Species order must be either'
            do i=1,5
               write(io6,*) cspec4(i)
            enddo
            write(io6,*)'for AROMATIC and BIOGENIC VOCs, or'
            do i=1,2
               write(io6,*) cspec4(i)
            enddo
            write(io6,*) cspec4(5)
            write(io6,*)'for just AROMATIC VOCs, or'
            do i=1,3
               write(io6,*) cspec4(i+2)
            enddo
            write(io6,*)'for just BIOGENIC VOCs.'
            write(io6,*)
            write(io6,*)'Species found:'
            do i=1,is
               write(io6,*) cspec(i)
            enddo
         else
            write(io6,*)'CHEMI: FATAL error with chemistry selection'
            write(io6,*)'Undefined MCHEM= ',mchem
            write(*,*)
            stop 'Halted in CHEMI -- see list file.'
         endif
         write(*,*)
         stop 'Halted in CHEMI -- see list file.'
      endif
c
c -------------------------------------------------------------------
c --- Read user-specified chemical transformation rates from CHEM.DAT
c -------------------------------------------------------------------
      if(mchem.eq.2)call rdchem(nspec)
c
c ----------------------------------------------------------------------
c --- Read and process header & time-invariant ozone data from OZONE.DAT
c ----------------------------------------------------------------------
      if((mchem.EQ.1 .OR. mchem.EQ.3 .OR. mchem.EQ.4) .AND. moz.EQ.1)
     &   then

c ---    Determine the Dataset Version
         read(io22,*) c16
         REWIND(io22)
c
c ---    Read the header and time-invariant records
         if(c16.NE.'OZONE.DAT       ') then
c
c ---       EARLY OZONE.DAT Format (time and coordinates must match
c ---       those in control file)
c
            call rdhdoz(io22,ldb,nozsta,iutmoz,ibdato,ibtimo,iedato,
     1                  ietimo,vrsoz,laboz)
            call rdtioz(io22,nozsta,ldb,cidoz,xozm,yozm)
c
c ---       Process time information
            itimoz=1
c
c ---       Convert station coordinates from km to meters relative
c ---       to origin of met. grid
            do i=1,nozsta
               xozm(i)=1000.*xozm(i)-xorig
               yozm(i)=1000.*yozm(i)-yorig
            enddo
c
c ---       Perform QA check on UTM zone
            if(LUTM) then
              if(iutmoz.ne.iutmzn)then
                write(io6,*)'ERROR in subr. CHEMI -- Value of UTM zone',
     1         ' in OZONE.DAT file does not match control file value ',
     2         '-- IUTMOZ = ',iutmoz,' IUTMZN = ',iutmzn
                write(*,*)
                stop 'Halted in CHEMI -- see list file.'
              endif
            else
c ---         Demand that the zone be ZERO
              if(iutmoz.NE.0)then
                write(io6,*)'ERROR in subr. CHEMI -- Value of UTM zone',
     1         ' in OZONE.DAT file is ZERO if projection is not UTM  ',
     2         '-- PMAP = ',pmap,'   IUTMOZ = ',iutmoz
                write(*,*)
                stop 'Halted in CHEMI -- see list file.'
              endif
            endif
         else
c
c ---       Dataset 2.1 OZONE.DAT Format (time zone must match control
c ---       file, but coordinates are transformed)
c
            call RDHDOZ2(io22,ldb,nozsta,iutmoz,ibdato,ibtimo,iedato,
     &                  ietimo,xbtzoz,feastoz,fnorthoz,
     &                  rnlat0oz,relon0oz,rnlat1oz,rnlat2oz,
     &                  vrsoz,laboz,pmapoz,utmhemoz,datumoz)
            call RDTIOZ2(io22,nozsta,pmapoz,ldb,cidoz,xozm,yozm)
c
c ---       Process time information
            itimoz=2
            if(NINT(xbtz).NE.NINT(xbtzoz)) then
               write(io6,*)'ERROR in subr. CHEMI -- Value of time zone',
     1         ' in OZONE.DAT file is different from model base time ',
     2         'zone -- XBTZ = ',xbtz,'   XBTZOZ = ',xbtzoz
                write(*,*)
                stop 'Halted in CHEMI -- see list file.'
            endif
c
c ---       Set up map projection conversion to CALPUFF coordinates
            iutmi=iutmoz
            if(utmhemoz.EQ.'S   ' .AND. iutmi.LT.900) iutmi=-iutmi
            cmapi=pmapoz
            if(cmapi.EQ.'TTM     ') cmapi='TM      '
c ---       Set conversion vectors
            call GLOBE1(cmapi,iutmi,tmsone,rnlat1oz,rnlat2oz,
     &               rnlat0oz,relon0oz,feastoz,fnorthoz,
     &               cmapo,iutmo,tmsone,xlat1,xlat2,rnlat0,relon0,
     &               feast,fnorth,caction,vecti,vecto)
c
c ---       Convert station coordinates to model map projection and
c ---       datum and then from km to meters relative to origin of
c ---       met. grid
            do i=1,nozsta
               call GLOBE(io6,caction,datumoz,vecti,datum,vecto,
     &                    xozm(i),yozm(i),xdum,ydum,izone,c4hem)
               xozm(i)=1000.*xdum-xorig
               yozm(i)=1000.*ydum-yorig
            enddo
         endif
c
c ---    Compute the station number of the closest ozone station to
c ---    each grid point
         if(nozsta.eq.1)then
            do 30 i=1,nx
            do 30 j=1,ny
            nearoz(i,j)=1
30          continue
         else if(nozsta.ge.2)then
            do 40 i=1,nx
            xgdpt=(float(i)-0.5)*dgrid
            do 40 j=1,ny
            ygdpt=(float(j)-0.5)*dgrid
            dmin2=rmax
            ksv=0
c
c ---       Loop over ozone stations to find the closest one to
c ---       grid point (i,j)
            do 35 k=1,nozsta
            dist2=(xozm(k)-xgdpt)**2 + (yozm(k)-ygdpt)**2
            if(dist2.lt.dmin2)then
               dmin2=dist2
               ksv=k
            endif
35          continue
c
            if(ksv.gt.0)then
               nearoz(i,j)=ksv
            else
               write(io6,*)'ERROR in subr. CHEMI -- Invalid value ',
     1         'of KSV --  KSV = ',ksv,' I = ',i,' J = ',j
               write(*,*)
               stop 'Halted in CHEMI -- see list file.'
            endif
40          continue
c
         else
            write(io6,*)'ERROR in subr. CHEMI -- Invalid value ',
     1      'of NOZSTA with MOZ=2 option -- NOZSTA = ',nozsta
            write(*,*)
            stop 'Halted in CHEMI -- see list file.'
         endif
c
c ---    Write NEAROZ data
         if(ldb)then
            ldate=.false.
            messag='Nearest ozone station number to each grid point'
            call out(xdum,nearoz,2,5,ldate,messag,nx,ny)
         endif
      endif
c
c ----------------------------------------------------------------------
c --- Read and process header & time-invariant H2O2 data from H2O2.DAT
c ----------------------------------------------------------------------
      if(maqchem.EQ.1 .AND. mh2o2.EQ.1) then
c
c ---    Read the header record
         call RDHDAQ(ch2o2,io23,ldb,nh2o2sta,iutmh2o2,ibdath,ibtimh,
     1               iedath,ietimh,vrsh2o2,labh2o2)
c
c ---    Read the time-invariant records
         call RDTIAQ(ch2o2,io23,nh2o2sta,ldb,cidh2o2,xh2o2m,yh2o2m)
c
c ---    Perform QA check on UTM zone
         if(iutmh2o2.ne.iutmzn)then
            write(io6,*)'ERROR in subr. CHEMI -- Value of UTM zone ',
     1      'in H2O2.DAT file does not match control file value -- ',
     2      'IUTMH2O2 = ',iutmh2o2,' IUTMZN = ',iutmzn
            write(*,*)
            stop 'Halted in CHEMI -- see list file.'
         endif
c
c ---    Convert station coordinates from UTM (km) to meters relative
c ---    to origin of met. grid
         do i=1,nh2o2sta
            xh2o2m(i)=1000.*xh2o2m(i)-xorig
            yh2o2m(i)=1000.*yh2o2m(i)-yorig
         enddo
c
c ---    Compute the station number of the closest H2O2 station to
c ---    each grid point
         if(nh2o2sta.eq.1)then
            do i=1,nx
               do j=1,ny
                  nearh2o2(i,j)=1
               enddo
            enddo
         else if(nh2o2sta.ge.2)then
            do 140 i=1,nx
            xgdpt=(float(i)-0.5)*dgrid
            do 140 j=1,ny
            ygdpt=(float(j)-0.5)*dgrid
            dmin2=rmax
            ksv=0
c
c ---       Loop over H2O2 stations to find the closest one to
c ---       grid point (i,j)
            do k=1,nh2o2sta
               dist2=(xh2o2m(k)-xgdpt)**2 + (yh2o2m(k)-ygdpt)**2
               if(dist2.lt.dmin2)then
                  dmin2=dist2
                  ksv=k
               endif
            enddo
c
            if(ksv.gt.0)then
               nearh2o2(i,j)=ksv
            else
               write(io6,*)'ERROR in subr. CHEMI -- Invalid value ',
     1         'of KSV --  KSV = ',ksv,' I = ',i,' J = ',j
               write(*,*)
               stop 'Halted in CHEMI -- see list file.'
            endif
140         continue
c
         else
            write(io6,*)'ERROR in subr. CHEMI -- Invalid value ',
     1      'of NH2O2STA with MH2O2=2 option -- NH2O2STA = ',nh2o2sta
            write(*,*)
            stop 'Halted in CHEMI -- see list file.'
         endif
c
c ---    Write NEARH2O2 data
         if(ldb)then
            ldate=.false.
            messag='Nearest H2O2 station number to each grid point'
            call out(xdum,nearh2o2,2,5,ldate,messag,nx,ny)
         endif
      endif
c
c ----------------------------------------------------------------------
c --- Compute Lat/Lon for CALMET surface met stations for MCHEM=3
c ----------------------------------------------------------------------
      if(mchem.EQ.3 .AND. metfm.EQ.1) call SSLATLON(ldb)
c
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdchem(nspec)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                 RDCHEM
c                J. Scire, SRC
c
c --- PURPOSE:  Read a file containing a diurnal cycle of 24 hourly
c               chemical transformation rates (in percent/hour)
c
c --- UPDATE
c --- V5.4-V5.7
c          000602 - 030402  (DGS): MXVAR relocated to PARAMS.CAL
c --- V5.3-V5.4
c          950122 - 000602  (DGS): add message to "stop"
c
c --- INPUTS:
c        NSPEC - integer - Number of species being modeled
c     Parameters: IO6, IO24
c
c --- OUTPUT:
c     Common block /CHEMDAT/ variables
c           CHEMT(24,3)
c
c --- RDCHEM called by: CHEMI
c --- RDCHEM calls:     READIN
c----------------------------------------------------------------------
c
c --- Include parameter statements
      include 'params.puf'
      include 'params.cal'
c
      integer ivleng(mxvar),ivtype(mxvar)
      character*12 cvdic(mxvar)
      logical lecho
c
      include 'chemdat.puf'
c
      data cvdic/'k1','k2','k3','K1','K2','K3',54*' '/
      data ivleng/6*24,54*0/
      data ivtype/6*1, 54*0/
      data lecho/.true./
c
c --- Initialize user-specified vd array with missing value
c --- indicators
      do 10 j=1,3
      do 10 i=1,24
      chemt(i,j)=-9999.
10    continue
c
c --- read the formatted file
      write(io6,32)
32    format(///1x,13('----------')//5x,'USER-SPECIFIED CHEMICAL ',
     1 'TRANSFORMATION RATE FILE (CHEM.DAT)'//)
c
      call readin(cvdic,ivleng,ivtype,io24,io6,lecho,
     1 chemt(1,1),chemt(1,2),chemt(1,3),chemt(1,1),chemt(1,2),
     2 chemt(1,3),
     3 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
     4 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
     5 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
     6 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
     7 idum,idum,idum,idum,idum,idum)
c
c --- check that values for every required species have been read
      ierr=0
      if(nspec.ge.1)then
         do 45 i=1,24
         if(chemt(i,1).le.-9999.)ierr=1
45       continue
      endif
c
      if(nspec.ge.3)then
         do 47 i=1,24
         if(chemt(i,2).le.-9999.)ierr=1
47       continue
      endif
c
      if(nspec.ge.4)then
         do 49 i=1,24
         if(chemt(i,3).le.-9999.)ierr=1
49       continue
      endif
c
c --- Error if any hour for this deposited species is missing
      if(ierr.eq.1)then
         write(io6,57)
57       format(/1x,'ERROR in subr. RDCHEM -- required values not ',
     1   'found in CHEM.DAT file')
         if(nspec.ge.1)write(io6,59)'k1',(chemt(n,1),n=1,24)
         if(nspec.ge.3)write(io6,59)'k2',(chemt(n,2),n=1,24)
         if(nspec.ge.4)write(io6,59)'k2',(chemt(n,3),n=1,24)
59       format(/1x,a2,' = ',12(f10.4,1x)/6x,12(f10.4,1x))
         write(*,*)
         stop 'Halted in RDCHEM -- see list file.'
      endif
c
999   continue
      return
      end
c----------------------------------------------------------------------
      subroutine rdhdoz(iunit,lprt,nozsta,iutmoz,ibdato,ibtimo,
     1 iedato,ietimo,vrsoz,laboz)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                 RDHDOZ
c                J. Scire, SRC
c
c --- PURPOSE:  Read the header records from the OZONE.DAT data file
c
c --- UPDATE
c --- V5.5-V5.7     030402  (DGS): Add list file unit to YR4 call
c --- V5.2-V5.4     000602  (DGS): Add message to "stop"
c --- V5.0-V5.2     991104  (DGS): YYYY format for year
c
c --- INPUTS:
c            IUNIT - integer    - Fortran unit number of OZONE file
c             LPRT - logical    - Flag controlling printing of header
c                                 record data (F=suppress, T=print)
c        Parameters:
c            IO6, MXOZ
c
c --- OUTPUT:
c           NOZSTA - integer - Number of ozone stations in the OZONE.DAT
c                              file
c           IUTMOZ - integer - UTM zone in which the ozone station
c                              coordinates are specified
c           IBDATO - integer - Date of beginning of data (YYYYJJJ, where
c                              YYYY=year, JJJ=Julian day)
c           IBTIMO - integer - Hour of beginning of data (00-23, LST)
c           IEDATO - integer - Date of ending of data (YYYYJJJ, where
c                              YYYY=year, JJJ=Julian day)
c           IETIMO - integer - Hour of ending of data (00-23, LST)
c            VRSOZ - C*12    - Data set version
c            LABOZ - C*12    - Data set label
c
c --- RDHDOZ called by: CHEMI
c --- RDHDOZ calls:     YR4
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      character*12 fnameo,vrsoz,laboz
      logical lprt
c
c --- Header Record #1 - General data - beginning, ending dates &
c                        times, UTM zone, number of stations
c
      read(iunit,*)fnameo,nozsta,iutmoz,ibdato,ibtimo,iedato,ietimo,
     1 vrsoz,laboz

c --- Enforce YYYY format
      iby=ibdato/1000
      ibd=ibdato-1000*iby
      iey=iedato/1000
      ied=iedato-1000*iey
      call YR4(io6,iby,ierrb)
      call YR4(io6,iey,ierre)
      if(ierrb.NE.0 .OR. ierre.NE.0) then
         write(*,*)
         stop 'Halted in RDHDOZ -- see list file.'
      endif
      ibdato=iby*1000+ibd
      iedato=iey*1000+ied
c
      if(fnameo.ne.'OZONE'.and.fnameo.ne.'ozone')then
         write(io6,10)fnameo,iunit
10       format(/1x,'ERROR in SUBR. RDHDOZ -- file name does not ',
     1   'match expected value'/
     2   1x,'Expected file name: OZONE or ozone'/
     3   1x,'    File name read: ',a12/
     4   1x,'       Unit number: ',i4)
         write(*,*)
         stop 'Halted in RDHDOZ -- see list file.'
      endif
c
      if(nozsta.gt.mxoz)then
         write(io6,12)nozsta,mxoz
12       format(/1x,'ERROR in SUBR. RDHDOZ -- No. ozone stations ',
     1   ' in OZONE file is greater than current array dimension'/1x,
     2   '    No. ozone stations in file: ',i5/1x,
     3   'Current Array dimension (MXOZ): ',i5)
         write(*,*)
         stop 'Halted in RDHDOZ -- see list file.'
      endif
c
c --- WRITE CONTENTS OF HEADER RECORDS (if requested)
      if(lprt)then
         write(io6,102)
102      format(///1x,13('----------')//1x,'Header record data from ',
     1    'the OZONE data file')
         write(io6,103)fnameo,nozsta,iutmoz,ibdato,ibtimo,iedato,ietimo,
     1    vrsoz,laboz
103      format(/1x,'FNAMEO: ',a12/1x,'NOZSTA: ',i6/1x,'IUTMOZ: ',i6/
     1    1x,'IBDATO: ',i8/1x,'IBTIMO: ',i8/
     2    1x,'IEDATO: ',i8/1x,'IETIMO: ',i8/
     3    1x,'VRSOZ:  ',a12/1x,'LABOZ:  ',a12)
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdhdoz2(iunit,lprt,nozsta,iutmoz,ibdato,ibtimo,
     &                   iedato,ietimo,xtz,feast,fnorth,
     &                   rnlat0,relon0,rnlat1,rnlat2,
     &                   vrsoz,laboz,pmap,utmhem,datum)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 060725                RDHDOZ2
c                J. Scire, SRC
c
c --- PURPOSE:  Read the header records from the OZONE.DAT data file
c
c --- UPDATE (from RDHDOZ)
c --- V5.753-V5.756 060725  (DGS): Provide default lat/lon data to
c                                  XTRACTLL calls since these variables
c                                  may not be read (non-LCC maps)
c                                  Expand input processing to include
c                                  headers for PS,EM,LAZA,TTM maps
c --- V5.7-V5.753   051130  (DGS): Translate OZONE.DAT Dataset 2.1
c                                  format header
c
c --- INPUTS:
c            IUNIT - integer    - Fortran unit number of OZONE file
c             LPRT - logical    - Flag controlling printing of header
c                                 record data (F=suppress, T=print)
c        Parameters:
c            IO6, MXOZ
c
c --- OUTPUT:
c           NOZSTA - integer - Number of ozone stations in the OZONE.DAT
c                              file
c           IUTMOZ - integer - UTM zone in which the ozone station
c                              coordinates are specified
c           IBDATO - integer - Date of beginning of data (YYYYJJJ, where
c                              YYYY=year, JJJ=Julian day)
c           IBTIMO - integer - Hour of beginning of data (00-23, LST)
c           IEDATO - integer - Date of ending of data (YYYYJJJ, where
c                              YYYY=year, JJJ=Julian day)
c           IETIMO - integer - Hour of ending of data (00-23, LST)
c              XTZ - integer - Time zone of data
c           FEAST  - real    - False Easting (km) at projection origin
c           FNORTH - real    - False Northing (km) at projection origin
c          RNLAT0, - real    - N. latitude & E. longitude of x=0 and y=0
c           RELON0 (deg)       of map projection (Used only if PMAP =
c                              LCC, PS, EM, TTM or LAZA)
c                              NOTE: longitude neg in western hemisphere
c          RNLAT1, - real    - Matching N. latitude(s) for projection
c          RNLAT2 (deg)        (Used only if PMAP3= LCC, PS, or EM)
c                              LCC :  Projection cone slices through
c                                     Earth's surface at XLAT1 and XLAT2
c                              PS  :  Projection plane slices through
c                                     Earth at XLAT1
c                              EM  :  Projection cylinder slices through
c                                     Earth at [+/-] XLAT1
c            VRSOZ - C*12    - Data set version
c            LABOZ - C*12    - Data set label
c             PMAP - char    - Character code for input map projection
c                              LL  :  Latitude/longitude
c                              UTM :  Universal Transverse Mercator
c                              LCC :  Lambert Conformal Conic
c                              PS  :  Polar Stereographic
c                              EM  :  Equatorial Mercator
c                              LAZA:  Lambert Azimuthal Equal Area
c                              TTM :  Tangential Transverse Mercator
c           UTMHEM - char    - Base hemisphere for UTM projection
c                               (S=southern, N=northern)
c            DATUM - char    - Datum-Region for grid coordinates
c
c --- RDHDOZ2 called by: CHEMI
c --- RDHDOZ2 calls:     ALLCAP, YR4, INCR, XTRACTLL
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      character*12 fnameo,vrsoz,laboz
      logical lprt

      logical lgeo,lutm,llcc,lps,lem,llaza,lttm
      character*8 axtz
      character*16 dataset,dataver
      character*16 clat0,clon0,clat1,clat2
      character*33 blank33,break33
      character*64 datamod
      character*132 comment1,blank,break

      character*4 utmhem,xyunit
      character*8 datum,pmap
      character*12 daten

      data nlim/1/
      data zero/0.0/

c --- Set initial strings for potential lat/lon inputs
      data clat0/'0.0N'/,clon0/'0.0E'/,clat1/'0.0N'/,clat2/'0.0N'/

c --- Initialize local map projection logicals
      lgeo=.FALSE.
      lutm=.FALSE.
      llcc=.FALSE.
      lps=.FALSE.
      lem=.FALSE.
      llaza=.FALSE.
      lttm=.FALSE.


c ---    First record and comments
         read(iunit,'(2a16,a64)') dataset,dataver,datamod
         read(iunit,*) ncom
         do k=1,ncom
            read(iunit,'(a132)') comment1
         enddo
c ---    Map projection
         read(iunit,'(a8)') pmap
         do k=1,8
            call ALLCAP(pmap(k:k),nlim)
         enddo
         if(pmap.EQ.'LL      ')  lgeo =.TRUE.
         if(pmap.EQ.'UTM     ')  lutm =.TRUE.
         if(pmap.EQ.'LCC     ')  llcc =.TRUE.
         if(pmap.EQ.'PS      ')  lps  =.TRUE.
         if(pmap.EQ.'EM      ')  lem  =.TRUE.
         if(pmap.EQ.'LAZA    ')  llaza=.TRUE.
         if(pmap.EQ.'TTM     ')  lttm =.TRUE.
c ---    Map projection parameters
         if(LUTM) then
            read(iunit,'(i4,a4)') iutmoz,utmhem
         elseif(LLCC) then
            read(iunit,'(4a16)') clat0,clon0,clat1,clat2
         elseif(LPS) then
            read(iunit,'(3a16)') clat0,clon0,clat1
         elseif(LEM.or.LLAZA.or.LTTM) then
            read(iunit,'(2a16)') clat0,clon0
         endif
c ---    Map false Easting/Northing
         if(LLCC.or.LLAZA.or.LTTM) then
            read(iunit,*) feast,fnorth
         else
            feast=0.0
            fnorth=0.0
         endif
c ---    Map DATUM
         read(iunit,'(a8,a12)') datum,daten
         do k=1,8
            call ALLCAP(datum(k:k),nlim)
         enddo
c ---    Units
         read(iunit,'(a4)') xyunit
         do k=1,8
            call ALLCAP(datum(k:k),nlim)
         enddo
c ---    Time zone
         read(iunit,'(a8)') axtz
         if(axtz(7:8).NE.'00') then
            write(io6,*)'FATAL Error in RDHDOZ2 -- Time Zone'
            write(io6,*)'Expected whole hour, Found: ',axtz
            stop 'Halted in RDHDOZ2 -- see list file'
         endif
         read(axtz(4:6),'(i3)') ibtzhh
         if(ibtzhh.LT.-13 .OR. ibtzhh.GT.13) then
            write(io6,*)'FATAL Error in RDHDOZ2 -- Time Zone'
            write(io6,*)'Expected UTC-1300 to UTC+1300'
            write(io6,*)'Found: ',axtz
            stop 'Halted in RDHDOZ2 -- see list file'
         endif
         xtz=-FLOAT(ibtzhh)

c ---    Time period
         read(iunit,*)ibyr,ibdy,ibhr,ibsec,
     &                ieyr,iedy,iehr,iesec
c ---    Enforce YYYY format for year
         call YR4(io6,ibyr,ierrb)
         call YR4(io6,ieyr,ierre)
         if(ierrb.NE.0 .OR. ierre.NE.0) stop 'Halted in RDHDOZ2'

c ---    Number of stations
         read(iunit,*) nozsta



c --- Convert time at start of data to hour-end convention
      nhr=-1
      call INCR(io6,ibyr,ibdy,ibhr,nhr)
      ibdato=ibyr*1000+ibdy
      iedato=ieyr*1000+iedy
      ibtimo=ibhr
      ietimo=iehr
      ibdathr=ibtimo*100+ibhr
      iedathr=ietimo*100+iehr
c --- Seconds must be ZERO
      if(ibsec.NE.0 .OR. iesec.NE.0) then
         write(io6,*)'FATAL Error in RDHDOZ2 -- Times'
         write(io6,*)'Expected seconds=0, Found: ',ibsec,iesec
         stop 'Halted in RDHDOZ2 -- see list file'
      endif

c --- Place dataset version into VRSOZ
      vrsoz=dataver(1:12)

c --- Process lat/lon character variables to extract content
      call XTRACTLL(io6,'LAT ',clat1,rnlat1)
      call XTRACTLL(io6,'LAT ',clat2,rnlat2)
      call XTRACTLL(io6,'LAT ',clat0,rnlat0)
      call XTRACTLL(io6,'LON ',clon0,relon0)
c
      if(nozsta.gt.mxoz)then
         write(io6,12)nozsta,mxoz
12       format(/1x,'ERROR in SUBR. RDHDOZ2 -- No. ozone stations ',
     1   ' in OZONE file is greater than current array dimension'/1x,
     2   '    No. ozone stations in file: ',i5/1x,
     3   'Current Array dimension (MXOZ): ',i5)
         write(*,*)
         stop 'Halted in RDHDOZ2 -- see list file.'
      endif

c --- WRITE CONTENTS OF HEADER RECORDS (if requested)
      if(lprt)then
         write(io6,101) 'OZONE.DAT'
101      format(///1x,13('----------')//1x,'Header record data from ',
     1   a12,' file')
         write(io6,102)dataset,axtz,nozsta,
     &         ibdathr,ibsec,iedathr,iesec,pmap,
     &         datum
102      format(/1x,'DATASET: ',a16/1x,
     1   'AXTZ:   ',a8,'NSTA:   ',i8,/
     2   1x,'IBDATHR:',i9/1x,'IBSEC:  ',i4/
     3   1x,'IEDATHR:',i9/1x,'IESEC:  ',i4/
     4   1x,'MAP:    ',a8/1x,'DATUM:   ',a8)

         if(LUTM) write(io6,104) iutmoz,utmhem
         if(LLCC) write(io6,105) clat0,clon0,clat1,clat2,
     &                                 feast,fnorth
         if(LPS) write(io6,106) clat0,clon0,clat1
         if(LEM) write(io6,107) clat0,clon0
         if(LLAZA.or.LTTM) write(io6,108) clat0,clon0,
     &                                 feast,fnorth

104      format(/1x,'UTMZN:   ',i4/1x,'UTMHEM:  ',a4)
105      format(/1x,'Lat0:    ',a16/1x,'Lon0:    ',a16/
     &           1x,'Lat1:    ',a16/1x,'Lat2:    ',a16/
     &           1x,'False_E: ',f15.3/1x,'False_N: ',f15.3)
106      format(/1x,'Lat0:    ',a16/1x,'Lon0:    ',a16/
     &           1x,'Lat1:    ',a16)
107      format(/1x,'Lat0:    ',a16/1x,'Lon0:    ',a16)
108      format(/1x,'Lat0:    ',a16/1x,'Lon0:    ',a16/
     &           1x,'False_E: ',f15.3/1x,'False_N: ',f15.3)

      endif
c
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdtioz(iunit,nozsta,ldb,cid,xoz,yoz)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 941215                 RDTIOZ
c                J. Scire, SRC
c
c --- PURPOSE:  Read the time-invariant records of the OZONE data
c               file
c
c --- INPUTS:
c            IUNIT - integer    - Fortran unit number of OZONE file
c           NOZSTA - integer    - Number of stations in the OZONE file
c              LDB - logical    - Flag controlling printing of debug
c                                 data
c        Parameters:
c            IO6
c
c --- OUTPUT:
c      CID(nozsta) - C*16 array - Station identifiers (16 characters)
c      XOZ(nozsta) - real array - Easting UTM coordinate (km) of the
c                                 ozone station
c      YOZ(nozsta) - real array - Northing UTM coordinate (km) of the
c                                 ozone station
c
c --- RDTIOZ called by: CHEMI
c --- RDTIOZ calls:     none
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      real xoz(nozsta),yoz(nozsta)
      character*16 cid(nozsta)
      logical ldb
c
c --- Loop over ozone stations
      do 100 i=1,nozsta
      read(iunit,*)cid(i),xoz(i),yoz(i)
100   continue
c
      if(ldb)then
         write(io6,*)
         write(io6,*)'Time-invariant OZONE data'
         do 150 i=1,nozsta
         write(io6,*)'I = ',i,' CID(i) = ',cid(i),
     1    ' XOZ(i) = ',xoz(i),' YOZ(i) = ',yoz(i)
150      continue
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdtioz2(iunit,nsta,pmap,ldb,cid,xeast,ynorth)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 051130                RDTIOZ2
c                J. Scire, SRC
c
c --- PURPOSE:  Read the time-invariant records of the OZONE data
c               file
c
c --- UPDATE (from RDTIOZ)
c --- V5.0-V5.753   051130  (DGS): Translate OZONE.DAT Dataset 2.1
c                                  format header
c
c --- INPUTS:
c            IUNIT - integer    - Fortran unit number of OZONE file
c             NSTA - integer    - Number of stations in the OZONE file
c             PMAP - char*8     - Map projection
c              LDB - logical    - Flag controlling printing of debug
c                                 data
c        Parameters:
c            IO6
c
c --- OUTPUT:
c      CID(nozsta) - C*16 array - Station identifiers (16 characters)
c      xeast(nsta) - real array - Coordinate 1 of the station
c                                 Easting (km) or ELongitude (deg)
c     ynorth(nsta) - real array - Coordinate 2 of the station
c                                 Northing (km) or NLatitude (deg)
c
c --- RDTIOZ2 called by: CHEMI
c --- RDTIOZ2 calls:     XTRACTLL
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      real xeast(nsta),ynorth(nsta)
      character*16 cid(nsta)

      character*16 alat,alon
      character*8 pmap

      logical ldb

c --- Coordinates may be latitude/longitude strings
      if(pmap.EQ.'LL      ') then
c ---    Loop over data stations
         do i=1,nsta
            read(iunit,*)cid(i),alat,alon
c ---       Conver to real NLAT and ELON and place in arrays
            call XTRACTLL(io6,'LON ',alon,xeast(i))
            call XTRACTLL(io6,'LAT ',alat,ynorth(i))
         enddo
      else
c ---    Loop over data stations
         do i=1,nsta
            read(iunit,*)cid(i),xeast(i),ynorth(i)
         enddo
      endif
c
      if(ldb)then
         write(io6,*) 'Time-invariant data from OZONE.DAT file'
         do i=1,nsta
            write(io6,*)'I = ',i,' CID(i) = ',cid(i),
     &                  ' XEast(i) = ',xeast(i),
     &                  ' YNorth(i) = ',ynorth(i)
         enddo
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdoz(idathr,iunit,nozsta,ldb,itime,ozconc,leof)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 051130                   RDOZ
c                J. Scire, SRC
c
c --- PURPOSE:  Read the time-varying records of the OZONE data
c               file
c
c --- UPDATE
c --- V5.7-V5.753   051130  (DGS): Read Dataset 2.1 records (must be
c                                  hourly) -- pass time format flag
c                                  (ITIME)
c --- V5.5-V5.7     030402  (DGS): Add list file unit to YR4 call
c --- V5.2-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.2     991104  (DGS): YYYY format for year
c --- V4.0-V5.0     971107  (DGS): add EOF recovery
c                   971107  (DGS): add record-skip logic from COMP to
c                                  find current date-time
c
c --- INPUTS:
c           IDATHR - integer    - Date & hour of required data (YYYYJJJHH)
c            IUNIT - integer    - Fortran unit number of OZONE file
c           NOZSTA - integer    - Number of stations in the OZONE file
c              LDB - logical    - Flag controlling printing of data
c            ITIME - integer    - Time format flag
c                                 1: End time as year, Julian day, hour
c                                 2: Begin & End times as year, Julian
c                                    day, hour and second (0-3599)
c        Parameters:
c            IO6
c
c --- OUTPUT:
c   OZCONC(nozsta) - real       - Ozone concentration (ppb) at each
c                                 ozone station (NOTE: 9999. used as
c                                 a missing value indicator)
c          LEOF - logical       - End-Of-File flag
c
c --- RDOZ called by: COMP
c --- RDOZ calls:     YR4
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      real ozconc(nozsta)
      logical ldb,leof
c
c --- Read the ozone data record
1     if(itime.EQ.1) then
         read(iunit,*,end=999)iyr,ijul,ihr,ozconc
      elseif(itime.EQ.2) then
         read(iunit,*,end=999)ibyr,ibjul,ibhr,ibsec,
     &                        iyr,ijul,ihr,iesec,ozconc
         if(ibsec.NE.0 .OR. iesec.NE.0) then
            write(io6,*)'ERROR in subr. RDOZ -- Time is not hourly!'
            write(io6,*)'IBSEC, IESEC = ',ibsec,iesec
            write(*,*)
            stop 'Halted in RDOZ -- see list file.'
         endif
      else
         write(io6,*)'ERROR in subr. RDOZ -- Time format unknown! '
         write(io6,*)'Expected 1 or 2; Found ITIME = ',itime
         write(*,*)
         stop 'Halted in RDOZ -- see list file.'
      endif

c --- Enforce YYYY format
      call YR4(io6,iyr,ierr)
      if(ierr.NE.0) then
         write(*,*)
         stop 'Halted in RDOZ'
      endif

c --- Check to see if required date-time has been read
      kdathr=iyr*100000+ijul*100+ihr
      if(kdathr.lt.idathr)then
c ---    Obtain next time period in OZONE file
         go to 1
      elseif(kdathr.gt.idathr)then
         write(io6,*)'ERROR in subr. RDOZ -- current hour not ',
     1   'found in the OZONE data file -- Current date/hour = ',
     2   idathr,' Last date/hour read = ',kdathr
         write(*,*)
         stop 'Halted in RDOZ -- see list file.'
      endif
c
      if(ldb)then
         write(io6,*)
         write(io6,*)'Time-varying OZONE data for (YYYYJJJHH): ',kdathr
         write(io6,*)'OZCONC = ',ozconc
      endif
c
      return

999   write(io6,*)'RDOZ: End-Of-File found in OZONE file'
      leof=.TRUE.
      return

      end
c----------------------------------------------------------------------
      subroutine getoz(ixs,iys,dgrid,ldb,chioz)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602                  GETOZ
c                J. Scire, SRC
c
c --- PURPOSE:  Determine the appropriate value of ozone concentration
c               to use in the MESOPUFF II chemical routine
c                -- Use monthly background value if MOZ = 0
c                -- Read hourly values if MOZ = 1
c
c --- UPDATE
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c
c --- INPUTS:
c              IXS - integer - X index of the closest met. grid point
c                              to the puff/slug center
c              IYS - integer - Y index of the closest met. grid point
c                              to the puff/slug center
c            DGRID - real    - Grid spacing (m)
c              LDB - logical - Control variable determining if debug
c                              information is printed
c
c     Common block /CHEMDAT/ variables:
c           MOZ, BCKO3, NOZSTA, OZCONC(mxoz), XOZM(mxoz),
c           YOZM(mxoz), NEAROZ(mxnx,mxny)
c     Parameters:
c           MXNX, MXNY, MXOZ, IO6, IO22
c
c --- OUTPUT:
c            CHIOZ - real    - Ozone concentration (ppb)
c
c --- GETOZ called by:  CHEM
c --- GETOZ calls:      FINDR
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      logical ldb
c
      include 'chemdat.puf'
c
c --- Missing value indicator
      data xmiss/9999./
c
      if(moz.eq.0)then
         chioz=bcko3
      else if(moz.eq.1)then
c
c ---    ISTA is the ozone station closest to grid point (IXS,IYS)
         istaoz=nearoz(ixs,iys)
c
c ---    Determine ozone concentration (ppb) at the closest station
         chioz=ozconc(istaoz)
         if(chioz.ge.xmiss)then
c
c ---       Compute grid point coordinates (m) relative to met.
c ---       grid origin
            xgrd=(float(ixs)-0.5)*dgrid
            ygrd=(float(iys)-0.5)*dgrid
c
c ---       Find closest ozone station with non-missing data
            call findr(xozm,yozm,nozsta,ozconc,xgrd,ygrd,
     1      istaoz,chioz,ierr)
c
c ---       If all station data is missing, use default background conc.
            if(ierr.eq.1)chioz=bcko3
         endif
      else
         write(io6,*)'ERROR in subr. GETOZ -- Invalid value of MOZ',
     1   ' -- MOZ = ',moz
         write(*,*)
         stop 'Halted in GETOZ -- see list file.'
      endif
c
c*****
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. GETOZ -- ixs = ',ixs,' iys = ',iys,
     1   ' dgrid = ',dgrid,' istaoz = ',istaoz
         write(io6,*)'ozconc = ',(ozconc(n),n=1,nozsta)
         write(io6,*)'chioz  = ',chioz
      endif
c*****
      return
      end
c----------------------------------------------------------------------
      subroutine chembk(ndathr)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                 CHEMBK
c                D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Select the background Ozone, Ammonia, and H2O2
c               concentration for the current month
c --- UPDATE
c --- V5.5-V5.7     030402  (DGS): Add list file unit to GRDAY
c
c --- INPUTS:
c            NDATHR - integer    - YYYYJJJHH date-time for hour
c
c     Common Block /CHEMDAT/ variables:
c        BCKO3M(12),BCKNH3M(12),BCKH2O2M(12)
c
c --- OUTPUT:
c
c     Common block /CHEMDAT/ variables:
c        BCKO3, BCKNH3, BCKH2O2
c
c --- CHEMBK called by:  COMP
c --- CHEMBK calls:      GRDAY
c----------------------------------------------------------------------
      include 'params.puf'
      include 'chemdat.puf'

c --- Extract month from date-time
      iyr=ndathr/100000
      ijul=ndathr/100 - 1000*iyr
      call GRDAY(io6,iyr,ijul,imo,iday)

c --- Set background data for this month
      bcko3=bcko3m(imo)
      bcknh3=bcknh3m(imo)
      bckh2o2=bckh2o2m(imo)

      return
      end
c----------------------------------------------------------------------
      subroutine comp
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 151214                   COMP
c                J. Scire, D. Strimaitis   Earth TEch
c
c --- PURPOSE:  Computational phase of modeling -- Contains
c               main time loop
c
c --- UPDATE
c --- V5.8.4-V5.8.5 151214  (CDA) : Bug-fix:  add check for Gaussian
c                                  vertical distribution before calling
c                                  RISEWIND to refine advection wind
c                                  (may cause halt in ADVECT)
c                           (CDA) : Fix bug in bounary-source puff sampling
c                                  that added the contribution on boundary-
c                                  sources only when the last puff sampled
c                                  in a time-step was from a boundary source 
c --- V5.832-V5.8.4 130731  (EPA): Allow elevated receptors to sample
c                                  mass aloft (only discrete recs can
c                                  be elevated)
c --- V5.831-V5.8.4 130731  (EPA): Add call to SRCTABOUT to update the
c                                  source number of the current puff in
c                                  the DA file when line-source slugs
c                                  are processed
c                           (EPA): Initialize local QRATEW, XLAM arrays
c                                  to zero
c --- V5.82-V5.8.4  139731  (EPA): Add call to SRCTABIN to read current
c                                  tabulated rise properties in the puff
c                                  loop, and assign IMET=1 so that the
c                                  /SRCTAB/ tables are always used
c --- V5.81-V5.8.4  130731  (EPA): Check for imet outside valid range
c                                  of 1 to MXMETSAV+1
c --- V5.760-V5.8.4 130731  (EPA): Add cap to sigma-z to protect against
c                                  floating-point error in virtuals
c                                  Default cap is set to 5000km
c --- V5.753-V5.760 070605  (DGS): Add LCALM to SETPUF/SETSLG calls
c                   070605  (DGS): Process the total chiflx receptor
c                                  arrays even when the individual
c                                  source output option is not used
c                                  because they may contain PRIME cavity
c                                  impacts
c --- V5.752-V5.753 051130  (DGS): Add ITIMOZ to RDOZ call
c --- V5.751-V5.752 051108  (DGS): Heat flux at start of step is used
c                                  to screen TIBLGRO call
c                           (DGS): Add overwater SVMIN,SWMIN
c --- V5.75-V5.751  050805  (DGS): TIBLGRO arguments updated
c --- V5.741-V5.75  050225  (DGS): Place platform (downwash) ht into
c                                  /CURRENT/
c                   050225  (DGS): Add UATZI for TURBSET's AERSWV call
c                   050225  (DGS): Add DPBL arg to PUFRECS, PLGRECS,
c                                  SETPUF, SETSLG, CALCPF, CALCSL, and
c                                  PLMFOG to pass on to SETCSIG and
c                                  TAULY
c --- V5.74-V5.741  040913  (DGS): Add puff-age cutoff
c --- V5.72-V5.74   040715  (DGS): Add AERMET version of SURFACE and
c                                  PROFILE met data files
c                                  (METFM=5 or MPRFFM=2)
c --- V5.71-V5.72   031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c                   031017  (DGS): Source contribution option added;
c                                  update array space for volemarb
c --- V5.7-V5.71    030528  (DGS): Get search radius for BC puffs from
c                                  user input stored in /BCS/
c --- V5.5-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c                   030402  (DGS): Add list file unit to JULDAY, GRDAY,
c                                  INCR
c                   030402  (DGS): add PRIME downwash changes
c                   030402  (DGS): compute IMET for /CURRENT/
c
c --- V5.4-V5.4     000602_4(DGS): Assign ZFRISE the rise rather than
c                                  the effective plume ht at final rise
c                                  before call to RISEWIND
c --- V5.4-V5.4     000602_4(DGS): BCKO3M, BCKH2O2M monthly arrays
c --- V5.4-V5.4     000602_3(DGS): add H2O2 processing for aqueous chem
c --- V5.4-V5.4     000602_2(DGS): add FOGWIND call for PLUME mode
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c                   000602  (DGS): update SPLIT arguments (horizontal)
c                   000602  (DGS): add IMESG=2 option
c                   000602  (DGS): FOG processing added
c --- V5.3-V5.3     991222a (DGS): move supplementary PROFILE.DAT read
c                                  ahead of reads from primary met file
c                                  and update profile hts here if turbs
c                                  are obtained from PLMMET.DAT
c --- V5.0-V5.3     991222  (DGS): add Boundary Condition puffs and
c                                  remove redundant IPUFID decoding
c --- V5.0-V5.0     981228e (DGS): use IFREE flag for fresh puffs as
c                                  well as attached slugs
c                   981228e (DGS): move initial coastline screen into
c                                  TIBLON
c --- V5.0-V5.0     981228d (DGS): add mass flux balance option
c                   981228d (DGS): debug puff range changed from
c                                  (1,NPFDEB) to (IPFDEB1,IPFDEB2)
c --- V5.0-V5.0     981228c (DGS): add mass flux output option
c --- V5.0-V5.0     981228  (DGS): shift last hour processed back 1
c                                  when EOF is found
c                   980918  (DGS): use substeps for all sampling steps
c                                  except those with attached slug
c                   980918  (DGS): add SOA module branch (MCHEM=4)
c                   980821  (DGS): allow transitional plume rise hts to
c                                  define advection wind for steps
c                   980821  (DGS): allow sampling sub-steps for wind
c                                  speed increase over timestep
c                   980807  (DGS): read restart data only if NPUFFS>0
c                   980807  (DGS): update ICODE when slug is converted
c                                  to a puff
c                   980807  (DGS): add METFM to INITPUF call
c                   980731  (DGS): refine criteria for JSUP
c                   980722  (DGS): SVMIN & SWMIN by stability class
c                   980515  (DGS): compute steps and mixing ht for TIBL
c                                  module
c                   980430  (DGS): use stability JSUP at heights above
c                                  HLID, which is unlimited for stable
c                                  periods
c                   980304  (DGS): add restart option calls
c --- V4.0-V5.0     971107  (DGS): add EOF recovery to met file call
c                   971107  (DGS): NYR=NYR-1 changed to NPYR=NYR-1
c                   971107  (DGS): screen CTSG receptors hill-by-hill
c                   971107  (DGS): re-order vertex array elements
c                   971107  (DGS): add LNEMARB (variable line source)
c                   971107  (DGS): remove DPBL limit on ZTOP for stable
c                                  and neutral
c                   971107  (DGS): Place ZTOP/ZBOT logic into PUFFDZ,
c                                  and use to find advection speed
c                                  when computing sampling steps
c                   971107  (DGS): compute vertical divergence dwdz of
c                                  CALMET winds and modify sigma-z
c                   971107  (DGS): move record-skip logic into "RD..."
c                   971107  (DGS): move current value of puff code into
c                                  /CURRENT/ as icode
c --- V4.0-V4.07    971107  (DGS): add PDFVARS for CBL
c --- V4.0-V5.0     971107  (DGS): replace ZFINAL puff/slug height array
c                                  with ZPB,ZPE arrays
c                   971107  (DGS): CTSG not called for puffs above CBL
c                   971107  (DGS): RDSIG replaced with RDPROF
c
c --- Parameters: MXNX, MXNY, MXSPEC, MXP4, MXP6, MXP14,
c                 MXPT2, MXAREA, MXLINES, MXLNGRP, MXVOL, MXHILL, IO6
c
c --- COMP called by: MAIN
c --- COMP calls:     JULDAY, RDMET, RDISC, RDPLM, RDMET4, RDPROF, RDOZ,
c                     SPLIT,INITR2D,GETPRFM,GETPRFP,HDUN,INITPUF,ZFIND,
c                     ADVECT, WINDSET, TURBSET, EXMET, PTLAPS, GETOZ,
c                     VMASS, SETPUF, SETSLG, CHEM, WET, DRY, PUFRECS,
c                     CALCPF, PLGRECS, CALCSL, SLG2PUF, CTSG,
c                     OUTPUT, GRDAY, INCR, INITI2D, PDFVARS,
c                     RESTARTI, RESTARTO, TIBLON, TIBLGRO, RISEWIND,
c                     MFLXINI, MFLXCMP, MBALINI, MBALSUM, SETSOA,
c                     CALCBC, SUMBC, PLMFOG, FOGWIND, ZTRACE, FOGREC,
c                     RDAQ, GETH2O2, CHEMBK, TCHIFLX,
c                     SRCTABIN, SRCTABOUT
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'ar1.puf'
      include 'ar2.puf'
      include 'bcs.puf'
      include 'chemdat.puf'
      include 'chiflx.puf'
      include 'comparm.puf'
      include 'ctsgdat.puf'
      include 'current.puf'
      include 'datehr.puf'
      include 'dispdat.puf'
      include 'flags.puf'
      include 'fog.puf'
      include 'gen.puf'
      include 'grid.puf'
      include 'ln1.puf'
      include 'ln2.puf'
      include 'methd.puf'
      include 'methr.puf'
      include 'nongrd.puf'
      include 'outpt.puf'
      include 'pt1.puf'
      include 'pt2.puf'
      include 'puff.puf'
      include 'slug.puf'
      include 'tibl.puf'
      include 'vol1.puf'
      include 'vol2.puf'
      include 'wrkspc.puf'
c
      real hillr2(mxhill)
      real fracwet(mxspec),fracdry(mxspec)
      real xlam(mxspec),vd(mxspec),vdpvd(mxspec)
      real qold(mxspec),qnew(mxspec),qavg(mxspec),qavgt(mxspec)
      real qoldup(mxspec),qnewup(mxspec)
      real qbrate(mxspec),qerate(mxspec)
      real qbrateup(mxspec),qerateup(mxspec)
      real q01wet(mxspec,2),q01dry(mxspec,2),qratew(mxspec,2)
      real em2dat(mxp4,mxpt2),em4dat(mxp6,mxvol)
      real em3dat(mxp14,mxarea)
      real em5dat(mxp6,mxlines),em5grp(7,mxlngrp)
      real wdivs(mxnz),wdive(mxnz)
      real q1sfc(mxspec),q1upr(mxspec)
      logical ldb2,ldbhr,ldbhr0,ldbmet,lpuff,lslug,lskip,lresplit
      logical lcalm,lclip,ldohill(mxhill)
      logical leof,ldiv,lctsg,lprof,ltibl
      logical lsubsam
      logical ltest
      logical lszcap
      integer nsource(9)
c
c --- Special treatment for puffs from boundary conditions
      logical lbcpuf
      character*3 cbal
c
      data dthr/3600./,zero/0.0/
      data fracwet/mxspec*1.0/,fracdry/mxspec*1.0/
      data vd/mxspec*0.0/,vdpvd/mxspec*1.0/
      data qold/mxspec*0.0/,qnew/mxspec*0.0/
      data qoldup/mxspec*0.0/,qnewup/mxspec*0.0/
      data qbrateup/mxspec*0.0/,qerateup/mxspec*0.0/
      data qbrate/mxspec*0.0/,qerate/mxspec*0.0/
      data qratew/mxspec*0.0,mxspec*0.0/
      data xlam/mxspec*0.0/
      data iavg/1/
      data qunit/1.0/,rad/57.295778/
      data nsigma/3/
c --- Set value of transport wind speed for "calm"
      data ucalm/0.001/
c --- Set minimum value on computed potential temperature gradients
      data ptgrad0/0.005/
c
c ***
      write(iomesg,*)'COMPUTATIONAL PHASE'
c ***
c
c----------------------------------------------------------
c --- INITIALIZATIONS
c----------------------------------------------------------

c --- Set search radius (grid cells) for boundary condition puffs
c --- to impact a receptor
      rbc0=rsampbc*1000.*dgridi

c --- Date and hour (00-23: time ending!)
      nyr=ibyr
      nmo=ibmo
      nday=ibdy
      nhr=ibhr
c --- Hour index (01-24: hour ending at 0000 is 24th hour)
      nhrind=nhr
      if(nhrind.EQ.0) nhrind=24
      call JULDAY(io6,nyr,nmo,nday,njul)
      ndathr=nyr*100000+njul*100+nhr
c
c --- Set basic time step in integer hours
      nhrinc=nint(dthr/3600.)
c
      xsamleni=1.0/xsamlen
      xtmp2=dthr*xsamleni*dgridi
      chioz=bcko3m(nmo)
      chih2o2=bckh2o2m(nmo)
      rconst=nsigma*dgridi
c
c --- Set boundary of computational grid in MET-GRID units
      xb=ibcomp-1.0
      xe=iecomp
      yb=jbcomp-1.0
      ye=jecomp
c
c --- Set factor used to distinguish "puff codes" for puffs vs. slugs
      mfact=10*mslug
c
c --- Pass default potential temperature gradient from control file
c --- variable PTG0 to hourly met variable PTG (hourly PTG is provided
c --- by RDISC and RDPLM, but not by RDMET, RDMET4)
      ptg(1)=ptg0(1)
      ptg(2)=ptg0(2)
c
c --- Set value of LCLIP:  this is passed to PUFRECS, SLGRECS, and
c --- PLGRECS to limit receptor-specific sigmas to range defined by
c --- values at the start/end of the step, when true.
c     lclip=.FALSE.
      lclip=.TRUE.
c
c --- Set End-Of-File logical to .FALSE. (met & chem files)
      leof=.FALSE.
c
c --- PROFILE heights are determined hourly, but initialize to model
c --- layers for cases where PROFILE.DAT file is not used
      nzprf=nz
      do iz=1,nz
         zprf(iz)=zgpt(iz)
      enddo

c --- Set square of maximum "radius" of hills for CTSG option
      if(MCTSG.EQ.1) then
         do ih=1,nhill
            hillr2(ih)=(dgridi*AMAX1(hilldat(10,ih),hilldat(11,ih)))**2
         enddo
      endif

c --- Set logical for incorporating vertical divergence in puff growth
      if(lcalgrd .AND. metfm.EQ.1) then
         ldiv=.TRUE.
      else
         ldiv=.FALSE.
      endif

c --- Set logical for applying cap to sigma-z to protect virtuals
      if(szcap_m.GT.0.0) then
         lszcap=.TRUE.
      else
         lszcap=.FALSE.
      endif

c --- Set logical for reading PROFILE.DAT as a secondary met file
c --- (e.g. for turbulence data or inversion strength)
      if(metfm.EQ.4 .OR. metfm.EQ.5) then
         lprof=.FALSE.
      elseif(mtinv.EQ.1) then
         lprof=.TRUE.
      elseif(mdisp.EQ.1 .OR. mdisp.EQ.5) then
         if(mturbvw.LT.4) then
            lprof=.TRUE.
         else
            lprof=.FALSE.
         endif
      else
         lprof=.FALSE.
      endif

c --- Initialize model fields with restart file if this is
c --- a "continuation" run, and if NPUFFS>0 was found in header
      if(npuffs.GT.0 .AND.
     &  (mrestart.EQ.1 .OR. mrestart.EQ.3)) call RESTARTI

c --- Set puff ID range for debug output
      ipfdeb1=ipfdeb
      ipfdeb2=ipfdeb1+npfdeb-1

c----------------------------------------------------------
c --- BASIC TIME LOOP (hours)
c----------------------------------------------------------
      if(imesg.eq.1)then
         write(iomesg,*)'  ---   Puff #      Advection Step'
         write(iomesg,*)
      elseif(imesg.eq.2)then
        if(msplit.GT.0) then
          write(iomesg,*)'  --- YYYYJJJHH    # Old  # Split  # Emitted'
        else
          write(iomesg,*)'  --- YYYYJJJHH    # Old  # Emitted'
        endif
        write(iomesg,*)
      endif
c
      iarlg=IABS(irlg)
      do 1000 nn=1,iarlg
c ***
      if(imesg.eq.1)print 5,nn
5     format('+',' Reading Data         ',i6)
c ***
c
c --- Determine if debug data are written this hour
      if(nn.ge.nn1.and.nn.le.nn2)then
         ldbhr=ldebug
      else
         ldbhr=.false.
      endif
      ldbhr0=ldbhr
c
c --- Read meteorological data
      ldbmet=ldbhr
c     ldbmet=.FALSE.
c
c --- Read data from PROFILE file for current hour if needed for
c --- turbulence data or inversion strength, if PROFILE.DAT is not
c --- the primary met file (LPROF=T if PROFILE.DAT must be read here)
      if(LPROF) then
         if(mprffm.EQ.1) then
            call RDPROF(ndathr,ldbmet,nzprf,wsprf,wdprf,tprf,zprf,
     &                  ssprf,swprf,svprf,dptinvo,leof)
         elseif(mprffm.EQ.2) then
            call RDPROF5(ndathr,ldbmet,nzprf,wsprf,wdprf,tprf,zprf,
     &                   ssprf,swprf,svprf,dptinvo,leof)
         else
            write(io6,*)
            write(io6,*) 'COMP:  Bad MPRFFM found = ',mprffm
            write(io6,*) 'Expected 1 or 2'
            write(io6,*)
            write(*,*)
            write(*,*) 'COMP:  Bad MPRFFM found = ',mprffm
            write(*,*) 'Expected 1 or 2'
            write(*,*)
            stop
         endif
c
c ---    Reset PROFILE heights to model layers if turbulence data will
c ---    be read from PLMMET.DAT
         if(mturbvw.EQ.4) then
            nzprf=nz
            do iz=1,nz
               zprf(iz)=zgpt(iz)
            enddo
         endif
      endif
c
c --- Read data from primary met file for current hour
      if(metfm.EQ.1) then
c frr (09/01)- 2D arrays of rho,temp,RH,qsw,ipcode for
c         CALMET V5.3 level 010901 and up
c         call RDMET(ndathr,tmp1,nw1,ldbmet,umet,vmet,tmet,ipgt,htmix,
c     1              ustar,xmonin,wstar,rmm,tempss,rhoss,qswss,irhss,
c     2              ipcode,wdiv)

         call RDMET(ndathr,tmp1,nw1,ldbmet,umet,vmet,tmet,ipgt,htmix,
     1              ustar,xmonin,wstar,rmm,tempss,rhoss,qswss,irhss,
     2              ipcode,temp2d,rho2d,qsw2d,irh2d,ipcode2d,wdiv)

      elseif(metfm.EQ.2) then
         call RDISC(ndathr,ldbmet,umet,vmet,ipgt,htmix,ustar,xmonin,
     1              wstar,rmm,tempss,rhoss,qswss,irhss,ipcode,
     2              ptg,plexp,leof)
      elseif(metfm.EQ.3) then
         call RDPLM(ndathr,ldbmet,umet,vmet,svprf,ipgt,htmix,ustar,
     1              xmonin,wstar,rmm,tempss,rhoss,qswss,irhss,ipcode,
     2              ptg,plexp,leof)
      elseif(metfm.EQ.4) then
         call RDMET4(ndathr,ldbmet,ptg,nzprf,wsprf,wdprf,tprf,zprf,
     1              ssprf,swprf,svprf,ipgt,htmix,ustar,xmonin,wstar,
     2              rmm,tempss,rhoss,qswss,irhss,ipcode,dptinvo,
     3              leof)
      elseif(metfm.EQ.5) then
         call RDMET5(ndathr,ldbmet,ptg,nzprf,wsprf,wdprf,tprf,zprf,
     1              ssprf,swprf,svprf,ipgt,htmix,ustar,xmonin,wstar,
     2              rmm,tempss,rhoss,qswss,irhss,ipcode,dptinvo,
     3              leof)
      endif
c
c --- Disregard any DPTINVO values read from PROFILE.DAT when MTINV=0
      if(mtinv.EQ.0) dptinvo=-999.
c
c --- Compute cloud and zenith data at surface met stations
      call SUNDATA(ldbmet)
c
c --- Set background data for SOA option this hour
      if(mchem.EQ.4) call SETSOA(ndathr)
c
c --- Update current monthly background data
      if(mchem.GT.0) call CHEMBK(ndathr)
c
c --- Read ozone data for current hour
      if((mchem.EQ.1 .OR. mchem.EQ.3 .OR. mchem.EQ.4)
     &                               .AND.  moz.EQ.1)then
         call RDOZ(ndathr,io22,nozsta,ldbmet,itimoz,ozconc,leof)
      endif
c
c --- Read H2O2 data for current hour
      if(maqchem.EQ.1 .AND.  mh2o2.EQ.1)then
         call RDAQ(ch2o2,ndathr,io23,nh2o2sta,ldbmet,h2o2conc,leof)
      endif
c
      if(LEOF) then
         irlg=nn-1
         write(io6,*)
         write(io6,*) 'EOF reached in MET or CHEM data files'
         write(io6,*) 'Last period processed IRLG =',irlg
         write(io6,*)
         write(*,*)
         write(*,*) 'EOF reached in MET or CHEM data files'
         write(*,*) 'Last period processed IRLG =',irlg
         write(*,*)
c ---    Roll back date-hr to report last hour processed
         nhrinc=-1
         call INCR(io6,nyr,njul,nhr,nhrinc)
         call GRDAY(io6,nyr,njul,nmo,nday)
         ndathr=nyr*100000+njul*100+nhr
         return
      endif

c
c --- Compute vertical divergence fields for CALMET data
      if(LDIV) then
         do k=nz,1,-1
            delzi=1./(zface(k+1)-zface(k))
            do i=1,nx
            do j=1,ny
               if(k.GT.1) then
                  wdiv(i,j,k)=delzi*(wdiv(i,j,k)-wdiv(i,j,k-1))
               else
                  wdiv(i,j,k)=delzi*wdiv(i,j,k)
               endif
            enddo
            enddo
         enddo
      endif
c
c --- Initialize concentrations and dry/wet fluxes at beginning
c --- of each time step (TOTAL and BC arrays)
      if(iavg.eq.1.or.mod(nn,iavg).eq.1)then
c
c ---    Gridded receptors
         if(lsamp)then
            do i=1,nspec
               call INITR2D(zero,mxnxg,mxnyg,nxsam,nysam,tchisam(1,1,i))
               if(mdry.eq.1)call INITR2D(zero,mxnxg,mxnyg,
     1                      nxsam,nysam,tdfsam(1,1,i))
               if(mwet.eq.1)call INITR2D(zero,mxnxg,mxnyg,
     1                      nxsam,nysam,twfsam(1,1,i))
            enddo
         endif
         if(lsamp .AND. nbc.GT.0)then
            call INITR2D(rbc0,mxnxg,mxnyg,nxsam,nysam,rbcsam)
            do i=1,nspec
               call INITR2D(zero,mxnxg,mxnyg,nxsam,nysam,cbcsam(1,1,i))
               if(mdry.eq.1)call INITR2D(zero,mxnxg,mxnyg,
     1                      nxsam,nysam,dbcsam(1,1,i))
               if(mwet.eq.1)call INITR2D(zero,mxnxg,mxnyg,
     1                      nxsam,nysam,wbcsam(1,1,i))
            enddo
         endif
c
c ---    Non-gridded receptors
         if(nrec.gt.0)then
            call INITR2D(zero,mxrec,mxspec,nrec,nspec,tchirec)
            if(mdry.eq.1)call INITR2D(zero,mxrec,mxspec,nrec,nspec,
     1                   tdfrec)
            if(mwet.eq.1)call INITR2D(zero,mxrec,mxspec,nrec,nspec,
     1                   twfrec)
         endif
         if(nrec.gt.0 .AND. nbc.GT.0)then
            call INITAR(rbc0,nrec,rbcrec)
            call INITR2D(zero,mxrec,mxspec,nrec,nspec,cbcrec)
            if(mdry.eq.1)call INITR2D(zero,mxrec,mxspec,nrec,nspec,
     1                   dbcrec)
            if(mwet.eq.1)call INITR2D(zero,mxrec,mxspec,nrec,nspec,
     1                   wbcrec)
         endif
c
c ---    Complex-terrain (CTSG) receptors
         if(nctrec.gt.0)then
            call INITR2D(zero,mxrect,mxspec,nctrec,nspec,tchict)
            if(nbc.GT.0) then
               call INITAR(rbc0,nctrec,rbcct)
               call INITR2D(zero,mxrect,mxspec,nctrec,nspec,cbcct)
            endif
         endif
      endif
c
c --- Initialize mass flux arrays at beginning of each time step
      if(imflx.EQ.1) call MFLXINI
c
c --- Initialize mass balance arrays at beginning of each time step
      if(imbal.EQ.1) call MBALINI
c
c --- Compute hill-specific flow parameters (Hd, U/N) for CTSG
c --- terrain option
      if(nhill.gt.0)then
         if(metfm.EQ.4 .OR. metfm.EQ.5) then
c ---       Use 1-D PROFILE.DAT arrays
c ---       Set surface layer data (use cell 1,1)
            istab=ipgt(1,1)
            istab=MIN0(istab,6)
            dpbl=AMAX1(htmix(1,1),xminzi)
            dpbl=AMIN1(dpbl,xmaxzi)
            el=xmonin(1,1)
            z0m=z0(1,1)
            call GETPRFP(ssprf,tprf,zprf,nears,tempss,lcalgrd,
     &                   istab,dpbl,el,z0m,ptg,nzprf)
            do ih=1,nhill
               call HDUN(ih)
            enddo
         else
c ---       Use 3-D MET arrays
            do ih=1,nhill
c frr (09/01) - CALMET noobs mode temp2d instead of tempss
c               call GETPRFM(ih,umet,vmet,tmet,zgpt,nears,tempss,lcalgrd,
c     &                      ipgt,ptg,nx,ny,nz,xorig,yorig,dgrid)
               call GETPRFM(ih,umet,vmet,tmet,zgpt,nears,tempss,lcalgrd,
     &                      ipgt,ptg,nx,ny,nz,xorig,yorig,dgrid,
     &                      i2dmet,temp2d)
               call HDUN(ih)
            enddo
         endif
      endif

c --- Initialize puff numbers to report to screen this step (imesg=2)
      numold=npuffs
      numsplty=0
      numspltz=0
c
c --- Split certain puffs/slugs to respond to wind shear
      ldb2=ldbhr
c     ldb2=.TRUE.
c     ldb2=.FALSE.
      if(msplit.EQ.1) then
         if(iresplit(nhrind).EQ.1) then
            lresplit=.TRUE.
         else
            lresplit=.FALSE.
         endif
         call SPLIT(ldb2,lresplit,nspec,xb,yb,xe,ye,imbal,
     &              numsplty,numspltz)
         numsplit=numsplty+numspltz
      endif
c
c --- Release new puffs/slugs for this time step
c --- NOTE: when using PRIME downwash, in/near-cavity concentrations
c ---       will be computed here within source-loop
      ldb2=ldbhr
c     ldb2=.TRUE.
c     ldb2=.FALSE.
      call INITPUF(ndathr,nspec,dthr,ldb2,em2dat,em4dat,em3dat,
     &             em5dat,em5grp,metfm,newpuf)
      noldp=npuffs
      npuffs=npuffs+newpuf
c
c --- Identify puffs for computing FOG output in plume mode, and
c --- set up puff centerline trace and receptors for each
c --- Process just the first new puff released this step from each
c --- point source
      if(LPMODE) then
         ldb2=ldbhr
c        ldb2=.TRUE.
c        ldb2=.FALSE.
         nipfog=0
c ---    ZTRACE operates on current met period tables
         imet=1
         do i=1,newpuf
            ip=noldp+i
            if(irlsnum(ip).EQ.1 .AND.
     &        (isrctyp(ip).EQ.1 .OR. isrctyp(ip).EQ.2)) then
c ---          Keep this puff
               nipfog=nipfog+1
               ipfog(nipfog)=ip
c ---          Compute puff height at each distance in fog arrays
               call ZTRACE(ldb2,ip,mxrfog,xrfog,zrfog(1,nipfog))
            else
c ---          Drop this puff
               ipufcd(ip)=99
            endif
         enddo
c ---    Generate discrete receptors for this hour
         call FOGREC(ldb2)
      endif

c --- Tracking message for this timestep
      if(imesg.EQ.2) then
         if(msplit.GT.0) then
            print 7,ndathr,numold,numsplit,newpuf
         else
            print 7,ndathr,numold,newpuf
         endif
      endif
7     format('+',6x,4i9)
c
c --- Echo splitting information to list file
      ldb2=ldbhr
c     ldb2=.TRUE.
c     ldb2=.FALSE.
      if(LDB2) then
         write(io6,'(a,5i9)')'#Old,split-y,split-z,emitted: ',
     &                         ndathr,numold,numsplty,numspltz,newpuf
      endif
c
c
c*****
      if(ldbhr)then
         write(io6,202)nn,ndathr,noldp,newpuf,npuffs
202      format(/1x,'Advection step (NN) = ',i5,2x,
     1   'Date/hour (YYYYJJJHH) = ',i9/1x,'No. old puffs (NOLDP) = ',
     2   i6,2x,'No. new puffs (NEWPUF) = ',i6,2x,
     3   'Total puffs (NPUFFS) = ',i6)
      endif
c*****
c
c----------------------------------------------------------
c --- LOOP OVER PUFFS
c----------------------------------------------------------

c --- MSOURCE Option
c ---------------------
c --- The source contribution option requires output of computed
c --- fields for EACH source as well as all sources combined.
c --- Process impacts for EACH source in turn by just using puffs
c --- emitted from that source.  This is implemented by placing a
c --- screen for the source ID into the puff loop, and executing
c --- the puff loop multiple times, once for each source.  If the
c --- source contribution option is OFF (MSOURCE=0), the puff
c --- loop is executed once, and no source screen is applied.
c --- Source Types are:
c            1 = Point         Constant Emissions
c            2 = Point         Variable Emissions
c            3 = Poly. Area    Constant Emissions
c            4 = Poly. Area    Variable Emissions
c            5 = Line          Constant Emissions
c            6 = Line          Variable Emissions
c            7 = Volume        Constant Emissions
c            8 = Grid Volume   Variable Emissions
c            9 = Boundary Condition
C --- Set range for loops over source types and sources
      if(msource.EQ.0) then
c ---    Set loop ranges so that puff loop is executed once
         nstype=1
         nsource(1)=1
         do kk=2,9
            nsource(kk)=0
         enddo
      elseif(msource.EQ.1) then
         nstype=9
         nsource(1)=npt1
         nsource(2)=npt2
         nsource(3)=nar1
         nsource(4)=nar2
         nsource(5)=nlines
         nsource(6)=nln2
         nsource(7)=nvl1
         nsource(8)=nvl2
         nsource(9)=nbc
      endif

c --- Loop over source types
      do 1200 ktype=1,nstype

c ---  Loop over sources of the current type
       do 1100 ksource=1,nsource(ktype)
c
c ---    Initialize concentrations and dry/wet fluxes (SOURCE
c ---    contribution arrays)
c ---    Gridded receptors
         if(lsamp .AND. ktype.NE.9)then
            do i=1,nspec
               call INITR2D(zero,mxnxg,mxnyg,nxsam,nysam,chisam(1,1,i))
               if(mdry.eq.1)call INITR2D(zero,mxnxg,mxnyg,
     1                      nxsam,nysam,dfsam(1,1,i))
               if(mwet.eq.1)call INITR2D(zero,mxnxg,mxnyg,
     1                      nxsam,nysam,wfsam(1,1,i))
            enddo
         endif
c
c ---    Non-gridded receptors
         if(nrec.gt.0 .AND. ktype.NE.9)then
            call INITR2D(zero,mxrec,mxspec,nrec,nspec,chirec)
            if(mdry.eq.1)call INITR2D(zero,mxrec,mxspec,nrec,nspec,
     1                   dfrec)
            if(mwet.eq.1)call INITR2D(zero,mxrec,mxspec,nrec,nspec,
     1                   wfrec)
         endif
c
c ---    Complex-terrain (CTSG) receptors
         if(nctrec.gt.0 .AND. ktype.NE.9)then
            call INITR2D(zero,mxrect,mxspec,nctrec,nspec,chict)
         endif


         DO 900 II=1,NPUFFS
c
c ---    Skip puffs/slugs off the computational grid
         if(ipufcd(ii).ge.99)go to 900

         if(LAGE) then
c ---       Drop puffs older than age cutoff
            if(tmtotb(ii).GE.tsecmax) then
               ipufcd(ii)=99
               goto 900
            endif
         endif
c
c ---    Process just first new puff released this step from each
c ---    point source if modeling visible plume length (this should
c ---    be redundant)
         if(LPMODE) then
            ltest=.FALSE.
            do jfog=1,nipfog
               if(ii.EQ.ipfog(jfog)) ltest=.TRUE.
            enddo
            if(.NOT.LTEST) then
               ipufcd(ii)=99
               goto 900
            endif
         endif

         if(msource.EQ.1) then
c ---       Skip this puff if it is not from the current source type
            if(ktype.NE.isrctyp(ii)) goto 900
c ---       Skip this puff if it is not from the current source
            if(ktype.EQ.5 .OR. ktype.EQ.6) then
c ---          Line source may be isrcnum=1000+isrcnum (isrcnum<1000)
               ksource2=ksource+1000
               if(isrcnum(ii).NE.ksource .AND.
     &            isrcnum(ii).NE.ksource2) goto 900
            else
               if(isrcnum(ii).NE.ksource) goto 900
            endif
         endif
c
c ---    Using area-source approach for modeling NEW emissions from
c ---    LINE sources requires skipping the sampling step for slugs
c ---    released from all but the first "segment" of a line.  This
c ---    will be controlled by LSKIP.  Initialize it here.
         lskip=.FALSE.
c
c ---    Use puff position (or younger end of slug) to obtain initial
c ---    met grid cell index - make sure that index is in bounds!
         ixs=1.0+xpb(ii)
         iys=1.0+ypb(ii)
         if(ixs.LT.1) then
            ixs=1
         elseif(ixs.GT.nx) then
            ixs=nx
         endif
         if(iys.LT.1) then
            iys=1
         elseif(iys.GT.ny) then
            iys=ny
         endif
c ***
         if(imesg.eq.1)print 8,ii,nn
8        format('+',6x,i6,10x,i6)
c ***
c
c ---    Track puffs in DEBUG mode, starting with puff IPFDEB1 and
c ---    ending with puff IPFDEB2
         ldbhr=ldbhr0
         if(ii.GE.ipfdeb1 .AND. ii.LE.ipfdeb2) then
            ldbhr=ldbhr
         else
            ldbhr=.FALSE.
         endif
c
c ---    Retrieve puff/slug identification factor for this "puff"
c ---    (MFACT equal 0 indicates all are puffs, but some slugs are
c ---    really puffs if the slug indexing factor has been removed
c ---    from the puff code)
         if(mfact.EQ.0 .OR. ipufcd(ii).LT.mfact) then
c ---       This is a PUFF
            mfact0=0
            lpuff=.TRUE.
            lslug=.FALSE.
            zpmean=zpb(ii)
         else
c ---       This is a SLUG
            mfact0=mfact
            lslug=.TRUE.
            lpuff=.FALSE.
            zpmean=0.5*(zpb(ii)+zpe(ii))
         endif
c
c ---    Assign puff code for this puff
         icode=ipufcd(ii)
c
c ---    Move puff identification into local and /CURRENT/ variables:
c ---       IPNO,   the puff number released from the source for the
c ---               current time step (local);
c ---       ISTYPE, the type of source (/CURRENT/); and
c ---       ISNUM,  the source number from which the puff was released
c                   (/CURRENT/)
         ipno=irlsnum(ii)
         istype=isrctyp(ii)
         isnum=isrcnum(ii)
c --- Retain IMET for roll-back capability to earlier versions, but set
c --- equal to 1 here so that /SRCTAB/ tables are always used
         imet=1
cc
cc ---    Compute met period index for source tabulations for this puff
cc ---    (stored in /CURRENT/, capped at MXMETSAV+1)
c         imet=1+(ipno-1+NINT(tmtotb(ii)/temit0(ii)))/
c     &           NINT(dthr/temit0(ii))
c         imet=MIN(imet,mxmetsav+1)
c         if(imet.LT.1) then
c            write(io6,*)
c            write(io6,*) 'FATAL ERROR in COMP: bad met period index'
c            write(io6,*) 'Expected IMET = 1 to MXMETSAV+1'
c            write(io6,*) 'Found    IMET = ',imet
c            write(io6,*) '     MXMETSAV = ',mxmetsav
c            write(io6,*)
c            write(*,*)
c            stop 'Halted in COMP -- See list file'
c         endif

c ---    Place source tabulations that apply to this puff into /SRCTAB/
         call SRCTABIN(ii,isrctyp(ii),isrcnum(ii),irlsnum(ii))

c ---    Place the platform height (downwash) into /CURRENT/ if this
c ---    puff is from a point source
         zplat=0.0
         if(istype.EQ.1) then
            zplat=zplatpt1(isnum)
         elseif(istype.EQ.2) then
            zplat=zplatpt2(isnum)
         endif

c ---    Set logical for treating boundary condition (BC) puffs
         lbcpuf=.FALSE.
         if(istype.EQ.9) lbcpuf=.TRUE.
c
c ---    Find the layer containing the puff before rise
         call ZFIND(ht0(ii),zface,nzp1,ilayer0)
c ---    Find the layer containing the puff after rise
         call ZFIND(zpmean,zface,nzp1,ilayer1)
c
c ---    Determine the number & length of the sampling steps
         if(ii.le.noldp)then
c
c ---       OLD PUFF/SLUG
            iold=1
c
c ---       Assign met parameters from cell
            istab=ipgt(ixs,iys)
            istab=MIN0(istab,6)
            dpbl=AMAX1(htmix(ixs,iys),xminzi)
            dpbl=AMIN1(dpbl,xmaxzi)
            el=xmonin(ixs,iys)
            z0m=z0(ixs,iys)
c
c ---       Distance that would be traveled during the time step
c           (in grid units)
c ---       Get wind speed for puff at final rise for metfm=1,4,5
            ilayer=ilayer1
            htmet=zpmean
c ---       Use power law from wind at stacktop for metfm=2,3
            if(metfm.EQ.2 .OR. metfm.EQ.3) then
               htmet=ht0(ii)
               ztop=htmet
               zbot=htmet
            else
               call PUFFDZ(ii,icode,lpuff,istab,ilayer,htmet,dpbl,
     &                     ztop,zbot)
            endif
            call ADVECT(ldbhr,ixs,iys,z0m,el,dpbl,istab,ht0(ii),
     &                  zbot,ztop,uadv,vadv)
            ws=SQRT(uadv**2+vadv**2)
            if(ws.LT.wscalm) ws=AMAX1(ws,ucalm)
c
            nsam=nint(ws*xtmp2+1)
            nsam=min0(nsam,mxsam)
            xsami=1.0/float(nsam)
            nsstr=1
            tsamp=dthr*xsami
c ***
      if(ldbhr)then
         write(io6,*)
         write(io6,*)'OLD PUFF'
         write(io6,*)'ii = ',ii,' nsam = ',nsam,' nsstr = ',nsstr
         write(io6,*)'tsamp = ',tsamp,' ws = ',ws
      endif
c ***
         ELSE
c
c ---       NEW PUFF/SLUG
            iold=0
c
            if(istype.EQ.1) then
c ---          Revise npnew to allow PRIME module to create a dual
c ---          release (primary source and cavity source);
c ---          npnew=newpt1(isnum) can be too large by factor of 2
               npnew=NINT(dthr/temit0(ii))
            elseif(istype.EQ.2) then
c ---          Revise npnew to allow PRIME module to create a dual
c ---          release (primary source and cavity source);
c ---          npnew=newpt2(isnum) can be too large by factor of 2
               npnew=NINT(dthr/temit0(ii))
            elseif(istype.EQ.3) then
               npnew=newar1(isnum)
               if(lslug) then
c ---             Transfer vertex information and area of source to
c ---             /current/ arrays (new slug from POLYGON area)
                  nside=nvert1(isnum)
                  aream2=area1(isnum)
                  do iv=1,nside
                     xvert(iv)=xar1grd(iv,isnum)*dgrid
                     yvert(iv)=yar1grd(iv,isnum)*dgrid
                  enddo
               endif
            elseif(istype.EQ.4) then
               npnew=newar2(isnum)
               if(lslug) then
c ---             Transfer vertex information and area of source to
c ---             /current/ arrays (new slug from POLYGON area)
                  nside=nvert2(isnum)
                  aream2=area2(isnum)
                  do iv=1,nside
                     xvert(iv)=xar2grd(iv,isnum)*dgrid
                     yvert(iv)=yar2grd(iv,isnum)*dgrid
                  enddo
               endif
            elseif(istype.EQ.5) then
               if(lslug) then
                  if(isnum.LT.1000) then
c ---                This puff is a NEW release from segment 1 of LINE
c ---                so polygon area source method for slugs is used
c ---                for entire line during the first sampling step.
c ---                Transfer "vertex" information and "area" of source
c ---                to /CURRENT/ arrays.
                     nside=4
c ---                Note: pass area of one segment
                     aream2=arline(isnum)/nseg(isnum)
                     do iv=1,nside
                        xvert(iv)=xvertl(iv,isnum)*dgrid
                        yvert(iv)=yvertl(iv,isnum)*dgrid
                     enddo
                  else
c ---                This slug is a NEW release from segment 2+ of LINE
c ---                so skip call to CALCSL for 1st sampling step
                     lskip=.TRUE.
c ---                Reset puff ID information
                     isnum=isnum-1000
                     isrcnum(ii)=isnum
c ---                Replace source tabulations that apply to this puff
c ---                in the DA file, using the updated source number
                     call SRCTABOUT(ii,isrctyp(ii),isrcnum(ii),
     &                              irlsnum(ii))
                 endif
               endif
               npnew=newln1(isnum)
            elseif(istype.EQ.6) then
               if(lslug) then
                  if(isnum.LT.1000) then
c ---                This puff is a NEW release from segment 1 of LINE
c ---                so polygon area source method for slugs is used
c ---                for entire line during the first sampling step.
c ---                Transfer "vertex" information and "area" of source
c ---                to /CURRENT/ arrays.
                     nside=4
c ---                Note: pass area of one segment
                     aream2=arline2(isnum)/nseg2(isnum)
                     do iv=1,nside
                        xvert(iv)=xvertl2(iv,isnum)*dgrid
                        yvert(iv)=yvertl2(iv,isnum)*dgrid
                     enddo
                  else
c ---                This slug is a NEW release from segment 2+ of LINE
c ---                so skip call to CALCSL for 1st sampling step
                     lskip=.TRUE.
c ---                Reset puff ID information
                     isnum=isnum-1000
                     isrcnum(ii)=isnum
c ---                Replace source tabulations that apply to this puff
c ---                in the DA file, using the updated source number
                     call SRCTABOUT(ii,isrctyp(ii),isrcnum(ii),
     &                              irlsnum(ii))
                  endif
               endif
               npnew=newln2(isnum)
            elseif(istype.EQ.7) then
               npnew=newvl1(isnum)
            elseif(istype.EQ.8) then
               npnew=newvl2(isnum)
            elseif(istype.EQ.9) then
               npnew=newbc(isnum)
            else
               write(io6,*)
               write(io6,*) 'FATAL:  Source type invalid! - ',istype
               write(io6,*)
               write(*,*)
               stop 'Halted in COMP -- see list file.'
            endif
c
            nsam=npnew
            xsami=1.0/float(nsam)
            nsstr=ipno
            tsamp=temit0(ii)
c
c ***
      if(ldbhr)then
         write(io6,*)
         write(io6,*)'NEW PUFF'
         write(io6,*)'ii = ',ii,' nsam = ',nsam,' nsstr = ',nsstr
         write(io6,*)'tsamp = ',tsamp,' IPNO = ',ipno,' ISNUM = ',isnum
         write(io6,*)'ISTYPE = ',istype,' NPNEW = ',npnew
      endif
c ***
         ENDIF

c ---    Reciprocal of number of seconds in averaging period
         tavgi=1./(float(iavg)*dthr)
c ---    Reciprocal of number of seconds in puff emission period
         temiti=1.0/temit0(ii)
c ---    Reciprocal of number of seconds in a sampling step
         tsampi=1.0/tsamp
c ---    Reciprocal of number of sampling steps in averaging period
         tfract=tsamp*tavgi

c ---    Sampling step may need to be adjusted as puff travels among
c ---    grid cells if speeds change sufficiently.  Assign the initial
c ---    sampling step interval to a reference variable.
         reftsamp=tsamp
         tleft=0.0
c ---    Do not use substeps if the number of sampling steps already
c ---    equals the maximum imposed
         lsubsam=.TRUE.
         if(nsam.EQ.mxsam) lsubsam=.FALSE.

c*****
      if(ldbhr)then
         write(io6,212)ii,iold,irlsnum(ii),isrcnum(ii),isrctyp(ii),
     &                 ipufcd(ii)
         write(io6,214)xpb(ii),ypb(ii),sigyb(ii),sigzb(ii),xtotb(ii),
     1    tmtotb(ii)
         if(ipufcd(ii).gt.10)write(io6,216)xpe(ii),ype(ii),
     1    sigye(ii),sigze(ii),xtote(ii),tmtote(ii)
         write(io6,218)zimax(ii),ziold(ii),zpmean,xfinal(ii),
     1    elbase(ii),ws0(ii),srat0(ii),temit0(ii)
         write(io6,220)'QU',(qu(n,ii),n=1,nspec)
         write(io6,220)'QM',(qm(n,ii),n=1,nspec)
212      format(5x,'Puff no.=',i7,2x,'IOLD=',i1,' (0=new,1=old)',
     1   2x,'IRLSNUM=',i8,2x,'ISRCNUM=',i8,2x,'ISRCTYP=',i8,
     2   2x,'IPUFCD=',i3)
214      format(5x,'XPB=',f8.3,2x,'YPB=',f8.3,2x,'SIGYB=',f8.1,2x,
     1    'SIGZB=',f8.1,2x,'XTOTB=',f8.1,2x,'TMTOTB=',f10.1)
216      format(5x,'XPE=',f8.3,2x,'YPE=',f8.3,2x,'SIGYE=',f8.1,2x,
     1    'SIGZE=',f8.1,2x,'XTOTE=',f8.1,2x,'TMTOTE=',f10.1)
218      format(5x,'ZIMAX=',f6.0,2x,'ZIOLD=',f6.0,2x,'ZPMEAN=',f7.2,
     1    2x,'XFINAL=',f7.1,2x,'ELBASE=',f6.1,2x,'WS0=',f6.2,2x,
     2    'SRAT0=',f6.3,2x,'TEMIT0=',f7.1)
220      format(5x,a2,'=',8(f12.2,2x))
         write(io6,*)'TEMITI= ',temiti,' TFRACT=',tfract,' TSAMPI=',
     1    tsampi,' TAVGI=',tavgi
      endif
c*****

c ---    Add mass of fresh emissions to total emissions this period
         if(imbal.EQ.1 .AND. iold.EQ.0) then
            if(LBCPUF) then
               cbal='IBC'
            else
               cbal='INP'
            endif
            call MBALSUM(cbal,qm(1,ii),qu(1,ii),qm(1,ii),qu(1,ii))
         endif

c
c----------------------------------------------------------
c ---    LOOP OVER SAMPLING STEPS
c----------------------------------------------------------
         DO 800 KSAM=NSSTR,NSAM
c
c ---    Initialize sampling step variables
         tsamp=reftsamp+tleft
c ---    Time left in current sampling step
         tleft=tsamp
c
c ---    Identify slugs that are attached to source and puffs that are
c ---    at the source at the start of the step: if puff/slug was
c ---    generated this time-step (IOLD=0), and if this is the first
c ---    sampling step, then a slug is attached to the source for the
c ---    sampling step, and a puff touches the source at the start
c ---    (ifree=0).
         ifree=1
         if(ksam .EQ. nsstr) ifree=iold
c
c ---    Re-entry for possible substep
500      continue
         tsampi=1.0/tsamp
         tfract=tsamp*tavgi

c ---    Transfer met. variables at start of step needed to compute
c ---    trajectory.  Use the puff position at the end of the previous
c ---    step, or the average slug position at the end of previous step.
         if(lpuff) then
c ---       Set last position of PUFF
            xold=xpb(ii)
            yold=ypb(ii)
            zold=zpb(ii)
         else
c ---       Set last position of SLUG center
            xold=0.5*(xpb(ii)+xpe(ii))
            yold=0.5*(ypb(ii)+ype(ii))
            zold=0.5*(zpb(ii)+zpe(ii))
         endif
c
         ixs=1.0+xold
         iys=1.0+yold
         if(ixs.LT.1) then
            ixs=1
         elseif(ixs.GT.nx) then
            ixs=nx
         endif
         if(iys.LT.1) then
            iys=1
         elseif(iys.GT.ny) then
            iys=ny
         endif
c
c ------------------------------------
c ---    Determine the advective winds
c ------------------------------------
         istab=ipgt(ixs,iys)
         istab=MIN0(istab,6)
         dpbl=AMAX1(htmix(ixs,iys),xminzi)
         dpbl=AMIN1(dpbl,xmaxzi)
         el=xmonin(ixs,iys)
         z0m=z0(ixs,iys)
c
         htmet=zold
         ilayer=ilayer1
c
c ---    Compute the height of the bottom and top of the puff/slug
c ---    at the end of previous step
         call PUFFDZ(ii,icode,lpuff,istab,ilayer,htmet,dpbl,
     &               ztop,zbot)
c
c ---    Compute the wind components for advection
         call ADVECT(ldbhr,ixs,iys,z0m,el,dpbl,istab,ht0(ii),zbot,ztop,
     &               uadv,vadv)
c ---    Compute corresponding speed and direction
         ws=SQRT(uadv**2+vadv**2)
c
c ---    Account for wind profile on transport during rise
c ---    (applies to CALMET or PROFILE winds only)
         if((MOD(icode,2).EQ.1).AND.
     &      (xtotb(ii).LT.xfinal(ii))) then
            if(metfm.EQ.1 .OR. metfm.EQ.4 .OR. metfm.EQ.5) then
c ---          Fill /CURRENT/ variables needed in GRISE
               ipnum=ii
               zfrise=zfinal(ii)-(ht0(ii)-stipdw(ii))
               xfrise=xfinal(ii)
               xshift=xshift0(ii)
c ---          Vertical spread from centerline ht at start of step
               dzb=ztop-htmet
c ---          Obtain average wind for step
               call RISEWIND(ldbhr,lpuff,ncount,dzb,ii,ixs,iys,z0m,
     &                       el,dpbl,istab,tsamp,uadv,vadv,ws)
            endif
         endif
c
c ---    Treat calm conditions by imposing a minimum on vadv
         if(ws.LT.wscalm) then
            lcalm=.TRUE.
            if(ABS(vadv).LT.ucalm) vadv=ucalm
            ws=AMAX1(ws,ucalm)
         else
            lcalm=.FALSE.
         endif
c
c ---    FOG analysis in PLUME mode requires advection to be shifted
c ---    to align with receptor directions
         if(LPMODE) call FOGWIND(io6,ldbhr,ws,uadv,vadv)
c
c ---    Compute final advection wind direction (not flow vector)
         wd=270.-rad*atan2(vadv,uadv)
         wd=amod(wd,360.)

c ---    Apply constraint on step-size:  Slugs that are being emitted
c ---    during the first sampling step are not altered (they are NOT
c ---    free of the source)
         fstep=1.0
         if((LPUFF .OR. (LSLUG .AND. ifree.EQ.1)) .AND. LSUBSAM) then
c ---       Step distance in grid units should not exceed XSAMLEN
            fstep=ws*tsamp*dgridi*xsamleni
            if(fstep.GT.1.0) then
c ---          Substep with shorter sampling time is needed
               if(fstep.GE.2.0 .OR. ksam.LT.nsam) then
c ---             Take a full XSAMLEN this sub-step
                  tsamp=tsamp/fstep
                  tsampi=1.0/tsamp
                  tfract=tsamp*tavgi
               else
c ---             This is the last step and 1<fstep<2, so divide it
c ---             into two equal timesteps
                  tsamp=0.5*tsamp
                  tsampi=1.0/tsamp
                  tfract=tsamp*tavgi
               endif
c ---          Shorter TSAMP could change mean transport wind if puff
c ---          is still rising! (revisit RISEWIND)
               if(xtotb(ii).LT.xfinal(ii)) then
                  if(metfm.EQ.1 .OR. metfm.EQ.4 .OR. metfm.EQ.5) then
                     call RISEWIND(ldbhr,lpuff,ncount,dzb,ii,ixs,iys,
     &                            z0m,el,dpbl,istab,tsamp,uadv,vadv,ws)
                  endif
               endif
            endif
         endif
         tleft=tleft-tsamp

c*****
      if(ldbhr)then
         write(io6,240)ksam,nsam
         write(io6,242)'BEGINNING Qs',(qu(n1,ii),n1=1,nspec)
         write(io6,244)(qm(n2,ii),n2=1,nspec)
         write(io6,245)xold,yold,ixs,iys,ilayer
         write(io6,246)ws,wd,dpbl
         write(io6,*)' REFTSAMP      TSAMP      TLEFT    (for substep)'
         write(io6,'(3f10.2)') reftsamp,tsamp,tleft
240      format(/10x,'Sampling step: ',i4,' of ',i4)
242      format(10x,a11,1x,'QU=  ',5(f11.1,1x))
244      format(22x,'QM=  ',5(f11.1,1x))
245      format(10x,'XOLD=',f7.3,' YOLD=',f7.3,' IXS=',i4,' IYS=',i4,
     1    ' ILAYER=',i3)
246      format(10x,'WS=',f7.3,' WD=',f7.3,' DPBL=',f7.1)
      endif
c*****
c
c ---    Compute the DX, DY and new coordinates of the puff (in
c ---    met. grid units).  Note that when slugs are modeled, the
c ---    new and old DX,DY refer to the distance traveled by the
c ---    newer and older ends of the slug during the step.  Furthermore,
c ---    the new X,Y represents the new position of the slug center.
c ---    First, in meters.
         dxoldm=uadv*tsamp
         dyoldm=vadv*tsamp
         dxnewm=dxoldm
         dynewm=dyoldm
         distm=ws*tsamp
c ---    Now, in met. grid units
         dxmold=dxoldm*dgridi
         dymold=dyoldm*dgridi
         xnew=xold+dxmold
         ynew=yold+dymold

c ---    Set cell index for the mid-point of the step
         ixmid=0.5*(xold+xnew)+1.0
         if(ixmid.LT.1) then
            ixmid=1
         elseif(ixmid.GT.nx) then
            ixmid=nx
         endif
         iymid=0.5*(yold+ynew)+1.0
         if(iymid.LT.1) then
            iymid=1
         elseif(iymid.GT.ny) then
            iymid=ny
         endif

c ---    Set cell index for the end of the step
         ixend=xnew+1.0
         if(ixend.LT.1) then
            ixend=1
         elseif(ixend.GT.nx) then
            ixend=nx
         endif
         iyend=ynew+1.0
         if(iyend.LT.1) then
            iyend=1
         elseif(iyend.GT.ny) then
            iyend=ny
         endif
c
c ---    Add contribution of vertical divergence to sigma-z if
c ---    Gaussian puff/slug enters a cell with acute vertical
c ---    divergence during step
         if(LDIV .AND. mod(icode,2).EQ.1) then
c ---       Find average w-divergence across puff using "wind" sub.
            do kz=1,nz
               wdivs(kz)=wdiv(ixs,iys,kz)
               wdive(kz)=wdiv(ixend,iyend,kz)
            enddo
            call ADVWND(wdivs,wdive,zface,nzp1,zbot,ztop,divs,dive)
            wdivmx=AMAX1(divs,dive)
            if(wdivmx.GT.cdiv(1)) then
               ftrans=1.0
               if(wdivmx.LT.cdiv(2)) ftrans=(wdivmx-cdiv(1))/
     &                                      (cdiv(2)-cdiv(1))
               szdivfac=1.+ftrans*wdivmx*tsamp
               sigzb(ii)=sigzb(ii)*szdivfac
               sigze(ii)=sigze(ii)*szdivfac
            else
               szdivfac=0.0
            endif
         else
            szdivfac=0.0
         endif
c*****
         if(ldbhr .AND. szdivfac.GT.0.0) then
            write(io6,*) ' -----  Div triggered; szdivfac=',szdivfac
            write(io6,*) ' -----  Dw/Dz averaged over puff'
            write(io6,*) '           ixs,iys,ixend,iyend =',ixs,iys,
     &                                                  ixend,iyend
            do kz=1,nz
               write(io6,*)' iz,wdiv(start),wdiv(end) =',kz,wdivs(kz),
     &                                                      wdive(kz)
            enddo
            write(io6,*) '              ftrans,wdivmx =',ftrans,wdivmx

         endif
c*****
c
c ---    CAP
c ---    Place a cap on the size of the sigma-z at the start of the step
c ---    to keep it from growing (much) beyond a very large value
c ---    This keeps sigma within the range of the host curves
         if(lszcap) then
            sigzb(ii)=AMIN1(sigzb(ii),szcap_m)
            sigze(ii)=AMIN1(sigze(ii),szcap_m)
            if(ldbhr) then
               write(io6,*) ' -----  SIGMA-Z CAP (m): ',szcap_m
               write(io6,*) ' -----  sigzb,sigze = ',
     &                               sigzb(ii),sigze(ii)
            endif
         endif
c
c ---    Transfer ozone concentration for chemistry
         ldb2=.false.
         if(mchem.EQ.1 .OR. mchem.EQ.3 .OR. mchem.EQ.4)
     &      call GETOZ(ixmid,iymid,dgrid,ldb2,chioz)
c
c ---    Transfer H2O2 concentration for aqueous chemistry
         ldb2=.false.
         if(maqchem.EQ.1)
     &      call GETH2O2(ixmid,iymid,dgrid,ldb2,chih2o2)

c ---    Set met/dispersion data for the mid-point of the step
         istab=ipgt(ixmid,iymid)
         istab=min0(istab,6)
         dpbl=amax1(htmix(ixmid,iymid),xminzi)
         dpbl=amin1(dpbl,xmaxzi)
         el=xmonin(ixmid,iymid)
         ustr=ustar(ixmid,iymid)
         wstr=wstar(ixmid,iymid)
         z0m=z0(ixmid,iymid)
c ---    Assign Plume Path Coefficient (even if not used)
         ppcoef=ppc(istab)
c
c ---    Extract IRU value (rural=0, urban=1) at mid-point
         iru=0
         if(ilandu(ixmid,iymid) .GE. iurb1 .AND.
     &      ilandu(ixmid,iymid) .LE. iurb2) iru=1

c ---    Set met cell index for subsequent use (TIBL may change index)
         ixmet=ixmid
         iymet=iymid

c ---    Test for sub-grid TIBL treatment
c ---------------------------------------
         ltibl=.FALSE.
         if(MSGTIBL.EQ.1) then
c ---       Store current sampling time into MASTER variable since
c ---       sub-grid TIBL module may alter it
            tsamp0=tsamp
            itibl=0
            if(zitibl(ii).LE.0.) then
c ---          Puff not currently interacting with TIBL
c ---          Check for Positive Radiation at start of step
c frr (09/01 ) 2D QSW in CALMET
               if(i2dmet.EQ.1) then
                  qsws=qsw2d(ixs,iys)
               elseif(i2dmet.EQ.0) then
                  qsws=qswss(nears(ixs,iys))
               else
                  write(*,*)'Subr. COMP:  Invalid I2DMET = ',i2dmet
                  stop
               endif
               if(qsws.GT.0.0) then
                  ltibl=.TRUE.
c ---             Complete the check for initiating TIBL this step
c ---             and set parameters if TIBL is needed
                  if(LTIBL) call TIBLON(ldbhr,ifree,xold,yold,xnew,
     &                                  ynew,ixs,iys,ixend,iyend,
     &                                  htmet,ltibl)
               endif
               if(LTIBL) then
c ---             Store TIBL ht for next sampling step for this puff
                  if(ilandu(ixend,iyend).GE.iwat1 .AND.
     &               ilandu(ixend,iyend).LE.iwat2) then
c ---                Still in a water cell (must re-enter this section)
                     zitibl(ii)=-1.
                  else
                     zitibl(ii)=htibl(ntibl)
                  endif
               endif
            else
c ---          Puff currently interacting with TIBL (ZITIBL>0)
c ---          Do not override current land use cell index (TIBLGRO)
               ixr=-1
               iyr=-1
c ---          Current heat flux must exceed 5 W/m**2 for further TIBL
c frr (09/01 ) 2D QSW in CALMET
               if(i2dmet.EQ.1) then
                  temps=temp2d(ixs,iys)
               elseif(i2dmet.EQ.0) then
                  temps=tempss(nears(ixs,iys))
               else
                  write(*,*)'Subr. COMP:  Invalid I2DMET = ',i2dmet
                  stop
               endif

c ---          Test for heat flux using met data at start of step,
c ---          and form based on u-star and M-O length
c ---          to conform to what is done within TIBLGRO
               ustars=AMAX1(0.0,ustar(ixs,iys))
               hbyrcp=-ustars**3*temps/(9.8*0.4*xmonin(ixs,iys))

               if(hbyrcp.LE.0.004) then
c ---             Turn off TIBL calculations due to small heat flux
                  ltibl=.FALSE.
                  zitibl(ii)=-1.
               elseif(zitibl(ii).GE.dpbl) then
c ---             Turn off TIBL calculations if TIBL exceeds current ZI
                  ltibl=.FALSE.
                  zitibl(ii)=-1.
               else
c ---             Compute TIBL arrays for this step
                  ltibl=.TRUE.
                  call TIBLGRO(ldbhr,xold,yold,xnew,ynew,ixr,iyr,
     &                         zitibl(ii),-.001,-1.)
c ---             Store TIBL ht for next sampling step for this puff
                  if(ilandu(ixend,iyend).GE.iwat1 .AND.
     &               ilandu(ixend,iyend).LE.iwat2) then
c ---                Enters a water cell next step
                     zitibl(ii)=-1.
                  else
                     zitibl(ii)=htibl(ntibl)
                  endif
               endif
            endif
         endif

c ---    Sub-grid TIBL Sub-step
c ---    Set up data for current substep within this sampling step
600      if(LTIBL) then
            itibl=itibl+1
c ---       Set sampling time for this sub-step
            tsamp=tstibl(itibl)*tsamp0
            tsampi=1.0/tsamp
            tfract=tsamp*tavgi
c ---       Redefine step
            distm=ws*tsamp
            dxoldm=uadv*tsamp
            dyoldm=vadv*tsamp
            dxnewm=dxoldm
            dynewm=dyoldm
            dxmold=dxoldm*dgridi
            dymold=dyoldm*dgridi
            xnew=xold+dxmold
            ynew=yold+dymold
c ---       Replace surface layer properties with those
c ---       consistent with TIBL computation
            ixmet=ixtibl(itibl)
            iymet=iytibl(itibl)
            istab=ipgt(ixmet,iymet)
            istab=min0(istab,6)
            el=xmonin(ixmet,iymet)
            ustr=ustar(ixmet,iymet)
            wstr=wstar(ixmet,iymet)
            z0m=z0(ixmet,iymet)
            iru=0
            if(ilandu(ixmet,iymet) .GE. iurb1 .AND.
     &         ilandu(ixmet,iymet) .LE. iurb2) iru=1
c ---       Assign Plume Path Coefficient (even if not used)
            ppcoef=ppc(istab)
c ---       Use actual TIBL height for dpbl
            dpbl=amax1(htibl(itibl),xminzi)
            dpbl=amin1(dpbl,xmaxzi)
         endif
c
c ---    Transfer surface station met. variables (flag=2)
         call EXMET(2,ixmet,iymet,dgrid,tempk,qsw,irh,rhoair,
     &              cldcov,coszen)
c ---    Set land (1) water (2) index for SVMIN,SWMIN
         ilw=1
         if(ilandu(ixmet,iymet).GE.iwat1 .AND.
     &      ilandu(ixmet,iymet).LE.iwat2) ilw=2
c
c ---    Set vertical mass distribution for this step
c ---    The reflecting lid returned (HLID) is used for subsequent calc
c ---    of the vertical distribution of mass; the original height
c ---    (DPBL) is retained for all other uses
         call VMASS(ii,mfact0,nspec,istab,dpbl,hlid,icode)
c ---    Place maximum mix ht for this distribution into local variable
         hlidmax=zimax(ii)
c
c ---    For puffs above mixed layer, use stability class "JSUP" to
c ---    calculate SIGMA Y and SIGMA Z growth (if JSUP=0, or if ISTAB
c ---    is 5 or 6, use the mixed-layer stability class ISTAB)
         jdstab=istab
         if(jsup.GT.0 .AND. istab.LT.5 .AND. htmet.GT.dpbl) jdstab=jsup
c
c ---    Set turbulence velocities and activate dispersion options
c ---    (Note: idopty and idoptz will be carried in /CURRENT/)
         if(mdisp.EQ.1 .OR. mdisp.EQ.2 .OR. mdisp.EQ.5) then
c ---       Extract wind speed (m/s) at Zi
            call ZFIND(dpbl,zface,nzp1,ilayerzi)
            call WINDSET(dpbl,ilayerzi,ixmet,iymet,z0m,el,dpbl,istab,
     &                   uatzi,wdzi)
            call TURBSET(ldbhr,ustr,el,wstr,jdstab,dpbl,z0m,htmet,
     &                   uatzi,ws,wd,ixmet,iymet,ilw,
     &                   tsigv,tsigw,idopty,idoptz)
         else
            idopty=mdisp
            idoptz=mdisp
            tsigv=svmin(jdstab,ilw)
            tsigw=swmin(jdstab,ilw)
         endif

c ---    Set PDF variables
         if(mpdf.EQ.1) call PDFVARS(ldbhr,io6,mdisp,icode,tsigw,wstr,
     &                         ustr,bidfnl(ii),fb(ii),dpbl,ht0(ii),ws)
c
c ---    Set local Brunt-Vaisala frequency
         if(LCALGRD) then
c ---       Use temperature (K) gradient across puff depth (DELZ)
c ---       Minimum pot. temp. gradient is 0.005 K/m
            delz=amax1((ztop-zbot),10.)
            call PTLAPS(ixmet,iymet,zbot,ptgrad0,delz,ptgrad,t0)
            bvf=sqrt(9.80665*ptgrad/t0)
         else
c ---       Use default potential temperature lapse rate with the
c ---       surface temperature from the nearest station
            if(istab.LE.4) then
               ptgrad=0.0
            elseif(istab.EQ.5) then
               ptgrad=amax1(ptg(1),ptgrad0)
            else
               ptgrad=amax1(ptg(2),ptgrad0)
            endif
            bvf=sqrt(9.80665*ptgrad/tempk)
         endif
c
c*****
      if(ldbhr)then
         write(io6,*)
         write(io6,242)'AFTER VMASS ',(qu(n1,ii),n1=1,nspec)
         write(io6,244)(qm(n2,ii),n2=1,nspec)
         write(io6,*)'old,new Puff/Slug Code = ',ipufcd(ii),icode
         write(io6,*)'             zbot,ztop = ',zbot,ztop
         write(io6,*)'             uadv,vadv = ',uadv,vadv
         write(io6,*)'       xnew,ynew,distm = ',xnew,ynew,distm
         write(io6,*)'       ixmet,iymet,iru = ',ixmet,iymet,iru
         write(io6,*)'dpbl,hlid,istab,jdstab = ',dpbl,hlid,istab,jdstab
         write(io6,*)'            bvf,ppcoef = ',bvf,ppcoef
      endif
c*****
c
c ---    Store current puff code into array (may change in VMASS)
         ipufcd(ii)=icode
c
c -----------------------------------------------------
c ---    Finish Setting Puff/Slug parameters
c -----------------------------------------------------
         if(LBCPUF) then
c ---       Boundary Condition (BC) PUFFS FIRST
            call SETBCPUF(ii,tsamp,distm,ws,xnew,ynew,ldbhr,uavg)

         elseif(lpuff) then
c
c ---       NOW PUFFS
c ---       Compute puff position and sigmas, and update stored data.
            call SETPUF(ii,tsamp,distm,jdstab,el,tsigv,tsigw,bvf,ws,
     &                  dpbl,xnew,ynew,iru,ldbhr,uavg,lcalm)
c
         else
c
c ---       NOW SLUGS
c ---       Compute position of slug-ends at start and end of step,
c ---       compute sigmas at these points, and update stored data.
            call SETSLG(ii,ifree,tsamp,iru,jdstab,el,tsigv,tsigw,bvf,
     &                  ws,dpbl,dxoldm,dyoldm,dxnewm,dynewm,ldbhr,
     &                  uavg,lcalm)
         endif
c
c
c --------------------------------------------------------
c ---    Account for Removal and/or Conversion Processes
c --------------------------------------------------------
c
c ---    Define mass at START of sampling step (after vertical
c ---    redistribution but before any removal or conversion)
         do ipl=1,nspec
c ---       Set initial pollutant mass (g) (PUFF)
            qold(ipl)=qm(ipl,ii)
            qoldup(ipl)=qu(ipl,ii)
c ---       Set starting emissions (g/s) for each pollutant (SLUG)
            qbrate(ipl)=qm(ipl,ii)*temiti
            qbrateup(ipl)=qu(ipl,ii)*temiti
c ---       Set contribution to total average mass over step
            qavgt(ipl)=0.5*(qm(ipl,ii)+qu(ipl,ii))
c ---       Store initial masses for mass balance option
            q1sfc(ipl)=qm(ipl,ii)
            q1upr(ipl)=qu(ipl,ii)
         enddo
c
c ---    Chemical Transformation
c ------------------------------
         if(mchem.ge.1)then
            zmsl=zpb(ii)+elev(ixmid,iymid)
            call CHEM(nspec,mchem,maqchem,nhrind,tsamp,jsup,qsw,tempk,
     &                irh,rhoair,istab,hlid,chioz,chih2o2,cldcov,
     &                coszen,zmsl,ldbhr)
            if(imbal.EQ.1) then
               cbal='TRN'
               if(LBCPUF) cbal='TBC'
               call MBALSUM(cbal,q1sfc,q1upr,qm(1,ii),qu(1,ii))
            endif
         endif
c*****
      if(ldbhr)then
         write(io6,242)'AFTER CHEM  ',(qu(n1,ii),n1=1,nspec)
         write(io6,244)(qm(n2,ii),n2=1,nspec)
      endif
c*****
c
c ---    Wet deposition
c ---------------------
         if(mwet.eq.1)then
            do ispec=1,nspec
               q01wet(ispec,1)=qm(ispec,ii)+qu(ispec,ii)
               qratew(ispec,1)=q01wet(ispec,1)*temiti
c ---          Store initial masses for mass balance option
               q1sfc(ispec)=qm(ispec,ii)
               q1upr(ispec)=qu(ispec,ii)
            enddo
c
            call WET(ixs,iys,nspec,tsamp,ii,tempk,ldbhr,xlam,fracwet)
c
            do ispec=1,nspec
               q01wet(ispec,2)=qm(ispec,ii)+qu(ispec,ii)
               qratew(ispec,2)=q01wet(ispec,2)*temiti
            enddo
c
            if(imbal.EQ.1) then
               cbal='WET'
               if(LBCPUF) cbal='WBC'
               call MBALSUM(cbal,q1sfc,q1upr,qm(1,ii),qu(1,ii))
            endif
         endif
c*****
      if(ldbhr)then
         write(io6,242)'AFTER WET   ',(qu(n1,ii),n1=1,nspec)
         write(io6,244)(qm(n2,ii),n2=1,nspec)
      endif
c*****
c
c ---    Dry deposition
c ---------------------
         if(mdry.eq.1)then
            do ispec=1,nspec
               q01dry(ispec,1)=qm(ispec,ii)
c ---          Store initial masses for mass balance option
               q1sfc(ispec)=qm(ispec,ii)
               q1upr(ispec)=qu(ispec,ii)
            enddo
c
            call DRY(icode,ixs,iys,nhrind,tsamp,ii,dpbl,hlid,
     &               tempk,qsw,ppcoef,ldbhr,
     &               vd,vdpvd,fracdry)
c
            do ispec=1,nspec
               q01dry(ispec,2)=qm(ispec,ii)
            enddo
c
            if(imbal.EQ.1) then
               cbal='DRY'
               if(LBCPUF) cbal='DBC'
               call MBALSUM(cbal,q1sfc,q1upr,qm(1,ii),qu(1,ii))
            endif
         endif
c*****
      if(ldbhr)then
         write(io6,242)'AFTER DRY   ',(qu(n1,ii),n1=1,nspec)
         write(io6,244)(qm(n2,ii),n2=1,nspec)
      endif
c*****
c
c ---    Define mass at END of sampling step (after removal & chemistry)
         do ipl=1,nspec
c ---       Set "new" pollutant mass (g) (PUFF)
            qnew(ipl)=qm(ipl,ii)
            qnewup(ipl)=qu(ipl,ii)
c ---       Set ending emissions (g/s) for each pollutant (SLUG)
            qerate(ipl)=qm(ipl,ii)*temiti
            qerateup(ipl)=qu(ipl,ii)*temiti
c ---       Add contribution to total average mass over step
            qavgt(ipl)=qavgt(ipl)+0.5*(qm(ipl,ii)+qu(ipl,ii))
         enddo
c
c ---    Write puff/slug data at sampling step to TRACKING file
         if(ldbhr) call TRACK(ii,ndathr,dpbl,jdstab)
c
c ---    Update mass flux totals
         if(imflx.EQ.1) call MFLXCMP(ldbhr,lslug,nspec,qavgt)
c
c ----------------------------
c ---    Sampling of puff/slug
c ----------------------------
c
c ---    Reset LSKIP if a new slug is now free of the source
         if(lskip .AND. ifree.EQ.1) lskip=.FALSE.
c
c ---    Call appropriate sampling function (BC, PUFF, or SLUG)
c
         if(LPMODE) then
c ---       Process plume data for FOG Model PLUME Mode output
            call PLMFOG(xold,yold,jdstab,
     1                  iru,tsigv,tsigw,el,bvf,ws,wd,dpbl,nspec,
     2                  qm(1,ii),qu(1,ii),icode,hlid,temiti,
     3                  ldbhr,lcalm)
c ---       Drop this puff (sampled 1 time as a plume)
            ipufcd(ii)=99
c ---       Log mass dropped
            if(imbal.EQ.1) then
               cbal='OUT'
               call MBALSUM(cbal,qm(1,ii),
     &                      qu(1,ii),qm(1,ii),qu(1,ii))
            endif
            go to 801


         elseif(LBCPUF) then
c ---       Nearest BC puff sampling function
            call CALCBC(xold,yold,xnew,ynew,qold,qnew,qoldup,qnewup,
     1                  icode,hlid,hlidmax,diam0(ii),vdpvd,nspec,
     2                  q01wet,q01dry,vd,fracwet,tsampi,rbc0,ldbhr)

         elseif(lpuff) then
c ---       Integrated puff sampling function
c ---       PUFFR is the puff radius in computational grid units at
c ---       the END of the step
            puffr=rconst*sye1

            call CALCPF(xold,yold,xnew,ynew,ppcoef,jdstab,iru,
     1                  tsigv,tsigw,el,bvf,uavg,dpbl,qold,qnew,qoldup,
     2                  qnewup,icode,hlid,hlidmax,puffr,vdpvd,nspec,
     3                  q01wet,q01dry,vd,fracwet,tsampi,tfract,
     4                  ldbhr,lcalm,lclip)
c
         elseif(.not.LSKIP) then
c ---       Slug sampling function
            call CALCSL(tsamp,tfract,nspec,qbrate,qerate,qbrateup,
     1                  qerateup,qratew,ht0(ii),elbase(ii),ppcoef,
     2                  jdstab,symin,szmin,iru,hlid,hlidmax,tsigv,
     3                  tsigw,el,bvf,dpbl,xlam,vd,vdpvd,uavg,
     3                  ldbhr,lcalm,lclip)
         endif

c -----------------------------
c ---    CTSG sampling function
c -----------------------------
c ---  NOTE 1: Deposition fluxes are not computed at CTSG receptors,
c ---          but any change in the mass in a puff/slug during the
c ---          step is reflected in the concentrations at these
c ---          receptors insofar as the average mass is used here.
c ---  NOTE 2: CTSG algorithm is not designed for CALM conditions.  A
c ---          treatment for CTSG receptors has been added to CALCPF
c ---          and CALCSL for CALM conditions, so skip call to CTSG.
c ---  NOTE 3: CTSG does not interpret puff codes;  screen out codes
c ---          3 & 13 at the start (all material above CBL)

         lctsg=.FALSE.
         if(nctrec.GT.0 .AND. .not.LCALM .AND. .not.LBCPUF) then
            if(mod(icode,10).NE.3) lctsg=.TRUE.
         endif
         if(LCTSG) then
c
c ---       Define AVERAGE mass during sampling step for each pollutant
c ---       but do not incorporate the near-surface correction factor
c ---       (vd'/vd) because center of puff may impinge on terrain
            do ipl=1,nspec
c ---          Set the average pollutant mass (g) below mixing height
               qavg(ipl)=0.5*(qold(ipl)+qnew(ipl))
            enddo
c
            if(lpuff) then
c ---          PUFFS:
c
c ---          Set puff radius (squared) at end of step to identify
c ---          receptors that can be affected (met grid units)
               puffr2=(rconst*sye1)**2
c
c ---          Identify hills that may be affected by puff this step
               do ih=1,nhill
                  scanr2=puffr2+hillr2(ih)
                  call PFSCRN(xold,yold,xnew,ynew,hilldat(1,ih),
     &                        hilldat(2,ih),scanr2,d2,ldohill(ih))
               enddo
c
               ipin=ii
               qin=qunit
c ---          (Note: ttb is age at START step, but tmtotb has already
c ---           been reset to the age at the start of the NEXT step)
               ttb=tmtotb(ii)-tsamp
c
c ---          Set receptor elevation to stack-base to assure no CTADJ
c ---          modifications in call to PUFRECS here
               recht=elbase(ii)
c
c ---          Loop over complex terrain receptors
               do irin=1,nctrec
c
                  if(ldohill(ihill(irin))) then
c ---                Get receptor-specific puff information
                     xrm=xrct(irin)*dgrid
                     yrm=yrct(irin)*dgrid
                     zrm=0.0
                     call PUFRECS(lclip,xrm,yrm,zrm,jdstab,iru,
     &                            tsigv,tsigw,el,bvf,uavg,dpbl,
     &                            recht,ppcoef,lcalm,trec,frac,
     &                            syr,szr,zgrise,zpr,zrpole,
     &                            rfacsq,idrop)
c ---                PRIME downwash:  skip 'dropped' receptors in
c ---                                 cavity zone
                     if(idrop.EQ.0) then
c
c ---                Use receptor-specific puff ht in CTSG call
                     call CTSG(ldbhr,irin,ipin,qin,ws,wd,hlid,xb1,yb1,
     &                         zgrise,jdstab,elrect(irin),ihill(irin),
     &                         tsamp,ttb,szb1,sze1,syb1,sye1,szr,syr,
     &                         szmin,symin,frac,concct,cflat)
c
c ---                Scale concentrations for each species
                     ctemp=concct*tfract
                     do js=1,nspec
                        chict(irin,js)=chict(irin,js)+qavg(js)*ctemp
                     enddo
                     endif
                  endif
               enddo
c
            else
c ---          SLUGS:
c ---          Determine the number of plugs needed to simulate slug
c ---          (a plug is a puff-like segment of a slug)
               if(iage.EQ.0) then
c ---             Use slug information at end of step for fresh release
                  call SLG2PUF(xe1,xe2,ye1,ye2,sye1,sye2,
     &                         numpuff,qfac,xfac)
               else
c ---             Use slug information at beginning of step
                  call SLG2PUF(xb1,xb2,yb1,yb2,syb1,syb2,
     &                         numpuff,qfac,xfac)
               endif

c ---  Debug Writes
       if(ldbhr) then
          write(io6,*)
          write(io6,*)'SLG2PUF results...........'
          write(io6,*)'Slug #, numpuff     = ',ii,numpuff
          write(io6,*)'qfac,xfac           = ',qfac,xfac
          write(io6,*)
       endif

c
c ---          Loop over plugs from younger end to older end of slug
               qin=qfac*qunit
c ---          Skip first plug of a fresh slug since it has no timestep
               nfirst=1
               if(iage.EQ.0) nfirst=2
               do np=nfirst,numpuff
c
c ---             Assign slug properties to the plug
                  ipin=ii+np
                  fac=1.0-xfac*(np-1)
c ---             Set age at START of step, and duration of the step
c ---             (Note: tmtotb and tmtote are ages of the young[2] and
c ---              old[1] ends of the slug at the END of the step)
                  ttb=tmtote(ii)+fac*(tmtotb(ii)-tmtote(ii))-tsamp
                  if(ttb.LT.0.0) then
c ---                Must be a freshly released slug!
                     stepin=ttb+tsamp
                     ttb=0.0
                     tadj=stepin/tsamp
                  else
                     stepin=tsamp
                     tadj=1.0
                  endif
c ---             Set coordinates at start and end of step (meters)
                  xpbm=xb1+fac*(xb2-xb1)
                  ypbm=yb1+fac*(yb2-yb1)
                  xpem=xe1+fac*(xe2-xe1)
                  ypem=ye1+fac*(ye2-ye1)
c ---             Set coordinates at start and end of step (met grid)
                  xbmg=xpbm*dgridi
                  ybmg=ypbm*dgridi
                  xemg=xpem*dgridi
                  yemg=ypem*dgridi
c ---             Compute sigmas at start of step (meters)
                  call PLGRECS(lclip,fac,xpbm,ypbm,jdstab,iru,
     &                         tsigv,tsigw,el,bvf,uavg,dpbl,
     &                         frac,sy1in,sz1in,zgrise)
c ---             Compute sigmas at end of step (meters)
                  call PLGRECS(lclip,fac,xpem,ypem,jdstab,iru,
     &                         tsigv,tsigw,el,bvf,uavg,dpbl,
     &                         frac,sy2in,sz2in,zgrise)
c
c ---             Set plug radius (squared) at end of step to identify
c ---             receptors that are affected (met grid units)
                  puffr2=(rconst*sy2in)**2
c
c ---             Identify hills that may be affected by plug this step
                  do ih=1,nhill
                     scanr2=puffr2+hillr2(ih)
                     call PFSCRN(xbmg,ybmg,xemg,yemg,hilldat(1,ih),
     &                           hilldat(2,ih),scanr2,d2,ldohill(ih))
                  enddo
c
c ---  Debug Writes ---
       if(ldbhr) then
          write(io6,*)
          write(io6,*)'Plug Loop.................'
          write(io6,*)'Slug #, Plug #, Q   = ',ii,np,qin
          write(io6,*)'fac, tstart, tstep  = ',fac,ttb,stepin
       endif
c ---  Debug Writes ---
c
c ---             Loop over complex terrain receptors
                  do irin=1,nctrec
c ---                Screen out receptors that are too far away
                     if(ldohill(ihill(irin))) then
c ---                   Get receptor-specific plug information
                        xrm=xrct(irin)*dgrid
                        yrm=yrct(irin)*dgrid
                        call PLGRECS(lclip,fac,xrm,yrm,jdstab,iru,
     &                               tsigv,tsigw,el,bvf,uavg,dpbl,
     &                               frac,syr,szr,zgrise)
c
c ---                   Use receptor-specific puff ht in CTSG call
                        call CTSG(ldbhr,irin,ipin,qin,ws,wd,hlid,xpbm,
     &                            ypbm,zgrise,jdstab,elrect(irin),
     &                            ihill(irin),stepin,ttb,sz1in,sz2in,
     &                            sy1in,sy2in,szr,syr,szmin,symin,frac,
     &                            concct,cflat)
c
c ---                   Scale concentrations for each species
                        ctemp=concct*tfract*tadj
                        do js=1,nspec
                           chict(irin,js)=chict(irin,js)+qavg(js)*ctemp
                        enddo
                     endif
                  enddo
               enddo
            endif
         endif

c -----------------------------
c ---    Clean up for next step
c -----------------------------

c ---    Update puff code (may change in sampling routines)
         ipufcd(ii)=icode
c
c ---    Reset ZIMAX for next step (used for uniform distribution)
         zimax(ii)=amax1(zimax(ii),hlid)

c ---    Update the reflecting lid height from "last" step
         ziold(ii)=hlid

c ---    Check if new position is off computational grid (reset code)
         if(lpuff) then
c ---       Test center of PUFF:
            if(xnew.lt.xb.or.xnew.gt.xe.or.
     1         ynew.lt.yb.or.ynew.gt.ye)then
               ipufcd(ii)=99
c ---          Log mass dropped
               if(imbal.EQ.1) then
                  cbal='OUT'
                  if(LBCPUF) cbal='OBC'
                  call MBALSUM(cbal,qm(1,ii),
     &                         qu(1,ii),qm(1,ii),qu(1,ii))
               endif
               go to 801
            endif
         else
c ---       Test both ends of SLUG:
            if(xpe(ii).lt.xb.or.xpe(ii).gt.xe.or.
     1         ype(ii).lt.yb.or.ype(ii).gt.ye) then
c ---          Older end of slug is off the grid!
               if(xpb(ii).lt.xb.or.xpb(ii).gt.xe.or.
     1            ypb(ii).lt.yb.or.ypb(ii).gt.ye) then
c ---             Younger end is also off grid!
                  ipufcd(ii)=99
c ---             Log mass dropped
                  if(imbal.EQ.1) call MBALSUM('OUT',qm(1,ii),
     &                                     qu(1,ii),qm(1,ii),qu(1,ii))
                  go to 801
               endif
            endif
         endif

c ---    Check if a slug should be converted to a puff
         if(lslug) then
c ---       This is a SLUG!
            testsy=amin1(sye2,sye1)
            testd=sl2pf*sqrt((xe1-xe2)**2+(ye1-ye2)**2)
            if(testsy.GE.testd) then
c ---          Convert to PUFF!
               ipufcd(ii)=ipufcd(ii)-mfact0
               mfact0=0
               icode=ipufcd(ii)
               lpuff=.TRUE.
               lslug=.FALSE.
               zpb(ii)=0.5*(zpb(ii)+zpe(ii))
               sigyb(ii)=0.5*(sigyb(ii)+sigye(ii))
               sigzb(ii)=0.5*(sigzb(ii)+sigze(ii))
               xtotb(ii)=0.5*(xtotb(ii)+xtote(ii))
               tmtotb(ii)=0.5*(tmtotb(ii)+tmtote(ii))
               xpb(ii)=xnew
               ypb(ii)=ynew
c*****
      if(ldbhr)then
         write(io6,*)'SLUG converted to PUFF at end of KSAM= ',ksam
         write(io6,*)'     SIGYB, SIGZB        = ',sigyb(ii),sigzb(ii)
         write(io6,*)'     Slug Length * SL2PF = ',testd
      endif
c*****
            endif
         endif

c ---    End of TIBL sub-step loop
         if(LTIBL) then
            if(itibl.LT.ntibl) then
               xold=xnew
               yold=ynew
               goto 600
            else
c ---          Restore sampling step variables
               tsamp=tsamp0
               tsampi=1.0/tsamp
               tfract=tsamp*tavgi
            endif
         endif

         if(LSUBSAM) then
c ---       Check for incomplete sampling step
            if(tleft.GE.1.0 .AND. ksam.EQ.nsam) then
c ---          Last sampling step, so use up remaining sampling time
c ---          by taking another substep
               tsamp=tleft
               goto 500
            elseif(tleft.GT.tsamp) then
c ---          Time remaining in this step exceeds the time used in
c ---          the current sub-step, so take another substep.
               tsamp=tleft
               goto 500
            endif
c ---       Otherwise, continue on to the next sampling step, and add
c ---       whatever time is left to the reference sampling step time
         endif

800      continue

c ---    Puff (ii) has been sampled, and is still in domain
c ---    Add mass to total for end of period
         if(imbal.EQ.1) then
            cbal='TOT'
            if(LBCPUF) cbal='SBC'
            call MBALSUM(cbal,qm(1,ii),qu(1,ii),qm(1,ii),qu(1,ii))
         endif

801      continue

c ---    Close puff loop
900      CONTINUE

c ---  All puffs for this source have been sampled
c ---  Add contribution to Total CHIFLX arrays (mode 1)
       ichiflx=1
       if(ktype.NE.9) call TCHIFLX(ichiflx)
       if(msource.EQ.1) then
c ---     Perform source contribution output
cc ---     Add contribution to Total CHIFLX arrays (mode 1)
c          ichiflx=1
c          if(ktype.NE.9) call TCHIFLX(ichiflx)
c ---     Print results and/or store source contribution records on disk
          isrcmode=1
          if(ktype.NE.9) call OUTPUT(nn,isrcmode,ktype,ksource)
       endif

c ---  Close source loop
1100   continue

c --- Close source-type loop
1200  continue

c --- Swap Total CHIFLX arrays into standard CHIFLX arrays (mode 2)
      ichiflx=2
c      if(msource.EQ.1) call TCHIFLX(ichiflx)
      call TCHIFLX(ichiflx)

c --- Sum contribution from the boundary condition puff that passes
c --- nearest each receptor this sampling step
      if(nbc.GT.0) call SUMBC

c --- Do Fog-related processing on concentration and temperature excess
c --- fields and report results
      if(MFOG.GT.0) call FOGOUT
c
c --- Print results and/or store results on disk
      ktype=0
      ksource=1
      isrcmode=0
      call OUTPUT(nn,isrcmode,ktype,ksource)

c --- Write model run data for this period to restart file if selected
      if(mrestart.GE.2) then
         if(nn.EQ.iarlg) then
c ---       Restart data are written at close of run
            call RESTARTO
         elseif(nrespd.GT.0) then
c ---       Restart data are written every NRESPD periods
            if(MOD(nn,nrespd).EQ.0)call RESTARTO
         endif
      endif

c --- Increment date and time (except on last hour of run)
      if(nn.lt.iarlg)then
         call INCR(io6,nyr,njul,nhr,nhrinc)
         call GRDAY(io6,nyr,njul,nmo,nday)
         ndathr=nyr*100000+njul*100+nhr
c ---    Hour index (01-24: hour ending at 0000 is 24th hour)
         nhrind=nhr
         if(nhrind.EQ.0) nhrind=24
      endif
c
1000  continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine vmass(ii,mfact0,nspec,istab,dpbl,hlid,icode)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 040913                  VMASS
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Assigns vertical distribution of puff/slug for current
c               sampling step (puff code, mass)
c
c --- UPDATE
c --- V5.4-V5.741   040913  (DGS): MTILT option only: increase test for
c                                  well-mixed limit
c --- V5.0-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.0     980731  (DGS): recast 2-layer logic for Gaussian to
c                                  allow gradual fumigation
c --- V4.0-V5.0     971107  (DGS): replace ZFINAL puff/slug height array
c                                  with ZPB,ZPE arrays
c
c --- INPUTS:
c            II - integer - Current puff/slug index
c        MFACT0 - integer - ICODE offset between puffs and slugs
c                           (0 = PUFF;  10 = SLUG)
c         NSPEC - integer - Number of active species in run
c         ISTAB - integer - Stability class in surface layer
c          DPBL - real    - Depth of planetary boundary layer (current
c                           mixing height, m)
c         ICODE - integer - Code for vertical distribution
c                                1 = Puff within DPBL & Gaussian
c                                2 = Puff within DPBL & uniform
c                                3 = Puff above DPBL & Gaussian
c                                4 = Puff above DPBL & uniform
c                                5 = Puff currently above DPBL
c                                    (but previously below) & Gaussian
c                                6 = Puff currently DPBL layer
c                                    (but previously below) & uniform
c                               11 = Slug within DPBL & Gaussian
c                               12 = Slug within DPBL & uniform
c                               13 = Slug above DPBL & Gaussian
c                               14 = Slug above DPBL & uniform
c                               15 = Slug currently above DPBL
c                                    (but previously below) & Gaussian
c                               16 = Slug currently above DPBL
c                                    (but previously below) & uniform
c
c     Common block /FLAGS/ variables:
c            MTILT
c     Common block /PUFF/ variables:
c            ZIMAX(mxpuff), ZIOLD(mxpuff), SIGYB(mxpuff), SIGZB(mxpuff),
c            ZPB(mxpuff), QU(mxspec,mxpuff), QM(mxspec,mxpuff)
c     Common block /SLUG/ variables:
c            ZPE(mxpuff), SIGYE(mxpuff), SIGZE(mxpuff)
c
c     Parameters:
c            MXPUFF, MXSPEC, IO6
c
c --- OUTPUT:
c          HLID - real    - Modified mixing height: reflecting lid
c                           for vertical mass distribution (m)
c         ICODE - integer - Code for vertical distribution
c     Common block /PUFF/ variables:
c            QU(mxspec,mxpuff), QM(mxspec,mxpuff)
c
c
c --- VMASS called by: COMP
c --- VMASS calls:     none
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'flags.puf'
      include 'puff.puf'
      include 'slug.puf'
c
      logical lfatal
c
c --- Set unlimited mixing height (m)
      data ziunlm/1.0e04/
      data rtpiby2/1.2533141/, one/1.0/, half/0.5/, zero/0.0/

c --- Ratio of sigma-z to zi for well-mixed limit
      data szbyzi0/1.6/

c --- Factor to increase sz/zi0 for MTILT option
      data ftiltmix/2.0/

c --- Trap invalid puff codes here
      lfatal=.FALSE.
      if(icode.EQ.0) lfatal=.TRUE.
      if(icode.GE.7 .AND. icode.LE.10) lfatal=.TRUE.
      if(icode.GE.17 .AND. icode.LT.99) lfatal=.TRUE.
      if(LFATAL) then
         write(io6,*)'VMASS:  Invalid puff code = ',icode
         write(*,*)
         stop 'Halted in VMASS -- see list file.'
      endif

c --- Condition old mixing heights from last step
      qumass=zero
      do ipl=1,nspec
         qumass=qumass+qu(ipl,ii)
      enddo
      if(qumass.EQ.zero) then
c ---    No upper layer, so assign last lid height to max height to be
c ---    consistent with 1-layer structure
         zimax(ii)=ziold(ii)
      endif

c --- Set mean height of puff/slug
      if(mfact0.EQ.0) then
c ---    Puff
         zmean=zpb(ii)
      else
c ---    Slug
         zmean=half*(zpb(ii)+zpe(ii))
      endif

c --- Initialize lid height to PBL height
      hlid=dpbl

c --- If Gaussian, determine the top of equivalent uniform profile
c --- Ignore BID contribution to sigma-z
      if(mod(icode,2).EQ.1) then
         if(mfact0.EQ.0) then
c ---       Puff
            szmax=sigzb(ii)
            szmin=sigzb(ii)
            zmean=zpb(ii)
         else
c ---       Slug
            szmax=amax1(sigzb(ii),sigze(ii))
            szmin=amin1(sigzb(ii),sigze(ii))
            zmean=half*(zpb(ii)+zpe(ii))
         endif
c ---    Equivalent top of puff without influence of lid
         ptop0=zmean+rtpiby2*szmax
      endif

c --- Set the ratio of sigma-z to zi for well-mixed limit
      szbyzi=szbyzi0
      if(mtilt.GT.0) szbyzi=szbyzi0*ftiltmix
c
c ---------------------------------------------------
c --- Set vertical distribution for mixed puffs first
c ---------------------------------------------------
c
c --- CODE 4:  puff/slug above mixed layer since release, & Uniform
      if(mod(icode,10).EQ.4) then
c ---    Keep current icode until mixed layer reaches center of puff
c ---    then switch to icode=2,12 with no change to hlid, and shift
c ---    all mass to main layer
         if(hlid.GE.zmean) then
            icode=2+mfact0
            do ipl=1,nspec
               qm(ipl,ii)=qu(ipl,ii)+qm(ipl,ii)
               qu(ipl,ii)=zero
            enddo
         endif

c --- CODE 2,6:  puff/slug Uniform & within present/past mixed layer
      elseif(mod(icode,2).EQ.0) then
         if(hlid.GE.zimax(ii)) then
c ---       Current mixing height has exceeded ZIMAX, so there is a
c ---       1-layer structure:  transfer mass
            do ipl=1,nspec
               qm(ipl,ii)=qu(ipl,ii)+qm(ipl,ii)
               qu(ipl,ii)=zero
            enddo
            zimax(ii)=hlid
            ziold(ii)=hlid
            icode=2+mfact0
         else
c ---       Puff/slug mass is both above and below current mixed
c ---       layer. Calculate any transfer of mass between layers
c ---       Sign of the transfer is (+) if lower layer gains mass
c ---       from the upper layer, and (-) if upper layer gains mass.
            if(hlid.GE.ziold(ii)) then
c ---          1: lower layer growing into upper layer --
               dqfac=(hlid-ziold(ii))/(zimax(ii)-ziold(ii))
               if(dqfac.GT.one) dqfac=one
               do ipl=1,nspec
                  dq=qu(ipl,ii)*dqfac
                  qu(ipl,ii)=qu(ipl,ii)-dq
                  qm(ipl,ii)=qm(ipl,ii)+dq
               enddo
            else
c ---          2: upper layer growing into lower layer --
               qmtotal=zero
               do ipl=1,nspec
                  qmtotal=qmtotal+qm(ipl,ii)
               enddo
               if(qmtotal.EQ.zero) then
c ---             Special case of qm=0 (reset hlid to ziold)
                  hlid=ziold(ii)
               else
c ---             Mass in surface layer decreases as layer shrinks
                  dqfac=(hlid-ziold(ii))/ziold(ii)
                  if(dqfac.LT.-one) dqfac=-one
                  do ipl=1,nspec
                     dq=qm(ipl,ii)*dqfac
                     qu(ipl,ii)=qu(ipl,ii)-dq
                     qm(ipl,ii)=qm(ipl,ii)+dq
                  enddo
               endif
            endif
            ziold(ii)=hlid
            icode=6+mfact0
         endif
c
c -------------------------------------------------
c --- Set vertical distribution for Gaussian puffs
c -------------------------------------------------
c
c --- Treat STABLE surface layer case first
c
      elseif(istab.GE.5) then
c ---    Adjust puff code 3 case to code 1
         if(mod(icode,10).EQ.3) then
c ---       Place puff within unlimited stable layer
            icode=1+mfact0
            hlid=ziunlm
            zimax(ii)=ziunlm
            ziold(ii)=ziunlm
            do ipl=1,nspec
               qm(ipl,ii)=qu(ipl,ii)+qm(ipl,ii)
               qu(ipl,ii)=zero
            enddo
         else
c ---       Make the old mixing height current to either preserve
c ---       unlimited mixing, or to retain structure from last hour
            hlid=ziold(ii)
         endif
c ---    Test for well-mixed limit and reset if found
         if((szmin/hlid).GT.szbyzi) then
c ---       Puff is mixed: change code
            icode=icode+1
         endif

c --- Now treat cases with a non-stable surface layer
c
c --- CODE 1:  puff/slug Gaussian & within current mixed layer
      elseif(mod(icode,10).EQ.1) then
c ---    Determine reflecting lid height for Gaussian distribution.
         if(hlid.LT.zmean) then
c ---       Puff above surface layer, so persist last structure and
c ---       reset code to 5
            hlid=ziold(ii)
            icode=5+mfact0
         elseif(hlid.LT.ziold(ii)) then
c ---       Mixing lid is decreasing, but puff remains within surface
c ---       layer, so do not allow reflecting lid to decrease below
c ---       level at which puff first interacts strongly with the lid.
c ---       Test based on top-hat distribution
            ptop=AMIN1(ptop0,ziold(ii))
            hlid=AMAX1(hlid,ptop)
         endif
c ---    Reset zimax and ziold to the new lid height
         zimax(ii)=hlid
         ziold(ii)=hlid
c ---    Test for well-mixed limit
         if((szmin/hlid).GT.szbyzi) then
c ---       Puff is MIXED
            if(hlid.GT.dpbl) then
c ---          Create 2 layers: restore current mixing ht and
c ---          distribute mass above/below current mixing height
               icode=6+mfact0
               dqfac=(dpbl-hlid)/hlid
               if(dqfac.LT.-one) dqfac=-one
               do ipl=1,nspec
                  dq=qm(ipl,ii)*dqfac
                  qu(ipl,ii)=qu(ipl,ii)-dq
                  qm(ipl,ii)=qm(ipl,ii)+dq
               enddo
               ziold(ii)=dpbl
               hlid=dpbl
            else
c ---          There is only one layer
               icode=2+mfact0
            endif
         endif

c --- CODE 3:  puff/slug above mixed layer since release, & Gaussian
      elseif(mod(icode,10).EQ.3) then
c ---    Keep current values until mixed layer reaches centerline ht,
c ---    then pass mass below lid to qm, with reflections from hlid
         if(hlid.GE.zmean) then
c ---       Fraction of mass above lid is  0 < fup < 0.5
            if(hlid.GE.ptop0) then
c ---          All mass is in surface layer now --- One layer
               fup=zero
               icode=1+mfact0
               zimax(ii)=hlid
               ziold(ii)=hlid
            else
c ---          Two layers
               fup=0.5*(ptop0-hlid)/(ptop0-zmean)
               icode=5+mfact0
               zimax(ii)=ptop0
               ziold(ii)=hlid
            endif
c ---       Transfer mass from upper layer to surface layer
            do ipl=1,nspec
               qtot=qu(ipl,ii)+qm(ipl,ii)
               qu(ipl,ii)=fup*qtot
               qm(ipl,ii)=qtot-qu(ipl,ii)
            enddo
c ---       Test for well-mixed limit
            if((szmin/hlid).GT.szbyzi) icode=icode+1
         endif

c --- CODE 5:  puff/slug Gaussian with mass above & below mixing ht
      elseif(mod(icode,10).EQ.5) then
         if(hlid.GE.zimax(ii)) then
c ---       Current mixing height has exceeded ZIMAX, so there is a
c ---       1-layer structure again:  transfer mass
            do ipl=1,nspec
               qm(ipl,ii)=qu(ipl,ii)+qm(ipl,ii)
               qu(ipl,ii)=zero
            enddo
            icode=1+mfact0
            zimax(ii)=hlid
            ziold(ii)=hlid
c ---       Test for well-mixed limit
            if((szmin/hlid).GT.szbyzi) icode=icode+1
         elseif(hlid.LT.zmean) then
c ---       Surface layer is below the center of the puff; retain
c ---       old vertical structure
            hlid=ziold(ii)
c ---       Test for well-mixed limit in lower layer
            if((szmin/hlid).GT.szbyzi) icode=icode+1
         elseif(hlid.LT.ziold(ii)) then
c ---       Mixing lid is decreasing, but puff remains in surface layer;
c ---       do not allow reflecting lid to decrease in height below
c ---       level at which puff first interacts strongly with the lid.
c ---       Test based on top-hat distribution
            ptop=AMIN1(ptop0,ziold(ii))
            hlid=AMAX1(hlid,ptop)
c ---       Reset ziold to the new lid height, retain zimax (2 layers)
            ziold(ii)=hlid
c ---       Test for well-mixed limit in lower layer
            if((szmin/hlid).GT.szbyzi) icode=icode+1
         else
c ---       Mixing lid is rising, but remains less than ZIMAX
c ---       Allow growing layer to entrain mass that had partially
c ---       penetrated the top of the layer.
c ---       Sign of the transfer is (+) as lower layer gains mass
            dqfac=(hlid-ziold(ii))/(zimax(ii)-ziold(ii))
            if(dqfac.GT.one) dqfac=one
            do ipl=1,nspec
               if(qu(ipl,ii).GT.zero) then
                  dq=qu(ipl,ii)*dqfac
                  qu(ipl,ii)=qu(ipl,ii)-dq
                  qm(ipl,ii)=qm(ipl,ii)+dq
               endif
            enddo
c ---       Reset ZIOLD
            ziold(ii)=hlid
c ---       Test for well-mixed limit in lower layer
            if((szmin/hlid).GT.szbyzi) icode=icode+1
         endif
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine split(ldbhr,lresplit,nspec,xb,yb,xe,ye,imbal,
     &                 numsplty,numspltz)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 031017                  SPLIT
c                D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Create "new" puffs/slugs by splitting old puffs/slugs
c               in the vertical and old puffs in the horizontal when
c               appropriate for tracking effects of wind shear
c
c --- UPDATE
c --- V5.4-V5.72    031017  (DGS): ISRCTYP replaces IPUFID
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c                   000602  (DGS): add horizontal splitting
c
c --- INPUTS:
c         LDBHR - logical - Debug output produced (T/F)
c      LRESPLIT - logical - Reset ISPLIT to 1 to allow further splits
c                           in the vertical (T = Yes, F = No)
c         NSPEC - integer - Number of species
c         XB,YB - real    - SW corner of computational grid
c                           (met. grid units)
c         XE,YE - real    - NE corner of computational grid
c                           (met. grid units)
c         IMBAL - integer - Flag for tracking mass balance (1=tracked)
c
c     Common block /COMPARM/ variables:
c           NSPLIT, ROLDMAX, ZISPLIT,
c           NSPLITH, SYSPLITH, CNSPLITH(mxspec), SHSPLITH
c     Common Block /GRID/ variables:
c           DGRIDI, NZ, NZP1, ZFACE(mxnzp1)
c    Common block /METHR/ variables:
c           UMET(mxnx,mxny,mxnz), VMET(mxnx,mxny,mxnz)
c     Common block /PUFF/ variables:
c           NPUFFS, ZIOLD, ZIMAX, SIGYB
c           ISRCTYP, IPUFCD, XPB, YPB, QM, QU
c     Parameters:
c           MXPUFF, MXSPEC, MXNX, MXNY, MXNZ, MXNZP1, IO6
c
c --- OUTPUT:
c      NUMSPLTY - integer - Number of old puffs that are split in the
c                           horizontal
c                           (initial value set to 0 before call)
c      NUMSPLTZ - integer - Number of puffs that are split in the
c                           vertical
c                           (initial value set to 0 before call)
c
c --- SPLIT called by:  COMP
c --- SPLIT calls:      ROLLDN, SWAP, PUFFDZ, ADVWND, MBALSUM
c----------------------------------------------------------------------
c ---       Conditions for splitting a puff in the horizontal:
c               1)  Must be a puff (not slug)
c               2)  Must NOT be a 'boundary puff'
c               3)  Sigma-y (without BID) must exceed SYSPLITH
c               4)  Average concentration of at least one species must
c                   exceed the corresponding CNSPLITH
c ---       Conditions for splitting a puff in the vertical:
c               1)  Puff/Slug code 6/16
c               2)  ISPLIT=1 (puff/slug has not been split this cycle)
c               3)  Mix. ht last step is at least a min. value ZISPLIT
c               4)  Mix. ht last step is a "small" fraction of ZIMAX,
c                   no larger than ROLDMAX
c               5)  Puff has finite mass in surface layer (qm)
c ---------------------------------------------------------------------
c
      include 'params.puf'
      include 'comparm.puf'
      include 'grid.puf'
      include 'methr.puf'
      include 'puff.puf'

      logical ldbhr,lresplit,lpuff
      logical lconc, lshear
      real qqu(mxspec),qqm(mxspec)
      real u(mxnz),v(mxnz)
      real sin45(8),cos45(8)
      character*3 cbal

c --- Set puff logical to true (horizontal splitting)
      data lpuff/.TRUE./

c --- Set the center-puff mass augmentation factor Fc/n
c --- for a radial spread factor of fd=2.4 (scales new sigma-y)
c ---     expval=EXP(-0.5*fd*fd)
c ---     fcbyn=(0.25-expval)/(1.0-expval)
      data fd/2.4/, fcbyn/0.205395/

      data twopi/6.2831853/
      data cbal/'OUT'/

c --- Set array of sines and cosines in 45 degree steps for the
c --- shear calculations
      data sin45/ 0.0,  0.707107,  1.0,  0.707107,
     &            0.0, -0.707107, -1.0, -0.707107/
      data cos45/ 1.0,  0.707107,  0.0, -0.707107,
     &           -1.0, -0.707107,  0.0,  0.707107/

c --- Set angle and mass weight for radial array of split puffs
      rnm1=FLOAT(nsplith-1)
      angle=twopi/rnm1
      weight=(1.-fcbyn)/rnm1

c ------------------------------------------
c --- Address HORIZONTAL splitting first
c ------------------------------------------
c --- Make room for split puffs: If too many puffs are needed,
c --- remove puffs that are off the grid and "roll down" arrays
      np0=npuffs
      np=npuffs*(nsplith)
      if(np.GT.mxpuff) then
         call ROLLDN(np0)
c ---    Reset current number of puffs after roll-down
         np0=npuffs
      endif

c --- Loop over all existing puffs/slugs
c --------------------------------------
      do ii=1,np0
c ---  Must be an active PUFF (no slugs)
       if(ipufcd(ii).LT.11) then
c
c ---    Process only puffs released from explicit sources
c ---    (not boundary)
         if(isrctyp(ii).NE.9) then
c
c ---      Puff-size filter
           if(sigyb(ii).GT.sysplith) then
              lconc=.FALSE.
              if(ipufcd(ii).NE.4)then
c ---            (Code 4 is above mixed layer since release, and
c ---             uniform: do not split it)
c ---            Approximate puff concentration
c ---            Use 'neutral' form of PUFFDZ for puff top/bottom
c ---            (ilayer is a dummy here)
                 iistab=4
                 iilayer=3
                 call PUFFDZ(ii,ipufcd(ii),lpuff,iistab,iilayer,
     &                       zpb(ii),ziold(ii),ztop,zbot)
                 volinv=1.0/((ztop-zbot)*twopi*sigyb(ii)*sigyb(ii))
                 do is=1,nspec
                    if(((qm(is,ii)+qu(is,ii))*volinv).GT.
     &                                     cnsplith(is)) then
                       lconc=.TRUE.
                       goto 101
                    endif
                 enddo
              endif
c
c ---         Minimum concentration filter
101           if(lconc) then
c ---           Set ring radius for obtaining shear (met. grid units)
c ---           [Use the distance based on the split-puff sigmas]
c ---           Set sigma-y for the new puffs
                synew=0.5*sigyb(ii)
c ---           Set radial distance for puffs about original location
                rmet=fd*synew*dgridi
c ---           Get advection components at center
                ix=1.0+AMAX1(0.,xpb(ii))
                iy=1.0+AMAX1(0.,ypb(ii))
                ix=MIN(ix,nx)
                iy=MIN(iy,ny)
c ---           Transfer U,V to 1-D arrays
                do iz=1,nz
                   u(iz)=umet(ix,iy,iz)
                   v(iz)=vmet(ix,iy,iz)
                enddo
                call ADVWND(u,v,zface,nzp1,zbot,ztop,u0,v0)
c ---           Check enlargement rate against shear criterion
                lshear=.FALSE.
c ---           Search at 45-deg intervals starting at 0 (North)
                do iang=1,8
                   x=xpb(ii)+rmet*sin45(iang)
                   y=ypb(ii)+rmet*cos45(iang)
                   ix=1.0+AMAX1(0.,x)
                   iy=1.0+AMAX1(0.,y)
                   ix=MIN(ix,nx)
                   iy=MIN(iy,ny)
c ---              Transfer U,V to 1-D arrays
                   do iz=1,nz
                      u(iz)=umet(ix,iy,iz)
                      v(iz)=vmet(ix,iy,iz)
                   enddo
                   call ADVWND(u,v,zface,nzp1,zbot,ztop,ui,vi)
                   erate=sin45(iang)*(ui-u0)+cos45(iang)*(vi-v0)
                   if(erate.GT.shsplith) then
                      lshear=.TRUE.
                      goto 201
                   endif
                enddo
c
c ---           Minimum wind shear filter
201             if(lshear) then

c                 --------------------
c ---               Split this PUFF
c                 --------------------

c *******
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'SPLIT --- initial values for puff ',ii
         write(io6,*) ' sigyb,ipufcd,ziold,zimax = '
         write(io6,*) sigyb(ii),ipufcd(ii),ziold(ii),zimax(ii)
         write(io6,*) 'ztop,zbot (m) = ',ztop,zbot
         write(io6,*) '1/Volume (1/m^3) = ',volinv
         write(io6,*) 'q-upper = ',(qu(is,ii),is=1,nspec)
         write(io6,*) 'q-lower = ',(qm(is,ii),is=1,nspec)
         write(io6,*)
         write(io6,*) 'Split criteria: shear'
         write(io6,*) '   iang,ix,iy = ',iang,ix,iy
         write(io6,*) 'xpb,ypb,u0,v0 = ',xpb(ii),ypb(ii),u0,v0
         write(io6,*) ' xi, yi,ui,vi = ',x,y,ui,vi
         write(io6,*) '   erate(m/s) = ',erate
         write(io6,*)
      endif
c ********
c
c ---             Check to see if roll-down was adequate
                  if(npuffs+nsplith.gt.mxpuff)then
                     write(io6,*) 'FATAL ERROR in subr. SPLIT'
                     write(io6,*)'Too many puffs on grid ---'
                     write(io6,*)' NPUFFS (old puffs) = ',npuffs
                     write(io6,*)' NSPLITH = ',nsplith
                     write(io6,*)' MXPUFF = ',mxpuff
                     write(*,*)
                     stop 'Halted in SPLIT -- see list file.'
                  endif
c
c ---             Swap puff data from original puff to splits
                  do i=1,nsplith-1
                     j=npuffs+i
                     call SWAP(j,ii)
                  enddo

c ---             Loop over split puffs (first puff is at old location)
c ---             and alter the sigma-y, location, and masses
c ---             Center puff:
                  sigyb(ii)=synew
                  do is=1,nspec
                     qm(is,ii)=fcbyn*qm(is,ii)
                     qu(is,ii)=fcbyn*qu(is,ii)
                  enddo
c ---             Ring puffs:
                  do i=2,nsplith
c ---                Set puff index (jj)
                     jj=npuffs+i-1
c ---                Revise puff attributes
                     sigyb(jj)=synew
                     xpb(jj)=xpb(ii)+rmet*SIN(angle*(i-2))
                     ypb(jj)=ypb(ii)+rmet*COS(angle*(i-2))
                     do is=1,nspec
                        qm(is,jj)=weight*qm(is,jj)
                        qu(is,jj)=weight*qu(is,jj)
                     enddo
c ---                Check if new position is off computational
c ---                grid (reset code)
                     if(xpb(jj).lt.xb.or.xpb(jj).gt.xe.or.
     &                  ypb(jj).lt.yb.or.ypb(jj).gt.ye)then
                        ipufcd(jj)=99
c ---                   Log mass dropped
                        if(imbal.EQ.1) then
                           call MBALSUM(cbal,qm(1,jj),qu(1,jj),
     &                                  qm(1,jj),qu(1,jj))
                        endif
                     endif
                  enddo
c *******
      if(ldbhr) then
         do i=1,nsplith
            jj=npuffs+i-1
            if(jj.EQ.npuffs) jj=ii
         write(io6,*) 'SPLIT --- changed values for puff ',jj
         write(io6,*) 'xpb,ypb,sigyb = ',xpb(jj),ypb(jj),sigyb(jj)
         write(io6,*) 'q-upper = ',(qu(is,jj),is=1,nspec)
         write(io6,*) 'q-lower = ',(qm(is,jj),is=1,nspec)
         write(io6,*)
         enddo
      endif
c *******

c
c ---             Update total number of puffs
                  npuffs=npuffs+nsplith-1
c ---             Update number of old puffs that are split
                  numsplty=numsplty+1
c
                endif
              endif
            endif
         endif
       endif
      enddo

c ------------------------------------------
c --- Address VERTICAL splitting next
c ------------------------------------------
c --- Make room for split puffs: If too many puffs are needed,
c --- remove puffs that are off the grid and "roll down" arrays
      np0=npuffs
      np=npuffs*(nsplit)
      if(np.GT.mxpuff) then
         call ROLLDN(np0)
c ---    Reset current number of puffs after roll-down
         np0=npuffs
      endif

c --- Loop over all existing puffs/slugs
c --------------------------------------
      do ii=1,np0
       if(ipufcd(ii).LT.90) then
c
c ---    Reset ISPLIT flag to 1 if it is time to split all puffs again
         if(lresplit) isplit(ii)=1
c
c ---    Process only those puffs that are uniform in the vertical, and
c ---    above the mixing layer (but were once below)
         if(ipufcd(ii).EQ.6 .OR. ipufcd(ii).EQ.16) then
c
c ---       Check to see if roll-down was adequate
            if(npuffs+nsplit.gt.mxpuff)then
               write(io6,*) 'FATAL ERROR in subr. SPLIT'
               write(io6,*)'Too many puffs on grid for puff array -- ',
     1         'NPUFFS (old puffs) = ',npuffs,' NSPLIT = ',nsplit,
     2         ' MXPUFF = ',mxpuff
               write(*,*)
               stop 'Halted in SPLIT -- see list file.'
            endif
c
            if(isplit(ii).EQ.1 .AND. ziold(ii).GE.zisplit) then
               ratio=ziold(ii)/zimax(ii)
               qmtotal=0.0
               do is=1,nspec
                  qmtotal=qmtotal+qm(is,ii)
               enddo
               if(ratio.LE.roldmax .AND. qmtotal.GT.0.0) then
c                 ------------------------
c ---               Split this PUFF/SLUG
c                 ------------------------

c *******
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'SPLIT --- initial values for puff ',ii
         write(io6,*) ' isplit,ipufcd,ziold,zimax = '
         write(io6,*) isplit(ii),ipufcd(ii),ziold(ii),zimax(ii)
         write(io6,*) 'q-upper = ',(qu(is,ii),is=1,nspec)
         write(io6,*) 'q-lower = ',(qm(is,ii),is=1,nspec)
      endif
c ********
c
c ---             Reset split flag to indicate that a split has occurred
                  isplit(ii)=0
c
c ---             Swap puff/slug data from original puff to splits
                  do i=1,nsplit-1
                     j=npuffs+i
                     call SWAP(j,ii)
                  enddo
c
c ---             Set working variables
                  zlidu=zimax(ii)
                  zlidm=ziold(ii)
                  do is=1,nspec
                     qqu(is)=qu(is,ii)
                     qqm(is)=qm(is,ii)
                  enddo
                  dzui=1.0/(zlidu-zlidm)
                  dzmi=1.0/zlidm
                  zlo=zlidu
c
c ---             Loop over split puffs/slugs
                  do i=1,nsplit
c
c ---                Set puff/slug index (jj)
                     jj=npuffs+i-1
                     if(jj.EQ.npuffs) jj=ii
c
c ---                Set top and bottom of puff/slug slice
                     zhi=zlo
                     zlo=0.0
                     if(i.LT.nsplit) zlo=zhi*0.5
c
c --------------------------------------------
c ---                Set/revise puff/slug data
c --------------------------------------------
c
                     if(zlo.GE.zlidm) then
c ---                   Slice is from upper layer of original puff
                        dqfac=(zhi-zlo)*dzui
                        do is=1,nspec
                           qu(is,jj)=qqu(is)*dqfac
                           qm(is,jj)=0.0
                        enddo
                        zimax(jj)=zhi
                        ziold(jj)=zlo
c
                     elseif(zhi.LE.zlidm) then
c ---                   Slice is from lower layer of original puff
                        dqfac=(zhi-zlo)*dzmi
                        if(zlo.GT.0.0) then
                           do is=1,nspec
                              qu(is,jj)=qqm(is)*dqfac
                              qm(is,jj)=0.0
                           enddo
                           zimax(jj)=zhi
                           ziold(jj)=zlo
                        else
                           do is=1,nspec
                              qu(is,jj)=0.0
                              qm(is,jj)=qqm(is)*dqfac
                           enddo
c ---                      Change code from 6(16) to 2(12)
                           ipufcd(jj)=ipufcd(jj)-4
                           zimax(jj)=zhi
                           ziold(jj)=zhi
                        endif
c
                     elseif(zlo.EQ.0.0) then
c ---                   Lower layer is identical to lower layer of
c ---                   original puff, and upper layer is drawn from
c ---                   slice of upper layer of original puff
                        dqfac=(zhi-zlidm)*dzui
                        do is=1,nspec
                           qu(is,jj)=qqu(is)*dqfac
                        enddo
                        zimax(jj)=zhi
                        ziold(jj)=zlidm
c
                     else
c ---                   Slice straddles upper and lower layers of
c ---                   original puff
                        dqfacu=(zhi-zlidm)*dzui
                        dqfacm=(zlidm-zlo)*dzmi
                        do is=1,nspec
                           qu(is,jj)=qqu(is)*dqfacu+qqm(is)*dqfacm
                           qm(is,jj)=0.0
                        enddo
                        zimax(jj)=zhi
                        ziold(jj)=zlo
                     endif
c *******
      if(ldbhr) then
         write(io6,*) 'SPLIT --- changed values for puff ',jj
         write(io6,*) ' isplit,ipufcd,ziold,zimax = '
         write(io6,*) isplit(jj),ipufcd(jj),ziold(jj),zimax(jj)
         write(io6,*) 'q-upper = ',(qu(is,jj),is=1,nspec)
         write(io6,*) 'q-lower = ',(qm(is,jj),is=1,nspec)
      endif
c *******
                  enddo
c
c ---             Update total number of puffs
                  npuffs=npuffs+nsplit-1
c ---             Update number of old puffs that are split
                  numspltz=numspltz+1
c
               endif
            endif
         endif
       endif
      enddo
c
      return
      end
c----------------------------------------------------------------------
      subroutine initpuf(ndathr,nspec,dthr,ldbhr,em2dat,em4dat,
     1                   em3dat,em5dat,em5grp,metfm,newpuf)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                INITPUF
c                J. Scire, D. Strimaitis  SRC
c
c --- PURPOSE:  Invoke routines that initialize newly released
c               puff/slug variables from each source
c
c --- UPDATE
c --- V5.71-V5.8.4  130731  (EPA): Enforce MXMETSAV=2 (line source
c                                  tables are currently available only
c                                  for current and previous met period)
c --- V5.4-V5.71    030528  (DGS): Add MBCON=2 option for BCON file
c                   030528  (DGS): Require non-negative emissions from
c                                  variable emissions files
c --- V5.4-V5.4     000602_6(DGS): Fix call to RDEM3 (data records for
c                                  BAEMARB.DAT files) to use the file
c                                  unit number 'io' instead of 'io17',
c                                  which was removed in CALPUFF 5.4,
c                                  Level 000602.  File unit io17
c                                  (which is zero because it is not
c                                  defined) is not open so the call to
c                                  RDEM3 generates a runtime error
c                                  which halts the run.  This affects
c                                  previous CALPUFF versions starting
c                                  with version 5.4.
c --- V5.3-V5.4     000602  (DGS): relace VOLEM.DAT with VOLEMARB.DAT
c                   000602  (DGS): allow multiple PTEMARB, BAEMARB, and
c                                  VOLEMARB files
c                   000602  (DGS): add message to "stop"
c --- V5.2-V5.3     991222  (DGS): add Boundary Condition (BC) sources
c --- V5.0-V5.0     980807  (DGS): generalize VOLEM.DAT format
c                   980807  (DGS): pass METFM to subs
c                   980430  (DGS): correct BAEMARB emissions
c --- V4.0-V5.0     971107  (DGS): add LNEMARB.DAT data and subroutines
c                   971107  (DGS): remove volume flux from PT2 input
c                                  processing
c                   971107  (DGS): replace heat flux with effective rise
c                                  velocity and diameter in AR2 input
c                   971107  (DGS): add surface elevation to AR2 input
c                   971107  (DGS): add initial sigma-z to AR2 input
c                   971107  (DGS): re-order vertex array elements
c
c --- INPUTS:
c        NDATHR - integer - Julian day, hour for current time
c         NSPEC - integer - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c    EM2DAT(nse2+4,npt2) - real array - Time-varying PTEMARB source
c                                        data
c    EM4DAT(nse4+6,nvl2) - real array - Time-varying VOLEMARB source
c                                        data
c   EM3DAT(nse3+14,nar2) - real array - Time-varying BAEMARB source
c                                        data
c    EM5DAT(nse5+6,nln2) - real array - Time-varying LNEMARB source
c                                        data for lines
c      EM5GRP(7,mxlngrp) - real array - Time-varying LNEMARB source
c                                        data for groups of lines
c         METFM - integer - Meteorological data format
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW
c     Common block /FILNAM/ variables:
c           NPTDAT, NARDAT, NVOLDAT,
c           PTDAT, ARDAT, VOLDAT
c     Common block /FLAGS/ variables:
c           MSLUG, MBCON
c     Common block /GRID/ variables:
c           DGRID, DGRIDI, XORIG
c     Common block /PUFF/ variables:
c           NPUFFS
c     Common block /PT1/ variables:
c           NPT1
c     Common block /PT2/ variables:
c           MFPT2, NPT2, NSE2, IBEG2, IEND2
c     Common block /LN1/ variables:
c           NLINES
c     Common block /LN2/ variables:
c           NLN2, NSE5, IBEG5, IEND5
c     Common block /AR1/ variables:
c           NAR1
c     Common block /AR2/ variables:
c           NAR2, NSE3, IBEG3, IEND3
c     Common block /VOL1/ variables:
c           NVL1
c     Common block /VOL2/ variables:
c           NVL2, NSE4, IBEG4, IEND4, MFVL2
c     Common block /BCS/ variables:
c           NBC
c     Parameters:
c           MXPT1, MXPT2, MXLINES, MXLNGRP, MXMETSAV,
c           MXAREA, MXVOL, MXEMDAT, MXVERT,
c           IO6, IOPT2, IOAR2, IOVOL
c
c --- OUTPUT:
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c     Common block /AR2/ variables:
c            xar2grd(mxvertp1,mxarea),yar2grd(mxvertp1,mxarea),
c            area2(mxarea),refar2(mxarea),htar2(mxarea),tkar2(mxarea),
c            qhfar2(mxarea),qar2(mxspec,mxarea)
c
c
c
c --- INITPUF called by:  COMP
c --- INITPUF calls:      POINTS1,  RDEM2, POINTS2,
c                         LINES1 ,  RDEM5, LN2FILL, LINES2,
c                         AREAS1 ,  RDEM3,  AREAS2,
c                         VOLS   ,  RDEM4,
c                         BCS1   , RDEMBC, RDEMBC2
c----------------------------------------------------------------------
c
      include 'params.puf'

c --- Set number of variables before emissions in 'EMARB' arrays
c --- as parameters
      parameter(nvarpt=4, nvarba=14, nvarln=6, nvarvl=6)
c
      include 'comparm.puf'
      include 'filnam.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'puff.puf'
      include 'pt1.puf'
      include 'pt2.puf'
      include 'ln1.puf'
      include 'ln2.puf'
      include 'ar1.puf'
      include 'ar2.puf'
      include 'vol1.puf'
      include 'vol2.puf'
      include 'bcs.puf'
c
      logical ldbhr,problem,lqneg
c
c --- Time-variable emission arrays (declare full dimensions here and
c --- pass as argument to subr. so that dimensions can be adjusted)
      real em2dat(nse2+nvarpt,npt2)
      real em3dat(nse3+nvarba,nar2)
      real em4dat(nse4+nvarvl,nvl2)
      real em5dat(nse5+nvarln,nln2),em5grp(7,mxlngrp)
c
c --- Fix the number of vertices (sides) of area sources at 4
      real xvert(4),yvert(4)
c
c
c     (XMXLEN is the maximum length of a puff/slug in grid units)
      xtmp=dthr/(xmxlen*dgrid)
c
c --- Initialize current number of puffs equal to the number of
c --- old puffs, and set the number of new puffs to zero;
c --- both of these will be updated within subsequent calls
      np=npuffs
      newpuf=0
c
c --- MFACT is 0 (puffs released) or 10 (slugs released)
      mfact=10*mslug
c
c --- Set logical for detecting problem with sources
      problem=.FALSE.
c
c*****
      if(ldbhr)then
         write(io6,202)mfact,xtmp
202      format(/1x,'LDB output from SUBR. INITPUF'/5x,'MFACT: ',i2,
     1   2x,'XTMP: ',f10.5)
      endif
c*****
c
c --- Enforce MXMETSAV=2 (set in parameter file) regardless of source
c --- types in current run
      if(mxmetsav.NE.2) then
        write(io6,*)
        write(io6,*)'ERROR -- MXMETSAV must be set to 2 in PARAMS.PUF'
        write(io6,*)
        stop 'Halted in INITPUF -- See list file'
      endif
c
c ---------------------------------------------------
c --- Loop over point sources with CONSTANT emissions
c ---------------------------------------------------
      if(npt1.gt.0) then
         do i=1,npt1
            call POINTS1(i,nspec,dthr,xtmp,ldbhr,mfact,metfm,np,
     &                   newpuf,problem)
         enddo
      endif
c
c ---------------------------------------------------
c --- Loop over point sources with VARIABLE emissions
c ---------------------------------------------------
      if(npt2.gt.0) then
c ---    Update variable emissions from PTEMARB files
c ---    Loop over files to check/update all sources
         do ip=1,nptdat
            if(ndathr.lt.ibeg2(ip))then
               write(io6,*)
               write(io6,*)'ERROR -- PTEMARB date/time exceeds current'
               write(io6,*)'      -- current date/time :',ndathr
               write(io6,*)'      -- PTEMARB date/time :',ibeg2(ip)
               write(io6,*)'      -- PTEMARB file      :',ptdat(ip)
               write(*,*)
               stop 'Halted in INITPUFF -- see list file.'
            elseif(ndathr.gt.iend2(ip))then
               io=iopt2+ip-1
c ---          Read until current model date/time is reached
301            continue
               call RDEM2(io,mfpt2(ip),npt2,nse2,cid2,ibsrc2(ip),
     &                    iesrc2(ip),ivrs2(ip),ldbhr,io6,ibeg2(ip),
     &                    iend2(ip),em2dat)
               if(ndathr.gt.iend2(ip))go to 301
               if(ndathr.lt.ibeg2(ip))then
                  write(io6,*)
                  write(io6,*)
     &                 'ERROR -- PTEMARB date/time exceeds current'
                  write(io6,*)'      -- current date/time :',ndathr
                  write(io6,*)'      -- PTEMARB date/time :',ibeg2(ip)
                  write(io6,*)'      -- PTEMARB file      :',ptdat(ip)
                  write(*,*)
                  stop 'Halted in INITPUFF -- see list file.'
               endif
c ---          Swap variable emissions data (em2dat) into /pt2/ arrays
               do i=ibsrc2(ip),iesrc2(ip)
                  tstak2(i)=em2dat(1,i)
                  exitw2(i)=em2dat(2,i)
                  syipt2(i)=em2dat(3,i)
                  szipt2(i)=em2dat(4,i)
                  lqneg=.FALSE.
                  do is=1,nse2
                     iq=is+nvarpt
                     qstak2(ixrem2(is),i)=em2dat(iq,i)
                     if(qstak2(ixrem2(is),i).LT.0.0) lqneg=.TRUE.
                  enddo
c ---             Report problem if any emissions are negative
                  if(lqneg) then
                     write(io6,*)
                     write(io6,*)'*********  FATAL  ***********'
                     write(io6,*)'ERROR in subr. INITPUF -- Invalid ',
     1               'emission rate  (must NOT be negative)'
                     write(io6,*)' -- PTEMARB Source = ',i
                     problem=.TRUE.
                  endif
               enddo
            endif
         enddo

         do i=1,npt2
            call POINTS2(i,nspec,dthr,xtmp,ldbhr,mfact,metfm,np,
     &                   newpuf,problem)
         enddo
      endif
c
c --------------------------------------------------------------
c --- Process 1 group of line sources with CONSTANT emissions
c --------------------------------------------------------------
      if(nlines.gt.0) then
         call LINES1(nspec,dthr,xtmp,ldbhr,mfact,metfm,np,
     &               newpuf,problem)
      endif
c
c --------------------------------------------------------------------
c --- Process multiple groups of line sources with VARIABLE parameters
c --------------------------------------------------------------------
c
      if(nln2.gt.0) then
c ---    Check if it is time to update the variable parameters
         if(ndathr.lt.ibeg5)then
            write(io6,*)
            write(io6,*)'ERROR -- LNEMARB date/time exceeds current'
            write(io6,*)'      -- current date/time :',ndathr
            write(io6,*)'      -- LNEMARB date/time :',ibeg5
            write(*,*)
            stop 'Halted in INITPUFF -- see list file.'
         else if(ndathr.gt.iend5)then
c ---       Read until current model date/time is reached
511         continue
            call RDEM5(io19,mxlngrp,nln2,nse5,cid5,ldbhr,io6,
     &                 ibeg5,iend5,lngrp,em5dat,em5grp)
            if(ndathr.gt.iend5)go to 511
            if(ndathr.lt.ibeg5)then
               write(io6,*)
               write(io6,*)'ERROR -- LNEMARB date/time exceeds current'
               write(io6,*)'      -- current date/time :',ndathr
               write(io6,*)'      -- LNEMARB date/time :',ibeg5
               write(*,*)
               stop 'Halted in INITPUFF -- see list file.'
            endif
c ---       Swap variable emissions data (em5grp,em5dat) into /ln2/
            call LN2FILL(lngrp,nln2,em5grp,em5dat,nvarln,problem)
         endif
         do ig=1,lngrp
            call LINES2(ig,nspec,dthr,xtmp,ldbhr,mfact,metfm,np,
     &                  newpuf,problem)
         enddo
      endif
c
c ------------------------------------------------------------
c --- Loop over polygon area sources with CONSTANT emissions
c ------------------------------------------------------------
      if(nar1.gt.0) then
         do i=1,nar1
            call AREAS1(i,nspec,dthr,xtmp,ldbhr,mfact,np,
     &                  newpuf,problem)
         enddo
      endif
c
c ----------------------------------------------------------
c --- Loop over polygon area sources with VARIABLE emissions
c ----------------------------------------------------------
      if(nar2.gt.0) then
c ---    Update variable emissions from BAEMARB files
c ---    Loop over files to check/update all sources
         do ia=1,nardat
            if(ndathr.lt.ibeg3(ia))then
               write(io6,*)
               write(io6,*)'ERROR -- BAEMARB date/time exceeds current'
               write(io6,*)'      -- current date/time :',ndathr
               write(io6,*)'      -- BAEMARB date/time :',ibeg3(ia)
               write(io6,*)'      -- BAEMARB file      :',ardat(ia)
               write(*,*)
               stop 'Halted in INITPUFF -- see list file.'
            elseif(ndathr.gt.iend3(ia))then
               io=ioar2+ia-1
c ---          Read until current model date/time is reached
306            continue
               call RDEM3(io,nar2,nse3,cid3,ibsrc3(ia),iesrc3(ia),
     &                    ldbhr,io6,ibeg3(ia),iend3(ia),em3dat)
               if(ndathr.gt.iend3(ia))go to 306
               if(ndathr.lt.ibeg3(ia))then
                  write(io6,*)
                  write(io6,*)
     &                     'ERROR -- BAEMARB date/time exceeds current'
                  write(io6,*)'      -- current date/time :',ndathr
                  write(io6,*)'      -- BAEMARB date/time :',ibeg3(ia)
                  write(io6,*)'      -- BAEMARB file      :',ardat(ia)
                  write(*,*)
                  stop 'Halted in INITPUFF -- see list file.'
               endif
c ---          Swap location & emissions data (em3dat) into /ar2/
               do i=ibsrc3(ia),iesrc3(ia)
c
c ---             Compute & store relative vertex coordinates;
c ---             accumulate sums for computing the mean location of
c ---             the area source
                  sumx=0.
                  sumy=0.
c ---             Explicitly allow ONLY 4-sided shapes!
                  nvert2(i)=4
                  do iv=1,nvert2(i)
                     xvert(iv)=em3dat(iv,i)
                     yvert(iv)=em3dat(iv+nvert2(i),i)
                     xar2grd(iv,i)=(1000.*xvert(iv)-xorig)*dgridi
                     yar2grd(iv,i)=(1000.*yvert(iv)-yorig)*dgridi
                     sumx=sumx+xar2grd(iv,i)
                     sumy=sumy+yar2grd(iv,i)
                  enddo
c ---             Mean location of source
                  xar2grd(nvert2(i)+1,i)=sumx/FLOAT(nvert2(i))
                  yar2grd(nvert2(i)+1,i)=sumy/FLOAT(nvert2(i))

c ---             Area of 4-sided area source in m^2
                  call QUADAREA(xvert,yvert,area2(i))
c
c ---             Height, surface elevation (m)
                  htar2(i)=em3dat(9,i)
                  elar2(i)=em3dat(10,i)

c ---             Effective temperature (K), velocity (m/s) and radius (m)
c ---             for rise calculation
                  tkar2(i)=em3dat(11,i)
                  wefar2(i)=em3dat(12,i)
                  refar2(i)=em3dat(13,i)

c ---             Initial sigma-z (m)
                  sz0ar2(i)=em3dat(14,i)

c ---             Emissions (g/s)
                  if(baemunit(i).EQ.'g/s') then
                     fqunit=1.00
                  elseif(baemunit(i).EQ.'g/m2/s') then
                     fqunit=area2(i)
                  else
                     write(io6,*)
                     write(io6,*)
     &                     'ERROR -- Invalid units in BAEMARB.DAT'
                     write(io6,*)'      -- Expected g/s or g/m2/s'
                     write(io6,*)'      -- Found: ',baemunit(i)
                     write(*,*)
                     stop 'Halted in INITPUFF -- see list file.'
                  endif
                  lqneg=.FALSE.
                  do is=1,nse3
                     iq=is+nvarba
                     qar2(ixrem3(is),i)=fqunit*em3dat(iq,i)
                     if(qar2(ixrem3(is),i).LT.0.0) lqneg=.TRUE.
                  enddo
c ---             Report problem if any emissions are negative
                  if(lqneg) then
                     write(io6,*)
                     write(io6,*)'ERROR in subr. INITPUF -- Invalid ',
     1               'emission rate  (must NOT be negative)'
                     write(io6,*)' -- AREMARB Source = ',i
                     problem=.TRUE.
                  endif
               enddo
            endif
         enddo

         do i=1,nar2
            call AREAS2(i,nspec,dthr,xtmp,ldbhr,mfact,metfm,np,
     &                  newpuf,problem)
         enddo
      endif
c
c ------------------------------------------------------------
c --- Loop over volume sources with CONSTANT emissions
c ------------------------------------------------------------
      if(nvl1.gt.0) then
         mvolume=1
         do i=1,nvl1
            call VOLS(mvolume,i,nspec,dthr,xtmp,ldbhr,mfact,np,
     &                 newpuf,problem)
         enddo
      endif
c
c ------------------------------------------------------------
c --- Loop over volume sources with VARIABLE emissions
c ------------------------------------------------------------
c
      if(nvl2.gt.0) then
         mvolume=2
c ---    Update variable emissions from VOLEMARB files
c ---    Loop over files to check/update all sources
         do iv=1,nvoldat
            if(ndathr.lt.ibeg4(iv))then
               write(io6,*)
               write(io6,*)
     &                   'ERROR -- VOLEMARB date/time exceeds current'
               write(io6,*)'      -- current date/time :',ndathr
               write(io6,*)'      -- VOLEMARB date/time:',ibeg4(iv)
               write(io6,*)'      -- VOLEMARB file     :',voldat(iv)
               write(*,*)
               stop 'Halted in INITPUFF -- see list file.'
            elseif(ndathr.gt.iend4(iv))then
               io=iovol+iv-1
c ---          Read until current model date/time is reached
311            continue
               call RDEM4(io,mfvl2(iv),nvl2,nse4,cid4,ibsrc4(iv),
     &                    iesrc4(iv),ldbhr,io6,ibeg4(iv),iend4(iv),
     &                    em4dat)
               if(ndathr.gt.iend4(iv))go to 311
               if(ndathr.lt.ibeg4(iv))then
                 write(io6,*)
                 write(io6,*)
     &                    'ERROR -- VOLEMARB date/time exceeds current'
                 write(io6,*)'      -- current date/time :',ndathr
                 write(io6,*)'      -- VOLEMARB date/time:',ibeg4(iv)
                 write(io6,*)'      -- VOLEMARB file     :',voldat(iv)
                 write(*,*)
                 stop 'Halted in INITPUFF -- see list file.'
               endif
c ---          Swap variable emissions data (em4dat) into /vol2/ arrays
               do i=ibsrc4(iv),iesrc4(iv)
c ---             Compute relative grid coordinates
                  xvl2grd(i)=(1000.*em4dat(1,i)-xorig)*dgridi
                  yvl2grd(i)=(1000.*em4dat(2,i)-yorig)*dgridi
                  htvl2(i)=em4dat(3,i)
                  elvl2(i)=em4dat(4,i)
                  sy0vl2(i)=em4dat(5,i)
                  sz0vl2(i)=em4dat(6,i)
                  lqneg=.FALSE.
                  do is=1,nse4
                     iq=is+nvarvl
                     qvl2(ixrem4(is),i)=em4dat(iq,i)
                     if(qvl2(ixrem4(is),i).LT.0.0) lqneg=.TRUE.
                  enddo
c ---             Report problem if any emissions are negative
                  if(lqneg) then
                     write(io6,*)
                     write(io6,*)'ERROR in subr. INITPUF -- Invalid ',
     1               'emission rate  (must NOT be negative)'
                     write(io6,*)' -- VOLEMARB Source = ',i
                     problem=.TRUE.
                  endif
               enddo
            endif
         enddo

         do i=1,nvl2
            call VOLS(mvolume,i,nspec,dthr,xtmp,ldbhr,mfact,np,
     &                 newpuf,problem)
         enddo
      endif
c
c ----------------------------------------------------------------
c --- Loop over all boundary condition sources
c ----------------------------------------------------------------
      if(nbc.gt.0) then
         if(ntypebc2.GT.0) then
c ---       Check if it is time to update variable concentrations
            if(ndathr.lt.ibegbc)then
               write(io6,*)
               write(io6,*)'ERROR -- BCON date/time exceeds current'
               write(io6,*)'      -- current date/time :',ndathr
               write(io6,*)'      -- BCON date/time    :',ibegbc
               write(*,*)
               problem=.true.
            else if(ndathr.gt.iendbc)then
c ---          Obtain BCON data for current model date/time
               if(mbcon.EQ.1) then
                  call RDEMBC(ldbhr,ndathr)
               elseif(mbcon.EQ.2) then
                  call RDEMBC2(ldbhr,ndathr)
               else
                 write(io6,*)
                 write(io6,*)'ERROR -- BCON option is invalid'
                 write(io6,*)'      -- expected : 1 or 2'
                 write(io6,*)'      -- MBCON    :',mbcon
                 write(*,*)
                 problem=.true.
               endif
            endif
         endif
c ---    Loop over all boundary segments and define new puffs
         do i=1,nbc
            call BCS1(i,nspec,dthr,ldbhr,np,newpuf,problem)
         enddo
      endif
c
c
      if(PROBLEM) then
         write(*,*)
         stop 'Halted in INITPUFF -- see list file.'
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine areas1(i,nspec,dthr,xtmp1,ldbhr,mfact,np,
     &                  newpuf,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 AREAS1
c                J. Scire, D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Initialize newly released puff/slug variables for
c               polygon AREA SOURCES with constant emissions.
c
c --- UPDATE
c --- V5.831-V5.8.4 130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c --- V5.82-V5.8.4  130731  (EPA): Place rise tables in DA file
c --- V5.72-V5.8.4  130731  (EPA): Change J to I in debug output
c --- V5.7-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.4-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c --- V5.1-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.1     990729  (DGS): enforce minimum sigma-y at source
c --- V5.0-V5.0     980918  (DGS): initial sigma-y is zero
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V5.0-V5.0     980304  (DGS): drop any new puffs if emissions = 0
c --- V5.0-V5.0     980304  (DGS): place source sigmas in SY0,SZ0
c --- V4.0-V5.0     971107  (DGS): add variable emissions factor call
c                                  to function VEMFAC
c                   971107  (DGS): reverse arguments of vertex arrays
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c
c --- INPUTS:
c             I - integer - Area source index
c         NSPEC - real    - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         XTMP1 - real    -
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c            NP - integer - Index of last puff/slug initialized
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW, SYMIN, SZMIN, WSCALM, PLX0
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MHFTSZ
c     Common block /GRID/ variables:
c           DGRID, IBCOMP, IECOMP, JBCOMP, JECOMP
c     Common block /METHR/ variables:
c           PLEXP
c     Common block /METHD/ variables:
c           I2DMET
c     Common block /PUFF/ variables:
c           NPUFFS
c     Common block /AR1/ variables:
c           XAR1GRD(mxvertp1,mxarea),YAR1GRD(mxvertp1,mxarea),
c           HTAR1(mxarea),ELAR1(mxarea),SZ0AR1(mxarea),NVERT1(mxarea),
c           QAR1(mxspec,mxarea),NEWAR1(mxarea),
c           ivar1(mxspec,mxarea),iq12ar1(mxspec,mxarea)
c     Parameters:
c           MXNX, MXNY, MXNZ, MXNZP1, MXSPEC, MXAREA, IO6
c
c --- OUTPUT:
c            NP - integer - UPDATED index of last puff/slug initialized
c        NEWPUF - integer - UPDATED number of new puffs/slugs released
c                           during the current time step
c       PROBLEM - logical - Set true if fatal problem encountered
c
c     Common block /AR1/ variables:
c           NEWAR1(mxarea)
c     Common block /PUFF/ variables:
c           all variables in common block
c     Common block /SLUG/ variables:
c           all variables in common block
c
c --- AREAS1 called by:  INITPUF
c --- AREAS1 calls:      RLSMET, ROLLDN, SYAREA, SWAP, INJECT, VEMFAC,
c                        ZEROTAB, SRCTABOUT
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      include 'comparm.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'methr.puf'
      include 'ar1.puf'
      include 'puff.puf'
      include 'slug.puf'
c frr (09/01)
      include 'methd.puf'
c
      real q(mxspec)
      logical ldbhr,problem
c
c ***
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'AREAS1:  Source Number    ',i
      endif
c ***
c
c --- Determine the met. grid point closest to the source
      ixs=1.0+xar1grd(nvert1(i)+1,i)
      iys=1.0+yar1grd(nvert1(i)+1,i)
c
c --- Source off the computational grid -- write a FATAL message
      if(ixs.lt.ibcomp.or.ixs.gt.iecomp.or.iys.lt.jbcomp.or.iys.gt.
     1   jecomp)then
         write(io6,20)i,ixs,iys
20       format(/1x,'FATAL -- an area source with constant emissions ',
     1   'is off the computational grid'/1x,'source no. (i) = ',i6,2x,
     2   'nearest grid point (ixs,iys) = (',i5,',',i5,')')
         problem=.TRUE.
         return
      endif
c
c --- Extract release height wind speed & other met. variables
      htrel=htar1(i)
      call rlsmet(ldbhr,ixs,iys,htrel,mfact,
     &            mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &            ustr,wstr,tsigv,tsigw,iru,issta,sqrts,idopty,idoptz)
c
c frr (09/01) new calmet format (2D temp)
      if(i2dmet.EQ.1) then
         temp=temp2d(ixs,iys)
      elseif(i2dmet.EQ.0) then
         temp=tempss(issta)
      else
         write(*,*)'Subr. AREAS1:  Invalid I2DMET = ',i2dmet
         stop
      endif

c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif
c --- Swap emission rate for source 'i' into 1D array and scale
      qtot=0.0
      do is=1,nspec
         q(is)=qar1(is,i)*VEMFAC(ldbhr,ivar1(is,i),iq12ar1(is,i),
     &                           temp,ws,istab)
         qtot=qtot+q(is)
      enddo
c --- Return without generating new puffs if all species have zero
c --- mass in puff
      if(qtot.EQ.0.0) then
c ***
         if(ldbhr) then
            write(io6,*)
            write(io6,*) 'No emissions this step from Source ',i
            write(io6,*)
         endif
c ***
         return
      endif
c
c --- Initialize source tabulation specifications to zero
      call ZEROTAB
c
c --- Compute the number of puffs/slugs released this hour
c --- from this source
      npnew=ws*xtmp1+1
      npnew=max0(npnew,1)
      npnew=min0(npnew,mxnew)
      newar1(i)=npnew
      newpuf=newpuf+npnew
c --- If puff arrays are full, remove puffs that are off the grid
c --- and "roll down" arrays to make room for new puffs
c --- (this also applies to the DA file of tabulated arrays)
      if(npuffs+newpuf.gt.mxpuff) call rolldn(np)
c
c --- Check to see if roll-down was adequate
      if(npuffs+newpuf.gt.mxpuff)then
         write(io6,*) ' ERROR in subr. AREAS1'
         write(io6,*)'Too many puffs on grid for array dimensions -- ',
     1   'NPUFFS (old puffs) = ',npuffs,' NEWPUF = ',newpuf,
     2   ' MXPUFF = ',mxpuff
         write(*,*)
         stop 'Halted in AREAS1 -- see list file.'
      endif
c
c --- DT is the time (sec) over which each puff is emitted
      dt=dthr/float(npnew)
c
c --- Set variance associated with buoyancy-enhanced growth @ final rise
      xf=0.0
      rise=0.0
      bidsq=0.0
c --- Set downwash flag to zero (no building downwash)
      idw=0
c --- Set final plume height
      heff=htar1(i)
c --- Set sigma y, sigma z at the source
      szsrc=amax1(szmin,sz0ar1(i))
      call SYAREA(xar1grd(1,i),yar1grd(1,i),nvert1(i),dgrid,flow,ldbhr,
     &            sysrc)
      sysrc=amax1(symin,sysrc)

c******
      if(ldbhr)then
         write(io6,204)i,ilayer,ixs,iys,ws,istab,dpbl,issta,npnew,
     1    newpuf,dt
204      format(5x,'IS: ',i5,2x,'ILAYER: ',i3,2x,'IXS: ',i4,2x,
     1    'IYS: ',i4,2x,'WS: ',f5.1,2x,'ISTAB: ',i1,2x,'DPBL: ',
     2    f7.1,2x,'ISSTA: ',i4,2x,'NPNEW: ',i4,2x,'NEWPUF: ',i5/
     3    5x,'DT: ',f7.2)
c
         write(io6,210)idw,heff,rise,xf,sysrc,szsrc
210      format(5x,'IDW: ',i5,2x,'HEFF: ',f8.2,2x,'RISE : ',f8.2,2x,
     1    'XF : ',f8.2,2x,'SYSRC: ',f8.2,2x,'SZSRC: ',f8.2)
c
         write(io6,208)i,np,iru,dt,sqrts
208      format(5x,'I: ',i5,2x,'NP: ',i5,2x,
     1    'IRU: ',i2,2x,'DT: ',f7.2,2x,'SQRTS: ',f7.3)
      endif
c*****
c ----------------------------------------------------------
c ---    Initialize current hour's new puffs for this source
c ----------------------------------------------------------
         do 50 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xar1grd(nvert1(i)+1,i)
         ypb(np)=yar1grd(nvert1(i)+1,i)
         zitibl(np)=-1.0
         elbase(np)=elar1(i)
         sigyb(np)=symin
         sigzb(np)=szsrc
c ---    Final plume rise results
         zfinal(np)=heff
         zpb(np)=heff
         zpe(np)=heff
         xfinal(np)=xf
         bidfnl(np)=bidsq
         isplit(np)=1
c ---    Time-of-release data
         ht0(np)=htar1(i)
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations
         idw0(np)=idw
         heff20(np)=heff
         sy0(np)=sysrc
         sz0(np)=szsrc

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from this source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =3 for const. area sources)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=3
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    Note that "oldest" end of slug is at the source, as is the
c ---    "newest end; oldest end moves away and grows during the step,
c ---    while newest end remains fixed in size at the source.
c
         if(mslug.EQ.1 .AND. mfact0.GT.0) then
c ---       Set coordinates of oldest end of slug (in met. grid units)
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c -------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c -------------------------------------------------------------------
c ---    Set partial penetration variables to null values
         fmix=1.0
         hmax=dpbl
         call INJECT(np,nspec,dt,mfact0,q,heff,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer NULL tabulated arrays record to DA file
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

50    continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine areas2(i,nspec,dthr,xtmp1,ldbhr,mfact,metfm,np,
     &                  newpuf,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 AREAS2
c                J. Scire, D. Strimaitis,  SRC
c
c --- PURPOSE:  Initialize newly released puff/slug variables for
c               BUOYANT polygon AREA SOURCES.
c
c --- UPDATE
c --- V5.831-V5.8.4 130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c --- V5.82-V5.8.4  130731  (EPA): Place rise tables in DA file
c --- V5.74-V5.8.4  130731  (EPA): Change J to I in debug output
c --- V5.72-V5.74   040715  (DGS): add METFM=5 (AERMET)
c --- V5.7-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.4-V5.7     030402  (DGS): add MPRIME, SYSRC, SZSRC, HTR to
c                                  NUMRISE call (not used here)
c --- V5.1-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.1     990729  (DGS): enforce minimum sigma-y at source
c --- V5.0-V5.0     980918  (DGS): initial sigma-y is zero
c --- V5.0-V5.0     980807  (DGS): use final rise CALMET/PROFILE winds
c                                  to set release step
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V5.0-V5.0     980430  (DGS): assign PROBLEM (compiler warning)
c --- V5.0-V5.0     980304  (DGS): place source sigmas in SY0,SZ0
c --- V4.0-V5.0     971107  (DGS): remove heat flux from AR2 input
c                                  processing
c                   971107  (DGS): add ground elevation and initial
c                                  sigma-z to AR2 input
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c
c --- INPUTS:
c             I - integer - Area source index
c         NSPEC - real    - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         XTMP1 - real    -
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c         METFM - integer - Meteorological data format
c            NP - integer - Index of last puff/slug initialized
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW, SYMIN, SZMIN, WSCALM, PLX0
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MHFTSZ
c     Common block /GRID/ variables:
c           DGRID, IBCOMP, IECOMP, JBCOMP, JECOMP
c     Common block /METHD/ variables:
c           ELEV(mxnx,mxny)
c     Common block /METHR/ variables:
c           PLEXP
c     Common block /PUFF/ variables:
c           NPUFFS
c     Common block /AR2/ variables:
c           XAR2GRD(mxvertp1,mxarea),YAR2GRD(mxvertp1,mxarea),
c           HTAR2(mxarea),TKAR2(mxarea),ELAR2(mxarea),REFAR2(mxarea),
c           REFAR2(mxarea),WEFAR2(mxarea),SZ0AR2(mxarea),
c           QAR2(mxspec,mxarea),AREA2(mxarea),
c           NVERT2(mxarea),NEWAR2(mxarea),NZA,NTR0
c     Parameters:
c           MXNX, MXNY, MXNZ, MXNZP1, MXSPEC, MXAREA, MXRISE, IO6
c
c --- OUTPUT:
c            NP - integer - UPDATED index of last puff/slug initialized
c        NEWPUF - integer - UPDATED number of new puffs/slugs released
c                           during the current time step
c       PROBLEM - logical - Set true if fatal problem encountered
c
c     Common block /AR2/ variables:
c           NEWAR2(mxarea)
c     Common block /PUFF/ variables:
c           all variables in common block
c     Common block /SLUG/ variables:
c           all variables in common block
c     Common block /SRCTAB/ variables:
c           NTR,XTR(mxrise),ZTR(mxrise),RTR(mxrise),HTR(mxrise)
c
c --- AREAS2 called by:  INITPUF
c --- AREAS2 calls:      RLSMET, ROLLDN, NUMMET, NUMRISE,
c                        SYAREA, SWAP, INJECT, ZEROTAB, SRCTABOUT
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      include 'comparm.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'methd.puf'
      include 'methr.puf'
      include 'ar2.puf'
      include 'puff.puf'
      include 'slug.puf'
      include 'srctab.puf'
c
      real q(mxspec)
      logical ldbhr,problem
      data twobypi/0.63662/
c
c ***
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'AREAS2:  Source Number    ',i
      endif
c ***
c
c --- Do not generate puffs for this source if all emissions are ZERO!
      qsum=0.0
      do is=1,nspec
         qsum=qsum+qar2(is,i)
      enddo
      if(qsum.EQ.0.0) then
         newar2(i)=0
         return
      endif
c
c --- Determine the met. grid point closest to the source
      ixs=1.0+xar2grd(nvert2(i)+1,i)
      iys=1.0+yar2grd(nvert2(i)+1,i)
c
c --- Source off the computational grid -- write a WARNING
      if(ixs.lt.ibcomp.or.ixs.gt.iecomp.or.iys.lt.jbcomp.or.iys.gt.
     1   jecomp)then
         write(io6,20)i,ixs,iys
20       format(/1x,'Warning -- an area source with variable ',
     1   'emissions is off the computational grid'/
     2   1x,'source no. (i) = ',i6,2x,
     3   'nearest grid point (ixs,iys) = (',i5,',',i5,')')
c
c ---    Don't emit from this source, but continue executing
         newar2(i)=0
c ---    Retain current value of PROBLEM
         problem=problem
         return
      endif
c
c --- Initialize source tabulation arrays to zero
      call ZEROTAB

c --- Extract release height wind speed & other met. variables
      call rlsmet(ldbhr,ixs,iys,htar2(i),mfact,
     &            mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &            ustr,wstr,tsigv,tsigw,iru,issta,sqrts,idopty,idoptz)
c
c --- Set sigma y, sigma z at the source
      szsrc=AMAX1(szmin,sz0ar2(i))
      call SYAREA(xar2grd(1,i),yar2grd(1,i),nvert2(i),dgrid,
     &            flow,ldbhr,sysrc)
      sysrc=AMAX1(symin,sysrc)

c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif
c
c --------------------------------
c --- Numerical Plume Rise Section
c --------------------------------
c
c --- Construct met. profiles at this grid cell
      call NUMMET(ixs,iys,ldbhr)
c
c --  Tabulate plume rise in arrays
      mprime=0
      ntr=ntr0
      call NUMRISE(mprime,ldbhr,htar2(i),tkar2(i),refar2(i),wefar2(i),
     &             sysrc,szsrc,ntr,xtr,ztr,rtr,htr)
c
c --- Set variance associated with buoyancy-enhanced growth @ final rise
      xf=xtr(ntr)
      rise=ztr(ntr)-htar2(i)
      bidsq=twobypi*rtr(ntr)**2
c --- Set downwash flag to zero (no building downwash)
      idw=0
c --- Set final plume height
      heff=ztr(ntr)
c
c ---------------------------------------------------------
c --- Compute the number of puffs/slugs released this hour
c --- from this source
c ---------------------------------------------------------
c --- Use CALMET/PROFILE winds at final rise to set release/sampling
c --- data
      if(metfm.EQ.1 .OR. metfm.EQ.4 .OR. metfm.EQ.5) then
         call rlsmet(ldbhr,ixs,iys,heff,mfact,
     &               mfact0fr,ilayerfr,wsfr,flowfr,ivecfr,istab,dpbl,el,
     &               ustr,wstr,tsigvfr,tsigwfr,iru,issta,sqrtsfr,
     &               idoptyfr,idoptzfr)
         wsnew=AMAX1(ws,wsfr)
      else
         wsnew=ws
      endif
      npnew=wsnew*xtmp1+1
      npnew=max0(npnew,1)
      npnew=min0(npnew,mxnew)
      newar2(i)=npnew
      newpuf=newpuf+npnew
c --- If puff arrays are full, remove puffs that are off the grid
c --- and "roll down" arrays to make room for new puffs
c --- (this also applies to the DA file of tabulated arrays)
      if(npuffs+newpuf.gt.mxpuff) call rolldn(np)
c
c --- Check to see if roll-down was adequate
      if(npuffs+newpuf.gt.mxpuff)then
         write(io6,*) ' ERROR in subr. AREAS2'
         write(io6,*)'Too many puffs on grid for array dimensions -- ',
     1   'NPUFFS (old puffs) = ',npuffs,' NEWPUF = ',newpuf,
     2   ' MXPUFF = ',mxpuff
         write(*,*)
         stop 'Halted in AREAS2 -- see list file.'
      endif
c
c --- DT is the time (sec) over which each puff is emitted
      dt=dthr/float(npnew)
c
c******
      if(ldbhr)then
         write(io6,204)i,ilayer,ixs,iys,ws,istab,dpbl,issta,npnew,
     1    newpuf,dt
204      format(5x,'IS: ',i5,2x,'ILAYER: ',i3,2x,'IXS: ',i4,2x,
     1    'IYS: ',i4,2x,'WS: ',f5.1,2x,'ISTAB: ',i1,2x,'DPBL: ',
     2    f7.1,2x,'ISSTA: ',i4,2x,'NPNEW: ',i4,2x,'NEWPUF: ',i5/
     3    5x,'DT: ',f7.2)
c
         write(io6,210)idw,heff,rise,xf,sysrc,szsrc
210      format(5x,'IDW: ',i5,2x,'HEFF: ',f8.2,2x,'RISE : ',f8.2,2x,
     1    'XF : ',f8.2,2x,'SYSRC: ',f8.2,2x,'SZSRC: ',f8.2)
c
         write(io6,208)i,np,iru,dt,sqrts
208      format(5x,'I: ',i5,2x,'NP: ',i5,2x,
     1    'IRU: ',i2,2x,'DT: ',f7.2,2x,'SQRTS: ',f7.3)
      endif
c*****
c ----------------------------------------------------------
c ---    Initialize current hour's new puffs for this source
c ----------------------------------------------------------
         do 50 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xar2grd(nvert2(i)+1,i)
         ypb(np)=yar2grd(nvert2(i)+1,i)
         zitibl(np)=-1.0
         elbase(np)=elar2(i)
         sigyb(np)=symin
         sigzb(np)=szsrc
c ---    Final plume rise results
         zfinal(np)=heff
         zpb(np)=heff
         zpe(np)=heff
         xfinal(np)=xf
         bidfnl(np)=bidsq
         isplit(np)=1
c ---    Time-of-release data
         ht0(np)=htar2(i)
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations
         idw0(np)=idw
         heff20(np)=heff
         sy0(np)=sysrc
         sz0(np)=szsrc

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =4 for buoyant area sources)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=4
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    Note that "oldest" end of slug is at the source, as is the
c ---    "newest end; oldest end moves away and grows during the step,
c ---    while newest end remains fixed in size at the source.
c
         if(mslug.EQ.1 .AND. mfact0.GT.0) then
c ---       Set coordinates of oldest end of slug (in met. grid units)
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c -------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c -------------------------------------------------------------------
c ---    Set partial penetration variables to null values
         fmix=1.0
         hmax=dpbl
c ---    Swap emission rate for source 'i' into 1D array
         do ispec=1,nspec
            q(ispec)=qar2(ispec,i)
         enddo
         call INJECT(np,nspec,dt,mfact0,q,heff,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer tabulated arrays record to DA file using full
c ---    MXRISE dimension
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

50       continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine syarea(xargrd,yargrd,nvert,dgrid,vecrad,ldbhr,
     &                  sysrc)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                 SYAREA
c                D. Strimaitis,   SRC
c
c --- PURPOSE:  For a polygon area source, determine the effective
c               initial sigma-y based on the projection of the source
c               in the crosswind direction for this met period.
c
c --- UPDATE
c --- V4.0-V5.0     971107  (DGS): change coordinate arrays for
c                                  verticies so that single array dim.
c                                  can be used
c
c --- INPUTS:
c
c         XARGRD(mxvert) - real    - X coordinates (m) of the vertices of
c                                    the polygon area source.
c         YARGRD(mxvert) - real    - Y coordinates (m) of the vertices of
c                                    the polygon area source.
c                  NVERT - integer - # vertices of the polygon area source.
c                  DGRID - real    - MET grid cell length  (m)
c                 VECRAD - real    - Flow vector (radians)
c                  LDBHR - logical - Debug control
c
c
c --- OUTPUTS:
c
c                  SYSRC - real    - Effective initial sigma-y (m) for
c                                    source
c
c
c --- SYAREA called by:  AREAS1, AREAS2
c --- SYAREA calls:      none
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      real xargrd(mxvert),yargrd(mxvert)
      logical ldbhr

      data piby2/1.5707963/,rt2pi/2.5066283/
c
c --- Transform vertex coordinates into upwind/crosswind frame,
c     keeping track of the max & min crosswind coordinates
c
c --- Rotation angle (CW)
      rot=-vecrad+piby2
      sinrot=sin(rot)
      cosrot=cos(rot)
c --- New crosswind coordinate of vertex #1
      yprime=-sinrot*xargrd(1)+cosrot*yargrd(1)
      ymin=yprime
      ymax=yprime
c --- Process rest of vertices
      do iv=2,nvert
         yprime=-sinrot*xargrd(iv)+cosrot*yargrd(iv)
         ymin=amin1(ymin,yprime)
         ymax=amax1(ymax,yprime)
      enddo
c
c --- Compute initial sigma-y as L/SQRT(2*pi)
      sysrc=(ymax-ymin)*dgrid/rt2pi
c
      if(LDBHR) then
         write(io6,*) 'SYAREA -- '
         write(io6,*) 'ymin,ymax (met grid) = ',ymin,ymax
         write(io6,*) 'coord rotation (rad) = ',rot
         write(io6,*) 'initial sigma-y (m)  = ',sysrc
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine vols(mvolume,i,nspec,dthr,xtmp1,ldbhr,mfact,np,
     &                newpuf,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                   VOLS
c                J. Scire, D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Initialize newly released puff/slug variables for
c               VOLUME SOURCES prescribed in the control-file, or
c               VOLUME SOURCES prescribed in VOLEMARB.DAT
c
c --- UPDATE
c --- V5.831-V5.8.4 130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c --- V5.82-V5.8.4  130731  (EPA): Place rise tables in DA file
c --- V5.72-V5.8.4  130731  (EPA): Change J to I in debug output
c --- V5.7-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.4-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c --- V5.0-V5.4     000602  (DGS): combine VOLS1 & VOLS2
c                   000602  (DGS): add message to "stop"
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V5.0-V5.0     980304  (DGS): drop any new puffs if emissions = 0
c --- V5.0-V5.0     980304  (DGS): place source sigmas in SY0,SZ0
c --- V4.0-V5.0     971107  (DGS): add variable emissions factor call
c                                  to function VEMFAC
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c
c --- INPUTS:
c       MVOLUME - integer - Flag for origin of volume source data
c                            1 = Control file (/vol1/)
c                            2 = VOLEMARB.DAT file (/vol2/)
c             I - integer - Volume source index
c         NSPEC - real    - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         XTMP1 - real    -
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c            NP - integer - Index of last puff/slug initialized
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW, SYMIN, SZMIN, WSCALM, PLX0
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MHFTSZ
c     Common block /GRID/ variables:
c           IBCOMP, IECOMP, JBCOMP, JECOMP
c     Common block /METHR/ variables:
c           PLEXP
c     Common block /METHD/ variables:
c           I2DMET
c     Common block /PUFF/ variables:
c           NPUFFS
c     Common block /VOL1/ variables:
c           XVL1GRD(mxvol),YVL1GRD(mxvol),HTVL1(mxvol),
c           ELVL1(mxvol),SY0VL1(mxvol),SZ0VL1(mxvol),
c           QVL1(mxspec,mxvol),NEWVL1(mxvol),
c           ivvl1(mxspec,mxvol),iq12vl1(mxspec,mxvol)
c     Common block /VOL2/ variables:
c           XVL2GRD(mxvol),YVL2GRD(mxvol),HTVL2(mxvol),
c           ELVL2(mxvol),SY0VL2(mxvol),SZ0VL2(mxvol),
c           QVL2(mxspec,mxvol),NEWVL2(mxvol)
c     Parameters:
c           MXNX, MXNY, MXNZ, MXNZP1, MXSPEC, MXVOL, IO6
c
c --- OUTPUT:
c            NP - integer - UPDATED index of last puff/slug initialized
c        NEWPUF - integer - UPDATED number of new puffs/slugs released
c                           during the current time step
c       PROBLEM - logical - Set true if fatal problem encountered
c
c     Common block /VOL1/ variables:
c           NEWVL1(mxvol)
c     Common block /VOL2/ variables:
c           NEWVL2(mxvol)
c     Common block /PUFF/ variables:
c           all variables in common block
c     Common block /SLUG/ variables:
c           all variables in common block
c
c --- VOLS called by:  INITPUF
c --- VOLS calls:      RLSMET, ROLLDN, SWAP, INJECT, VEMFAC,
c                      ZEROTAB, SRCTABOUT
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      include 'comparm.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'methr.puf'
      include 'vol1.puf'
      include 'vol2.puf'
      include 'puff.puf'
      include 'slug.puf'
c frr (09/01)
      include 'methd.puf'
c
      real q(mxspec)
      logical ldbhr,problem
      character*16 vltype

c --- Assign variables for current source
      if(mvolume.EQ.1) then
         vltype=' Control File '
         xvlgrd=xvl1grd(i)
         yvlgrd=yvl1grd(i)
         heff=htvl1(i)
         elvl=elvl1(i)
         szsrc=amax1(szmin,sz0vl1(i))
         sysrc=amax1(symin,sy0vl1(i))
         do is=1,nspec
            q(is)=qvl1(is,i)
         enddo
      elseif(mvolume.EQ.2) then
         vltype=' VOLEMARB.DAT '
         xvlgrd=xvl2grd(i)
         yvlgrd=yvl2grd(i)
         heff=htvl2(i)
         elvl=elvl2(i)
         szsrc=amax1(szmin,sz0vl2(i))
         sysrc=amax1(symin,sy0vl2(i))
         do is=1,nspec
            q(is)=qvl2(is,i)
         enddo
      else
         write(io6,*)
         write(io6,*)'VOLS:  Invalid volume source type: ',mvolume
         write(io6,*)'       Valid types are 1 (control file)'
         write(io6,*)'                       2 (VOLEMARB.DAT)'
         write(*,*)
         stop 'Halted in VOLS -- see list file.'
      endif
c
c ***
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'VOLS: Source Number ',i,'  Source Type ',vltype
      endif
c ***
c
c --- Determine the met. grid point closest to the source
      ixs=1.0+xvlgrd
      iys=1.0+yvlgrd
c
c --- Source off the computational grid -- write a FATAL message
      if(ixs.lt.ibcomp.or.ixs.gt.iecomp.or.iys.lt.jbcomp.or.iys.gt.
     1   jecomp)then
         write(io6,20) vltype,i,ixs,iys
20       format(/1x,'FATAL -- a volume source of Type ',a16,
     1   'is off the computational grid'/1x,'source no. (i) = ',i6,2x,
     2   'nearest grid point (ixs,iys) = (',i5,',',i5,')')
         problem=.TRUE.
         return
      endif
c
c --- Extract release height wind speed & other met. variables
      call rlsmet(ldbhr,ixs,iys,heff,mfact,
     &            mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &            ustr,wstr,tsigv,tsigw,iru,issta,sqrts,idopty,idoptz)
c
c frr (09/01) new calmet format (2D temp)
      if(i2dmet.EQ.1) then
         temp=temp2d(ixs,iys)
      elseif(i2dmet.EQ.0) then
         temp=tempss(issta)
      else
         write(*,*)'Subr. VOLS:  Invalid I2DMET = ',i2dmet
         stop
      endif


c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif

c --- Adjust TYPE-1 emissions for source 'i' and obtain total
      qtot=0.0
      do is=1,nspec
         if(mvolume.EQ.1) q(is)=q(is)*VEMFAC(ldbhr,ivvl1(is,i),
     &                          iq12vl1(is,i),temp,ws,istab)
         qtot=qtot+q(is)
      enddo
c --- Return without generating new puffs if all species have zero
c --- mass in puff
      if(qtot.EQ.0.0) then
c ***
         if(ldbhr) then
            write(io6,*)
            write(io6,*) 'No emissions this step from Source ',i
            write(io6,*)
         endif
c ***
         return
      endif
c
c --- Initialize source tabulation specifications to zero
      call ZEROTAB

c --- Compute the number of puffs/slugs released this hour
c --- from this source
      npnew=ws*xtmp1+1
      npnew=max0(npnew,1)
      npnew=min0(npnew,mxnew)
      if(mvolume.EQ.1) then
         newvl1(i)=npnew
      else
         newvl2(i)=npnew
      endif
      newpuf=newpuf+npnew
c --- If puff arrays are full, remove puffs that are off the grid
c --- and "roll down" arrays to make room for new puffs
c --- (this also applies to the DA file of tabulated arrays)
      if(npuffs+newpuf.gt.mxpuff) call rolldn(np)
c
c --- Check to see if roll-down was adequate
      if(npuffs+newpuf.gt.mxpuff)then
         write(io6,*) ' ERROR in subr. VOLS'
         write(io6,*)'Too many puffs on grid for array dimensions -- ',
     1   'NPUFFS (old puffs) = ',npuffs,' NEWPUF = ',newpuf,
     2   ' MXPUFF = ',mxpuff
         write(*,*)
         stop 'Halted in VOLS -- see list file.'
      endif
c
c --- DT is the time (sec) over which each puff is emitted
      dt=dthr/float(npnew)
c
c --- Set variance associated with buoyancy-enhanced growth @ final rise
      xf=0.0
      rise=0.0
      bidsq=0.0
c --- Set downwash flag to zero (no building downwash)
      idw=0

c******
      if(ldbhr)then
         write(io6,204)i,ilayer,ixs,iys,ws,istab,dpbl,issta,npnew,
     1    newpuf,dt
204      format(5x,'IS: ',i5,2x,'ILAYER: ',i3,2x,'IXS: ',i4,2x,
     1    'IYS: ',i4,2x,'WS: ',f5.1,2x,'ISTAB: ',i1,2x,'DPBL: ',
     2    f7.1,2x,'ISSTA: ',i4,2x,'NPNEW: ',i4,2x,'NEWPUF: ',i5/
     3    5x,'DT: ',f7.2)
c
         write(io6,210)idw,heff,rise,xf,sysrc,szsrc
210      format(5x,'IDW: ',i5,2x,'HEFF: ',f8.2,2x,'RISE : ',f8.2,2x,
     1    'XF : ',f8.2,2x,'SYSRC: ',f8.2,2x,'SZSRC: ',f8.2)
c
         write(io6,208)i,np,iru,dt,sqrts
208      format(5x,'I: ',i5,2x,'NP: ',i5,2x,
     1    'IRU: ',i2,2x,'DT: ',f7.2,2x,'SQRTS: ',f7.3)
      endif
c*****
c ----------------------------------------------------------
c ---    Initialize current hour's new puffs for this source
c ----------------------------------------------------------
         do 50 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xvlgrd
         ypb(np)=yvlgrd
         zitibl(np)=-1.0
         elbase(np)=elvl
         sigyb(np)=sysrc
         sigzb(np)=szsrc
c ---    Final plume rise results
         zfinal(np)=heff
         zpb(np)=heff
         zpe(np)=heff
         xfinal(np)=xf
         bidfnl(np)=bidsq
         isplit(np)=1
c ---    Time-of-release data
         ht0(np)=heff
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations (downwash)
         idw0(np)=idw
         heff20(np)=heff
         sy0(np)=sysrc
         sz0(np)=szsrc

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =7 for control file volume sources)
c ---    (Type =8 for VOLEMARB.DAT volume sources)
         irlsnum(np)=j
         isrcnum(np)=i
         if(mvolume.EQ.1) then
            isrctyp(np)=7
         else
            isrctyp(np)=8
         endif
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    Note that "oldest" end of slug is at the source, as is the
c ---    "newest end; oldest end moves away and grows during the step,
c ---    while newest end remains fixed in size at the source.
c
         if(mslug.EQ.1 .AND. mfact0.GT.0) then
c ---       Set coordinates of oldest end of slug (in met. grid units)
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c ------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c ------------------------------------------------------------------
c ---    Set partial penetration variables to null values
         fmix=1.0
         hmax=dpbl
         call inject(np,nspec,dt,mfact0,q,heff,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer NULL tabulated arrays record to DA file
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

50       continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine points1(i,nspec,dthr,xtmp1,ldbhr,mfact,metfm,np,
     &                   newpuf,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 151214                POINTS1
c                J. Scire, D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Initialize newly released puff/slug variables for
c               POINT SOURCES with constant emissions
c
c --- UPDATE
c --- V5.8.4-V5.8.5 151214   (CDA): Add BID to sigmas for the PRIME case 
c                                  where plume does not eneter the wake (no wake table).  
c                                  Plume growth is calculated from the source rathrer 
c                                  than from the sigmas at the end of the wake table 
c                                  (read from the wake table, including BID), so the BID 
c                                  due to rise must be added.
c --- V5.8.4-V5.8.5 151214   (CDA): Add calls to WAKE_CSIG to set
c                                  dispersion data for release ht and
c                                  for building top
c --- V5.834-V5.8.4 130731  (EPA): Add idownw as a screen for debug
c                                  writes so that unassigned downwash
c                                  variables are not written to list
c                                  file
c                   130731  (EPA): Set BID to zero for PRIME sources as
c                                  wake tables now include BID, and add
c                                  HTR to CAV_CONC call
c --- V5.833-V5.8.4 130731  (EPA): Add maximum lid height for mass above
c                                  Zi to CAV_CONC arguments for later
c                                  use in VCOUP
c --- V5.832-V5.8.4 130731  (EPA): Do not adjust Briggs plume rise for
c                                  shear when distance to final rise is
c                                  zero (near-calm)
c                           (EPA): Write more digits for TSTAK, DTEMP
c                                  debug output
c --- V5.831-V5.8.4 130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c --- V5.82-V5.8.4  130731  (EPA): Place rise tables in DA file
c --- V5.760-V5.8.4 130731  (EPA): Initialize variables
c                                  INDEX = 0
c --- V5.75-V5.760  070605  (DGS): Initialize variables
c                                  HB, HW, HEFF2, ZLY, RINIT = 0.0
c                   070605  (DGS): Fix debug output index from J to I
c                   070605  (DGS): Fix name of IRU used in PRIME section
c                                  when the meteorology at building-ht
c                                  is extracted (IRUB was not defined)
c --- V5.74-V5.75   050225  (DGS): add platform adjustment to ISC
c                                  building downwash (MBDW=1)
c                   050225  (DGS): Add DPBL arg to SETCSIG for TAULY
c --- V5.72-V5.74   040715  (DGS): add METFM=5 (AERMET)
c --- V5.7-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.5-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c                   030402  (DGS): implement PRIME downwash option
c --- V5.4-V5.5     010730  (DGS): store initial sigmas from control
c                                  file in SYSRC0 and SZSRC0 for use
c                                  in downwash zone
c                   010730  (DGS): revise building-array index to match
c                                  ISC
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c                   000602  (DGS): add MFOG option
c --- V5.0-V5.3     991222b (DGS): reset momentum flux using FMFAC
c                   991222b (DGS): pass momentum flux to STKTIP
c --- V5.0-V5.0     980807  (DGS): use final rise CALMET/PROFILE winds
c                                  to set release step
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V5.0-V5.0     980304  (DGS): drop any new puffs if emissions = 0
c                   980304  (DGS): use initial sigmay,z arrays from
c                                  control file
c                   980304  (DGS): place source sigmas in SY0,SZ0
c --- V4.0-V5.0     971107  (DGS): add variable emissions factor call
c                                  to function VEMFAC
c                   971107  (DGS): updated /PT1/ variables used (doc)
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c                   971107  (DGS): add observed inversion strength
c
c --- INPUTS:
c             I - integer - Point source index
c         NSPEC - real    - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         XTMP1 - real    -
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c         METFM - integer - Meteorological data format
c            NP - integer - Index of last puff/slug initialized
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW, SYMIN, SZMIN, PTG0(2), WSCALM, TBD, PLX0
c     Common block /DISPDAT/ variables:
c           JSUP
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MTIP, MSHEAR, MPARTL, MHFTSZ, MFOG, MBDW
c     Common block /FOG/ variables:
c           TXSMXFOG
c     Common block /GRID/ variables:
c           IBCOMP, IECOMP, JBCOMP, JECOMP
c     Common block /METHD/ variables:
c           LCALGRD, I2DMET
c     Common block /METHR/ variables:
c           PLEXP, PTG(2), DPTINVO
c     Common block /PUFF/ variables:
c           NPUFFS
c     Common block /PT1/ variables:
c           XPT1GRD(mxpt1),YPT1GRD(mxpt1),HTSTAK(mxpt1),
c           ELSTAK(mxpt1),DIAM(mxpt1),EXITW(mxpt1),TSTAK(mxpt1),
c           IDOWNW(mxpt1),QSTAK(mxspec,mxpt1),NPT1,
c           SYIPT1(mxpt1),SZIPT1(mxpt1),FMFPT1(mxpt1),
c           BWIDTH(36,mxpt1),BHT(36,mxpt1),
c           BLN1(36,mxpt1),XBADJ1(36,mxpt1),YBADJ1(36,mxpt1),
c           ivpt1(mxspec,mxpt1),iq12pt1(mxspec,mxpt1),
c           ZPLATPT1(mxpt1)
c     Parameters:
c           MXNX, MXNY, MXNZ, MXNZP1, MXPT1, MXSPEC, IO6
c
c --- OUTPUT:
c            NP - integer - UPDATED index of last puff/slug initialized
c        NEWPUF - integer - UPDATED number of new puffs/slugs released
c                           during the current time step
c       PROBLEM - logical - Set true if fatal problem encountered
c
c     Common block /FOG/ variables:
c           TXSMXFOG
c     Common block /PT1/ variables:
c           NEWPT1(mxpt1)
c     Common block /PUFF/ variables:
c           all variables in common block
c     Common block /SLUG/ variables:
c           all variables in common block
c     Common block /SRCTAB/ variables:
c           NTR, NWK, NCV,
c           XTR(mxrise),ZTR(mxrise),RTR(mxrise),HTR(mxrise),
c           XWK(mxrise),SYWK(mxrise),SZWK(mxrise),DRWK(mxrise),
c           XCV(mxrise),SYCV(mxrise),SZCV(mxrise)
c
c --- POINTS1 called by:  INITPUF
c --- POINTS1 calls:      RLSMET, ROLLDN, PTLAPS, SETCSIG, SIGTY,
c                         SIGTZ, STKTIP, DWSIGS, PRSS, PRFIN, PRM,
c                         PRFINSH, SWAP, INJECT, VEMFAC,
c                         WAKE_INI, NUMMET, NUMRISE, CAV_CONC, WAKE_DBG
c                         ZEROTAB, SRCTABOUT
c                         WAKE_CSIG
c
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      include 'comparm.puf'
      include 'csigma.puf'
      include 'dispdat.puf'
      include 'flags.puf'
      include 'fog.puf'
      include 'grid.puf'
      include 'methd.puf'
      include 'methr.puf'
      include 'puff.puf'
      include 'pt1.puf'
      include 'slug.puf'
      include 'srctab.puf'
c
      real q(mxspec),qcav(mxspec)
      logical ldbhr,problem

c --- PRIME logicals to configure primary (LPRM) and cavity (LCAV) puff
      logical lprm,lcav
c
      data rt2/1.4142136/, rt2pi/2.5066283/, piby4/0.7853982/
c --- Set minimum allowed potential temperature gradient PTGRAD0,
      data ptgrad0/.005/
c --- Set minimum allowed wind speed for building downwash
      data wsdw0/1.0/

c --- Initialize local ISC building downwash variables
      index=0
      hb=0.0
      hw=0.0
      heff2=0.0
      zly=0.0
      rinit=0.0
c
c ***
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'POINTS1:  Source Number    ',i
      endif
c ***
c
c --- Determine the met. grid point closest to the stack
      ixs=1.0+xpt1grd(i)
      iys=1.0+ypt1grd(i)
c
c --- Source off the computational grid -- write a FATAL message
      if(ixs.lt.ibcomp.or.ixs.gt.iecomp.or.iys.lt.jbcomp.or.iys.gt.
     1   jecomp)then
         write(io6,20)i,ixs,iys
20       format(/1x,'FATAL -- a point source with constant emissions ',
     1   'is off the computational grid'/1x,'source no. (i) = ',i6,2x,
     2   'nearest grid point (ixs,iys) = (',i5,',',i5,')')
         problem=.TRUE.
         return
      endif
c
c --- Extract stack height wind speed & other met. variables;
c --- and set CALM configuration if triggered
      call rlsmet(ldbhr,ixs,iys,htstak(i),mfact,
     &            mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &            ustr,wstr,tsigv,tsigw,iru,issta,sqrts,idopty,idoptz)
c
c frr (09/01) new calmet format (2D temp)
      if(i2dmet.EQ.1) then
         temp=temp2d(ixs,iys)
      elseif(i2dmet.EQ.0) then
         temp=tempss(issta)
      else
         write(*,*)'Subr. POINTS1:  Invalid I2DMET = ',i2dmet
         stop
      endif

c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif

c --- Swap emission rate for source 'i' into 1D array and scale
      qtot=0.0
      do is=1,nspec
         q(is)=qstak(is,i)*VEMFAC(ldbhr,ivpt1(is,i),iq12pt1(is,i),
     &                            temp,ws,istab)
         qtot=qtot+q(is)
      enddo
c --- Return without generating new puffs if all species have zero
c --- mass in puff
      if(qtot.EQ.0.0) then
c ***
         if(ldbhr) then
            write(io6,*)
            write(io6,*) 'No emissions this step from Source ',i
            write(io6,*)
         endif
c ***
         return
      endif

c --- Initialize source tabulation arrays to zero
      call ZEROTAB

c --- Set volume flux from stack
      vf0=piby4*exitw(i)*(diam(i))**2

c --- Set temperature excess at release
c frr(09/01)
c      dtemp=tstak(i)-tempss(issta)
      dtemp=tstak(i)-temp
c      dtemp=amax1(dtemp,0.01)
      dtemp=amax1(dtemp,0.0)

      if(MFOG.GT.0) then
c ---    Place the temperature excess emission rate (K-m^3/s) in Q(2)
c ---    Note that nspec should be 2 for FOG option
         q(2)=dtemp*vf0
c ---    Maximum temperature excess used to compute RH will be limited
c ---    to the minimum temperature excess among FOG sources
         txsmxfog=AMIN1(dtemp,txsmxfog)
      endif
c
c -------------------------------------------------------------
c --- Compute the final plume rise and distance to final rise
c -------------------------------------------------------------
c --- Calculate fluxes
c --- Buoyancy flux:  2.4516625 = g/4., where g = 9.80665 m/s**2
      fluxb=(2.4516625*diam(i)**2*exitw(i)/tstak(i))*dtemp
c --- Momentum flux
c frr(09/01)
c      fluxm=0.25*(exitw(i)*diam(i))**2*tempss(issta)/tstak(i)
      fluxm=0.25*(exitw(i)*diam(i))**2*temp/tstak(i)
c --- Apply vertical momentum flux factor of zero or one
c --- Use simple test for ZERO instead of forming the product:
c ---     fluxm=fluxm*fmfpt1(i)
      if(fmfpt1(i).LT.0.5) fluxm=0.0
c
c --- Adjustment for stack-tip downwash (NOT for bldg downwash!)
      if(mtip.EQ.1) then
         call stktip(htstak(i),diam(i),fluxm,exitw(i),ws,tipdw)
      else
         tipdw=0.0
      endif
c
c --- Final plume rise (no downwash considered)
      call prfin(exitw(i),diam(i),fluxm,fluxb,ws,istab,sqrts,
     &           xfinm,xfinb,xf,zfinm,zfinb,rise)
c
c --- Compute vertical wind shear effects
      if(mshear.EQ.1 .AND. xfinb.GT.0.0)then
         call prfinsh(fluxb,ws,plx,htstak(i),xfinb,istab,sqrts,
     1                zfinsh)
c ---    Final buoyant rise is the LOWER of the Briggs & shear hts.
         zfinb=amin1(zfinb,zfinsh)
c ---    Final plume rise is the HIGHER of the momentum & buoyant hts.
         rise=amax1(zfinb,zfinm)
      endif
c
c --- Adjust for partial penetration of elevated stable layer
c     if(mpartl.EQ.1 .and. istab.LE.3 .and. htstak(i).LT.dpbl) then
      if(mpartl.EQ.1 .and. istab.LE.4 .and. fluxb.GT.0.0) then
c ---    Set thickness (m) of transition region above mixing height
         dzinv=30.
c ---    Estimate potential temperature gradient above mixed layer
         if(LCALGRD) then
c ---       Use temperatures provided by met model
            htinv=amax1(dpbl,htstak(i))
            call ptlaps(ixs,iys,htinv,ptgrad0,dzinv,ptginv,tmix)
         else
c ---       Use default potential temperature lapse rate
            if(jsup.LE.4) then
               ptginv=ptgrad0
            elseif(jsup.EQ.5) then
               ptginv=amax1(ptg0(1),ptgrad0)
            else
               ptginv=amax1(ptg0(2),ptgrad0)
            endif
         endif
c ---    Estimate potential temperature change across inversion
         if(dptinvo.GT.0.0) then
c ---       Use observed value provided in met file
            dptinv=dptinvo
         else
            dptinv=ptginv*dzinv
         endif
c frr(09/01)
c        call prfpp(rise,fluxb,ws,htstak(i),dpbl,tempss(issta),ptginv,
         call prfpp(rise,fluxb,ws,htstak(i),dpbl,temp,ptginv,
     &              dptinv,fmix,hmax)
c ---    Reset component final rise heights for use in gradual rise
         if(zfinb.GT.rise) zfinb=rise
         if(zfinm.GT.rise) zfinm=rise
c
      else
         fmix=1.0
         hmax=dpbl
      endif
c
c --- Set variance associated with buoyancy-enhanced growth @ final rise
      bidsq=(rise/3.5)**2
c
c --- Set final plume height
      heff=htstak(i)-tipdw+rise
c
c --- Set selected data in /CSIGMA/ for sigma calls
      call setcsig(idopty,idoptz,iru,ws,istab,el,sqrts,
     &             tsigv,tsigw,symin,szmin,heff,dpbl)
c
c --------------------------------------------------------------------
c --- Determine if building downwash effects on plume rise and sigmas
c --- should be considered
c --------------------------------------------------------------------
      sz0dw=0.0
      sy0dw=0.0
      xshift=0.0
      xshift2=0.0
      lprm=.FALSE.
      lcav=.FALSE.
c --- Initialize downwash flag to zero (no building downwash)
c --- Note:  idw=0  no downwash
c ---        idw=1  Huber-Snyder model
c ---        idw=2  Schulman-Scire model
c ---        idw=3  PRIME model (puff released from primary source)
c ---        idw=4  PRIME model (puff released from cavity source)
      idw=0

      if(idownw(i).EQ.1 .AND. ws.GE.wsdw0 .AND. mbdw.EQ.2) then
c        --------------------------------
c        --- PRIME Downwash Section
c        --------------------------------
         mprime=1
c ---    Store dispersion data for release height for later use

         zht=heff
         call WAKE_CSIG(idopty,idoptz,iru,ws,istab,el,
     &                  sqrts,tsigv,tsigw,symin,szmin,
     &                  zht,dpbl,'RELEASE ')

c ---    Get direction-specific building data (direction at stack ht)
         index=INT(0.1*FLOAT(ivec)+0.4999)
         if(index.eq.0)index=36
         dsbh=bht(index,i)
         dsbw=bwidth(index,i)
         dsbl=bln1(index,i)
         xadj=xbadj1(index,i)
         yadj=ybadj1(index,i)
         hl=AMIN1(dsbh,dsbw)
c ---    Screen for GEP stack (regulatory definition)
         geptest=dsbh+1.5*hl
         if(htstak(i).LT.geptest) then
            idw=3
c ---       Set stack radius
            reff=0.5*diam(i)
c ---       Set met data at top of building
            call RLSMET(ldbhr,ixs,iys,dsbh,mfact,
     &                  mfact0b,ilayer,wsb,flowb,ivecb,istabb,dpbl,
     &                  elb,ustrb,wstrb,tsigvb,tsigwb,iru,issta,
     &                  sqrtsb,idoptyb,idoptzb)

c ---       Reset /CSIGMA/ data for met data at top of building
            zht=AMAX1(heff,dsbh)
            call SETCSIG(idoptyb,idoptzb,iru,wsb,istabb,elb,sqrtsb,
     &                   tsigvb,tsigwb,symin,szmin,zht,dpbl)

c ---       Store dispersion data for top of building for later use
            call WAKE_CSIG(idoptyb,idoptzb,iru,wsb,istabb,elb,
     &                     sqrtsb,tsigvb,tsigwb,symin,szmin,
     &                     zht,dpbl,'BUILDING')

c ---       Refresh /WAKEDAT/ variables
            call WAKE_INI(ldbhr,istab,iru,dsbh,dsbw,dsbl,xadj,yadj,
     &                    wsb,ws,tsigvb,tsigwb,idoptyb,idoptzb)
c
c ---       Construct met. profiles at this grid cell
            call NUMMET(ixs,iys,ldbhr)
c ---       Compute plume rise and wake structure
c ---       Use full MXRISE points in rise table
            ntr=mxrise
            call NUMRISE(mprime,ldbhr,htstak(i),tstak(i),reff,exitw(i),
     &                   syipt1(i),szipt1(i),ntr,xtr,ztr,rtr,htr)
c ---       Pass final wake structure to source arrays (with BID)
            call WAKE_FIN(ldbhr,nwk,xwk,szwk,sywk,drwk,szw0,syw0,
     &                    ncv,xcv,szcv,sycv,szc0,syc0,fqcvpt1(i))
c
c ---       Set logicals (primary & cavity) and partition mass
            if(fqcvpt1(i).LE.0.001) then
               lcav=.FALSE.
               lprm=.TRUE.
               do is=1,nspec
                  qcav(is)=0.0
               enddo
            elseif(fqcvpt1(i).GE.0.999) then
               lcav=.TRUE.
               lprm=.FALSE.
               do is=1,nspec
                  qcav(is)=q(is)
                  q(is)=0.0
               enddo
            else
               lcav=.TRUE.
               lprm=.TRUE.
               do is=1,nspec
                  qcav(is)=q(is)*fqcvpt1(i)
                  q(is)=q(is)-qcav(is)
               enddo
            endif

c ---       Compute near-cavity concentrations for current source,
c ---       return location of cavity source on the met grid, and
c ---       return the distance from the source to the end of the
c ---       cavity transition zone
            call CAV_CONC(ldbhr,nspec,q,qcav,xpt1grd(i),ypt1grd(i),
     &                    ntr,xtr,ztr,htr,flow,dpbl,hmax,
     &                    xcavgrd,ycavgrd,xshift,xshift2)
c
c ---       Assign final plume height, rise, and distance for primary
c ---       source
            heff=ztr(ntr)
            rise=htr(ntr)
            xf=xtr(ntr)
c
c ---       Reset BID and tip downwash
            tipdw=0.0

            if(nwk.LE.1 .AND. lprm) then
c             Case where primary plume is not in wake (no wake table)
              bidsq=(rise/3.5)**2
            else
c ---         The BID has been included in the wake tables
              bidsq=0.0
            endif

c ---       Report selected data to file for debug
            if(ldbhr) call WAKE_DBG(io6,ntr,xtr,ztr,rtr,htr,
     &                              .FALSE.,htstak(i))
        endif
      endif

      if(idownw(i).GE.1 .AND. ws.GE.wsdw0 .AND. mbdw.EQ.1) then
c        --------------------------------
c        --- HS/SS Downwash Section
c        --------------------------------
c ---    Get direction-specific building width and height
         index=INT(0.1*FLOAT(ivec)+0.4999)
         if(index.eq.0)index=36
         hb=bht(index,i)
         hw=bwidth(index,i)
         hl=amin1(hb,hw)
c
c ---    Assign platform height
         zplat=0.0
         if(idownw(i).EQ.2) zplat=zplatpt1(i)
c
c ---    Calculate the momentum rise at 2*hb and test for downwash
         xarg=2.*hb
         call prm(diam(i),exitw(i),fluxm,ws,istab,sqrts,xarg,
     &           xfinm,zfinm,z2hb)
         heff2=htstak(i)+z2hb
         dwtest=hb+1.5*hl
c
         if((heff2-zplat).LE.dwtest) then
c ---       Set downwash flag to ACTIVE
            idw=1
c ---       (1)  Compute sigmas at 10*hl
            xarg10=10.*hl
            xarg10km=0.001*xarg10
            targ10=xarg10/ws
            call dwsigs(tbd,hw,hb,mhftsz,ws,htstak(i),heff2,zplat,
     &                  xarg10,sy10,sz10)
c
c ---       (2)  Final Plume rise altered if Schulman-Scire (SS) active
            sstest=hb+0.5*hl
            if((htstak(i)-zplat).LT.sstest) then
c ---          Schulman-Scire downwash ACTIVE
               idw=2
c ---          Set sigmas at 3*hl
               xarg=3.*hl
               call dwsigs(tbd,hw,hb,mhftsz,ws,htstak(i),heff2,zplat,
     &                     xarg,sy3,sz3)
c ---          Determine line source parameters, ZLY and RINIT
c ---          Calculate ZLY
               if((heff2-zplat).GT.(1.2*hb)) then
                  zly=0.0
               elseif(sy3.GT.sz3) then
                  zly=rt2pi*(sy3-sz3)
               else
                  zly=0.0
               endif
c ---          Calculate initial radius of plume, RINIT
               rinit=rt2*sz3
c ---          Compute SS final plume rise
c ---          Set max distance to final rise
               xarg=amax1(xfinm,xfinb)
               call prss(xarg,zly,rinit,ws,istab,sqrts,diam(i),
     &                   exitw(i),fluxm,fluxb,xfinm,xfinb,rise)
c
c ---          Reset BID and tip downwash = 0
               bidsq=0.0
               tipdw=0.0
            endif
c
c ---       Set final plume height
            heff=htstak(i)-tipdw+rise
c
         endif
      endif

c ---------------------------------------------------------
c --- Compute the number of puffs/slugs released this hour
c --- from this source
c ---------------------------------------------------------
c --- Use CALMET/PROFILE winds at final rise to set release/sampling
c --- data and to check MFACT0 determination (slug changed to puff
c --- only if CALM is detected at both heights)
      if(metfm.EQ.1 .OR. metfm.EQ.4 .OR. metfm.EQ.5) then
         call rlsmet(ldbhr,ixs,iys,heff,mfact,
     &               mfact0fr,ilayerfr,wsfr,flowfr,ivecfr,istab,dpbl,
     &               el,ustr,wstr,tsigvfr,tsigwfr,iru,issta,sqrtsfr,
     &               idoptyfr,idoptzfr)
         mfact0=MAX0(mfact0,mfact0fr)
         wsnew=AMAX1(ws,wsfr)
      else
         wsnew=ws
      endif
c
      npnew=wsnew*xtmp1+1
      npnew=max0(npnew,1)
      npnew=min0(npnew,mxnew)
c
      if(lcav.AND.lprm) then
c ---    PRIME downwash produces both a primary and a cavity source
         newpt1(i)=2*npnew
      else
         newpt1(i)=npnew
      endif
c
      newpuf=newpuf+newpt1(i)
c --- If puff arrays are full, remove puffs that are off the grid
c --- and "roll down" arrays to make room for new puffs
c --- (this also applies to the DA file of tabulated arrays)
      if(npuffs+newpuf.gt.mxpuff) call rolldn(np)
c --- Check to see if roll-down was adequate
      if(npuffs+newpuf.gt.mxpuff)then
         write(io6,*) ' ERROR in subr. POINTS1'
         write(io6,*)'Too many puff on grid for array dimensions -- ',
     1   'NPUFFS (old puffs) = ',npuffs,' NEWPUF = ',newpuf,
     2   ' MXPUFF = ',mxpuff
         write(*,*)
         stop 'Halted in POINTS1 -- see list file.'
      endif
c
c --- DT is the time (sec) over which each puff is emitted
      dt=dthr/float(npnew)

c ---------------------------
c --- FOG processing Option
c ---------------------------
      if(MFOG.GT.0) then
c ---    Compute initial sigma consistent with volume flux
         ws3= wsnew * wsnew * wsnew
         if(ws3.GE.(vf0/dt**2)) then
            sigvf=SQRT(vf0/wsnew)/rt2pi
         else
            sigvf=((vf0*dt)**.3333333)/rt2pi
         endif
      else
         sigvf=0.0
      endif

c ------------------------------------
c --- Set initial sigmas at the source
c ------------------------------------
      szini=AMAX1(sigvf,szipt1(i))
      syini=AMAX1(sigvf,syipt1(i))

      szsrc=AMAX1(szmin,szini)
      sysrc=AMAX1(symin,syini)
c
      if(idw.EQ.3) then
c ---    PRIME: initial sigma already used
         sysrc=AMAX1(symin,syw0)
         sysrc2=AMAX1(symin,syc0)
         szsrc=AMAX1(szmin,szw0)
         szsrc2=AMAX1(szmin,szc0)
      elseif(idw.GT.0) then
c ---    Downwash is active: initial sigmas at the source must reproduce
c ---    the modified sigmas at 10 hl, using ambient growth curve.  The
c ---    modified sigmas add the downwash sigmas and any other initial
c ---    sigmas in quadrature. (HS/SS)
c
c ---    (1)  Add initial sigmas to downwash sigmas at 10 hl
         if(szini.GT.0.) then
            sigz=SQRT(szini**2+sz10**2)
         else
            sigz=sz10
         endif
         if(syini.GT.0.) then
            sigy=SQRT(syini**2+sy10**2)
         else
            sigy=sy10
         endif
c
c ---    (2)  Calculate virtual time/distance for these sigmas
         call sigtz(sigz,0.0,0.0,htstak(i),szamb,v10tz,v10dz)
         call sigty(sigy,0.0,0.0,syamb,v10ty,v10dy)
c
c ---    (3)  Set corresponding sigmas at the source (sy0dw,sz0dw)
c ---    this will allow the effects of downwash on the sigmas to
c ---    influence puff size beyond 10*hl
         ydxkm=amax1(0.0,v10dy-xarg10km)
         ydt=amax1(0.0,v10ty-targ10)
         zdxkm=amax1(0.0,v10dz-xarg10km)
         zdt=amax1(0.0,v10tz-targ10)
         call sigtz(0.0,zdxkm,zdt,htstak(i),sz0dw,virtz,virdz)
         call sigty(0.0,ydxkm,ydt,sy0dw,virty,virdy)

         sysrc=amax1(symin,sy0dw)
         szsrc=amax1(szmin,sz0dw)
      endif


c*****
      if(ldbhr)then
         write(io6,204)i,ilayer,ixs,iys,ws,istab,dpbl,issta,npnew,
     1    newpuf,dt
204      format(5x,'IS: ',i5,2x,'ILAYER: ',i3,2x,'IXS: ',i4,2x,
     1    'IYS: ',i4,2x,'WS: ',f5.1,2x,'ISTAB: ',i1,2x,'DPBL: ',
     2    f7.1,2x,'ISSTA: ',i4,2x,'NPNEW: ',i4,2x,'NEWPUF: ',i5/
     3    5x,'DT: ',f7.2)
c
         write(io6,206)htstak(i),diam(i),exitw(i),tstak(i),
c frr(09/01)
c    1    tempss(issta),dtemp,fluxb,fluxm,xf,heff,tipdw
     1    temp,dtemp,fluxb,fluxm,xf,heff,tipdw
206      format(5x,'HTSTAK: ',f6.1,2x,'DIAM: ',f6.3,2x,'EXITW: ',
     1    f6.3,2x,'TSTAK: ',f8.2,2x,'TEMPSS: ',f6.2,2x,'DTEMP: ',f8.3,
     2    2x,'FLUXB : ',f8.3,2x,'FLUXM: ',f6.1/5x,'XF: ',f6.1,2x,
     3    'HEFF: ',f6.1,2x,'TIPDW: ',f6.1)
c
         write(io6,210)idw,heff2,zly,rinit,rise
210      format(5x,'IDW: ',i5,2x,'HEFF2: ',f8.2,2x,'ZLY : ',f8.2,2x,
     1    'RINIT : ',f8.2,'RISE : ',f8.2)
         if(idownw(i).GT.0) then
            if(mbdw.EQ.2) then
               write(io6,*) 'hb,hw,index = ',dsbh,dsbw,index
               write(io6,*) 'len,[x,y]adj = ',dsbl,xadj,yadj
            else
               write(io6,*) 'hb,hw,index = ',hb,hw,index
            endif
         endif
c
         write(io6,208)i,np,idopty,idoptz,iru,sysrc,szsrc,dt,istab
208      format(5x,'I: ',i5,2x,'NP: ',i5,2x,'IDOPTY: ',i2,2x,
     1    'IDOPTZ: ',i2,2x,'IRU: ',i2,/2x,'SIGYB: ',f8.2,2x,
     2    'SIGZB: ',f8.2,2x,'DT: ',f7.2,2x,'ISTAB: ',i1)

         if(mfog.GT.0) write(io6,*)'TXSMXFOG = ',txsmxfog
      endif
c*****
c ----------------------------------------------------------
c ---    Initialize current hour's new puffs for this source
c ----------------------------------------------------------
      if((.NOT.lcav .AND. .NOT.lprm) .OR. lprm) then
         do 50 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xpt1grd(i)
         ypb(np)=ypt1grd(i)
         zitibl(np)=-1.0
         elbase(np)=elstak(i)
         sigyb(np)=sysrc
         sigzb(np)=szsrc
c ---    Final plume rise results
         zfinal(np)=heff
         zpb(np)=heff
         zpe(np)=heff
         xfinal(np)=xf
         bidfnl(np)=bidsq
c ---    Intermediate results for calc. gradual rise
         fb(np)=fluxb
         fm(np)=fluxm
         xbfin(np)=xfinb
         xmfin(np)=xfinm
         zbfin(np)=zfinb
         zmfin(np)=zfinm
         stipdw(np)=tipdw
         isplit(np)=1
c ---    Time-of-release data
         ht0(np)=htstak(i)
         exitw0(np)=exitw(i)
         diam0(np)=diam(i)
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations (downwash)
         idw0(np)=idw
         hb0(np)=hb
         hw0(np)=hw
         heff20(np)=heff2
         zly0(np)=zly
         r0(np)=rinit
         xshift0(np)=xshift
         sysrc0(np)=syini
         szsrc0(np)=szini
         sy0(np)=sysrc
         sz0(np)=szsrc

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =1 for const. point sources)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=1
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    Note that "oldest" end of slug is at the source, as is the
c ---    "newest end; oldest end moves away and grows during the step,
c ---    while newest end remains fixed in size at the source.
c
         if(mslug.EQ.1 .AND. mfact0.GT.0) then
c ---       Set coordinates of oldest end of slug (in met. grid units)
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c ------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c ------------------------------------------------------------------
         call inject(np,nspec,dt,mfact0,q,heff,hmax,dpbl,fmix,istab)
c ------------------------------------------------------------------
c ---    Transfer tabulated arrays record to DA file using full
c ---    MXRISE dimension
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

50       continue
      endif

c ---------------------------------------------------------
c --- Initialize new puffs for PRIME cavity source (idw=4)
c ---------------------------------------------------------
      if(lcav) then
      do 150 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xcavgrd
         ypb(np)=ycavgrd
         zitibl(np)=-1.0
         elbase(np)=elstak(i)
         sigyb(np)=sysrc2
         sigzb(np)=szsrc2
         stipdw(np)=tipdw
         isplit(np)=1
c ---    Time-of-release data
c ---    Set release ht to building ht for this cavity source (puffs
c ---    are released at ZERO, but are initially advected with wind
c ---    at building ht)
         ht0(np)=dsbh
         exitw0(np)=0.0
         diam0(np)=0.0
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations (downwash)
         idw0(np)=4
         hb0(np)=dsbh
         hw0(np)=dsbw
         xshift0(np)=xshift2
         sysrc0(np)=0.0
         szsrc0(np)=0.0
         sy0(np)=sysrc2
         sz0(np)=szsrc2

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =1 for const. point sources)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=1
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    Note that "oldest" end of slug is at the source, as is the
c ---    "newest end; oldest end moves away and grows during the step,
c ---    while newest end remains fixed in size at the source.
c
         if(mslug.EQ.1 .AND. mfact0.GT.0) then
c ---       Set coordinates of oldest end of slug (in met. grid units)
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c ------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c ------------------------------------------------------------------
         call inject(np,nspec,dt,mfact0,qcav,0.0,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer tabulated arrays record to DA file using full
c ---    MXRISE dimension
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

150   continue
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine points2(i,nspec,dthr,xtmp1,ldbhr,mfact,metfm,np,
     &                   newpuf,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 151214                POINTS2
c                J. Scire, D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Initialize newly released puff/slug variables for
c               POINT SOURCES with VARIABLE emissions
c
c --- UPDATE
c --- V5.8.4-V5.8.5 151214  (CDA): Add calls to WAKE_CSIG to set
c                                  dispersion data for release ht and
c                                  for building top
c --- V5.834-V5.8.4 130731  (EPA): Add idownw as a screen for debug
c                                  writes so that unassigned downwash
c                                  variables are not written to list
c                                  file
c                           (EPA): Set BID to zero for PRIME sources as
c                                  wake tables now include BID, and add
c                                  HTR to CAV_CONC call
c --- V5.833-V5.8.4 130731  (EPA): Add maximum lid height for mass above
c                                  Zi to CAV_CONC arguments for later
c                                  use in VCOUP
c --- V5.832-V5.8.4 130731  (EPA): Do not adjust Briggs plume rise for
c                                  shear when distance to final rise is
c                                  zero (near-calm)
c                           (EPA): Write more digits for TSTAK, DTEMP
c                                  debug output
c --- V5.831-V5.8.4 130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c --- V5.82-V5.8.4  130731  (EPA): Place rise tables in DA file
c --- V5.760-V5.8.4 130731  (EPA): Initialize variables
c                                  INDEX = 0
c --- V5.75-V5.760  070605  (DGS): Initialize variables
c                                  HB, HW, HEFF2, ZLY, RINIT = 0.0
c                   070605  (DGS): Fix debug output index from J to I
c                   070605  (DGS): Fix name of IRU used in PRIME section
c                                  when the meteorology at building-ht
c                                  is extracted (IRUB was not defined)
c --- V5.74-V5.75   050225  (DGS): add platform adjustment to ISC
c                                  building downwash (MBDW=1)
c                   050225  (DGS): Add DPBL arg to SETCSIG for TAULY
c --- V5.72-V5.74   040715  (DGS): add METFM=5 (AERMET)
c --- V5.7-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.5-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c                   030402  (DGS): implement PRIME downwash option
c --- V5.4-V5.5     010730  (DGS): store initial sigmas from PTEMARB
c                                  file in SYSRC0 and SZSRC0 for use
c                                  in downwash zone
c                   010730  (DGS): revise building-array index to match
c                                  ISC
c --- V5.4-V5.4     000602_8 (DGS): add constraint that buoyancy flux
c                                   (FLUXB) be greater than zero
c                                   to conditions that must be met for
c                                   calling partial penetration sub.
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c                   000602  (DGS): add initial sigmay,z arrays
c                   000602  (DGS): add MFOG option to process emissions
c                                  file from CTEMISS
c --- V5.0-V5.3     991222b (DGS): reset momentum flux using FMFAC
c                   991222b (DGS): pass momentum flux to STKTIP
c --- V5.0-V5.0     980807  (DGS): use final rise CALMET/PROFILE winds
c                                  to set release step
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V5.0-V5.0     980430  (DGS): assign PROBLEM (compiler warning)
c --- V5.0-V5.0     980304  (DGS): place source sigmas in SY0,SZ0
c --- V4.0-V5.0     971107  (DGS): modify partial penetration logic to
c                                  be consistent with POINTS1
c                   971107  (DGS): add building downwash
c                   971107  (DGS): remove volume flux from PT2 input
c                                  processing
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c                   971107  (DGS): add observed inversion strength
c
c --- INPUTS:
c             I - integer - Point source index
c         NSPEC - real    - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         XTMP1 - real    -
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c         METFM - integer - Meteorological data format
c            NP - integer - Index of last puff/slug initialized
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW, SYMIN, SZMIN, PTG0(2), WSCALM, TBD, PLX0
c     Common block /DISPDAT/ variables:
c           JSUP
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MTIP, MSHEAR, MPARTL, MHFTSZ, MFOG, MBDW
c     Common block /FOG/ variables:
c           TXSMXFOG
c     Common block /GRID/ variables:
c           IBCOMP, IECOMP, JBCOMP, JECOMP
c     Common block /METHD/ variables:
c           LCALGRD, I2DMET
c     Common block /METHR/ variables:
c           PLEXP, PTG(2), DPTINVO
c     Common block /PUFF/ variables:
c           NPUFFS
c     Common block /PT2/ variables:
c           TIEM2(8,mxpt2), NPT2, TSTAK2(mxpt2), EXITW2(mxpt2),
c           QSTAK2(mxspec,mxpt2), BHT2(36,mxpt2), BWD2(36,mxpt2),
c           BLN2(36,mxpt2),XBADJ2(36,mxpt2),YBADJ2(36,mxpt2),
c           SYIPT2(mxpt2),SZIPT2(mxpt2)
c           ZPLATPT2(mxpt2)
c     Parameters:
c           MXNX, MXNY, MXNZ, MXNZP1, MXPT2,  MXRISE, IO6
c
c --- OUTPUT:
c            NP - integer - UPDATED index of last puff/slug initialized
c        NEWPUF - integer - UPDATED number of new puffs/slugs released
c                           during the current time step
c       PROBLEM - logical - Set true if fatal problem encountered
c
c     Common block /FOG/ variables:
c           TXSMXFOG
c     Common block /PT2/ variables:
c           NEWPT2(mxpt2)
c     Common block /PUFF/ variables:
c           all variables in common block
c     Common block /SLUG/ variables:
c           all variables in common block
c     Common block /SRCTAB/ variables:
c           NTR, NWK, NCV,
c           XTR(mxrise),ZTR(mxrise),RTR(mxrise),HTR(mxrise),
c           XWK(mxrise),SYWK(mxrise),SZWK(mxrise),DRWK(mxrise),
c           XCV(mxrise),SYCV(mxrise),SZCV(mxrise)
c
c --- POINTS2 called by:  INITPUF
c --- POINTS2 calls:      RLSMET, ROLLDN, PTLAPS, SETCSIG, SIGTY,
c                         SIGTZ, STKTIP, DWSIGS, PRSS, PRFIN, PRM,
c                         PRFINSH, SWAP, INJECT,
c                         WAKE_INI, NUMMET, NUMRISE, CAV_CONC, WAKE_DBG
c                         ZEROTAB, SRCTABOUT
c                         WAKE_CSIG
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      include 'comparm.puf'
      include 'csigma.puf'
      include 'dispdat.puf'
      include 'flags.puf'
      include 'fog.puf'
      include 'grid.puf'
      include 'methd.puf'
      include 'methr.puf'
      include 'puff.puf'
      include 'pt2.puf'
      include 'slug.puf'
      include 'srctab.puf'
c
      real q(mxspec),qcav(mxspec)
      logical ldbhr,problem

c --- PRIME logicals to configure primary (LPRM) and cavity (LCAV) puff
      logical lprm,lcav
c
      data rt2/1.4142136/, rt2pi/2.5066283/, piby4/0.7853982/
c --- Set minimum allowed potential temperature gradient PTGRAD0,
      data ptgrad0/.005/
c --- Set minimum allowed wind speed for building downwash
      data wsdw0/1.0/

c --- Initialize local ISC building downwash variables
      index=0
      hb=0.0
      hw=0.0
      heff2=0.0
      zly=0.0
      rinit=0.0

c --- Transfer selected data from TIEM2 array for clarity
      xgrd=tiem2(1,i)
      ygrd=tiem2(2,i)
      htstak=tiem2(3,i)
      diam=tiem2(4,i)
      elstak=tiem2(5,i)
      idownw=NINT(tiem2(6,i))
      fmfpt2=tiem2(7,i)
c
c ***
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'POINTS2:  Source Number    ',i
         write(io6,*) '--------'
      endif
c ***
c --- Swap emission rate for source 'i' into 1D array
      qsum=0.0
      do is=1,nspec
         q(is)=qstak2(is,i)
         qsum=qsum+q(is)
      enddo
c --- Return without generating new puffs if all species have zero
c --- mass in puff
      if(qsum.EQ.0.0) then
         newpt2(i)=0
         return
      endif
c
c --- Determine the met. grid point closest to the stack
      ixs=1.0+xgrd
      iys=1.0+ygrd
c
c --- Source off the computational grid -- write a WARNING
      if(ixs.lt.ibcomp.or.ixs.gt.iecomp.or.iys.lt.jbcomp.or.iys.gt.
     1   jecomp)then
         write(io6,20)i,ixs,iys
20       format(/1x,'Warning -- a point source with variable emissions',
     1   ' is off the computational grid'/1x,'source no. (i) = ',i6,2x,
     2   'nearest grid point (ixs,iys) = (',i5,',',i5,')')
c
c ---    Don't emit from this source, but continue executing
         newpt2(i)=0
c ---    Retain current value of PROBLEM
         problem=problem
         return

      endif
c
c --- Extract stack height wind speed & other met. variables
c --- and set CALM configuration if triggered
      call RLSMET(ldbhr,ixs,iys,htstak,mfact,
     &            mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &            ustr,wstr,tsigv,tsigw,iru,issta,sqrts,idopty,idoptz)
c
c frr (09/01) new calmet format (2D temp)
      if(i2dmet.EQ.1) then
         temp=temp2d(ixs,iys)
      elseif(i2dmet.EQ.0) then
         temp=tempss(issta)
      else
         write(*,*)'Subr. POINTS2:  Invalid I2DMET = ',i2dmet
         stop
      endif
c
c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif

c --- Initialize source tabulation arrays to zero
      call ZEROTAB
c
c -------------------------------------------------------------
c --- Compute the final plume rise and distance to final rise
c -------------------------------------------------------------
c --- Calculate fluxes
      dtemp=tstak2(i)-temp
      dtemp=amax1(dtemp,0.0)
c --- Buoyancy flux:  2.4516625 = g/4., where g = 9.80665 m/s**2
      fluxb=(2.4516625*diam**2*exitw2(i)/tstak2(i))*dtemp
c --- Momentum flux
      fluxm=0.25*(exitw2(i)*diam)**2*temp/tstak2(i)
c --- Apply vertical momentum flux factor of zero or one
c --- Use simple test for ZERO instead of forming the product:
c ---     fluxm=fluxm*fmfpt2
      if(fmfpt2.LT.0.5) fluxm=0.0
c
c --- Adjustment for stack-tip downwash (NOT for bldg downwash!)
      if(mtip.EQ.1) then
         call stktip(htstak,diam,fluxm,exitw2(i),ws,tipdw)
      else
         tipdw=0.0
      endif
c
c --- Final plume rise (no downwash considered)
      call prfin(exitw2(i),diam,fluxm,fluxb,ws,istab,sqrts,
     &           xfinm,xfinb,xf,zfinm,zfinb,rise)
c
c --- Compute vertical wind shear effects
      if(mshear.eq.1 .AND. xfinb.GT.0.0)then
         call prfinsh(fluxb,ws,plx,htstak,xfinb,istab,sqrts,
     1    zfinsh)
c ---     Final buoyant rise is the LOWER of the Briggs & shear hts.
          zfinb=amin1(zfinb,zfinsh)
c ---     Final plume rise is the HIGHER of the momentum & buoyant hts.
          rise=amax1(zfinb,zfinm)
      endif
c
c --- Adjust for partial penetration of elevated stable layer
c     if(mpartl.EQ.1 .and. istab.LE.3 .and. htstak.LT.dpbl) then
      if(mpartl.EQ.1 .and. istab.LE.4 .and. fluxb.GT.0.0) then
c ---    Set thickness (m) of transition region above mixing height
         dzinv=30.
c ---    Estimate potential temperature gradient above mixed layer
         if(LCALGRD) then
c ---       Use temperatures provided by met model
            htinv=amax1(dpbl,htstak)
            call ptlaps(ixs,iys,htinv,ptgrad0,dzinv,ptginv,tmix)
         else
c ---       Use default potential temperature lapse rate
            if(jsup.LE.4) then
               ptginv=ptgrad0
            elseif(jsup.EQ.5) then
               ptginv=amax1(ptg0(1),ptgrad0)
            else
               ptginv=amax1(ptg0(2),ptgrad0)
            endif
         endif
c ---    Estimate potential temperature change across inversion
         if(dptinvo.GT.0.0) then
c ---       Use observed value provided in met file
            dptinv=dptinvo
         else
            dptinv=ptginv*dzinv
         endif
c frr    call prfpp(rise,fluxb,ws,htstak,dpbl,tempss(issta),ptginv,
         call prfpp(rise,fluxb,ws,htstak,dpbl,temp,ptginv,
     &              dptinv,fmix,hmax)
c ---    Reset component final rise heights for use in gradual rise
         if(zfinb.GT.rise) zfinb=rise
         if(zfinm.GT.rise) zfinm=rise
c
      else
         fmix=1.0
         hmax=dpbl
      endif
c
c --- Set variance associated with buoyancy-enhanced growth @ final rise
      bidsq=(rise/3.5)**2
c
c --- Set final plume height
      heff=htstak-tipdw+rise
c
c --- Set selected data in /CSIGMA/ for sigma calls
      call SETCSIG(idopty,idoptz,iru,ws,istab,el,sqrts,
     &             tsigv,tsigw,symin,szmin,heff,dpbl)
c
c --------------------------------------------------------------------
c --- Determine if building downwash effects on plume rise and sigmas
c --- should be considered
c --------------------------------------------------------------------
      sz0dw=0.0
      sy0dw=0.0
      xshift=0.0
      xshift2=0.0
      lprm=.FALSE.
      lcav=.FALSE.
c --- Initialize downwash flag to zero (no building downwash)
c --- Note:  idw=0  no downwash
c ---        idw=1  Huber-Snyder model
c ---        idw=2  Schulman-Scire model
c ---        idw=3  PRIME model (puff released from primary source)
c ---        idw=4  PRIME model (puff released from cavity source)
      idw=0

      if(idownw.EQ.1 .AND. ws.GE.wsdw0 .AND. mbdw.EQ.2) then
c        --------------------------------
c        --- PRIME Downwash Section
c        --------------------------------
         mprime=1

c ---       Store dispersion data for release height for later use
            zht=heff

            call WAKE_CSIG(idopty,idoptz,iru,ws,istab,el,
     &                     sqrts,tsigv,tsigw,symin,szmin,
     &                     zht,dpbl,'RELEASE ')

c ---    Get direction-specific building data (direction at stack ht)
         index=INT(0.1*FLOAT(ivec)+0.4999)
         if(index.eq.0)index=36
         dsbh=bht2(index,i)
         dsbw=bwd2(index,i)
         dsbl=bln2(index,i)
         xadj=xbadj2(index,i)
         yadj=ybadj2(index,i)
         hl=AMIN1(dsbh,dsbw)
c ---    Screen for GEP stack (regulatory definition)
         geptest=dsbh+1.5*hl
         if(htstak.LT.geptest) then
            idw=3
c ---       Set stack radius
            reff=0.5*diam
c ---       Set met data at top of building
            call RLSMET(ldbhr,ixs,iys,dsbh,mfact,
     &                  mfact0b,ilayer,wsb,flowb,ivecb,istabb,dpbl,
     &                  elb,ustrb,wstrb,tsigvb,tsigwb,iru,issta,
     &                  sqrtsb,idoptyb,idoptzb)

c ---       Reset /CSIGMA/ data for met data at top of building
            zht=AMAX1(heff,dsbh)
            call SETCSIG(idoptyb,idoptzb,iru,wsb,istabb,elb,sqrtsb,
     &                   tsigvb,tsigwb,symin,szmin,zht,dpbl)

c ---          Store dispersion data for top of building for later use
               call WAKE_CSIG(idoptyb,idoptzb,iru,wsb,istabb,elb,
     &                        sqrtsb,tsigvb,tsigwb,symin,szmin,
     &                        zht,dpbl,'BUILDING')

c ---       Refresh /WAKEDAT/ variables
            call WAKE_INI(ldbhr,istab,iru,dsbh,dsbw,dsbl,xadj,yadj,
     &                    wsb,ws,tsigvb,tsigwb,idoptyb,idoptzb)
c ---       Construct met. profiles at this grid cell
            call NUMMET(ixs,iys,ldbhr)
c ---       Compute plume rise and wake structure
c ---       Use full MXRISE points in rise table
            ntr=mxrise
            call NUMRISE(mprime,ldbhr,htstak,tstak2(i),reff,exitw2(i),
     &                   syipt2(i),szipt2(i),ntr,xtr,ztr,rtr,htr)
c ---       Pass final wake structure to source arrays with BID
            call WAKE_FIN(ldbhr,nwk,xwk,szwk,sywk,drwk,szw0,syw0,
     &                    ncv,xcv,szcv,sycv,szc0,syc0,fqcvpt2(i))
c
c ---       Set logicals (primary & cavity) and partition mass
            if(fqcvpt2(i).LE.0.001) then
               lcav=.FALSE.
               lprm=.TRUE.
               do is=1,nspec
                  qcav(is)=0.0
               enddo
            elseif(fqcvpt2(i).GE.0.999) then
               lcav=.TRUE.
               lprm=.FALSE.
               do is=1,nspec
                  qcav(is)=q(is)
                  q(is)=0.0
               enddo
            else
               lcav=.TRUE.
               lprm=.TRUE.
               do is=1,nspec
                  qcav(is)=q(is)*fqcvpt2(i)
                  q(is)=q(is)-qcav(is)
               enddo
            endif

c ---       Compute near-cavity concentrations for current source,
c ---       return location of cavity source on the met grid, and
c ---       return the distance from the source to the end of the
c ---       cavity transition zone
            call CAV_CONC(ldbhr,nspec,q,qcav,xgrd,ygrd,
     &                    ntr,xtr,ztr,htr,flow,dpbl,hmax,
     &                    xcavgrd,ycavgrd,xshift,xshift2)
c
c ---       Assign final plume height, rise, and distance for primary
c ---       source
            heff=ztr(ntr)
            rise=htr(ntr)
            xf=xtr(ntr)
c
c ---       Reset BID and tip downwash
            tipdw=0.0

            if(nwk.LE.1 .AND. lprm) then
c             Case where primary plume is not in wake (no wake table)
              bidsq=(rise/3.5)**2
            else
c ---         The BID has been included in the wake tables
              bidsq=0.0
            endif
c
c ---       Report selected data to file for debug
            if(ldbhr) call WAKE_DBG(io6,ntr,xtr,ztr,rtr,htr,
     &                             .FALSE.,htstak)
         endif
      endif

      if(idownw.GE.1 .AND. ws.GE.wsdw0 .AND. mbdw.EQ.1) then
c     --------------------------------
c     --- HS/SS Downwash Section
c     --------------------------------
c ---    Set direction-specific building width and height
         index=INT(0.1*FLOAT(ivec)+0.4999)
         if(index.eq.0)index=36
         hb=bht2(index,i)
         hw=bwd2(index,i)
         hl=amin1(hb,hw)
c
c ---    Assign platform height
         zplat=0.0
         if(idownw.EQ.2) zplat=zplatpt2(i)

c ---    Calculate the momentum rise at 2*hb and test for downwash
         xarg=2.*hb
         call prm(diam,exitw2(i),fluxm,ws,istab,sqrts,xarg,
     &           xfinm,zfinm,z2hb)
         heff2=htstak+z2hb
         dwtest=hb+1.5*hl
c
         if((heff2-zplat).LE.dwtest) then
c ---       Set downwash flag to ACTIVE
            idw=1
c ---       (1)  Compute downwash sigmas at 10*hl for setting up
c ---       virtual sigmas at the source
            xarg10=10.*hl
            xarg10km=0.001*xarg10
            targ10=xarg10/ws
            call dwsigs(tbd,hw,hb,mhftsz,ws,htstak,heff2,zplat,xarg10,
     &                  sy10,sz10)
c
c ---       (2)  Alter Final Plume rise if Schulman-Scire (SS) active
            sstest=hb+0.5*hl
            if((htstak-zplat).LT.sstest) then
c ---          Schulman-Scire downwash ACTIVE
               idw=2
c ---          Set sigmas at 3*hl
               xarg=3.*hl
               call dwsigs(tbd,hw,hb,mhftsz,ws,htstak,heff2,zplat,xarg,
     &                     sy3,sz3)
c ---          Determine line source parameters, ZLY and RINIT
c ---          Calculate ZLY
               if((heff2-zplat).GT.(1.2*hb)) then
                  zly=0.0
               elseif(sy3.GT.sz3) then
                  zly=rt2pi*(sy3-sz3)
               else
                  zly=0.0
               endif
c ---          Calculate initial radius of plume, RINIT
               rinit=rt2*sz3
c ---          Compute SS final plume rise
c ---          Set max distance to final rise
               xarg=amax1(xfinm,xfinb)
               call prss(xarg,zly,rinit,ws,istab,sqrts,diam,
     &                   exitw2(i),fluxm,fluxb,xfinm,xfinb,rise)
c
c ---          Reset BID and tip downwash = 0
               bidsq=0.0
               tipdw=0.0
            endif
c
c ---       Set final plume height
            heff=htstak-tipdw+rise
c
         endif
      endif
c
c ---------------------------------------------------------
c --- Compute the number of puffs/slugs released this hour
c --- from this source
c ---------------------------------------------------------
c --- Use CALMET/PROFILE winds at final rise to set release/sampling
c --- data and to check MFACT0 determination (slug changed to puff
c --- only if CALM is detected at both heights)
      if(metfm.EQ.1 .OR. metfm.EQ.4 .OR. metfm.EQ.5) then
         call RLSMET(ldbhr,ixs,iys,heff,mfact,
     &               mfact0fr,ilayerfr,wsfr,flowfr,ivecfr,istab,dpbl,el,
     &               ustr,wstr,tsigvfr,tsigwfr,iru,issta,sqrtsfr,
     &               idoptyfr,idoptzfr)
         mfact0=MAX0(mfact0,mfact0fr)
         wsnew=AMAX1(ws,wsfr)
      else
         wsnew=ws
      endif
c
      npnew=wsnew*xtmp1+1
      npnew=max0(npnew,1)
      npnew=min0(npnew,mxnew)
c
      if(lcav.AND.lprm) then
c ---    PRIME downwash produces both a primary and a cavity source
         newpt2(i)=2*npnew
      else
         newpt2(i)=npnew
      endif

      newpuf=newpuf+newpt2(i)
c --- If puff arrays are full, remove puffs that are off the grid
c --- and "roll down" arrays to make room for new puffs
c --- (this also applies to the DA file of tabulated arrays)
      if(npuffs+newpuf.gt.mxpuff) call rolldn(np)

c --- Check to see if roll-down was adequate
      if(npuffs+newpuf.gt.mxpuff)then
         write(io6,*) ' ERROR in subr. POINTS2'
         write(io6,*)'Too many puff on grid for array dimensions -- ',
     1   'NPUFFS (old puffs) = ',npuffs,' NEWPUF = ',newpuf,
     2   ' MXPUFF = ',mxpuff
         write(*,*)
         stop 'Halted in POINTS2 -- see list file.'
      endif
c
c --- DT is the time (sec) over which each puff is emitted
      dt=dthr/float(npnew)

c ---------------------------
c --- FOG processing Option
c ---------------------------
      if(MFOG.GT.0) then
c ---    Screen for minimum temperature excess
         txsmxfog=AMIN1(txsmxfog,dtemp)
c ---    Compute initial sigma consistent with volume flux
         vf0=piby4*exitw2(i)*diam**2
         ws3= wsnew * wsnew * wsnew
         if(ws3.GE.(vf0/dt**2)) then
            sigvf=SQRT(vf0/wsnew)/rt2pi
         else
            sigvf=((vf0*dt)**.3333333)/rt2pi
         endif
      else
         sigvf=0.0
      endif

c ------------------------------------
c --- Set initial sigmas at the source
c ------------------------------------
      szini=AMAX1(sigvf,szipt2(i))
      syini=AMAX1(sigvf,syipt2(i))

      szsrc=AMAX1(szmin,szini)
      sysrc=AMAX1(symin,syini)

      if(idw.EQ.3) then
c ---    PRIME: set values without initial sigma option
         sysrc=AMAX1(symin,syw0)
         sysrc2=AMAX1(symin,syc0)
         szsrc=AMAX1(szmin,szw0)
         szsrc2=AMAX1(szmin,szc0)

      elseif(idw.GT.0) then
c ---    Downwash is active: initial sigmas at the source must reproduce
c ---    the modified sigmas at 10 hl, using ambient growth curve.  The
c ---    modified sigmas add the downwash sigmas and any other initial
c ---    sigmas in quadrature.
c
c ---    (1)  Add initial sigmas to downwash sigmas at 10 hl
         if(szini.GT.0.) then
            sigz=SQRT(szini**2+sz10**2)
         else
            sigz=sz10
         endif
         if(syini.GT.0.) then
            sigy=SQRT(syini**2+sy10**2)
         else
            sigy=sy10
         endif
c
c ---    (2)  Calculate virtual time/distance for these sigmas
         call sigtz(sigz,0.0,0.0,htstak,szamb,v10tz,v10dz)
         call sigty(sigy,0.0,0.0,syamb,v10ty,v10dy)
c
c ---    (3)  Set corresponding sigmas at the source (sy0dw,sz0dw)
c ---    this will allow the effects of downwash on the sigmas to
c ---    influence puff size beyond 10*hl
         ydxkm=amax1(0.0,v10dy-xarg10km)
         ydt=amax1(0.0,v10ty-targ10)
         zdxkm=amax1(0.0,v10dz-xarg10km)
         zdt=amax1(0.0,v10tz-targ10)
         call sigtz(0.0,zdxkm,zdt,htstak,sz0dw,virtz,virdz)
         call sigty(0.0,ydxkm,ydt,sy0dw,virty,virdy)

         sysrc=amax1(symin,sy0dw)
         szsrc=amax1(szmin,sz0dw)
      endif

c******
      if(ldbhr)then
         write(io6,204)i,ilayer,ixs,iys,ws,istab,dpbl,issta,npnew,
     1    newpuf,dt
204      format(5x,'IS: ',i5,2x,'ILAYER: ',i3,2x,'IXS: ',i4,2x,
     1    'IYS: ',i4,2x,'WS: ',f5.1,2x,'ISTAB: ',i1,2x,'DPBL: ',
     2    f7.1,2x,'ISSTA: ',i4,2x,'NPNEW: ',i4,2x,'NEWPUF: ',i5/
     3    5x,'DT: ',f7.2)
c
         write(io6,206)htstak,diam,exitw2(i),tstak2(i),
cfrr 1    tempss(issta),dtemp,fluxb,fluxm,xf,heff,tipdw
     1    temp,dtemp,fluxb,fluxm,xf,heff,tipdw
206      format(5x,'HTSTAK: ',f6.1,2x,'DIAM: ',f6.3,2x,'EXITW: ',
     1    f6.3,2x,'TSTAK: ',f8.2,2x,'TEMPSS: ',f6.2,2x,'DTEMP: ',f8.3,
     2    2x,'FLUXB : ',f8.3,2x,'FLUXM: ',f6.1/5x,'XF: ',f6.1,2x,
     3    'HEFF: ',f6.1,2x,'TIPDW: ',f6.1)
c
         write(io6,210)idw,rise
210      format(5x,'IDW: ',i5,2x,'RISE : ',f8.2)
         if(idownw.GT.0) then
            if(mbdw.EQ.2) then
               write(io6,*) 'hb,hw,index = ',dsbh,dsbw,index
               write(io6,*) 'len,[x,y]adj = ',dsbl,xadj,yadj
            else
               write(io6,*) 'hb,hw,index = ',hb,hw,index
            endif
         endif
c
         write(io6,208)i,np,iru,sysrc,szsrc,dt,istab
208      format(5x,'I: ',i5,2x,'NP: ',i5,2x,
     1    'IRU: ',i2,2x,'SIGYB: ',f8.2,2x,'SIGZB: ',f8.2,2x/
     2    5x,'DT: ',f7.2,2x,'ISTAB: ',i1)
         if(mfog.GT.0) write(io6,*)'TXSMXFOG = ',txsmxfog
      endif
c*****
c ----------------------------------------------------------
c ---    Initialize current hour's new puffs for this source
c ----------------------------------------------------------
      if((.NOT.lcav .AND. .NOT.lprm) .OR. lprm) then
         do 50 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xgrd
         ypb(np)=ygrd
         zitibl(np)=-1.0
         elbase(np)=elstak
         sigyb(np)=sysrc
         sigzb(np)=szsrc
c ---    Final plume rise results
         zfinal(np)=heff
         zpb(np)=heff
         zpe(np)=heff
         xfinal(np)=xf
         bidfnl(np)=bidsq
c ---    Intermediate results for calc. gradual rise
         fb(np)=fluxb
         fm(np)=fluxm
         xbfin(np)=xfinb
         xmfin(np)=xfinm
         zbfin(np)=zfinb
         zmfin(np)=zfinm
         stipdw(np)=tipdw
         isplit(np)=1
c ---    Time-of-release data
         ht0(np)=htstak
         exitw0(np)=exitw2(i)
         diam0(np)=diam
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations (downwash)
         idw0(np)=idw
         hb0(np)=hb
         hw0(np)=hw
         heff20(np)=heff2
         zly0(np)=zly
         sysrc0(np)=syini
         szsrc0(np)=szini
         r0(np)=rinit
         xshift0(np)=xshift
         sy0(np)=sysrc
         sz0(np)=szsrc

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =2 for point sources with VARIABLE emiss.)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=2
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    Note that "oldest" end of slug is at the source, as is the
c ---    "newest end; oldest end moves away and grows during the step,
c ---    while newest end remains fixed in size at the source.
c
         if(mslug.EQ.1 .AND. mfact0.GT.0) then
c ---       Set coordinates of oldest end of slug (in met. grid units)
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c ------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c ------------------------------------------------------------------
         call inject(np,nspec,dt,mfact0,q,heff,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer tabulated arrays record to DA file using full
c ---    MXRISE dimension
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

50       continue
      endif

c ---------------------------------------------------------
c --- Initialize new puffs for PRIME cavity source (idw=4)
c ---------------------------------------------------------
      if(lcav) then
      do 150 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xcavgrd
         ypb(np)=ycavgrd
         zitibl(np)=-1.0
         elbase(np)=elstak
         sigyb(np)=sysrc2
         sigzb(np)=szsrc2
         stipdw(np)=tipdw
         isplit(np)=1
c ---    Time-of-release data
c ---    Set release ht to building ht for this cavity source (puffs
c ---    are released at ZERO, but are initially advected with wind
c ---    at building ht)
         ht0(np)=dsbh
         exitw0(np)=0.0
         diam0(np)=0.0
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations (downwash)
         idw0(np)=4
         hb0(np)=dsbh
         sysrc0(np)=0.0
         szsrc0(np)=0.0
         hw0(np)=dsbw
         xshift0(np)=xshift2
         sy0(np)=sysrc2
         sz0(np)=szsrc2

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =2 for point sources with VARIABLE emiss.)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=2
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    Note that "oldest" end of slug is at the source, as is the
c ---    "newest end; oldest end moves away and grows during the step,
c ---    while newest end remains fixed in size at the source.
c
         if(mslug.EQ.1 .AND. mfact0.GT.0) then
c ---       Set coordinates of oldest end of slug (in met. grid units)
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c ------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c ------------------------------------------------------------------
         call inject(np,nspec,dt,mfact0,qcav,0.0,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer tabulated arrays record to DA file using full
c ---    MXRISE dimension
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

150   continue
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine lines1(nspec,dthr,xtmp1,ldbhr,mfact,metfm,np,
     &                  newpuf,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 LINES1
c                J. Scire, D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Initialize newly released puff/slug variables for
c               LINE SOURCES with constant emissions
c
c --- UPDATE
c --- V5.831-V5.8.4 130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c                           (EPA): Apply minimum floor to the downwash
c                                  sigmas stored in SY0,SZ0 arrays
c                           (EPA): initialize variables written in debug
c                                  output that may not be computed in
c                                  loop over lines (thalf,xhalfkm,
c                                  syhalf,szhalf)
c --- V5.75-V5.8.4  130731  (EPA): Place rise tables in DA file
c --- V5.74-V5.75   050225  (DGS): Add DPBL arg to SETCSIG for TAULY
c --- V5.72-V5.74   040715  (DGS): add METFM=5 (AERMET)
c --- V5.7-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.4-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c --- V5.0-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.0     980807  (DGS): use final rise CALMET/PROFILE winds
c                                  to set release step
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V5.0-V5.0     980304  (DGS): drop any new puffs if emissions = 0
c --- V4.0-V5.0     971107  (DGS): add variable emissions factor call
c                                  to function VEMFAC
c                   971107  (DGS): alter calling arg for SETLINE, used
c                                  for both LINES1 and LINES2
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c
c --- INPUTS:
c         NSPEC - real    - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         XTMP1 - real    -
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c         METFM - integer - Meteorological data format
c            NP - integer - Index of last puff/slug initialized
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW, SYMIN, SZMIN, WSCALM, PLX0
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MTIP, MHFTSZ, MSHEAR
c     Common block /GRID/ variables:
c           DGRID, IBCOMP, IECOMP, JBCOMP, JECOMP
c     Common block /LN1/ variables:
c           NLINES,XL,HBL,WBL,WML,DXL,FPRIMEL,WSEP,FPTOT,FBPT,
c           XLBEGGRD(mxlines),YLBEGGRD(mxlines),XLENDGRD(mxlines),
c           YLENDGRD(mxlines),HSL(mxlines),BELEVL(mxlines),
c           XLBAR,YLBAR,ORIENTL,MXNSEG,QTL(mxspec,mxlines),
c           NLRISE,XLRISE(mxrise,2),ZLRISE(mxrise,2),
c           ivln1(mxspec,mxlines),iq12ln1(mxspec,mxlines)
c     Common block /METHR/ variables:
c           PLEXP
c     Common block /METHD/ variables:
c           I2DMET
c     Common block /PUFF/ variables:
c           NPUFFS
c     Parameters:
c           MXNX, MXNY, MXNZ, MXNZP1, MXLINES, MXSPEC, MXRISE, IO6
c
c --- OUTPUT:
c            NP - integer - UPDATED index of last puff/slug initialized
c        NEWPUF - integer - UPDATED number of new puffs/slugs released
c                           during the current time step
c       PROBLEM - logical - Set true if fatal problem encountered
c
c     Common block /LN1/ variables:
c           NEWLN1(mxline), NSEG(mxlines),
c     Common block /PUFF/ variables:
c           all variables in common block
c     Common block /SLUG/ variables:
c           all variables in common block
c     Common block /SRCTAB/ variables:
c           NTR, XTR(mxrise), ZTR(mxrise)
c
c --- LINES1 called by:  INITPUF
c --- LINES1 calls:      RLSMET, ROLLDN, HEFTRAN, SIGTY, SIGTZ, SETLINE,
c                        SETCSIG, SWAP, INJECT, VEMFAC, ZEROTAB,
c                        SRCTABOUT
c----------------------------------------------------------------------
c
      include 'params.puf'

      include 'comparm.puf'
      include 'csigma.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'methr.puf'
      include 'ln1.puf'
      include 'puff.puf'
      include 'slug.puf'
c frr(09/01)
      include 'methd.puf'
      include 'srctab.puf'

      real q(mxspec)
      logical ldbhr,problem,lcalm

c --- Set minimum allowed wind speed for building downwash (.GE.1)
      data wsdw0/1.0/

      data oneby2pi/0.1591549/,rt2pi/2.5066283/,rt2bypi/0.7978846/
      data zero/0.0/


c ***
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'LINES1:  Processing 1 Group of ',nlines,' lines'
      endif
c ***
c
c -------------------------------------------------------------------
c --- Get met data for block of line sources
c -------------------------------------------------------------------
c
c --- Determine the met. grid point closest to the CENTER of the array
c --- of line sources
      ixs=1.0+xlbar
      iys=1.0+ylbar
c
c --- Source off the computational grid -- write a FATAL message
      if(ixs.lt.ibcomp.or.ixs.gt.iecomp.or.iys.lt.jbcomp.or.iys.gt.
     1   jecomp)then
         i=1
         write(io6,20)i,ixs,iys
20       format(/1x,'FATAL -- a line source with constant emissions ',
     1   'is off the computational grid'/1x,'source no. (i) = ',i6,2x,
     2   'nearest grid point (ixs,iys) = (',i5,',',i5,')')
         problem=.TRUE.
         return
      endif
c
c --- Initialize source tabulation arrays to zero
      call ZEROTAB
c
c --- Extract wind speed & other met. variables;
c --- and set CALM configuration if triggered
      call rlsmet(ldbhr,ixs,iys,hbl,mfact,
     &            mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &            ustr,wstr,tsigv,tsigw,iru,issta,sqrts,idopty,idoptz)
c
c frr (09/01) new calmet format (2D temp)
      if(i2dmet.EQ.1) then
         temp=temp2d(ixs,iys)
      elseif(i2dmet.EQ.0) then
         temp=tempss(issta)
      else
         write(*,*)'Subr. LINES1:  Invalid I2DMET = ',i2dmet
         stop
      endif

c --- Trap missing power-law exponent (substitute default)
      if(plexp.LT.-900.) then
c ---    Use default
         plx=plx0(istab)
      else
c ---    Use it
         plx=plexp
      endif

c --- Set logical to identify calm conditions
      if(ws.LT.wscalm) then
         lcalm=.TRUE.
      else
         lcalm=.FALSE.
      endif
c
c --- Calculate the virtual times and sigmas at Heffter transition
      uavg=amax1(.5,ws)
c
c --- Set selected data in /CSIGMA/ for sigma calls
      call setcsig(idopty,idoptz,iru,uavg,istab,el,sqrts,
     &            tsigv,tsigw,symin,szmin,hbl,dpbl)
c
      if(mhftsz.EQ.0)then
         szh=syh
         call sigty(syh,zero,zero,dum,thfty,dhfty)
      else
         call heftran(1,hsl(1),symin,szmin,zero,zero,zero,zero)
      endif
c
c --------------------------------------------------------------------
c --- Calculate modified plume rise parameters for group, and tabulate
c --- rise from point of full buoyancy (XFB) to point of final rise
c --------------------------------------------------------------------
c
c --- Find angle between flow and orientation of line sources (theta)
      theta=flow-orientl
c
c --- Compute attributes of the line sources for this meteorology,
c --- and update rise tabulation
      ntr=nlrise
      call setline(mshear,theta,ws,istab,sqrts,plx,nlines,xl,
     &             hbl,wml,fprimel,wsep,fptot,fbpt,ntr,
     &             xle,xld,rzero,xtr,ztr)

c
c --- Set trig. factors for flow direction
      sinf=sin(flow)
      cosf=cos(flow)
c
c --- Find the along-flow coordinate that defines the line source
c --- element furthest upwind: (YY0GRD in met grid units)
c --- Rotate coord. system to place the yy-axis along the flow (line 1)
      yybeg=xlbeggrd(1)*sinf+ylbeggrd(1)*cosf
      yyend=xlendgrd(1)*sinf+ylendgrd(1)*cosf
      yy0grd=amin1(yybeg,yyend)
c --- Continue with other lines, if used
      do i=2,nlines
         yy=xlbeggrd(i)*sinf+ylbeggrd(i)*cosf
         yy0grd=amin1(yy0grd,yy)
         yy=xlendgrd(i)*sinf+ylendgrd(i)*cosf
         yy0grd=amin1(yy0grd,yy)
      enddo

c --- Use CALMET/PROFILE winds at final rise to set release/sampling
c --- data
      if(metfm.EQ.1 .OR. metfm.EQ.4 .OR. metfm.EQ.5) then
         heff=hbl+ztr(ntr)
         call rlsmet(ldbhr,ixs,iys,heff,mfact,
     &               mfact0fr,ilayerfr,wsfr,flowfr,ivecfr,istab,dpbl,el,
     &               ustr,wstr,tsigvfr,tsigwfr,iru,issta,sqrtsfr,
     &               idoptyfr,idoptzfr)
         wsnew=AMAX1(ws,wsfr)
      else
         wsnew=ws
      endif
c
c******
      if(ldbhr)then
         write(io6,204) ilayer,ixs,iys,ws,istab,dpbl,issta,theta
204      format(5x,'ILAYER: ',i3,2x,'IXS: ',i4,2x,
     1    'IYS: ',i4,2x,'WS: ',f5.1,2x,'ISTAB: ',i1,2x,'DPBL: ',
     2    f7.1,2x,'ISSTA: ',i4,2x,'THETA: ',f5.1)
c
         write(io6,206) xtr(1),ztr(1),xle,xld,xtr(ntr),ztr(ntr)
206      format(5x,'XFB : ',f6.1,2x,'ZFB : ',f6.1,2x,'XLE : ',
     1    f6.1,2x,'XLD : ',f6.1,2x,'XFIN0: ',f6.1,2x,'ZFIN0: ',f6.1)
c
      endif
c*****
c
c --------------------------------------------------
c --- Loop over lines
c --------------------------------------------------
c
      do 100 i=1,nlines
c
c --- Swap emission rate for source 'i' into 1D array and scale
      qtot=0.0
      do is=1,nspec
         q(is)=qtl(is,i)*VEMFAC(ldbhr,ivln1(is,i),iq12ln1(is,i),
     &                          temp,ws,istab)
         qtot=qtot+q(is)
      enddo
c --- Skip to next line if all species have zero mass in puff
      if(qtot.EQ.0.0) then
c ***
         if(ldbhr) then
            write(io6,*)
            write(io6,*) 'No emissions this step from Source ',i
            write(io6,*)
         endif
c ***
         goto 100
      endif

c --- Rotate coord. system to place the yy-axis along the flow
      xxbeg=xlbeggrd(i)*cosf-ylbeggrd(i)*sinf
      xxend=xlendgrd(i)*cosf-ylendgrd(i)*sinf
      yybeg=xlbeggrd(i)*sinf+ylbeggrd(i)*cosf
      yyend=xlendgrd(i)*sinf+ylendgrd(i)*cosf

c --- Find cross-wind and along-wind length of this line in meters
      xcrossm=abs(xxbeg-xxend)*dgrid
      yalongm=abs(yybeg-yyend)*dgrid

c --- Compute the number of puffs/slugs released this hour
c --- from this line source
      npnew=wsnew*xtmp1+1
      npnew=max0(npnew,1)
      npnew=min0(npnew,mxnew)
      newln1(i)=npnew
c
c --- DT is the time (sec) over which each puff is emitted
      dt=dthr/float(npnew)

c ---------------------------------------------------------
c --- Compute number of segments needed for one line (NSEG)
c ---------------------------------------------------------
      if(mslug.EQ.0 .OR. lcalm) then
c ---    Puffs are released, so use all MXNSEG segments
         thalf=0.
         xhalfkm=0.
         syhalf=0.
         szhalf=0.
         nsegy=0
         nsegz=0
         nseg(i)=mxnseg
      else
c ---    Slugs are released
c
c ---    Calculate the virtual times and sigmas at Heffter transition
         if(mhftsz.EQ.0)then
            szh=syh
            call sigty(syh,zero,zero,dum,thfty,dhfty)
         else
            call heftran(1,hsl(i),syab1,szab1,zero,zero,zero,zero)
         endif
c ---    Set NSEGY as function of transport speed, sigma-y,
c ---    and cross-wind length of line (make it an ODD integer)
         thalf=0.5*dt
         xhalfkm=0.001*uavg*thalf
         call sigty(zero,xhalfkm,thalf,syhalf,dum,dum)
         nsegy=nint(xcrossm/(rt2pi*syhalf))
         iodd=mod(nsegy,2)
         if(iodd.EQ.0) nsegy=nsegy+1
c ---    Set NSEGZ as function of transport speed, sigma-z, release ht,
c ---    and along-wind change in rise (make it an ODD integer)
         call sigtz(zero,xhalfkm,thalf,hsl(i),szhalf,dum,dum)
         nsegz=nint(2.0*ztr(1)/szhalf)
         iodd=mod(nsegz,2)
         if(iodd.EQ.0) nsegz=nsegz+1
c ---    Take the larger of the two
         nseg(i)=MAX0(nsegz,nsegy)
c ---    Cap result at MXNSEG
         nseg(i)=MIN0(nseg(i),mxnseg)
      endif

c --- Line releases npnew clouds this hour, with nseg elements
c --- in each cloud
      newpuf=newpuf+npnew*nseg(i)
c
c --- If puff arrays are full, remove puffs that are off the grid
c --- and "roll down" arrays to make room for new puffs
c --- (this also applies to the DA file of tabulated arrays)
      if(npuffs+newpuf.gt.mxpuff) call rolldn(np)
c
c --- Check to see if roll-down was adequate
      if(npuffs+newpuf.gt.mxpuff)then
         write(io6,*) ' ERROR in subr. LINES1'
         write(io6,*)'Too many puffs on grid for array dimensions -- ',
     1   'NPUFFS (old puffs) = ',npuffs,' NEWPUF = ',newpuf,
     2   ' MXPUFF = ',mxpuff
         write(*,*)
         stop 'Halted in LINES1 -- see list file.'
      endif
c
c --------------------------------------------------------------------
c --- Calculate building downwash effects on initial plume sigmas
c --------------------------------------------------------------------
c --- Initialize downwash variables to zero (no building downwash)
      sz0dw=0.0
      sy0dw=0.0
      idw=0
      if(ws.GT.wsdw0 .AND. .NOT.lcalm) then
c ---    Set downwash flag to ACTIVE
         idw=1
c ---    Use BLP calculation of downwash sigmas
         sz0dw=rt2bypi*rzero
         sy0dw=0.5*sz0dw
      endif
c
c --- Set initial sigma y, sigma z for puff/slug, including effective
c --- spread due to length of line source element (add length effects
c --- and downwash effects in quadrature)
c --- Crosswind variance: 0.25*(line width)**2/(2pi)
      if(lcalm) then
         xlen2=(xcrossm**2+yalongm**2)/(nseg(i)**2)
      else
         xlen2=(xcrossm/nseg(i))**2
      endif
      sy2=0.25*oneby2pi*xlen2+sy0dw*sy0dw
      sysrc=amax1(symin,sqrt(sy2))
c --- Alongwind variance: 0.25*(line length * rise rate)**2/(2pi)
      if(lcalm) then
         sz2=0.0
         szsrc=szmin
      else
         sz2=0.25*oneby2pi*((yalongm/nseg(i))*
     &                      ztr(1)/xtr(1))**2+sz0dw*sz0dw
         szsrc=amax1(szmin,sqrt(sz2))
      endif

c******
      if(ldbhr)then
         write(io6,*)
         write(io6,*) 'Line Source # ',i
         write(io6,*)
         write(io6,*) 'LINES1:  thalf,xhalfkm = ',thalf,xhalfkm
         write(io6,*) '          syhalf,nsegy = ',syhalf,nsegy
         write(io6,*) '          szhalf,nsegz = ',szhalf,nsegz
         write(io6,*) '                  nseg = ',nseg(i)
         write(io6,208) xcrossm,npnew,newpuf,dt,
     2                  idw,rzero,sysrc,szsrc
208      format(5x,'XCROSSM: ',f6.1,2x,
     2    'NPNEW: ',i4,2x,'NEWPUF: ',i5,2x,'DT: ',f7.2,2x/5x,
     3    'IDW: ',i3,2x,'RZERO: ',f6.1,2x,'SYSRC: ',f6.1,2x,
     4    'SZSRC: ',f6.1)
      endif
c*****
c
c -------------------------------------------------------------
c --- Loop over "point" sources (each segment) along line
c -------------------------------------------------------------
c
c --- Set up the distance increments along the line
      dxgrd=(xlendgrd(i)-xlbeggrd(i))/nseg(i)
      dxgrdby2=0.5*dxgrd
      dygrd=(ylendgrd(i)-ylbeggrd(i))/nseg(i)
      dygrdby2=0.5*dygrd

      do 90 ipt=1,nseg(i)

c ---  Set location in met grid units
       xptgrd=xlbeggrd(i)+(ipt-1)*dxgrd+dxgrdby2
       yptgrd=ylbeggrd(i)+(ipt-1)*dygrd+dygrdby2

c ---  Set the shift in distance (m) of this point from the upwind edge
       yyptgrd=xptgrd*sinf+yptgrd*cosf
       xshift=(yyptgrd-yy0grd)*dgrid
       if(xshift.LT.0.0) xshift=0.0
       if(xshift.GT.xtr(1)) xshift=xtr(1)

c ---  Set the final height and distance to final rise for this puff
       if(lcalm) then
          xshift=0.0
          xfrise=0.0
          heff=hsl(i)+ztr(ntr)
       else
          if(xtr(1).LE.xtr(ntr)) then
c ---        Case 1:  final rise reached beyond XFB
             heff=hsl(i)+ztr(ntr)-xshift*ztr(1)/xtr(1)
             xfrise=xtr(ntr)-xshift
          else
c ---        Case 2:  final rise reached before XFB
             size=1.0-xshift/xtr(1)
             heff=hsl(i)+ztr(ntr)*size
             xfrise=xtr(ntr)*size
          endif
       endif
c
c******
      if(ldbhr)then
         write(io6,*) 'Element #  ',ipt
         write(io6,210) hsl(i),heff,xfrise,xshift,xptgrd,yptgrd
210      format(5x,'HSL : ',f6.1,2x,'HEFF: ',f6.1,'XFRISE: ',f6.1,2x,
     1    'XSHIFT: ',f6.1,2x,'XPTGRD: ',f8.4,2x,'YPTGRD: ',f8.4)
      endif
c*****
c ----------------------------------------------------------
c ---    Initialize current hour's new puffs for this source
c ----------------------------------------------------------
         do 50 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xptgrd
         ypb(np)=yptgrd
         zitibl(np)=-1.0
         elbase(np)=belevl(i)
         sigyb(np)=sysrc
         sigzb(np)=szsrc
c ---    Final plume rise results for puff
         zfinal(np)=heff
         zpb(np)=heff
         zpe(np)=heff
         xfinal(np)=xfrise
c ---    Intermediate results for calc. gradual rise
         fb(np)=fbpt
c ---    Set xbfin and zbfin to negatives to signal use of final
c ---    rise if calm
         if(lcalm) then
            xbfin(np)=-1.0
            zbfin(np)=-1.0
         else
            xbfin(np)=xtr(ntr)
            zbfin(np)=ztr(ntr)
         endif
         isplit(np)=1
c
c ---    Time-of-release data
         ht0(np)=hsl(i)
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations (downwash - point sources)
         idw0(np)=idw
         hb0(np)=hsl(i)
         hw0(np)=xcrossm
         heff20(np)=hsl(i)
         zly0(np)=xld
         r0(np)=rzero
c ---    Additional data for line sources
         xshift0(np)=xshift
         sy0(np)=AMAX1(sy0dw,symin)
         sz0(np)=AMAX1(sz0dw,szmin)

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =5 for const. line sources)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=5
c
c ---    !-NOTE 1-!
c ---    The puff number really refers to the number of emission
c ---    steps, which equals the puff number when ONE puff is released
c ---    from a source each emission step.  But many puffs are released
c ---    each step when simulating a line source (distributed along
c ---    the line).  Subsequent use is made of IRLSNUM in controlling
c ---    sampling functions, which depend on the emission steps, so we
c ---    explicitly place the emission-step index in the array.
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    !-NOTE 2-!
c ---    OLD slugs from each segment are modeled explicitly, but
c ---    NEW releases are modelled using the numerical area-source
c ---    method for the ENTIRE line.  Therefore, we add a marker to
c ---    all slugs after segment 1, so that these can be identified
c ---    and ignored when NEW.  The marker consists of adding 1000 to
c ---    ISRCNUM, which would indicate that the puff comes from
c ---    line-source ISRCNUM=1000+i.  A check is made in READCF which
c ---    stops execution if parameter (mxlines .GE. 1000) to insure
c ---    that no valid line-source ID exceeds 999.
c
         if(mslug.eq.1 .AND. .NOT.lcalm) then
c
c ---       Set PUFID marker
            if(ipt.GT.1) isrcnum(np)=isrcnum(np)+1000
c
c ---       Set coordinates of oldest end of slug (in met. grid units)
c ---       Note that "oldest" end of slug is at the source, as is the
c ---       "newest" end; oldest end moves away and grows during the
c ---       step, while newest end remains fixed in size at the source.
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c ------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c ------------------------------------------------------------------
c ---    Set partial penetration variables to null values
         fmix=1.0
         hmax=dpbl
c ---    Mass emitted into each line segment needs to be divided by
c ---    nseg, which is the number of segments.  Accomplish that here
c ---    by dividing the timestep by nseg.
         dtseg=dt/nseg(i)
         call inject(np,nspec,dtseg,mfact0,q,heff,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer tabulated arrays record to DA file using full
c ---    MXRISE dimension
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))

50       continue
90     continue
100   continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine rlsmet(ldbhr,ixs,iys,htr,mfact,
     &                  mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &                  ustr,wstr,tsigv,tsigw,iru,issta,sqrts,
     &                  idopty,idoptz)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 051108                 RLSMET
c                D. Strimaitis,  SRC
c
c --- PURPOSE:  Obtain release height wind speed & other met. variables
c
c --- UPDATE
c --- V5.75-V5.752  051108  (DGS): Add overwater SVMIN,SWMIN
c --- V5.7-V5.75    050225  (DGS): Add UATZI for TURBSET's AERSWV call
c --- V5.4-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c --- V5.0-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.0     981228  (DGS): restore flow units
c --- V5.0-V5.0     980807  (DGS): enforce time-growth sigmas if CALM
c                   980807  (DGS): use surface stability for all hts
c                                  when stable
c --- V5.0-V5.0     980722  (DGS): SVMIN & SWMIN by stability class
c --- V5.0-V5.0     980722  (DGS): remove FLOW=0 assignment for CALMS
c                                  (use WD from WINDSET)
c --- V4.0-V5.0     971107  (DGS): use release ht = MAX(htr,z0)
c
c --- INPUTS:
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c       IXS,IYS - integer - Met grid cell index for puff
c           HTR - real    - Release height (m)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c
c     Common block /COMPARM/ variables:
c           XMINZI, XMAXZI, SVMIN(6,2), SWMIN(6,2), WSCALM
c     Common block /DISPDAT/ variables:
c           IURB1, IURB2, JSUP
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MDISP, MDISP2
c     Common block /GRID/ variables:
c           ZFACE(mxnzp1), NZP1, ZGPT(mxnz)
c     Common block /METHR/ variables:
c           UMET(mxnx,mxny,mxnz),VMET(mxnx,mxny,mxnz),IPGT(mxnx,mxny),
c           HTMIX(mxnx,mxny), XMONIN(mxnx,mxny), USTAR(mxnx,mxny),
c           WSTAR(mxnx,mxny), PTG(2), PLEXP,
c           TEMPSS(mxss),TEMP2D
c     Common block /METHD/ variables:
c           NEARS(mxnx,mxny), ILANDU(mxnx,mxny), Z0(mxnx,mxny),
c           NSSTA, LCALGRD, I2DMET
c     Parameters:
c           MXNX, MXNY, MXNZ, MXNZP1, MXSS, IO6
c
c --- OUTPUT:
c        MFACT0 - integer - Current stepping index to identify slugs
c                           vs. puffs (puff used for calms)
c        ILAYER - integer - Met layer index for release height
c            WS - real    - Wind speed (m/s)
c          FLOW - real    - Flow direction (radians CW from N)
c          IVEC - integer - Vector flow direction (deg CW from N)
c         ISTAB - integer - Stability class (1-6)
c          DPBL - real    - Mixing height (m)
c            EL - real    - Monin-Obukhov length (m)
c          USTR - real    - Friction velocity (m/s)
c          WSTR - real    - Convective velocity scale (m/s)
c         TSIGV - real    - Lateral turbulence velocity (m/s)
c         TSIGW - real    - Vertical turbulence velocity (m/s)
c           IRU - integer - Rural/Urban indicator (rural=0, urban=1)
c         ISSTA - integer - Index of nearest surface met station
c         SQRTS - real    - Root of stability parameter (1/s);
c                           (same as Brunt-Vaisala frequency)
c        IDOPTY - integer - Current dispersion option for sigma-y
c        IDOPTZ - integer - Current dispersion option for sigma-z
c
c --- RLSMET called by:  AREAS1, AREAS2, LINES1, POINTS1, POINTS2,
c                        VOLS
c --- RLSMET calls:      ZFIND, WINDSET, TURBSET, PTLAPS
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      include 'comparm.puf'
      include 'dispdat.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'methd.puf'
      include 'methr.puf'
c
      logical ldbhr
c
      data g/9.80665/
c --- Set minimum allowed potential temperature gradient PTGRAD0,
c --- and the layer above stack-top over which it is calculated DELZ
      data ptgrad0/.005/, delz/100./
c --- Set transport wind speed for "calm"
      data ucalm/0.001/
c
c --- Select properties for this cell
      istab=MIN0(ipgt(ixs,iys),6)
      dpbl=AMAX1(htmix(ixs,iys),xminzi)
      dpbl=AMIN1(dpbl,xmaxzi)
      el=xmonin(ixs,iys)
      ustr=ustar(ixs,iys)
      wstr=wstar(ixs,iys)
      z0m=z0(ixs,iys)
c --- Set land (1) water (2) index for SVMIN,SWMIN
      ilw=1
      if(ilandu(ixs,iys).GE.iwat1 .AND.
     &   ilandu(ixs,iys).LE.iwat2) ilw=2

c
c --- Find the layer containing the release height (m)
      htrel=AMAX1(htr,z0m)
      call ZFIND(htrel,zface,nzp1,ilayer)
c --- Extract wind speed (m/s) and direction (deg)
      call WINDSET(htrel,ilayer,ixs,iys,z0m,el,dpbl,istab,ws,wd)
      flow=wd+180.
      if(flow.LT.0.) then
         flow=flow+360.
      elseif(flow.GE.360.) then
         flow=flow-360.
      endif
      ivec=NINT(flow)
c
c --- For puffs above mixed layer, use stability class "JSUP" to
c --- calculate SIGMA Y and SIGMA Z growth (if JSUP=0, use
c --- mixed-layer stability class)
      jdstab=istab
      if(istab.LT.5 .and. htrel.GT.dpbl .and. jsup.ne.0)jdstab=jsup
c
c --- Set turbulence velocities and activate dispersion options
      if(mdisp.EQ.1 .OR. mdisp.EQ.2 .OR. mdisp.EQ.5) then
c ---    Extract wind speed (m/s) at Zi
         call ZFIND(dpbl,zface,nzp1,ilayerzi)
         call WINDSET(dpbl,ilayerzi,ixs,iys,z0m,el,dpbl,istab,
     &                   uatzi,wdzi)
         call TURBSET(ldbhr,ustr,el,wstr,jdstab,dpbl,z0m,htrel,
     &                uatzi,ws,wd,ixs,iys,ilw,
     &                tsigv,tsigw,idopty,idoptz)
      else
         idopty=mdisp
         idoptz=mdisp
         tsigw=swmin(jdstab,ilw)
         tsigv=svmin(jdstab,ilw)
      endif
c
c --- Extract IRU value (rural=0, urban=1) for source
      iru=0
      if(ilandu(ixs,iys) .GE. iurb1 .AND.
     &   ilandu(ixs,iys) .LE. iurb2) iru=1
c
c --- Identify surface met station nearest source
      issta=NEARS(ixs,iys)
      if(issta.gt.nssta)then
         write(io6,*) ' ERROR in subr. RLSMET'
         write(io6,*)'ISSTA > NSSTA -- ISSTA = ',issta,' NSSTA = ',
     1                nssta
         write(*,*)
         stop 'Halted in RLSMET -- see list file.'
      endif
c
c frr (09/01) new calmet format (2D temp)
      if(i2dmet.EQ.1) then
         temp=temp2d(ixs,iys)
      elseif(i2dmet.EQ.0) then
         temp=tempss(issta)
      else
         write(*,*)'Subr. RLSMET:  Invalid I2DMET = ',i2dmet
         stop
      endif

c --- Compute stratification parameter = Brunt-Vaisala freq.
      if(LCALGRD) then
c ---    Use temperature (K) gradient between stack-top and
c ---    DELZ above stack-top
         call PTLAPS(ixs,iys,htr,ptgrad0,delz,ptgrad,t0)
         sqrts=SQRT(g*ptgrad/t0)
      else
c ---    Use default potential temperature lapse rate with the
c ---    surface temperature from the nearest station
         if(istab.LE.4) then
            ptgrad=0.0
         elseif(istab.EQ.5) then
            ptgrad=AMAX1(ptg(1),ptgrad0)
         else
            ptgrad=AMAX1(ptg(2),ptgrad0)
         endif
         sqrts=SQRT(g*ptgrad/temp)
      endif
c
c --- If CALM is detected, make sure PUFF ID stepping index is 0 to
c --- use PUFFS
      mfact0=mfact
      if(ws.LT.wscalm) then
         ws=AMAX1(ws,ucalm)
         mfact0=0
c ---    Reset dispersion option ("calms" use time-based sigmas)
         idopty=1
         idoptz=1
      endif

c --- Convert flow from degrees to radians
      flow=flow*.0174533

      return
      end
c----------------------------------------------------------------------
      subroutine zfind(z,zface,nzp1,ilayer)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 941215                  ZFIND
c                J. Scire, SRC
c
c --- PURPOSE:  Find the vertical layer containing height "Z"
c
c --- INPUTS:
c             Z - real    - Height (m) of interest
c   ZFACE(nzp1) - real    - Array of face heights (m)
c          NZP1 - integer - Number of vertical cell faces
c                           (no. layers + 1)
c
c --- OUTPUT:
c        ILAYER - integer - Vertical containing height "Z"
c                           (ILAYER=1  returned if Z < face ht. #1)
c                           (ILAYER=NZ returned if Z > face ht. #NZP1)
c
c --- ZFIND called by:  RLSMET, ADVWND
c --- ZFIND calls:      none
c----------------------------------------------------------------------
c
      real zface(nzp1)
c
c --- Find first face height above height "Z"
      do 10 i=2,nzp1
      if(z.lt.zface(i))then
         ilayer=i-1
         go to 12
      endif
10    continue
c
c --- "Z" must be above top face
      ilayer=nzp1-1
c
12    continue
      return
      end
c----------------------------------------------------------------------
      subroutine ptlaps(i,j,htbase,dptmin,delz,dtheta,tht)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 060725                 PTLAPS
c ---            J. Scire, D. Strimaitis,  SRC
c
c --- PURPOSE:  Calculate the potential temperature lapse rate
c               (deg. K/m) in a layer "DELZ" meters deep above the
c               a specified height, using either the temperature
c               data from the MET file, or the PROFILE.DAT file
c
c --- UPDATE
c --- V5.74-V5.756  060725  (DGS): fix case where upper height exceeds
c                                  middle of top layer (ku must be nz)
c --- V5.4-V5.74    040715  (DGS): add METFM=5 (AERMET)
c --- V5.0-V5.4     000602  (DGS): add message to "stop"
c --- V4.0-V5.0     971107  (DGS): check PROBLEM returned by XTPRF
c
c --- INPUTS:
c                  I,J - integers      - Grid cell indexes
c               HTBASE - real          - Height (m) of bottom of layer
c               DPTMIN - real          - Minimum potential temperature
c                                        lapse rate (deg. K/m)
c                 DELZ - real          - Depth (m) of layer through
c                                        which potential temp. lapse
c                                        rate is computed
c    Common block /COMPARM/ variables:
c         WSCALM, XMINZI, XMAXZI
c     Common Block /GEN/ variables:
c         METFM
c     Common Block /GRID/ variables:
c         NZ, ZGPT(mxnz)
c    Common block /METHR/ variables:
c         TMET(mxnx,mxny,mxnz)
c         IPGT(mxnx,mxny), HTMIX(mxnx,mxny), XMONIN(mxnx,mxny)
c         PTG(2), TPRF(mxprfz), ZPRF(mxprfz), NZPRF
c    Parameters:
c         MXNX, MXNY, MXNZ, MXPRFZ, IO6
c
c --- OUTPUT:
c               DTHETA - real          - Potential temperature lapse rate
c                                        (deg. K) in "DELZ" meter layer
c                  THT - real          - Temperature at bottom of layer
c
c --- PTLAPS called by:  RLSMET, POINTS1, POINTS2, LINES1
c --- PTLAPS calls:      XTPRF
c----------------------------------------------------------------------
c
c --- include parameters
      include 'params.puf'
      include 'comparm.puf'
      include 'gen.puf'
      include 'grid.puf'
      include 'methr.puf'
c
      logical problem
c
      if(metfm.EQ.1) then
c ---    MET layers
c ---    Find level just below htbase
         kl=nz-1
         do 10 k=2,nz
            if(zgpt(k).lt.htbase) go to 10
            kl=k-1
            go to 12
10       continue
12       continue
c
c ---    Find level just above htbase+delz
c ---    Initialize to NZ
         ku=nz
         htpdz=htbase+delz
         klp1=kl+1
         do 15 k=klp1,nz
            if(zgpt(k).lt.htpdz) go to 15
            ku=k
            go to 16
15       continue
16       continue
c
c ---    If two adjacent levels were found, just take dt/dz between them
         if((ku-kl).eq.1) then
            dtheta=.0098+(tmet(i,j,ku)-tmet(i,j,kl))/(zgpt(ku)-zgpt(kl))
            tht=tmet(i,j,kl)
         else
c ---       Obtain temperatures (deg. K) at htbase & htbase + delz
c ---       by interpolation
            klp1=kl+1
            tht=tmet(i,j,klp1)-(tmet(i,j,klp1)-tmet(i,j,kl))*
     1                       (zgpt(klp1)-htbase)/(zgpt(klp1)-zgpt(kl))
            kum1=ku-1
            thtp=tmet(i,j,ku)-(tmet(i,j,ku)-tmet(i,j,kum1))*
     1                      (zgpt(ku)-htpdz)/(zgpt(ku)-zgpt(kum1))
c
c ---       Compute potential temperature lapse rate (deg. K/m)
            dtheta=(thtp-tht)/delz+0.0098
         endif

      elseif(metfm.EQ.4 .OR. metfm.EQ.5) then
c ---    PROFILE.DAT data
         problem=.FALSE.
c ---    Set current surface layer properties
         istab=ipgt(i,j)
         istab=MIN0(istab,6)
         dpbl=AMAX1(htmix(i,j),xminzi)
         dpbl=AMIN1(dpbl,xmaxzi)
         el=xmonin(i,j)
c ---    Do not need z0 for temperature (set to 0.1 m)
         z0m=0.1

c ---    Extract temperatures at top and bottom of layer
         call XTPRF(nzprf,tprf,zprf,htbase,'tmp',z0m,el,
     &              dpbl,istab,ptg,tht,problem)
         htop=htbase+delz
         call XTPRF(nzprf,tprf,zprf,htop,'tmp',z0m,el,
     &              dpbl,istab,ptg,thtp,problem)

c ---    Results are invalid if XTPRF reported PROBLEM=TRUE
         if(PROBLEM) then
            write(io6,*) 'PTLAPS:  FATAL ERROR reported when ',
     &                   'extracting temp from PROFILE ---'
            write(io6,*) 'There are no valid data'
            write(*,*)
            stop 'Halted in PTLAPS -- see list file.'
         endif
c
c ---    Compute potential temperature lapse rate (deg. K/m)
         dtheta=(thtp-tht)/delz+0.0098
      endif
c
c --- dptmin is minimum stable pot. temp. lapse rate
      dtheta=amax1(dtheta,dptmin)
c
      return
      end
c----------------------------------------------------------------------
      subroutine inject(np,nspec,dt,mfact0,q,heff,hmax,dpbl,fmix,istab)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 980615                 INJECT
c                D. Strimaitis,  SRC
c
c --- PURPOSE:   Inject emissions into proper layer (above/below
c                mixing ht.)
c
c --- UPDATE
c --- V5.0-V5.0
c          950715 - 980615  (DGS): Use 2-layer puff codes for partial
c                                  penetration
c
c --- INPUTS:
c            NP - integer - Index of puff/slug
c         NSPEC - real    - Number of species modeled
c            DT - real    - Time over which puff is emitted (s)
c        MFACT0 - integer - Stepping index to identify slugs vs puffs
c             Q - real ar.- Emission rate (g/s) for period DT
c          HEFF - real    - Effective puff ht. at final rise (m)
c          HMAX - real    - Top of upper layer (partial penetration)
c          DPBL - real    - Current mixing height (m)
c          FMIX - real    - Fraction of mass in mixed layer
c         ISTAB - integer - Stability class in surface layer
c
c     Common block /FLAGS/ variables:
c           MGAUSS
c     Common block /PUFF/ variables:
c           NPUFFS
c     Parameters:
c           MXSPEC, MXPUFF
c
c --- OUTPUT:
c
c     Common block /PUFF/ variables:
c           IPUFFCD(mxpuff),ZIMAX(mxpuff),ZIOLD(mxpuff),
c           QM(mxspec,mxpuff),QU(mxspec,mxpuff)
c
c --- INJECT called by:  AREAS1, AEREAS2, VOLS, POINTS1,
c                        POINTS2, LINES1
c --- INJECT calls:      none
c----------------------------------------------------------------------
c
      include 'params.puf'
      include 'flags.puf'
      include 'puff.puf'
c
      real q(mxspec)

c --- Set unlimited mixing height (m)
      data ziunlm/1.0e04/
c
      if(fmix.NE.1.0 .and. fmix.NE.0.0) then
c ---    Partial penetration of inversion was calculated
c ------------------------------------------------------
         zimax(np)=hmax
         ziold(np)=dpbl
         do ispec=1,nspec
            qtotal=q(ispec)*dt
            qm(ispec,np)=qtotal*fmix
            qu(ispec,np)=qtotal-qm(ispec,np)
         enddo
         if(mgauss.EQ.1)then
c ---       Gaussian puff or slug within mixed layer
            ipufcd(np)=5+mfact0
         else
c ---       Uniform puff or slug within mixed layer
            ipufcd(np)=6+mfact0
         endif
c
      elseif(heff.LE.dpbl)then
c ---    Within surface layer
c ---------------------------
         do ispec=1,nspec
            qm(ispec,np)=q(ispec)*dt
            qu(ispec,np)=0.0
         enddo
         if(mgauss.EQ.1)then
c ---       Gaussian puff or slug
            ipufcd(np)=1+mfact0
            if(istab.GE.5) then
c ---          Stable regime -- set up for unlimited mixing
               zimax(np)=ziunlm
               ziold(np)=ziunlm
            else
c ---          Non-stable regime -- use current mixing height
               zimax(np)=dpbl
               ziold(np)=dpbl
            endif
         else
c ---       Uniform puff or slug within mixed layer
            ipufcd(np)=2+mfact0
            zimax(np)=dpbl
            ziold(np)=dpbl
         endif
c
      else
c ---    Above surface layer
c ---------------------------
         if(mgauss.EQ.1)then
c ---       Gaussian puff or slug above mixed layer
            if(istab.GE.5) then
c ---          Stable regime -- treat as unlimited mixed layer
               ipufcd(np)=1+mfact0
               zimax(np)=ziunlm
               ziold(np)=ziunlm
               do ispec=1,nspec
                  qm(ispec,np)=q(ispec)*dt
                  qu(ispec,np)=0.0
               enddo
            else
c ---          Non-stable regime -- place mass above mixed layer
               ipufcd(np)=3+mfact0
               zimax(np)=dpbl
               ziold(np)=dpbl
               do ispec=1,nspec
                  qm(ispec,np)=0.0
                  qu(ispec,np)=q(ispec)*dt
               enddo
            endif
         else
c ---       Uniform puff or slug above mixed layer
            ipufcd(np)=4+mfact0
            zimax(np)=dpbl
            ziold(np)=dpbl
            do ispec=1,nspec
               qm(ispec,np)=0.0
               qu(ispec,np)=q(ispec)*dt
            enddo
         endif
c
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine dwsigs(tbd,hw,hb,mhftsz,ws,hs,heff,zplat,xdown,
     &                  sigy,sigz)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 050225                 DWSIGS
c ---            J. Scire, D. Strimaitis, SRC
c
c --- PURPOSE:  Compute the dispersion coefficients, sigma y and
c               sigma z due to building downwash effects. (Values
c               returned are the max. obtained with or without
c               building downwash)
c
c --- UPDATE
c --- V5.0-V5.75    050225  (DGS): Add platform ht adjustment
c --- V4.0-V5.0     971107  (DGS): Return "zero" sigmas for distances
c                                  within "3Hb" of source
c
c --- INPUTS:
c           TBD - real     - Variable determining switch-over pt. from
c                           Schulman-Scire scheme to Huber-Snyder
c                           scheme (SS used for Hs < Hb + TBD * HL,
c                           TBD < 0   ==> always use Huber-Synder
c                           TBD = 1.5 ==> always use Schulman-Scire
c                           TBD = 0.5 ==> ISC switch-point
c            HW - real     - Wind-direction specific building width (m)
c                            (for current wind)
c            HB - real     - Wind-direction specific building height (m)
c                            (for current wind)
c        MHFTSZ - integer  - Use Heffter sigma-z (0:NO  1:YES)
c            WS - real     - Stack height wind speed (m/s)
c            HS - real     - Stack height (m)
c          HEFF - real     - Effective stack ht. (m) accounting for
c                            momentum rise alone at a downwind distance
c                            of 2. building heights
c         ZPLAT - real     - Platform ht (m) (non-zero for structures
c                            that are elevated above the surface)
c         XDOWN - real     - Downwind distance (m) of receptor
c
c --- OUTPUT:
c          SIGY - real     - Horizontal dispersion coefficient (m)
c          SIGZ - real     - Vertical dispersion coefficient (m)
c
c --- DWSIGS called by:  PUFRECS, SLGRECS, PLGRECS, POINTS1, POINTS2
c --- DWSIGS calls:      HEFTRAN, SIGTY, SIGTZ
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'csigma.puf'
c
      sigy=0.0
      sigz=0.0
c
      hl=AMIN1(hw,hb)
      hl3=3.*hl
      hl10=10.*hl
c
c --- Return zero values for the sigmas at distances < "3Hb"
c --- Allow for precision uncertainty
      if(xdown.LT.0.99*hl3) return

c --- Valid platform height?
      if(zplat.LT.0.) stop 'DWSIGS: Platform height is negative'
c --- Adjusted stack height above platform
      hsplat=AMAX1((hs-zplat),0.0)
c --- Adjusted stack height above platform
      heplat=AMAX1((heff-zplat),0.0)

c --- Calculate the virtual times and sigmas at Heffter transition
      if(mhftsz.EQ.0)then
         szh=syh
         call sigty(syh,0.0,0.0,dum,thfty,dhfty)
      else
         call heftran(1,hs,sigy,sigz,0.0,0.0,0.0,0.0)
      endif
c
c --- Compute the downwind distance to use in the downwash eqns.
      if(xdown.le.hl3)then
         xarg=hl3
      else if(xdown.ge.hl10)then
         xarg=hl10
      else
         xarg=xdown
      endif
c --- Convert to time and distance used in dispersion formulas
      targ=xarg/ws
      xargkm=0.001*xarg
c
c --- Get "ambient" sigmas
c
      call sigty(0.0,xargkm,targ,syamb,virty,virdy)
      call sigtz(0.0,xargkm,targ,hs,szamb,virtz,virdz)
c
c --- Now get "downwash" sigmas
c
c ---------------------------------------
c --- Huber-Synder Calculations ---------
c ---------------------------------------
      xtemp=0.067*(xarg-hl3)
      sigz=0.7*hl+xtemp
c
      if(hw.ge.hb)then
c ---    Squat building
c ---    Determine if sigma y enhancement occurs
         if(heplat.le.1.2*hb)then
            if(hw.lt.5.*hb)then
               sigy=0.35*hw+xtemp
            else
               sigy=0.35*hb+xtemp
c ---          (Note: "lower bound" ISC2 option is not available)
            endif
         else
            sigy=0.0
         endif
      else
c
c ---    Tall building
c ---    Determine if sigma y enhancement occurs
         if(heplat.le.1.2*hb)then
            sigy=0.35*hw+xtemp
         else
            sigy=0.0
         endif
      endif
c
c -----------------------------------------
c --- Schulman-Scire Calculations ---------
c -----------------------------------------
      if(tbd.ge.0.0 .AND. hsplat.le.hb+tbd*hl)then
c
c ---    Determine linear scaling function for sigz
         if(heplat.le.hb)then
            a=1.0
         else if(heplat.le.hb+2.*hl)then
            a=(hb-heplat)/(2.*hl)+1.0
         else
            a=0.0
         endif
c
c ---    Scale the vertical dispersion coefficient
         sigz=a*sigz
      endif
c
c --- Select the greater of the ambient and downwash sigmas
      sigy=amax1(syamb,sigy)
      sigz=amax1(szamb,sigz)

      return
      end
c----------------------------------------------------------------------
      subroutine setline(mshear,theta,wsr,istab,sqrts,plawx,
     &                   nlines,xl,hbl,wml,fprimel,wsep,fptot,fbpt,
     &                   nlrise,xle,xld,r0,xrise,zrise)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                SETLINE
c ---            D. Strimaitis, SRC
c
c --- PURPOSE:  Perform initial processing for buoyant line sources
c               for current meteorology, and compute rise table
c
c --- UPDATE
c --- V5.0-V5.8.4   130731  (EPA): add check for invalid power-law exp
c --- V5.0-V5.0     981228  (DGS): add line width term to XFB for single
c                                  line and use BLP code for effective
c                                  width for parallel winds
c --- V4.0-V5.0     971107  (DGS): add all io to argument list to allow
c                                  use with variable line sources as
c                                  well as constant lines
c
c --- INPUTS:
c        MSHEAR - integer      - Flag for including wind shear in rise
c                                calcs. (0=NO shear;  1=shear)
c         THETA - real         - Angle between wind and axis of
c                                line source (radians)
c           WSR - real         - Wind speed at release height (m/s)
c         ISTAB - integer      - Stability class (PG)
c         SQRTS - real         - Square root of stability parameter
c                                  (sqrt(s)=(g*(dtheta/dz)/tair)**0.5)
c         PLAWX - real         - Wind speed profile power law exponent
c        NLINES - integer      - Number of line sources
c            XL - real         - Average line source length (m)
c           HBL - real         - Average line source height (m)
c           WML - real         - Average line source width (m)
c       FPRIMEL - real         - Average buoyancy parameter/line
c                                in units of (m**4/s**3)
c          WSEP - real         - Average separation between lines
c         FPTOT - real         - Total buoyancy parameter
c          FBPT - real         - "Point Source" buoyancy parameter
c        NLRISE - integer      - Number of points used to tabulate
c                                plume rise from block of lines
c
c --- OUTPUT:
c           XLE - real     - Cross-wind effective line length (m)
c           XLD - real     - Effective downwash length (m)
c            R0 - real     - Initial dilution radius (m)
c XRISE(mxrise) - real     - Tabulated distances (m) from source
c ZRISE(mxrise) - real     - Tabulated rise heights (m) above source
c
c --- SETLINE called by:  LINES1, LINES2
c --- SETLINE calls:      ROOT3
c----------------------------------------------------------------------
c
      include 'params.puf'
      real rt3(3)
      real xrise(mxrise),zrise(mxrise)

c --- (beta=0.6)
      data beta/0.6/, beta2/0.36/, betai/1.6666667/, pibeta/1.8849556/
      data pi/3.1415927/, twopi/6.2831853/
      data half/0.5/, third/0.3333333/

c --- Set a minimum wind speed to use for calculating final rise (m/s)
      data wsrise/1.0/

c --- Trap invalid power-law exponent
      if(plawx.LE.0.0) then
         write(io6,*)
         write(io6,*)'SETLINE:  Invalid power-law exponent found'
         write(io6,*)'          PLAWX = ',plawx
         stop 'Halted in SETLINE --- see list file'
      endif
c
c --- Calculate sine & cosine, taking results in first quadrant
      cost=abs(cos(theta))
      sint=abs(sin(theta))

      ws=amax1(wsr,wsrise)
      ws3=ws*ws*ws

c ---------------------------------------------------------------------
c --- Get the downwind distance to full buoyancy (XFB) and the
c --- effective line length (XLE) for current meteorology
c ---------------------------------------------------------------------

c --- Set xfb
      xfb=xl*cost+(nlines-1)*wsep*sint
      if(nlines.EQ.1) xfb=xfb+wml*sint
      xfb2=xfb*xfb

c --- Set virtual line length for winds parallel to line sources (wmlv)
      if(nlines.EQ.1) then
         wmlv=wml
      else
c ---    Height at which plumes from adjacent lines interact (hi)
         hi=half*wsep*betai
c ---    Distance at which adjacent plumes interact (xi)
c ---    First, assume that xi < xl:
         xibyxl3=ws3*(hi/xl)**3*((twopi*beta2*xl/fprimel)*
     &                           (1.+3.*wml/(pibeta*hi)))
         if(xibyxl3.GT.1.) then
            xi=half*xl*(1.+third*SQRT(12.*xibyxl3-3.))
            wmlv=fptot*(third*xl**2+xi*(xi-xl))/(2.*beta*ws3*hi**2)-
     &                  third*pibeta*hi
         else
            wmlv=fptot*(third*xl**2*xibyxl3)/(2.*beta*ws3*hi**2)-
     &                  third*pibeta*hi
         endif
      endif

c --- Set effective line length for current wind direction
      xle=xl*sint+wmlv*cost

c ---------------------------------------------------------------------
c --- Effective building downwash length (XLD) and initial radius (R0)
c ---------------------------------------------------------------------
      xld=xle*sint
      r0=amin1(hbl,xld)

c ---------------------------------------------------------------------
c --- Effective wind speed if shear effect on rise is included
c ---------------------------------------------------------------------
c --- Note: do not apply shear to case where wind speed is less than
c ---       the minimum speed "wsrise"
      if(mshear.EQ.1 .AND. wsr.GE.wsrise) then
         if(istab.LE.4) then
c ---       "Neutral"
            eps=2.0+3.0*plawx
            epsi=1.0/eps
c ---       Get distance to final rise (no shear)
            if(fbpt.LE.55.) then
               xfin0=3.5*14*fbpt**.625
            else
               xfin0=3.5*34.49*fbpt**.4
            endif
c ---       Get shear-modified final rise
            zeps=(0.25*(eps*xfin0)**2)*(fptot*hbl**(3.0*plawx))/
     &            ((2.0+plawx)*beta*xl*ws3)
            zshear=zeps**epsi
c ---       Get effective wind speed
            ws3=(xfin0/zshear)**2*fptot/(2.0*beta*xl)
            ws=ws3**third
c ---       Effective speed must be no less than wsr (speed at release)
            if(ws.LT.wsr) then
               ws=wsr
               ws3=ws*ws*ws
            endif
         else
c ---       "Stable"
            twopp=2.0+plawx
            twoppi=1.0/twopp
            s=sqrts**2
c ---       Get shear-modified final rise
            zshear=( twopp*fptot*hbl**plawx/(beta*xl*ws*s) )**twoppi
c ---       Get effective wind speed
            ws=2.0*fptot/(beta*xl*s*zshear*zshear)
c ---       Effective speed must be no less than wsr (speed at release)
            if(ws.LT.wsr) then
               ws=wsr
            else
               ws3=ws*ws*ws
            endif
         endif
      endif

c ---------------------------------------------------------------------
c --- Final rise & distance to final rise from the most upwind point
c --- "zfin0,xfin0"
c ---------------------------------------------------------------------
      aa3=1.0
      aa2=(3.*betai)*(xle/pi+r0)
      aa1=(3.*r0/beta2)*(2.*xld/pi+r0)
      aa00=-0.5*fbpt/(beta2*ws3)
      if(istab.LE.4) then
c ---    "Neutral"
         if(fbpt.LE.55.) then
            xfin0=3.5*14*fbpt**.625
         else
            xfin0=3.5*34.49*fbpt**.4
         endif
         if(xfin0.LT.xfb) then
            aa0=aa00*xfin0**3/xfb
         else
            aa0=aa00*(xfb2+3.*xfin0*(xfin0-xfb))
         endif
         call root3(aa3,aa2,aa1,aa0,nr,rt3)
c ---    Pick largest root
         zfin0=rt3(1)
         do i=2,nr
            zfin0=amax1(zfin0,rt3(i))
         enddo
      else
c ---    "Stable"
         s=sqrts**2
         aa0=-6.*fbpt/(beta2*ws*s)
         call root3(aa3,aa2,aa1,aa0,nr,rt3)
c ---    Pick the largest real root
         zfin0=rt3(1)
         do i=2,nr
            zfin0=amax1(zfin0,rt3(i))
         enddo
c ---    Now use neutral transient rise eqn. to get distance to zfin0
c ---    First, assume that xfin0 < xfb:
         ws2bys=ws*ws/s
         xfin0=(12.0*ws2bys*xfb)**third
         if(xfin0.GT.xfb) then
c ---       Must be beyond xfb
            xfin0=0.5*(xfb+sqrt(16.0*ws2bys-xfb2*third))
         endif
c ---    Distance should not be greater than result without downwash
         xfin=ws*pi/sqrts
         xfin0=amin1(xfin0,xfin)
      endif

c ---------------------------------------------------------------------
c --- Rise at XFB from the most upwind point (ZFB)
c ---------------------------------------------------------------------
      aa0=aa00*xfb2
      call root3(aa3,aa2,aa1,aa0,nr,rt3)
c --- Pick largest root
      zfb=rt3(1)
      do i=2,nr
         zfb=amax1(zfb,rt3(i))
      enddo
      zfb=amin1(zfb,zfin0)

c----------------------------------------------------------------------
c --- Fill in rise table between xfb and xfin0, inclusive
c----------------------------------------------------------------------
c --- Fill in new information for current met.
      xrise(1)=xfb
      zrise(1)=zfb
      xrise(nlrise)=xfin0
      zrise(nlrise)=zfin0

      dx=(xfin0-xfb)/(nlrise-1)

      if(xfb.GE.xfin0) then
c ---    Final rise reached before XFB -- just plug final rise values
         do ir=2,nlrise-1
            xrise(ir)=xrise(ir-1)+dx
            zrise(ir)=zfb
         enddo
      else
c ---    Final rise reached beyond XFB -- compute gradual rise values
         do ir=2,nlrise-1
            xibl=xrise(ir-1)+dx
            aa0=aa00*(xfb2+3.0*(xibl*xibl-xfb*xibl))
            call root3(aa3,aa2,aa1,aa0,nr,rt3)
c ---       Pick largest root
            zibl=rt3(1)
            do i=2,nr
               zibl=amax1(zibl,rt3(i))
            enddo
            zrise(ir)=amin1(zibl,zfin0)
            xrise(ir)=xibl
         enddo
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine rolldn(np)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 950715                 ROLLDN
c                D. Strimaitis,  SRC
c
c --- PURPOSE:  Identifies inactive puff/slug indices, and "rolls down"
c               arrays to free space for new puffs/slugs
c
c --- INPUTS:
c            NP - integer - Index of last puff/slug initialized
c
c     Common block /PUFF/ variables:
c           NPUFFS, IPUFCD
c     Common block /OUTPT/ variables:
c           IMESG
c     Parameters:
c           MXPUFF
c
c --- OUTPUT:
c            NP - integer - Revised index of last puff/slug initialized
c     Common block /PUFF/ variables:
c           NPUFFS
c
c --- ROLLDN called by: AREAS1, LINES1, POINTS1, POINTS2, VOLS,
c                       SPLIT, RESTARTO
c --- ROLLDN calls:     SWAP
c----------------------------------------------------------------------
c --- NOTE:
c     Inactive indices are searched in ascending order, and are filled
c     with next active "old" puff/slug in descending order.  Once gaps
c     in the "old" locations have been filled, the new puffs/slugs
c     initialized this timestep are added to the top of the arrays,
c     retaining the order.
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'puff.puf'
      include 'outpt.puf'
c
c --- Identify number of NEW puffs/slugs already initialized
      nnew=np-npuffs
c
c --- Set starting index for ascending search for inactive puffs
      inact=1
c
c --- Loop over "old" puffs/slugs in descending order
      do j=npuffs,1,-1
         if(ipufcd(j).LT.99) then
c ---       Active puff found: use this to replace next inactive puff
            do i=inact,j
               if(ipufcd(i).EQ.99) then
c ---             Inactive puff found, replace it and EXIT do-i
                  call swap(i,j)
                  goto 10
               endif
            enddo
c ---       Inactive puff NOT found, replacement complete: EXIT do-j
            goto 50

10          inact=i
         endif
      enddo

50    continue
c --- Reset number of "old" puffs/slugs
      ntop=npuffs
      npuffs=j
c
c --- Inactive indices have been filled; place new puffs already
c --- initialized at the top of the arrays
      do ii=1,nnew
         i=npuffs+ii
         j=ntop+ii
         call swap(i,j)
      enddo
c
c --- Reset the index for the last puff/slug initialized
      np0=np
      np=npuffs+nnew

c --- Report activity to screen (controlled by IMESG)
      if(imesg.GT.0) then
         nlost=np0-np
         print 9,nlost
9        format('+',44x,'-',i8,' inactive puffs removed')
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine swap(i,j)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                   SWAP
c                D. Strimaitis,  Earth Tech
c
c --- PURPOSE:  Transfers puff/slug array elements from index "J"
c               to index "I".  If J=0, array elements are initialized
c               to ZERO.
c
c --- UPDATE
c --- V5.72-V5.8.4  130731  (EPA): Added call to SWAPTAB to perform
c ---                              transfer of tabulated source data
c --- V5.4-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.0-V5.4     010730  (DGS): SYSRC0, SZSRC0 arrays added
c --- V5.0-V5.0     980615  (DGS): SPEED0 array added
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c                   971107  (DGS): STIPDW array added
c
c --- INPUTS:
c             I - integer - New index
c             J - integer - Old index
c
c     Common block /GEN/ variables:
c           NSPEC
c     Common block /PUFF/ variables:
c           all variables
c     Common block /SLUG/ variables:
c           all variables
c     Parameters:
c           MXPUFF, MXSPEC
c
c --- OUTPUT:
c     Common block /PUFF/ variables:
c           all variables
c     Common block /SLUG/ variables:
c           all variables
c
c --- SWAP called by: ROLLDN, SPLIT, AREAS1, AREAS2, POINTS1, POINTS2,
c                     VOLS, LINES1, LINES2, BCS1
c --- SWAP calls:     SWAPTAB
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'gen.puf'
      include 'puff.puf'
      include 'slug.puf'

      data zero/0.0/

      if(j.GT.0) then

c ---       Source tables in Direct Access file
            call SWAPTAB(i,j)

c ---       PUFF.PUF
            xpb(i)       =xpb(j)
            ypb(i)       =ypb(j)
            zpb(i)       =zpb(j)
            zimax(i)     =zimax(j)
            ziold(i)     =ziold(j)
            zitibl(i)    =zitibl(j)
            sigyb(i)     =sigyb(j)
            sigzb(i)     =sigzb(j)
            xtotb(i)     =xtotb(j)
            tmtotb(i)    =tmtotb(j)
            zfinal(i)    =zfinal(j)
            xfinal(i)    =xfinal(j)
            bidfnl(i)    =bidfnl(j)
            fb(i)        =fb(j)
            fm(i)        =fm(j)
            xbfin(i)     =xbfin(j)
            xmfin(i)     =xmfin(j)
            zbfin(i)     =zbfin(j)
            zmfin(i)     =zmfin(j)
            stipdw(i)    =stipdw(j)
            do is=1,nspec
               qu(is,i)  =qu(is,j)
               qm(is,i)  =qm(is,j)
            enddo
            irlsnum(i)   =irlsnum(j)
            isrcnum(i)   =isrcnum(j)
            isrctyp(i)   =isrctyp(j)
            ipufcd(i)    =ipufcd(j)
            elbase(i)    =elbase(j)
            do i3=1,3
               do i2=1,2
                  tcon(i3,i2,i)  =tcon(i3,i2,j)
               enddo
            enddo
            isplit(i)    =isplit(j)
            idw0(i)      =idw0(j)
            ht0(i)       =ht0(j)
            exitw0(i)    =exitw0(j)
            diam0(i)     =diam0(j)
            ws0(i)       =ws0(j)
            istab0(i)    =istab0(j)
            sqrts0(i)    =sqrts0(j)
            srat0(i)     =srat0(j)
            temit0(i)    =temit0(j)
            hb0(i)       =hb0(j)
            hw0(i)       =hw0(j)
            heff20(i)    =heff20(j)
            iru0(i)      =iru0(j)
            sigv0(i)     =sigv0(j)
            sigw0(i)     =sigw0(j)
            el0(i)       =el0(j)
            plexp0(i)    =plexp0(j)
            zly0(i)      =zly0(j)
            r0(i)        =r0(j)
            sysrc0(i)    =sysrc0(j)
            szsrc0(i)    =szsrc0(j)
            xshift0(i)   =xshift0(j)
            sy0(i)       =sy0(j)
            sz0(i)       =sz0(j)

c ---       SLUG.PUF
            xpe(i)       =xpe(j)
            ype(i)       =ype(j)
            zpe(i)       =zpe(j)
            sigye(i)     =sigye(j)
            sigze(i)     =sigze(j)
            xtote(i)     =xtote(j)
            tmtote(i)    =tmtote(j)
            speed0(i)    =speed0(j)

      else

c ---       PUFF.PUF
            xpb(i)       =zero
            ypb(i)       =zero
            zpb(i)       =zero
            zimax(i)     =zero
            ziold(i)     =zero
            zitibl(i)    =zero
            sigyb(i)     =zero
            sigzb(i)     =zero
            xtotb(i)     =zero
            tmtotb(i)    =zero
            zfinal(i)    =zero
            xfinal(i)    =zero
            bidfnl(i)    =zero
            fb(i)        =zero
            fm(i)        =zero
            xbfin(i)     =zero
            xmfin(i)     =zero
            zbfin(i)     =zero
            zmfin(i)     =zero
            stipdw(i)    =zero
            do is=1,nspec
               qu(is,i)  =zero
               qm(is,i)  =zero
            enddo
            irlsnum(i)   =0
            isrcnum(i)   =0
            isrctyp(i)   =0
            ipufcd(i)    =0
            elbase(i)    =zero
            do i3=1,3
               do i2=1,2
                  tcon(i3,i2,i)  =zero
               enddo
            enddo
            isplit(i)    =0
            idw0(i)      =0
            ht0(i)       =zero
            exitw0(i)    =zero
            diam0(i)     =zero
            ws0(i)       =zero
            istab0(i)    =0
            sqrts0(i)    =zero
            srat0(i)     =zero
            temit0(i)    =zero
            hb0(i)       =zero
            hw0(i)       =zero
            heff20(i)    =zero
            iru0(i)      =0
            sigv0(i)     =zero
            sigw0(i)     =zero
            el0(i)       =zero
            plexp0(i)    =zero
            zly0(i)      =zero
            r0(i)        =zero
            sysrc0(i)    =zero
            szsrc0(i)    =zero
            xshift0(i)   =zero
            sy0(i)       =zero
            sz0(i)       =zero

c ---       SLUG.PUF
            xpe(i)       =zero
            ype(i)       =zero
            zpe(i)       =zero
            sigye(i)     =zero
            sigze(i)     =zero
            xtote(i)     =zero
            tmtote(i)    =zero
            speed0(i)    =zero

      endif

      return
      end
c----------------------------------------------------------------------
      function vemfac(ldb,ivary,iq12,tdegk,ws,istab)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602                 VEMFAC
c                D. Strimaitis, EARTH TECH
c
c --- PURPOSE:  Provide a scaling factor for the emission rate from
c               values provided in the control file
c
c --- UPDATES
c --- V5.2-V5.4     000602  (DGS): add message to "stop"
c --- V5.1-V5.2     991104  (JSS): Error messages written to list
c                                  file as well as to screen
c --- V5.0-V5.0     981228  (DGS): alter ITCAT eqn to obtain T bins
c                                  listed in control file
c                   980918  (DGS): Impose ITCAT=1 as lower limit
c
c --- INPUTS:
c           LDB - logical       - Output debug writes when .TRUE.
c         IVARY - integer       - Type of emission variability
c                                  0:  NO variation
c                                  1:  Diurnal (24 values)
c                                  2:  Monthly (12 values)
c                                  3:  Hour & Season (96 values)
c                                  4:  Speed & Stability (36 values)
c                                  5:  Temperature (12 values)
c          IQ12 - integer       - Pointer to starting location in VQFAC
c         TDEGK - real          - Ambient temperature (K)
c            WS - real          - Wind speed (m/s)
c         ISTAB - integer       - Stability class - PG
c
c     Common block /COMPARM/:
c           WSCAT(5), VQFAC(12,mxq12), IQNUM(5),
c     Common block /DATEHR/:
c           nmo,nhrind
c     Parameters:
c           MXQ12
c
c --- OUTPUT:
c        VEMFAC - real          - Emission rate factor for current
c                                 conditions
c
c --- VEMFAC called by:  POINTS1, AREAS1, LINES1, VOLS
c --- VEMFAC calls:      none
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include commons
      include 'comparm.puf'
      include 'datehr.puf'

      logical ldb
      integer iseas(12)

      data iseas/1,1,2,2,2,3,3,3,4,4,4,1/

c --- Select factor based on type of variation
      if(ivary.EQ.0) then
c ---    No variation
         vemfac=1.0
         return
      elseif(ivary.EQ.1) then
c ---    Diurnal (24 values)
         j=iq12
         n12=nhrind
         if(n12.GT.12) then
            n12=n12-12
            j=j+1
         endif
         vemfac=vqfac(n12,j)
      elseif(ivary.EQ.2) then
c ---    Monthly (12 values)
         j=iq12
         n12=nmo
         vemfac=vqfac(n12,j)
      elseif(ivary.EQ.3) then
c ---    Hour & Season (96 values)
         j=iq12+(iseas(nmo)-1)*2
         n12=nhrind
         if(n12.GT.12) then
            n12=n12-12
            j=j+1
         endif
         vemfac=vqfac(n12,j)
      elseif(ivary.EQ.4) then
c ---    Speed & Stability (36 values)
         iws=1
         do ii=1,5
            if(ws.GT.wscat(ii)) iws=ii+1
         enddo
         if(istab.LE.2) then
            j=iq12
            n12=iws+6*(istab-1)
         elseif(istab.LE.4) then
            j=iq12+1
            n12=iws+6*(istab-3)
         else
            j=iq12+2
            n12=iws+6*(istab-5)
         endif
         vemfac=vqfac(n12,j)
      elseif(ivary.EQ.5) then
c ---    Temperature (12 values)
         itcat=0.2*(tdegk-268.16)+1
         itcat=MIN0(itcat,12)
         itcat=MAX0(itcat,1)
         j=iq12
         n12=itcat
         vemfac=vqfac(n12,j)
      else
         write(io6,*)'VEMFAC -- FATAL Error, Invalid IVARY = ',ivary
         write(*,*)
         stop 'Halted in VEMFAC -- see list file.'
      endif

c --- Debug output
      if(LDB) then
         write(io6,*)'VEMFAC --   ivary,iq12: ',ivary,iq12
         write(io6,*)'           T, ws, stab: ',tdegk,ws,istab
         write(io6,*)'           j, n12, fac: ',j,n12,vemfac
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine lines2(ig,nspec,dthr,xtmp1,ldbhr,mfact,metfm,np,
     &                  newpuf,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                 LINES2
c                D. Strimaitis,  EARTH TECH
c
c --- PURPOSE:  Initialize newly released puff/slug variables for
c               LINE SOURCES with variable parameters (one group
c               processed)
c
c --- UPDATE
c --- V5.831-V5.8.4 130731  (EPA): PLEXP is explicitly assigned a
c                                  missing value in BLOCK DATA and
c                                  must be be replaced with default if
c                                  it remains missing here
c                           (EPA): Apply minimum floor to the downwash
c                                  sigmas stored in SY0,SZ0 arrays
c --- V5.75-V5.8.4  130731  (EPA): Place rise tables in DA file
c --- V5.74-V5.75   050225  (DGS): Add DPBL arg to SETCSIG for TAULY
c --- V5.72-V5.74   040715  (DGS): add METFM=5 (AERMET)
c --- V5.4-V5.72    031017  (DGS): IRLSNUM,ISRCNUM,ISRCTYP replace
c                                  IPUFID
c --- V5.0-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.0     980807  (DGS): use final rise CALMET/PROFILE winds
c                                  to set release step
c --- V5.0-V5.0     980515  (DGS): ZITIBL array added
c --- V4.0-V5.0     971107  (DGS): ZPB,ZPE arrays added
c
c --- INPUTS:
c            IG - integer - Index for line source group processed
c         NSPEC - real    - Number of species modeled
c          DTHR - real    - Length (seconds) of a basic time step
c         XTMP1 - real    -
c         LDBHR - logical - Control variable for debug write statements
c                           (T = write, F = do not write)
c         MFACT - integer - Stepping index to identify slugs vs puffs
c         METFM - integer - Meteorological data format
c            NP - integer - Index of last puff/slug initialized
c        NEWPUF - integer - Number of new puffs/slugs released
c                           during the current time step
c
c     Common block /COMPARM/ variables:
c           XMXLEN, MXNEW, SYMIN, SZMIN, WSCALM, PLX0
c     Common block /FLAGS/ variables:
c           MGAUSS, MSLUG, MTIP, MHFTSZ, MSHEAR
c     Common block /GRID/ variables:
c           DGRID, IBCOMP, IECOMP, JBCOMP, JECOMP
c     Common block /LN2/ variables:
c           NLINES2,NL2(mxlngp),XL2(mxlngrp),HBL2(mxlngrp),
c           WBL2(mxlngrp),WML2(mxlngrp),DXL2(mxlngrp),FPRIMEL2(mxlngrp),
c           WSEP2(mxlngrp),FPTOT2(mxlngrp),FBPT2(mxlngrp),
c           ILNGRP(mxlines),XL2BEGGRD(mxlines),YL2BEGGRD(mxlines),
c           XL2ENDGRD(mxlines),YL2ENDGRD(mxlines),HSL2(mxlines),
c           BELEVL2(mxlines),XVERTL2(4,mxlines),YVERTL2(4,mxlines),
c           XL2BAR(mxlngrp),YL2BAR(mxlngrp),ORIENTL2(mxlngrp),
c           ARLINE2(mxlines),NSEG2(mxlines),QTL2(mxspec,mxlines),
c           NLRISE2
c
c     Common block /METHR/ variables:
c           PLEXP
c     Common block /PUFF/ variables:
c           NPUFFS
c     Parameters:
c           MXRISE, MXLINES, MXLNGRP, MXSPEC, IO6
c
c --- OUTPUT:
c            NP - integer - UPDATED index of last puff/slug initialized
c        NEWPUF - integer - UPDATED number of new puffs/slugs released
c                           during the current time step
c       PROBLEM - logical - Set true if fatal problem encountered
c
c     Common block /LN2/ variables:
c           NEWLN2(mxlines), NSEG2(mxlines),
c     Common block /PUFF/ variables:
c           all variables in common block
c     Common block /SLUG/ variables:
c           all variables in common block
c     Common block /SRCTAB/ variables:
c           NTR, XTR(mxrise), ZTR(mxrise)
c
c --- LINES2 called by:  INITPUF
c --- LINES2 calls:      RLSMET, ROLLDN, HEFTRAN, SIGTY, SIGTZ, SETLINE,
c                        SWAP, INJECT, ZEROTAB, SRCTABOUT
c----------------------------------------------------------------------
c
      include 'params.puf'

      include 'comparm.puf'
      include 'csigma.puf'
      include 'flags.puf'
      include 'grid.puf'
      include 'methr.puf'
      include 'ln2.puf'
      include 'puff.puf'
      include 'slug.puf'
      include 'srctab.puf'

      real q(mxspec)
      logical ldbhr,problem,lcalm

c --- Set minimum allowed wind speed for building downwash (.GE.1)
      data wsdw0/1.0/

      data oneby2pi/0.1591549/,rt2pi/2.5066283/,rt2bypi/0.7978846/
      data zero/0.0/

c ***
      if(ldbhr) then
         write(io6,*)
         write(io6,*) 'LINES2:  Processing Line Group ',ig
      endif
c ***
c
c -------------------------------------------------------------------
c --- Get met data for block of line sources
c -------------------------------------------------------------------
c
c --- Determine the met. grid point closest to the CENTER of the array
c --- of line sources
      ixs=1.0+xl2bar(ig)
      iys=1.0+yl2bar(ig)
c
c --- Source off the computational grid -- write a FATAL message
      if(ixs.lt.ibcomp.or.ixs.gt.iecomp.or.iys.lt.jbcomp.or.iys.gt.
     1   jecomp)then
         write(io6,20)ig,ixs,iys
20       format(/1x,'FATAL -- a line source with constant emissions ',
     1   'is off the computational grid'/1x,'source no. (i) = ',i6,2x,
     2   'nearest grid point (ixs,iys) = (',i5,',',i5,')')
         problem=.TRUE.
         return
      endif
c
c --- Initialize source tabulation arrays to zero
      call ZEROTAB
c
c --- Extract wind speed & other met. variables;
c --- and set CALM configuration if triggered
      call rlsmet(ldbhr,ixs,iys,hbl2(ig),mfact,
     &            mfact0,ilayer,ws,flow,ivec,istab,dpbl,el,
     &            ustr,wstr,tsigv,tsigw,iru,issta,sqrts,idopty,idoptz)
c
c --- Set logical to identify calm conditions
      if(ws.LT.wscalm) then
         lcalm=.TRUE.
      else
         lcalm=.FALSE.
      endif
c
c ---    Trap missing power-law exponent (substitute default)
         if(plexp.LT.-900.) then
c ---       Use default
            plx=plx0(istab)
         else
c ---       Use it
            plx=plexp
         endif

c --- Calculate the virtual times and sigmas at Heffter transition
      uavg=amax1(.5,ws)
c
c --- Set selected data in /CSIGMA/ for sigma calls
      call setcsig(idopty,idoptz,iru,uavg,istab,el,sqrts,
     &            tsigv,tsigw,symin,szmin,hbl2(ig),dpbl)
c
      if(mhftsz.EQ.0)then
         szh=syh
         call sigty(syh,zero,zero,dum,thfty,dhfty)
      else
         call heftran(1,hsl2(1),symin,szmin,zero,zero,zero,zero)
      endif
c
c --------------------------------------------------------------------
c --- Calculate modified plume rise parameters for group, and tabulate
c --- rise from point of full buoyancy (XFB) to point of final rise
c --------------------------------------------------------------------
c
c --- Find angle between flow and orientation of line sources (theta)
      theta=flow-orientl2(ig)
c
c --- Compute attributes of the line sources for this meteorology,
c --- and update rise tabulation
      ntr=nlrise2
      call setline(mshear,theta,ws,istab,sqrts,plx,nl2(ig),xl2(ig),
     &             hbl2(ig),wml2(ig),fprimel2(ig),wsep2(ig),fptot2(ig),
     &             fbpt2(ig),ntr,xle,xld,rzero,xtr,ztr)
c
c --- Set trig. factors for flow direction
      sinf=sin(flow)
      cosf=cos(flow)
c
c --- Find the along-flow coordinate that defines the line source
c --- element furthest upwind: (YY0GRD in met grid units)
c --- Rotate coord. system to place the yy-axis along the flow (line 1)
      do il=nlines2,1,-1
         if(ilngrp(il).EQ.ig) il1=il
      enddo
      yybeg=xl2beggrd(il1)*sinf+yl2beggrd(il1)*cosf
      yyend=xl2endgrd(il1)*sinf+yl2endgrd(il1)*cosf
      yy0grd=amin1(yybeg,yyend)
c --- Continue with other lines, if used
      do i=2,nl2(ig)
         lni=i-1+il1
         yy=xl2beggrd(lni)*sinf+yl2beggrd(lni)*cosf
         yy0grd=amin1(yy0grd,yy)
         yy=xl2endgrd(lni)*sinf+yl2endgrd(lni)*cosf
         yy0grd=amin1(yy0grd,yy)
      enddo

c --- Use CALMET/PROFILE winds at final rise to set release/sampling
c --- data
      if(metfm.EQ.1 .OR. metfm.EQ.4 .OR. metfm.EQ.5) then
         heff=hbl2(ig)+ztr(ntr)
         call rlsmet(ldbhr,ixs,iys,heff,mfact,
     &               mfact0fr,ilayerfr,wsfr,flowfr,ivecfr,istab,dpbl,el,
     &               ustr,wstr,tsigvfr,tsigwfr,iru,issta,sqrtsfr,
     &               idoptyfr,idoptzfr)
         wsnew=AMAX1(ws,wsfr)
      else
         wsnew=ws
      endif
c
c******
      if(ldbhr)then
         write(io6,204) ilayer,ixs,iys,ws,istab,dpbl,issta,theta
204      format(5x,'ILAYER: ',i3,2x,'IXS: ',i4,2x,
     1    'IYS: ',i4,2x,'WS: ',f5.1,2x,'ISTAB: ',i1,2x,'DPBL: ',
     2    f7.1,2x,'ISSTA: ',i4,2x,'THETA: ',f5.1)
c
         write(io6,206) xtr(1),ztr(1),xle,xld,
     1                  xtr(ntr),ztr(ntr)
206      format(5x,'XFB : ',f6.1,2x,'ZFB : ',f6.1,2x,'XLE : ',
     1    f6.1,2x,'XLD : ',f6.1,2x,'XFIN0: ',f6.1,2x,'ZFIN0: ',f6.1)
c
      endif
c*****
c
c --------------------------------------------------
c --- Loop over lines
c --------------------------------------------------
c
      do 100 i=1,nlines2

c --- Skip line sources that are not in current group
      if(ilngrp(i).NE.ig) goto 100

c --- Rotate coord. system to place the yy-axis along the flow
      xxbeg=xl2beggrd(i)*cosf-yl2beggrd(i)*sinf
      xxend=xl2endgrd(i)*cosf-yl2endgrd(i)*sinf
      yybeg=xl2beggrd(i)*sinf+yl2beggrd(i)*cosf
      yyend=xl2endgrd(i)*sinf+yl2endgrd(i)*cosf

c --- Find cross-wind and along-wind length of this line in meters
      xcrossm=abs(xxbeg-xxend)*dgrid
      yalongm=abs(yybeg-yyend)*dgrid

c --- Compute the number of puffs/slugs released this hour
c --- from this line source
      npnew=wsnew*xtmp1+1
      npnew=max0(npnew,1)
      npnew=min0(npnew,mxnew)
      newln2(i)=npnew
c
c --- DT is the time (sec) over which each puff is emitted
      dt=dthr/float(npnew)

c ---------------------------------------------------------
c --- Compute number of segments needed for one line (NSEG)
c ---------------------------------------------------------
      if(mslug.EQ.0 .OR. lcalm) then
c ---    Puffs are released, so use all MXNSEG segments
         nsegy=0
         nsegz=0
         nseg2(i)=mxnseg2
      else
c ---    Slugs are released
c
c ---    Calculate the virtual times and sigmas at Heffter transition
         if(mhftsz.EQ.0)then
            szh=syh
            call sigty(syh,zero,zero,dum,thfty,dhfty)
         else
            call heftran(1,hsl2(i),syab1,szab1,zero,zero,zero,zero)
         endif
c ---    Set NSEGY as function of transport speed, sigma-y,
c ---    and cross-wind length of line (make it an ODD integer)
         thalf=0.5*dt
         xhalfkm=0.001*uavg*thalf
         call sigty(zero,xhalfkm,thalf,syhalf,dum,dum)
         nsegy=nint(xcrossm/(rt2pi*syhalf))
         iodd=mod(nsegy,2)
         if(iodd.EQ.0) nsegy=nsegy+1
c ---    Set NSEGZ as function of transport speed, sigma-z, release ht,
c ---    and along-wind change in rise (make it an ODD integer)
         call sigtz(zero,xhalfkm,thalf,hsl2(i),szhalf,dum,dum)
         nsegz=nint(2.0*ztr(1)/szhalf)
         iodd=mod(nsegz,2)
         if(iodd.EQ.0) nsegz=nsegz+1
c ---    Take the larger of the two
         nseg2(i)=MAX0(nsegz,nsegy)
c ---    Cap result at MXNSEG
         nseg2(i)=MIN0(nseg2(i),mxnseg2)
      endif

c --- Line releases npnew clouds this hour, with nseg elements
c --- in each cloud
      newpuf=newpuf+npnew*nseg2(i)
c --- If puff arrays are full, remove puffs that are off the grid
c --- and "roll down" arrays to make room for new puffs
c --- (this also applies to the DA file of tabulated arrays)
      if(npuffs+newpuf.gt.mxpuff) call rolldn(np)
c --- Check to see if roll-down was adequate
      if(npuffs+newpuf.gt.mxpuff)then
         write(io6,*) ' ERROR in subr. LINES2'
         write(io6,*)'Too many puffs on grid for array dimensions -- ',
     1   'NPUFFS (old puffs) = ',npuffs,' NEWPUF = ',newpuf,
     2   ' MXPUFF = ',mxpuff
         write(*,*)
         stop 'Halted in LINES2 -- see list file.'
      endif
c
c --------------------------------------------------------------------
c --- Calculate building downwash effects on initial plume sigmas
c --------------------------------------------------------------------
c --- Initialize downwash variables to zero (no building downwash)
      sz0dw=0.0
      sy0dw=0.0
      idw=0
      if(ws.GT.wsdw0 .AND. .NOT.lcalm) then
c ---    Set downwash flag to ACTIVE
         idw=1
c ---    Use BLP calculation of downwash sigmas
         sz0dw=rt2bypi*rzero
         sy0dw=0.5*sz0dw
      endif
c
c --- Set initial sigma y, sigma z for puff/slug, including effective
c --- spread due to length of line source element (add length effects
c --- and downwash effects in quadrature)
c --- Crosswind variance: 0.25*(line width)**2/(2pi)
      if(lcalm) then
         xlen2=(xcrossm**2+yalongm**2)/(nseg2(i)**2)
      else
         xlen2=(xcrossm/nseg2(i))**2
      endif
      sy2=0.25*oneby2pi*xlen2+sy0dw*sy0dw
      sysrc=amax1(symin,sqrt(sy2))
c --- Alongwind variance: 0.25*(line length * rise rate)**2/(2pi)
      if(lcalm) then
         sz2=0.0
         szsrc=szmin
      else
         sz2=0.25*oneby2pi*((yalongm/nseg2(i))*
     &                      ztr(1)/xtr(1))**2+sz0dw*sz0dw
         szsrc=amax1(szmin,sqrt(sz2))
      endif
c
c --- Swap emission rate for source 'i' into 1D array
      do is=1,nspec
         q(is)=qtl2(is,i)
      enddo
c******
      if(ldbhr)then
         write(io6,*)
         write(io6,*) 'Line Source # ',i
         write(io6,*)
         write(io6,*) 'LINES2:  thalf,xhalfkm = ',thalf,xhalfkm
         write(io6,*) '          syhalf,nsegy = ',syhalf,nsegy
         write(io6,*) '          szhalf,nsegz = ',szhalf,nsegz
         write(io6,*) '                  nseg = ',nseg2(i)
         write(io6,208) xcrossm,npnew,newpuf,dt,
     2                  idw,rzero,sysrc,szsrc
208      format(5x,'XCROSSM: ',f6.1,2x,
     2    'NPNEW: ',i4,2x,'NEWPUF: ',i5,2x,'DT: ',f7.2,2x/5x,
     3    'IDW: ',i3,2x,'RZERO: ',f6.1,2x,'SYSRC: ',f6.1,2x,
     4    'SZSRC: ',f6.1)
      endif
c*****
c
c -------------------------------------------------------------
c --- Loop over "point" sources (each segment) along line
c -------------------------------------------------------------
c
c --- Set up the distance increments along the line
      dxgrd=(xl2endgrd(i)-xl2beggrd(i))/nseg2(i)
      dxgrdby2=0.5*dxgrd
      dygrd=(yl2endgrd(i)-yl2beggrd(i))/nseg2(i)
      dygrdby2=0.5*dygrd

      do 90 ipt=1,nseg2(i)

c ---  Set location in met grid units
       xptgrd=xl2beggrd(i)+(ipt-1)*dxgrd+dxgrdby2
       yptgrd=yl2beggrd(i)+(ipt-1)*dygrd+dygrdby2

c ---  Set the shift in distance (m) of this point from the upwind edge
       yyptgrd=xptgrd*sinf+yptgrd*cosf
       xshift=(yyptgrd-yy0grd)*dgrid
       if(xshift.LT.0.0) xshift=0.0
       if(xshift.GT.xtr(1)) xshift=xtr(1)

c ---  Set the final height and distance to final rise for this puff
       if(lcalm) then
          xshift=0.0
          xfrise=0.0
          heff=hsl2(i)+ztr(ntr)
       else
          if(xtr(1).LE.xtr(ntr)) then
c ---        Case 1:  final rise reached beyond XFB
             heff=hsl2(i)+ztr(ntr)-xshift*ztr(1)/xtr(1)
             xfrise=xtr(ntr)-xshift
          else
c ---        Case 2:  final rise reached before XFB
             size=1.0-xshift/xtr(1)
             heff=hsl2(i)+ztr(ntr)*size
             xfrise=xtr(ntr)*size
          endif
       endif
c
c******
      if(ldbhr)then
         write(io6,*) 'Element #  ',ipt
         write(io6,210) hsl2(i),heff,xfrise,xshift,xptgrd,yptgrd
210      format(5x,'HSL : ',f6.1,2x,'HEFF: ',f6.1,'XFRISE: ',f6.1,2x,
     1    'XSHIFT: ',f6.1,2x,'XPTGRD: ',f8.4,2x,'YPTGRD: ',f8.4)
      endif
c*****
c ----------------------------------------------------------
c ---    Initialize current hour's new puffs for this source
c ----------------------------------------------------------
         do 50 j=1,npnew
         np=np+1
c
c ---    Use SWAP to start with all puff/slug variables equal to zero
         call swap(np,0)
c
c ---    Fill non-zero values
         xpb(np)=xptgrd
         ypb(np)=yptgrd
         zitibl(np)=-1.0
         elbase(np)=belevl2(i)
         sigyb(np)=sysrc
         sigzb(np)=szsrc
c ---    Final plume rise results for puff
         zfinal(np)=heff
         zpb(np)=heff
         zpe(np)=heff
         xfinal(np)=xfrise
c ---    Intermediate results for calc. gradual rise
         fb(np)=fbpt2(ig)
c ---    Set xbfin and zbfin to negatives to signal use of final
c ---    rise if calm
         if(lcalm) then
            xbfin(np)=-1.0
            zbfin(np)=-1.0
         else
            xbfin(np)=xtr(ntr)
            zbfin(np)=ztr(ntr)
         endif
         isplit(np)=1
c ---    Time-of-release data
         ht0(np)=hsl2(i)
         temit0(np)=dt
         ws0(np)=ws
         istab0(np)=istab
         sqrts0(np)=sqrts
         iru0(np)=iru
         sigv0(np)=tsigv
         sigw0(np)=tsigw
         el0(np)=el
         plexp0(np)=plx
c ---    Set vector/scalar ws ratio to 1.0
         srat0(np)=1.0
c ---    Additional time-of-release parameters needed for
c ---    receptor-specific calculations (downwash - point sources)
         idw0(np)=idw
         hb0(np)=hsl2(i)
         hw0(np)=xcrossm
         heff20(np)=hsl2(i)
         zly0(np)=xld
         r0(np)=rzero
c ---    Additional data for line sources
         xshift0(np)=xshift
         sy0(np)=AMAX1(sy0dw,symin)
         sz0(np)=AMAX1(sz0dw,szmin)

c ---    Set puff identity where IRLSNUM is the puff number released
c ---    from a source this time step, ISRCNUM is the source number
c ---    of type ISRCTYP from which the puff was released.
c ---    (Type =6 for variable line sources)
         irlsnum(np)=j
         isrcnum(np)=i
         isrctyp(np)=6
c
c ---    !-NOTE 1-!
c ---    The puff number really refers to the number of emission
c ---    steps, which equals the puff number when ONE puff is released
c ---    from a source each emission step.  But many puffs are released
c ---    each step when simulating a line source (distributed along
c ---    the line).  Subsequent use is made of IRLSNUM in controlling
c ---    sampling functions, which depend on the emission steps, so we
c ---    explicitly place the emission-step index in the array.
c
c ----------------------------------------------------------
c ---    Do same for additional SLUG parameters
c ----------------------------------------------------------

c ---    !-NOTE 2-!
c ---    OLD slugs from each segment are modeled explicitly, but
c ---    NEW releases are modelled using the numerical area-source
c ---    method for the ENTIRE line.  Therefore, we add a marker to
c ---    all slugs after segment 1, so that these can be identified
c ---    and ignored when NEW.  The marker consists of adding 1000 to
c ---    ISRCNUM, which would indicate that the puff comes from
c ---    line-source ISRCNUM=1000+i.  A check is made in READCF which
c ---    stops execution if parameter (mxlines .GE. 1000) to insure
c ---    that no valid line-source ID exceeds 999.
c
         if(mslug.eq.1 .AND. .NOT.lcalm) then
c
c ---       Set PUFID marker
            if(ipt.GT.1) isrcnum(np)=isrcnum(np)+1000
c
c ---       Set coordinates of oldest end of slug (in met. grid units)
c ---       Note that "oldest" end of slug is at the source, as is the
c ---       "newest" end; oldest end moves away and grows during the
c ---       step, while newest end remains fixed in size at the source.
            xpe(np)=xpb(np)
            ype(np)=ypb(np)
            xtote(np)=xtotb(np)
            tmtote(np)=tmtotb(np)
c ---       Set sigmas for oldest end of slug
            sigye(np)=sigyb(np)
            sigze(np)=sigzb(np)
         endif
c
c ------------------------------------------------------------------
c ---    Inject emissions into proper layer (above/below mixing ht.)
c ------------------------------------------------------------------
c ---    Set partial penetration variables to null values
         fmix=1.0
         hmax=dpbl
c ---    Mass emitted into each line segment needs to be divided by
c ---    nseg, which is the number of segments.  Accomplish that here
c ---    by dividing the timestep by nseg.
         dtseg=dt/nseg2(i)
         call inject(np,nspec,dtseg,mfact0,q,heff,hmax,dpbl,fmix,istab)
c
c ------------------------------------------------------------------
c ---    Transfer tabulated arrays record to DA file using full
c ---    MXRISE dimension
c ------------------------------------------------------------------
         call SRCTABOUT(np,isrctyp(np),isrcnum(np),irlsnum(np))
50       continue
90     continue
100   continue

      return
      end
c----------------------------------------------------------------------
      subroutine ln2fill(lngrp,nsrc5,em5grp,em5dat,nvarln,problem)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                LN2FILL
c                D. Strimaitis,  EARTH TECH
c
c --- PURPOSE:  Fill common /LN2/ for LINE SOURCES with variable
c               parameters
c
c --- UPDATE
c --- V5.71-V5.8.4  130731  (EPA): initialize PROBLEM to false
c --- V5.0-V5.71    030528  (DGS): require non-negative emissions
c --- V5.0-V5.0     980430  (DGS): add number of variables before
c                                  emissions in EM5DAT as argument
c
c --- INPUTS:
c            LNGRP - integer - Number of groups of line sources
c                              active this period
c            NSRC5 - integer - Max number of lines in  LNEMARB file
c  EM5GRP(7,lngrp) - real ar - Time-varying LNEMARB group data
c  EM5DAT(nse5+nvarln,nsrc5)
c                  - real ar - Time-varying LNEMARB line data
c           NVARLN - integer - Number of variables in EM5DAT array
c                              before emissions
c          PROBLEM - logical - Flag indicating errors are found
c                              when true
c
c     Common block /GRID/ variables:
c           DGRID, DGRIDI, XORIG, YORIG
c
c     Parameters:
c           MXLINES, MXLNGRP, MXSPEC
c
c --- OUTPUT:
c          PROBLEM - logical - Flag indicating errors are found
c                              when true (updated here)
c
c     Common block /LN2/ variables:
c           NSE5,NLINES2,NL2(mxlngrp),XL2(mxlngrp),HBL2(mxlngrp),
c           WBL2(mxlngrp),WML2(mxlngrp),DXL2(mxlngrp),FPRIMEL2(mxlngrp),
c           WSEP2(mxlngrp),FPTOT2(mxlngrp),FBPT2(mxlngrp),
c           ILNGRP(mxlines),XL2BEGGRD(mxlines),YL2BEGGRD(mxlines),
c           XL2ENDGRD(mxlines),YL2ENDGRD(mxlines),HSL2(mxlines),
c           BELEVL2(mxlines),XVERTL2(4,xlines),YVERTL2(4,mxlines),
c           XL2BAR(mxlngrp),YL2BAR(mxlngrp),ORIENTL2(mxlngrp),
c           ARLINE2(mxlines),QTL2(mxspec,mxlines)
c
c --- LN2FILL called by:  INITPUF
c --- LN2FILL calls:      none
c----------------------------------------------------------------------
c
      include 'params.puf'
      include 'grid.puf'
      include 'ln2.puf'

      real em5dat(nse5+nvarln,nsrc5),em5grp(7,lngrp)
      logical problem,lqneg

c --- Initialize PROBLEM
      problem=.FALSE.

c --- Loop over line groups
      nlines2=0
      do ig=1,lngrp
         nlprev=nlines2
         nl2(ig)=NINT(em5grp(1,ig))
         nlines2=nlines2+nl2(ig)
         xl2(ig)=em5grp(2,ig)
         hbl2(ig)=em5grp(3,ig)
         wbl2(ig)=em5grp(4,ig)
         wml2(ig)=em5grp(5,ig)
         dxl2(ig)=em5grp(6,ig)
         fprimel2(ig)=em5grp(7,ig)
c ---    Separation between centers of adjacent lines (average)
         wsep2(ig)=wbl2(ig)+dxl2(ig)
c ---    Total buoyancy flux from all line sources in block
         fptot2(ig)=fprimel2(ig)*em5grp(1,ig)
c ---    Corresponding point-source buoyancy flux (fptot/pi)
         fbpt2(ig)=fptot2(ig)*0.3183099
c ---    Set half average line width for area calculations below
         wmlby2=0.5*wml2(ig)
         wmlby2=FLOAT(INT(wmlby2)+1)
c ---    Loop over lines
         do i=nlprev+1,nlines2
            ilngrp(i)=ig
            xl2beggrd(i)=(1000.*em5dat(1,i)-xorig)*dgridi
            yl2beggrd(i)=(1000.*em5dat(2,i)-yorig)*dgridi
            xl2endgrd(i)=(1000.*em5dat(3,i)-xorig)*dgridi
            yl2endgrd(i)=(1000.*em5dat(4,i)-yorig)*dgridi
            hsl2(i)=em5dat(5,i)
            belevl2(i)=em5dat(6,i)
            lqneg=.FALSE.
            do is=1,nse5
               iq=is+nvarln
               qtl2(ixrem5(is),i)=em5dat(iq,i)
               if(qtl2(ixrem5(is),i).LT.0.0) lqneg=.TRUE.
            enddo
c ---       Report problem if any emissions are negative
            if(lqneg) then
               write(io6,*)
               write(io6,*)'*********  FATAL  ***********'
               write(io6,*)'ERROR in subr. INITPUF -- Invalid ',
     1         'emission rate  (must NOT be negative)'
               write(io6,*)' -- LNEMARB Source = ',i
               problem=.TRUE.
            endif
c
c ---       Compute the vertex coordinates for corresponding
c ---       area-source representation
            xdiffm=(xl2beggrd(i)-xl2endgrd(i))*dgrid
            ydiffm=(yl2beggrd(i)-yl2endgrd(i))*dgrid
c ---       Let "c" denote 1/slope of line
            if(abs(ydiffm).LE.1.0e-10) then
               dx=0.0
               dy=-wmlby2
            else
               c=xdiffm/ydiffm
               dx=wmlby2/SQRT(1+c*c)
               dy=-dx*c
            endif
c ---       Convert deltas to grid units
            dxgrd=dx*dgridi
            dygrd=dy*dgridi
c ---       Pass vertices to arrays in /LN2/
            xvertl2(1,i)=xl2beggrd(i)-dxgrd
            yvertl2(1,i)=yl2beggrd(i)-dygrd
            xvertl2(2,i)=xl2beggrd(i)+dxgrd
            yvertl2(2,i)=yl2beggrd(i)+dygrd
            xvertl2(3,i)=xl2endgrd(i)+dxgrd
            yvertl2(3,i)=yl2endgrd(i)+dygrd
            xvertl2(4,i)=xl2endgrd(i)-dxgrd
            yvertl2(4,i)=yl2endgrd(i)-dygrd
c ---       Corresponding area of line source in m^2
            arline2(i)=2.*wmlby2*SQRT(xdiffm*xdiffm+ydiffm*ydiffm)
         enddo
c
c ---    Find center of array of line sources, and orientation
c ---    for this group
         xbeg=0.0
         ybeg=0.0
         xend=0.0
         yend=0.0
         fac=1.0/em5grp(1,ig)
         do i=nlprev+1,nlines2
            xbeg=xbeg+xl2beggrd(i)
            ybeg=ybeg+yl2beggrd(i)
            xend=xend+xl2endgrd(i)
            yend=yend+yl2endgrd(i)
         enddo
         xbeg=xbeg*fac
         ybeg=ybeg*fac
         xend=xend*fac
         yend=yend*fac
c
         xl2bar(ig)=0.5*(xbeg+xend)
         yl2bar(ig)=0.5*(ybeg+yend)
         orientl2(ig)=ATAN2((xbeg-xend),(ybeg-yend))
      enddo

      return
      end
c----------------------------------------------------------------------
      subroutine ctadj(zterr,zht,zstak,zbase,ppcoef,zpa)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                  CTADJ
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Adjust puff-height to simulate terrain effects when
c               either the ISC terrain treatment (MCTADJ = 1) or the
c               partial plume height correction (MCTADJ = 3) is used
c
c --- UPDATE
c --- V4.0-V5.0     971107  (DGS): Allow receptors below stack base
c                                  in ISC treatment
c                   971107  (DGS): Also continue to apply partial
c                                  height eqn. with negative terrain ht
c
c --- INPUTS:
c             ZTERR - real    - Terrain elevation (m MSL) at receptor
c               ZHT - real    - Puff height before adjustments (m)
c             ZSTAK - real    - Stack height of source of puff (m)
c             ZBASE - real    - Stack base elevation MSL (m)
c            PPCOEF - real    - Plume Path Coefficient
c
c     Common Block /FLAGS/ variables:
c        MCTADJ
c     Parameters:
c        MXREC
c
c
c --- OUTPUTS:
c         ZPA - real      - Adjusted puff height above ground (m)
c
c --- CTADJ called by:  VCBAR, PUFRECS, SLGRECS, RECSPEC0
c --- CTADJ calls:      none
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'flags.puf'
      include 'nongrd.puf'

c --- Set minimum height of slug above the ground
      data zmin/0.0/

c --- Apply terrain adjustment
      if(mctadj .EQ. 1) then
c ---    ISC terrain adjustment
c ---    Chop terrain at stack-top (set relative to stack-base)
         zrterr = AMIN1(zterr-zbase,zstak)
c ---    Allow negative zrterr to pass (as in ISCST)
         zpa=AMAX1(zmin, (zht - zrterr))
      elseif(mctadj .EQ. 3) then
c ---    Partial Plume Height adjustment (e.g. half-height)
         delzr=zterr-zbase
c ---    Allow terrain below stack-base (delzr can be negative)
         zpa=zht-(1.-ppcoef)*AMIN1(zht,delzr)
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine ctadj2(r,zpold,xold,yold,xnew,ynew,szold,bvf,ws,
     &                  ldbhr,strain,zpnew,fracz,lup)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 991104a                CTADJ2
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Compute strain-induced adjustment factor for vertical
c               dispersion, where the strain in the flow is approx.
c               from the underlying gridded terrain field.
c               Also, compute changes in puff height above ground for
c               stably stratified flow.  This is used when MCTADJ=2.
c
c --- UPDATE
c --- V5.0-V5.2     991104a (DGS): add constraint that R <= 1.0
c --- V4.0-V5.0     971107  (DGS): clean up treatment of degenerate
c                                  cases; use approximate expressions
c                                  for functions of small argument
c                   971107  (DGS): use puff height and local terrain
c                                  relief for determining etabyh, and
c                                  use local relief in Froude number
c                   971107  (DGS): set ratio of step length to
c                                  horizontal scale of surrogate hill
c                                  equal to step rise/relief
c                   971107  (JCC): separate max/min function calls
c --- V4.0-V5.0     971107  (DGS): adjust puff height for stable flows
c
c --- INPUTS:
c           R - real      - ratio of sigma-z at the start of step
c                           to that at end of step, before accounting
c                           for strain during the step
c       ZPOLD - real      - Puff height above ground (m) at start
c        XOLD - real      - Old puff x-position (Met Grid Units)
c        YOLD - real      - Old puff y-position (Met Grid Units)
c        XNEW - real      - New puff x-position (Met Grid Units)
c        YNEW - real      - New puff y-position (Met Grid Units)
c       SZOLD - real      - Sigma-z at start of step (m)
c         BVF - real      - Current Brunt-Vaisala freq (1/s)
c          WS - real      - Current wind speed (m/s)
c       LDBHR - logical   - Debug write logical
c
c       Common block /GRID/ variables:
c             dgrid, relief(5,mxnx,mxny), nx, ny
c       Parameters:
c             IO6,MXNX,MXNY
c
c --- OUTPUT:
c      STRAIN - real      - Dispersion adjustment factor for the
c                           current step
c       ZPNEW - real      - Puff height above ground (m) at end of step
c       FRACZ - real      - Fraction of step beyond which puff height is
c                           is constant (ZPNEW) for upslope flow, or up
c                           to which puff height is constant (ZPOLD) for
c                           downslope flow
c         LUP - logical   - Flag indicating upslope flow when .TRUE.
c
c --- CTADJ2 called by:  SETPUF, SETSLG
c --- CTADJ2 calls:      GETELEV
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'grid.puf'

      logical ldbhr,lup

      data two/2./,one/1./,half/0.5/,third/0.3333333/,zero/0.0/,
     &     small/1.0e-4/

c --- Condition ratio r to be <= 1
      r=AMIN1(1.0,r)

c --- Set met cell location for old and new puff locations
      icello=1+AMAX1(zero,xold)
      jcello=1+AMAX1(zero,yold)
      icelln=1+AMAX1(zero,xnew)
      jcelln=1+AMAX1(zero,ynew)

      icello=MIN0(nx,icello)
      jcello=MIN0(ny,jcello)
      icelln=MIN0(nx,icelln)
      jcelln=MIN0(ny,jcelln)

c --- Compute horizontal distance of step, and rise along step (m)
      xstep=(xnew-xold)*dgrid
      ystep=(ynew-yold)*dgrid
      delx=SQRT(xstep**2+ystep**2)
      call GETELEV(xold,yold,elold)
      call GETELEV(xnew,ynew,elnew)
      rise=elnew-elold
      arise=abs(rise)
      if(rise.GT.zero) then
         lup=.TRUE.
      else
         lup=.FALSE.
      endif

c --- Set relief height for this trajectory
c --- ( tan(22.5)=0.4142 , tan(67.5)=2.4142)
      if(ABS(ystep).GT.2.4142*ABS(xstep)) then
c ---    North-South
         rlf=AMAX1(relief(1,icello,jcello),relief(1,icelln,jcelln))
      else
         ybyx=ystep/xstep
         if(ybyx.GT.0.4142) then
c ---       NorthEast-SouthWest
            rlf=AMAX1(relief(2,icello,jcello),relief(2,icelln,jcelln))
         elseif(ybyx.LT.-0.4142) then
c ---       SouthEast-NorthWest
            rlf=AMAX1(relief(4,icello,jcello),relief(4,icelln,jcelln))
         else
c ---       East-West
            rlf=AMAX1(relief(3,icello,jcello),relief(3,icelln,jcelln))
         endif
      endif

c --- Set peak terrain elevation near this trajectory
      eltop=AMAX1(relief(5,icello,jcello),relief(5,icelln,jcelln))

c --- Compute puff height changes and strain function
c
      if(delx.LE.small .OR. arise.LE.small) then
c ---    Treat degenerate case of no step or no slope
         dtz=zero
         slope=zero
         xbyl=zero
         dxbyl=zero
         strat=zero
         tz=one
         tzsq=one
         strain=one
         zpnew=zpold
         fracz=zero
c
      else
c
c ---    Compute the slope of the terrain along the trajectory segment
         slope=rise/delx
         aslope=ABS(slope)

c ---    Compute change in puff height above ground along step to
c ---    account for deflection of stable layer beneath puff
c ---    NOTE: puffs embedded in downslope flow are not allowed to
c ---    rise over layers below Hd
         if(bvf.GT.zero .AND. lup) then
c ---       Determine dividing-streamline elevation (m MSL)
            elds=eltop-ws/bvf
c ---       Find fraction of step at which height change either
c ---       begins or ends based on dividing-streamline
            fracz=(elds-elold)/rise
c ---       For upslope flow, add constraint that puff height is not
c ---       reduced beyond point where zp/sigz < 1.8, assuming linear
c ---       growth in sigz during step.  This is the point at which the
c ---       presence of the ground increases C(zp) by about .15% over
c ---       free-puff value, and the GLC is about 40% of C(zp).
            if(fracz.GT.zero) then
               sznew=szold/r
               fraczs=(zpold-1.8*szold)/(rise+1.8*(sznew-szold))
               fraczs=AMAX1(zero,fraczs)
               fracz=AMIN1(fraczs,fracz)
            endif
c ---       Compute puff height above ground at at end of step
            if(fracz.LE.zero) then
               zpnew=zpold
            elseif(fracz.GE.one) then
               zpnew=zpold-rise
            else
               zpnew=zpold-rise*fracz
            endif
         else
            zpnew=zpold
            fracz=zero
         endif

c ---    Set ratio of streamline height (eta) / height of the
c ---    surrogate hill (h) equal to the ratio of the "average" puff
c ---    height to the height of the local terrain relief;
c ---    condition eta/H within range 0.1 to 10.0
         zp=half*(zpold+zpnew)
         if(rlf.LE.0.1*zp) then
            etabyh=10.
         else
            etabyh=AMAX1(0.1,zp/rlf)
         endif

c ---    Compute 1/Froude number for the surrogate hill, where the local
c ---    relief is used as the hill height
         fri=bvf*rlf/ws
c ---    Limit Fr>1.0, so that 1/Fr<1.0
         fri=AMIN1(one,fri)

c ---    Set ratio of streamline height (eta) / horizontal scale of the
c ---    surrogate hill (L), and corresponding EXP(+\-)
         etabyl=two*etabyh*aslope
         if(etabyl.GE.0.1) then
           expnl=EXP(etabyl)
           expnli=one/expnl
         else
           expnl=one+etabyl
           expnli=one-etabyl
         endif

c ---    Compute the stratification parameter
         strat=fri*etabyh
         if(strat.GE.0.1) then
            sinln=SIN(strat)
            cosln=COS(strat)
         else
            sinln=strat
            cosln=one-half*strat**2
         endif
c
c ---    Find position on surrogate hill at which change in strain is
c ---    greatest
         trig=sinln/(cosln-expnl)

         if(slope.GT.zero) then
c ---       Upwind face
c ---       No stratification:
            xbyl=-SQRT(third*(one+two*aslope*(one-expnli)/etabyl))
            if(ABS(trig).GE.0.01) then
c ---          Stronger stratification:
               xbyl=xbyl+half*(one-SQRT(one+trig**2))/trig
            else
c ---          Weaker stratification:
               xbyl=xbyl-half*half*trig
            endif
         else
c ---       Downwind face
c ---       No stratification:
c ---       Use small argument approximation to *(one-expnli)/etabyl=1
            xbyl= SQRT(third*(one+two*aslope*(one-expnli)/etabyl))
            if(ABS(trig).GE.0.01) then
c ---          Stronger stratification:
               xbyl=xbyl+(one-SQRT(one+trig**2))/trig
            else
c ---          Weaker stratification:
               xbyl=xbyl-half*trig
            endif
         endif
         xbyl2=xbyl*xbyl
c
c ---    Compute strain factor at XBYL
         tzi=one+(two*aslope/(etabyl*(one+xbyl2))) *
     &           (one-expnli*(cosln-xbyl*sinln))
         tz=one/tzi
         tzsq=tz*tz
c
c ---    Set ratio of step length / length-scale of the
c ---    surrogate hill (delx/L) equal to |rise|/relief
         dxbyl=one
         if(arise.LT.rlf) dxbyl=arise/rlf
c
c ---    Compute rate of change in strain at XBYL, times the scaled
c ---    step length dxbyl
         dtz=-dxbyl*(two*aslope*tzsq/(etabyl*(one+xbyl2)**2)) *
     &        (-two*xbyl+expnli*(two*xbyl*cosln+(one-xbyl2)*sinln))
c
c ---    Compute diffusion adjustment factor due to strain in the flow
         sfcnsq=exp(two*(one-tz))
         rsq=r*r
         arg=two*dtz
         exparg=EXP(-arg)
         if(ABS(arg).GT.0.05) then
            strain=rsq+sfcnsq*(one-rsq)*(one-exparg)/arg
         else
            strain=rsq+sfcnsq*(one-rsq)
         endif
         strain=SQRT(strain)
c
      endif
c
c --- DEBUG output
      if(ldbhr) then
         write(io6,*)
         write(io6,*)'CTADJ2:    r= ',r,'  delx(m)= ',delx
         write(io6,*)'xold,yold(MGU)  = ',xold,yold
         write(io6,*)'xnew,ynew(MGU)  = ',xnew,ynew
         write(io6,*)'elold,elnew(mMSL)= ',elold,elnew,'slope= ',slope
         write(io6,*)'bvf= ',bvf,' ws= ',ws,' relief =',rlf
         write(io6,*)'eltop,elds    = ',eltop,elds
         write(io6,*)'zpold,zpnew(m)= ',zpold,zpnew
         write(io6,*)'fracz,lup     = ',fracz,lup
         write(io6,*)'eta/H= ',etabyh,' delx/L= ',dxbyl
         write(io6,*)'1/Fr= ',fri,' strat= ',strat
         write(io6,*)'xbyl= ',xbyl,'  tz= ',tz,'  dtz= ',dtz
         write(io6,*)'S^2= ',sfcnsq,'  strain= ',strain
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine slugct2(x,y,lclip,rhoci,rhocf,fracsi,fracsy,fracso,
     &                   xr1,yr1,xr2,yr2,zpr,fracsr)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                SLUGCT2
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Compute receptor-specific slug height and associated
c               properties, for MCTADJ=2.
c
c --- INPUTS:
c           X,Y - real    - Receptor coordinates (m)
c                           to that at end of step, before accounting
c                           for strain during the step
c         LCLIP - logical - No extrapolation of slug properties beyond
c                           footprint during step when TRUE
c   RHOCI,RHOCF - real    - Cross-slug receptor position (m) at initial
c                           and final slug locations of the step
c         FRACSI- real    - Along-slug receptor position from young end,
c                           as fraction of the slug length, at initial
c                           slug location
c  FRACSY,FRACSO- real    - Along-step receptor position, as fraction of
c                           the step length, for the young and old ends
c                           of the slug
c
c     Common Block /CURRENT/ variables:
c        XB1, YB1, ZB1,
c        XE1, YE1, ZE1, fracz1, lup1,
c        XB2, YB2, ZB2,
c        XE2, YE2, ZE2, fracz2, lup2,
c
c     Parameters:
c        IO6
c
c --- OUTPUT:
c       XR1,YR1 - real    - Coordinates (m) of old end of slug when
c                           slug interacts with receptor
c       XR2,YR2 - real    - Coordinates (m) of young end of slug when
c                           slug interacts with receptor
c           ZPR - real    - Receptor-specific slug ht above ground (m)
c        FRACSR - real    - Along-slug receptor position from young end,
c                           as fraction of the slug length, at position
c                           where slug interacts with receptor
c
c --- SLUGCT2 called by:  SLGRECS
c --- SLUGCT2 calls:      SLGFRAC
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'current.puf'

      logical lclip, ldb

      data one/1./,zero/0.0/,small/1.0e-3/
      data ldb/.FALSE./

c --- Use the cross-slug position of the receptor at the start
c --- and end of the step to find fraction of step when slug AXIS
c --- aligns with receptor (FRACSA)
      rhodif=rhocf-rhoci
      rhomax=AMAX1(ABS(rhocf),ABS(rhoci),small)
      rhotest=ABS(rhodif)/rhomax
      if(rhotest.LT.small) then
c ---    Axis does not move enough during the step, so find
c ---    the nearest approach of old or young slug-end
c ---    (where either end might be used, choose the younger)
         if(fracsy.GE.zero .AND. fracsy.LE.one) then
c ---       Young end passes receptor during step
            fracsa=fracsy
            fracsr=zero
         elseif(fracso.GE.zero .AND. fracso.LE.one) then
c ---       Old end passes receptor, but not young end
            fracsa=fracso
            fracsr=one
         elseif(fracsi.GE.zero .AND. fracsi.LE.one) then
c ---       Slug ends bracket receptor at start of step
            fracsa=zero
            fracsr=fracsi
         elseif(fracsy.GT.one) then
            if(fracso.GE.fracsy) then
c ---          Young end approaches nearer receptor at end of step
               fracsr=zero
               fracsa=fracsy
            else
c ---          Old end approaches nearer receptor at end of step
               fracsr=one
               fracsa=fracso
            endif
         elseif(fracsy.LT.zero) then
            if(fracso.LE.fracsy) then
c ---          Young end approaches nearer receptor at start of step
               fracsr=zero
               fracsa=fracsy
            else
c ---          Old end approaches nearer receptor at start of step
               fracsr=one
               fracsa=fracso
            endif
         endif
      else
c ---    Axis moves so compute fraction of step when slug AXIS
c ---    aligns with receptor
         fracsa=-rhoci/rhodif
         if(LCLIP) then
            fracsa=AMIN1(one,fracsa)
            fracsa=AMAX1(zero,fracsa)
         endif
c ---    Compute slug-end locations at FRACSA of step
         xr1=xb1+fracsa*(xe1-xb1)
         yr1=yb1+fracsa*(ye1-yb1)
         xr2=xb2+fracsa*(xe2-xb2)
         yr2=yb2+fracsa*(ye2-yb2)
c ---    Compute fractional along-slug distance to receptor from
c ---    young end (FRACSR), evaluated at FRACSA
         call SLGFRAC(x,y,xr1,yr1,xr2,yr2,rhoar,rhocr,fracsr,
     &                d12,d12i)
         if(fracsr.LT.zero) then
c ---       Use slug height at "young" end at nearest point
c ---       (reset FRACSA and FRACSR)
            fracsa=fracsy
            fracsr=zero
         elseif(fracsr.GT.one) then
c ---       Use slug height at "old" end at nearest point
c ---       (reset FRACSA and FRACSR)
            fracsa=fracso
            fracsr=one
         endif
      endif

c --- Impose clipping along transport (conditional)
      if(LCLIP) then
         fracsa=AMIN1(one,fracsa)
         fracsa=AMAX1(zero,fracsa)
      endif

c --- Compute slug-end locations at (Final) FRACSA
      xr1=xb1+fracsa*(xe1-xb1)
      yr1=yb1+fracsa*(ye1-yb1)
      xr2=xb2+fracsa*(xe2-xb2)
      yr2=yb2+fracsa*(ye2-yb2)

c --- Compute elevation of each end of slug at FRACSA
c --- Older end
      if(lup1) then
c ---    Upslope (ht may fall)
         if(fracz1.LE.zero) then
            zr1=zb1
         else
            zjump=ze1-zb1
            if(fracz1.LT.one) zjump=zjump/fracz1
            zr1=zb1+AMIN1(fracsa,fracz1)*zjump
         endif
      else
c ---    Downslope (ht may rise)
         if(fracz1.GE.one) then
            zr1=zb1
         else
            zjump=ze1-zb1
            if(fracz1.GT.zero) zjump=zjump/(one-fracz1)
            zr1=zb1+AMAX1(zero,(fracsa-fracz1))*zjump
         endif
      endif
c --- Younger end
      if(lup2) then
c ---    Upslope (ht may fall)
         if(fracz2.LE.zero) then
            zr2=zb2
         else
            zjump=ze2-zb2
            if(fracz2.LT.one) zjump=zjump/fracz2
            zr2=zb2+AMIN1(fracsa,fracz2)*zjump
         endif
      else
c ---    Downslope (ht may rise)
         if(fracz2.GE.one) then
            zr2=zb2
         else
            zjump=ze2-zb2
            if(fracz2.GT.zero) zjump=zjump/(one-fracz2)
            zr2=zb2+AMAX1(zero,(fracsa-fracz2))*zjump
         endif
      endif

c --- Interpolate slug height between ends
      zpr=zr2+fracsr*(zr1-zr2)

c --- Debug output section
      if(ldb) then
         write(io6,*)'SLUGCT2:'
         write(io6,*)'zpr,zr1,zr2   = ',zpr,zr1,zr2
         write(io6,*)'fracsr,fracsa = ',fracsr,fracsa
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine puffct2(frac,xr1,yr1,zpr)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                PUFFCT2
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Compute receptor-specific puff height for MCTADJ=2.
c
c --- INPUTS:
c          FRAC - real    - Along-step receptor position, as fraction of
c                           the step length
c
c     Common Block /CURRENT/ variables:
c        XB1, YB1, ZB1,
c        XE1, YE1, ZE1, fracz1, lup1
c
c     Parameters:
c        IO6
c
c --- OUTPUT:
c       XR1,YR1 - real    - Puff coordinates (m) when puff interacts
c                           with receptor
c           ZPR - real    - Receptor-specific puff ht above ground (m)
c
c --- PUFFCT2 called by:  PUFRECS
c --- PUFFCT2 calls:      SLGFRAC
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'current.puf'

      data one/1./,zero/0.0/

c --- Compute puff location at FRAC
      xr1=xb1+frac*(xe1-xb1)
      yr1=yb1+frac*(ye1-yb1)

c --- Compute elevation at FRAC
      if(lup1) then
c ---    Upslope (ht may fall)
         if(fracz1.LE.zero) then
            zpr=zb1
         else
            zjump=ze1-zb1
            if(fracz1.LT.one) zjump=zjump/fracz1
            zpr=zb1+AMIN1(frac,fracz1)*zjump
         endif
      else
c ---    Downslope (ht may rise)
         if(fracz1.GE.one) then
            zpr=zb1
         else
            zjump=ze1-zb1
            if(fracz1.GT.zero) zjump=zjump/(one-fracz1)
            zpr=zb1+AMAX1(zero,(frac-fracz1))*zjump
         endif
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine getelev(x,y,z)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 950715                GETELEV
c
c --- PURPOSE:  Employs bilinear interpolation to obtain terrain
c               elevation at a point within the MET grid.
c
c --- INPUTS:
c           X - real      - x-position (Met Grid Units)
c           Y - real      - y-position (Met Grid Units)
c
c       Common block /METHD/ variables:
c             ELEV(mxnx,mxny)
c       Common block /GRID/ variables:
c             nx,ny
c       Parameters:
c             mxnx, mxny
c
c --- OUTPUT:
c           Z - real      - Terrain elevation (m MSL)
c
c --- GETELEV called by: ELEVI, VCBAR, CTADJ2
c --- GETELEV calls:     none
c----------------------------------------------------------------------
c  NOTE:  this routine interpolates among elevations assigned to the
c         CENTER of cells in the MET grid, and assumes that the
c         terrain varies linearly between adjacent CENTERS.
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'methd.puf'
      include 'grid.puf'
c
c --- Trap case of single grid-cell
      if(nx.eq.1 .AND. ny.eq.1) then
         z=elev(1,1)
         return
      endif
c
c --- Compute cell x-index of nearest lower left grid-point
c --- (ll denotes lower left-grid point)
      if(nx.eq.1) then
         ixll=1
         ixllp1=1
      else
         ixll=(x+0.5)
c ---    Shift index if needed to stay within grid
         nxm1=nx-1
         ixll=max0(ixll,1)
         ixll=min0(ixll,nxm1)
c ---    Other corners
         ixllp1=ixll+1
      endif
c
c --- Compute cell y-index of nearest lower left grid-point
c --- (ll denotes lower left-grid point)
      if(ny.eq.1) then
         iyll=1
         iyllp1=1
      else
         iyll=(y+0.5)
c ---    Shift index if needed to stay within grid
         nym1=ny-1
         iyll=max0(iyll,1)
         iyll=min0(iyll,nym1)
c ---    Other corners
         iyllp1=iyll+1
      endif
c
c --- Position of point relative to the ll grid-point (grid units)
      t=(x-(ixll-0.5))
      onemt=1.-t
      u=(y-(iyll-0.5))
      onemu=1.-u

c -- Interpolated value
      z=onemt*onemu*elev(ixll,iyll)
     1  +t*onemu*elev(ixllp1,iyll)
     2  +t*u*elev(ixllp1,iyllp1)
     3  +u*onemt*elev(ixll,iyllp1)

      return
      end
c----------------------------------------------------------------------
      subroutine trelief(ldb)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                TRELIEF
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Compute local relief of the terrain for each cell in
c               the meteorological grid, and also the peak elevation
c               associated with this relief.  The relief height and
c               peak terrain elevation are used for MCTADJ = 2
c
c --- INPUTS:
c         LDB - logical   - Debug write logical
c
c       Common block /GRID/ variables:
c             NX,NY
c       Common block /METHD/ variables:
c             ELEV(MXNX,MXNY)
c       Parameters:
c             IO6,MXNX,MXNY
c
c --- OUTPUT:
c       Common block /GRID/ variables:
c             RELIEF(5,mxnx,mxny)
c
c --- TRELIEF called by:  SETUP
c --- TRELIEF calls:      TERAVG
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'grid.puf'
      include 'methd.puf'

      logical ldb

      data zero/0.0/, one/1.0/, beta/1.0/

c --- BETA is the criterion for identifying the "end-point" of the
c --- height profile associated with a cell; this test is applied to
c --- the ratio of the slope for the current position to the original
c --- slope, so that if the ratio is outside the range
c --- BETA to 1+BETA, the segment of the profile is completed

c --- Loop over each cell in the grid
c ------------------------------------
      do j=1,ny
      do i=1,nx

c ---    Initial peak elevation equals cell elevation
         rise=zero

c ---    Process 4 orientations (1:N/S, 2:NE/SW, 3:E/W, 4:SE/NW)
c ---    N/S
c ------------
c ---    Direction of Increasing y-cell index
c ---    Reliefi > 0 if terrain increases in this direction
         reliefi=zero
         if(j.LT.ny) then
            delh1=elev(i,j+1)-elev(i,j)
            reliefi=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i,j+1)
               do jj=j+1,ny-1,1
                  elavg0=elavg
                  call TERAVG(ldb,i,j,i,jj+1,elavg)
                  delh=elavg-elavg0
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefi=reliefi+delh
                  else
                     goto 110
                  endif
               enddo
            endif
         endif
110      continue
c ---    Direction of Decreasing y-cell index
c ---    Reliefd > 0 if terrain decreases in this direction
         reliefd=zero
         if(j.GT.1) then
            delh1=-(elev(i,j-1)-elev(i,j))
            reliefd=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i,j-1)
               do jj=j-1,2,-1
                  elavg0=elavg
                  call TERAVG(ldb,i,j,i,jj-1,elavg)
                  delh=-(elavg-elavg0)
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefd=reliefd+delh
                  else
                     goto 120
                  endif
               enddo
            endif
         endif
120      continue
         rplus=ABS(reliefi+reliefd)
         rminus=ABS(reliefi-reliefd)
         if(rplus.GT.rminus) then
            relief(1,i,j)=rplus
         else
            relief(1,i,j)=AMAX1(ABS(reliefi),ABS(reliefd))
         endif
         rise=AMAX1(rise,reliefi)
         rise=AMAX1(rise,-reliefd)

c ---    NE/SW
c ------------
c ---    Direction of Increasing x,y-cell index
c ---    Reliefi > 0 if terrain increases in this direction
         reliefi=zero
         if(j.LT.ny .AND. i.LT.nx) then
            delh1=elev(i+1,j+1)-elev(i,j)
            reliefi=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i+1,j+1)
c ---          Limit do-loop range using cell index nearest edge of grid
               nxy=MIN0((nx-i),(ny-j))
               do k=1,nxy-1
                  ii=i+k
                  jj=j+k
                  elavg0=elavg
                  call TERAVG(ldb,i,j,ii+1,jj+1,elavg)
                  delh=elavg-elavg0
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefi=reliefi+delh
                  else
                     goto 210
                  endif
               enddo
            endif
         endif
210      continue
c ---    Direction of Decreasing x,y-cell index
c ---    Reliefd > 0 if terrain decreases in this direction
         reliefd=zero
         if(j.GT.1 .AND. i.GT.1) then
            delh1=-(elev(i-1,j-1)-elev(i,j))
            reliefd=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i-1,j-1)
c ---          Limit do-loop range using cell index nearest edge of grid
               nxy=MIN0(i,j)-1
               do k=1,nxy-1
                  ii=i-k
                  jj=j-k
                  elavg0=elavg
                  call TERAVG(ldb,i,j,ii-1,jj-1,elavg)
                  delh=-(elavg-elavg0)
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefd=reliefd+delh
                  else
                     goto 220
                  endif
               enddo
            endif
         endif
220      continue
         rplus=ABS(reliefi+reliefd)
         rminus=ABS(reliefi-reliefd)
         if(rplus.GT.rminus) then
            relief(2,i,j)=rplus
         else
            relief(2,i,j)=AMAX1(ABS(reliefi),ABS(reliefd))
         endif
         rise=AMAX1(rise,reliefi)
         rise=AMAX1(rise,-reliefd)


c ---    E/W
c ------------
c ---    Direction of Increasing x-cell index
c ---    Reliefi > 0 if terrain increases in this direction
         reliefi=zero
         if(i.LT.nx) then
            delh1=elev(i+1,j)-elev(i,j)
            reliefi=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i+1,j)
               do ii=i+1,nx-1,1
                  elavg0=elavg
                  call TERAVG(ldb,i,j,ii+1,j,elavg)
                  delh=elavg-elavg0
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefi=reliefi+delh
                  else
                     goto 310
                  endif
               enddo
            endif
         endif
310      continue
c ---    Direction of Decreasing x-cell index
c ---    Reliefd > 0 if terrain decreases in this direction
         reliefd=zero
         if(i.GT.1) then
            delh1=-(elev(i-1,j)-elev(i,j))
            reliefd=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i-1,j)
               do ii=i-1,2,-1
                  elavg0=elavg
                  call TERAVG(ldb,i,j,ii-1,j,elavg)
                  delh=-(elavg-elavg0)
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefd=reliefd+delh
                  else
                     goto 320
                  endif
               enddo
            endif
         endif
320      continue
         rplus=ABS(reliefi+reliefd)
         rminus=ABS(reliefi-reliefd)
         if(rplus.GT.rminus) then
            relief(3,i,j)=rplus
         else
            relief(3,i,j)=AMAX1(ABS(reliefi),ABS(reliefd))
         endif
         rise=AMAX1(rise,reliefi)
         rise=AMAX1(rise,-reliefd)


c ---    SE/NW
c ------------
c ---    Direction of Increasing x, decreasing y-cell index
c ---    Reliefi > 0 if terrain increases in this direction
         reliefi=zero
         if(j.GT.1 .AND. i.LT.nx) then
            delh1=elev(i+1,j-1)-elev(i,j)
            reliefi=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i+1,j-1)
c ---          Limit do-loop range using cell index nearest edge of grid
               nxy=MIN0((nx-i),(j-1))
               do k=1,nxy-1
                  ii=i+k
                  jj=j-k
                  elavg0=elavg
                  call TERAVG(ldb,i,j,ii+1,jj-1,elavg)
                  delh=elavg-elavg0
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefi=reliefi+delh
                  else
                     goto 410
                  endif
               enddo
            endif
         endif
410      continue
c ---    Direction of Decreasing x, increasing y-cell index
c ---    Reliefd > 0 if terrain decreases in this direction
         reliefd=zero
         if(j.LT.ny .AND. i.GT.1) then
            delh1=-(elev(i-1,j+1)-elev(i,j))
            reliefd=delh1
            if(ABS(delh1).GT.zero) then
               elavg=elev(i-1,j+1)
c ---          Limit do-loop range using cell index nearest edge of grid
               nxy=MIN0((i-1),(ny-j))
               do k=1,nxy-1
                  ii=i-k
                  jj=j+k
                  elavg0=elavg
                  call TERAVG(ldb,i,j,ii-1,jj+1,elavg)
                  delh=-(elavg-elavg0)
                  rr=ABS(delh/delh1-one)
                  if(rr.LE.beta) then
                     reliefd=reliefd+delh
                  else
                     goto 420
                  endif
               enddo
            endif
         endif
420      continue
         rplus=ABS(reliefi+reliefd)
         rminus=ABS(reliefi-reliefd)
         if(rplus.GT.rminus) then
            relief(4,i,j)=rplus
         else
            relief(4,i,j)=AMAX1(ABS(reliefi),ABS(reliefd))
         endif
         rise=AMAX1(rise,reliefi)
         rise=AMAX1(rise,-reliefd)

c ---    Identify peak elevation near this cell
         relief(5,i,j)=elev(i,j)+rise

      enddo
      enddo

      if(ldb) then
c ---    Write out a subset of the terrain difference fields
         write(io6,*)
         write(io6,*)'TRELIEF: terrain near center of met grid'
         write(io6,*)'         i, j, RELIEF(N/NE/E/SE), PEAK in m ='
         i0=nx/2
         do j=ny,1,-1
c         do i=i0,i0+1
            i=i0
            write(io6,'(2i4,5f10.1)')i,j,(relief(k,i,j),k=1,5)
c         enddo
         enddo
         ibeg=MAX0(1,i0-10)
         iend=MIN0(nx,ibeg+19)
         write(io6,*)
         write(io6,*)
         write(io6,*)
         write(io6,*)'TRELIEF: PEAK in local RELIEF'
         write(io6,*)'E-W Cell Index  -----'
         write(io6,'(5x,20i5)') (ii,ii=ibeg,iend)
         write(io6,*)
         do jj=ny,1,-1
           write(io6,'(i3,2x,20f5.0)')jj,(relief(5,ii,jj),ii=ibeg,iend)
         enddo
         write(io6,*)
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine teravg(ldb,i0,j0,i,j,elavg)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                 TERAVG
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Compute average elevation of a strip of cells containing
c               cell (i,j), which lie across a 45 degree sector centered
c               on the direction from cell (i0,j0) to cell (i,j).
c
c --- INPUTS:
c         LDB - logical   - Debug write logical
c       I0,J0 - integer   - Cell at origin of sector
c         I,J - integer   - Cell at center of sector direction
c
c       Common block /GRID/ variables:
c             NX,NY
c       Common block /METHD/ variables:
c             ELEV(MXNX,MXNY)
c       Parameters:
c             IO6,MXNX,MXNY
c
c --- OUTPUT:
c       ELAVG - real      - Average elevation in strip of cells which
c                           is perpendicular to sector direction, and
c                           which includes cell (i,j)
c
c --- TERAVG called by:  TRELIEF
c --- TERAVG calls:      none
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'grid.puf'
      include 'methd.puf'

      logical ldb

      data zero/0.0/, tan225/0.4142136/

      if(i0.EQ.i) then
c ---    Process N/S sector orientation
c ---    Select E/W strip of cells that lie in 45 degree sector
         jdel=IABS(j-j0)
         idel=INT(FLOAT(jdel)*tan225)
         ixmin=MAX0(1,i-idel)
         ixmax=MIN0(nx,i+idel)
         nsum=0
         tsum=zero
         do ix=ixmin,ixmax
            nsum=nsum+1
            tsum=tsum+elev(ix,j)
         enddo
         elavg=tsum/nsum

      elseif(j0.EQ.j) then
c ---    Process E/W sector orientation
c ---    Select N/S strip of cells that lie in 45 degree sector
         idel=IABS(i-i0)
         jdel=INT(FLOAT(idel)*tan225)
         jymin=MAX0(1,j-jdel)
         jymax=MIN0(ny,j+jdel)
         nsum=0
         tsum=zero
         do jy=jymin,jymax
            nsum=nsum+1
            tsum=tsum+elev(i,jy)
         enddo
         elavg=tsum/nsum

      elseif((j-j0).EQ.(i-i0)) then
c ---    Process NE/SW sector orientation
c ---    Select NW/SE strip of cells that lie in 45 degree sector
         kdiag=IABS(i-i0)
         kdiag=INT(FLOAT(kdiag)*tan225)
         jymin=MAX0(1,j-kdiag)
         jymax=MIN0(ny,j+kdiag)
         ixmin=MAX0(1,i-kdiag)
         ixmax=MIN0(nx,i+kdiag)
c ---    Set edge of valid domain
         kleft=-MIN0((i-ixmin),(jymax-j))
         krght=MIN0((ixmax-i),(j-jymin))
c ---    Sum the elevations in the strip
         nsum=zero
         tsum=zero
         do k=kleft,krght
            ii=i+k
            jj=j-k
            nsum=nsum+1
            tsum=tsum+elev(ii,jj)
         enddo

c ---    ADD half-step cells (one half-step further along direction)
         nx2=2*nx
         ny2=2*ny
         i02=2*i0
c ---    Increment i2,j2 one "half-cell" along direction
         i2=2*i+1
         j2=2*j+1
         if(i.LT.i0) i2=i2-2
         if(j.LT.j0) j2=j2-2
         kdiag=IABS(i2-i02)
         kdiag=INT(FLOAT(kdiag)*tan225)
         jymin=MAX0(2,j2-kdiag)
         jymax=MIN0(ny2,j2+kdiag)
         ixmin=MAX0(2,i2-kdiag)
         ixmax=MIN0(nx2,i2+kdiag)
c ---    Set edge of valid domain
         kleft=-MIN0((i2-ixmin),(jymax-j2))
         krght=MIN0((ixmax-i2),(j2-jymin))
c ---    Sum the elevations in the strip
         do k=kleft,krght
            ii=i2+k
            jj=j2-k
c ---       Process only full-cell positions
            if(MOD(ii,2).EQ.0 .AND. MOD(jj,2).EQ.0) then
               ii=ii/2
               jj=jj/2
               nsum=nsum+1
               tsum=tsum+elev(ii,jj)
            endif
         enddo

c ---    Average the elevations in the strip
         elavg=tsum/nsum

      elseif((j-j0).EQ.-(i-i0)) then
c ---    Process NW/SE orientation
c ---    Select SW/NE strip of cells that lie in 45 degree sector
         kdiag=IABS(i-i0)
         kdiag=INT(FLOAT(kdiag)*tan225)
         jymin=MAX0(1,j-kdiag)
         jymax=MIN0(ny,j+kdiag)
         ixmin=MAX0(1,i-kdiag)
         ixmax=MIN0(nx,i+kdiag)
c ---    Set edge of valid domain
         kleft=-MIN0((i-ixmin),(j-jymin))
         krght=MIN0((ixmax-i),(jymax-j))
c ---    Sum the elevations in the strip
         nsum=zero
         tsum=zero
         do k=kleft,krght
            ii=i+k
            jj=j+k
            nsum=nsum+1
            tsum=tsum+elev(ii,jj)
         enddo

c ---    ADD half-step cells (one half-step further along direction)
         nx2=2*nx
         ny2=2*ny
         i02=2*i0
c ---    Increment i2,j2 one "half-cell" along direction
         i2=2*i+1
         j2=2*j+1
         if(i.LT.i0) i2=i2-2
         if(j.LT.j0) j2=j2-2
         kdiag=IABS(i2-i02)
         kdiag=INT(FLOAT(kdiag)*tan225)
         jymin=MAX0(2,j2-kdiag)
         jymax=MIN0(ny2,j2+kdiag)
         ixmin=MAX0(2,i2-kdiag)
         ixmax=MIN0(nx2,i2+kdiag)
c ---    Set edge of valid domain
         kleft=-MIN0((i2-ixmin),(j2-jymin))
         krght=MIN0((ixmax-i2),(jymax-j2))
c ---    Sum the elevations in the strip
         do k=kleft,krght
            ii=i2+k
            jj=j2+k
c ---       Process only full-cell positions
            if(MOD(ii,2).EQ.0 .AND. MOD(jj,2).EQ.0) then
               ii=ii/2
               jj=jj/2
               nsum=nsum+1
               tsum=tsum+elev(ii,jj)
            endif
         enddo

c ---    Average the elevations in the strip
         elavg=tsum/nsum

      endif

c --- Debug Output Section
      if(LDB) then
         if(i.EQ.j .AND. (j.LE.3 .OR. j.GE.(ny-2))) then
            write(io6,*)'TERAVG:    i0,j0,i,j= ',i0,j0,i,j
            write(io6,*)'          elavg,nsum= ',elavg,nsum
         endif
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine walltrap(ldb,syb,sye,z,xb,yb,xe,ye,bvf,ws,itrap)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107               WALLTRAP
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Compute local valley width at height "z" above cell
c               elevation for position at beginning and end of step;
c               then limit growth of sigma-y during step if valley
c               width is small enough (used for MCTADJ = 2)
c
c --- INPUTS:
c         LDB - logical   - Debug write logical
c     SYB,SYE - real      - Sigma-y at beginning and end of step (m)
c           Z - real      - Puff height above ground (m)
c       XB,YB - real      - Beginning puff position (Met Grid Units)
c       XE,YE - real      - Ending puff position (Met Grid Units)
c         BVF - real      - Brunt-Vaisala Frequency (1/s)
c          WS - real      - Wind Speed (m/s)
c
c       Common block /GRID/ variables:
c             DGRID, RELIEF(5,mxnx,mxny)
c             IVALW(mxvalz,mxnx,mxny), DZVAL
c       Common block /METHD/ variables:
c             ELEV(MXNX,MXNY)
c       Parameters:
c             IO6,MXNX,MXNY,MXVALZ
c
c --- OUTPUT:
c         SYE - real      - Sigma-y at end of step (m)    [revised]
c       ITRAP - integer   - Flag denotes when SYE changes
c                           (0:  No Change;  1:  Change)
c
c --- WALLTRAP called by:  SETPUF, SETSLG
c --- WALLTRAP calls:      none
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'grid.puf'
      include 'methd.puf'

      logical ldb

      data zero/0.0/, one/1.0/

c --- Criterion for trapping is ratio RCRIT=sigma-y/L at which area
c --- under the Gaussian curve equals area of top-hat of width L, with
c --- the same peak concentration
      data rcrit/0.4/

c --- Initialize data
      itrap=0
      syeold=sye

c --- No Trapping if puff is above the dividing streamline
      if(bvf.LE.zero) goto 500

c --- Set met cell location for old and new puff locations
      ixb=1+AMAX1(zero,xb)
      jyb=1+AMAX1(zero,yb)
      ixe=1+AMAX1(zero,xe)
      jye=1+AMAX1(zero,ye)

      ixb=MIN0(nx,ixb)
      jyb=MIN0(ny,jyb)
      ixe=MIN0(nx,ixe)
      jye=MIN0(ny,jye)

c --- Determine dividing-streamline elevation (m MSL)
c --- Set peak terrain elevation near this step
      eltop=AMAX1(relief(5,ixb,jyb),relief(5,ixe,jye))
      elds=eltop-ws/bvf

c --- Set minimum puff elevation (m MSL)
      elpuff=AMIN1(elev(ixb,jyb),elev(ixe,jye))+z

      if(elpuff.LE.elds) then

c ---    Perform trapping calculations
c ------------------------------------

c ---    Compute valley widths at "z"
         zgrid=z/dzval
         izbot=INT(zgrid)
         if(izbot.EQ.0) then
            izbot=1
            dzfac=zero
         else
            dzfac=zgrid-FLOAT(izbot)
         endif
         iztop=izbot+1

c ---    No trapping if puff is above valley
         if(izbot.GE.mxvalz) goto 500

c ---    No trapping if puff not in valley at either beginning
c ---    or end of step
         if(ivalw(iztop,ixb,jyb).EQ.-1) goto 500
         if(ivalw(iztop,ixe,jye).EQ.-1) goto 500
         if(ivalw(izbot,ixb,jyb).EQ.-1) goto 500
         if(ivalw(izbot,ixe,jye).EQ.-1) goto 500

c ---    Interpolate valley width(m) at beginning and end
         wb=dgrid*((one-dzfac)*FLOAT(ivalw(izbot,ixb,jyb))+
     &                   dzfac*FLOAT(ivalw(iztop,ixb,jyb)))
         we=dgrid*((one-dzfac)*FLOAT(ivalw(izbot,ixe,jye))+
     &                   dzfac*FLOAT(ivalw(iztop,ixe,jye)))

c ---    Check for trapping criterion at ends of step
         rb=syb/wb
         re=sye/we
         if(AMAX1(rb,re).LE.rcrit) then
c ---       No trapping within step
            goto 500
         elseif(AMIN1(rb,re).GE.rcrit) then
c ---       Full trapping within step
            itrap=1
            f=zero
            frac=-999
            sye=syb
            goto 500
         else
c ---       Trapping for only part of step
c ---       Assume linear changes over step, and compute fraction of
c ---       step at which RCRIT criterion is met
            frac=AMAX1(zero,(syb-rcrit*wb)/((we-wb)*rcrit-(sye-syb)))
            itrap=1
            if(re.GE.rcrit) then
               f=frac
            elseif(rb.GE.rcrit) then
               f=one-frac
            endif
            sye=syb+f*(sye-syb)
         endif
      endif

c --- Report DEBUG information
500   if(LDB .AND. itrap.EQ.1) then
         write(io6,*)
         write(io6,*)'WALLTRAP:  z,bvf,ws = ',z,bvf,ws
         write(io6,*)'    ixb,jyb,ixe,jye = ',ixb,jyb,ixe,jye
         write(io6,*)'    Valley   wb, we = ', wb, we
         write(io6,*)'       syb,sye(old) = ',syb,syeold
         write(io6,*)'  f, frac ,sye(new) = ',f,frac,sye
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine vwidth(ldb)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602                 VWIDTH
c                D. Strimaitis, SRC
c
c --- PURPOSE:  Compute local valley width in met grid cell units
c               as a function of height at each cell
c
c --- UPDATES
c --- V5.2-V5.4    000602  (DGS): add message to "stop"
c --- V5.1-V5.2    991104  (JSS): Error messages written to list
c                                 file as well as to screen
c --- V5.0  971107-980304  (DGS): replace NX with NY in range check for
c                                 y-indices (bug)
c                          (DGS): change AMAX1(int) to MAX0(int) etc.
c
c --- INPUTS:
c         LDB - logical   - Debug write logical
c
c       Common block /GRID/ variables:
c             NX,NY
c       Common block /METHD/ variables:
c             ELEV(MXNX,MXNY)
c       Parameters:
c             IO6,MXNX,MXNY
c
c --- OUTPUT:
c       Common block /GRID/ variables:
c             IVALW(mxvalz,mxnx,mxny), DZVAL
c
c --- VWIDTH called by:  SETUP
c --- VWIDTH calls:      none
c
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
      include 'grid.puf'
      include 'methd.puf'

      logical ldb,lwidth

      data big/9000./
      data dzmin/10./, qahit/0.5/

c --- DZMIN is the minimum delta-z used in resolving width as a
c --- function of height
c --- QAHIT if min fraction of cells in a strip that constitutes a wall

c --- Initialize widths, and search elevations for max/min values (m)
      zmax=-big
      zmin=big
      do j=1,ny
      do i=1,nx
         if(elev(i,j).GT.zmax) zmax=elev(i,j)
         if(elev(i,j).LT.zmin) zmin=elev(i,j)
         do k=1,mxvalz
            ivalw(k,i,j)=-1
         enddo
      enddo
      enddo

c --- Set initial height interval
      dzval=(zmax-zmin)/FLOAT(mxvalz)
1     dzval=AMAX1(dzmin,dzval)

c --- Loop over heights above the cell elevation
      do k=1,mxvalz

c ---    Did the valley disappear too soon?  --- Increase resolution
         if(k.GT.1 .AND. .NOT.lwidth .AND. dzval.GT.dzmin) then
c ---       Recalculate the height increment and start over
            dzval=delz/FLOAT(mxvalz)
            do j0=1,ny
            do i0=1,nx
               do k0=1,mxvalz
                  ivalw(k0,i0,j0)=-1
               enddo
            enddo
            enddo
            goto 1
         endif

         delz=k*dzval
         lwidth=.FALSE.

c ---    Loop over each cell in the grid
c ---------------------------------------
         do j=1,ny
         do i=1,nx

c ---       Do not process this height for this cell if no valley width
c ---       had been found at the previous height
            if(k.GT.1) then
               if(ivalw(k-1,i,j).EQ.-1) goto 500
            endif

c ---       Set target elevation for cell (i,j)
            ztarget=elev(i,j)+delz

c ---       Find # cells from (i,j) to terrain that exceeds target
c ---       in each of 4 quadrants (N, S, E, W)
            lookNS=-1
            lookEW=-1

c ---       N
c ------------
c ---       Direction of Increasing y-cell index
c ---       March in cell-steps to North of cell (i,j)
            do jy=j+1,ny
               jdel=jy-j
c ---          Look at E-W strip within 90 degree sector about N
               ixmin=MAX0(1,i-jdel)
               ixmax=MIN0(nx,i+jdel)
c !!!          iqa=NINT(FLOAT(ixmax-ixmin)*qahit)
               iqa=NINT(FLOAT(ixmax-ixmin)*qahit)+1
               ihit=0
               do ix=ixmin,ixmax
                  if(elev(ix,jy).GE.ztarget) then
                     ihit=ihit+1
                     if(ihit.EQ.iqa) then
                        lookNS=jy
                        goto 100
                     endif
                  endif
               enddo
            enddo

100         continue
c ---       If target elevation was not found to the north, skip the
c ---       look to the south for the "other side" of the valley
            if(lookNS.LT.0) goto 200

c ---       S
c ------------
c ---       Direction of Decreasing y-cell index
c ---       March in cell-steps to South of cell (i,j)
            do jy=j-1,1,-1
               jdel=j-jy
c ---          Look at E-W strip within 90 degree sector about S
               ixmin=MAX0(1,i-jdel)
               ixmax=MIN0(nx,i+jdel)
c !!!          iqa=NINT(FLOAT(ixmax-ixmin)*qahit)
               iqa=NINT(FLOAT(ixmax-ixmin)*qahit)+1
               ihit=0
               do ix=ixmin,ixmax
                  if(elev(ix,jy).GE.ztarget) then
                     ihit=ihit+1
                     if(ihit.EQ.iqa) then
                        lookNS=lookNS-jy
                        goto 200
                     endif
                  endif
               enddo
            enddo
c ---       Reset to "null" value
            lookNS=-1

200         continue

c ---       E
c ------------
c ---       Direction of Increasing x-cell index
c ---       March in cell-steps to East of cell (i,j)
            do ix=i+1,nx
               idel=ix-i
c ---          Look at N-S strip within 90 degree sector about E
               jymin=MAX0(1,j-idel)
               jymax=MIN0(ny,j+idel)
c !!!          iqa=NINT(FLOAT(jymax-jymin)*qahit)
               iqa=NINT(FLOAT(jymax-jymin)*qahit)+1
               ihit=0
               do jy=jymin,jymax
                  if(elev(ix,jy).GE.ztarget) then
                     ihit=ihit+1
                     if(ihit.EQ.iqa) then
                        lookEW=ix
                        goto 300
                     endif
                  endif
               enddo
            enddo

300         continue
c ---       If target elevation was not found to the east, skip
c ---       look to the west for the "other side" of the valley;
            if(lookEW.LT.0) goto 400

c ---       W
c ------------
c ---       Direction of Decreasing x-cell index
c ---       March in cell-steps to West of cell (i,j)
            do ix=i-1,1,-1
               idel=i-ix
c ---          Look at N-S strip within 90 degree sector about W
               jymin=MAX0(1,j-idel)
               jymax=MIN0(ny,j+idel)
c !!!          iqa=NINT(FLOAT(jymax-jymin)*qahit)
               iqa=NINT(FLOAT(jymax-jymin)*qahit)+1
               ihit=0
               do jy=jymin,jymax
                  if(elev(ix,jy).GE.ztarget) then
                     ihit=ihit+1
                     if(ihit.EQ.iqa) then
                        lookEW=lookEW-ix
                        goto 400
                     endif
                  endif
               enddo
            enddo
c ---       Reset to "null" value
            lookEW=-1

400         continue

c ---       Set cross-valley width at this elevation, for this cell,
c ---       equal to the minimum NS or EW span
            itest=lookNS*lookEW
            if(itest.LT.0) then
c ---          Only one of the directions produced a valley width, so
c ---          take the maximum to select the valid width
               ivalw(k,i,j)=MAX0(lookNS,lookEW)
            else
c ---          Both are valid or both are invalid, so take the minimum
               ivalw(k,i,j)=MIN0(lookNS,lookEW)
            endif
            if(ivalw(k,i,j).GT.1) lwidth=.TRUE.

c ---       Test width
            if(ivalw(k,i,j).NE.-1 .AND. ivalw(k,i,j).LT.2) then
               write(io6,*) 'FATAL Problem in VWIDTH'
               write(io6,*) '-- invalid valley width computed'
               write(io6,*) '-- i,j,k,width = ',i,j,k,ivalw(k,i,j)
               write(*,*)
               stop 'Halted in VWIDTH -- see list file.'
            endif

500         continue

         enddo
         enddo

c --- End Loop over heights
      enddo

      if(ldb) then
c ---    Write out key setup info
         write(io6,*)
         write(io6,*)'VWIDTH: Information about process:'
         write(io6,*)'         zmax,zmin = ',zmax,zmin
         write(io6,*)'      mxvalz,dzval = ',mxvalz,dzval

         do k=1,mxvalz
c ---       Write out a subset of the valley width fields
            delz=dzval*k
            i0=nx/2
            ibeg=MAX0(1,i0-10)
            iend=MIN0(nx,ibeg+19)
            write(io6,*)
            write(io6,*)
            write(io6,*)'VWIDTH: Valley Width(cells) at Height(m) ',delz
            write(io6,*)'E-W Cell Index  -----'
            write(io6,'(5x,20i4)') (ii,ii=ibeg,iend)
            write(io6,*)
            do jj=ny,1,-1
              write(io6,'(i3,2x,20i4)') jj,(ivalw(k,ii,jj),ii=ibeg,iend)
            enddo
         enddo
      endif

      return
      end
c-----------------------------------------------------------------------
      subroutine axis(ht,aax,bax)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 940831                    AXIS
c ---            D. Strimaitis, SRC
c
c  PURPOSE:     Given a contour height above the grid-plane,
c               subroutine returns the major and minor axis lengths
c               of the hill.
c
c  ARGUMENTS:
c     PASSED:   ht              contour height above grid-plane (m)  [r]
c   RETURNED:   aax,bax         major, minor axis lengths (m)        [r]
c
c  CALLING ROUTINES:    CTPAR
c
c  EXTERNAL ROUTINES:   none
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'
      real ax(2)

      if(ht .LE. small) then
         aax=axmax(1,ih)
         bax=axmax(2,ih)
c  Restrict axis lengths so that defined major axis never becomes less
c  than defined minor axis
      if(bax .GT. aax) bax=aax
         return
      endif

c  Scale height of contour by the relief height of the hill
      htbyh=ht/h

      do 10 i=1,2
        ax(i)=scale(i,ih)*((one-htbyh)/(htbyh+
     1       (scale(i,ih)/axmax(i,ih))**expo(i,ih)))**(one/expo(i,ih))
10    continue
      aax=ax(1)
      bax=ax(2)
c  Restrict axis lengths so that defined major axis never becomes less
c  than defined minor axis
      if(bax .GT. aax) bax=aax

      return
      end
c-----------------------------------------------------------------------
      subroutine bi(afac,argm,argp,b)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                      BI
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes the quantity B(E,Eo) for the special case in
c               which sigma-z is virtually constant
c
c ARGUMENTS:
c    PASSED:    afac            1/(2*sz**2)  (m**-2)                 [r]
c               argm            Eo-length  (m)                       [r]
c               argp            Eo+length  (m)                       [r]
c  RETURNED:    b               B(E,Eo)                              [r]
c
c CALLING ROUTINES:     UPPER, LOWER
c
c EXTERNAL ROUTINES:
c-----------------------------------------------------------------------

      INCLUDE 'const.puf'

      exarg1=afac*argm**2
      exarg2=afac*argp**2

      term1=zero
      term2=zero

      if(exarg1 .LT. expmax) term1=EXP(-exarg1)
      if(exarg2 .LT. expmax) term2=EXP(-exarg2)

      b=two*(term1+term2)

      return
      end
c-----------------------------------------------------------------------
      subroutine bji(ak,dm,dp,d0,eoimh,eoiph,ej,bj)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                     BJI
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes the quantity B(E,Eo)
c
c ARGUMENTS:
c    PASSED:    ak              1/sqrt2*sze*szo*szpt  (m**-3)        [r]
c               dm              szpt**2 (Eo-Hd)  (m**3)              [r]
c               dp              szpt**2 (Eo+Hd)  (m**3)              [r]
c               d0              ak*sze**2 (zlid-Hd)  (m**3)          [r]
c               eoimh           Eo-Hd  (m)                           [r]
c               eoiph           Eo+Hd  (m)                           [r]
c               ej              E  (m)                               [r]
c  RETURNED:    bj              B(E,Eo)                              [r]
c
c CALLING ROUTINES:     UPPER
c
c EXTERNAL ROUTINES:    ERF
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

      dum=half/szesq
      akd1=ak*(dm+szosq*ej)
      akd2=ak*(dm-szosq*ej)
      akd3=ak*(dp-szosq*ej)
      akd4=ak*(dp+szosq*ej)

      exarg1=dum*(ej-eoimh)*(ej-eoimh)
      exarg2=dum*(ej+eoimh)*(ej+eoimh)
      exarg3=dum*(ej+eoiph)*(ej+eoiph)
      exarg4=dum*(ej-eoiph)*(ej-eoiph)

      term1=zero
      term2=zero
      term3=zero
      term4=zero

      if(exarg1 .LT. expmax) term1=EXP(-exarg1)*(ERF(d0-akd1)+ERF(akd1))
      if(exarg2 .LT. expmax) term2=EXP(-exarg2)*(ERF(d0-akd2)+ERF(akd2))
      if(exarg3 .LT. expmax) term3=EXP(-exarg3)*(ERF(d0+akd3)-ERF(akd3))
      if(exarg4 .LT. expmax) term4=EXP(-exarg4)*(ERF(d0+akd4)-ERF(akd4))

      bj=term1+term2+term3+term4

      return
      end
c-----------------------------------------------------------------------
      subroutine bjil(ak,b1,ej,eoi,bj)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                    BJIL
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes the quantity B(E,Eo) for LOWER
c
c ARGUMENTS:
c    PASSED:    ak              1/sqrt2*sz*szo*szp  (m**-3)          [r]
c               b1              Hd*sz**2  (m**3)                     [r]
c               eoi             Eo  (m)                              [r]
c               ej              E  (m)                               [r]
c  RETURNED:    bj              B(E,Eo)                              [r]
c
c CALLING ROUTINES:     LOWER
c
c EXTERNAL ROUTINES:    ERF
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

      dum=half/szsq
      b2=ej*szosq
      b3=eoi*szpsq

      exarg1=dum*(ej-eoi)*(ej-eoi)
      exarg2=dum*(ej+eoi)*(ej+eoi)

      term1=zero
      term2=zero

      arg1p=ak*(b1+b2+b3)
      arg1m=ak*(b1-b2-b3)
      arg2p=ak*(b1+b2-b3)
      arg2m=ak*(b1-b2+b3)

      if(exarg1 .LT. expmax) term1=EXP(-exarg1)*(ERF(arg1p)+ERF(arg1m))
      if(exarg2 .LT. expmax) term2=EXP(-exarg2)*(ERF(arg2p)+ERF(arg2m))

      bj=term1+term2

      return
      end
c-----------------------------------------------------------------------
      subroutine ctinit(dgrid,mhillin,nhill,hilldat,nctrec,xrct,yrct)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                  CTINIT
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Transfers data that are needed for the subgrid-scale
c               terrain option to common/CTPASS/, and initializes
c               data passed in common/CONST/.
c
c ARGUMENTS:
c    PASSED:
c               dgrid           spacing of cells in met grid (m)    [r]
c               mhillin         method for input of hill terrain    [i]
c                                     and receptor data
c                                     1 = Created by CTDM processor
c                                         programs (in CTDM format)
c                                     2 = Created by OPTHILL
c                                         processor & read in Input
c                                         Groups (6b, 6c)
c               nhill           number of subgrid-scale terrain     [i]
c                                     features
c               hilldat         hill data from control file        [ra]
c               nctrec          number of special complex terrain   [i]
c                                     receptors
c               xrct            X coordinate of complex terrain    [ra]
c                                     receptor (met. grid units)
c               yrct            Y coordinate of complex terrain    [ra]
c                                     receptor (met. grid units)
c
c  RETURNED:    (if CTDM receptor file is used)
c               xrct            X coordinate of complex terrain    [ra]
c                                     receptor (met. grid units)
c               yrct            Y coordinate of complex terrain    [ra]
c                                     receptor (met. grid units)
c
c CALLING ROUTINES:     SETUP
c
c EXTERNAL ROUTINES:    INPREC, INPTER
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

c  Dimension arrays passed through the argument list
      real hilldat(11,mxhill),xrct(mxrect),yrct(mxrect)

c  Set constants that are passed in common
      zero=0.
      one=1.
      two=2.
      three=3.
      four=4.
      half=0.5
      twoby3=two/three
      rt2=SQRT(two)
      pi=3.1415927
      rtpi=SQRT(pi)
      pii=one/pi
      rtpii=one/rtpi
      piby2=half*pi
      twopi=two*pi
      dtor=pi/180.
      small=.000001
      expmax=69.
      alphai=1.20
      hslfac=0.05
      epsint=0.01
      epsrefl=0.01
      mxrefl=50

c  Set the number of points along the trajectory to the maximum allowed
c  by the parameter MXTPTS in this implementation
      ntpts=mxtpts

c  Transfer flag to /CTPASS/ variable for type of terrain data
      mhillt=mhillin

c  Transfer hill information.  (These are placed in common/CTPASS/)
c              mhillt: method for hill data input
c                      1 = HILL.DAT file from CTDM
c                      2 = Input Subgroup 6b (OPTHILL)
      if(mhillt.eq.1) then
c ---    Read and process data from HILL.DAT (CTDM Terrain Processor)
         call INPTER
         do i=1,nhill
c ---       Change height reference from m (MSL) to m above hill base
            do inz=1,nzh(i)
               zh(inz,i)=zh(inz,i)-zgrid(i)
            enddo
         enddo

      elseif(mhillt.eq.2) then
c ---    Swap data from arrays filled from input file (Subgroup 6b)
         do i=1,nhill
c ---       Compute (xc,yc) as meters from MET grid origin
            xc(i)=dgrid*hilldat(1,i)
            yc(i)=dgrid*hilldat(2,i)
            thetah(i)=hilldat(3,i)
            zgrid(i)=hilldat(4,i)
            relief(i)=hilldat(5,i)
            expo(1,i)=hilldat(6,i)
            expo(2,i)=hilldat(7,i)
            scale(1,i)=hilldat(8,i)
            scale(2,i)=hilldat(9,i)
            axmax(1,i)=hilldat(10,i)
            axmax(2,i)=hilldat(11,i)
         enddo
      endif

c  Transfer receptor information.  (placed in common/CTPASS/)
c              mhillt: method for receptor data input
c                      1 = HILLRCT.DAT file from CTDM
c                      2 = Input Subgroup 6c
      if(mhillt.eq.1) then
c ---    Read & process data from HILLREC.DAT (CTDM Receptor Generator)
         call INPREC
c ---    Transfer receptor information to common/CTSGDAT/: change
c ---    distance units from meters to MET grid
         do i=1,nctrec
            xrct(i)= xrctm(i)/dgrid
            yrct(i)= yrctm(i)/dgrid
         enddo
      elseif(mhillt.eq.2) then
c ---    Transfer receptor information: change distance units from MET
c ---    grid to meters from MET grid origin (placed in common/CTPASS/)
         do i=1,nctrec
            xrctm(i)=dgrid*xrct(i)
            yrctm(i)=dgrid*yrct(i)
         enddo
      endif
c  Initialize variables
      ip=0
      ih=0
      tstart=0.

      return
      end
c-----------------------------------------------------------------------
      subroutine ctpar
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                   CTPAR
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes parameters for complex terrain option which
c               depend only on specification of puff and hill data.
c
C
C MODIFICATION:  1.  Changes made during EPA-sponsored upgrade to the
C                    FLOW algorithm have been made here.  This is now
C                    consistent with INPUFF 3.0 (10/93).
c
c                2.  Option added to accept hill information in CTDM
c                    format, or in original OPTHILL format, controlled
c                    by variable MHILLT:
c                               1 = CTDM format
c                               2 = OPTHILL format
c
c                3.  Modify method of computing and incorporating shear
c                    (this differs from INPUFF 3.0 (10/93)
c
c --- UPDATE
c --- V4.0-V5.0     971107  (DGS): Speed shear modification is applied
c                                  only when speed at hilltop is at
c                                  least 1/10 puff speed
c
c ARGUMENTS:    none
c
c CALLING ROUTINES:     CTSG
c
c EXTERNAL ROUTINES:    ROTATE, AXIS, KLOSE, MUNU, IREG, HILROT, SPEED,
c                       PATH, XINTRP
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'
      INCLUDE 'flvar.puf'

      real mu,nu

c  Define parameters used in CTDM flow algorithm
c *** Begin Modifications 7/4/91. Sigma Research Corp.  DGS.
c     data b0n/1.25/,rnlz/0.69315/
c *** Restore rnlz ('92 Modification).  Sigma Research Corp.  DGS.
      data rnlz/0.5/
c *** End Modifications 7/4/91. Sigma Research Corp.  DGS.

c  Shift puff position to hill-centered coordinate system, with
c       x-axis along the flow.
      xpc=xp-xc(ih)
      ypc=yp-yc(ih)
      rotflo=three*piby2-thetaw*dtor
      call ROTATE(xpc,ypc,rotflo,xpf,ypf)

c  Get axis lengths for hill below Hd at the lesser of Hd and puff ht.
      ht=AMIN1(zpuff,hd)
      if(mhillt .EQ. 1) then
c ---    CTDM format hill information
c        Use the ellipse parameters already fit to the hill, and select
c        the values for height 'ht' as in CTDMPLUS.  Note that the
c        center of the ellipse, and its orientation are taken from the
c        polynomial hill that was fit to the entire terrain element.
c        (Section modified from CTDMPLUS)
C         GET MAJOR, MINOR AXIS FOR THE HILL BELOW hd
C         KLOW IS THE ARRAY INDEX TO THE HEIGHT CLOSEST TO (BUT LESS
C         THAN) ht
          KLOW = KLOSE( ZH(1,ih), NZH(ih), ht )
          IF( KLOW .EQ. 0 ) KLOW = 1
          BASEHW = ZH(KLOW,ih)
          IF( KLOW .EQ. NZH(ih) ) THEN
C             THE CRITICAL HT IS ABOVE LAST CONTOUR VALUE
C             DO NOT INTERPOLATE, BUT USE INVERSE POLYNOMIAL FORMULA
C
C             COMPUTE MAJOR & MINOR AXIS LENGTHS: INTERPOLATE BETWEEN
C             MAJAXW, MINAXW AND 0.0 IF ABOVE THE LAST CONTOUR
C
              FRACT =  1.0 - (ht - BASEHW)/(h - BASEHW)
              aax = MAJAXW(KLOW,ih) * FRACT
              bax = MINAXW(KLOW,ih) * FRACT
          ELSE
C             LINEARLY INTERPOLATE BETWEEN TWO VALUES
              aax = XINTRP( ZH(KLOW,ih), ZH(KLOW+1,ih),  ht,
     *                       MAJAXW(KLOW,ih), MAJAXW(KLOW+1,ih))
              bax = XINTRP( ZH(KLOW,ih), ZH(KLOW+1,ih),  ht,
     *                       MINAXW(KLOW,ih), MINAXW(KLOW+1,ih))
          ENDIF
      elseif(mhillt .EQ. 2) then
c ---    OPTHILL format hill information
         call AXIS(ht,aax,bax)
      endif
      baxi=one/bax

c  ----- Compute attributes of flow below Hd -----

c  Make sure that initial puff position used to define source streamline
c  is far enough away from hill
c     xpfi=AMIN1(xpf,-two*aax)
      xpfi=AMIN1(xpf,-100.*aax)

c  Find alpha-w (wind direction CW from major axis of ellipse)
c  (note that alpha-w has a range of 0-360 degrees)
      alfw=(thetaw-thetah(ih))*dtor
      if(alfw .LT. zero) alfw=alfw+twopi

c  Find beta (angle CCW from flow direction to "beta direction")
      r=aax*baxi
      top=r*SIN(alfw)
      bot=COS(alfw)
      alfs=ATAN2(top,bot)
c  (make sure that alpha-s has a range of 0-360 degrees)
      if(alfs .LT. zero) alfs=alfs+twopi
      beta=alfw-alfs

c  Find impingement pt. in ellipse coord. system (x along major axis)
      xoe=aax*COS(-alfw)
      yoe=bax*SIN(-alfw)

c  Rotate ellipse system to place x-axis along the flow direction
      rotang=pi-alfw
      call ROTATE(xoe,yoe,rotang,xof,yof)

c  Find the x-coord of the impingement pt. in the beta system
c       (note that this is the boundary between regions 1 and 2,
c        and the negative is the boundary between regions 2 and 3
c        in the flow below Hd)
      call ROTATE(xof,yof,beta,xob,yob)

c  Find puff position in beta coordinate system
      call ROTATE(xpf,ypf,beta,xpb,ypb)

c  Find d, the distance between the puff SL and stagnation SL
c  - Find initial puff position in ellipse coord system
      call ROTATE(xpfi,ypf,-rotang,xpei,ypei)
c  - Convert to elliptical coordinates
      call MUNU(0,xpei*baxi,ypei*baxi,r,mu,nu)
c  - Compute d
      d=(aax+bax)*SINH(mu)*SIN(nu+alfw)

c  ----- Compute attributes of flow above Hd -----

c  Determine boundaries between regions above Hd
      sbeta=SIN(beta)
      cbeta=COS(beta)
      x12f=(xob-ypf*sbeta)/cbeta
      x23f=(-xob-ypf*sbeta)/cbeta

c  Compute time-of-travel from puff at the start of the time-step to
c       the boundary(1,2).  This applies to the flow both above and
c       below Hd.  Note that t12p < 0 when puff is already past the
c       (1,2) boundary.
      x12p=x12f-xpf
      t12p=x12p/u

c  Compute the age of puff at the impingement point (timpg)
      timpg=tstart+t12p

c  Compute sigmas at the impingement point
      tlow=AMAX1(timpg,zero)
c old szo=SIGMA(tlow,sz1,tstart,sz2,tstep,szr,frac)
      szimpg=SIGMA(2,zpuff,u,tlow,sz1,tstart,sz2,tstep,szr,frac)
      szimpg=AMAX1(szmn,szimpg)
c old syo=SIGMA(tlow,sy1,tstart,sy2,tstep,syr,frac)
      syimpg=SIGMA(1,zpuff,u,tlow,sy1,tstart,sy2,tstep,syr,frac)
      syimpg=AMAX1(symn,syimpg)

c  Obtain Gaussian hill length scale for each axis of hill (above Hd)
      halfht=half*(h+hd)
      call AXIS(halfht,axa,axb)
      ah=axa*alphai
      bh=axb*alphai

c  Determine angle between the minor axis of the hill and the flow
c  in radians.  Note that use of psi is invariant to shifts of +/- pi
      psi=(thetaw-thetah(ih))*dtor-piby2

c  Set variables contained in common FLVARS:
c  Cut-off hill height and Froude number above Hd
      hh=h-hd
      fr=ubyn/hh
c  Find parameters for rotated hill
      call HILROT(ah,bh,psi)

c  Adapt section of code from CTDM subroutine FLOW ----------
c  (Note: speed shear ALF is no longer passed on to FLOPUFF)
C *** COMPUTE NEEDED LENGTH SCALE FACTORS.
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c *** Restore LZI ('92 Modification). Sigma Research Corp.
      LZI = SQRT(HALF * (LXI2 + LYI2) ) / RNLZ
c     lzi = sqrt( lxi2 + lyi2 )
c  LN and LNI are now computed in flopuff
c     LN  = HALF * rtpi * LZ
c     LNI = ONE / LN
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
      LZ  = ONE / LZI
C
C     COMPUTE THE HILL ASYMMETRY FACTOR HASYM. ....EQN. A-19B
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c *** Restore HASYM ('92 Modification). Sigma Research Corp.
      HASYM = SQRT(1.0+LX*LX*LYI2)
c     hasym = one
      IF(HASYM .GT. rt2) HASYM = rt2
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
c

c *** Begin shear modifications (1996).  EARTH TECH -- DGS
c --- Find speed shear from 1/2 the cut-off hill height to 1.5 the
c --- cut-off hill height
      hlo=half*(h+hd)
      hhi=two*h-hlo
      alf=(SPEED(hhi-hd)-SPEED(hlo-hd))/hh
      if(alf.LT.zero) alf=zero
c --- Modify neutral length scale, using shear and wind speed at hilltop
c --- provided speed at top is at least 1/10 puff speed
      speedhh=SPEED(hh)
      if(speedhh.GT.0.1*u) then
         lni=lzi+alf/speedhh
      else
         lni=lzi
      endif
      ln=one/lni
c *** End shear modifications (1996).  EARTH TECH -- DGS

c
C *** COMPUTE CORRECTED STRATIFICATION, S.
      BVUI = zero
      IF(ubyn .LT. 999.) BVUI=one/ubyn
      BVUI2 = BVUI * BVUI
      S = BVUI * HASYM
      S2 = S*S
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c  -B0N2 is not used, and B0,B02 are computed in FLOPUFF
c     B0N2 = B0N * B0N
c     B0 = S * LZ * RTPII * B0N
c     B02 = B0 * B0
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.

c *** Begin shear modifications (1996).  EARTH TECH -- DGS
c     Compute B0, and B02 here once again
      b0=s*ln
      b02=b0*b0
c *** End shear modifications (1996).  EARTH TECH -- DGS

c  End section of code from CTDM subroutine FLOW ********************

c  Define streamline height above Hd for obtaining distortion factors.
c  Use puff-center height above Hd, but set minimum value to hslfac
c  times the cut-off hill height (HH).
      hslmin=hslfac*hh
      hsl=AMAX1(zpuff-hd,hslmin)

c  Do not allow the ht of streamline to exceed upper limit compatible
c  with the flow routine
      hslmax=hh+piby2*ubyn/hasym
      hsl=AMIN1(hsl,hslmax)

c  Set up array of distortion factors at ntpts points along puff
c  trajectory, centered at x=xmf, covering a range of 3*el.
c  The length el is one half the distance between points of
c  intersection of the line y=0 (the centerplane of the flow over the
c  hill) with the ellipse that forms the base hill below Hd.
c  But xmf is the mid-point of the intersection of the puff trajectory
c  (without deflection) and the ellipse.  Note that at(1,-)=th, and
c  at(2,-)=tl; tu will be obtained from 1/(th*tl)
      spsi=SIN(psi)
      cpsi=COS(psi)
      spsi2=spsi*spsi
      cpsi2=cpsi*cpsi
      aax2=aax*aax
      bax2=bax*bax
      c1=(aax2-bax2)*spsi*cpsi
      c2=bax2*spsi2+aax2*cpsi2
      c2i=one/c2
      c4=aax2*bax2
      xmf=-c1*ypf*c2i
      el=SQRT(c4*c2i)
      xspace=three*el/(ntpts-1)
      xbegin=xmf-half*(ntpts-1)*xspace
      xend=xbegin+three*el

c  Set a flag so that factors = 1 if trajectory passes to side of hill
      iflag=0
      if(ypf*ypf .LT. c2) iflag=1

c  Loop over points
c  Set factors for first and last points equal to 1
      k=1
      at(1,k)=one
      at(2,k)=one
      k=ntpts
      at(1,k)=one
      at(2,k)=one

c  Set initial guess for streamline position upwind of hill before
c  entering loop.  PATH will use "current" ysl,zsl values when searching
c  for the streamline position at the next x-value.
      ysl=ypf
      zsl=hsl
      do 10 k=2,ntpts-1
         at(1,k)=one
         at(2,k)=one
         x=(k-1)*xspace+xbegin
         if(iflag .NE. 1) then
            ysl=ypf
            zsl=hsl
         else
c           call PATH(at(1,k),at(2,k),dum,x,ypf,hsl,ysl,zsl)
            call PATH(at(1,k),at(2,k),dum,x,ypf,hsl,xspace,ysl,zsl)
c *** Diagnostic write statement:
c           if(at(1,k) .LE. zero .OR. at(2,k) .LE. zero)
c    1                                 print *,k,(at(i,k),i=1,2)
         endif
10    continue

c --- Report DEBUG information
      if(ldb) then
         write(idebug,*)
         write(idebug,*) 'CTPAR: Flow below Hd ----'
         write(idebug,*) 'Height for axes (m) = ',ht
         write(idebug,*) 'Axis lengths (m)    = ',aax,bax
         write(idebug,*) 'Dist to imp pt (m)  = ',x12p
         write(idebug,*) 'Time to imp pt (s)  = ',timpg
         write(idebug,*) 'Sigma y,z at imp pt = ',syimpg,szimpg
         write(idebug,*) 'Crosswind y to SSL  = ',d
         write(idebug,*)
         write(idebug,*) 'CTPAR: Flow above Hd ----'
         write(idebug,*) 'Axis lengths (m)    = ',ah,bh
         write(idebug,*) 'Upper Froude No     = ',fr
      endif


      return
      end
c-----------------------------------------------------------------------
      subroutine ctrec
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                   CTREC
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes receptor position in various coordinate
c               systems and obtains travel times from regional bounds.
c
c ARGUMENTS:    none
c
c CALLING ROUTINES:     CTSG
c
c EXTERNAL ROUTINES:    ROTATE, IREG
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

c  Shift receptor position to hill-centered coordinate system with
c       x-axis along the flow
      xrc=xr-xc(ih)
      yrc=yr-yc(ih)
      call ROTATE(xrc,yrc,rotflo,xrf,yrf)

c  Find receptor position in ellipse coordinate system
      call ROTATE(xrf,yrf,-rotang,xre,yre)

c  Reset receptor location to the surface of the elliptic cylinder
c  if it lies outside of the ellipse (RMU > 0), by changing RMU and
c  computing a new X,Y (Adapted from CTDM+ modification!)
c  Compute the elliptic coordinates of the receptor
      if(zrec. LT. hd) then
         call MUNU(0,xre*baxi,yre*baxi,r,rmu,rnu)
         if(rmu .GT. 0) then
           rsq=r*r
           if(rsq .LT. one) rsq=one
           dum1=SQRT(rsq-one)

           if(dum1 .NE. 0.0) then
c ---        Not a circle (dum1 = 0)
             rmu0=ALOG((r+one)/dum1)
             sinnu=SIN(rnu)
             cosnu=COS(rnu)
             sinhmu=SINH(rmu0)
             coshmu=COSH(rmu0)
             xre=(dum1*coshmu*cosnu)/baxi
             yre=(dum1*sinhmu*sinnu)/baxi
           else

c ---        For a circle centered at (0,0), decrease XRE,YRE by
c ---        the ratio of the radial distance to the ellipse divided
c ---        by the radial distance to (XRE,YRE)

             factor=one/(SQRT(xre*xre+yre*yre)*baxi)
             xre=xre*factor
             yre=yre*factor
           endif

c  Recalculate receptor location with x-axis along the flow
           call ROTATE(xre,yre,rotang,xrf,yrf)

         endif
      endif

c  Find receptor position in beta coordinate system
      call ROTATE(xrf,yrf,beta,xrb,yrb)

c  Determine regions above and below Hd
      iregu=IREG(xrf,x12f,x23f)
      iregl=IREG(xrb,xob,-xob)

c  Compute time-of-travel from boundary(1,2) to receptor
c  - Upper flow:
      t12ru=(xrf-x12f)/u
c  - Lower flow:
      t12rl=(xrb-xob)/(u*cbeta)

      return
      end
c-----------------------------------------------------------------------
      subroutine ctsg(ldbin,irin,ipin,qin,uin,dirin,zlidin,xpin,ypin,
     *                zpin,iscin,zrin,ihin,stepin,tin,sz1in,sz2in,
     *                sy1in,sy2in,szrin,syrin,szmnin,symnin,frin,
     *                conc,cflat)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8     Level: 960521                     CTSG
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Main subroutine that controls computation of
c               concentrations on sub-grid-scale terrain features
c
c ARGUMENTS:
c   PASSED:     ldbin           debug logical                        [l]
c               irin            receptor number                      [i]
c               ipin            puff number                          [i]
c               qin             mass in puff (g)                     [r]
c               uin,dirin       wind speed, direction (m/s, deg CCW) [r]
c               zlidin          mixing lid (m)                       [r]
c               xpin,ypin,zpin  puff coordinates (m) at start of step[r]
c               iscin           stability class                      [i]
c               zrin            receptor height (m)                  [r]
c               ihin            hill ID                              [i]
c               stepin          time step (s)                        [r]
c               tin             age of puff at start of time-step (s)[r]
c               sz1in,sy1in     puff sigmas at start of time-step (m)[r]
c               sz2in,sy2in     puff sigmas at end of time-step (m)  [r]
c               szmnin,symnin   minimum value for sigmas (m)         [r]
c               frin            interpolation fraction for receptor  [r]
c                               position (0:start, 1:end of step)
c               szrin,syrin     puff sigmas at the receptor (m)      [r]
c   RETURNED:   conc            concentration (g/m**3)               [r]
c               cflat           concentration (g/m**3) without hill  [r]
c
c CALLING ROUTINES:     (main)
c
c EXTERNAL ROUTINES:    CTPAR, CTREC, PUFFC, UPPER, LOWER
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

      logical ldbin

c  Check to see if CTSG has just been called for the same time period,
c  the same puff, and the same hill:
      isame=0
      if(tstart .EQ. tin) then
         if(ip .EQ. ipin) then
            if(ih .EQ. ihin) then
               isame=1
            endif
         endif
      endif

c  Transfer debug unit number to CTPASS variable
      idebug=io6

c  Pass argument list into common CTPASS
      ldb=ldbin
      ir=irin
      ip=ipin
      q=qin
      u=uin
      thetaw=dirin
      zlid=zlidin
      xp=xpin
      yp=ypin
      zpuff=zpin
      isc=iscin
      xr=xrctm(irin)
      yr=yrctm(irin)
      zrec=zrin
      ih=ihin
      tstep=stepin
      tstart=tin
      sz1=sz1in
      sz2=sz2in
      sy1=sy1in
      sy2=sy2in
      frac=frin
      szr=szrin
      syr=syrin
      szmn=szmnin
      symn=symnin

c  Calculate diffusivities for the time-step
      if(frac.EQ.zero .OR. frac.EQ.one) then
c ---    Use diffusivity over full step
         twokz=(sz2**2-sz1**2)/tstep
         twoky=(sy2**2-sy1**2)/tstep
      elseif(frac.GT.half) then
c ---    Use diffusivity from receptor position to end of step
         timefac=1./((one-frac)*tstep)
         twokz=(sz2**2-szr**2)*timefac
         twoky=(sy2**2-syr**2)*timefac
      else
c ---    Use diffusivity from start of step to receptor position
         timefac=1./(frac*tstep)
         twokz=(szr**2-sz1**2)*timefac
         twoky=(syr**2-sy1**2)*timefac
      endif
      if(twokz.LT.small) twokz=0.0
      if(twoky.LT.small) twoky=0.0

c  Report argument list in DEBUG mode, and the inferred diffusivity
      if(ldb .AND. irin.eq.1) then
         write(io6,*)
         write(io6,*)'CTSG input data'
         write(io6,*)' ir = ',ir,' ip = ',ip,' q = ',q,
     1  ' u = ',u,' wd = ',thetaw,' zlid = ',zlid,' xp = ',xp,
     2  ' yp = ',yp,' zpuff = ',zpuff,' isc = ',isc,
     3  ' ih = ',ih,' tstep = ',tstep,' tstart = ',tstart,
     4  ' frac = ',frac,
     5  ' sz1 = ',sz1,' sz2 = ',sz2,' sy1 = ',sy1,
     6  ' sy2 = ',sy2,' szr = ',szr,' syr = ',syr,
     7  ' symn = ',symn,' szmn = ',szmn,
     8  ' hd = ',hda(ih),' u/N = ',ubyna(ih),
     9  ' h = ',relief(ih),' 2Kz = ',twokz,' 2Ky = ',twoky
      endif

c  Adjust height of receptor from height above sea level to
c  height above base-plane for current hill.
      zrec=zrec-zgrid(ih)

c  If current hill, puff, or time step differs from the last, compute
c  terrain-related parameters for puff trajectory.
      if(isame .EQ. 0) then
         hd=hda(ih)
         ubyn=ubyna(ih)
         h=relief(ih)
         call CTPAR
      endif

c  Compute receptor-related parameters
      call CTREC

c  Compute concentration
c       When terrain influence is modeled by using a receptor-on-a-pole
c       the standard puff sampling algorithm is called with an argument
c       of either 1 or 2.  Argument 1 signals the use of a pole of
c       height zpole; 2 signals the same plus the use of the distance
c       (d, passed as dpole) from the puff trajectory to the stagnation
c       SL in place of the usual off-axis distance to the receptor.

      cu=zero
      cl=zero
      if(zrec .GT. hd) then
         if(zlid .GT. hd) then
            if(iregu .EQ. 1) then
               zpole=hd
               call PUFFC(1,zpole,zero,cu)
            else
               call UPPER(cu)
            endif
            if(iregl .NE. 1 .and. hd .GT. zero) call LOWER(cl)
         endif
      elseif(hd .GT. zero) then
c ---    Remove test for receptors near base of hill, and treat all
c ---    receptors in the same way
c ---    zmin=0.1*AMIN1(hd,zpuff)
         zpole=zrec
         dpole=d
c ---    if(zpole .LT. zmin) then
c ---       call PUFFC(1,zpole,zero,cl)
c ---    else
            if(iregl .EQ. 1) then
               call PUFFC(2,zpole,dpole,cl)
            else
               call LOWER(cl)
            endif
c ---    endif
      endif

c  Do a "flat" calc. for comparison
      call PUFFC(0,zero,zero,cflat)

      conc=cu+cl

c  Report results in DEBUG mode
      if(ldb .AND. irin.eq.1)then
         write(io6,*)
         write(io6,*)'CTSG output for receptor ',irin
         write(io6,*)'  hd = ',hd,'   u/N = ',ubyn
         write(io6,*)'conc = ',conc,' cflat = ',cflat
      endif

      return
      end
c-----------------------------------------------------------------------
      function fcty(t)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                    FCTY
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes value of integrand function denoted as fcty,
c               at time t.
c
c ARGUMENTS:
c    PASSED:    t       time-of-travel of puff (sec)                 [r]
c
c CALLING ROUTINES:     UPPER
c
c EXTERNAL ROUTINES:    TFAC
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

c  Obtain Th and Tu
      delt=t-timpg
      x=x12f+delt*u
      call TFAC(x,th,tl,tu)

c  Compute integrand
      fcty=twoky*EXP(two*(one-tl))

      return
      end
c-----------------------------------------------------------------------
      function fctz(t)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 951005                    FCTZ
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes value of integrand function denoted as fctz,
c               at time t.
c
c ARGUMENTS:
c    PASSED:    t       time-of-travel of puff (sec)                 [r]
c
c CALLING ROUTINES:     UPPER
c
c EXTERNAL ROUTINES:    TFAC
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

c  Obtain Th and Tu
      delt=t-timpg
      x=x12f+delt*u
      call TFAC(x,th,tl,tu)

c  Compute integrand
      fctz=twokz*tu*tu*EXP(two*(one-th))

      return
      end
c-----------------------------------------------------------------------
      subroutine flopuff(x,y,z,eta,del,thi,tli,tu)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                 FLOPUFF
c ---            R. Yamartino, SRC
c ---            (D. Strimaitis, SRC)
c
C PURPOSE:      (adapted from CTDM subroutine FLOW)
C     COMPUTES THE PERTURBATION WINDS UP,VP,WP AT (X,Y,Z) AND
C     COMPUTES THE VERTICAL AND LATERAL DEFLECTIONS (ETA,DEL) OF THE
C     STREAMLINE THAT PASSES THROUGH THE POINT (X,Y,Z) ABOVE THE
C     SURFACE OF A ROTATED GAUSSIAN HILL.
C *** THIS CODE NOW COMPUTES IDYY, AND IXXDYY TO COMPUTE T-FACTORS.
C     TLI    = 1.0 - D(DEL)/DY = 1.0 + (IDYY + BVUI2*IXXDYY)
C     THI    = 1.0 - D(ETA)/DZ = 1.0 + IDZZ
C
C *** THIS STRATIFIED FLOW CALCULATION ACCOUNTS FOR ARBITRARY
C     STRATIFICATION, N/U, (INCLUDING NEUTRAL) IN THE NEAR FIELD
C     OF THE HILL (I.E. X < LX, Y < LY, Z << LX OR LY ).
C *** LINEAR WIND SHEAR CORRECTIONS ARE ADDED IN SUCH THAT NEUTRAL
C     DEFLECTIONS ARE CORRECT TO LOWEST ORDER IN THE SHEAR GRADIENT.
C *** U''/U = 0 IS ASSUMED BUT N/U IS COMPUTED FROM FR ABOVE HC.
C
C     MODIFICATION:  Changes made during EPA-sponsored upgrade to the
C                    FLOW algorithm have been made here.  This is now
C                    consistent with INPUFF 3.0 (10/93).
C
C ARGUMENTS:
C    PASSED:    X       X COORDINATE (POSITIVE DOWNWIND OF HILL      [r]
C                       CENTER) (m)
C               Y       Y COORDINATE (POSITIVE LEFT OF HILL          [r]
C                       CENTER) (m)
C               Z       Z COORDINATE (POSITIVE ABOVE HILL            [r]
C                       SURFACE) (m)
C  RETURNED:    ETA     VERTICAL DEFL. OF STREAMLINE PASSING         [r]
C                       (X,Y,Z) (m)
C               DEL     LATERAL DEFLECTION OF STREAMLINE PASSING     [r]
C                       (X,Y,Z) (m)
C               TLI     1.0/(TL FACTOR) AT (X,Y,Z)                   [r]
C               THI     1.0/(TH FACTOR) AT (X,Y,Z)                   [r]
C               TU      TU FACTOR AT (X,Y,Z)                         [r]
C
C CALLING ROUTINES:  UPPER, PATH
C
C EXTERNAL ROUTINES: SPEED
C----------------------------------------------------------------------C

      INCLUDE 'const.puf'
      INCLUDE 'flvar.puf'
C                                                                       FLW00470
      REAL*4 I,IDY,IDZ,IDX,IDXX,IDXY,IDXZ                               FLW00490
      REAL*4 IX,IXDY,IXX,IXXDY,IDYY,IDZZ,IXXDYY,ID3Y,IXXD3Y             FLW00500
      DATA WTB/1.25/                                                    FLW00530
C                                                                       FLW00540
C *** MOST OF THIS CODE COMPUTES I AND ITS INTEGRALS AND DERIVATIVES.   FLW00550
C     THE NOTATION IS SEEN IN THE EXAMPLE IXDY, WHICH IS I INTEGRATED   FLW00560
C     ONCE IN X (FROM -INFINITY TO X) AND DIFFERENTIATED IN Y.          FLW00570
C                                                                       FLW00580
C *** COMPUTE DIMENSIONLESS COORDINATES
      XDLX = X * LXI                                                    FLW00710
      YDLY = Y * LYI                                                    FLW00720
      YDLY2 = YDLY * YDLY                                               FLW00730
C                                                                       FLW00740
C *** COMPUTE THE MODIFIED COORDINATES XM,YM AND THEIR                  FLW00750
C     DIMENSIONLESS FORMS XMDLX,YMDLY.                                  FLW00760
      XM = X + GAM*LX*LX*Y                                              FLW00770
      YM = Y + GAM*LY*LY*X                                              FLW00780
      XMDLX = XM * LXI                                                  FLW00790
      XMDLX2 = XMDLX * XMDLX                                            FLW00800
      YMDLY = YM * LYI                                                  FLW00810
      YMDLY2 = YMDLY * YMDLY                                            FLW00820
C                                                                       FLW00830
      GAMLX = GAM * LX                                                  FLW00840
      GAMLX2 = GAMLX * GAMLX                                            FLW00850
      GAMP = ONE - GAMLX2*LY*LY                                         FLW00860
      GAMP2 = GAMP * GAMP                                               FLW00870
C                                                                       FLW00880
C     HHXY = HH * HILHGT(X,Y)   BUT COMPUTE IN CODE BELOW.              FLW00890
      ARG = XDLX*XDLX + YDLY*YDLY + 2.0*GAM*X*Y                         FLW00900
      IF(ARG .GT. 30.) ARG = 30.                                        FLW00910
      EXPARG = EXP(-ARG)                                                FLW00920
      HHXY = HH * EXPARG                                                FLW00930
C                                                                       FLW00940
C *** OBTAIN CORRECT WIND SPEED, U, USING SPEED                         FLW00950
C                                                                       FLW00960
      U = SPEED(HHXY+Z)                                                 FLW00970
      UI = ONE / U                                                      FLW00980
C                                                                       FLW00990
C     COMPUTE THE SHEAR FACTORS THAT ARE NEEDED.                        FLW01000
C                                                                       FLW01010
c !!! Begin shear modifications 1996.  EARTH TECH -- DGS
c
c dgs U0 = AMIN1(SPEED(HHXY),U)                                         FLW01020
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c     SHRF = SQRT(U0*UI)                                                FLW01030
c     SHRFDZ = -HALF * ALF * UI                                         FLW01040
c     SHRC=HALF*ALF/U0                                                  FLW01050
c dgs shrf = u / u0
c dgs ln  = lz * shrf
c dgs lni = one / ln
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
c
C *** COMPUTE THE ADDITIONAL Z SUPRESSION FACTOR FROM NEUTRAL FLOW MATCHFLW01060
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c     ZFACI = ONE / (ONE + LNI * Z)                                     FLW01070
c     ZFACDZ = -TWO * LNI * ZFACI                                       FLW01080
      zfaci = exp(-lni * z)
C *** COMBINE WITH SHEAR FACTOR TO GIVE TOTAL Z ADJUSTMENT FACTOR.      FLW01090
c     TZFAC = SHRF * ZFACI * ZFACI                                      FLW01100
c     TZFDZ = SHRFDZ + ZFACDZ                                           FLW01110
c     TZFDZZ = TZFDZ*TZFDZ - SHRFDZ*ALF*UI - ZFACDZ*LNI*ZFACI           FLW01120
c *** Combine with shear factor to give total z adjustment factor.
c dgs b0 = s * ln
c dgs b02 = b0 * b0
c dgs tzfac = zfaci * lz  / (one + b02)
      tzfac = zfaci * ln  / (one + b02)
      tzfdz = -lni
      tzfdzz = lni*lni
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
c !!! End shear modifications 1996.  EARTH TECH -- DGS

C                                                                       FLW01130
C                                                                       FLW01260
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c     AST = TWO * RTPII * S2 * LZ * PII * B0N2 - SHRC                   FLW01270
      ast = one
C --- ASTDS2 IS ACTUALLY AST/(S*BVUI)                                   FLW01280
c     ASTDS2 = TWO * RTPII * LZ * PII * HASYM                           FLW01290
      astds2 = one
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
c
C --- HHM IS THE COEFFICIENT OF I AT X=Y=0                              FLW01300
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c     HHM = HH * LN / (ONE + B02)                                       FLW01310
      hhm = hh
C --- HHXYM IS THE COEFFICIENT OF I AWAY FROM HILL CREST                FLW01320
      HHXYM = HHM * EXPARG                                              FLW01330
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
C *** COMPUTE THE STRATIFICATION HEIGHT, SZ.                            FLW01340
      SZ = S * Z                                                        FLW01350
C                                                                       FLW01360
C *** COMPUTE THE VARIOUS 'ANGULAR FACTORS', AFN, AND THEIR DERIVATIVES,FLW01370
C     ADN, CONDITIONED ON THE VALUE OF SZ.                              FLW01380
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c     IF(SZ .LE. 0.005) THEN                                            FLW01390
c        CSZ = ONE                                                      FLW01400
c        SSZ = SZ                                                       FLW01410
c        AF1 = Z                                                        FLW01420
c        AD1 = ONE                                                      FLW01430
c        ADD1 = S * SZ                                                  FLW01440
c     ELSE                                                              FLW01450
c        SI  = ONE / S                                                  FLW01460
c        CSZ = COS(SZ)                                                  FLW01470
c        SSZ = SIN(SZ)                                                  FLW01480
c        AF1 = SSZ * SI                                                 FLW01490
c        AD1 = CSZ                                                      FLW01500
c        ADD1 = -S * SSZ                                                FLW01510
c     ENDIF                                                             FLW01520
      csz = cos(sz)
      ssz = sin(sz)
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
C                                                                       FLW01530
C     AF0 = CSZ / ZFACI                                                 FLW01540
C     AD0 = LNI * CSZ  -  S * SSZ / ZFACI                               FLW01550
C *** OVERRIDE AF0=CSZ WITH AF0=ONE. 10/8/86                            FLW01560
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
c     AF0 = ONE / ZFACI                                                 FLW01570
c     AD0 =  LNI                                                        FLW01580
c     ADD0 = -S2 / ZFACI                                                FLW01590
c     AF2SHR = TWO * LNI + SHRC                                         FLW01600
c     AF2 = S * CSZ + AF2SHR * SSZ                                      FLW01610
c     AD2 = -S2 * SSZ + AF2SHR * S * CSZ                                FLW01620
c     ADD2 = -S2 * (S * CSZ + AF2SHR * SSZ)                             FLW01630
c
      af0 = csz
      ad0 =  -s * ssz
      add0 = -s2 * csz
c
      af1 = b0 * ssz
      ad1 = b0 * s * csz
      add1 = -b0 * s2 * ssz
c
      af2 = b0 * csz  +  ssz
      ad2 = -b0 * s * ssz  +  s * csz
      add2 = -s2 * (b0 * csz  +  ssz)
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
C                                                                       FLW01640
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR I.                         FLW01650
      T0 = ONE                                                          FLW01660
c *** Begin Modifications 7/4/91. Sigma Research Corp.  RJY.
      T1 = -AST                                                         FLW01670
c or  t1 = -one
C ??? T2 = -ASTDS2*XMDLX                                                FLW01680
C ---------- TRY SETTING T2=0. FOR XM LESS THAN ZERO ------------       FLW01690
c     T2 = 0.                                                           FLW01700
c     IF(XM .GE. 0.) T2 = -ASTDS2*XMDLX                                 FLW01710
      t2 = -astds2*xmdlx
c or  t2 = -xmdlx
c *** End Modifications 7/4/91. Sigma Research Corp.  RJY.
C                                                                       FLW01720
      TI0 = T0 * AF0                                                    FLW01730
      TI1 = T1 * AF1                                                    FLW01740
      TI2 = T2 * AF2                                                    FLW01750
      SUM = TI0 + TI1 + TI2                                             FLW01760
C                                                                       FLW01770
C *** COMPUTE THE BASIC QUANTITY I.   ....EQN. A-27                     FLW01780
      I = TZFAC * HHXYM * SUM                                           FLW01790
C                                                                       FLW01800
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDZ.                       FLW01810
      TI0 = T0 * AD0                                                    FLW01820
      TI1 = T1 * AD1                                                    FLW01830
      TI2 = T2 * AD2                                                    FLW01840
      SUM = TI0 + TI1 + TI2                                             FLW01850
C                                                                       FLW01860
C *** COMPUTE THE DERIVATIVE OF I WITH RESPECT TO Z.  ....EQN. A-28     FLW01870
      TERM1 = TZFAC * HHXYM * SUM                                       FLW01880
      IDZ =  TERM1  +  TZFDZ * I                                        FLW01890
C                                                                       FLW01900
C *** COMPUTE THE SECOND DERIVATIVE OF I WITH RESPECT TO Z.             FLW01910
      TI0 = T0 * ADD0                                                   FLW01920
      TI1 = T1 * ADD1                                                   FLW01930
      TI2 = T2 * ADD2                                                   FLW01940
      SUM = TI0 + TI1 + TI2                                             FLW01950
C                                                                       FLW01960
C *** COMPUTE THE SECOND DERIVATIVE OF I WITH RESPECT TO Z. ....EQN.A-29FLW01970
      IDZZ = TZFAC * HHXYM * SUM  +  TWO * TZFDZ * TERM1  +  TZFDZZ * I FLW01980
C                                                                       FLW01990
C                                                                       FLW02000
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDX AND IDXZ.              FLW02010
C     T0 = ZERO                                                         FLW02020
C     T1 = ZERO                                                         FLW02030
      T2 = -ASTDS2 * LXI                                                FLW02040
C                                                                       FLW02050
C     TI0 = T0 * AF0                                                    FLW02060
C     TI1 = T1 * AF1                                                    FLW02070
      TI2 = T2 * AF2                                                    FLW02080
C     SUM = TI0 + TI1 + TI2                                             FLW02090
      SUM = TI2                                                         FLW02100
C                                                                       FLW02110
C *** COMPUTE THE QUANTITY IDX.    ....EQN. A-30                        FLW02120
      TERM2 = TZFAC * HHXYM * SUM                                       FLW02130
      IDX = -TWO * XMDLX * LXI * I  +  TERM2                            FLW02140
C                                                                       FLW02150
C     NOW COMPUTE THE D/DZ TERMS.                                       FLW02160
C     TI0 = T0 * AD0                                                    FLW02170
C     TI1 = T1 * AD1                                                    FLW02180
      TI2 = T2 * AD2                                                    FLW02190
C     SUM = TI0 + TI1 + TI2                                             FLW02200
      SUM = TI2                                                         FLW02210
C                                                                       FLW02220
C *** COMPUTE THE DERIVATIVE OF IDX WITH RESPECT TO Z.  ....EQN. A-32   FLW02230
      TERM3 = TZFAC*HHXYM*SUM                                           FLW02240
      IDXZ = -TWO*XMDLX*LXI*IDZ + TZFDZ*TERM2 + TERM3                   FLW02250
C                                                                       FLW02260
C                                                                       FLW02270
C *** COMPUTE THE QUANTITIES NEEDED FOR IDXX.                           FLW02280
C     T0 = ZERO                                                         FLW02290
C     T1 = ZERO                                                         FLW02300
C     T2 = ZERO                                                         FLW02310
C                                                                       FLW02320
C     TI0 = T0 * AF0                                                    FLW02330
C     TI1 = T1 * AF1                                                    FLW02340
C     TI2 = T2 * AF2                                                    FLW02350
C     SUM = TI0 + TI1 + TI2                                             FLW02360
      SUM = ZERO                                                        FLW02370
C                                                                       FLW02380
C *** COMPUTE THE QUANTITY IDXX.  ....EQN. A-31                         FLW02390
      IDXX = -TWO * LXI2 * (ONE + TWO * XMDLX2) * I  -                  FLW02400
     X       FOUR * XMDLX * LXI * IDX  +  TZFAC * HHXYM * SUM           FLW02410
C                                                                       FLW02420
C                                                                       FLW02430
C                                                                       FLW02440
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDY.                       FLW02450
C     T0 = ZERO                                                         FLW02460
C     T1 = ZERO                                                         FLW02470
      T2 = -ASTDS2 * GAMLX                                              FLW02480
C                                                                       FLW02490
C     TI0 = T0 * AF0                                                    FLW02500
C     TI1 = T1 * AF1                                                    FLW02510
      TI2 = T2 * AF2                                                    FLW02520
C     SUM = TI0 + TI1 + TI2                                             FLW02530
      SUM = TI2                                                         FLW02540
C                                                                       FLW02550
C *** COMPUTE THE QUANTITY IDY.   ....EQN. A-33                         FLW02560
      IDY = -TWO * LYI * YMDLY * I  +  TZFAC * HHXYM * SUM              FLW02570
C                                                                       FLW02580
C *** COMPUTE THE QUANTITY IDYY.  ....EQN. A-34                         FLW02590
      IDYY = -TWO * LYI2 * (ONE + TWO * YMDLY2) * I  -                  FLW02600
     X       FOUR * YMDLY * LYI * IDY                                   FLW02610
C                                                                       FLW02620
C *** COMPUTE THE QUANTITY ID3Y.  ....EQN. A-35                         FLW02630
      ID3Y = -8.0 * LYI3 * YMDLY * I  -  FOUR * LYI * YMDLY * IDYY  -   FLW02640
     X       TWO * LYI2 * (THREE + TWO * YMDLY2) * IDY                  FLW02650
C                                                                       FLW02660
C                                                                       FLW02670
C *** COMPUTE THE QUANTITIES NEEDED FOR IDXY.                           FLW02680
C     T0 = ZERO                                                         FLW02690
C     T1 = ZERO                                                         FLW02700
C     T2 = ZERO                                                         FLW02710
C                                                                       FLW02720
C     TI0 = T0 * AF0                                                    FLW02730
C     TI1 = T1 * AF1                                                    FLW02740
C     TI2 = T2 * AF2                                                    FLW02750
C     SUM = TI0 + TI1 + TI2                                             FLW02760
      SUM = ZERO                                                        FLW02770
C                                                                       FLW02780
C *** COMPUTE THE QUANTITY IDXY.     ....EQN. A-36                      FLW02790
      IDXY = -TWO * (GAM  +  TWO * XM * YM * LXI2 * LYI2) * I  -        FLW02800
     X       TWO * XMDLX * LXI * IDY  -                                 FLW02810
     X       TWO * YMDLY * LYI * IDX  +  TZFAC * HHXYM * SUM            FLW02820
C                                                                       FLW02830
C                                                                       FLW02840
C ****************************************************************      FLW02850
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXXDY.                     FLW02860
C     NOTE THAT IXX IS ALSO NEEDED FOR THIS.                            FLW02870
C                                                                       FLW02880
C --- COMPUTE THE GNX AND GNXX FACTORS.                                 FLW02890
C $$$ G0X = HALF * rtpi * ( ONE + ERF(XMDLX) )                          FLW02900
C --- INSERT THE FOLLOWING FIX TO KILL LAT. DEFL. GROWTH. 10/1/86       FLW02910
      G0X = HALF * rtpi * ( ONE - ERF( ABS(XMDLX) )  )                  FLW02920
C                                                                       FLW02930
      IF(XMDLX2 .GT.30.) XMDLX2 = 30.                                   FLW02940
      G1X = -HALF * EXP(-XMDLX2)                                        FLW02950
      G0XX = XMDLX * G0X - G1X                                          FLW02960
      G1XX = -HALF * G0X                                                FLW02970
C                                                                       FLW02980
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXX.                       FLW02990
      T0 = G0XX                                                         FLW03000
      T1 = -G0XX                                                        FLW03010
      T1 = AST * T1                                                     FLW03020
      T2 = -ASTDS2*G1XX                                                 FLW03030
C                                                                       FLW03040
      TI0 = T0 * AF0                                                    FLW03050
      TI1 = T1 * AF1                                                    FLW03060
      TI2 = T2 * AF2                                                    FLW03070
      SUM = TI0 + TI1 + TI2                                             FLW03080
C                                                                       FLW03090
C *** COMPUTE THE QUANTITY IXX.      ....EQN. A-42                      FLW03100
C     QX = YDLY2 - GAMLX2 * Y * Y                                       FLW03110
      QX = YDLY2 * GAMP                                                 FLW03120
      IF(QX .GT.30.) QX = 30.                                           FLW03130
      EFAC = EXP(-QX)                                                   FLW03140
      HHLX2E = HHM * LX * LX * EFAC                                     FLW03150
      IXX = TZFAC * HHLX2E * SUM                                        FLW03160
C                                                                       FLW03170
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXXDY.                     FLW03180
      T0 = GAMLX*G0X                                                    FLW03190
      T1 = -GAMLX*G0X                                                   FLW03200
      T1 = AST * T1                                                     FLW03210
      T2 = -ASTDS2*GAMLX*G1X                                            FLW03220
C                                                                       FLW03230
      TI0 = T0 * AF0                                                    FLW03240
      TI1 = T1 * AF1                                                    FLW03250
      TI2 = T2 * AF2                                                    FLW03260
      SUM = TI0 + TI1 + TI2                                             FLW03270
C                                                                       FLW03280
C *** COMPUTE THE QUANTITY IXXDY.     ....EQN. A-44                     FLW03290
      IXXDY = -TWO * LYI2 * Y * GAMP * IXX  +  TZFAC * HHLX2E * SUM     FLW03300
C                                                                       FLW03310
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IX.                        FLW03320
      T0 = +G0X                                                         FLW03330
      T1 = -G0X                                                         FLW03340
      T1 = AST * T1                                                     FLW03350
      T2 = -ASTDS2*G1X                                                  FLW03360
C                                                                       FLW03370
      TI0 = T0 * AF0                                                    FLW03380
      TI1 = T1 * AF1                                                    FLW03390
      TI2 = T2 * AF2                                                    FLW03400
      SUM = TI0 + TI1 + TI2                                             FLW03410
C                                                                       FLW03420
C *** COMPUTE THE QUANTITY IX.     ....EQN. A-41                        FLW03430
      IX = TZFAC * HHLX2E * LXI * SUM                                   FLW03440
C                                                                       FLW03450
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXDY.                      FLW03460
C     HHJ = GAMLX * EXP(-XMDLX2) * XMDLX**J  BUT SEE G1X                FLW03470
      HH0 = -TWO * G1X * GAMLX                                          FLW03480
      HH1 = HH0 * XMDLX                                                 FLW03490
      HH2 = HH1 * XMDLX                                                 FLW03500
      T0 = HH0                                                          FLW03510
      T1 = -HH0                                                         FLW03520
      T1 = AST * T1                                                     FLW03530
      T2 = -ASTDS2*HH1                                                  FLW03540
C                                                                       FLW03550
      TI0 = T0 * AF0                                                    FLW03560
      TI1 = T1 * AF1                                                    FLW03570
      TI2 = T2 * AF2                                                    FLW03580
      SUM = TI0 + TI1 + TI2                                             FLW03590
C                                                                       FLW03600
C *** COMPUTE THE QUANTITY IXDY.        ....EQN. A-45                   FLW03610
      IXDY = -TWO * LYI2 * Y * GAMP * IX  +  TZFAC * HHLX2E * LXI * SUM FLW03620
C                                                                       FLW03630
C                                                                       FLW03640
C *** COMPUTE THE QUANTITY IXXDYY       ....EQN. A-46                   FLW03650
C     (NOTE THAT IXXDYY USES THE SAME SUM AS IXDY)                      FLW03660
      IXXDYY = -TWO * LYI2 * GAMP * IXX * (ONE + TWO*GAMP*YDLY2) -      FLW03670
     X          FOUR * LYI2 * Y * GAMP * IXXDY  +                       FLW03680
     X          TZFAC * HHLX2E * GAMLX * SUM                            FLW03690
C                                                                       FLW03700
C                                                                       FLW03710
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXXD3Y.                    FLW03720
      T0 = -TWO * HH1                                                   FLW03730
      T1 = +TWO * HH1                                                   FLW03740
      T1 = AST * T1                                                     FLW03750
      T2 = -ASTDS2 * (HH0 - TWO*HH2)                                    FLW03760
C                                                                       FLW03770
      TI0 = T0 * AF0                                                    FLW03780
      TI1 = T1 * AF1                                                    FLW03790
      TI2 = T2 * AF2                                                    FLW03800
      SUM = TI0 + TI1 + TI2                                             FLW03810
C                                                                       FLW03820
C *** COMPUTE THE QUANTITY IXXD3Y.        ....EQN. A-47                 FLW03830
      IXXD3Y = -FOUR*LYI3*GAMP2*IXX*YDLY*(THREE+TWO*GAMP*YDLY2) -       FLW03840
     X          6.0 * LYI2 * GAMP * IXXDY * (ONE+TWO*GAMP*YDLY2)  -     FLW03850
     X          6.0 * LYI * GAMP * YDLY * IXXDYY  +                     FLW03860
     X          TZFAC * HHLX2E * GAMLX2 * SUM                           FLW03870
C                                                                       FLW03880
C ************************************************************          FLW03890
C *** COMPUTE THE STREAMLINE DEFLECTIONS.                               FLW03900
C *** COMPUTE THE VERTICAL DEFLECTION AS -(D/DZ) I.  ....EQN. A-22A     FLW03910
      ETA = -IDZ                                                        FLW03920
C *** NOW COMPUTE THE LATERAL DEFLECTION AS          ....EQN. A-22E     FLW03930
C     DEL = -(D/DY)(IDY+BVUI2*IXX) = -(IDY + BVUI2*IXXDY)               FLW03940
C *** AND COMPUTE ITS FIRST AND SECOND DERIVATIVES                      FLW03950
      TERM3 = BVUI2 * IXXDY                                             FLW03960
      DEL = -(IDY + TERM3)                                              FLW03970
      DELDY = -IDYY - BVUI2*IXXDYY                                      FLW03980
      DELDYY = -ID3Y - BVUI2*IXXD3Y                                     FLW03990
C *** COMPUTE CORRECTION FACTOR FOR LATERAL DEFLECTIONS                 FLW04000
      DELC = ONE + ABS(DELDY)                                           FLW04010
      DELCOR = DELC                                                     FLW04020
      IF(ABS(DEL).LT.0.001*LY) THEN                                     FLW04030
         DELCOR = ONE                                                   FLW04040
      ELSEIF(ABS(DELDYY*LY) .GT. 0.001) THEN                            FLW04050
         EPS = WTB*DELDYY*DEL                                           FLW04060
         ARGRT = DELC*DELC-TWO*EPS                                      FLW04070
         RTDELC = 0.                                                    FLW04080
         IF(ARGRT .GE. 0.) RTDELC = SQRT(ARGRT)                         FLW04090
         IF(RTDELC .NE. DELC) DELCOR = EPS/(DELC-RTDELC)                FLW04100
      ENDIF                                                             FLW04110
C *** APPLY CORRECTION FACTOR                                           FLW04120
      DEL = DEL / DELCOR                                                FLW04130
C                                                                       FLW04140
C *** COMPUTE THE RECIPROCAL OF THE T FACTORS      ....EQNS. A-22F,G    FLW04150
C *** NOTE THAT THE T FACTORS COULD GO TO INFINITY.                     FLW04160
      TLI = ONE - DELDY/DELCOR                                          FLW04170
      THI = ONE + IDZZ                                                  FLW04180
C                                                                       FLW04190
C ****************************************************************      FLW04200
C                                                                       FLW04210
C *** COMPUTE THE PERTURBATION VELOCITIES.   ...EQNS. A-22B,C,D         FLW04220
C                                                                       FLW04230
C *** NOW COMPUTE THE ALONG-WIND VELOCITY PERTURBATION AS               FLW04240
C     UP/U = -(IDXX + (BV*UI)**2 * I )                                  FLW04250
C     NOTE THAT THIS IS JUST THE NEGATIVE OF THE PERTURBATION           FLW04260
C     PRESSURE DIVIDED BY RHO(0)*U**2.                                  FLW04270
      TERM3 = BVUI2 * I                                                 FLW04280
      UP = -(IDXX + TERM3)                                              FLW04290
C *** COMPUTE THE NON-LINEAR PERTURBATION ALA HUNT ET AL.               FLW04300
C!!!!!UPNL = ( -ONE + SQRT( ABS(ONE + TWO*UP) )  ) * U                  FLW04310
      UP = UP * U                                                       FLW04320
C                                                                       FLW04330
C *** NOW COMPUTE THE LATERAL VELOCITY PERTURBATION AS                  FLW04340
C     VP/U = -(IDXY + (BV*UI)**2 * IXDY)                                FLW04350
      TERM3 = BVUI2 * IXDY                                              FLW04360
      VP = -(IDXY + TERM3) * U                                          FLW04370
C                                                                       FLW04380
C *** NOW COMPUTE THE VERTICAL VELOCITY PERTURBATION AS -(D/DZ) IDX.    FLW04390
      WP = -IDXZ * U                                                    FLW04400
C                                                                       FLW04410
C ***********************************************************           FLW04420
C                                                                       FLW04430
C *** COMPUTE THE "SPEED-UP" FACTOR TU                                  FLW04440
      UTOT=SQRT( (U+UP)*(U+UP) + VP*VP + WP*WP )                        FLW04450
      TU = UTOT*UI                                                      FLW04460
C                                                                       FLW04470
C ***********************************************************           FLW04480
C                                                                       FLW04490
      RETURN                                                            FLW04500
      END                                                               FLW04510
c-----------------------------------------------------------------------
c      subroutine getprfm(ihill,umet,vmet,tmet,zgpt,nears,tempss,lcalgrd,
c     &                   istab,ptg,nx,ny,nz,xorig,yorig,dgrid)
      subroutine getprfm(ihill,umet,vmet,tmet,zgpt,nears,tempss,lcalgrd,
     &                   istab,ptg,nx,ny,nz,xorig,yorig,dgrid,
     &                   i2dmet,temp2d)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                 GETPRFM
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Passes vertical profiles of wind speed and the Brunt-
c               Vaisala Frequency into common for use by CTSG-related
c               routines. Uses MET arrays.
c
c UPDATE:
c
c --- V5.5-V5.7     030402  (FRR): Add 2D met arrays (i2dmet)
c
c ARGUMENTS:
c    PASSED:    ihill   hill index number                           [i]
c               umet    wind field array of u-components (m/s)     [ra]
c               vmet    wind field array of v-components (m/s)     [ra]
c               tmet    temperature array (K)                      [ra]
c               zgpt    heights of data levels above surface (m)   [ra]
c               nears   array for met station nearest grid pt.     [ia]
c               tempss  temperatures at surface stations           [ra]
c               lcalgrd indicates temp profile available (T)        [l]
c               istab   stability class field                      [ia]
c               ptg     default pot. temp gradient (K/m) for the   [ra]
c                       two stable classes (E,F)
c               nx      number of grid-points in x-dir.             [i]
c               ny      number of grid-points in y-dir.             [i]
c               nz      number of grid-points in vertical           [i]
c               xorig   x-coordinate of the origin of met grid (m)  [r]
c               yorig   y-coordinate of the origin of met grid (m)  [r]
c               dgrid   spacing of grid-cells in met grid (m)       [r]
c               temp2d  temperatures at CALMET gridpoints          [ra]
c               i2dmet  2D CALMET surface arrays                    [i]
c                        0 = 2d sfc met NOT available
c                        1 = 2d sfc met available
c  RETURNED:    none
c
c CALLING ROUTINES:     COMP
c
c EXTERNAL ROUTINES:    NEARS
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

      real umet(mxnx,mxny,mxnz),vmet(mxnx,mxny,mxnz),
     1     tmet(mxnx,mxny,mxnz),zgpt(mxnz),tempss(mxss),ptg(2)
      integer istab(mxnx,mxny),nears(mxnx,mxny)
      logical lcalgrd
c frr(09/01)
      real temp2d(mxnx,mxny)

c  Obtain met data at the grid-point nearest the center of the hill.
c  Find the grid-point indices (ig,jg) of the cell in which the
c  center of the hill is located.  The minimum value of each index
c  should be 1, and the maximum value should be either nx or ny.
      xhill=xc(ihill)-xorig
      yhill=yc(ihill)-yorig
      ig=xhill/dgrid+1.0
      ig=MAX0(1,ig)
      ig=MIN0(nx,ig)
      jg=yhill/dgrid+1.0
      jg=MAX0(1,jg)
      jg=MIN0(ny,jg)


c  BVF default is determined from stability class and near-surface T
      if(istab(ig,jg) .LE. 4) then
         ptgrad=0.0
      elseif(istab(ig,jg) .EQ. 5) then
         ptgrad=ptg(1)
      else
         ptgrad=ptg(2)
      endif
c frr (09/01) new calmet format (2D temp)
      if(i2dmet.EQ.1) then
         temp=temp2d(ig,jg)
      elseif(i2dmet.EQ.0) then
c        Temperature at surface met station nearest hill
         issta=nears(ig,jg)
         temp=tempss(issta)
      else
         write(*,*)'Subr. GETPRFM:  Invalid I2DMET = ',i2dmet
         stop
      endif

      dfault=SQRT(9.80665*ptgrad/temp)

c  Assign variables to common.  Note that the B-V frequency is set
c  to zero if the temperature structure in a layer is not stably
c  stratified.
      nlev=nz
      do nl=1,nlev
         z(nl)=zgpt(nl)
c  Special case of nz=1:  met data may be from ISC-type input, so use
c  the wind speed as measured, not as scaled to zgpt.  The measured
c  speed was saved as "level 2".
         nlws=nl
         if(nz.EQ.1) nlws=nlws+1
         ws(nl)=SQRT(umet(ig,jg,nlws)**2+vmet(ig,jg,nlws)**2)
         if(LCALGRD) then
            abvf(nl)=0.
            if(nl .GT. 1) then
               sbvf=(9.80665/tmet(ig,jg,nl-1))
     1              *((tmet(ig,jg,nl)-tmet(ig,jg,nl-1))
     2              /(zgpt(nl)-zgpt(nl-1))+.0098)
               if(sbvf .GT. 0.) abvf(nl)=SQRT(sbvf)
            endif
         else
            abvf(nl)=dfault
         endif
      enddo

c  Set the B-V freq of the lowest layer equal to that in the adjacent
c  layer just above it (LCALGRD only)
      if(LCALGRD) abvf(1)=abvf(2)

      return
      end
c-----------------------------------------------------------------------
      subroutine getprfp(ssprf,tprf,zprf,nears,tempss,lcalgrd,
     &                   istab,dpbl,el,z0m,ptg,nzprf)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602                 GETPRFP
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Passes vertical profiles of wind speed and the Brunt-
c               Vaisala Frequency into common for use by CTSG-related
c               routines. Uses PROFILE.DAT arrays. (METFM=4)
c
c --- UPDATE
c --- V5.0-V5.4     000602  (DGS): add message to "stop"
c --- V4.0-V5.0     971107  (DGS): check PROBLEM returned by XTPRF
c
c ARGUMENTS:
c    PASSED:   ssprf    scalar wind speed profile (m/s)            [ra]
c               tprf    temperature profile (K)                    [ra]
c               zprf    heights of data levels above surface (m)   [ra]
c               nears   array for met station nearest grid pt.     [ia]
c               tempss  temperatures at surface stations           [ra]
c               lcalgrd indicates temp profile available (T)        [l]
c               istab   stability class                            [ia]
c               dpbl    Boundary layer depth (m)                    [r]
c               el      Monin-Obukhov length (m)                    [r]
c               z0m     surface roughness length (m)                [r]
c               ptg     default pot. temp gradient (K/m) for the   [ra]
c                       two stable classes (E,F)
c               nzprf   number of profile levels in vertical        [i]
c  RETURNED:    none
c
c CALLING ROUTINES:     COMP
c
c EXTERNAL ROUTINES:    NEARS
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

      real ssprf(mxprfz),tprf(mxprfz),zprf(mxprfz),t(mxprfz),
     1     tempss(mxss),ptg(2)
      integer nears(mxnx,mxny)
      logical lcalgrd,problem

c  Obtain met data at the grid-point nearest the center of the hill.
c  Because METFM=4 provides data at one location, draw fields from (1,1)
      ig=1
      jg=1

c  Surface met station nearest hill
      issta=nears(ig,jg)

c  BVF default is determined from stability class and near-surface T
      if(istab .LE. 4) then
         ptgrad=0.0
      elseif(istab .EQ. 5) then
         ptgrad=ptg(1)
      else
         ptgrad=ptg(2)
      endif
      dfault=SQRT(9.80665*ptgrad/tempss(issta))

c  Assign variables to common.  Note that the B-V frequency is set
c  to zero if the temperature structure in a layer is not stably
c  stratified.
      problem=.FALSE.
      nlev=nzprf
      do nl=1,nlev
         z(nl)=zprf(nl)
         call XTPRF(nzprf,ssprf,zprf,z(nl),'spd',z0m,el,
     &              dpbl,istab,ptg,ws(nl),problem)
         call XTPRF(nzprf,tprf,zprf,z(nl),'tmp',z0m,el,
     &              dpbl,istab,ptg,t(nl),problem)
         if(LCALGRD) then
            abvf(nl)=0.
            if(nl .GT. 1) then
               sbvf=(9.80665/t(nl-1))*((t(nl)-t(nl-1))
     &              /(zprf(nl)-zprf(nl-1))+.0098)
               if(sbvf .GT. 0.) abvf(nl)=SQRT(sbvf)
            endif
         else
            abvf(nl)=dfault
         endif
      enddo

c --- Results are invalid if XTPRF reported PROBLEM=TRUE
      if(PROBLEM) then
         write(io6,*) 'GETPRFP:  FATAL ERROR reported when ',
     &                'extracting temp from PROFILE ---'
         write(io6,*) 'There are no valid data'
         write(*,*)
         stop 'Halted in GETPRFP -- see list file.'
      endif

c  Set the B-V freq of the lowest layer equal to that in the adjacent
c  layer just above it (LCALGRD only)
      if(LCALGRD) abvf(1)=abvf(2)

      return
      end
c-----------------------------------------------------------------------
      subroutine hdun(ihill)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602                    HDUN
c ---            D. Strimaitis, SRC
c
c --- UPDATES
c --- V5.2-V5.4    000602  (DGS): add message to "stop"
c --- V5.1-V5.2    991104  (JSS): Error messages written to list
c                                 file as well as to screen
c
c PURPOSE:      Compute dividing-streamline height (Hd) and U/N above Hd.
c               Note that Hd is height above the grid-plane (m).
c
c ARGUMENTS:
c    PASSED:    ihill           hill ID number                       [i]
c  RETURNED:    none
c
c CALLING ROUTINES:     (main)
c
c EXTERNAL ROUTINES:    none
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'
      real lhs(mxlev),rhs(mxlev)

c  Identify height of hill above the grid-plane elevation
      h=relief(ihill)

c  Treat case of a single layer first (Hd = H - U/N)
      if(nlev .EQ. 1) then
         if(abvf(1) .EQ. zero) then
            hda(ihill)=zero
            ubyna(ihill)=999.
            return
         else
            ubyna(ihill)=ws(1)/abvf(1)
            hda(ihill)=AMAX1(zero,h-ubyna(ihill))
            return
         endif
      endif

c  Initialize working arrays
      do nl=1,nlev
         lhs(nl)=0.0
         rhs(nl)=0.0
      enddo

c  Find the first level whose elevation exceeds the top of the hill
      do nl=nlev,1,-1
         if(z(nl) .GT. h) ilev=nl
      enddo

c  Set up array of left-hand-side values of eqn. for hd
c  and check for neutral/unstable lapse rates throughout profile,
c  or "zero" wind speeds
      bvfsum=zero
      sumlhs=0.0
      do nl=1,ilev-1
         lhs(nl)=half*ws(nl)*ws(nl)
         sumlhs=sumlhs+lhs(nl)
         bvfsum=bvfsum+abvf(nl+1)
      enddo
      sumlhs=sumlhs+lhs(ilev)
      if(bvfsum .LE. zero) then
         hda(ihill)=zero
         ubyna(ihill)=999.
         return
      elseif(sumlhs.LE.0.0) then
         hda(ihill)=h
         ubyna(ihill)=zero
         return
      endif

c  Set up array of right-hand-side values of eqn. for hd
      zm=half*(z(ilev-1)+h)
      rhs(ilev-1)=abvf(ilev)*abvf(ilev)*((h-zm)*
     &            (h-z(ilev-1)))

      do nl=ilev-2,1,-1
         zm=half*(z(nl+1)+z(nl))
         rhs(nl)=rhs(nl+1)+
     &           abvf(nl+1)*abvf(nl+1)*((h-zm)*(z(nl+1)-z(nl)))
      enddo

c  Identify top of layer that contains hd
      it=ilev
      do nl=ilev-1,1,-1
         if(lhs(nl) .GE. rhs(nl)) it=nl
      enddo

c  Compute hd
      ib=it-1
      if(ib.EQ.0) then
         b=ws(it)/z(it)
         a=zero
      else
         b=(ws(it)-ws(ib))/(z(it)-z(ib))
         a=ws(it)-b*z(it)
      endif
      b2=b*b
      bvf2=abvf(it)*abvf(it)

c  Top of the layer containing Hd is the lesser of z(it) and H
      TOP=AMIN1(h,z(it))
      qa=b2-bvf2
      qb=two*(a*b+bvf2*h)
      qc=a*a-two*rhs(it)-bvf2*TOP*(two*h-TOP)

      qb2=qb*qb
      qac4=4.*qa*qc
      if(qac4 .LE. qb2) then
         deter=SQRT(qb2-qac4)
         hda(ihill)=(-qb+deter)/(two*qa)
         hda(ihill)=AMAX1(one,hda(ihill))
      else
         write(io6,*)'HDUN: Fatal Problem - IMAGINARY SOLUTION'
         write(io6,*)'Hill Ht                    = ',h
         write(io6,*)'Top of layer containing Hd = ',top
         write(io6,*)'b^2, 4ac                   = ',qb2,qac4
         write(io6,*)'Profile of Speed and B-V Freq.'
         do i=1,nlev
            write(io6,*)'z, ws, |BVF| = ',z(i),ws(i),abvf(i)
            write(io6,*)'z, LHS, RHS  = ',z(i),lhs(i),rhs(i)
         enddo
         write(*,*)
         stop 'Halted in HDUN -- see list file.'
      endif

c  Compute weighted speed and Brunt-Vaisala freq above top of layer
      ubar=zero
      bvfbar=zero
      do nl=it+1,ilev
         wt=z(nl)-z(nl-1)
         ubar=ubar+half*(ws(nl)+ws(nl-1))*wt
         bvfbar=bvfbar+abvf(nl)*wt
      enddo

c  Add contribution from layer between hd and z(it)
      wt=z(it)-hda(ihill)
      ubar=ubar+half*(ws(it)+a+b*hda(ihill))*wt
      bvfbar=bvfbar+abvf(it)*wt

c  Compute U/N
      ubyna(ihill)=ubar/bvfbar

      return
      end
c-----------------------------------------------------------------------
      real function hilhgt(x,y)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                  HILHGT
c ---            R. Yamartino, SRC
c
C PURPOSE:      (adapted from CTDM)
C               COMPUTES THE FRACTIONAL HILL HEIGHT AT
C               THE POSITION (X,Y) FOR A ROTATED GAUSSIAN HILL.
C
C ARGUMENTS:
C    PASSED:    X,Y     LOCATION AT WHICH HEIGHT IS NEEDED  (M)      [r]
C
C CALLING ROUTINES: PATH
C
C EXTERNAL ROUTINES: NONE
C-----------------------------------------------------------------------

      INCLUDE 'flvar.puf'
C                                                                       HHT00260
C       DEFINE ARGUMENTS                                                HHT00270
      REAL      X, Y                                                    HHT00280
C                                                                       HHT00290
C       DEFINE LOCAL VARIABLES                                          HHT00300
      REAL      Q, XDLX, YDLY                                           HHT00310
C                                                                       HHT00320
      XDLX = X * LXI                                                    HHT00340
      YDLY = Y * LYI                                                    HHT00350
      Q = XDLX*XDLX + YDLY*YDLY + 2.0*GAM*X*Y                           HHT00360
C  NOTE THAT HILROT PROVIDES CROSSTERM GAM FOR A ROTATED HILL           HHT00370
      IF(Q .GT. 30.) Q = 30.                                            HHT00380
      HILHGT = EXP(-Q)                                                  HHT00390
C                                                                       HHT00400
      RETURN                                                            HHT00410
      END                                                               HHT00420
c-----------------------------------------------------------------------
      subroutine hilrot(ah,bh,psi)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                  HILROT
c ---            R. Yamartino, SRC
c
C PURPOSE:      (adapted from CTDM)
C     COMPUTES THE NEEDED LENGTH SCALES LX AND LY AND THE
C     FACTOR GAM FOR A GAUSSIAN HILL HAVING MAJOR AXIS AH, MINOR AXIS
C     BH, AND ROTATED CCW BY AN ANGLE PSI.
C     WHEN PSI=0 THE MINOR AXIS IS ORIENTED ALONG THE X-AXIS (OR FLOW
C     DIRECTION) AND THE MAJOR AXIS LIES ALONG THE Y-AXIS.
C
C ARGUMENTS:
C    PASSED:    AH,BH   MAJOR AND MINOR HILL SEMI-AXIS LENGTHS (M)   [r]
C               PSI     ANGLE OF ROTATION (RADIANS)                  [r]
C  RETURNED:    NONE
C
C CALLING ROUTINES: CTPAR
C
C EXTERNAL ROUTINES: NONE
C----------------------------------------------------------------------

      real lai2,lbi2
      INCLUDE 'flvar.puf'

C                                                                       HRT00370
      CPSI = COS(PSI)                                                   HRT00390
      CPSI2 = CPSI*CPSI                                                 HRT00400
      SPSI = SIN(PSI)                                                   HRT00410
      SPSI2 = SPSI*SPSI                                                 HRT00420
      LAI2 = 1.0 / (AH*AH)                                              HRT00430
      LBI2 = 1.0 / (BH*BH)                                              HRT00440
C                                                                       HRT00450
      GAM = (LBI2-LAI2)*CPSI*SPSI                                       HRT00460
      LXI2 = CPSI2*LBI2 + SPSI2*LAI2                                    HRT00470
      lxi=SQRT(lxi2)
      lx=1.0/lxi
      LYI2 = CPSI2*LAI2 + SPSI2*LBI2                                    HRT00490
      lyi=SQRT(lyi2)
      ly=1.0/lyi
      lyi3=lyi2*lyi
C                                                                       HRT00510
      RETURN                                                            HRT00520
      END                                                               HRT00530
C-----------------------------------------------------------------------
        subroutine inprec
C-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                  INPREC
c
c HISTORY: This subroutine is adapted from the CTDMPLUS model with
c          modifications to allow its use within CALPUFF.  Data needed
c          for CTSG are extracted from CTDM arrays.
c
C PURPOSE: THIS ROUTINE IS RESPONSIBLE FOR READING THE RECEPTOR DATA
C
C LIMITATIONS:
C       A MAXIMUM OF 'mxrect' RECEPTORS
C
C ARGUMENTS
c   PASSED:     none
c   Common block /PARAMS/ variables:
c               mxrect          maximum number of CTSG receptors     [r]
c   Common block /CTSGDAT/ variables:
c               xhill2m         convert user lengths to meters       [r]
c               zhill2m         convert user heights to meters       [r]
c               xctdmkm         x-origin(km) of CTDM in CALPUFF sys  [r]
c               yctdmkm         y-origin(km) of CTDM in CALPUFF sys  [r]
c               xmetct0m        x-origin(m) of CTDM from SW MET grid [r]
c               ymetct0m        y-origin(m) of CTDM from SW MET grid [r]
c
c   RETURNED:   none
c               (Data arrays are loaded into /CTPASS/ and /CTSGDAT/)
c   Common block /CTSGDAT/ variables:
c               ihill(mxrect)   Hill number associated with each    [ia]
c                               complex terrain receptor
c               elrect(mxrect)  Ground elevation (m MSL) of each    [ra]
c                               complex terrain receptor
c               nctrec          number of CTSG receptors             [i]
c   Common block /CTPASS/ variables:
c                xrctm(mxrect)  CTSG receptor coordinates in meters [ra]
c                yrctm(mxrect)  CTSG receptor coordinates in meters [ra]
c
C I/O:
C
C       LINE  VARIABLE  COLUMNS FORMAT  DESCRIPTION
C
C         1      NAME      1-16   A16   RECEPTOR NAME
C                   X     21-30   F10.0 X-COORD (USER HORIZONTAL UNITS)
C                   Y     31-40   F10.0 Y-COORD (USER HORIZONTAL UNITS)
C                  zZ     41-50   F10.0 HT ABOVE GROUND (USER VERTICAL
C                                               UNITS)
C                  GE     51-60   F10.0 GROUND ELEVATION (USER VERTICAL
C                                               UNITS)
C                  NH     61-65     I5  HILL NUMBER FOR THIS RECEPTOR
C
C
C CALLING ROUTINES: CTINIT
C
C-----------------------------------------------------------------------
C
      include   'params.puf'
      include   'ctpass.puf'
      include   'ctsgdat.puf'
C
C       DEFINE LOCAL VARIABLES
        REAL    X, Y, zZ, GE
        INTEGER NH, NR, NO, YES, FLAT
        CHARACTER*16    NAME
        DATA    NO/0/, YES/1/, FLAT/0/
C
        NR = 0
        NRFLAT = NO
c ---   'Use' nrflat (compiler warning)
        nrflat=nrflat
c
c  Set local i/o unit variables
        inrec=io29
        iout=io6
c  Write initial header to the list-file
        write(iout,5020)
        WRITE(IOUT,6000)

C       LOOP ON RECEPTOR INPUT LINES, TERMINATE ON EOF
100     CONTINUE
            READ(INREC, 1010, END=900) NAME,X,Y,zZ,GE,NH

C           RECEPTORS ON FLAT TERRAIN FLAG
            IF(NH .EQ. FLAT) then
               NRFLAT = YES
            else
               NR = NR + 1
               IF(NR .GT. mxrect) GO TO 991
               WRITE(IOUT, 6020) NR,NAME,X,Y,zZ,GE,NH
c ---          Set receptor data in /CTSGDAT/
               elrect(NR)=ge*zhill2m
               ihill(NR) = NH
c ---          Compute receptor location as meters in MET grid
c ---          for /CTPASS/
               xrctm(NR)=X*xhill2m + xmetct0m
               yrctm(NR)=Y*xhill2m + ymetct0m
            endif

        GO TO 100
C       END RECEPTOR INPUT LOOP
900     nctrec = NR
C       FOOTNOTE
        WRITE(IOUT,6030) xhill2m,zhill2m
        write(iout,6040) xctdmkm,yctdmkm
        write(iout,*)'   NOTE:  All receptors are placed on the ground!'
        RETURN
C
C       ERROR SECTION
C
991     WRITE(IOUT,9910) nr,mxrect
        write(*,*)
        stop 'Halted in INPREC -- see list file.'
C       FORMAT SECTION
1010    FORMAT(A16,4X,4F10.0,I5)
c
5020  format(1x,//'INFORMATION PROVIDED IN CTDM RECEPTOR FILE'//)
c
6000    FORMAT(/,27X,'      RECEPTOR INFORMATION',//,
     &  ' REC   IDENTIFICATION    EAST      NORTH  HEIGHT  ABOVE   ',
     &  'GRD LVL',/,
     &  ' NO.                     COORD     COORD  LOCAL GRD LVL  ',
     &  'ELEVATION     HILL',/,
     &  '                           (USER UNITS)    (USER UNITS) ',
     &  '(USER UNITS)  NUMBER',/,
     &  ' ---  ----------------  -------- -------- -------------  ',
     &  '----------   ------')
6010    FORMAT(' ')
6020    FORMAT(I4,2X,A16,1X,F9.2,F9.2,5X,F7.1,5X,F7.1,7X,I2)
6030    FORMAT(' ---------------------------------------------',/,
     1  '   MULTIPLY HORIZONTAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     2          'TO METERS',/,
     3  '   MULTIPLY VERTICAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     4          'TO METERS')
6040    FORMAT(/,
     1  '   ADD  ',1PE10.3,' KILOMETERS to reference X-Coordinate ',
     2          'to CALPUFF coordinate system',/,
     3  '   ADD  ',1PE10.3,' KILOMETERS to reference Y-Coordinate ',
     4          'to CALPUFF coordinate system')
9910    FORMAT(//' ***** RECEPTOR INPUT ERROR *****'/' INVALID ',
     1  ' NUMBER OF RECEPTORS FOUND   : nr     =',I4,/'         ',
     2  ' NUMBER OF RECEPTORS ALLOWED : mxrect =',I4)
        END
C-----------------------------------------------------------------------
        subroutine inpter
C-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                  INPTER
c
c HISTORY: This subroutine is taken from the CTDMPLUS model with few
c          modifications to allow its use within CALPUFF.  Data needed
c          for CTSG are extracted from CTDM arrays.
c
C PURPOSE: THIS ROUTINE IS RESPONSIBLE FOR READING THE TERRAIN
C          INFORMATION FOR EACH HILL.
C
C ASSUMPTIONS: THIS FIRST CONTOUR HEIGHT IS LESS THAN OR EQUAL TO THE
C               LOWEST STACK BASE ELEVATION
C
C LIMITATIONS:
C       A MAXIMUM OF 'MXHILL' HILLS
C       A MAXIMUM OF 'MXCNTR HEIGHTS FOR HILL SHAPE INFORMATION
C
C ARGUMENTS:
c   PASSED:     none
c   Common block /CTSGDAT/ variables:
c               xhill2m         convert user lengths to meters       [r]
c               zhill2m         convert user heights to meters       [r]
c               xctdmkm         x-origin(km) of CTDM in CALPUFF sys  [r]
c               yctdmkm         y-origin(km) of CTDM in CALPUFF sys  [r]
c               xmetct0m        x-origin(m) of CTDM from SW MET grid [r]
c               ymetct0m        y-origin(m) of CTDM from SW MET grid [r]
c               nhill           number of hills stated in input file [i]
c
c   RETURNED:   none
c               (Data arrays are loaded into /CTPASS/ and /CTSGDAT/)
c
C
C I/O:
C  INPUT: UNIT=INTERR
C
C       THE FOLLOWING INDICATE THE GROUP OF INPUT LINES EXPECTED
C       FOR EACH HILL.
C
C       LINE  VARIABLE  COLUMNS FORMAT  DESCRIPTION
C         1      NH        6- 7   I2    HILL NUMBER
C                                         FOR THIS RECEPTOR GROUP
C                NZ        9-10   I2    NUMBER OF HEIGHTS FOR WHICH
C                                         CONTOUR AND CUTOFF HILL SHAPE
C                                         INFORMATION IS GIVEN
C                HTP      21-30  F10.0  HEIGHT OF TOP OF HILL
C                                         ABOVE GRID ZERO, USER UNITS
C                HILNAM   41-80   A40   DESCRIPTION FOR THIS HILL
C
C       NEXT NZH LINES, ONE FOR EACH BEST-FIT ELLIPSE
C
C                  ZH      1-10  F10.0  ELEVATION OF BEST-FIT ELLIPSE,
C                                       USER COORDINATES
C                 XHW     11-20  F10.0  X-COORD (USER HORIZONTAL UNITS)
C                                       OF ELLIPSE CENTER
C                 YHW     21-30  F10.0  Y-COORD (USER HORIZONTAL UNITS)
C                                       OF ELLIPSE CENTER
C              MAJORW     31-40  F10.0  ORIENTATION OF MAJOR AXIS OF
C                                       ELLIPSE (DEGREES CLOCKWISE FROM
C                                       NORTH)
C              MAJAXW     41-50  F10.0  LENGTH OF MAJOR SEMIAXIS, USER
C                                       COORDINATES
C              MINAXW     51-60  F10.0  LENGTH OF MINOR SEMIAXIS, USER
C                                       COORDINATES
C
C       NEXT NZH LINES, ONE FOR EACH CUT-OFF HILL
C
C                  ZH      1-10  F10.0  ELEVATION OF BASE OF CUT-OFF
C                                       HILL, USER COORDINATES
C                 XHL     11-20  F10.0  X-COORD (USER HORIZONTAL UNITS)
C                                       OF CENTER OF CUT-OFF HILL
C                 YHL     21-30  F10.0  Y-COORD (USER HORIZONTAL UNITS)
C                                       OF CENTER OF CUT-OFF HILL
C              MAJORL     31-40  F10.0  ORIENTATION OF MAJOR AXIS OF
C                                       CUT-OFF HILL (DEGREES CLOCKWISE
C                                       FROM NORTH)
C              EXPOMA     41-50  F10.0  EXPONENT IN INVERSE POLYNOMIAL
C                                       FUNCTION FOR CUT-OFF HILL SHAPE
C                                       FOR MAJOR AXIS CROSS SECTION
C              EXPOMI     51-60  F10.0  EXPONENT IN INVERSE POLYNOMIAL
C                                       FUNCTION FOR CUT-OFF HILL SHAPE
C                                       FOR MINOR AXIS CROSS SECTION
C              SCALMA     61-70  F10.0  SCALE LENGTH IN INVERSE
C                                       POLYNOMIAL FUNCTION FOR CUT-OFF
C                                       HILL SHAPE FOR MAJOR AXIS CROSS
C                                       SECTION
C              SCALMI     71-80  F10.0  SCALE LENGTH IN INVERSE
C                                       POLYNOMIAL FUNCTION FOR CUT-OFF
C                                       HILL SHAPE FOR MINOR AXIS CROSS
C                                       SECTION
C
C
C       THIS GROUP OF INPUT LINES SHOULD BE REPEATED FOR EACH HILL.
C
C
C CALLING ROUTINES:  CTINIT
C
C EXTERNAL ROUTINES: none
C
C-----------------------------------------------------------------------
C
      include   'params.puf'
      include   'ctpass.puf'
      include   'ctsgdat.puf'
C
C       DEFINE LOCAL VARIABLES
        REAL    EL, HTP, SMALL
        INTEGER NH, NZ, I
C
        INTEGER         NHILLS, HILNAM(10,MXHILL)

        REAL            THS(MXHILL),
     *                  XHW(MXCNTR,MXHILL), YHW(MXCNTR,MXHILL),
     *                  MAJORW(MXCNTR,MXHILL),
     *                  XHL(MXCNTR,MXHILL), YHL(MXCNTR,MXHILL),
     *                  MAJORL(MXCNTR,MXHILL),
     *                  EXPOMA(MXCNTR,MXHILL), EXPOMI(MXCNTR,MXHILL),
     *                  SCALMA(MXCNTR,MXHILL), SCALMI(MXCNTR,MXHILL)

c      (CTPASS contains the remaining CTDM variables ---
c                       NZH(MXHILL), ZH(MXCNTR,MXHILL),
c                       MAJAXW(MXCNTR,MXHILL), MINAXW(MXCNTR,MXHILL)  )

C
        DATA    SMALL/0.00001/
C
        NHILLS = 0
c
c  Set local i/o unit variables
      interr=io28
      iout=io6
c  Write initial header to the list-file
      write(iout,5020)
C

c --- Add test for number of hills greater than MXHILL
100   if(nhills.EQ.mxhill) then
c ---   This read should find an end-of-file (and transfer to 500)
        READ( INTERR, 1010, ERR=500, END=500) NH
c ---   Oops... too many hills in this file
        nhills=nhills+1
        write(iout,1100) nhills,mxhill
1100    format(//,10x,'NUMBER OF HILLS = ',i4,
     1      '; EXCEEDS MAXIMUM ALLOWABLE (MXHILL) = ',i4)
        write(*,*)
        stop 'Halted in INPTER -- see list file.'
      else

        READ( INTERR, 1010, ERR=9000, END=500) NH, NZ, HTP,
     $                          (HILNAM(I,NHILLS+1),I=1,10)
1010    FORMAT(5X,I2,1X,I2,10X,F10.0,10X,10A4)
        NHILLS = NHILLS + 1
C       CHECK FOR OUT OF SEQUENCE
        IF( NH .NE. NHILLS ) THEN
            WRITE( IOUT, 1110) NHILLS, NH
1110    FORMAT(//,10X,'HILL NUMBER OF OUT SEQUENCE--',I2,' WAS ',
     1  'EXPECTED; ',I2,' WAS READ')
            write(*,*)
            stop 'Halted in INPTER -- see list file.'
        ENDIF
C       CHECK FOR ARRAY OUT OF BOUNDS
        IF( NZ .GT. mxcntr ) THEN
            WRITE(IOUT,1120) NZ,mxcntr
1120    FORMAT(//,10X,'NUMBER OF CONTOURS/CUT-OFF HILLS = ',I4,
     1      '; EXCEEDS MAXIMUM ALLOWABLE (MXCNTR) = ',i4)
            write(*,*)
            stop 'Halted in INPTER -- see list file.'
        ENDIF
C
        WRITE( IOUT, 6020 ) NH, (HILNAM(I,NH),I=1,10), HTP
        WRITE( IOUT, 6030 ) (HILNAM(I,NH),I=1,10)
      endif
C
C       READ VARIABLES FOR WRAP: ELLIPSE INFORMATION
C
        DO 200 I = 1,NZ
            READ(INTERR,1040,ERR=9000) ZH(I,nh),XHW(I,NH),YHW(I,NH),
     *                          MAJORW(I,NH),MAJAXW(I,NH),MINAXW(I,NH)
1040        FORMAT(6F10.0)
            WRITE(IOUT,6040) ZH(I,nh),XHW(I,NH),YHW(I,NH),MAJORW(I,NH),
     *                          MAJAXW(I,NH),MINAXW(I,NH)
200     CONTINUE
C
C       READ VARIABLES FOR LIFT: CUT-OFF HILL INFORMATION
C
        WRITE(IOUT,6050) (HILNAM(I,NH),I=1,10)
        DO 300 I = 1,NZ
            READ(INTERR,1050,ERR=9000) EL,XHL(I,NH),YHL(I,NH),MAJORL(I,
     1          NH),EXPOMA(I,NH),EXPOMI(I,NH),SCALMA(I,NH),SCALMI(I,NH)
1050        FORMAT(8F10.0)
            IF(ABS(EL-ZH(I,nh)).GT.SMALL) THEN
                WRITE(IOUT,1140) I,EL,I,ZH(I,nh)
1140            FORMAT(//,10X,'CUT-OFF HILL BASE # ',I2,' = ',F7.2,
     *                  '; DOES NOT AGREE WITH THE CORRESPONDING ',
     *                  'CONTOUR # ',I2,' HEIGHT OF ',F7.2)
                write(*,*)
                stop 'Halted in INPTER -- see list file.'
            ENDIF
            WRITE(IOUT,6060) EL,XHL(I,NH),YHL(I,NH),MAJORL(I,NH),
     *                          EXPOMA(I,NH),EXPOMI(I,NH),
     *                          SCALMA(I,NH),SCALMI(I,NH)
300     CONTINUE
C
C       CONVERT TO METERS USING xhill2m AND zhill2m, and shift origin
c       to place hill in CALPUFF MET GRID system
C
        NZH(NH) = NZ
        THS(NH) = HTP * zhill2m
        DO 400 I = 1,NZ
            ZH(I,NH) = ZH(I,NH) * zhill2m
            XHW(I,NH) = XHW(I,NH) * xhill2m + xmetct0m
            YHW(I,NH) = YHW(I,NH) * xhill2m + ymetct0m
            XHL(I,NH) = XHL(I,NH) * xhill2m + xmetct0m
            YHL(I,NH) = YHL(I,NH) * xhill2m + ymetct0m
            MAJAXW(I,NH) = MAJAXW(I,NH) * xhill2m
            MINAXW(I,NH) = MINAXW(I,NH) * xhill2m
            SCALMA(I,NH) = SCALMA(I,NH) * xhill2m
            SCALMI(I,NH) = SCALMI(I,NH) * xhill2m
400     CONTINUE
C       READ NEXT HILL INFO
        GO TO 100
C       END OF TERRAIN INPUT
500     CONTINUE
        WRITE(IOUT,6100) xhill2m,zhill2m
        write(iout,6110) xctdmkm,yctdmkm
        WRITE (IOUT,6091)
C

c --- CTSG Section for "LIFT" description ---
c  Transfer hill information to common/CTPASS/.  Note that the hill
c  description parameters for the polynomial hill are those for the
c  entire hill.  The ellipse information selected later for the flow
c  below Hd will depend on the hourly value of the dividing streamline.
c  The array index for the contour at the base of the hill is found
c  by calling KLOSE with a third argument equal to zero.

c --- Set the number of hills (in /CTSGDAT/) to that found(nhills)
      nhill=nhills

      do i=1,nhill
         klow=KLOSE(zh(1,i),nzh(i),zero)
         if(klow .EQ. 0) klow=1
         xc(i)=xhl(klow,i)
         yc(i)=yhl(klow,i)
         thetah(i)=majorl(klow,i)
         expo(1,i)=expoma(klow,i)
         expo(2,i)=expomi(klow,i)
         scale(1,i)=scalma(klow,i)
         scale(2,i)=scalmi(klow,i)
         axmax(1,i)=1000.*scale(1,i)
         axmax(2,i)=1000.*scale(1,i)
c ---    Set zgrid equal to the base contour elevation
         zgrid(i)=zh(klow,i)
c ---    Change height reference from m (MSL) to m above hill base
         relief(i)=ths(i)-zgrid(i)
c
c ---    Swap selected data to arrays in Subgroup 6b from input file
         hilldat(3,i) = thetah(i)
         hilldat(4,i) = zgrid(i)
         hilldat(5,i) = relief(i)
         hilldat(6,i) = expo(1,i)
         hilldat(7,i) = expo(2,i)
         hilldat(8,i) = scale(1,i)
         hilldat(9,i) = scale(2,i)
         hilldat(10,i) = axmax(1,i)
         hilldat(11,i) = axmax(2,i)
c
      enddo
c  Note that axmax is set to a number that is large compared to the
c  scale of the major axis of the hill (scale(1,i)).  This makes the
c  specification of the inverse polynomial hill consistent between
c  the CTDM and the CTSG formulations.

        RETURN
C
C       TERMINAL ERROR
9000    WRITE(IOUT,9005)
9005    FORMAT(//,10X,'ERROR IN DATA READ IN HILL INPUT')
        GO TO 9999
9999    write(*,*)
        stop 'Halted in INPTER -- see list file.'
c
5020  format(1x,//'INFORMATION PROVIDED IN THE CTDM HILL FILE'//)
C
6020    FORMAT(/' HILL #',I2,'  ',10A4,'HILL TOP:',F7.1,
     *          ' (USER UNITS)')
6030    FORMAT(/' BEST FIT ELLIPSE INFORMATION FOR WRAP: ',10A4,/
     *  '  CONTOUR  X-COORD   Y-COORD   MAJOR  AXIS   ELLIPSE AXIS ',
     *  'LENGTHS',/,
     *  '   HEIGHT    (HILL CENTER)     AZIM. FROM N    MAJOR      ',
     *  'MINOR',/,
     *  '  -------  --------  --------  ------------  --------   ',
     *  '--------')
6040    FORMAT(F9.1,2F10.3,F11.1,2X,2F11.3)
6050    FORMAT(/' Hc CUT-OFF HILL INFORMATION FOR LIFT:  ',10A4,/,
     *  '  CONTOUR  X-COORD  Y-COORD  MAJOR  AXIS  <--- INVERSE ',
     *  'POLYNOMIAL VARIABLES --->',/,
     *  '   HEIGHT    (HILL CENTER)  AZIM. FROM N  MAJ EXP MIN EXP   ',
     *  'MAJ SCALE  MIN SCALE',/,
     *  '  -------  -------- ------- ------------  ------- -------   ',
     *  '---------  ---------')
6060    FORMAT(F9.1,F10.3,F9.3,F10.1,F11.3,F8.3,F12.3,F11.3)
6091    FORMAT(/)
6100    FORMAT(' ---------------------------------------------',/,
     1  '   MULTIPLY HORIZONTAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     2          'TO METERS',/,
     3  '   MULTIPLY VERTICAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     4          'TO METERS')
6110    FORMAT(/,
     1  '   ADD  ',1PE10.3,' KILOMETERS to reference X-Coordinate ',
     2          'to CALPUFF coordinate system',/,
     3  '   ADD  ',1PE10.3,' KILOMETERS to reference Y-Coordinate ',
     4          'to CALPUFF coordinate system')
        END
c-----------------------------------------------------------------------
      integer function ireg(x,x12,x23)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                    IREG
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Determines position of a point relative to boundaries
c               of the CTSG modeling regions.
c
c ARGUMENTS:
c    PASSED:    x       position (coordinate normal to regions)      [r]
c               x12     boundary upwind of hill                      [r]
c               x23     boundary downwind of hill                    [r]
c  RETURNED:    ireg    region (1, 2, or 3)                          [i]
c
c CALLING ROUTINES:     CTREC, CTPAR
c
c EXTERNAL ROUTINES:    none
c-----------------------------------------------------------------------

      ireg=2
      if(x .LT. x12) then
         ireg=1
      elseif(x .GT. x23) then
         ireg=3
      endif
      return
      end
c-----------------------------------------------------------------------
      integer function klose(XA,NA,X)
C-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 940831                   KLOSE
c ---            Adopted from CTDMPLUS without modification
c
C PURPOSE: THIS FUNCTION RETURNS THE POSITION OF THE DATA VALUE IN ARRAY
C               XA WHICH IS NEAREST TO THE VALUE X BUT LESS THAN X
C
C ASSUMPTIONS:
C       ARRAY XA IS SORTED IN ASCENDING ORDER
C
C LIMITATIONS:  IF XA ARE ALL > X, SET KLOSE = 0
C
C ARGUMENTS
C  PASSED:
C       XA      REAL    ARRAY OF VALUES TO BE SEARCHED
C       NA      INT     DIMENSION OF XA
C       X       REAL    VALUE TO BE SEARCHED FOR
C  RETURNED FUNCTION VALUE:
C       KLOSE   INT     ARRAY SUBSCRIPT OF NEAREST VALUE TO X
C
C I/O: NONE
C
C CALLING ROUTINES: INPTER, CTPAR
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: ABS
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
C       DEFINE ARGUMENTS
        INTEGER NA
        REAL    XA(NA), X
C
C       IF NO XA VALUES ARE LESS THAN X, SET KLOSE = 0
C
        IF( XA(1) .GT. X ) THEN
                KLOSE = 0
        ELSE IF( XA(1) .EQ. X ) THEN
                KLOSE = 1
        ELSE
                DO  10  KLOSE = NA, 1, -1
                        IF( XA(KLOSE) .LT. X ) RETURN
10              CONTINUE
        ENDIF
        RETURN
        END
c-----------------------------------------------------------------------
      subroutine lower(c)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                   LOWER
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes concentrations due to puff material in lower
c               segment of the flow (below Hd).
c
c ARGUMENTS:
c    PASSED:    none
c  RETURNED:    c               concentration  (g/m**3)              [r]
c
c CALLING ROUTINES:     CTSG
c
c EXTERNAL ROUTINES:    MUNU, SIGMA, ERF
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

c  Initialize concentration that is returned
      c=zero

c  Determine if puff travels along the same or opposite side of the hill
c       from the receptor
      call MUNU(1,xre*baxi,yre*baxi,r,rmu,rnu)
      side=SIGN(one,SIN(rnu+alfw))

c  Compute the age of puff at the receptor (tup)
      tup=timpg+t12rl

c  If the age of the puff at the receptor is not positive, concentration
c  is zero!
      if(tup .LE. 0.) return

c  Set receptor-specific sigmas; note that these sigmas are constrained
c  by the puff-sigmas at the start and end of the step
c  Receptor may be shifted below Hd, so compute estimate here
c     sz=szr
c     sy=syr
c old sz=SIGMA(tup,sz1,tstart,sz2,tstep,szr,frac)
      sz=SIGMA(2,zpuff,u,tup,sz1,tstart,sz2,tstep,szr,frac)
      sz=AMAX1(sz1,sz)
      sz=AMIN1(sz2,sz)
c old sy=SIGMA(tup,sy1,tstart,sy2,tstep,syr,frac)
      sy=SIGMA(1,zpuff,u,tup,sy1,tstart,sy2,tstep,syr,frac)
      sy=AMAX1(sy1,sy)
      sy=AMIN1(sy2,sy)
      szsq=sz*sz
      sysq=sy*sy
c  Assign sigmas at the impingement point
      szo=szimpg
      szosq=szo*szo
      syo=syimpg
      syosq=syo*syo
c  Compute sigma-prime squared (both y and z)
      szpsq=szsq-szosq
      sypsq=sysq-syosq
c  Reset impingement sigmas if they exceed receptor-specific values --
c  this turns off hill-effects as the puff has not yet reached the hill
      if(szpsq.LE.zero) then
         szo=sz
         szosq=szsq
         szpsq=zero
         szp=zero
      else
         szp=SQRT(szpsq)
      endif
      if(sypsq.LE.zero) then
         syo=sy
         syosq=sysq
         sypsq=zero
         syp=zero
      else
         syp=SQRT(sypsq)
      endif

c  Puff is mixed in the vertical if sigmaz upwind of the hill (szo)
c  exceeds 1.6 times the mixing height (zmix).  Set mixing flag to 1.
      imix=0
      if(szo .GE. 1.6*zlid) imix=1

c  Compute the concentration on the trajectory ("centerline")
      t1mtr=-(t12p+t12rl)
      t2mtr=tstep+t1mtr
      dum=u/(rt2*sy)
      co=q*(ERF(t2mtr*dum)-ERF(t1mtr*dum))/(tstep*four*pi*u*sy*sz)
      if(co.LE.zero) return

c  Compute the horizontal distribution factor
      argy1=half*(d*d/sysq)
      if(argy1 .LT. expmax) then
         argy2=(d*syp)/(rt2*syo*sy)
         fy=EXP(-argy1)*(one+side*ERF(argy2))

c  Compute the vertical distribution factor
c  - If puff is mixed in the vertical, set fz to rt2pi*sz/zlid and
c    calculate concentration.
         if(imix .EQ. 1) then
            fz=rt2pi*sz/zlid
            c=co*fy*fz
            return
         endif
         twofz=zero
         if(szp .GT. small) then
            ak=one/(rt2*sz*szo*szp)
            b1=hd*szsq
c  - First term (no reflections from mixing lid); i=1, j=1:
            ejp=zrec
            eoip=zpuff
            call BJIL(ak,b1,ejp,eoip,bj)
            twofz=bj
c  - Skip reflections when contribution without reflections is zero
            if(twofz .EQ. zero) goto 501
c  - Reflections just from lid upwind of hill; j=1, i>1:
            ejp=zrec
            do 100, i=2,mxrefl
               eoip=two*(i-1)*zlid+zpuff
               eoim=eoip-two*zpuff
               call BJIL(ak,b1,ejp,eoip,bjp)
               call BJIL(ak,b1,ejp,eoim,bjm)
               add=bjp+bjm
               twofz=twofz+add
               if(add/twofz .LT. epsrefl) goto 101
100         continue
c  - Reflections just from lid over and downwind of hill; i=1, j>1:
101         eoip=zpuff
            do 200, j=2,mxrefl
               ejp=two*(j-1)*zlid+zrec
               ejm=ejp-two*zrec
               call BJIL(ak,b1,ejp,eoip,bjp)
               call BJIL(ak,b1,ejm,eoip,bjm)
               add=bjp+bjm
               twofz=twofz+add
               if(add/twofz .LT. epsrefl) goto 201
200         continue
c  - Reflections throughout; i>1, j>1:
c  - Loop on i>1:
201         do 400 i=2,mxrefl
               eoip=two*(i-1)*zlid+zpuff
               eoim=eoip-two*zpuff
c  - Loop on j>1:
               do 300 j=1,mxrefl
                  ejp=two*(j-1)*zlid+zrec
                  ejm=ejp-two*zrec
                  call BJIL(ak,b1,ejp,eoip,bjpp)
                  call BJIL(ak,b1,ejm,eoip,bjmp)
                  call BJIL(ak,b1,ejp,eoim,bjpm)
                  call BJIL(ak,b1,ejm,eoim,bjmm)
                  add=bjpp+bjmp+bjpm+bjmm
                  twofz=twofz+add
                  if(add/twofz .LT. epsrefl) then
                     if(j .GT. 1) goto 400
                     goto 501
                  endif
300            continue
400         continue
         else
c  - Sigma-z is not growing, szp is very small and equations simplify
c  - Only j=1 terms contribute (no reflection from lid over hill)
c  - 2Fz is zero for all receptors above Hd
            if(zrec .LE. hd) then
               ak=half/szsq
               ejp=zrec
               eoip=zpuff
               eoipmj=eoip-ejp
               eoippj=eoip+ejp
               call BI(ak,eoipmj,eoippj,twofz)
               if(twofz.EQ.zero) goto 501
c  - Reflections from lid upwind of hill; i>1:
               do 500 i=2,mxrefl
                  eoip=two*(i-1)*zlid+zpuff
                  eoim=eoip-two*zpuff
                  eoipmj=eoip-ejp
                  eoippj=eoip+ejp
                  eoimmj=eoim-ejp
                  eoimpj=eoim+ejp
                  call BI(ak,eoipmj,eoippj,bip)
                  call BI(ak,eoimmj,eoimpj,bim)
                  add=bip+bim
                  twofz=twofz+add
                  if(add/twofz .LE. epsrefl) goto 501
500            continue
            endif
         endif

501      fz=half*twofz

c  Compute concentration
         c=co*fy*fz
      endif
c
      if(ldb) then
         write(idebug,*)
         write(idebug,*)'LOWER: co,fy,fz =',co,fy,fz
         write(idebug,*)'(START) syo,szo =',syimpg,szimpg
         write(idebug,*)'(USED)  syo,szo =',syo,szo
         write(idebug,*)'(START) syr,szr =',syr,szr
         write(idebug,*)'(USED)  syr,szr =',sy,sz
         write(idebug,*)'       co,fy,fz =',co,fy,fz
         write(idebug,*)'t12p,t12rl,tstep=',t12p,t12rl,tstep
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine munu(muflag,xbi,ybi,r,mu,nu)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 910620                   MUNU
c ---            D. Strimaitis, SRC
c
c  PURPOSE:     Computes the elliptical coordinates of a point that is
c               referenced to the system centered on the ellipse, with
c               x-axis along the major axis.
c
c  ARGUMENTS:
c     PASSED:   muflag          flag signalling no mu calculation    [i]
c                               (1: do not calculate mu)
c               (xbi,ybi)       scaled coord (x/bax,y/bax)           [r]
c               r               ratio of axes aax/bax                [r]
c   RETURNED:   (mu,nu)         elliptical coordinates               [r]
c
c  CALLING ROUTINES:    CTPAR, LOWER
c
c  EXTERNAL ROUTINES:   none
c----------------------------------------------------------------------

      INCLUDE 'const.puf'
      real mu,nu
c
      absx=ABS(xbi)
      absy=ABS(ybi)
      xsq=xbi*xbi
      ysq=ybi*ybi

c  If point lies very near an axis, place it on the axis
      if(absx .LT. small) then
         xbi=zero
         absx=zero
      endif
      if(absy .LT. small) then
         ybi=zero
         absy=zero
      endif

c  If axes are nearly equal, treat hill as a symmetric hill
      rsq=r*r
      rp1=r+one
      rsqm1=rsq-one
      if(rsqm1 .LT. small) then
         rsqm1=zero
         rp1=two
      endif

      rdsq=xsq+ysq
c     rd=SQRT(rdsq)

c  ---- Compute nu -----------

c  Special cases
      if(xbi .EQ. zero) then
         nu=piby2
         if(ybi .LT. zero) nu=three*piby2
      elseif(ybi .EQ. zero) then
         nu=zero
         if(xbi .LT. zero) nu=pi
      elseif(rsqm1 .EQ. zero) then
         nu=ATAN2(ybi,xbi)
      else
c  General case
         capb=rdsq/rsqm1-one
         ac=-ybi*ybi/rsqm1
         twoa=two
         snusq=(-capb+SQRT(capb*capb-four*ac))/twoa
         if(snusq .LT. small) then
            nu=zero
         else
            arg=SQRT(snusq)
            if((one-arg) .LT. zero) arg=one
            nu=ASIN(arg)
            if(xbi .LT. zero) nu=pi-nu
            if(ybi .LT. zero) nu=-nu
         endif
      endif
      cosnu=COS(nu)
      sinnu=SIN(nu)

      if(muflag .NE. 1) then

c  ---- Compute mu -----------

c  Special cases
         if(ybi .EQ. zero .AND. xbi .EQ. zero) then
            mu=zero
         elseif(abs(sinnu) .LE. small) then
            mu=ALOG((absx+SQRT(xsq-rsqm1))/rp1)
         elseif(abs(cosnu) .LE. small) then
            mu=ALOG((absy+SQRT(ysq+rsqm1))/rp1)
         else
c  General case
            mu=ALOG((xbi/cosnu+ybi/sinnu)/rp1)
         endif
      else
         mu=0.
      endif

      return
      end
C-----------------------------------------------------------------------
      subroutine path(th,tl,tu,x,yi,zi,delx,y3,z3)
C-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                    PATH
c ---            D. Strimaitis, SRC
c
C PURPOSE:     (adapted from CTDM)
C     COMPUTES THE POSITION OF THE STREAMLINE THAT PASSES THROUGH THE
C     POINT AT (-INFINITY,YI,ZI) FOR ANY X ASSUMING A GAUSSIAN HILL
C     FUNCTION H(a,b)=HH*EXP(-(a/AH)**2-(b/BH)**2).  LOCAL DEFORMATION
C     FACTORS Th,Tl,Tu ARE COMPUTED AT (X,Y,Z).
C     NOTE THAT THE X-AXIS IS ALIGNED WITH THE INCIDENT FLOW.
C
C     MODIFICATION:  A root solver from the SLATEC package is called if
C                    the simple linear iteration is slow or fails
C
C ARGUMENTS:
C    PASSED:    X               DISTANCE ALONG FLOW AT WHICH         [r]
C                               STREAMLINE COORDINATES ARE FOUND (M)
C               YI,ZI           STREAMLINE COORD. FAR FROM HILL (M)  [r]
C               DELX            INCREMENT FOR STREAMLINE TRACE (M)   [r]
C  RETURNED:    TH,TL,TU        LOCAL DEFORMATION OR STRAIN FACTORS  [r]
C               Y3,Z3           STREAMLINE COORD. AT X (M)           [r]
C
C CALLING ROUTINES:     CTPAR
C
C EXTERNAL ROUTINES:    FLOPUFF, HILHGT
c                       PATH0, XSTF, SNSQE, R1MACH
C-----------------------------------------------------------------------
C
      INCLUDE 'const.puf'
      INCLUDE 'flvar.puf'

c --- Local common to pass current 'constants' from PATH to PATH0
      common /flvar2/ xx,yyi,zzi
c         xx:  along-flow coordinate where streamline is sampled
c        yyi:  lateral position of streamline far from hill
c        zzi:  vertical position of streamline far from hill

c --- Set up variables for root solver
      real yz(2),fvec(2),wa(20)
      real xgd(2),ygd(2),zgd(2)
      external PATH0
      data ijac/2/, ndim/2/, nprint/6/, lwa/20/
c     - ijac=2      compute Jacobian internally
c     - ndim=2      number of dimensions
c     - nprint=6
c     - lwa=20      dimension for work array  (wa)
c                   lwa=1+(3*ndim*ndim+13*ndim)/2
c --- Set TOL to the square root of the machine precision.
      tol=SQRT(R1MACH(4))
      xx=x
      yyi=yi
      zzi=zi

c --- Set up variables for linear solver
      DATA CRIT/0.005/                                                  PTH00380
      DSMALL=.01*HH                                                     PTH00390
      YSTEP=0.5*LY                                                      PTH00400
      ZSTEP=0.5*HH                                                      PTH00410
      NITER=0                                                           PTH00580
      mxiter=4

c --- Save values from last call
      zlast=z3
      ylast=y3

c --- Use original position and the values from last call to path for
c --- for the 2 initial guesses for the linear iteration
      y1=y3
      z1=z3
      y2=yi
      z2=zi
      if(y1 .EQ. y2) y2=dsmall+y2
      if(z1 .EQ. z2) z2=dsmall+z2
      if(z1.LT.zero) z1=zero
      if(z2.LT.zero) z2=zero

C *** COMPUTE THE STREAMLINE DEFLECTIONS FOR THE FIRST GUESSES          PTH00500
C       ETA IS THE VERTICAL DEFLECTION, DEL IS THE LATERAL DEFLECTION   PTH00510
C       H1 IS ELEVATION OF SURFACE BENEATH THE FIRST-GUESS POSITION     PTH00520
C       H2 IS ELEVATION OF SURFACE BENEATH THE SECOND-GUESS POSITION    PTH00530
      CALL FLOPUFF(X,Y1,Z1,ETA1,DEL1,THI,TLI,TU)                        PTH00540
      H1=HH*HILHGT(X,Y1)                                                PTH00550
      CALL FLOPUFF(X,Y2,Z2,ETA2,DEL2,THI,TLI,TU)                        PTH00560
      H2=HH*HILHGT(X,Y2)                                                PTH00570

c --- Compute the scaled errors
      er1=ABS((y1-del1-yi)/ly)+ABS((z1+h1-eta1-zi)/hh)
      er2=ABS((y2-del2-yi)/ly)+ABS((z2+h2-eta2-zi)/hh)

C                                                                       PTH00620
C *** ITERATE UNTIL THE STREAMLINE IS FOUND TO WITHIN CRIT * HH         PTH00630
C *** NEW GUESS                                                         PTH00640
C                                                                       PTH00650
c ---------------------------------------------------
c --- Section for call to linear solver
c ---------------------------------------------------
c --- Compute new estimate: y3,z3
10    DENY=Y1-Y2+DEL2-DEL1                                              PTH00660
      if(ABS(y2-y1) .LE. small .OR. ABS(deny) .LT. small) then
c ---    Go right to non-linear root solver
         goto 40
      ELSE                                                              PTH00690
         Y3=(Y1*(YI+DEL2)-Y2*(YI+DEL1))/DENY                            PTH00700
c *** RESTRICT RATE OF CHANGE OF POSITION ESTIMATE                      PTH00710
         STEP=Y3-Y2                                                     PTH00720
         IF(ABS(STEP) .GT. YSTEP) Y3=Y2+SIGN(YSTEP,STEP)                PTH00730
      ENDIF                                                             PTH00740
      DENZ=Z1+H1-ETA1+ETA2-Z2-H2                                        PTH00750
      if(ABS(z2-z1) .LE. small .OR. ABS(denz) .LT. small) then
c ---    Go right to non-linear root solver
         goto 40
      ELSE                                                              PTH00780
         Z3=(Z1*(ZI+ETA2-H2)-Z2*(ZI+ETA1-H1))/DENZ                      PTH00790
c --- Do not allow a streamline height below surface of hill
         z3=AMAX1(zero,z3)
C *** RESTRICT RATE OF CHANGE OF POSITION ESTIMATE                      PTH00800
         STEP=Z3-Z2                                                     PTH00810
         IF(ABS(STEP) .GT. ZSTEP) Z3=Z2+SIGN(ZSTEP,STEP)                PTH00820
      ENDIF                                                             PTH00830
      NITER=NITER+1                                                     PTH00840
C                                                                       PTH00880
C     COMPUTE QUANTITIES NOW FOR THE NEW GUESS.                         PTH00970
      CALL FLOPUFF(X,Y3,Z3,ETA3,DEL3,THI,TLI,TU)                        PTH00980
      H3=HH*HILHGT(X,Y3)                                                PTH00990
C *** COMPUTE THE ERROR IN THE SOLUTION SCALED BY HH                    PTH01000
      ERRY=ABS((Y3-DEL3-YI)/LY)                                         PTH01010
      ERRZ=ABS((Z3+H3-ETA3-ZI)/HH)                                      PTH01020
C                                                                       PTH01030
C *** QUIT IF ERROR CRITERIA SATISFIED.                                 PTH01040
      IF(ERRY .LT. CRIT .AND. ERRZ .LT. CRIT) GO TO 50                  PTH01050

c --- Update last estimate (keep previous best estimate in '1')
      if(er1.GT.er2) then
      Y1=Y2                                                             PTH01060
      Z1=Z2                                                             PTH01070
      H1=H2                                                             PTH01080
      ETA1=ETA2                                                         PTH01090
      DEL1=DEL2                                                         PTH01100
      endif

      Y2=Y3                                                             PTH01110
      Z2=Z3                                                             PTH01120
      H2=H3                                                             PTH01130
      ETA2=ETA3                                                         PTH01140
      DEL2=DEL3                                                         PTH01150
      er2=errz+erry

c --- Quit linear iteration approach if convergence is too slow
      if(niter.GT.mxiter) goto 40
      GO TO 10                                                          PTH01160
                                                                        PTH01170
40    continue
c ----------------------------------------------------
c --- Section for call to non-linear root solver SNSQE
c ----------------------------------------------------
c --- Set control variable to allow recovery from convergence errors
      call XSETF(0)
c --- Pass last value of (y,z) to solver as first guess; could use
c --- best result from linear solver, but this could pose problem
c --- since method failed
      yz(1)=ylast
      yz(2)=zlast
      call SNSQE(path0,jac,ijac,ndim,yz,fvec,tol,nprint,info,wa,lwa)

c --- Transfer solution to output variables, and call FLOPUFF again
c --- to obtain deflections and strain data
      y3=yz(1)
      z3=yz(2)
      call flopuff(x,y3,z3,eta3,del3,thi,tli,tu)
      h3=hh*hilhgt(x,y3)

c --- Interrogate INFO to see if this solution is valid
      if(info.EQ.2 .OR. info.EQ.4) then
c ---    PROBLEM!  Test against convergence criteria above
         yii=y3-del3
         zii=z3-eta3+h3
         erry=ABS((yii-yi)/ly)
         errz=ABS((zii-zi)/hh)
         if(erry.GT.crit .OR. errz.GT.crit) then
c ---       Recovery for failed procedure:
c ---       Search for 2 "good" points in the vicinity of x, and
c ---       interpolate y,z at x.
c ---       Shift x in increments of .1 DELX (10% of the increment
c ---       used to map streamline along the flow)
            delshft=0.1*delx
            ngood=0
c ---       First, get 1 point further downwind (search out to 3 DELX)
            do ishft=1,30
               shft=ishft*delshft
               xx=x+shft
               yz(1)=ylast
               yz(2)=zlast
               call SNSQE(path0,jac,ijac,ndim,yz,fvec,tol,nprint,
     &                    info,wa,lwa)
               if(info.EQ.1) then
                  ngood=ngood+1
                  xgd(ngood)=xx
                  ygd(ngood)=yz(1)
                  zgd(ngood)=yz(2)
                  if(ngood.EQ.1) goto 45
               endif
            enddo
c ---       Now, get needed points further upwind (up to 3 DELX)
45          do ishft=1,30
               shft=ishft*delshft
               xx=x-shft
               yz(1)=ylast
               yz(2)=zlast
               call SNSQE(path0,jac,ijac,ndim,yz,fvec,tol,nprint,
     &                    info,wa,lwa)
               if(info.EQ.1) then
                  ngood=ngood+1
                  xgd(ngood)=xx
                  ygd(ngood)=yz(1)
                  zgd(ngood)=yz(2)
                  if(ngood.EQ.2) goto 46
               endif
            enddo
c ---       Code should not reach this point!!
            write(*,*)
            stop 'PATH: convergence procedures failed'

c ---       Interpolate from nearest 2 points along streamline
46          xfac=(x-xgd(1))/(xgd(1)-xgd(2))
            y3=ygd(1)+(ygd(1)-ygd(2))*xfac
            z3=zgd(1)+(zgd(1)-zgd(2))*xfac
c ---       Call FLOPUFF again to obtain deflections and strain data
            call flopuff(x,y3,z3,eta3,del3,thi,tli,tu)
            h3=hh*hilhgt(x,y3)
         endif
      endif

   50 CONTINUE                                                          PTH01180
C                                                                       PTH01200
C *** COMPUTE T-FACTORS: IN MOST CASES, TL IS A RESIDUAL                PTH01210
C                                                                       PTH01220
      TH=1./THI                                                         PTH01230
      TL=THI/TU                                                         PTH01240
C                                                                       PTH01250
C     IF A LONG RIDGE, CONSIDER CALCULATED VALUE OF TL.  IF ASPECT RATIOPTH01260
C     IS 3 OR LESS, KEEP TL AS A RESIDUAL.  IF ASPECT RATIO EXCEEDS 3,  PTH01270
C     USE A COMBINATION OF RESIDUAL VALUE AND CALCULATED VALUE AS A     PTH01280
C     FUNCTION OF ASPECT RATIO                                          PTH01290
C                                                                       PTH01300
      ASPECT = LY/LX                                                    PTH01310
      IF(ASPECT.GT.3.0 .AND. ABS(1.0 - TLI) .LT. 0.1) THEN              PTH01320
          TLRES = TL                                                    PTH01330
          TLCALC = 1.0/TLI                                              PTH01340
          WEIGHT = ((ASPECT - 3.0)/ASPECT) ** 0.25                      PTH01350
          TL = TLCALC * WEIGHT + TLRES * (1.0 - WEIGHT)                 PTH01360
          TU = THI/TL                                                   PTH01370
      ENDIF                                                             PTH01380
      RETURN                                                            PTH01390
      END                                                               PTH01400
c-----------------------------------------------------------------------
      subroutine path0(n,yz,fvec,iflag)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 980430                   PATH0
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes difference between actual upstream location
c               of streamline in the y-z plane, and corresponding
c               position of approximated streamline.  When the right
c               estimate of (y,z) at a given x is chosen (this is the
c               vector yz), the difference between the location of the
c               actual streamline and the estimated streamline is zero.
c
c --- UPDATE
c --- V5.0-V5.0     980430  (DGS): assign iflag (compiler warning)
c
c ARGUMENTS:
c   PASSED:     n       number of elements in input vector (yz)      [i]
c               yz      (y,z) guess for streamline location at x    [ra]
c               iflag   control flag for SNSQ (not modified here)    [i]
c   RETURNED:   fvec    corresponding difference from actual        [ra]
c                       streamline location far upwind
c               iflag   control flag for SNSQ (not modified here)    [i]
c
c CALLING ROUTINES:     SNSQ
c
c EXTERNAL ROUTINES:    FLOPUFF, HILHGT
c-----------------------------------------------------------------------

      INCLUDE 'flvar.puf'

c --- Local common to pass current 'constants' from PATH to PATH0
      common /flvar2/ xx,yyi,zzi
c       xx:  along-flow coordinate at point where streamline is sampled
c      yyi:  lateral position of streamline far from hill
c      zzi:  vertical position of streamline far from hill

      real yz(n),fvec(n)

c --- Retain iflag value
      iflag=iflag

c --- Compute streamline deflections eta(vertical) and del(lateral) to
c --- bring streamline from (inf,yi',zi') to (x,yz(1),yz(2))
c --- Do not allow streamline height below hill surface
      if(yz(2).LT.0.0) yz(2)=0.0
      call flopuff(xx,yz(1),yz(2),eta,del,thi,tli,tu)

c --- Compute the inferred upwind location (yi',zi')
      h=hh*hilhgt(xx,yz(1))
      yip=yz(1)-del
      zip=yz(2)-eta+h

c --- Functions to be zeroed are differences yi-yi' and zi-zi'
      fvec(1)=yyi-yip
      fvec(2)=zzi-zip

      return
      end
c-----------------------------------------------------------------------
      subroutine puffc(imode,zpole,dpole,c)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                   PUFFC
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes concentrations for those receptors that are
c               modeled as a "receptor-on-a-pole" (including cases in
c               which terrain effects are negligible)
c
c ARGUMENTS:
c   PASSED:     imode   mode of operation; 0 = flat, 1 = pole calc,  [i]
c                       2 = pole calc plus stagnation streamline offset
c               zpole   height of "pole" (m)                         [r]
c               dpole   lateral offset from stagnation streamline (m)[r]
c   RETURNED:   c       concentration (g/m**3)                       [r]
c
c CALLING ROUTINES:     CTSG
c
c EXTERNAL ROUTINES:    ERF
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

c  Initialize concentration that is returned
      c=zero

c  Make sure that receptor height is consistent with mode selection
      if(imode .EQ. 0) zpole=0.0

c  Compute elapsed time from when the puff was emitted to when it
c  reaches the recepter (the age of the puff when centered at the
c  receptor ("tup")
      tup=timpg+t12rl

c  If the age of the puff at the recepter is not positive, concentration
c  is zero!
      if(tup .LE. 0.) return

c  Compute needed sigmas
      sz=szr
      sy=syr
      szsq=sz*sz
      sysq=sy*sy

c  Puff is mixed in the vertical if sigma-z exceeds 1.6 times the
c  mixing height (zlid).  Set mixing flag to 1.
      imix=0
      if(sz .GE. 1.6*zlid) imix=1

c  Compute the concentration on the trajectory ("centerline")
      t1mtr=-(t12p+t12rl)
      t2mtr=tstep+t1mtr
      dum=u/(rt2*sy)
c     co=q*(ERF(t2mtr*dum)-ERF(t1mtr*dum))/(tstep*four*pi*u*sy*sz)
      co=q*(ERFDIF((t2mtr*dum),(t1mtr*dum)))/(tstep*four*pi*u*sy*sz)
      if(co .EQ. 0.0) then
         c=0.0
         return
      endif

c  Compute the horizontal distribution factor
      dely=yrf-ypf
      if(imode .EQ. 2) dely=dpole
      delysq=dely*dely
      argy=half*(delysq/sysq)
      if(argy .LT. expmax) then
         fy=EXP(-argy)

c  Compute the vertical distribution factor
c  - If puff is mixed in the vertical, set fz equal to rt2pi*sz/zlid
c    and compute concentration.
         if(imix .EQ. 1) then
            fz=rt2pi*sz/zlid
            c=co*fy*fz
            return
         endif
c  - Section for no mixing lid
         zplus=zpuff+zpole
         zminus=zpuff-zpole
         dum=half/szsq
         argz1=dum*zminus**2
         argz2=dum*zplus**2
         term1=zero
         term2=zero
         if(argz1 .LT. expmax) term1=EXP(-argz1)
         if(argz2 .LT. expmax) term2=EXP(-argz2)
         fz=term1+term2
c  - Section for reflections from lid
         if(fz .GT. 0.) then
            do 10 i=1,mxrefl
               twoizl=two*i*zlid
               argz1=dum*(twoizl-zminus)**2
               argz2=dum*(twoizl-zplus)**2
               argz3=dum*(twoizl+zminus)**2
               argz4=dum*(twoizl+zplus)**2
               term1=zero
               term2=zero
               term3=zero
               term4=zero
               if(argz1 .LT. expmax) term1=EXP(-argz1)
               if(argz2 .LT. expmax) term2=EXP(-argz2)
               if(argz3 .LT. expmax) term3=EXP(-argz3)
               if(argz4 .LT. expmax) term4=EXP(-argz4)
               fzo=fz
               fz=fz+term1+term2+term3+term4
               test=(fz-fzo)/fz
               if(test .LT. epsrefl) goto 11
10          continue
         endif

c  Compute concentration
11       c=co*fy*fz
      endif

      return
      end
c-----------------------------------------------------------------------
      subroutine qatr(xl,xu,eps,ndim,fct,y,ier,aux)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                    QATR
c
c PURPOSE:      Integration routine adapted from the IBM SSP program
c               DQATR.  Modified for single precision.
c
c ARGUMENTS:
c    PASSED:    xl,xu   lower and upper limits of integration        [r]
c               eps     fractional error used to define convergence  [r]
c               ndim    dimension of array aux                       [i]
c               fct     external function (integrand)
c               aux     working array, passed to allow variable dim. [r]
c  RETURNED:    y       value of integral                            [r]
c               ier     status flag at termination                   [i]
c
c CALLING ROUTINES:     UPPER
c
c EXTERNAL ROUTINES:    none
c-----------------------------------------------------------------------

c  NOTES: status flags denote the following --
c               ier=0   value of integral converged to within eps
c               ier=1   value of integral is diverging
c               ier=2   value of integral did not converge to within
c                       eps before ndim limit was reached

      EXTERNAL fct
      dimension aux(1)
      integer*2 i,ii,ji,j,jj
      half=0.5

c  Preparations for Romberg loop
      aux(1)=half*(fct(xl)+fct(xu))
      h=xu-xl
      y=h*aux(1)
      if(ndim .LE. 1) then
         ier=2
         return
      elseif(h .EQ. 0.) then
         ier=0
         return
      endif

      hh=h
      delt2=0.
      p=1.
      jj=1

c  Initialize flag for integer*2 limit: jj cannot exceed 32,000
      lstop=0

      do 7 i=2,ndim
         y=aux(1)
         delt1=delt2
         hd=hh
         hh=half*hh
         p=half*p
         x=xl+hh
         sm=0.

c  Integer*2 limit: jj cannot exceed 32,000
         if(lstop .EQ. 1) then
            write(6,1010)
1010        format(2X,'ERROR FROM QATR - VARIABLE jj EXCEEDED 32,000')
            write(*,*)
            stop 'Halted in QATR -- see list file.'
         endif
         if(jj .GT. 16000) lstop=1

         do 3 j=1,jj
            sm=sm+fct(x)
            x=x+hd
3        continue
         aux(i)=half*aux(i-1)+p*sm

c  A new approximation to the integral is computed by means
c       of the trapezoidal rule

c  Start of Rombergs extrapolation method

         q=1.
         ji=i-1
         do 4 j=1,ji
            ii=i-j
            q=q+q
            q=q+q
            aux(ii)=aux(ii+1)+(aux(ii+1)-aux(ii))/(q-1.)
4        continue

c  End of Romberg step

         delt2=ABS(y-aux(1))
         if(i .GE. 5) then
c  Modification for cases in which function = 0 over interval
            if(y .EQ. 0.) then
               ier=0
               return
            elseif(delt2/y .LE. eps) then
               ier=0
               y=h*aux(1)
               return
            elseif(delt2 .GE. delt1)then
               ier=1
               y=h*y
               return
            endif
         endif
7     jj=jj+jj
      ier=2
      y=h*aux(1)

      return
      end
c-----------------------------------------------------------------------
      subroutine rotate(x,y,ang,xp,yp)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 901015                  ROTATE
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Rotate coordinate system through angle "ang"
c               to map point (x,y) into point (xp,yp).
c
c ARGUMENTS:
c    PASSED:    x,y     coordinates before rotation                  [r]
c               ang     rotation angle (radians)                     [r]
c  RETURNED:    xp,yp   coordinates after rotation                   [r]
c
c CALLING ROUTINES:     CTPAR, CTREC
c
c EXTERNAL ROUTINES:    none
c-----------------------------------------------------------------------

c  Note: ang is the angle measured CCW from the x-axis to the xp-axis

      s=SIN(ang)
      c=COS(ang)
      xp=x*c+y*s
      yp=-x*s+y*c

      return
      end
c-----------------------------------------------------------------------
      function sigma(itype,zpuff,ws,t,s1,tstart,s2,tstep,sr,frac)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 000602                   SIGMA
c ---            D. Strimaitis, SRC
c
c --- UPDATES
c --- V5.2-V5.4    000602  (DGS): add message to "stop"
c --- V5.1-V5.2    991104  (JSS): Error messages written to list
c                                 file as well as to screen
c
c PURPOSE:      Computes a value of sigma for a given travel-time,
c               using the CALPUFF sigma subroutines, starting from
c               the nearest of three known values.  The effect of
c               buoyancy-induced growth is treated as a virtual time,
c               as in CTDM.
c
c ARGUMENTS:
c    PASSED:    itype   1:sigma-y  2:sigma-z                         [i]
c               zpuff   puff height above ground (m)                 [r]
c               ws      puff advection speed (m/s)                   [r]
c               t       puff age (s)                                 [r]
c               s1      sigma at start of time-step (m)              [r]
c               tstart  puff age at start of time-step (s)           [r]
c               s2      sigma at end of time-step (m)                [r]
c               tstep   duration of time-step (s)                    [r]
c               sr      sigma at some intermediate point (m)         [r]
c               frac    fraction of tstep to intermediate point      [r]
c    Parameters: IO6
c  RETURNED:    sigma   sigma at time t (m)                          [r]
c
c CALLING ROUTINES:     UPPER, LOWER
c
c EXTERNAL ROUTINES:    SIGTY, SIGTZ
c-----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Declare arrays for sorted age(time) and sigmas
      real a(3),s(3)
      data zero/0.0/

c --- When sigma does not grow, just return the value at start of step
      if(s1 .EQ. s2) then
         sigma=s1
      else
c ---    Find age nearest time t
         a(1)=tstart+frac*tstep
         s(1)=sr
         a(2)=tstart
         s(2)=s1
         a(3)=tstart+tstep
         s(3)=s2
         index=1
         adelt=ABS(t-a(1))
         do i=2,3
            if(ABS(t-a(i)).LT.adelt) then
               index=i
               adelt=ABS(t-a(i))
            endif
         enddo
c
c ---    Set advection speed to km/s
         wskps=0.001*ws
c
c ---    Convert corresponding sigma to a virtual time, and then
c ---    compute the sigma at t via 'forward' call to sigma routine
         if(itype.EQ.1) then
c ---       Sigma-y
            call sigty(s(index),zero,zero,sy,vty,vdy)
            tsec=AMAX1(zero,vty+(t-a(index)))
            dkm=AMAX1(zero,vdy+(t-a(index))*wskps)
            if(tsec.GT.zero) then
               call sigty(zero,dkm,tsec,sigma,dum1,dum2)
            else
               sigma=zero
            endif
         elseif(itype.EQ.2) then
c ---       Sigma-z
            call sigtz(s(index),zero,zero,zpuff,sz,vtz,vdz)
            tsec=AMAX1(zero,vtz+(t-a(index)))
            dkm=AMAX1(zero,vdz+(t-a(index))*wskps)
            if(tsec.GT.zero) then
               call sigtz(zero,vdz,vtz,zpuff,sigma,dum1,dum2)
            else
               sigma=zero
            endif
         else
            write(io6,*) 'SIGMA:  itype not valid --  ',itype
            write(*,*)
            stop 'Halted in SIGMA -- see list file.'
         endif

      endif

      return
      end
c-----------------------------------------------------------------------
      subroutine slg2puf(x1,x2,y1,y2,sy1,sy2,npuff,qfac,xfac)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                 SLG2PUF
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Subroutine determines the number of puffs required to
c               simulate GLC's due to a slug (prepares for CTSG call).
c               Assumes that separation between puffs is fixed, and is
c               set by a mean sigma-y along the slug.
c
c ARGUMENTS:
c   PASSED:     x1,x2           x-coord. of old(1) and new(2) ends   [r]
c                               of slug
c               y1,y2           y-coord. of old(1) and new(2) ends   [r]
c                               of slug
c               sy1,sy2         sigma-y at the old(1) and new(2) ends[r]
c                               of the slug
c   RETURNED:   npuff           number of surrogate puffs            [i]
c               qfac            fraction of slug mass in each puff   [r]
c               xfac            puff separation, expressed as a      [r]
c                               fraction of the length of the slug
c
c CALLING ROUTINES:     COMP
c
c EXTERNAL ROUTINES:    none
c-----------------------------------------------------------------------
c Note: Assume that slug is partitioned into N puffs, so that there are
c       N-1 segments between the puffs.  Set the separation between the
c       puffs equal to the "mean" sigma-y
c-----------------------------------------------------------------------

      data half/0.5/, one/1.0/

c --- Compute the distance between the two "ends" of the slug
      slen=SQRT((x1-x2)**2+(y1-y2)**2)

c --- Set a min. sigma-y of "1" for the younger end ...
      sy22=AMAX1(sy2,one)

c --- Compute the mean sigma-y
c --- Arithmetic mean
      sy=half*(sy1+sy22)
c --- Geometric mean
c     sy=SQRT(sy1*sy22)

c --- Assume N equally-spaced puffs, where N is at least 2
      npuff=NINT(slen/sy)+1
      if(npuff.LT.2) npuff=2
      nseg=npuff-1
      qfac=one/FLOAT(npuff)
      xfac=one/FLOAT(nseg)

      return
      end
c-----------------------------------------------------------------------
      function speed(htmhd)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 971107                   SPEED
c ---            D. Strimaitis, SRC
c
c
c PURPOSE:      Computes wind speed at the height provided
c
c --- UPDATE
c --- V4.0-V5.0     971107  (DGS): Minimum speed returned is ws(1)
c
c ARGUMENTS:
c    PASSED: htmhd      height at which speed is needed  (m)         [r]
c                       minus the height of dividing streamline
c
c CALLING ROUTINES: CTPAR, FLOPUFF
c
c EXTERNAL ROUTINES: NONE
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'ctpass.puf'

c  Treat single layer first
      if(nlev .EQ. 1) then
         speed=ws(1)
         return
      endif

c  Add Hd to get height consistent with profile array
      ht=htmhd+hd

c  Find the layer that contains ht
      do i=1,nlev
         iztop=i
         if(ht .LE. z(i)) goto 11
      enddo
11    if(iztop.EQ.1) then
         h1=0.0
         u1=0.0
      else
         h1=z(iztop-1)
         u1=ws(iztop-1)
      endif
      h2=z(iztop)
      u2=ws(iztop)

c  Use linear interpolation to find speed at ht
      a=(u2-u1)/(h2-h1)
      b=u1-a*h1
      speed=a*ht+b

c  Do not allow speeds less than value for layer 1
      speed=AMAX1(speed,ws(1))

      return
      end
c-----------------------------------------------------------------------
      subroutine tfac(x,th,tl,tu)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                    TFAC
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Interpolates flow distortion factors at position x along
c               the trajectory of the puff.
c
c ARGUMENTS:
c    PASSED:    x       position along the flow (puff trajectory);   [r]
c                       the origin lies at the center of the hill (m)
c  RETURNED: th,tl,tu   terrain-induced flow distortion factors      [r]
c
c CALLING ROUTINES:     FCTZ, FCTY
c
c EXTERNAL ROUTINES:    none
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

      if(x.GT.xbegin .AND. x.LT.xend) then

c  Find array index just upwind of x    (npos)
         nposm1=INT((x-xbegin)/xspace)
         npos=nposm1+1
         nposp1=npos+1

c  Find value of x at npos
         xnpos=xbegin+xspace*nposm1

c  Find distortion factors at x
         xfac=(x-xnpos)/xspace
         th=xfac*(at(1,nposp1)-at(1,npos))+at(1,npos)
         tl=xfac*(at(2,nposp1)-at(2,npos))+at(2,npos)
         tu=one/(th*tl)

      else

         tu=one
         tl=one
         th=one

      endif

      return
      end
c-----------------------------------------------------------------------
      subroutine upper(c)
c-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 960521                   UPPER
c ---            D. Strimaitis, SRC
c
c PURPOSE:      Computes concentrations due to puff material in the
c               upper sgment of the flow (above Hd).
c
c ARGUMENTS:
c    PASSED:    none
c  RETURNED:    c               concentration (g/m**3)               [r]
c
c CALLING ROUTINES:     CTSG
c
c EXTERNAL ROUTINES:    FLOPUFF, QATR, FCTZ, FCTY, SIGMA, ERF,
c                       BJI, BI
c-----------------------------------------------------------------------

      INCLUDE 'params.puf'
      INCLUDE 'const.puf'
      INCLUDE 'ctpass.puf'

c  Set up for call to QATR:
      real aux(300)
      EXTERNAL fctz,fcty
      ndim=300
      eps=.01

c  Initialize concentration that is returned
      c=zero

c  Compute the age of puff at the receptor (tup)
      tup=timpg+t12ru

c  If the age of the puff at the recepter is not positive, concentration
c  is zero!
      if(tup .LE. zero) return

c  Puff age at start of time-integration is not negative
      tlow=AMAX1(timpg,zero)

c  Assign sigmas at impingement point
      szo=szimpg
      szosq=szo*szo
      syo=syimpg
      syosq=syo*syo
c  Reset impingement sigmas if they exceed receptor-specific values --
c  this turns off hill-effects as the puff has not yet reached the hill
      szsq=szr*szr
      sysq=syr*syr
      if(szosq.GE.szsq .OR. syosq.GE.sysq) then
         szo=szr
         szosq=szsq
         syo=syr
         syosq=sysq
      endif

c  Puff is mixed in the vertical if sigmaz upwind of the hill (szo)
c  exceeds 1.6 times the mixed layer height (zlid).  Set mixing
c  flag to 1.
      imix=0
      if(szo .GE. 1.6*zlid) imix=1

c  Compute (sigz**2-sigzo**2)/Tz**2, denoted as szptsq and
c       also (sigy**2-sigyo**2)/Ty**2, denoted as syptsq
c  Assume no growth if growth is less than "small"
      szptsq=zero
      szpt=zero
      syptsq=zero
      zdif=szr-szo
c  - set zdif equal to zero to avoid line integral evaluation when
c    puff is mixed in the vertical
      if(imix .EQ. 1) zdif=zero
      ydif=syr-syo
      if(zdif .GT. small) then
         call QATR(tlow,tup,eps,ndim,fctz,szptsq,ier,aux)
         szpt=SQRT(szptsq)
      endif
      if(ydif .GT. small) then
         call QATR(tlow,tup,eps,ndim,fcty,syptsq,ier,aux)
      endif
      szesq=szosq+szptsq
      sze=SQRT(szesq)
      syesq=syosq+syptsq
      sye=SQRT(syesq)

c  Compute the concentration on the trajectory ("centerline")
      t1mtr=-(t12p+t12ru)
      t2mtr=tstep+t1mtr
      dum=u/(rt2*sye)
c     co=q*(ERF(t2mtr*dum)-ERF(t1mtr*dum))/(tstep*four*pi*u*sye*sze)
      co=q*(ERFDIF((t2mtr*dum),(t1mtr*dum)))/(tstep*four*pi*u*sye*sze)
      if(co.LE.zero) return

c  Compute the horizontal distribution factor
      call FLOPUFF(xrf,yrf,0.0,zeta,ydel,dum1,dum2,dum3)
      del=yrf-ydel-ypf
      argy=half*(del*del/syesq)
      if(argy .LT. expmax) then
         fy=EXP(-argy)

c  Compute the vertical distribution factor

c  - If puff is mixed in the vertical, set fz equal to rt2pi*sze/zlid
c    and calculate concentration
         if(imix .EQ. 1) then
            fz=rt2pi*sze/zlid
            c=co*fy*fz
            return
         endif
         twofz=zero
         zlmhd=zlid-hd
         ak=half/szesq
         if(szpt .GT. zero) then
            ak=one/(rt2*sze*szo*szpt)
            d0=ak*szesq*zlmhd
         endif
c  - First sum, i=1:
         eoip=zpuff
         eoipmh=eoip-hd
         eoipph=eoip+hd
c  When plume doesn't grow, loop over j is not needed
         if(szpt .EQ. zero) then
            call BI(ak,eoipmh,eoipph,bp)
            twofz=twofz+bp
c  - No impact on i=1 means that plume does not reach receptor!
            if(twofz.EQ.0.0) return
         else
            dpm=eoipmh*szptsq
            dpp=eoipph*szptsq
c  - Loop on j:
            do 200 j=1,mxrefl
               aj=AMIN0(2,j)
               ej=two*(j-1)*zlmhd
               call BJI(ak,dpm,dpp,d0,eoipmh,eoipph,ej,bjp)
               add=aj*bjp
               twofz=twofz+add
c  - No impact on i=j=1 means that plume does not reach receptor!
               if(twofz.EQ.0.0) return
               if(add/twofz .LT. epsrefl) goto 201
200         continue
         endif
c  - Loop on i>1:
201      do 400 i=2,mxrefl
            eoip=zpuff+two*zlid*(i-1)
            eoipmh=eoip-hd
            eoipph=eoip+hd
            eoim=-zpuff+two*zlid*(i-1)
            eoimmh=eoim-hd
            eoimph=eoim+hd
c  When plume doesn't grow, loop over j is not needed
            if(szpt .EQ. zero) then
               call BI(ak,eoipmh,eoipph,bp)
               call BI(ak,eoimmh,eoimph,bm)
               add=(bp+bm)
               twofz=twofz+add
               if(add/twofz .LT. epsrefl) goto 401
            else
               dmm=eoimmh*szptsq
               dpm=eoipmh*szptsq
               dpp=eoipph*szptsq
               dmp=eoimph*szptsq
c  - Loop on j:
               do 300 j=1,mxrefl
                  aj=AMIN0(2,j)
                  ej=two*(j-1)*zlmhd
                  call BJI(ak,dpm,dpp,d0,eoipmh,eoipph,ej,bjp)
                  call BJI(ak,dmm,dmp,d0,eoimmh,eoimph,ej,bjm)
                  add=(aj*(bjp+bjm))
                  twofz=twofz+add
                  if(add/twofz .LT. epsrefl) then
                     if(j .GT. 1) goto 400
                     goto 401
                  endif
300            continue
            endif
400      continue

401      fz=half*twofz

c  Compute concentration
         c=co*fy*fz
      endif

      return
      end
c-----------------------------------------------------------------------
      real function xintrp(x1,x2,x,y1,y2)
C-----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 940831                  XINTRP
c ---            Adopted from CTDMPLUS without modification
c
C FUNCTION: XINTRP
C
C PURPOSE: THIS FUNCTION LINEARLY INTERPOLATES BETWEEN TWO POINTS
C               (Y1,Y2) GIVEN THREE OTHER POINTS (X1,X2,X) WHERE
C               X1 AND X2 ARE ENDPOINTS AND X IS BETWEEN X1 AND X2
C
C ASSUMPTIONS: X IS BETWEEN X1 AND X2
C
C REMARKS: IF X1 = X2 THEN THE MIDPOINT BETWEEN Y1 AND Y2 IS RETURNED
C
C ARGUMENTS:
C  PASSED:
C       X1,X2   REAL    ENDPOINTS OF FIRST LINE
C       X       REAL    POINT BETWEEN X1 AND X2
C       Y1,Y2   REAL    ENDPOINTS OF LINE TO BE INTERPOLATED
C
C FUNCTION VALUE:
C       XINTER  REAL    INTERPOLATED VALUE BETWEEN Y1 AND Y2
C
C CALLING ROUTINES: ctpar
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: NONE
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
C       DEFINE ARGUMENTS
        REAL X1, X2, X, Y1, Y2
C       DEFINE LOCAL VARIABLES
        REAL DX
C       START
        DX = X2 - X1
        IF( DX .NE. 0.0 ) THEN
                XINTRP = Y1 + (Y2-Y1) * (X-X1)/DX
         ELSE
                XINTRP = (Y1+Y2) * 0.5
        ENDIF
        RETURN
        END
c----------------------------------------------------------------------
      subroutine dry(icode,ix,iy,nhrind,tsamp,jp,dpbl,hlid,tempk,qsw,
     1               ppcoef,ldbhr,
     1               vd,vdpvd,fracdry)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                    DRY
c                J. Scire, D. Strimaitis   SRC

c
c --- PURPOSE:  Compute dry deposition velocities for each modeled
c               species using a resistance model or user-specified
c               diurnally varying values.  Also compute mass removed
c               during step.
c
c --- UPDATES:
c --- V5.0 950715 - V5.8.4 130731
c                   (EPA): Explicitly set LCALM in call to VCBAR to
c                          false to disable single-point sampling
c                          (LCALM was not previously assigned so this
c                          perpetuates the current treatment)
c
c --- INPUTS:
c
c             ICODE - integer - Puff status code (1,2 = Puff within
c                               mixed layer and [Gaussian, uniform] in
c                               vertical; 3,4 = Puff above mixed layer
c                               and [Gaussian, uniform]; 5,6 = Same as
c                               3, 4 except puff was previously within
c                               mixed layer; 11-16 = Same as 1-6 except
c                               applies slugs; 99 = Off comp. grid)
c                IX - integer - X index of closest grid point to
c                               puff/slug center
c                IY - integer - Y index of closest grid point to
c                               puff/slug center
c            NHRIND - integer - Current hour (01-24)
c             TSAMP - real    - Sampling step (s)
c                JP - integer - Puff number of current puff
c              DPBL - real    - Current depth of the boundary layer (m)
c                               (mixing height at nearest grid point)
c              HLID - real    - Current reflecting lid height (m) used
c                               to calculate the vertical distribution
c             TEMPK - real    - Air temperature (deg. K)
c               QSW - real    - Short-wave radiation (W/m**2)
c            PPCOEF - real    - Plume Path Coefficient for partial
c                               height correction (MCTADJ = 3)
c             LDBHR - logical - Variable controlling debug write
c                               statements
c
c     Common Block /DISPDAT/ variables:
c        CONK1, CONK2
c     Common Block /DRYDEP/ variables:
c        IDRYFLG(mxspec), ZREF, IVEG, VDUSER(24,mxspec)
c     Common Block /GEN/ variables:
c        NSPEC
c     Common Block /GRID/ variables:
c        NX, NY
c     Common Block /METHD/ variables:
c        Z0(mxnx,mxny), ILANDU(mxnx,mxny), XLAI(mxnx,mxny),
c        IWAT1, IWAT2
c     Common Block /METHR/ variables:
c        UMET(mxnx,mxny,mxnz), VMET(mxnx,mxny,mxnz), USTAR(mxnx,mxny),
c        XMONIN(mxnx,mxny)
c     Common Block /PUFF/ variables:
c        QM(mxspec,mxpuff)
c     Parameters:
c        MXNX, MXNY, MXNZ, MXPUFF, MXSPEC, MXNZP1, MXSS,
c        MXUS, MXPS, IO6
c
c --- OUTPUT:
c         VD(nspec) - real    - Deposition velocities (m/s) before
c                               considering overall boundary layer
c                               resistance
c      VDPVD(nspec) - real    - Ratio of vd'/vd, where vd' is the
c                               deposition velocity after applying
c                               the overall boundary layer resistance
c    FRACDRY(nspec) - real    - Fraction of puff mass remaining after
c                               consideration of dry removal effects
c     Common Block /PUFF/ variables:
c        QM(mxspec,mxpuff)
c
c --- DRY called by:  COMP
c --- DRY calls:      VDCOMP, VCBAR
c----------------------------------------------------------------------
c --- Note:  Mass depletion requires the evaluation of the vertical
c            coupling coefficient.  Make sure that the use of the
c            mixing height is consistent with CALCPF and CALCSL!
c----------------------------------------------------------------------
c
c --- Include PARAMETERS
      include 'params.puf'
c
c --- Include common blocks
      include 'dispdat.puf'
      include 'drydep.puf'
      include 'gen.puf'
      include 'grid.puf'
      include 'methd.puf'
      include 'methr.puf'
      include 'puff.puf'
c
      real vd(nspec),vdpvd(nspec),fracdry(nspec)
      logical ldbhr,ldb2
      logical lcalmf

c --- Explicitly disable single-point VCBAR sampling by setting local
c --- variable to false ("calm" sampling was never fully implemented)
      lcalmf=.false.

c ***
      ldb2=.false.
      if(ldb2)then
         write(io6,*)
         write(io6,*)'SUBR. DRY -- Inputs and local variables'
         write(io6,*)'IX        = ',ix,'  IY = ',iy
         write(io6,*)'ICODE     = ',icode
         write(io6,*)'NHRIND    = ',nhrind
         write(io6,*)'VDUSER    = ',(vduser(nhrind,n),n=1,nspec)
         write(io6,*)'UMET      = ',umet(ix,iy,1)
         write(io6,*)'VMET      = ',vmet(ix,iy,1)
         write(io6,*)'Z0        = ',z0(ix,iy)
         write(io6,*)'USTAR     = ',ustar(ix,iy)
         write(io6,*)'WSTAR     = ',wstar(ix,iy)
         write(io6,*)'DPBL      = ',dpbl
         write(io6,*)'HLID      = ',hlid
         write(io6,*)'XMONIN    = ',xmonin(ix,iy)
         write(io6,*)'ILANDU    = ',ilandu(ix,iy)
         write(io6,*)'IWAT1     = ',iwat1,'  IWAT2 = ',iwat2
         write(io6,*)'XLAI      = ',xlai(ix,iy)
         write(io6,*)'QSW       = ',qsw
         write(io6,*)'PPCOEF    = ',ppcoef
         write(io6,*)'TEMPK     = ',tempk
      endif
c ***
c
c --- Initialize output variables
      diffk=0.0
      do i=1,nspec
         vd(i)=0.0
         vdpvd(i)=1.0
         fracdry(i)=1.0
      enddo
c
c --- Extract puff distribution code
c --- (IICODE is 1-6 or 99)
      if(icode.EQ.99) goto 100
      iicode=icode
      if(iicode.ge.11.and.iicode.le.16) iicode=iicode-10
c
c --- Skip vd calculations if puff is above mixed layer and uniform
      if(iicode.eq.4) goto 100
c
c --- Determine state of the vegetation -- NOTE: negative land use
c --- indicates irrigated land
      if(ilandu(ix,iy).lt.0.or.
     1  (ilandu(ix,iy).ge.iwat1.and.ilandu(ix,iy).le.iwat2))then
c ---    IRRIGATED or WATER-- assume vegetation is active and unstressed
         ivegij=1
      else
c ---    UNIRRIGATED -- use user-specified vegetation state
         ivegij=iveg
      endif
c
c --- Compute deposition velocities using the resistance model or
c     user-specified, diurnally-varying values
      ldb2=.false.
      call vdcomp(idryflg,nspec,zref,ivegij,umet(ix,iy,1),
     1 vmet(ix,iy,1),ilandu(ix,iy),iwat1,iwat2,z0(ix,iy),tempk,
     2 ustar(ix,iy),xmonin(ix,iy),xlai(ix,iy),qsw,vduser,nhrind,
     3 ldb2,vd)
c
c --- Compute ratio of vd'/vd to account for overall boundary layer
c --- resistance if puff/slug is or was below mixed layer height AND
c --- is uniformly mixed in the vertical (use current mixing height)
      if(iicode.eq.2.or.iicode.eq.6) then
c
         eustar=ustar(ix,iy)
         ewstar=wstar(ix,iy)
c
c ---    Compute boundary layer diffusivity
         if(ewstar.gt.0.0)then
c
c ---       Unstable conditions -- diffusivity is maximum of
c ---       stable/unstable values
            diffk=amax1(conk2*ewstar*dpbl,conk1*eustar*dpbl)
         else
c
c ---       Neutral/stable
            diffk=conk1*eustar*dpbl
         endif
c
c ---    Minimum value of dz to prevent numerical problems
         dz=amax1(dpbl-zref,0.00001)
c
         do 95 j=1,nspec
c ---    Compute vd'/vd ratio only for species using resistance model
c ---    (User-specified deposition velocities are NOT modified)
         if(idryflg(j).eq.1.or.idryflg(j).eq.2)then
            vdpvd(j)=diffk/(diffk+vd(j)*dz)
         endif
95       continue
      endif
c
c --- Compute fraction remaining and adjust puff mass

      if(iicode.eq.2.or.iicode.eq.6)then
c
c ---    Puff is uniform in the vertical
         const=tsamp/hlid
c
      else
c
c ---    Puff is Gaussian in the vertical
         mfact0=icode-iicode
         f1=vcbar(jp,mfact0,hlid,ppcoef,lcalmf)
         const=tsamp*f1
      endif

c --- Determine the fraction of pollutant mass remaining after
c --- dry removal
      do 97 j=1,nspec
      fracdry(j)=exp(-vdpvd(j)*vd(j)*const)
      qm(j,jp)=fracdry(j)*qm(j,jp)
97    continue

c*****
100   if(ldbhr)then
         write(io6,111)diffk,(vd(n),n=1,nspec)
         write(io6,112)(vdpvd(n),n=1,nspec)
         write(io6,113)(fracdry(n),n=1,nspec)
111      format(15x,'DRY REMOVAL -- diffk = ',f10.3/
     1          17x,'vd (m/s)      = ',2x,5(f11.6,1x))
112      format(17x,'vdpvd         = ',2x,5(f11.6,1x))
113      format(17x,'Fraction left = ',2x,5(f11.3,1x))
      endif
c*****
c
      return
      end
c----------------------------------------------------------------------
      subroutine vdcomp(idryflg,nspec,zref,iveg,u10,v10,ilu,iwat1,
     1 iwat2,z0,tdegk,ustar,el,xlai,qsw,vduser,nhrind,ldb,vd)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 040611                 VDCOMP
c                J. Scire, SRC
c
c --- PURPOSE:  Compute deposition velocities for each species
c               deposited for a single grid cell
c
c --- UPDATE
c --- V5.0 980304 - V5.73 040611
c                   (DGS): Rename NINT to NPSINT
c --- V5.0 960521 - V5.0 980304
c                   (DGS): Set minimum calculated z0 over water as in
c                          CALMET
c
c --- INPUTS:
c
c
c    IDRYFLG(nspec) - integer - Dry deposition method flags
c                                    0=not deposited,
c                                    1=resistance model - gas,
c                                    2=resistance model - particle,
c                                    3=user specified dep. velocities
c             NSPEC - integer - Total number of species
c                               (deposited + non-deposited species)
c              ZREF - real    - Reference height (m) for computing
c                               the atmospheric resistance
c              IVEG - integer - State of the vegetation in current cell
c                                    1 = vegetation active & unstressed
c                                    2 = vegetation active & stressed
c                                    3 = vegetation inactive
c               U10 - real    - U-component (m/s) of winds at 10 m
c                               height (Used only if in water cells)
c               V10 - real    - V-component (m/s) of winds at 10 m
c                               height (Used only if in water cells)
c               ILU - integer - Land use category for current grid cell
c      IWAT1, IWAT2 - integer - Range of land use categories defining
c                               water (IWAT1 to IWAT2)
c                Z0 - real    - Surface roughness length (m)
c             TDEGK - real    - Air temperature (deg. K)
c             USTAR - real    - Surface friction velocity (m/s)
c                EL - real    - Monin-Obukhov length (m)
c              XLAI - real    - Leaf area index
c               QSW - real    - Short-wave radiation at ground (W/m**2)
c VDUSER(24,mxspec) - real    - Diurnal cycle of user-specified
c                               deposition velocities (m/s) for hour
c                               ending 1-24
c            NHRIND - integer - Current hour index (1-24)
c               LDB - logical - Flag determining if debug write
c                               statements are activated
c     Common Block /DRYGAS/ variables:
c        PDIFF(mxspec),RM(mxspec),RGG(mxspec),RGW1(mxspec),
c        RCUT(mxspec),RD1(mxspec),BMIN,BMAX,QSWMAX,PCONST
c     Common Block /DRYPART/ variables:
c        SC23(mxint,mxpdep),VGRAV(mxint,mxpdep),TSTOP(mxint,mxpdep),
c        FRACT(mxint,mxpdep),VAIRMS
c     Parameters:
c        MXSPEC, MXPDEP, MXINT, IO6
c
c --- OUTPUT:
c         VD(nspec) - real    - Deposition velocities (m/s)
c
c --- VDCOMP called by:  DRY
c --- VDCOMP calls:      VDP
c----------------------------------------------------------------------
c
c --- Include PARAMETERS
      include 'params.puf'
c
c --- Include common block /DRYGAS/  -- Gas Deposition
      include 'drygas.puf'
c
c --- Include common block /DRYPART/ -- Particle Deposition
      include 'drypart.puf'
c
      real vd(nspec),vduser(24,mxspec)
      integer idryflg(nspec)
      logical lwater,ldb
c
      data vk/0.4/,usmin/1.e-5/,ramin/1.0/

c --- Minimum z0(m) over water is 2.0e-06, which corresponds to a 10m
c --- wind speed minimum of 1m/s
      data ws0/1.0/

c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. VDCOMP -- INPUTS'
         write(io6,*)'NSPEC   = ',nspec
         write(io6,*)'IDRYFLG = ',(idryflg(n),n=1,nspec)
         write(io6,*)'IVEG    = ',iveg
         write(io6,*)'U10     = ',u10,' v10 = ',v10
         write(io6,*)'ILU     = ',ilu,' IWAT1 = ',iwat1,' IWAT2 = ',
     1    iwat2
         write(io6,*)'Z0      = ',z0,' XLAI = ',xlai
         write(io6,*)'TDEGK   = ',tdegk,' USTAR = ',ustar,' EL = ',el,
     1    ' QSW = ',qsw
         write(io6,*)'NHRIND  = ',nhrind
         write(io6,*)'VDUSER  = ',(vduser(nhrind,n),n=1,nspec)
      endif
c ***
c
c --- Pass user-supplied deposition velocities to VD array and exit
c --- if no computations are needed
c --- LOOP OVER SPECIES
      numsp=0
      do j=1,nspec
         if(idryflg(j).eq.0)then
c ---       NO DEPOSITION
            vd(j)=0.0
            numsp=numsp+1
         elseif(idryflg(j).eq.3)then
c ---       USER-SPECIFIED DEPOSITION
            vd(j)=vduser(nhrind,j)
            numsp=numsp+1
         endif
      enddo
      if(numsp.eq.nspec) return
c
c --- Continue on if computations are needed for some species
c
c --- Determine if this grid cell is a water or land cell
      if(ilu.ge.iwat1.and.ilu.le.iwat2)then
         lwater=.true.
c ---    Compute wind-driven roughness length
         z0m=2.0e-6
         wstest=ABS(u10)+ABS(v10)
         if(wstest.GT.ws0) then
            ws=sqrt(u10**2+v10**2)
            if(ws.GT.ws0) z0m=2.0e-6*ws**2.5
         endif
      else
         lwater=.false.
         z0m=z0
      endif
c
c --- Compute atmospheric resistance
c --- Stability-dependent psi function (heat)
      elabs=abs(el)
      if(el.lt.0.0.and.elabs.lt.9990.)then
         ratio=-zref/el
         if(ratio.gt.1.0)ratio=1.0
         zmel=alog(ratio)
         psih=exp(0.598+0.39*zmel-0.090*zmel*zmel)
      else if(elabs.ge.9990.)then
         psih=0.0
      else
         ratio=zref/el
         if(ratio.gt.1.0)ratio=1.0
         psih=-5.*ratio
      endif
c
c --- Use minimum value of USTAR to avoid numerical problems
c     when USTAR near zero
      ustarr=amax1(ustar,usmin)
c
c --- Calculate atmospheric resistance
      ra=(alog(zref/z0m)-psih)/(vk*ustarr)
      ra=amax1(ra,ramin)
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'LWATER = ',lwater
         write(io6,*)'Z0M    = ',z0m
         write(io6,*)'PSIH   = ',psih
         write(io6,*)'USTARR = ',ustarr
         write(io6,*)'RA     = ',ra
      endif
c ***
c
c --- LOOP OVER SPECIES
      nsp=0
      do 100 j=1,nspec
c
c --- Compute deposition velocity for species deposited
      if(idryflg(j).eq.0 .OR. idryflg(j).eq.3)then
c ---    DEPOSITION ALREADY ASSIGNED
         go to 100
      elseif(idryflg(j).eq.2)then
c ---    PARTICLE DEPOSITION
         nsp=nsp+1
         call vdp(sc23(1,nsp),vgrav(1,nsp),tstop(1,nsp),fract(1,nsp),
     1   npsint,ra,vairms,ustarr,ldb,vd(j))
         go to 100
      endif
c
c --- GAS DEPOSITION
c
c --- Compute the deposition layer resistance, RD
c --- (RD1 is d1*SC**d2/vk -- computed in setup routine)
      RD=RD1(j)/ustarr
c
c --- Compute resistance directly to ground or water, RG
      if(lwater)then
c
c ---    Water cell (RGW1 computed in setup routine as
c ---                RGW1 = HENRY/(ALPHAS * D3 * USTAR)
         RG=RGW1(j)/ustarr
      else
c
c ---    Land cell (RG computed in setup routine)
         RG=RGG(j)
      endif
c
c --- Stomatal pore resistance (RS)
      if(iveg.eq.1)then
c
c ---    Vegetation is active & unstressed (IVEG=1)
c        (B = stomatal pore opening (m), BMIN = minimum stomatal
c        opening, BMAX = maximum stomatal opening, fr is the approx.
c        fraction of peak short-wave solar radiation available for a
c        particular hour)
c
c ---    Temperature effects -- If T > 35 deg. C, stomata fully
c ---    open to allow evaporative cooling -- but only if unstressed --
c ---    If T < 10 deg. C, stomata closed due to decreased metabolic
c ---    activity)
         if(tdegk.gt.308.)then
c ---       T > 35 deg. C
            B=BMAX
         else if(tdegk.lt.283.)then
c ---       T < 10 deg. C
            B=BMIN
         else
            fr=qsw/qswmax
            fr=amax1(0.0,fr)
            fr=amin1(1.0,fr)
            B=BMAX*fr+BMIN*(1.-fr)
         endif
c
         RS=pconst/(B*pdiff(j))
      else if(iveg.eq.2)then
c
c ---    Vegetation is active and stressed (IVEG=2)
c        (Stomatal opening is at its minimum size)
         RS=pconst/(BMIN*pdiff(j))
      else
c
c ---    Vegetation is inactive (IVEG=3)
         RS=9.9e9
      endif
c
c --- Internal foliage resistance (RF)
c     (RM is the mesophyll resistance)
      RF=RS+RM(j)
c
c --- Compute canopy resistance
      RC=1.0/(XLAI/RF+XLAI/RCUT(j)+1.0/RG)
c
c --- Deposition velocity is the inverse of the sum of the
c --- atmospheric, deposition layer, and canopy resistances
      vd(j)=1.0/(ra+rd+rc)
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. VDCOMP -- OUTPUT'
         write(io6,*)'SPECIES (J) = ',j
         write(io6,*)'RD          = ',rd
         write(io6,*)'RC          = ',rc
         write(io6,*)'VD(j)       = ',vd(j)
         write(io6,*)'RS          = ',rs
         write(io6,*)'RF          = ',rf
         write(io6,*)'RG          = ',rg
         write(io6,*)'B           = ',b
      endif
c
100   continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine vdp(sc23,vgrav,tstop,fract,npsint,ra,vairms,ustar,
     1 ldb,vd)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 040611                    VDP
c                J. Scire, SRC
c
c --- UPDATE
c --- V5.0 960628 - V5.73 040611
c                   (DGS): Rename NINT to NPSINT
c
c --- MODIFICATION  6/26/96 (DGS): all mass is in first size when gsig
c                                  is less than or equal to 1.0 um, so
c                                  only do first interval if
c                                  fract(1) = 1.0
c
c --- PURPOSE:  Compute a mass-weighted particle deposition
c               velocity for a single size distribution
c
c --- INPUTS:
c
c      SC23(npsint) - real    - Schmidt number ** DCONST4
c     VGRAV(npsint) - real    - Gravitational settling velocity (m/s)
c     TSTOP(npsint) - real    - Stopping time (s)
c     FRACT(npsint) - real    - Mass fraction in each size interval
c            NPSINT - integer - Number of size intervals used to
c                               evaluate the effective deposition
c                               velocity
c                RA - real    - Atmospheric resistance (s/m)
c            VAIRMS - real    - Viscosity of air (m**2/s)
c             USTAR - real    - Friction velocity (m/s)
c               LDB - logical - Flag determining if debug write
c                               statements are activated
c     Parameters:
c        IO6
c
c --- OUTPUT:
c                VD - real    - Mass-weighted deposition velocity (m/s)
c
c --- VDP called by:  VDCOMP
c --- VDP calls:      none
c----------------------------------------------------------------------
c
c --- Include PARAMETERS
      include 'params.puf'
c
      real sc23(npsint),vgrav(npsint),tstop(npsint),fract(npsint)
      logical ldb
c
      save xmin
      data xmin/-37./
c
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. VDP -- Inputs'
         write(io6,*)'SC23    = ',sc23
         write(io6,*)'VGRAV   = ',vgrav
         write(io6,*)'TSTOP   = ',tstop
         write(io6,*)'FRACT   = ',fract
         write(io6,*)'NPSINT  = ',npsint
         write(io6,*)'RA      = ',ra
         write(io6,*)'VAIRMS  = ',vairms
         write(io6,*)'USTAR   = ',ustar
      endif
c ***
      vd=0.0
      t1=ustar*ustar/vairms
c
c --- Reset number of intervals to 1 if all mass is in first interval
      if(fract(1).EQ.1.0) then
         intrvl=1
      else
         intrvl=npsint
      endif
c
c --- LOOP OVER SIZE INTERVALS
      do 10 i=1,intrvl
c
      st=tstop(i)*t1
c
c --- prevent underflows (min. 10. ** (-37.)
c *** xinert=10.**(-3./st)
      xpon=-3./st
      if(xpon.lt.xmin)then
         xinert=10.**(xmin)
      else
         xinert=10.**(xpon)
      endif
c
c --- Deposition layer resistance (s/m)
      rd=1.0/(ustar*(sc23(i)+xinert))
c
c --- Deposition velocity for this current interval
      vdi=1.0/(ra+rd+ra*rd*vgrav(i))+vgrav(i)
c
c --- Effective deposition velocity is weighted average of value
c --- in each size interval
      vd=vd+vdi*fract(i)
c ***
      if(ldb)then
         write(io6,*)'I       = ',i,' RD = ',rd,' VDI = ',vdi
      endif
c ***
c
10    continue
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'VD      = ',vd
      endif
c ***
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdvd
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                  RDVD
c                J. Scire, SRC
c
c --- PURPOSE:  Read a file containing a diurnal cycle of 24 hourly
c               deposition velocities (m/s) for selected species
c
c --- UPDATE
c --- V5.5-V5.7
c        000602_7 - 030402  (DGS): MXVAR relocated to PARAMS.CAL
c --- V5.5          000602_7 (JSS): Fix call to READIN to allow
c                                   up to MXSPEC species to have
c                                   user-specified dep. velocities
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c
c --- INPUTS:
c     Common block /GEN/ variables
c           NSPEC, CSPEC(mxspec)
c     Common block /DRYDEP/ variables
c           IDRYFLG(mxspec), NVDUSER
c     Parameters: MXVAR, MXSPEC, IO6, IO20
c
c --- OUTPUT:
c     Common block /DRYDEP/ variables
c           VDUSER(24,mxspec)
c
c --- RDVD called by: DRYI
c --- RDVD calls:     READIN
c----------------------------------------------------------------------
c
c --- Include parameter statements
      include 'params.puf'
      include 'params.cal'
c
      integer ivleng(mxvar),ivtype(mxvar)
      character*12 cvdic(mxvar)
      logical lecho
c
      include 'gen.puf'
      include 'drydep.puf'
c
      data cvdic/mxvar*' '/,ivleng/mxvar*0/,ivtype/mxvar*0/
      data lecho/.true./
c
c --- Initialize user-specified vd array with missing value
c --- indicators
      do 10 j=1,mxspec
      do 10 i=1,24
      vduser(i,j)=-9.
10    continue
c
      if(nvduser.eq.0)go to 999
c
c --- Set up the variable dictionary and array length vector
      do 20 i=1,nspec
      if(idryflg(i).eq.3)then
         cvdic(i)=cspec(i)
         ivleng(i)=24
         ivtype(i)=1
      endif
20    continue
c
c --- read the formatted file
      write(io6,32)
32    format(///1x,13('----------')//5x,'USER-SPECIFIED DEPOSITION ',
     1 'VELOCITY FILE (VD.DAT)'//)
c
c --- The following call is set for MXSPEC=35
c *** call readin(cvdic,ivleng,ivtype,io20,io6,lecho,
c ***1 vduser(1,1),vduser(1,2),vduser(1,3),vduser(1,4),vduser(1,5),
c ***2 vduser(1,6),vduser(1,7),vduser(1,8),vduser(1,9),vduser(1,10),
c ***3 vduser(1,11),vduser(1,12),vduser(1,13),vduser(1,14),vduser(1,15),
c ***4 vduser(1,16),vduser(1,17),vduser(1,18),vduser(1,19),vduser(1,20),
c ***5 vduser(1,21),vduser(1,22),vduser(1,23),vduser(1,24),vduser(1,25),
c ***6 vduser(1,26),vduser(1,27),vduser(1,28),vduser(1,29),vduser(1,30),
c ***7 vduser(1,31),vduser(1,32),vduser(1,33),vduser(1,34),vduser(1,35),
c ***8 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
c ***9 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
c ***a idum)
c
c --- The following call is set for MXSPEC=20
      call readin(cvdic,ivleng,ivtype,io20,io6,lecho,
     1 vduser(1,1),vduser(1,2),vduser(1,3),vduser(1,4),vduser(1,5),
     2 vduser(1,6),vduser(1,7),vduser(1,8),vduser(1,9),vduser(1,10),
     3 vduser(1,11),vduser(1,12),vduser(1,13),vduser(1,14),vduser(1,15),
     4 vduser(1,16),vduser(1,17),vduser(1,18),vduser(1,19),vduser(1,20),
     5 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
     4 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
     5 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
     6 idum,idum,idum,idum)
c
c --- The following call is set for MXSPEC=5
c *** call readin(cvdic,ivleng,ivtype,io20,io6,lecho,
c ***1 vduser(1,1),vduser(1,2),vduser(1,3),vduser(1,4),vduser(1,5),
c ***2 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
c ***3 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
c ***4 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
c ***5 idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,idum,
c ***6 idum,idum,idum,idum,idum,idum,idum)
c
c --- check that values for every required species have been read
      ierr=0
      do 50 j=1,nspec
c
      isperr=0
      if(idryflg(j).eq.3)then
         do 45 i=1,24
         if(vduser(i,j).lt.0.0)then
            ierr=1
            isperr=1
         endif
45       continue
c
c ---    Error if any hour for this deposited species is missing
         if(isperr.eq.1)then
            write(io6,47)cspec(j),(vduser(n,j),n=1,24)
47          format(/1x,'ERROR in subr. RDVD -- VD values not found ',
     1      'for species: ',a12,/1x,'VDUSER = ',12f10.5/10x,12f10.5/)
         endif
      endif
50    continue
c
      if(ierr.eq.1) then
         write(*,*)
         stop 'Halted in RDVD -- see list file.'
      endif
c
999   continue
      return
      end
c----------------------------------------------------------------------
      subroutine dryi(zgrid1,ldb)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 040611                   DRYI
c                J. Scire, SRC
c
c --- PURPOSE:  Setup routine for dry deposition module.
c               Initialization and time-invariant calculations
c               performed.
c
c --- UPDATE
c --- V5.4 000602 - V5.73 040611
c                   (DGS): Rename NINT to NPSINT
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c --- MODIFICATION  6/26/96 (DGS): place an upper limit of 10 m on zref
c
c --- INPUTS:
c
c            ZGRID1 - real    - Height (m) of the lowest grid point
c                               (i.e., approx. 10 m)
c               LDB - logical - Flag determining if debug write
c                               statements are activated
c     Common Block /DRYGAS/ variables:
c        PDIFF(mxspec),ALPHAS(mxspec),REACT(mxspec),RM(mxspec),
c        HENRY(mxspec),RCUTR,RGR,REACTR,DCONST1,DCONST2,DCONST3
c     Common Block /DRYPART/ variables:
c        GDIAM(mxpdep),GSIG(mxpdep),RHO(mxpdep),NPSINT,DCONST4
c     Common Block /DRYDEP/ variables:
c        IDRYFLG(mxspec),ZREF
c     Common block /GEN/ variables
c           NSPEC, CSPEC(mxspec), NSDD
c     Parameters:
c        MXSPEC, MXPDEP, MXINT, IO6
c
c --- OUTPUT:
c     Common Block /DRYGAS/ variables:
c        PDIFF(mxspec),RM(mxspec),RCUTR,RGR,RGG(mxspec),RGW1(mxspec),
c        RCUT(mxspec),RD1(mxspec)
c     Common Block /DRYPART/ variables:
c        NSPART,PDIAM(mxint,mxpdep),SC23(mxint,mxpdep),
c        VGRAV(mxint,mxpdep),TSTOP(mxint,mxpdep),FRACT(mxint,mxpdep),
c        VAIRMS
c     Common Block /DRYDEP/ variables:
c        VDUSER(24,mxspec),NVDUSER
c
c --- DRYI called by:  SETUP
c --- DRYI calls:      VDP1, RDVD
c----------------------------------------------------------------------
c
c --- Include PARAMETERS
      include 'params.puf'
c
c --- Include common block /DRYGAS/  -- Gas Deposition
      include 'drygas.puf'
c
c --- Include common block /DRYPART/ -- Particle Deposition
      include 'drypart.puf'
c
c --- Include common block /DRYDEP/ -- Deposition mode flags
      include 'drydep.puf'
c
c --- Include common block /GEN/    -- General run flags
      include 'gen.puf'
c
      logical ldb
c
      data vair/0.15e-4/,vk/0.4/
c
      if(nspec.gt.mxspec)then
         write(io6,*)'ERROR in SUBR. VD1 -- NSPEC is too large -- ',
     1  'NSPEC = ',nspec,' MXSPEC = ',mxspec
         write(*,*)
         stop 'Halted in VD1 -- see list file.'
      endif
c
      if(npsint.gt.mxint)then
         write(io6,*)'ERROR in SUBR. VD1 -- NPSINT is too large -- ',
     1  'NPSINT = ',npsint,' MXINT = ',mxint
         write(*,*)
         stop 'Halted in VD1 -- see list file.'
      endif
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. VD1 -- INPUTS'
         write(io6,*)'IDRYFLG          = ',(idryflg(n),n=1,nspec)
         write(io6,*)'NSPEC            = ',nspec
         write(io6,*)'PDIFF (cm**2/s)  = ',(pdiff(n),n=1,nspec)
         write(io6,*)'ALPHAS           = ',(alphas(n),n=1,nspec)
         write(io6,*)'REACT            = ',(react(n),n=1,nspec)
         write(io6,*)'RM (s/cm)        = ',(rm(n),n=1,nspec)
         write(io6,*)'HENRY            = ',(henry(n),n=1,nspec)
         write(io6,*)'RCUTR (s/cm)     = ',rcutr,' RGR = ',rgr,
     1   ' REACTR = ',reactr
         write(io6,*)'DCONST1 = ',dconst1,' DCONST2 = ',dconst2,
     1   ' DCONST3 = ',dconst3
      endif
c ***
c
c --- Count the number of deposited species
      LL=0
      do 15 i=1,nspec
      if(idryflg(i).ge.1)then
         LL=LL+1
      endif
15    continue
c
c --- Number of deposited species must be <= total no. species
      if(LL.ne.nsdd)then
         write(io6,17)LL,nsdd,(idryflg(n),n=1,nspec)
17       format(/1x,'ERROR in subr. VD1 -- LL .NE. NSDD -- LL = ',i5,
     1   3x,'NSDD = ',i5,3x,'IDRYFLG = ',100i2)
         write(*,*)
         stop 'Halted in VD1 -- see list file.'
      endif
c
c --- Count the number of species with user-specified deposition
c --- velocities
      nvduser=0
      do 20 i=1,nspec
      if(idryflg(i).eq.3)then
         nvduser=nvduser+1
      endif
20    continue
c
c --- Read diurnal cycles of user-specified deposition velocities
c --- for pollutants flagged with IDRYFLG(i)=3
      call rdvd
c
      if(ldb)then
         write(io6,*)
         write(io6,*)'NVDUSER = ',nvduser
         do 133 i=1,nspec
         write(io6,132)i,cspec(i),(vduser(n,i),n=1,24)
132      format(1x,'NO.: ',i3,' Species: ',a12,2x,12f8.5/
     1                                        33x,12f8.5)
133      continue
      endif
c
c --- Convert length units of input deposition variables from cm to m
c
      do 10 i=1,nspec
c
c --- IDRYFLG -  Flags indicating which species are deposited
c                (0=no, 1=yes-gas, 2=yes-particle, 3=yes-user specified
c                deposition velocities)
      if(idryflg(i).eq.0.or.idryflg(i).eq.3)go to 10
c
c --- Pollutant diffusivity (cm**2/s to m**2/s)
      pdiff(i)=pdiff(i)*1.e-4
c
c --- Mesophyll resistance from s/cm to s/m
      rm(i)=rm(i)*1.e2
10    continue
c
c --- Reference cuticle resistance (s/cm to s/m)
      rcutr=rcutr*1.e2
c
c --- Reference ground resistance (s/cm to s/m)
      rgr=rgr*1.e2
c
c --- Set reference height to height of the
c --- lowest grid point
      zref=AMIN1(zgrid1,10.)
c
c --- Compute time-invariant parameters
      nspart=0
      do 110 i=1,nspec
      if(idryflg(i).eq.0.or.idryflg(i).eq.3)then
         go to 110
      else if(idryflg(i).eq.2)then
c
c ---    PARTICLE DEPOSITION
         nspart=nspart+1
         if(nspart.gt.mxpdep)then
            write(io6,*)'ERROR IN SUBR. VD1 -- Too many particle ',
     1      'species -- NSPART = ',nspart,' MXPDEP = ',mxpdep
            write(*,*)
            stop 'Halted in VD1 -- see list file.'
         endif
c
         call vdp1(gdiam(nspart),gsig(nspart),rho(nspart),npsint,
     1   dconst4,ldb,pdiam(1,nspart),sc23(1,nspart),vgrav(1,nspart),
     2   tstop(1,nspart),fract(1,nspart),vairms)
         go to 110
      endif
c
c --- GAS DEPOSITION
c
c --- Schmidt number = viscosity of air/(diffusivity of the pollutant)
c     (vair = viscosity of air at 20 deg. C = 0.15e-4 m**2/s)
      sc=vair/pdiff(i)
c
c --- Time-invariant term of deposition layer resistance
      rd1(i)=dconst1*sc**dconst2/vk
c
c --- Cuticle resistance
      ratio=reactr/react(i)
      rcut(i)=rcutr*ratio
c
c --- Ground resistance
      rgg(i)=rgr*ratio
c
c --- Time-invariant term of "ground" resistance to water
      rgw1(i)=henry(i)/(alphas(i)*dconst3)
110   continue
c
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. VD1 -- OUTPUT'
         write(io6,*)'PDIFF (m**2/s)  = ',(pdiff(n),n=1,nspec)
         write(io6,*)'RM (s/m)        = ',(rm(n),n=1,nspec)
         write(io6,*)'RCUTR (s/m)     = ',rcutr,' RGR = ',rgr
         write(io6,*)'RGG (s/m)       = ',(rgg(n),n=1,nspec)
         write(io6,*)'RGW1 (s/m)      = ',(rgw1(n),n=1,nspec)
         write(io6,*)'RCUT (s/m)      = ',(rcut(n),n=1,nspec)
         write(io6,*)'RD1 (s/m)       = ',(rd1(n),n=1,nspec)
         write(io6,*)'ZREF (m)        = ',zref
      endif
c ***
      return
      end
c----------------------------------------------------------------------
      subroutine vdp1(gdiam,gsig,rho,npsint,dconst4,ldb,pdiam,sc23,
     1 vgrav,tstop,fract,vairms)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 040611                   VDP1
c                J. Scire, SRC
c
c --- PURPOSE:  Setup routine for PARTICLE dry deposition.
c               Initialization and time-invariant calculations
c               performed.
c
c --- UPDATE
c --- V5.4 000602 - V5.73 040611
c                   (DGS): Rename NINT to NPSINT
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c
c --- MODIFICATION  6/26/96 (DGS): put all mass into first size when
c                                  gsig is less than or equal to 1.0 um
c
c --- INPUTS:
c
c             GDIAM - real    - Geometric mass mean diameter (microns)
c              GSIG - real    - Geometric standard deviation of the
c                               distribution (microns)
c               RHO - real    - Particle density (g/cm**3)
c            NPSINT - integer - Number of size intervals used to
c                               evaluate the effective deposition
c                               velocity
c           DCONST4 - real    - Empirical constant in particle
c                               deposition layer resistance eqn.
c               LDB - logical - Flag determining if debug write
c                               statements are activated
c     Parameters:
c        IO6
c
c --- OUTPUT:
c       PDIAM(npsint) - real    - Geometric mean diameter (microns)
c                               of each interval
c      SC23(npsint) - real    - Schmidt number ** DCONST4
c     VGRAV(npsint) - real    - Gravitational settling velocity (m/s)
c     TSTOP(npsint) - real    - Stopping time (s)
c     FRACT(npsint) - real    - Mass fraction in each size interval
c            VAIRMS - real    - Viscosity of air (m**2/s)
c
c --- VDP1 called by:  DRYI
c --- VDP1 calls:      ERF
c----------------------------------------------------------------------
c
c --- Include PARAMETERS
      include 'params.puf'
c
      real pdiam(npsint),sc23(npsint),vgrav(npsint),tstop(npsint),
     &     fract(npsint)
      logical ldb
c
      save a1,a2,a3,xmfp,pi,vcon,xk,temp,vair,g
c
      data a1/1.257/,a2/0.4/,a3/0.55/,xmfp/6.5e-6/
      data pi/3.1415927/,vcon/1.81e-4/,xk/1.38e-16/
      data temp/293.15/
      data vair/0.15/,g/981./
c
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. VDP1 -- INPUTS'
         write(io6,*)'GDIAM (um)       = ',gdiam
         write(io6,*)'GSIG (um)        = ',gsig
         write(io6,*)'RHO (g/cm**3)    = ',rho
         write(io6,*)'DCONST4          = ',dconst4
         write(io6,*)'NPSINT           = ',npsint
      endif
c ***
      if(npsint.gt.1 .AND. gsig.GT.1.0)then
c
c ---    Setup size intervals from -4*sigma to +4*sigma from mean
         xincr=8.0/float(npsint)
c
c ---    Constant 1.414214 = sqrt(2)
         xtmp1=1.414214*alog(gsig)
c
c ---    DLOW is the diameter of the lower end of the interval
c        (set equal to DHIGH within loop)
         dhigh=gdiam*gsig**(-4)
      endif
c
c --- LOOP over "NPSINT" size intervals
      do 10 i=1,npsint
c
      if(npsint.gt.1 .AND. gsig.GT.1.0)then
         dlow=dhigh
c
c ---    DHIGH is the diameter of the high end of the interval
         dhigh=gdiam*gsig**(-4.+xincr*float(i))
c
c ---    Compute the area under the normal curve within this interval
         fract(i)=0.5*(erf(alog(dhigh/gdiam)/xtmp1)-
     1                 erf(alog(dlow/gdiam)/xtmp1))
c
c ---    Compute the geometric mean diameter (microns) of the interval
         pdiam(i)=exp(0.5*alog(dlow*dhigh))
c
      else if(npsint.eq.1)then
c
c ---    Only one size interval
         fract(i)=1.0
         pdiam(i)=gdiam
c
      else if(gsig.le.1.0)then
c ---    Only one effective particle size; put all mass in first
         fract(i)=0.0
         if(i.eq.1) fract(i)=1.0
         pdiam(i)=gdiam
c
      else
         write(io6,*)'ERROR in Subr. VDP1 -- Invalid value of NPSINT ',
     1   '-- NPSINT = ',npsint
         write(*,*)
         stop 'Halted in VDP1 -- see list file.'
      endif
c
c --- Slip correction factor
      diamcm=1.e-4*pdiam(i)
      scf=1.+2.0*xmfp*(a1+a2*exp(-a3*diamcm/xmfp))/diamcm
c
c --- Stokes friction coefficient
      sfc=3.*pi*vcon*diamcm/scf
c
c --- Diffusivity (cm**2/s)
      diff=xk*temp/sfc
c ***
      if(ldb)then
         write(io6,*)'i = ',i,' diamcm = ',diamcm,' scf = ',scf,
     1   ' sfc = ',sfc,' diff = ',diff
      endif
c ***
c
c --- schmidt number
c --- (vair = viscosity of air at 20 deg. c = 0.15 cm**2/s)
      sc23(i)=(vair/diff)**(-dconst4)
c
c --- gravitational settling velocity (m/s)
      vgrav(i)=0.01*rho*g*diamcm**2*scf/(18.*vcon)
c
c --- stopping times
      tstop(i)=vgrav(i)/(0.01*g)
10    continue
c
c --- convert viscosity of air (at 20. deg. c) from cm**2/s to m**2/s
      vairms=1.e-4*vair
c ***
      if(ldb)then
         write(io6,*)
         write(io6,*)'SUBR. VDP1 -- Outputs'
         write(io6,*)'PDIAM  = ',pdiam
         write(io6,*)'SC23   = ',sc23
         write(io6,*)'VGRAV  = ',vgrav
         write(io6,*)'TSTOP  = ',tstop
         write(io6,*)'FRACT  = ',fract
         write(io6,*)'VAIRMS = ',vairms
      endif
c ***
c
      return
      end
c----------------------------------------------------------------------
      subroutine exmet(iflag,ixs,iys,dgrid,tempk,qsw,irh,rhoair,
     &                 cc,czen)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                  EXMET
c                J. Scire
c
c --- PURPOSE:  Find the closest non-missing value of air temperature,
c               short-wave radiation, relative humidity, and air
c               density, cloud cover, and cosine of solar angle
c               to a particular grid point.
c               NOTE: if IFLAG = 1, only temperature is returned
c                     if IFLAG = 2, values for all six variables
c                                   are returned
c
c --- UPDATE
c --- V5.7-V5.8.4   130731  (EPA): Do not let returned station ID
c                                  from FINDR/FINDI overwrite the
c                                  station ID from the NEARS array
c --- V5.4-V5.7     030402  (FRR): Add 2D met arrays (i2dmet) of
c                                  RHO,QSW,RH,TEMP if
c                                  available in CALMET
c --- V5.0-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.0     980304  (DGS): add clouds & sun angle
c
c --- INPUTS:
c            IFLAG - integer - Flag determining which variables are
c                              computed ( 1 ==> TEMPK only,
c                              2 ==> TEMP, QSW, IRH, RHOAIR)
c              IXS - integer - X index of the closest met. grid point
c                              to the puff/slug center
c              IYS - integer - Y index of the closest met. grid point
c                              to the puff/slug center
c            DGRID - real    - Grid spacing (m)
c
c     Common block /METHD/ variables:
c           NXM, NYM, NEARS(mxnx,mxny), XSSTA(mxss), YSSTA(mxss),
c           NSSTA, LCALGRD, I2DMET
c     Common block /METHR/ variables:
c           TMET(mxnx,mxny,mxnz), TEMPSS(mxss), RHOSS(mxss),
c           QSWSS(mxss), IRHSS(mxss), CCSS(mxss),CZENSS(mxss)
c frr (09/01)
c           TEMP2D(mxnx,mxny), RHO2D(mxnx,mxny),
c           QSW2D(mxnx,mxny), IRH2D(mxnx,mxny), CC2D(mxnx,mxny),
c           CZEN2D(mxnx,mxny)
c     Parameters:
c           MXNX, MXNY, MXNZ, MXSS, MXUS, MXPS, IO6
c
c --- OUTPUT:
c            TEMPK - real    - Air temperature (deg. K)
c              QSW - real    - Short-wave solar radiation (W/m**2)
c              IRH - integer - Relative humidity (percent)
c           RHOAIR - real    - Air density (kg/m**3)
c               CC - real    - Cloud cover (tenths)
c             CZEN - real    - Cosine of solar zenith angle
c
c --- EXMET called by:  COMP
c --- EXMET calls:      FINDR, FINDI
c----------------------------------------------------------------------
c
      include 'params.puf'
c
      logical ldb2
c
      include 'methd.puf'
      include 'methr.puf'
c
c --- Missing value indicators for integer, real variables
      data imiss/9999/,xmiss/9999./
c
c --- Compute grid point coordinates (m) relative to met. grid origin
      xgrd=(float(ixs)-0.5)*dgrid
      ygrd=(float(iys)-0.5)*dgrid
c
c
c frr (09/01)- Use 2D arrays if available in CALMET
       if(i2dmet.EQ.1) then

          tempk=temp2d(ixs,iys)
          if(iflag.eq.2)then
            qsw=qsw2d(ixs,iys)
            irh=irh2d(ixs,iys)
            rhoair=rho2d(ixs,iys)
            cc=cc2d(ixs,iys)
            czen=czen2d(ixs,iys)
          else
c ---       Flag variables other than temperature as missing
            qsw=xmiss
            irh=imiss
            rhoair=xmiss
            cc=xmiss
            czen=xmiss
         endif

       elseif(i2dmet.EQ.0) then

c ---    ISTA is the surface met. stations closest to grid point (IXS,IYS)
         ista=nears(ixs,iys)
c
c ---    AIR TEMPERATURE (deg. K)
         if(lcalgrd)then
c ---    Use gridded temp. data, if available
            tempk=tmet(ixs,iys,1)
         else
c ---       Use air temp. at closest surface station
            tempk=tempss(ista)
c ---       Find temp. at nearest station with non-missing data
            if(tempk.ge.xmiss)then
               call findr(xssta,yssta,nssta,tempss,xgrd,ygrd,
     1          ista2,tempk,ierr)
c
               if(ierr.eq.1)then
                  write(io6,*)'ERROR in subr. EXMET -- All surface ',
     1            'temp. data missing -- IERR = ',ierr
                  write(io6,*)'TEMPSS = ',(tempss(n),n=1,nssta)
                  write(*,*)
                  stop 'Halted in EXMET -- see list file.'
               endif
            endif
         endif
c
         if(iflag.eq.2)then
c
c ---       SHORT-WAVE RADIATION (W/m**2)
            qsw=qswss(ista)
            if(qsw.ge.xmiss)then
               call findr(xssta,yssta,nssta,qswss,xgrd,ygrd,
     1          ista2,qsw,ierr)
c
               if(ierr.eq.1)then
                  write(io6,*)'ERROR in subr. EXMET -- All surface ',
     1            'short-wave radiation data missing -- IERR = ',ierr
                  write(io6,*)'QSWSS = ',(qswss(n),n=1,nssta)
                  write(*,*)
                  stop 'Halted in EXMET -- see list file.'
               endif
            endif
c
c ---       RELATIVE HUMIDITY (percent)
            irh=irhss(ista)
            if(irh.ge.imiss)then
               call findi(xssta,yssta,nssta,irhss,xgrd,ygrd,
     1          ista2,irh,ierr)
c
               if(ierr.eq.1)then
                  write(io6,*)'ERROR in subr. EXMET -- All surface ',
     1            'relative humidity data missing -- IERR = ',ierr
                  write(io6,*)'IRHSS = ',(irhss(n),n=1,nssta)
                  write(*,*)
                  stop 'Halted in EXMET -- see list file.'
               endif
            endif
c
c ---       AIR DENSITY (kg/m**3)
            rhoair=rhoss(ista)
            if(rhoair.ge.xmiss)then
               call findr(xssta,yssta,nssta,rhoss,xgrd,ygrd,
     1          ista2,rhoair,ierr)
c
               if(ierr.eq.1)then
                  write(io6,*)'ERROR in subr. EXMET -- All surface ',
     1            'air density data missing -- IERR = ',ierr
                  write(io6,*)'RHOSS = ',(rhoss(n),n=1,nssta)
                  write(*,*)
                  stop 'Halted in EXMET -- see list file.'
               endif
            endif
c
c ---       CLOUD COVER (tenths)
            cc=ccss(ista)
            if(cc.ge.xmiss)then
               call findr(xssta,yssta,nssta,ccss,xgrd,ygrd,
     1          ista2,cc,ierr)
c
               if(ierr.eq.1)then
                  write(io6,*)'ERROR in subr. EXMET -- All surface ',
     1            'cloud cover data missing -- IERR = ',ierr
                  write(io6,*)'CCSS = ',(ccss(n),n=1,nssta)
                  write(*,*)
                  stop 'Halted in EXMET -- see list file.'
               endif
            endif
c
c ---       Cosine of solar zenith angle
            czen=czenss(ista)
            if(czen.ge.xmiss)then
               call findr(xssta,yssta,nssta,czenss,xgrd,ygrd,
     1              ista2,czen,ierr)
c
               if(ierr.eq.1)then
                  write(io6,*)'ERROR in subr. EXMET -- All surface ',
     1            'solar zenth data missing -- IERR = ',ierr
                  write(io6,*)'CZENSS = ',(czenss(n),n=1,nssta)
                  write(*,*)
                  stop 'Halted in EXMET -- see list file.'
               endif
            endif
c
         else
c
c ---       Flag variables other than temperature as missing
            qsw=xmiss
            irh=imiss
            rhoair=xmiss
            cc=xmiss
            czen=xmiss
         endif
c
c*****
         ldb2=.false.
         if(ldb2)then
            write(io6,*)
            write(io6,*)'SUBR. EXMET -- iflag = ',iflag,' ixs = ',ixs,
     1      ' iys = ',iys,' dgrid = ',dgrid,' ista = ',ista
           write(io6,*)'tempk = ',tempk,' qsw = ',qsw,' irh = ',irh,
     1      ' rhoair = ',rhoair
            write(io6,*)'cc = ',cc,' czen = ',czen
         endif
c*****
      else
         write(*,*)'Subr. EXMET:  Invalid I2DMET = ',i2dmet
         stop
      endif

      return
      end
c----------------------------------------------------------------------
      subroutine findr(xsta,ysta,nsta,dat,x,y,ista,value,ierr)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 900228                  FINDR
c                J. Scire, SRC
c
c --- PURPOSE:  Find the closest station to a specified (X,Y)
c               coordinate that has non-missing data and pass
c               the real variable at that station back to the
c               calling routine
c
c --- INPUTS:
c       XSTA(nsta) - real    - Array of X coordinates (m) for each
c                              station relative to the met. grid origin
c                              at (0., 0.)
c       YSTA(nsta) - real    - Array of Y coordinates (m) for each
c                              station relative to the met. grid origin
c                              at (0., 0.)
c             NSTA - integer - Number of stations
c        DAT(nsta) - real    - Values of the variable at each station
c                              (NOTE: 9999. used as a missing value
c                              indicator)
c                X - real    - Reference X coordinate (m)
c                Y - real    - Reference Y coordinate (m)
c
c --- OUTPUT:
c             ISTA - integer - Station number of closest station
c            VALUE - real    - Value of from DAT array for closest
c                              station "ISTA"
c             IERR - integer - Error code (0=no error, 1=all data
c                              missing, so VALUE = missing value
c                              indicator
c
c --- FINDR called by:  EXMET, GETOZ
c --- FINDR calls:      none
c----------------------------------------------------------------------
c
      real xsta(nsta),ysta(nsta),dat(nsta)
      data xmax/1.e38/,xmiss/9999./
c
      ista=0
      value=xmiss
      dmin2=xmax
c
      do 10 i=1,nsta
c
c --- Compute the (distance)**2 to each station with non-missing data
      if(dat(i).lt.xmiss)then
         dist2=(xsta(i)-x)**2+(ysta(i)-y)**2
c
c ---    Keep track of the closest station to the reference point
         if(dist2.lt.dmin2)then
            dmin2=dist2
            ista=i
         endif
      endif
10    continue
c
      if(ista.eq.0)then
         ierr=1
         go to 999
      endif
c
c --- Extract the value at closest station from the data array
      value=dat(ista)
      ierr=0
c
999   continue
      return
      end
c----------------------------------------------------------------------
      subroutine findi(xsta,ysta,nsta,idat,x,y,ista,ivalue,ierr)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 900228                  FINDI
c                J. Scire, SRC
c
c --- PURPOSE:  Find the closest station to a specified (X,Y)
c               coordinate that has non-missing data and pass
c               the integer variable at that station back to the
c               calling routine
c
c --- INPUTS:
c       XSTA(nsta) - real    - Array of X coordinates (m) for each
c                              station relative to the met. grid origin
c                              at (0., 0.)
c       YSTA(nsta) - real    - Array of Y coordinates (m) for each
c                              station relative to the met. grid origin
c                              at (0., 0.)
c             NSTA - integer - Number of stations
c       IDAT(nsta) - integer - Values of the variable at each station
c                              (NOTE: 9999 used as a missing value
c                              indicator)
c                X - real    - Reference X coordinate (m)
c                Y - real    - Reference Y coordinate (m)
c
c --- OUTPUT:
c             ISTA - integer - Station number of closest station
c           IVALUE - real    - Value of from IDAT array for closest
c                              station "ISTA"
c             IERR - integer - Error code (0=no error, 1=all data
c                              missing, so VALUE = missing value
c                              indicator
c
c --- FINDI called by:  EXMET
c --- FINDI calls:      none
c----------------------------------------------------------------------
c
      real xsta(nsta),ysta(nsta)
      integer idat(nsta)
      data xmax/1.e38/,imiss/9999/
c
      ista=0
      ivalue=imiss
c
      dmin2=xmax
c
      do 10 i=1,nsta
c
c --- Compute the (distance)**2 to each station with non-missing data
      if(idat(i).lt.imiss)then
         dist2=(xsta(i)-x)**2+(ysta(i)-y)**2
c
c ---    Keep track of the closest station to the reference point
         if(dist2.lt.dmin2)then
            dmin2=dist2
            ista=i
         endif
      endif
10    continue
c
      if(ista.eq.0)then
         ierr=1
         go to 999
      endif
c
c --- Extract the value at closest station from the data array
      ivalue=idat(ista)
      ierr=1
c
999   continue
      return
      end
c----------------------------------------------------------------------
      subroutine fin(itest)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                    FIN
c                J. Scire, SRC
c
c --- PURPOSE:  Run termination routine -- compute runtime,
c               write last day processed
c
c --- UPDATE
c --- V5.721-V5.8.4 130731  (EPA): Add argument to WARN call
c --- V5.7-V5.721   040503  (DGS): Add warning function (call WARN)
c --- V5.5-V5.7     030402  (DGS): Add list file unit to JULDAY call
c                                  Change rdate, rdate2 to include
c                                  YYYY format for year (MM-DD-YYYY)
c --- V5.0-V5.2     991104  (DGS): YYYY year format
c
c --- INPUTS:
c          ITEST - integer - Flag indicating if execution is to
c                            include COMPUTATIONAL phase
c                            (ITEST = 1 to STOP program and skip
c                                       the COMPUTATIONAL phase
c                             ITEST = 2 to CONTINUE execution to
c                                       include computations)
c       Common block /DATEHR/
c          nyr, nmo, nday, njul, nhr
c       Common block /QA/
c          rdate, rtime, rcpu
c       Common block /OUTPT/
c          imesg
c       Parameters: IO6, IOMESG
c
c --- OUTPUT:  none
c
c --- FIN called by:  MAIN
c --- FIN calls:      DATETM, JULDAY, DELTT, YR4C, WARN
c----------------------------------------------------------------------
c
c --- include parameters
      include 'params.puf'
c
      character*8 rtime2
      character*10 rdate2
c
      include 'datehr.puf'
      include 'qa.puf'
      include 'outpt.puf'

c --- Process any warnings collected during the run
      call WARN('FIN         ',0.,0.)
c
      write(iomesg,*)'TERMINATION PHASE'
c
c --- Write last day/hour processed
      if(ITEST.eq.2)then
         write(io6,5)nyr,nmo,nday,njul,nhr
5        format(//2x,'LAST DAY/HOUR PROCESSED:'/5x,'Year: ',i4,2x,
     1   'Month: ',i2,3x,'Day: ',i2,3x,'Julian day: ',i3,3x,'Hour: ',
     2   i2)
      else
c
c ---    TEST mode -- COMPUTATIONAL phase skipped
         write(io6,12)
12       format(/1x,13('----------')//1x,
     1   'Completion of CALPUFF test mode run -- run terminating ',
     2   'normally'//1x,13('----------'))
      endif
c
c --- get system date & time at end of run
      call datetm(rdate2,rtime2,rcpu)
c
c --- compute runtime
      read(rtime(1:2),10)ihr1
      read(rtime(4:5),10)imin1
      read(rtime(7:8),10)isec1
10    format(i2)
      t1=ihr1*3600.+imin1*60.+isec1
c
      read(rtime2(1:2),10)ihr2
      read(rtime2(4:5),10)imin2
      read(rtime2(7:8),10)isec2
      t2=ihr2*3600.+imin2*60.+isec2
c
      if(rdate.eq.rdate2)then
         delt=t2-t1
      else
         read(rdate(1:2),10)imo1
         read(rdate(4:5),10)iday1
         read(rdate(7:10),'(i4)')iyr1
         call julday(io6,iyr1,imo1,iday1,ijul1)
c
         read(rdate2(1:2),10)imo2
         read(rdate2(4:5),10)iday2
         read(rdate2(7:10),'(i4)')iyr2
         call julday(io6,iyr2,imo2,iday2,ijul2)
c
c ---    compute no. hours from beg. of first hour of run to
c ---    ending hour of ending day of the run
         call deltt(iyr1,ijul1,ihr1,iyr2,ijul2,ihr2,idelhr)
c
c ---    adjust for minutes and seconds
         delt=idelhr*3600.-imin1*60.-isec1+imin2*60.+isec2
      endif

c --- On the PC, the runtime and CPU time are the same
c --- (DATETM provides RCPU = 0.0 on the PC)
      if(rcpu.EQ.0.0)rcpu=delt

c --- Report current date
      write(io6,1402)rtime2,rdate2,delt,rcpu
1402  format(//2x,'End of run -- Clock time: ',a8/
     1         2x,'                    Date: ',a10//
     2         2x,'      Elapsed Clock Time: ',f10.1,' (seconds)'//
     3         2x,'                CPU Time: ',f10.1,' (seconds)')
c
      return
      end
c----------------------------------------------------------------------
      subroutine met1(nx,ny,lecho,wrk1,nwork,ibyr,ibmo,ibdy,ibhr,irlg)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                   MET1
c                J. Scire, SRC
c
c --- PURPOSE:  Read header records of the CALMET meteorological
c               data file
c
c --- UPDATE
c --- V5.5-V5.7     030402  (DGS): Add list file unit to YR4 call
c                   030402  (DGS): Change (f6) to (f6.0)
c                   030402  (DGS): Add echo of CALMET control file (new
c                                  header format)
c                   030402  (DGS): Add DVERSM (dataset version) to
c                                  /METHD/ and use throughout code to
c                                  identify CALMET.DAT format, and
c                                  compute I2DMET here
c --- V5.4-V5.5     010730  (JSS): include IWAT2 on list file output
c --- V5.4-V5.4     000602_4(DGS): pass base time zone into /METHD/
c --- V5.2-V5.4     000602  (DGS): add message to "stop"
c                   000602  (DGS): add version check for record '2a'
c --- V5.0-V5.2     991104  (DGS): YYYY year format
c --- V5.0-V5.0     990228a (DGS): add IEOF to RDR2D arguments
c --- V5.0-V5.0     980304  (DGS): accept new/old CALMET headers
c --- V4.0-V5.0     971107  (DGS): pass start-time from met file
c                                  for use if METRUN=1
c
c --- INPUTS:
c            NX - integer       - Number of X cells in meteorological
c                                 grid
c            NY - integer       - Number of Y cells in meteorological
c                                 grid
c         LECHO - logical       - Control variable for output of header
c                                 record information
c   WRK1(nwork) - real array    - Work array of length "NWORK" words
c         NWORK - integer       - Dimension of work arrays -- NOTE:
c                                 NWORK must be at least as large as
c                                 nx*ny
c     Parameters:
c           MXNZP1, MXSS, MXUS, MXPS, IO6
c
c --- OUTPUT:
c     Common block /METHD/ variables:
c           NXM, NYM, NZM, XGRIDM, XORIGM, YORIGM, XBTZM,
c           NSSTA, NPSTA, NLU, IWAT1, IWAT2, ZFACEM(mxnzp1),
c           XSSTA(mxss),YSSTA(mxss),XUSTA(mxus),YUSTA(mxus),
c           XPSTA(mxps),YPSTA(mxps),Z0(mxnx,mxny),ILANDU(mxnx,mxny),
c           ELEV(mxnx,mxny),XLAI(mxnx,mxny),NEARS(mxnx,mxny),
c           LCALGRD,
c           dversm,i2dmet
c           levmet, llconfm, xlat1m, xlat2m, rlat0m, rlon0m
c           iutmznm,feastm,fnorthm,pmapm,datumm,datenm,utmhemm
c
c --- MET1 called by:  SETUP
c --- MET1 calls:      RDR1D, RDR2D, RDI2D, METQA, OUT, YR4
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
      real wrk1(nwork)
      character*80 title(3)
      character*70 messag
      character*8 vermet,clab1,clab2
      character*8 clabexp,clabex1,clabex2
      logical ldate,lecho

c --- Control for printing entire CALMET control file
      logical lmetcf
c
c --- Include common block /METHD/ -- CALMET header record data
      include 'methd.puf'

c --- Local Variables
      character*16 dataset,dataver
      character*33 blank33
      character*64 datamod
      character*80 doc1
      character*132 comment1,blank

      data ldate/.false./
      data lmetcf/.false./
      data blank33/'                                 '/

c --- Set blank (132 characters)
      blank(1:33)=blank33
      blank(34:66)=blank33
      blank(67:99)=blank33
      blank(100:132)=blank33

c --- Read and test first record to determine header format
c --- Record #1 - File Declaration -- 24 words
      read(io7) dataset,dataver,datamod
      ifilver=0
      if(dataset.EQ.'CALMET.DAT') ifilver=1
      REWIND(io7)

      if(lecho) then
         write(io6,*)
         write(io6,*)
         write(io6,*)
         write(io6,*)'CALMET Control file information:'
         write(io6,*)'--------------------------------'
         write(io6,*)
      endif

c --- Read records
c ----------------
c
      if(ifilver.EQ.1) then
        i2dmet=1
c
c ---   Record #1 - File Declaration -- 24 words
        read(io7) dataset,dataver,datamod
        if(lecho) write(io6,'(2a16,a64)') dataset,dataver,datamod
        read(dataver,'(f16.0)') dversm
c
c ---   Record #2 - Number of comment lines -- 1 word
        read(io7) ncom
c ---   Loop over comment records
        do i=1,ncom
          comment1=blank
          read(io7) comment1
          if(i.EQ.1) then
c ---       Save model version line
            doc1=comment1(1:80)
          elseif(i.LE.4) then
c ---       Save 3 title lines
            title(i-1)=comment1(1:80)
          endif
          if(lmetcf) write(io6,*) comment1
        enddo
        if(lecho .AND. .NOT.lmetcf) then
           write(io6,*)
           write(io6,*) doc1
           write(io6,*) title(1)
           write(io6,*) title(2)
           write(io6,*) title(3)
           write(io6,*)
        endif
c
c ---   record #NCOM+3 - run control parameters -- 37 words
        read(io7) ibyr,ibmo,ibdy,ibhr,ibtzm,irlg,irtype,
     1   nxm, nym, nzm, xgridm, xorigm, yorigm, iwfcod, nssta,
     2   nusta, npsta, nowsta, nlu, iwat1, iwat2, lcalgrd,
     3   pmapm,datumm,datenm,feastm,fnorthm,utmhemm,iutmznm,
     4   rnlat0m,relon0m,xlat1m,xlat2m

        rlat0m=rnlat0m
        rlon0m=-relon0m

      endif
c
      if(ifilver.EQ.0) then
c
c ---   Read older CALMET header records
        dversm=0.0
        i2dmet=0
c
c ---   record #1 - run title -- 60 words
        read(io7)title
c
c ---   record #2 - run control parameters -- 26 words
c ---   (vermet, levmet are both 8 bytes)
        read(io7)vermet,levmet,ibyr,ibmo,ibdy,ibhr,ibtzm,irlg,irtype,
     1   nxm, nym, nzm, xgridm, xorigm, yorigm, iutmznm, iwfcod, nssta,
     2   nusta, npsta, nowsta, nlu, iwat1, iwat2, lcalgrd

        if(lecho) then
           write(io6,104)vermet,levmet
104        format(1x,'CALMET Version: ',a8,3x,'Level: ',a8)
        endif

c ---   Enforce YYYY format
        call YR4(io6,ibyr,ierrb)
        if(ierrb.NE.0) then
           write(*,*)
           stop 'Halted in MET1'
        endif
c
c ---   New record -- #3 - additional run control data -- 8 words
c ---   Null values are assigned in block data
c ---   This record was introduced in CALMET Version 5.0 (980304)
        read(levmet(1:6),'(i6)') ilevmet
        read(vermet(1:6),'(f6.0)') rvermet
        if(ilevmet.GE.980304 .OR. rvermet.GT.5.1) then
           read(io7)xlat0m,xlon0m,llconfm,conecm,xlat1m,xlat2m,
     &              rlat0m,rlon0m
        endif
c
c ---   Recast map projection information
        if(LLCONFM) then
           pmapm='LCC     '
        else
           pmapm='UTM     '
           UTMHEMM='N   '
           if(xlat0m.LT.0.) UTMHEMM='S   '
        endif
c ---   Set datum to unknown
        datumm='unknown'

      endif

c --- Place integer IBTZM into real XBTZM
      xbtzm=FLOAT(ibtzm)
c
      if(LECHO)then
         write(io6,*)
         write(io6,*)
         write(io6,*)' IBYR    = ',ibyr
         write(io6,*)' IBMO    = ',ibmo
         write(io6,*)' IBDY    = ',ibdy
         write(io6,*)' IBHR    = ',ibhr
         write(io6,*)' IBTZM   = ',ibtzm
         write(io6,*)' IRLG    = ',irlg
         write(io6,*)' IRTYPE  = ',irtype
         write(io6,*)' LCALGRD = ',lcalgrd
         write(io6,*)' PMAP    = ',pmapm
         write(io6,*)' DATUM   = ',datumm
         write(io6,*)' NIMADATE= ',datenm
         write(io6,*)' FEASTM  = ',feastm
         write(io6,*)' FNORTHM = ',fnorthm
         if(PMAPM.EQ.'UTM     ') then
            write(io6,*)' IUTMZN  = ',iutmznm
            write(io6,*)' UTMHEM  = ',utmhemm
         else
            write(io6,*)' XLAT1M  = ',xlat1m
            write(io6,*)' XLAT2M  = ',xlat2m
            write(io6,*)' RLAT0M  = ',rlat0m
            write(io6,*)' RLON0M  = ',rlon0m
         endif
         write(io6,*)' NXM     = ',nxm
         write(io6,*)' NYM     = ',nym
         write(io6,*)' NZM     = ',nzm
         write(io6,*)' XGRIDM  = ',xgridm
         write(io6,*)' XORIGM  = ',xorigm
         write(io6,*)' YORIGM  = ',yorigm
         write(io6,*)' IWFCOD  = ',iwfcod
         write(io6,*)' NSSTA   = ',nssta
         write(io6,*)' NUSTA   = ',nusta
         write(io6,*)' NPSTA   = ',npsta
         write(io6,*)' NOWSTA  = ',nowsta
         write(io6,*)' NLU     = ',nlu
         write(io6,*)' IWAT1   = ',iwat1
         write(io6,*)' IWAT2   = ',iwat2

      endif
c
c --- Check that enough workspace has been allocated
      nec=nxm*nym
      if(nwork.lt.nec)then
         write(io6,*)'ERROR in subr. MET1 -- insufficient workspace ',
     1   'allocated to work arrays -- Allocated (NWORK) = ',nwork,
     2   '   Required (NEC) = ',nec
         write(*,*)
         stop 'Halted in MET1 -- see list file.'
      endif
c
      nzmp1=nzm+1
      if(mxnzp1.lt.nzmp1)then
         write(io6,*)'ERROR in subr. MET1 -- dimension of ZFACEM ',
     1   'array is too small for no. layers in MET file'
         write(io6,*)'MXNZP1 = ',mxnzp1,' NZMP1 = ',nzmp1
         write(*,*)
         stop 'Halted in MET1 -- see list file.'
      endif

c -------------------------------------
c
c --- record #NCOM+4 - cell face heights (NZ + 1 words)
      call rdr1d(io7,zfacem,nzmp1,clab1,idum)
c
      if(LECHO)then
         write(io6,203)(zfacem(n),n=1,nzmp1)
203      format(1x,'ZFACEM  = ',10(f9.3,', ')/)
      endif
c
c --- Check that record label matches expected label
      if(clab1.ne.'ZFACE')then
         clabexp='ZFACE'
         go to 999
      endif
c -------------------------------------
c
c ************************************************
c --- Perform QA checks on header record variables
c ************************************************
      call metqa

      nums=nssta+nusta+npsta
      if(lecho .AND. nums.GT.0) then
         write(io6,*)'Met Station Locations (Met Grid meters)'
      endif
c
c --- records #NCOM+5 & 6 - x, y coordinates of surface stations
c --- (NSSTA words each record)
      if(nssta.gt.0)then
         call rdr1d(io7,xssta,nssta,clab1,idum)
         call rdr1d(io7,yssta,nssta,clab2,idum)
         if(LECHO)then
            write(io6,*)clab1,' = ',(xssta(n),n=1,nssta)
            write(io6,*)clab2,' = ',(yssta(n),n=1,nssta)
         endif
c
c ---    Check that record labels matches expected labels
         if(clab1.ne.'XSSTA'.or.clab2.ne.'YSSTA')then
            clabex1='XSSTA'
            clabex2='YSSTA'
            go to 1999
         endif
      endif
c -------------------------------------
c
c --- records #NCOM+7 & 8 - x, y coordinates of upper air stations
c --- (NUSTA words each record)
      if(nusta.gt.0)then
         call rdr1d(io7,xusta,nusta,clab1,idum)
         call rdr1d(io7,yusta,nusta,clab2,idum)
         if(LECHO)then
            write(io6,*)clab1,' = ',(xusta(n),n=1,nusta)
            write(io6,*)clab2,' = ',(yusta(n),n=1,nusta)
         endif
c
c ---    Check that record labels matches expected labels
         if(clab1.ne.'XUSTA'.or.clab2.ne.'YUSTA')then
            clabex1='XUSTA'
            clabex2='YUSTA'
            go to 1999
         endif
      endif
c -------------------------------------
c
c --- records #NCOM+9 & 10 - x, y coordinates of precipitation stations
c --- (NPSTA words each record)
      if(npsta.gt.0)then
         call rdr1d(io7,xpsta,npsta,clab1,idum)
         call rdr1d(io7,ypsta,npsta,clab2,idum)
         if(LECHO)then
            write(io6,*)clab1,' = ',(xpsta(n),n=1,npsta)
            write(io6,*)clab2,' = ',(ypsta(n),n=1,npsta)
         endif
c
c ---    Check that record labels matches expected labels
         if(clab1.ne.'XPSTA'.or.clab2.ne.'YPSTA')then
            clabex1='XPSTA'
            clabex2='YPSTA'
            go to 1999
         endif
      endif
c -------------------------------------
c
c --- record #NCOM+11 - surface roughness lengths (NX * NY words)
      call rdr2d(io7,z0,wrk1,mxnx,mxny,nx,ny,clab1,idum,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'MET1: Unexpected EOF in CALMET header'
      endif
      if(LECHO)then
         messag='Surface roughness lengths (m)'
         messag(63:70)=clab1
         call out(z0,idum,1,5,ldate,messag,nx,ny)
      endif
c
c --- Check that record label matches expected label
      if(clab1.ne.'Z0')then
         clabexp='Z0'
         go to 999
      endif
c -------------------------------------
c
c --- record #NCOM+12 - land use categories (NX * NY words)
      call rdi2d(io7,ilandu,wrk1,mxnx,mxny,nx,ny,clab1,idum)
      if(LECHO)then
         messag='Land use categories'
         messag(63:70)=clab1
         call out(xdum,ilandu,2,5,ldate,messag,nx,ny)
      endif
c
c --- Check that record label matches expected label
      if(clab1.ne.'ILANDU')then
         clabexp='ILANDU'
         go to 999
      endif
c -------------------------------------
c
c --- record #NCOM+13 - elevations (NX * NY words)
      call rdr2d(io7,elev,wrk1,mxnx,mxny,nx,ny,clab1,idum,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'MET1: Unexpected EOF in CALMET header'
      endif
      if(LECHO)then
         messag='Terrain heights (m)'
         messag(63:70)=clab1
         call out(elev,idum,1,5,ldate,messag,nx,ny)
      endif
c
c --- Check that record label matches expected label
      if(clab1.ne.'ELEV')then
         clabexp='ELEV'
         go to 999
      endif
c -------------------------------------
c
c --- record #NCOM+14 - leaf area index (NX * NY words)
      call rdr2d(io7,xlai,wrk1,mxnx,mxny,nx,ny,clab1,idum,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'MET1: Unexpected EOF in CALMET header'
      endif
      if(LECHO)then
         messag='Leaf area index'
         messag(63:70)=clab1
         call out(xlai,idum,1,5,ldate,messag,nx,ny)
      endif
c
c --- Check that record label matches expected label
      if(clab1.ne.'XLAI')then
         clabexp='XLAI'
         go to 999
      endif
c -------------------------------------
c
c --- record #NCOM+15 - nearest surface station to each grid point
c                  (NX * NY words)
c frr (09/01)
      if (nssta.ge.1) then
         call rdi2d(io7,nears,wrk1,mxnx,mxny,nx,ny,clab1,idum)
         if(LECHO)then
           messag='Nearest surface station no. to each grid point'
           messag(63:70)=clab1
           call out(xdum,nears,2,5,ldate,messag,nx,ny)
         endif
c
c ---    Check that record label matches expected label
         if(clab1.ne.'NEARS')then
            clabexp='NEARS'
            go to 999
         endif

      endif

c -------------------------------------
c
      return
c
c --- Write error messages -- incorrect record label read
999   continue
      write(io6,1001)clab1,clabexp
1001  format(/1x,'ERROR in subr. MET1 -- incorrect record label ',
     1 'read from MET data file'//1x,'Label read     = ',a8/
     2                               1x,'Label expected = ',a8)
      write(*,*)
      stop 'Halted in MET1 -- see list file.'
1999  continue
      write(io6,2001)clab1,clab2,clabex1,clabex2
2001  format(/1x,'ERROR in subr. MET1 -- incorrect record label ',
     1 'read from MET data file'//
     2 1x,'Labels read     = ',a8,2x,a8/
     3 1x,'Labels expected = ',a8,2x,a8)
      write(*,*)
      stop 'Halted in MET1 -- see list file.'
c
      end
c----------------------------------------------------------------------
      subroutine metqa
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030528                  METQA
c                J. Scire, SRC
c
c --- PURPOSE:  Perform consistency checks of data read from the
c               CALMET header records with control file inputs
c
c --- UPDATE
c --- V5.7-V5.71    030528  (DGS): remove old UTM check that does
c                                  not screen out PMAP.NE.UTM cases
c --- V5.4-V5.7     030402  (DGS): add map projection and datum
c --- V5.4-V5.4     000602_4(DGS): add base time zone check
c --- V5.3-V5.4     000602  (DGS): add message to "stop"
c
c --- INPUTS:
c     Common block /DATEHR/ variables:
c           XBTZ
c     Common block /GRID/ variables:
c           NX, NY, NZ, DGRID, XORIG, YORIG, ZFACE(mxnzp1)
c     Common block /MAP/ variables:
c           lutm,llcc,lps,lem,llaza,lttm,
c           iutmzn,feast,fnorth,
c           rlat0,rlon0,xlat1,xlat2,
c           pmap,utmhem,datum,daten
c     Common block /METHD/ variables:
c           NXM, NYM, NZM, XGRIDM, XORIGM, YORIGM, XBTZM,
c           NSSTA, NUSTA, NPSTA, ZFACEM(mxnzmp1)
c           iutmznm,feastm,fnorthm,
c           rlat0m,rlon0m,xlat1m,xlat2m,
c           pmapm,utmhemm,datumm,
c           dversm
c     Parameters:
c           MXNZP1, MXNZMP1, MXSS, MXUS, MXPS, IO6
c
c --- OUTPUT:
c         none
c
c --- METQA called by:  MET1
c --- METQA calls:      LRSAME
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
c --- Include common blocks
      include 'datehr.puf'
      include 'grid.puf'
      include 'map.puf'
      include 'methd.puf'

      logical lrsame

c --- Initialize error flag
      ierr=0
c
c --- No. X, Y grid cells
      if(nx.ne.nxm)then
         write(io6,102)
102      format(/1x,'ERROR in subr. METQA -- MET header record ',
     1   'data is inconsistent with the control file input')
         write(io6,*)'NX = ',nx,' NXM = ',nxm
         ierr=1
      endif
      if(ny.ne.nym)then
         write(io6,102)
         write(io6,*)'NY = ',ny,' NYM = ',nym
         ierr=1
      endif
      if(nz.ne.nzm)then
         write(io6,102)
         write(io6,*)'NZ = ',nz,' NZM = ',nzm
         ierr=1
      endif
c
c --- Vertical face heights
      nzp1=nz+1
      do 35 i=1,nzp1
      if(abs(zface(i)-zfacem(i)).gt.0.1)then
         write(io6,102)
         write(io6,*)'I         = ',i
         write(io6,*)'ZFACE(i)  = ',zface(i)
         write(io6,*)'ZFACEM(i) = ',zfacem(i)
         ierr=1
      endif
35    continue
c
c --- Grid size
      if(abs(xgridm-dgrid).gt.0.1)then
         write(io6,102)
         write(io6,*)'DGRID = ',dgrid,' XGRIDM = ',xgridm
         ierr=1
      endif
c
c --- Grid reference coordinates
      if(abs(xorigm-xorig).gt.1.0)then
         write(io6,102)
         write(io6,*)'XORIG = ',xorig,' XORIGM = ',xorigm
         ierr=1
      endif
      if(abs(yorigm-yorig).gt.1.0)then
         write(io6,102)
         write(io6,*)'YORIG = ',yorig,' YORIGM = ',yorigm
         ierr=1
      endif
c
c --- MXSS in CALPUFF parameter file must be at least as large as
c     the number of surface stations used in the CALMET run
      if(nssta.gt.mxss)then
         write(io6,106)nssta,mxss
106      format(/1x,'ERROR in subr. METQA -- NSSTA read from ',
     1   'MET header record is greater than MXSS in the CALPUFF ',
     2   'parameter file'/1x,'NSSTA = ',i6,3x,'MXSS = ',i6)
         ierr=1
      endif
      if(nusta.gt.mxus)then
         write(io6,116)nusta,mxus
116      format(/1x,'ERROR in subr. METQA -- NUSTA read from ',
     1   'MET header record is greater than MXUS in the CALPUFF ',
     2   'parameter file'/1x,'NUSTA = ',i6,3x,'MXUS = ',i6)
         ierr=1
      endif
      if(npsta.gt.mxps)then
         write(io6,126)npsta,mxps
126      format(/1x,'ERROR in subr. METQA -- NPSTA read from ',
     1   'MET header record is greater than MXPS in the CALPUFF ',
     2   'parameter file'/1x,'NPSTA = ',i6,3x,'MXPS = ',i6)
         ierr=1
      endif
c
c --- Base time zone
      if(xbtzm.ne.xbtz)then
         write(io6,102)
         write(io6,*)'XBTZ(control file) = ',xbtz
         write(io6,*)'IBTZM(Met file)    = ',xbtzm
         ierr=1
      endif

c --- Projection checks
      if(pmapm.NE.pmap) then
         write(io6,102)
         write(io6,*)'         Map projection PMAP does not match'
         write(io6,*)'         Met file    : ',pmapm
         write(io6,*)'         Control file: ',pmap
         ierr=1
      endif
      if(LUTM) then
         if(iutmznm.NE.iutmzn)then
            write(io6,102)
            write(io6,*)'         UTM zone does not match'
            write(io6,*)'         Met file    : ',iutmznm
            write(io6,*)'         Control file: ',iutmzn
            ierr=1
         endif
         if(utmhemm.NE.utmhem)then
            write(io6,102)
            write(io6,*)'         UTM Hemisphere does not match'
            write(io6,*)'         Met file    : ',utmhemm
            write(io6,*)'         Control file: ',utmhem
            ierr=1
         endif
      else
c ---    Check false origin variables
         if(.not.LRSAME(0.0001,feastm,feast))then
            write(io6,102)
            write(io6,*)'         FEAST does not match'
            write(io6,*)'         Met file    : ',feastm
            write(io6,*)'         Control file: ',feast
            ierr=1
         endif
         if(.not.LRSAME(0.0001,fnorthm,fnorth))then
            write(io6,102)
            write(io6,*)'         FNORTH does not match'
            write(io6,*)'         Met file    : ',fnorthm
            write(io6,*)'         Control file: ',fnorth
            ierr=1
         endif
c ---    Check lat/lon variables
         if(.not.LRSAME(0.0001,rlat0m,rlat0))then
            write(io6,102)
            write(io6,*)'         RLAT0 does not match'
            write(io6,*)'         Met file    : ',rlat0m
            write(io6,*)'         Control file: ',rlat0
            ierr=1
         endif
         if(.not.LRSAME(0.0001,rlon0m,rlon0))then
            write(io6,102)
            write(io6,*)'         RLON0 does not match'
            write(io6,*)'         Met file    : ',rlon0m
            write(io6,*)'         Control file: ',rlon0
            ierr=1
         endif
         if(LLCC) then
            if(.not.LRSAME(0.0001,xlat1m,xlat1))then
               write(io6,102)
               write(io6,*)'         XLAT1 does not match'
               write(io6,*)'         Met file    : ',xlat1m
               write(io6,*)'         Control file: ',xlat1
               ierr=1
            endif
            if(.not.LRSAME(0.0001,xlat2m,xlat2))then
               write(io6,102)
               write(io6,*)'         XLAT2 does not match'
               write(io6,*)'         Met file    : ',xlat2m
               write(io6,*)'         Control file: ',xlat2
               ierr=1
            endif
         endif
      endif

c --- DATUM
      if(dversm.LT.1.) then
c ---    Assign CALPUFF datum to met datumm
         datumm=datum
      elseif(datumm.NE.datum)then
         write(io6,102)
         write(io6,*)'         DATUM does not match'
         write(io6,*)'         Met file    : ',datumm
         write(io6,*)'         Control file: ',datum
         ierr=1
      endif

c --- Stop execution if any errors encountered
      if(ierr.eq.1) then
         write(*,*)
         stop 'Halted in METQA -- see list file.'
      endif
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdmet(idathr,wrk1,nwork,lecho,umet,vmet,tmet,ipgt,
     1 htmix,ustar,xmonin,wstar,rmm,tempss,rhoss,qswss,irhss,ipcode,
     2 temp2d,rho2d,qsw2d,irh2d,ipcode2d,wdiv)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                  RDMET
c                J. Scire, SRC
c
c --- PURPOSE:  Read CALMET meteorological data for one hour
c
c --- UPDATE
c --- V5.5-V5.7     030402  (DGS): Add list file unit to YR4 call
c                   030119  (FRR): bug fix to make sure ipcode2d data
c                                  is read in when npsta=-1
c
c ---               090101  (FRR): read CALMET records V5.3, level 010901
c frr (09/01)
c ---  Different format after CALMET version V5.3 - Level 010901
c ---  NOOBS mode allowed (no upper and possibly no surface stations)
c ---  2D records of sf Temp, RH, IPCODE, RHO, QS (previously 1-D)
c ---  Precipitation data if NPSTA>0 or NPSTA=-1 (prognostic rain data)
c ---
c --- V5.2-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.2     991104  (DGS): YYYY format used for year
c --- V5.0-V5.0     990228a (DGS): add IEOF to RDR2D arguments and add
c                                  NEXTFIL to open next CALMET file
c --- V5.0-V5.0     990228  (DGS): correct dimension in call to RDR2D
c                                  for w-field
c --- V4.0-V5.0     971107  (DGS): store w for vertical divergence field
c                   971107  (DGS): add record-skip logic from COMP to
c                                  find current date-time
c
c --- INPUTS:
c        IDATHR - integer       - Date & hour of required data
c                                 (YYYYJJJHH)
c   WRK1(nwork) - real array    - Work array of length "NWORK" words
c         NWORK - integer       - Dimension of work array -- NOTE:
c                                 NWORK must be at least as large as
c                                 the max. of (NXM * NYM or NSSTA)
c         LECHO - logical       - Flag controlling printing of input
c                                 meteorological data fields
c    Common block /METHD/ variables:
c         NXM, NYM, NZM, NSSTA, NPSTA, LCALGRD, I2DMET
c    Parameters:
c         MXNZMP1, IO6
c
c --- OUTPUT:
c
c   UMET(mxnx,mxny,mxnz) - real    - U component of the wind (m/s)
c                                    at each grid point
c   VMET(mxnx,mxny,mxnz) - real    - V-component of the wind (m/s)
c   TMET(mxnx,mxny,mxnz) - real    - 3-D temperature field (deg. K)
c        IPGT(mxnx,mxny) - integer - PGT stability class
c       HTMIX(mxnx,mxny) - real    - Mixing height (m)
c       USTAR(mxnx,mxny) - real    - Surface friction velocity (m/s)
c      XMONIN(mxnx,mxny) - real    - Monin-Obukhov length (m)
c       WSTAR(mxnx,mxny) - real    - Convective velocity scale (m/s)
c         RMM(mxnx,mxny) - real    - Precipitation rate (mm/hr)
c          TEMPSS(mxss) - real    - Air temperature (deg. K) at
c                                    each surface met. station
c           RHOSS(mxss) - real    - Air density (kg/m**3)
c           QSWSS(mxss) - real    - Short wave solar radiation
c                                    (W/m**2)
c           IRHSS(mxss) - integer - Relative humidity (percent)
c          IPCODE(mxss) - integer - Precipitation code at each surface
c                                    station
c      TEMP2D(mxnx,mxny) - real    - Air temperature (deg. K)
c       RHO2D(mxnx,mxny) - real    - Air density (kg/m**3)
c       QSW2D(mxnx,mxny) - real    - Short wave solar radiation
c                                    (W/m**2)
c       IRH2D(mxnx,mxny) - integer - Relative humidity (percent)
c    IPCODE2D(mxnx,mxny) - integer - Precipitation code
c                 KDATHR - integer - Date of hour of data (YYYYJJJHH)
c   WDIV(mxnx,mxny,mxnz) - real    - Vertical divergence dw/dz; this
c                                    array holds the w-data here
c
c --- RDMET called by:  COMP
c --- RDMET calls:      RDR1D, RDR2D, RDI1D, RDI2D, OUT, NEXTFIL, YR4
c----------------------------------------------------------------------
c
c --- Include parameter statements
      include 'params.puf'
c
c --- Include common /METHD/ -- met. data parameters
      include 'methd.puf'
c
      real umet(mxnx,mxny,mxnz),vmet(mxnx,mxny,mxnz)
      real tmet(mxnx,mxny,mxnz)
      real htmix(mxnx,mxny),ustar(mxnx,mxny),xmonin(mxnx,mxny)
      real wstar(mxnx,mxny),rmm(mxnx,mxny)
      real wrk1(nwork)
c frr (09/01)in noobs mode, nssta can be = 0 => dimension with mxss
c     real tempss(nssta),rhoss(nssta),qswss(nssta)
      real tempss(mxss),rhoss(mxss),qswss(mxss)
      real wdiv(mxnx,mxny,mxnz)
c
c frr (09/01) - additional 2D arrays for temp,rh,rho,ipcode,qsw
      real    temp2d(mxnx,mxny),rho2d(mxnx,mxny),qsw2d(mxnx,mxny)
      integer irh2d (mxnx,mxny),ipcode2d(mxnx,mxny)
      real    rdum(mxnx,mxny)

c frr (09/01)in noobs mode, nssta can be = 0 => dimension with mxss
c     integer ipgt(mxnx,mxny),irhss(nssta),ipcode(nssta)
      integer ipgt(mxnx,mxny),irhss(mxss),ipcode(mxss)
c
      character*70 messag
      character*8 clabel
      character*8 clabexp
c
      logical lecho,ldate
c
      data ldate/.false./
c
c --- Check that enough workspace has been allocated
      nec=max0(nxm*nym,nssta)
      if(nwork.lt.nec)then
         write(io6,*)'ERROR in subr. RDMET -- insufficient workspace ',
     1   'allocated to work arrays -- Allocated (NWORK) = ',nwork,
     2   '   Required (NEC) = ',nec
         write(*,*)
         stop 'Halted in RDMET -- see list file.'
      endif

c --- Begin reading data records for one time period
1     continue

c
c --- read the U, V wind components
      kdathr=0
      do 10 iz=1,nzm
      call rdr2d(io7,umet(1,1,iz),wrk1,mxnx,mxny,nxm,nym,clabel,
     1 ndathr1,ieof)
      if(ieof.EQ.1) then
c ---    Reached end of CALMET.DAT file; check for another file
         call NEXTFIL(nxm,nym,ifound)
         if(ifound.EQ.1) then
            goto 1
         else
            write(*,*)
            stop 'RDMET: Unexpected EOF in CALMET records'
         endif
      endif
c
c --- Check that record label matches expected label
      clabexp='U-LEV'
      write(clabexp(6:8),'(i3)')iz
      if(clabel.ne.clabexp)go to 999
c

      call rdr2d(io7,vmet(1,1,iz),wrk1,mxnx,mxny,nxm,nym,clabel,
     1 ndathr2,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'RDMET: Unexpected EOF in CALMET records'
      endif
      clabexp(1:1)='V'
      if(clabel.ne.clabexp)go to 999
c

c --- Use the W wind component (conditional) for w-divergence
      if(lcalgrd)then
         call rdr2d(io7,wdiv(1,1,iz),wrk1,mxnx,mxny,nxm,nym,clabel,
     1              ndathr3,ieof)
         if(ieof.EQ.1) then
            write(*,*)
            stop 'RDMET: Unexpected EOF in CALMET records'
         endif
         clabexp(1:5)='WFACE'
         if(clabel.ne.clabexp)go to 999
         if(ndathr2.ne.ndathr3)go to 2999
      endif
c

c --- Check for consistency of date/time
      if(ndathr1.ne.ndathr2)go to 2999
      if(kdathr.eq.0)then
c ---    first vertical level
         kdathr=ndathr1
      else if(ndathr1.ne.kdathr)then
c ---    date/time does not match value for previous layer
         ndathr=ndathr1
         go to 3999
      endif
10    continue
c
c --- Read the 3-D temperature field
      if(lcalgrd)then
         clabexp='T-LEV'
         do 12 iz=1,nzm
         call rdr2d(io7,tmet(1,1,iz),wrk1,mxnx,mxny,nxm,nym,clabel,
     1    ndathr,ieof)
         if(ieof.EQ.1) then
            write(*,*)
            stop 'RDMET: Unexpected EOF in CALMET records'
         endif
c
         write(clabexp(6:8),'(i3)')iz
         if(clabel.ne.clabexp)go to 999
         if(ndathr.ne.kdathr)go to 3999
12       continue
      endif
c

c --- read other 2-D meteorological fields
c
c --- PGT stability class
      call rdi2d(io7,ipgt,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr)
      clabexp='IPGT'
      if(clabel.ne.clabexp)go to 999
      if(ndathr.ne.kdathr)go to 3999
c
c --- FRICTION VELOCITY
      call rdr2d(io7,ustar,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'RDMET: Unexpected EOF in CALMET records'
      endif
      clabexp='USTAR'
      if(clabel.ne.clabexp)go to 999
      if(ndathr.ne.kdathr)go to 3999
c
c --- MIXING HEIGHT
      call rdr2d(io7,htmix,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'RDMET: Unexpected EOF in CALMET records'
      endif
      clabexp='ZI'
      if(clabel.ne.clabexp)go to 999
      if(ndathr.ne.kdathr)go to 3999
c
c --- MONIN-OBUKHOV LENGTH
      call rdr2d(io7,xmonin,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'RDMET: Unexpected EOF in CALMET records'
      endif
      clabexp='EL'
      if(clabel.ne.clabexp)go to 999
      if(ndathr.ne.kdathr)go to 3999
c
c --- CONVECTIVE VELOCITY SCALE
      call rdr2d(io7,wstar,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
      if(ieof.EQ.1) then
         write(*,*)
         stop 'RDMET: Unexpected EOF in CALMET records'
      endif
      clabexp='WSTAR'
      if(clabel.ne.clabexp)go to 999
      if(ndathr.ne.kdathr)go to 3999
c
c --- PRECIPITATION DATA
c frr (09/01) - Additional option: if NPSTA=-1, prognostic gridded rain data
c      if(npsta.gt.0)then
      if(npsta.ne.0)then
         call rdr2d(io7,rmm,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
         if(ieof.EQ.1) then
            write(*,*)
            stop 'RDMET: Unexpected EOF in CALMET records'
         endif
      endif

c
c frr (09/01)
c --- NOOBS CALMET: full 2-D fields of the following variables instead
c --- of 1-D fields (values at the surface stations only)
c           - Air temperature (deg. K),
c           - Air density (kg/m**3),
c           - Short-wave solar radiation (W/m**2),
c           - Relative humidity (percent),
c           - Precipitation code

      if(i2dmet.EQ.1) then

c ---   New CALMET output format - 2D arrays -
c       call rdr1d(io7,tempss,nssta,clabel,ndathr)
        call rdr2d(io7,temp2d,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
        if(ieof.EQ.1) then
           write(*,*)
           stop 'RDMET: Unexpected EOF in CALMET records'
        endif
        clabexp='TEMPK'
        if(clabel.ne.clabexp)go to 999
        if(ndathr.ne.kdathr)go to 3999
c
c       call rdr1d(io7,rhoss,nssta,clabel,ndathr)
        call rdr2d(io7,rho2d,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
        if(ieof.EQ.1) then
           write(*,*)
           stop 'RDMET: Unexpected EOF in CALMET records'
        endif
        clabexp='RHO'
        if(clabel.ne.clabexp)go to 999
        if(ndathr.ne.kdathr)go to 3999
c
c       call rdr1d(io7,qswss,nssta,clabel,ndathr)
        call rdr2d(io7,qsw2d,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr,ieof)
        if(ieof.EQ.1) then
           write(*,*)
           stop 'RDMET: Unexpected EOF in CALMET records'
        endif
        clabexp='QSW'
        if(clabel.ne.clabexp)go to 999
        if(ndathr.ne.kdathr)go to 3999
c
c       call rdi1d(io7,irhss,nssta,clabel,ndathr)
        call rdi2d(io7,irh2d,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr)
        clabexp='IRH'
        if(ieof.EQ.1) then
           write(*,*)
           stop 'RDMET: Unexpected EOF in CALMET records'
        endif
        if(clabel.ne.clabexp)go to 999
        if(ndathr.ne.kdathr)go to 3999
c
c ---   Precipitation code at surface stations
c        if(npsta.gt.0)then
c frr 030119 - bug fix: also precipitation code if prognostic rain
c       (i.e npsta,eq.-1)
        if(npsta.ne.0)then
c         call rdi1d(io7,ipcode,nssta,clabel,ndathr)
          call rdi2d(io7,ipcode2d,wrk1,mxnx,mxny,nxm,nym,clabel,ndathr)
          clabexp='IPCODE'
          if(clabel.ne.clabexp)go to 999
          if(ndathr.ne.kdathr)go to 3999
       endif


      elseif(i2dmet.EQ.0) then
c ---    read 1-D meteorological fields:
c           Air temp. (deg. K),
c           Air density (kg/m**3),
c           Short-wave solar radiation (W/m**2),
c           Relative humidity (percent),
c           Precipitation code
         call rdr1d(io7,tempss,nssta,clabel,ndathr)
         clabexp='TEMPK'
         if(clabel.ne.clabexp)go to 999
         if(ndathr.ne.kdathr)go to 3999
c
         call rdr1d(io7,rhoss,nssta,clabel,ndathr)
         clabexp='RHO'
         if(clabel.ne.clabexp)go to 999
         if(ndathr.ne.kdathr)go to 3999
c
         call rdr1d(io7,qswss,nssta,clabel,ndathr)
         clabexp='QSW'
         if(clabel.ne.clabexp)go to 999
         if(ndathr.ne.kdathr)go to 3999
c
         call rdi1d(io7,irhss,nssta,clabel,ndathr)
         clabexp='IRH'
         if(clabel.ne.clabexp)go to 999
         if(ndathr.ne.kdathr)go to 3999
c
c ---    Precipitation code at surface stations
         if(npsta.gt.0)then
            call rdi1d(io7,ipcode,nssta,clabel,ndathr)
            clabexp='IPCODE'
            if(clabel.ne.clabexp)go to 999
            if(ndathr.ne.kdathr)go to 3999
         endif

      else
         write(*,*)'Subr. RDMET:  Invalid I2DMET = ',i2dmet
         stop
      endif

c --- Enforce YYYY format for year in KDATHR
      kyr=kdathr/100000
      kdyhr=kdathr-kyr*100000
      call YR4(io6,kyr,ierr)
      if(ierr.NE.0) then
         write(*,*)
         stop 'Halted in RDMET'
      endif
      kdathr=kyr*100000+kdyhr

c --- Check to see if required date-time has been read
      if(kdathr.lt.idathr)then
c ---    Obtain next time period in MET file
         go to 1
      elseif(kdathr.gt.idathr)then
         write(io6,*)'ERROR in subr. RDMET -- current hour not found ',
     1   'in the MET data file -- Current date/hour = ',idathr,
     2   ' Last date/hour read = ',kdathr
         write(*,*)
         stop 'Halted in RDMET -- see list file.'
      endif
c
c --- Write the input fields, if requested
      if(LECHO)then
c
c ---    Date and time
         write(io6,*)
         write(io6,*)'------ MET. FIELDS FOR DATE/TIME = ',kdathr,
     1   ' (YYYYJJJHH) ------'
         write(io6,*)
c
c ---    3-D fields
         do 101 iz=1,nzm
         messag='U-component (m/s) -- Level: '
         write(messag(29:31),'(i3)')iz
         call out(umet(1,1,iz),idum,1,5,ldate,messag,nxm,nym)
         messag(1:1)='V'
         call out(vmet(1,1,iz),idum,1,5,ldate,messag,nxm,nym)
         messag(1:1)='W'
         call out(wdiv(1,1,iz),idum,1,5,ldate,messag,nxm,nym)
101      continue
c
c ---    2-D fields
         messag='PGT stability class'
         call out(xdum,ipgt,2,1,ldate,messag,nxm,nym)
         messag='Friction velocity (m/s)'
         call out(ustar,idum,1,5,ldate,messag,nxm,nym)
         messag='Mixing height (m)'
         call out(htmix,idum,1,5,ldate,messag,nxm,nym)
         messag='Monin-Obukhov length (m)'
         call out(xmonin,idum,1,5,ldate,messag,nxm,nym)
         messag='Convective velocity scale (m/s)'
         call out(wstar,idum,1,5,ldate,messag,nxm,nym)
         if(npsta.gt.0)then
            messag='Precipitation rate (mm/hr)'
            call out(rmm,idum,1,5,ldate,messag,nxm,nym)
         endif
c
c ---    1-D fields
c frr (09/01) after level 010901, 2D CALMET fields-  Before, 1D
         if(i2dmet.EQ.1) then
            messag='Surface Air Temperature (deg. K)'
            call out(temp2d,idum,1,5,ldate,messag,nxm,nym)
            messag='Surface Air Density (Kg/m**3)'
            call out(rho2d,idum,1,5,ldate,messag,nxm,nym)
            messag='Short Wave Radiation (W/m**2)'
            call out(qsw2d,idum,1,5,ldate,messag,nxm,nym)
            messag='Surface Relative Humidity (%)'
            call out(rdum,irh2d,2,5,ldate,messag,nxm,nym)
            if(npsta.ne.0)then
               messag='Precipitation code'
               call out(rdum,ipcode2d,2,5,ldate,messag,nxm,nym)
            endif
         elseif(i2dmet.EQ.0) then
            write(io6,*)'TEMPSS (deg. K) = ',(tempss(n),n=1,nssta)
            write(io6,*)'RHOSS (kg/m**3)  = ',(rhoss(n),n=1,nssta)
            write(io6,*)'QSWSS (W/m**2)   = ',(qswss(n),n=1,nssta)
            write(io6,*)'IRHSS (percent)  = ',(irhss(n),n=1,nssta)
            if(npsta.gt.0)write(io6,*)'IPCODE           = ',
     1       (ipcode(n),n=1,nssta)
         else
            write(*,*)'Subr. RDMET:  Invalid I2DMET = ',i2dmet
            stop
         endif
      endif
c
      return
c
c --- Write error messages -- incorrect record label read
999   continue
      write(io6,1001)clabel,clabexp
1001  format(/1x,'ERROR in subr. RDMET -- incorrect record label ',
     1 'read from MET data file'//1x,'Label read     = ',a8/
     2                               1x,'Label expected = ',a8)
      write(*,*)
      stop 'Halted in RDMET -- see list file.'
c
c --- date/time variables do not match
2999  continue
      write(io6,*)'ERROR in subr. RDMET -- date/time variables ',
     1 'do not match -- NDATHR1 = ',ndathr1,' NDATHR2 = ',ndathr2,
     2 ' NDATHR3 = ',ndathr3
      write(*,*)
      stop 'Halted in RDMET -- see list file.'
3999  continue
      write(io6,*)'ERROR in subr. RDMET -- date/time variables ',
     1 'do not match -- NDATHR = ',ndathr,' KDATHR = ',kdathr
      write(*,*)
      stop 'Halted in RDMET -- see list file.'
      end
c----------------------------------------------------------------------
      subroutine rdprof(idathr,lecho,izp,wsprf,wdprf,tprf,zprf,
     &                  ssprf,swprf,svprf,dptinvo,leof)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                 RDPROF
c                D. Strimaitis   SRC
c
c --- PURPOSE:  Read meteorological data for one hour from CTDM
c               PROFILE file
c
c --- UPDATE
c --- V5.5-V5.7     030402  (DGS): Add list file unit to YR4, JULDAY,
c                                  GRDAY, INCR
c --- V5.2-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.2     991104  (DGS): YYYY format used for year
c --- V4.0-V5.0     971107  (DGS): add EOF recovery
c                           (DGS): add record-skip logic from COMP to
c                                  find current date-time
c                           (DGS): skip blank records
c                           (DGS): allow inversion strength in PROFILE
c
c --- INPUTS:
c        IDATHR - integer       - Date & hour of required data
c                                 (YYYYJJJHH)
c         LECHO - logical       - Flag controlling printing of input
c                                 meteorological data fields
c        PTG(2) - real          - Default potential temperature grad.
c                                 for stable classes (deg. K/m)
c
c    Common block /METHD/ variables:
c         NXM, NYM, NZM, NSSTA, NPSTA, ZFACEM(mxnzp1), LCALGRD,
c         IMIXCTDM, ISIGMAV
c    Parameters:
c         MXNX, MXNY, MXNZ, MXNZP1, MXPRFZ, IO6
c
c --- OUTPUT:
c
c                    IZP - integer - Number of profile levels
c          WSPRF(mxprfz) - real    - 1-D vector wind speed profile (m/s)
c          WDPRF(mxprfz) - real    - 1-D vector wind dir. profile (deg)
c           TPRF(mxprfz) - real    - Temperature profile (deg. K)
c           ZPRF(mxprfz) - real    - Heights for data in profile (m)
c          SSPRF(mxprfz) - real    - 1-D scalar speed profile (m/s)
c          SWPRF(mxprfz) - real    - 1-D sigma-w profile (m/s)
c          SVPRF(mxprfz) - real    - 1-D sigma-v profile (m/s)
c                DPTINVO - real    - Inversion strength at top of CBL
c                                    (jump in potential temperature K)
c                   LEOF - logical - End-Of-File flag
c
c --- RDPROF called by:  COMP, RDMET4
c --- RDPROF calls:      JULDAY, INCR, GRDAY, INITAR,
c                        INITAI, OUT, INITR2D, INITI2D,
c                        LSTAB, XTPRF, YR4
c----------------------------------------------------------------------
c
c --- Include parameter statements
      include 'params.puf'
c
      include 'methd.puf'
c
c --- Profile data arrays

      real wsprf(mxprfz),wdprf(mxprfz),tprf(mxprfz),zprf(mxprfz)
      real ssprf(mxprfz),swprf(mxprfz),svprf(mxprfz)
c
      character aline*132
c
      logical lecho,problem,leof
c
      data dtor/.0174533/

c --- Set logical to halt program if problem is found
1     problem=.FALSE.

c -------------------------------------------------------------------
c  -- Read records for this hour from CTDM PROFILE file
c -------------------------------------------------------------------
2     izp=0
10    izp=izp+1
c --- Do not let profile levels exceed MXPRFZ; discard extra levels
      if(izp.GT.mxprfz) izp=mxprfz

c --- First level of profile may contain the strength of inversion
c --- at top of CBL, so read first line as character variable and
c --- try to extract DPTINVO using internal read
      if(izp.EQ.1) then
         read(io31,'(a132)',end=999) aline
         read(aline,*,end=15) iy,im,id,ih,zprf(izp),ilast,wdprf(izp),
     &                     ssprf(izp),tprf(izp),svprf(izp),swprf(izp),
     &                     wsprf(izp),dptinvo
         goto 16
c ---    Inversion strength is not provided; return missing value
15       dptinvo=-999.
16       continue
      else
         read(io31,*,end=999) iy,im,id,ih,zprf(izp),ilast,wdprf(izp),
     &                     ssprf(izp),tprf(izp),svprf(izp),swprf(izp),
     &                     wsprf(izp)
      endif
c
c --- Convert svprf to sigma-v (m/s) if given in degrees
      if(isigmav.EQ.0) then
         if(svprf(izp).GT.0.0) then
            if(wsprf(izp).GT.0.0) then
c ---          Definition!
               svprf(izp)=svprf(izp)*dtor*wsprf(izp)
            elseif(ssprf(izp).GT.0.0) then
c ---          Approximation!
               svprf(izp)=svprf(izp)*dtor*ssprf(izp)
            else
               svprf(izp)=-999.
            endif
         endif
      endif
c
c --- Construct vector/scalar average wind, as in CTDM, if needed
      if(wsprf(izp).LE.0.0) then
         if(ssprf(izp).GT.0.0) then
c ---       Estimate vector mean from scalar mean speed
            if(svprf(izp).GT.0) then
               sigth=svprf(izp)/ssprf(izp)
c ---          Sigma-theta cannot exceed 103.9 degrees (1.81334 radians)
               sigth=AMIN1(sigth,1.81334)
               e=SIN(sigth)*(1.0-0.073864*sigth)
               wsprf(izp)=ssprf(izp)*SQRT(1.0-e*e)
            else
               wsprf(izp)=ssprf(izp)
            endif
         endif
      elseif(ssprf(izp).LE.0.0) then
c ---    Estimate scalar mean from vector mean speed
         sigth=svprf(izp)/wsprf(izp)
c ---    Sigma-theta cannot exceed 103.9 degrees (1.81334 radians)
         sigth=AMIN1(sigth,1.81334)
         if(sigth.GT.0) then
            e=SIN(sigth)*(1.0-0.073864*sigth)
            ssprf(izp)=wsprf(izp)/SQRT(1.0-e*e)
         else
            ssprf(izp)=wsprf(izp)
         endif
      endif
c
c --- Are there more levels in this profile? (go to 10 if yes)
      if(izp.EQ.1) then
         itest1=iy+im+id+ih
         itest2=itest1
         if(ilast.NE.1) goto 10
      elseif(ilast.EQ.1) then
         itest2=iy+im+id+ih
      else
         goto 10
      endif
c -------------------------------------------------------------------

c --- Form date-time variable for last record read from PROFILE file
c --- which uses a 1-24 clock (hour ending), whereas CALPUFF uses
c --- a 00-23 (hour ending) convention.  Therefore, convert hour "24"
c --- to hour "00" of the next day

c --- Enforce YYYY format for year
      call YR4(io6,iy,ierr)
      if(ierr.NE.0) then
         write(*,*)
         stop 'Halted in RDPROF'
      endif

      if(ih.EQ.24) then
c ---    Roll back 1 hour, then use INCR routine to move forward 1 hour
         ih=ih-1
         call julday(io6,iy,im,id,ijul)
         call incr(io6,iy,ijul,ih,1)
         call grday(io6,iy,ijul,im,id)
      else
         call julday(io6,iy,im,id,ijul)
      endif
      kpdathr=iy*100000+ijul*100+ih

c --- Check to see if required date-time has been read
      if(kpdathr.lt.idathr)then
c ---    Obtain next time period in MET file
         go to 1
      elseif(kpdathr.gt.idathr)then
         write(io6,*)'ERROR in subr. RDPROF -- current hour not found ',
     1   'in the PROFILE data file -- Current date/hour = ',idathr,
     2   ' Last date/hour read = ',kpdathr
         write(*,*)
         stop 'Halted in RDPROF -- see list file.'
      endif

c --- Check for consistent date-time for hour among records
      if(itest1.NE.itest2) then
         write(io6,*)'RDPROF: date-time of PROFILE levels do not match'
         problem=.TRUE.
      endif

c --- Halt program now if problem was found with PROFILE
      if(PROBLEM) then
         write(io6,*)'   PROFILE day-hr = ',kpdathr
         write(*,*)
         stop 'Halted in RDPROF -- see list file.'
      endif

c --- Write the input fields, if requested
      if(LECHO)then
c
c ---    Date and time
         write(io6,*)
         write(io6,*)'------ PROFILE FIELDS FOR DATE/TIME = ',idathr,
     1   ' (YYYYJJJHH) ------'
         write(io6,*)
c
c ---    Profile fields
         write(io6,*)'Height(m),  Scalar Speed,  Sigma-W,  Sigma-V:'
         do iz=1,izp
            write(io6,*) zprf(iz),ssprf(iz),swprf(iz),svprf(iz)
         enddo
         write(io6,*)
         write(io6,*)'Height(m), Vector Speed, Direction, Temperature:'
         do iz=1,izp
            write(io6,*) zprf(iz),wsprf(iz),wdprf(iz),tprf(iz)
         enddo
         write(io6,*)
c ---    Also report inversion strength here
         write(io6,*)'Inversion Strength in file (K) = ',dptinvo
         write(io6,*)
      endif
c
      return

999   write(io6,*)'RDPROF: End-Of-File found in PROFILE file'
      leof=.TRUE.
      return

      end
c----------------------------------------------------------------------
      subroutine rdprof5(idathr,lecho,izp,wsprf,wdprf,tprf,zprf,
     &                  ssprf,swprf,svprf,dptinvo,leof)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 040715                RDPROF5
c                D. Strimaitis   SRC
c
c --- PURPOSE:  Read meteorological data for one hour from AERMET
c               PROFILE file.  This is RDPROF with the following
c               changes:
c               1.  Retain extended data records even though none are
c                   currently expected
c               2.  Wind speed in record is assumed to be the scalar
c                   average
c               3.  Temperature is read as degrees C.
c
c --- INPUTS:
c        IDATHR - integer       - Date & hour of required data
c                                 (YYYYJJJHH)
c         LECHO - logical       - Flag controlling printing of input
c                                 meteorological data fields
c        PTG(2) - real          - Default potential temperature grad.
c                                 for stable classes (deg. K/m)
c
c    Common block /METHD/ variables:
c         NXM, NYM, NZM, NSSTA, NPSTA, ZFACEM(mxnzp1), LCALGRD,
c         IMIXCTDM, ISIGMAV
c    Parameters:
c         MXNX, MXNY, MXNZ, MXNZP1, MXPRFZ, IO6
c
c --- OUTPUT:
c
c                    IZP - integer - Number of profile levels
c          WSPRF(mxprfz) - real    - 1-D vector wind speed profile (m/s)
c          WDPRF(mxprfz) - real    - 1-D vector wind dir. profile (deg)
c           TPRF(mxprfz) - real    - Temperature profile (deg. K)
c           ZPRF(mxprfz) - real    - Heights for data in profile (m)
c          SSPRF(mxprfz) - real    - 1-D scalar speed profile (m/s)
c          SWPRF(mxprfz) - real    - 1-D sigma-w profile (m/s)
c          SVPRF(mxprfz) - real    - 1-D sigma-v profile (m/s)
c                DPTINVO - real    - Inversion strength at top of CBL
c                                    (jump in potential temperature K)
c                   LEOF - logical - End-Of-File flag
c
c --- RDPROF5 called by:  COMP, RDMET5
c --- RDPROF5 calls:      JULDAY, INCR, GRDAY, INITAR,
c                         INITAI, OUT, INITR2D, INITI2D,
c                         LSTAB, XTPRF, YR4
c----------------------------------------------------------------------
c
c --- Include parameter statements
      include 'params.puf'
c
      include 'methd.puf'
c
c --- Profile data arrays

      real wsprf(mxprfz),wdprf(mxprfz),tprf(mxprfz),zprf(mxprfz)
      real ssprf(mxprfz),swprf(mxprfz),svprf(mxprfz)
c
      character aline*132
c
      logical lecho,problem,leof
c
      data dtor/.0174533/

c --- Set logical to halt program if problem is found
1     problem=.FALSE.

c -------------------------------------------------------------------
c  -- Read records for this hour from AERMET PROFILE file
c -------------------------------------------------------------------
2     izp=0
10    izp=izp+1
c --- Do not let profile levels exceed MXPRFZ; discard extra levels
      if(izp.GT.mxprfz) izp=mxprfz

c --- First level of profile may contain the strength of inversion
c --- at top of CBL, so read first line as character variable and
c --- try to extract DPTINVO using internal read
      if(izp.EQ.1) then
         read(io31,'(a132)',end=999) aline
         read(aline,*,end=15) iy,im,id,ih,zprf(izp),ilast,wdprf(izp),
     &                     ssprf(izp),tprf(izp),svprf(izp),swprf(izp),
     &                     dptinvo
         goto 16
c ---    Inversion strength is not provided; return missing value
15       dptinvo=-999.
16       continue
      else
         read(io31,*,end=999) iy,im,id,ih,zprf(izp),ilast,wdprf(izp),
     &                     ssprf(izp),tprf(izp),svprf(izp),swprf(izp)
      endif

c --- Trap AERMET missings
      if(ssprf(izp).LT.0.0 .OR. ssprf(izp).GT.90.) ssprf(izp)=-999.
      if(wdprf(izp).LT.0.0 .OR. wdprf(izp).GT.900.) wdprf(izp)=-999.
      if(tprf(izp).LT.-90. .OR. tprf(izp).GT.90.) tprf(izp)=-999.
      if(svprf(izp).LT.0.0 .OR. svprf(izp).GT.90.) svprf(izp)=-99.9
      if(swprf(izp).LT.0.0 .OR. swprf(izp).GT.90.) swprf(izp)=-99.9

c --- Set vector mean speed equal to missing
      wsprf(izp)=-999.

c --- Convert temperature from degrees C to degrees K
      if(tprf(izp).GT.-900.) tprf(izp)=tprf(izp)+273.16

c --- Convert svprf to sigma-v (m/s) if given in degrees
      if(isigmav.EQ.0) then
         if(svprf(izp).GT.0.0) then
            if(wsprf(izp).GT.0.0) then
c ---          Definition!
               svprf(izp)=svprf(izp)*dtor*wsprf(izp)
            elseif(ssprf(izp).GT.0.0) then
c ---          Approximation!
               svprf(izp)=svprf(izp)*dtor*ssprf(izp)
            else
               svprf(izp)=-999.
            endif
         endif
      endif
c
c --- Construct vector/scalar average wind, as in CTDM, if needed
      if(wsprf(izp).LE.0.0) then
         if(ssprf(izp).GT.0.0) then
c ---       Estimate vector mean from scalar mean speed
            if(svprf(izp).GT.0) then
               sigth=svprf(izp)/ssprf(izp)
c ---          Sigma-theta cannot exceed 103.9 degrees (1.81334 radians)
               sigth=AMIN1(sigth,1.81334)
               e=SIN(sigth)*(1.0-0.073864*sigth)
               wsprf(izp)=ssprf(izp)*SQRT(1.0-e*e)
            else
               wsprf(izp)=ssprf(izp)
            endif
         endif
      elseif(ssprf(izp).LE.0.0) then
c ---    Estimate scalar mean from vector mean speed
         sigth=svprf(izp)/wsprf(izp)
c ---    Sigma-theta cannot exceed 103.9 degrees (1.81334 radians)
         sigth=AMIN1(sigth,1.81334)
         if(sigth.GT.0) then
            e=SIN(sigth)*(1.0-0.073864*sigth)
            ssprf(izp)=wsprf(izp)/SQRT(1.0-e*e)
         else
            ssprf(izp)=wsprf(izp)
         endif
      endif
c
c --- Are there more levels in this profile? (go to 10 if yes)
      if(izp.EQ.1) then
         itest1=iy+im+id+ih
         itest2=itest1
         if(ilast.NE.1) goto 10
      elseif(ilast.EQ.1) then
         itest2=iy+im+id+ih
      else
         goto 10
      endif
c -------------------------------------------------------------------

c --- Form date-time variable for last record read from PROFILE file
c --- which uses a 1-24 clock (hour ending), whereas CALPUFF uses
c --- a 00-23 (hour ending) convention.  Therefore, convert hour "24"
c --- to hour "00" of the next day

c --- Enforce YYYY format for year
      call YR4(io6,iy,ierr)
      if(ierr.NE.0) then
         write(*,*)
         stop 'Halted in RDPROF5'
      endif

      if(ih.EQ.24) then
c ---    Roll back 1 hour, then use INCR routine to move forward 1 hour
         ih=ih-1
         call julday(io6,iy,im,id,ijul)
         call incr(io6,iy,ijul,ih,1)
         call grday(io6,iy,ijul,im,id)
      else
         call julday(io6,iy,im,id,ijul)
      endif
      kpdathr=iy*100000+ijul*100+ih

c --- Check to see if required date-time has been read
      if(kpdathr.lt.idathr)then
c ---    Obtain next time period in MET file
         go to 1
      elseif(kpdathr.gt.idathr)then
         write(io6,*)'ERROR in subr. RDPROF5 -- current hour not found',
     1   'in the PROFILE data file -- Current date/hour = ',idathr,
     2   ' Last date/hour read = ',kpdathr
         write(*,*)
         stop 'Halted in RDPROF5 -- see list file.'
      endif

c --- Check for consistent date-time for hour among records
      if(itest1.NE.itest2) then
         write(io6,*)'RDPROF5: date-time of PROFILE levels do not match'
         problem=.TRUE.
      endif

c --- Halt program now if problem was found with PROFILE
      if(PROBLEM) then
         write(io6,*)'   PROFILE day-hr = ',kpdathr
         write(*,*)
         stop 'Halted in RDPROF5 -- see list file.'
      endif

c --- Write the input fields, if requested
      if(LECHO)then
c
c ---    Date and time
         write(io6,*)
         write(io6,*)'------ PROFILE FIELDS FOR DATE/TIME = ',idathr,
     1   ' (YYYYJJJHH) ------'
         write(io6,*)
c
c ---    Profile fields
         write(io6,*)'Height(m),  Scalar Speed,  Sigma-W,  Sigma-V:'
         do iz=1,izp
            write(io6,*) zprf(iz),ssprf(iz),swprf(iz),svprf(iz)
         enddo
         write(io6,*)
         write(io6,*)'Height(m), Vector Speed, Direction, Temperature:'
         do iz=1,izp
            write(io6,*) zprf(iz),wsprf(iz),wdprf(iz),tprf(iz)
         enddo
         write(io6,*)
c ---    Also report inversion strength here
         write(io6,*)'Inversion Strength in file (K) = ',dptinvo
         write(io6,*)
      endif
c
      return

999   write(io6,*)'RDPROF5: End-Of-File found in PROFILE file'
      leof=.TRUE.
      return

      end
c----------------------------------------------------------------------
      subroutine met2(lecho,ibyr,ibmo,ibdy,ibhr,irlg)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8.5    Level: 130731                   MET2
c                J. Scire, D. Strimaitis   SRC
c
c --- PURPOSE:  Create the header information normally contained
c               in the CALMET file (using ISCMET file).
c               Also, set the wind profile power-law exponents if
c               not provided in control file.
c
c --- UPDATE
c --- V5.7-V5.8.4   130731  (EPA): Change met station coordinates from
c                                  absolute to relative to grid origin
c --- V5.5-V5.7     030402  (DGS): Add list file unit to YR4, JULDAY,
c                                  GRDAY, INCR
c                   030402  (DGS): add map projection, datum
c --- V5.2-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.2     991104  (DGS): YYYY format for year
c --- V5.0-V5.0     980430  (DGS): remove plrur,plurb (compiler warning)
c --- V5.0-V5.0     980304  (DGS): add station elevation,lat,lon
c --- V4.0-V5.0     971107  (DGS): pass start-time from met file
c                                  for use if METRUN=1
c
c --- INPUTS:
c         LECHO - logical       - Control variable for output of header
c                                 record information
c     Common block /COMPARM/ variables:
c           PLX0
c     Common block /DISPDAT/ variables:
c           IURB1, IURB2
c     Common block /GRID/ variables:
c           NX, NY, NZ, DGRID, XORIG, YORIG, ZFACE(mxnzp1)
c     Common block /MAP/ variables:
c           iutmzn,feast,fnorth,
c           rlat0,rlon0,xlat1,xlat2,
c           pmap,utmhem,datum,daten
c     Common block /METHD/ variables:
c           ANEMHT, ILANDUIN, Z0IN, XLAIIN, ELEVIN, XLATIN, XLONIN
c     Parameters:
c           MXNZP1, MXSS, MXUS, MXPS, IO6
c
c --- OUTPUT:
c     Common block /COMPARM/ variables:
c           PLX0
c     Common block /METHD/ variables:
c           NXM, NYM, NZM, XGRIDM, XORIGM, YORIGM,
c           NSSTA, NPSTA, NLU, IWAT1, IWAT2, ZFACEM(mxnzp1),
c           XSSTA(mxss),YSSTA(mxss),XUSTA(mxus),YUSTA(mxus),
c           XLATSS(mxss),XLONSS(mxss),
c           XPSTA(mxps),YPSTA(mxps),Z0(mxnx,mxny),ILANDU(mxnx,mxny),
c           ELEV(mxnx,mxny),XLAI(mxnx,mxny),NEARS(mxnx,mxny),
c           LCALGRD
c           xlat1m, xlat2m, rlat0m, rlon0m
c           iutmznm,feastm,fnorthm,pmapm,datumm,datenm,utmhemm
c
c --- MET2 called by:  SETUP
c --- MET2 calls:      JULDAY, INCR, GRDAY, INITR2D, OUT, INITI2D, YR4
c----------------------------------------------------------------------
c
c --- Include parameters
      include 'params.puf'
c
      character*80 title(3)
      character*70 messag
      character*8 clab1,clab2
      logical ldate,lecho
c
c --- Include common block /COMPARM/ -- Computation parameters
      include 'comparm.puf'
c --- Include common block /DISPDAT/ -- Dispersion-related data
      include 'dispdat.puf'
c --- Include common block /METHD/ -- CALMET header record data
      include 'methd.puf'
c --- Include common block /GRID/  -- Grid data from control file
      include 'grid.puf'
c --- Include common block /MAP/  -- Projection data from control file
      include 'map.puf'
c
      data ldate/.false./
c
c --- Assume that run length can be several years, so set IRLG=LARGE
      irlg=999999
c
c --- Read ISC header record (station,year for surface and upper)
c ---------------------------------------------------------------------
      read(io7,'(a80)') title(3)
c                                                              RECORD 1
c ---------------------------------------------------------------------
c --- record #1 - run title --
c --- Set three title-lines
      title(1)='Constant Meteorological Fields'
      title(2)='Created for ISCMET.DAT'
c
c --- record #2 - run control parameters --
c --- (vermet, levmet are both 8 bytes):
c ---  vermet,levmet,ibyr,ibmo,ibdy,ibhr,irtype,
c ---  nxm, nym, nzm, xgridm, xorigm, yorigm, iutmznm, iwfcod, nssta,
c ---  nusta, npsta, nowsta, nlu, iwat1, iwat2, lcalgrd
c
c --- Fill in most first
      irtype=1
      nxm=nx
      nym=ny
      nzm=nz
      xgridm=dgrid
      xorigm=xorig
      yorigm=yorig
      pmapm=pmap
      datumm=datum
      datenm=daten
      iutmznm=iutmzn
      utmhemm=utmhem
      rlat0m=rlat0
      rlon0m=rlon0
      xlat1m=xlat1
      xlat2m=xlat2
      feastm=feast
      fnorthm=fnorth
      iwfcod=1
      nssta=1
      nusta=1
      npsta=1
      nowsta=0
      nlu=10
      iwat1=500
      iwat2=599
      lcalgrd=.FALSE.
c --- Now read date-time from first data record (must rewind!)
c ---------------------------------------------------------------------
      read(io7,'(4i2)') ibyr,ibmo,ibdy,ibhr
      rewind(io7)
      read(io7,'(a80)') title(3)
c                                                              RECORD 2
c ---------------------------------------------------------------------
c --- Enforce YYYY format for year
      call YR4(io6,ibyr,ierr)
      if(ierr.NE.0) then
         write(*,*)
         stop 'Halted in MET2'
      endif
c
c --- ISCMET.DAT uses a 1-24 clock (hour ending), whereas CALPUFF uses
c --- a 00-23 (hour ending) convention.  Therefore, convert hour "24"
c --- to hour "00" of the next day
      if(ibhr.EQ.24) then
c ---    Roll back 1 hour, then use INCR routine to move forward 1 hour
         ibhr=ibhr-1
         call julday(io6,ibyr,ibmo,ibdy,ijul)
         call incr(io6,ibyr,ijul,ibhr,1)
         call grday(io6,ibyr,ijul,ibmo,ibdy)
      endif

      if(LECHO)then
         write(io6,*)
         write(io6,*)
         write(io6,*)
         write(io6,*) title(1)
         write(io6,*) title(2)
         write(io6,*) title(3)
         write(io6,*)
         write(io6,*)' IBYR    = ',ibyr
         write(io6,*)' IBMO    = ',ibmo
         write(io6,*)' IBDY    = ',ibdy
         write(io6,*)' IBHR    = ',ibhr
         write(io6,*)' (converted to 00-23 convention)'
         write(io6,*)' IRTYPE  = ',irtype
         write(io6,*)' LCALGRD = ',lcalgrd
         write(io6,*)' NXM     = ',nxm
         write(io6,*)' NYM     = ',nym
         write(io6,*)' NZM     = ',nzm
         write(io6,*)' XGRIDM  = ',xgridm
         write(io6,*)' XORIGM  = ',xorigm
         write(io6,*)' YORIGM  = ',yorigm

         write(io6,*)' PMAPM   = ',pmapm
         write(io6,*)' DATUMM  = ',datumm
         write(io6,*)' DATENM  = ',datenm
         write(io6,*)' IUTMZNM = ',iutmznm
         write(io6,*)' UTMHEMM = ',utmhemm
         write(io6,*)' XLAT1M  = ',xlat1m
         write(io6,*)' XLAT2M  = ',xlat2m
         write(io6,*)' RLAT0M  = ',rlat0m
         write(io6,*)' RLON0M  = ',rlon0m
         write(io6,*)' FEASTM  = ',feastm
         write(io6,*)' FNORTHM = ',fnorthm

         write(io6,*)' IWFCOD  = ',iwfcod
         write(io6,*)' NSSTA   = ',nssta
         write(io6,*)' NUSTA   = ',nusta
         write(io6,*)' NPSTA   = ',npsta
         write(io6,*)' NOWSTA  = ',nowsta
         write(io6,*)' NLU     = ',nlu
         write(io6,*)' IWAT1   = ',iwat1
         write(io6,*)' IWAT2   = ',iwat2
         write(io6,*)' ANEMHT  = ',anemht
      endif
c
      nzmp1=nzm+1
      if(mxnzp1.lt.nzmp1)then
         write(io6,*)'ERROR in subr. MET2 -- dimension of ZFACEM ',
     1   'array is too small for no. layers in ISCMET file'
         write(io6,*)'MXNZP1 = ',mxnzp1,' NZMP1 = ',nzmp1
         write(*,*)
         stop 'Halted in MET2 -- see list file.'
      endif
c
c --- record #3 - cell face heights (NZ + 1 words)
c
c --- Grab the face heights from the control file
      do i=1,nzmp1
         zfacem(i)=zface(i)
      enddo
c
      if(LECHO)then
         write(io6,203)(zfacem(n),n=1,nzmp1)
203      format(1x,'ZFACEM  = ',10(f9.3,', ')/)
      endif
c
c --- records #4 & 5 - x, y coordinates of surface stations
c --- (NSSTA words each record)
      if(nssta.gt.0)then
c ---    Coordinates relative to the grid origin
         xssta(1)=0.0
         yssta(1)=0.0
         if(LECHO)then
            clab1='XSSTA'
            clab2='YSSTA'
            write(io6,*)clab1,' = ',(xssta(n),n=1,nssta)
            write(io6,*)clab2,' = ',(yssta(n),n=1,nssta)
         endif
      endif
c
c --- records #4a & 5a - lat, lon coordinates of surface stations
c --- (NSSTA words each record)
      if(nssta.gt.0)then
c ---    Grab the lat,lon from control file inputs
         xlatss(1)=xlatin
         xlonss(1)=xlonin
         if(LECHO)then
            clab1='XLATSS'
            clab2='YLONSS'
            write(io6,*)clab1,' = ',(xlatss(n),n=1,nssta)
            write(io6,*)clab2,' = ',(xlonss(n),n=1,nssta)
         endif
      endif
c
c --- records #6 & 7 - x, y coordinates of upper air stations
c --- (NUSTA words each record)
      if(nusta.gt.0)then
c ---    Coordinates relative to the grid origin
         xusta(1)=0.0
         yusta(1)=0.0
         if(LECHO)then
            clab1='XUSTA'
            clab2='YUSTA'
            write(io6,*)clab1,' = ',(xusta(n),n=1,nusta)
            write(io6,*)clab2,' = ',(yusta(n),n=1,nusta)
         endif
      endif
c
c --- records #8 & 9 - x, y coordinates of precipitation stations
c --- (NPSTA words each record)
      if(npsta.gt.0)then
c ---    Coordinates relative to the grid origin
         xpsta(1)=0.0
         ypsta(1)=0.0
         if(LECHO)then
            clab1='XPSTA'
            clab2='YPSTA'
            write(io6,*)clab1,' = ',(xpsta(n),n=1,npsta)
            write(io6,*)clab2,' = ',(ypsta(n),n=1,npsta)
         endif
      endif
c
c --- Fill the corresponding arrays:
c
c --- record #10 - surface roughness lengths (NX * NY words)
      call initr2d(z0in,mxnx,mxny,nxm,nym,z0)
      if(LECHO)then
         messag='Surface roughness lengths (m)'
         messag(63:70)='z0'
         call out(z0,idum,1,5,ldate,messag,nx,ny)
      endif
c
c --- record #11 - land use categories (NX * NY words)
      call initi2d(ilanduin,mxnx,mxny,nxm,nym,ilandu)
      if(LECHO)then
         messag='Land use categories'
         messag(63:70)='ILANDU'
         call out(xdum,ilandu,2,5,ldate,messag,nx,ny)
      endif
c
c --- record #12 - elevations (NX * NY words)
c --- Set grid elevation to ELEVIN from control file
      call initr2d(elevin,mxnx,mxny,nxm,nym,elev)
      if(LECHO)then
         messag='Terrain heights (m)'
         messag(63:70)='TERR'
         call out(elev,idum,1,5,ldate,messag,nx,ny)
      endif
c
c --- record #13 - leaf area index (NX * NY words)
      call initr2d(xlaiin,mxnx,mxny,nxm,nym,xlai)
      if(LECHO)then
         messag='Leaf area index'
         messag(63:70)='XLAI'
         call out(xlai,idum,1,5,ldate,messag,nx,ny)
      endif
c
c --- record #14 - nearest surface station to each grid point
c                  (NX * NY words)
      call initi2d(1,mxnx,mxny,nxm,nym,nears)
      if(LECHO)then
         messag='Nearest surface station no. to each grid point'
         messag(63:70)='NEARS'
         call out(xdum,nears,2,5,ldate,messag,nx,ny)
      endif

c
      return
      end
c----------------------------------------------------------------------
      subroutine rdisc(idathr,lecho,umet,vmet,ipgt,htmix,ustar,xmonin,
     1                 wstar,rmm,tempss,rhoss,qswss,irhss,ipcode,
     2                 ptgdf,plexp,leof)
c----------------------------------------------------------------------
c
c --- CALPUFF    Version: 5.8      Level: 030402                  RDISC
c                J. Scire, D. Strimaitis   SRC
c
c --- PURPOSE:  Read ISCMET.DAT meteorological data for one hour
c
c --- UPDATE
c --- V5.5-V5.7     030402  (DGS): Add list file unit to YR4, JULDAY,
c                                  GRDAY, INCR
c --- V5.4-V5.4     000602_4(DGS): add QAHRISC call
c --- V5.2-V5.4     000602  (DGS): add message to "stop"
c --- V5.0-V5.2     991104  (DGS): YYYY format for year
c --- V4.0-V5.0     971107  (DGS): add EOF recovery
c                   971107  (DGS): add record-skip logic from COMP to
c                                  find current date-time
c                   971107  (DGS): skip blank records
c
c --- INPUTS:
c        IDATHR - integer       - Date & hour of required data
c                                 (YYYYJJJHH)
c         LECHO - logical       - Flag controlling printing of input
c                                 meteorological data fields
c    Common block /COMPARM/ variables:
c         PLX0, PTG0, WSCALM
c    Common block /METHD/ variables:
c         NXM, NYM, NZM, NSSTA, NPSTA, LCALGRD, ANEMHT
c    Common block /DISPDAT/ variables:
c         IURB1, IURB2
c    Common block /GRID/ variables:
c         ZGPT
c    Parameters:
c         MXNZMP1, IO6
c
c --- OUTPUT:
c
c   UMET(mxnx,mxny,mxnz) - real    - U component of the wind (m/s)
c                                    at each grid point
c   VMET(mxnx,mxny,mxnz) - real    - V-component of the wind (m/s)
c        IPGT(mxnx,mxny) - integer - PGT stability class
c       HTMIX(mxnx,mxny) - real    - Mixing height (m)
c       USTAR(mxnx,mxny) - real    - Surface friction velocity (m/s)
c      XMONIN(mxnx,mxny) - real    - Monin-Obukhov length (m)
c       WSTAR(mxnx,mxny) - real    - Convective velocity scale (m/s)
c         RMM(mxnx,mxny) - real    - Precipitation rate (mm/hr)
c          TEMPSS(nssta) - real    - Air temperature (deg. K) at
c                                    each surface met. station
c           RHOSS(nssta) - real    - Air density (kg/m**3)
c           QSWSS(nssta) - real    - Short wave solar radiation
c                                    (W/m**2)
c           IRHSS(nssta) - integer - Relative humidity (percent)
c          IPCODE(nssta) - integer - Precipitation code at each surface
c                                    station
c               PTGDF(2) - real    - Default potential temperature grad.
c                                    for stable classes (deg. K/m)
c                  PLEXP - real    - Power law exponent for wind profile
c                                    (used with single-point met file)
c                 KDATHR - integer - Date of hour of data (YYYYJJJHH)
c                   LEOF - logical - End-Of-File flag
c
c --- RDISC called by:  COMP
c --- RDISC calls:      JULDAY, INCR, GRDAY, POWLAW, INITAR,
c                       INITAI, OUT, INITR2D, INITI2D, YR4, QAHRISC
c----------------------------------------------------------------------
c
c --- Include parameter statements
      include 'params.puf'
c
      include 'methd.puf'
      include 'comparm.puf'
      include 'dispdat.puf'
      include 'grid.puf'
c
      real umet(mxnx,mxny,mxnz),vmet(mxnx,mxny,mxnz)
      real htmix(mxnx,mxny),ustar(mxnx,mxny),xmonin(mxnx,mxny)
      real wstar(mxnx,mxny),rmm(mxnx,mxny)
      real tempss(nssta),rhoss(nssta),qswss(nssta)
      real ptgdf(2),plexp
c
      integer ipgt(mxnx,mxny),irhss(nssta),ipcode(nssta)
      character*70 messag
      character plfield*5,swfield*9,rhfield*3
      logical lecho,ldate,leof
c
      data ldate/.false./
      data vonk/0.4/
c
c --- Determine IRU value (rural=0, urban=1) from header data
      iru=0
      if(ilandu(1,1) .GE. iurb1 .AND.
     &   ilandu(1,1) .LE. iurb2) iru=1

c -------------------------------------------------------------------
c  -- Read one record of met data in extended ISC format (ASCII)
1     read(io7,5,end=999) iy,im,id,ih,fvec,wspd,tmpk,kst,rmix,umix,
     &                    ustr,xmon,z0m,ipc,pmmhr,dthdz,
     &                    plfield,swfield,rhfield
5     format(4i2,2f9.4,f6.1,i2,2f7.1,f9.4,f10.1,f8.4,i4,f7.2,
     &       f10.5,a5,a9,a3)
c
c --- Skip blank lines
      if(im.EQ.0 .OR. id.EQ.0) goto 1
c -------------------------------------------------------------------
c --- Enforce YYYY format for year
      call YR4(io6,iy,ierr)
      if(ierr.NE.0) then
         write(*,*)
         stop 'Halted in RDISC'
      endif

c --- ISCMET.DAT uses a 1-24 clock (hour ending), whereas CALPUFF uses
c --- a 00-23 (hour ending) convention.  Therefore, convert hour "24"
c --- to hour "00" of the next day
      if(ih.EQ.24) then
c ---    Roll back 1 hour, then use INCR routine to move forward 1 hour
         ih=ih-1
         call julday(io6,iy,im,id,ijul)
         call incr(io6,iy,ijul,ih,1)
         call grday(io6,iy,ijul,im,id)
      else
         call julday(io6,iy,im,id,ijul)
      endif
      kdathr=iy*100000+ijul*100+ih

c --- Check to see if required date-time has been read
      if(kdathr.lt.idathr)then
c ---    Obtain next time period in MET file
         go to 1
      elseif(kdathr.gt.idathr)then
         write(io6,*)'ERROR in subr. RDISC -- current hour not found ',
     1   'in the ISCMET data file -- Current date/hour = ',idathr,
     2   ' Last date/hour read = ',kdathr
         write(*,*)
         stop 'Halted in RDISC -- see list file.'
      endif

c --- Apply QA rules to data from file
      call QAHRISC(fvec,wspd,tmpk,kst,rmix,umix,ustr,xmon,
     &             ipc,pmmhr,swfield,rhfield,ierr)
      if(ierr.NE.0) then
         write(io6,*)'ERROR in subr. RDISC -- Data are not complete ',
     1   'in the ISCMET data file -- Current date/hour = ',idathr
         write(*,*)
         stop 'Halted in RDISC -- see list file.'
      endif

c --- Set current mixing height for land use type (IRU)
      if(iru.EQ.0) then
         zmix=rmix
      else
         zmix=umix
      endif

c --- Check current value of roughness with value in /METHD/
      if(z0m.LE.0.0) then
c ---    Roughness length missing, keep previous value
         z0m=z0(1,1)
      elseif(z0m.NE.z0(1,1)) then
c ---    Valid roughness length changed, update array
c !!!    write(io6,*)'RDISC :  Roughness length changed'
c !!!    write(io6,*)'         Date-Hour      - ',kdathr
c !!!    write(io6,*)'         old,new z0(m)  - ',z0(1,1),z0m
         call initr2d(z0m,mxnx,mxny,nxm,nym,z0)
      endif

c --- Recover from zero u*, L provided during CALM conditions by
c --- assuming no flow (u*=0.0), and virtually no shear layer
c --- (M-O length small).
      if(ustr.LE.0.0) then
         ustr=0.0
         xmon=1.
         if(kst.LE.4) xmon=-1.
      endif

c --- Compute w* from u*,L,zmix
      wstr=0.
      if(xmon.LT.0.) then
         wstr=ustr*(-zmix/(vonk*xmon))**0.33333
      endif

c --- Get potential temperature gradient for stable conditions
      if(dthdz.LE.0.0) then
c ---    Use default potential temperature gradients from control file
         ptgdf(1)=ptg0(1)
         ptgdf(2)=ptg0(2)
      else
         ptgdf(1)=dthdz
         ptgdf(2)=ptgdf(1)
      endif

c --- Set the U, V wind component factors
      rad=fvec*.0174533
      ufac=sin(rad)
      vfac=cos(rad)

c --- Get power law exponent
      if(plfield.EQ.' ') then
c ---    Set power law value for current stability class
         if(kst.GE.7) then
            plexp=plx0(6)
         else
            plexp=plx0(kst)
         endif
      else
         read(plfield,'(bn,f5.0)') plexp
      endif

c --- Get short-wave radiation
      if(swf